#/bin/sh

# constants
SUCCESS=0
USAGE_ERROR=1
UNKNOWN_ERROR=2
KDC_SRV_ERROR=3
KDC_REALM_ERROR=4
KDC_TIME_DIFF_ERROR=5
AD_JOIN_ERROR=6
NTD_JOIN_ERROR=7

# utility 
SED=/bin/sed.rh
UPPERCASE=/usr/bin/uppercase
LOWERCASE=/usr/bin/lowercase
GETKDC=/usr/bin/getKDC
KINIT=/usr/bin/kinit
GREP=/bin/grep.rh
AWK=/bin/awk
SETCFG=/sbin/setcfg
NET=/usr/local/samba/bin/net
WBINFO=/usr/bin/wbinfo

# config file
KRB5_TMPL=/etc/krb5_tmpl.conf
KRB5_CONF=/mnt/config/krb5.conf
SMB_CONF=/etc/config/smb.conf

# functions
backup_conf_file() {
#	echo "enter backup_conf_file"
	SMB_TMP=`mktemp $SMB_CONF.XXXXXX`
	if [ -f $KRB5_CONF ]; then
		KRB5_TMP=`mktemp $KRB5_CONF.XXXXXX` 
		cp -af $KRB5_CONF $KRB5_TMP
	fi
	cp -af $SMB_CONF $SMB_TMP
}

restore_conf_file() {
#	echo "enter restore_conf_file"
	[ ! -f "$KRB5_TMP" ] || mv $KRB5_TMP $KRB5_CONF
	mv $SMB_TMP $SMB_CONF

}

clean_backup_file() {
#	echo "enter clean_backup_file"
	[ ! -f "$KRB5_TMP" ] || rm -f $KRB5_TMP
	rm -f $SMB_TMP
}

add_printer_admin_main(){
	printers_support=`/sbin/getcfg Printers Support`
        printers_enable=`/sbin/getcfg Printers Enable`
        if [ "x${printers_enable}" = "xTRUE" ]; then
		echo $printers_support > /tmp/log
		echo $printers_enable >> /tmp/log
        	add_printer_admin
                add_printer_admin
                /etc/init.d/smb.sh restart > /dev/null
        fi
}
add_printer_admin(){
	user=""
        for x in `wbinfo -g | grep "Domain Users"`; do
                if [ x"$x" != x"Users" ]; then
                        user=$user"@\""$x\ Users\",
                fi
        done
        user=$user@everyone,guest
        /sbin/setcfg Printers "printer admin" "$user" -f $LOCAL_SMB_CONF -c
        return
}

clean_smb_conf() {
	LOCAL_SMB_CONF=$1
	$SETCFG global 'character set' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'name resolve order' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'realm' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'password server' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'pam password change' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'winbind separator' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'idmap uid' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'idmap gid' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'winbind enum users' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'winbind enum groups' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'winbind cache time' -f $LOCAL_SMB_CONF -e
	$SETCFG global 'obey pam restrictions' -f $LOCAL_SMB_CONF -e
#	Ricky added 2005/4/15
	$SETCFG Printers 'printer admin' -f $LOCAL_SMB_CONF -e
}

alone_set_smb_conf() {
	LOCAL_SMB_CONF=$1
	WG_NAME=$2
	$SETCFG global workgroup $WG_NAME -f $LOCAL_SMB_CONF
	$SETCFG global security USER -f $LOCAL_SMB_CONF
	$SETCFG System Workgroup $WG_NAME
}

join_ntd() {
	LOCAL_SMB_CONF=$1
	domain_name=`${LOWERCASE} $2`
	wg_name=`${UPPERCASE} ${domain_name}`
	user_name=$3
	passwd=$4

	$SETCFG global 'security' DOMAIN -f $LOCAL_SMB_CONF
	$SETCFG global 'workgroup' $wg_name -f $LOCAL_SMB_CONF
	$SETCFG global 'realm' $domain_name -f $LOCAL_SMB_CONF
	$SETCFG global 'password server' '*' -f $LOCAL_SMB_CONF
	$SETCFG global 'pam password change' yes -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind separator' '+' -f $LOCAL_SMB_CONF
	$SETCFG global 'idmap uid' '30001-60000' -f $LOCAL_SMB_CONF
	$SETCFG global 'idmap gid' '30001-60000' -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind enum users' yes -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind enum groups' yes -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind cache time' '300' -f $LOCAL_SMB_CONF
	$SETCFG global 'obey pam restrictions' yes -f $LOCAL_SMB_CONF
	$SETCFG System Workgroup $wg_name

	${NET} rpc join -U $user_name%$passwd -s $SMB_CONF > /dev/null 2>&1
	if [ "$?" != "0" ]; then 
		return 2
	fi
	return 0
}


join_ad() {
	LOCAL_SMB_CONF=$1
	domain_name=`${LOWERCASE} $2`
	wg_name=`${UPPERCASE} ${domain_name} | ${AWK} -F. '{print $1}'`
	user_name=$3
	passwd=$4

	${GETKDC} ${lc_name} > /dev/null
	if [ "$?" != "0" ]; then
		echo "get KDC failed!"
		return 1
	fi
	kdc=`${GETKDC} ${lc_name}`
	
	$SETCFG global 'security' ADS -f $LOCAL_SMB_CONF
	$SETCFG global 'workgroup' $wg_name -f $LOCAL_SMB_CONF
	$SETCFG global 'realm' $domain_name -f $LOCAL_SMB_CONF
	$SETCFG global 'password server' $kdc -f $LOCAL_SMB_CONF
	$SETCFG global 'pam password change' yes -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind separator' '+' -f $LOCAL_SMB_CONF
	$SETCFG global 'idmap uid' '30001-60000' -f $LOCAL_SMB_CONF
	$SETCFG global 'idmap gid' '30001-60000' -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind enum users' yes -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind enum groups' yes -f $LOCAL_SMB_CONF
	$SETCFG global 'winbind cache time' '300' -f $LOCAL_SMB_CONF
	$SETCFG global 'obey pam restrictions' yes -f $LOCAL_SMB_CONF
	$SETCFG System Workgroup $wg_name

	${NET} ads join -U $user_name%$passwd -s $SMB_CONF > /dev/null 2>&1
	if [ "$?" != "0" ]; then 
		return 2
	fi
	return 0
}

setup_krb5() {
	lc_name=`${LOWERCASE} $1`
	uc_name=`${UPPERCASE} ${lc_name}`
	user_name=$2
	passwd=$3

	${GETKDC} ${lc_name} > /dev/null
	if [ "$?" != "0" ]; then
		echo "get KDC failed!"
		return 1
	fi
	kdc=`${GETKDC} ${lc_name}`

	[ ! -f ${KRB5_CONF} ] || rm -f ${KRB5_CONF}
	${SED} "s/##QNAP_REALM##/${uc_name}/g" ${KRB5_TMPL} | ${SED} "s/##QNAP_DOMAIN##/${lc_name}/g" | ${SED} "s/##QNAP_KDC##/${kdc}/g" > ${KRB5_CONF}

	echo "${passwd}" | ${KINIT} ${user_name}@${uc_name} >/dev/null 2>&1
	if [ "$?" != "0" ]; then 
		tmp=`echo "${passwd}" | ${KINIT} ${user_name}@${uc_name} 2>&1 1>/dev/null` 
		clk=`echo ${tmp} | ${GREP} -qc "Clock skew too great"`
		if [ "${clk}" = "0" ]; then 
			echo "kinit failed: can't find KDC realm!"
			return 2
		else
			echo "kinit failed: too much time difference!"
			return 3
		fi
	fi
	return 0
}

#import_remote_accounts()
#{
#	echo "import remote accounts!"
#	# so far, we only import remote users
#	$WBINFO --import-users >/dev/null 2>&1 &
#}

#clean_imported_accounts()
#{
#	echo "kill imported remote accounts!"
#	# so far, we only import remote users
#	$WBINFO --kill-remote-users >/dev/null 2>&1 &
#}

#set_sync_account_schedule()
#{
#	echo "setting schedule to synchronize remote accounts"
#	# so far, only sync remote users
#	clear_sync_account_schedule
#	echo "0 6 * * * root /usr/bin/sync_remote_accounts.sh user>/dev/null 2>&1" >> /etc/crontab
#}

#clear_sync_account_schedule()
#{
#	cp /etc/crontab /tmp/crontab
#	${SED} -e '/sync_remote_accounts/d' /tmp/crontab > /etc/crontab
#	rm /tmp/crontab -f
#}

# main program 

auth_user=$3
auth_pwd=$4
case "$1" in
	"ADM") 		#AD member
		[ "$#" = "4" ] || ( echo "USAGE: $0 $1 AD_DOMAIN ADM_ACCOUNT ADM_PASSWD!"; exit $USAGE_ERROR )
		/etc/init.d/smb.sh stop > /dev/null
		backup_conf_file
		setup_krb5 $2 $3 $4 > /dev/null
		case "$?" in
			"0")
				RETVAL=$SUCCESS
				;;
			"1")
				RETVAL=$KDC_SRV_ERROR
				;;
			"2")
				RETVAL=$KDC_REALM_ERROR
				;;
			"3")
				RETVAL=$KDC_TIME_DIFF_ERROR
				;;
			*)
				RETVAL=$KNOWN_ERROR
		esac
		if [ $RETVAL -ne $SUCCESS ]; then
			restore_conf_file
			/etc/init.d/smb.sh start > /dev/null
			exit $RETVAL
		fi
		clean_smb_conf $SMB_CONF	
		join_ad $SMB_CONF $2 $3 $4
		if [ "$?" = "0" ]; then 
			clean_backup_file
			RETVAL=$SUCCESS
		else
			restore_conf_file
			RETVAL=$AD_JOIN_ERROR
		fi
		$SETCFG "Samba" "User" "$auth_user"
		$SETCFG "Samba" "Password" "$auth_pwd"
		/etc/init.d/smb.sh start > /dev/null
		sleep 3
		add_printer_admin_main
#		import_remote_accounts
#		set_sync_account_schedule
		exit $RETVAL
		;;
	"NTM")		#NT member
		[ "$#" = "4" ] || ( echo "USAGE: $0 $1 NT_DOMAIN ADM_ACCOUNT ADM_PASSWD!"; exit $USAGE_ERROR )
		/etc/init.d/smb.sh stop > /dev/null
		backup_conf_file
		clean_smb_conf $SMB_CONF	
		join_ntd $SMB_CONF $2 $3 $4
		if [ "$?" = "0" ]; then 
			clean_backup_file
			[ ! -f ${KRB5_CONF} ] || rm -f ${KRB5_CONF}
			RETVAL=$SUCCESS
		else
			restore_conf_file
			RETVAL=$NTD_JOIN_ERROR
		fi
		$SETCFG "Samba" "User" "$auth_user"
		$SETCFG "Samba" "Password" "$auth_pwd"
		/etc/init.d/smb.sh start > /dev/null
		sleep 3
                add_printer_admin_main

#		import_remote_accounts
#		set_sync_account_schedule
		exit $RETVAL
		;;
#	"PDC")		#NT PDC
#		;;
#	"BDC")		#NT BDC
#		;;
	"ALONE")	#Stand Alone Server
		[ "$#" = "2" ] || ( echo "USAGE: $0 $1 WORKGROUP_NAME!"; exit $USAGE_ERROR )
		/etc/init.d/smb.sh stop > /dev/null
		backup_conf_file
		clean_smb_conf $SMB_CONF	
		alone_set_smb_conf $SMB_CONF $2
		add_printer_admin_main
#		clean_imported_accounts
		/etc/init.d/smb.sh start > /dev/null
		clean_backup_file
#		clear_sync_account_schedule
		[ ! -f ${KRB5_CONF} ] || rm -f ${KRB5_CONF}
		;;
	*)
		echo "USAGE: $0 [ADM|NTM|ALONE] [arguments]!"
		exit $USAGE_ERROR
		;;
esac
