#!/bin/sh

[ -f /usr/sbin/lpd ] || exit 0

model=`/sbin/getcfg "System" "Model" -u`
if [ "x${model}" = "xNAS-3000" -o "x${model}" = "xNAS-4010" -o "x${model}" = "xPNS-30" -o "x${model}" = "xNAS-2100" ]
then
	/sbin/setcfg "Printers" "Support" TRUE
fi

RETVAL=0

case "$1" in
  start)
        # Start daemons.
        echo -n "Starting lpd: "
	if [ `/sbin/getcfg printers Support -u -d FALSE` = FALSE ]
	then
		echo " not support printer function."
		exit 0
	fi

	if [ `/sbin/getcfg printers Enable -u -d FALSE` = FALSE ]
	then
		echo " disable."
		exit 0
	fi

        #/usr/sbin/lpd
	/sbin/daemon_mgr lpd start "/usr/sbin/lpd"
	RETVAL=$?
        echo
        [ $RETVAL -eq 0 ] && touch /mnt/HDB_ROOT
        ;;
  stop)
        # Stop daemons.
        echo -n "Shutting down lpd: "
	# /bin/kill -9 `/sbin/pidof lpd`
	/sbin/daemon_mgr lpd stop "/usr/sbin/lpd"
	RETVAL=$?
        echo
        [ $RETVAL -eq 0 ] && rm -f /mnt/HDB_ROOT/*
        ;;
  status)
	status lpd
	RETVAL=$?
	;;
  restart|reload)
	$0 stop
	$0 start
	RETVAL=$?
	;;
  *)
        echo "Usage: printer.sh {start|stop|restart|reload|status}"
        exit 1
esac

exit $RETVAL
