#include <stdio.h>
#include <string.h>

/* include NAS lib */
#include <cgi.h>
#include <cfg_nic.h>
#include <config.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>
#include <cfg_qweb.h>

/* include local file */
#include "network.h"
#include "nic_web.h"

int web_replace(FILE *fptr, char *name, void *arg)
{
        if (!strcmp(name, "ONLOAD"))
        {
        }
        else
        if (!strcmp(name, "bWEB"))
        {
                if (Is_Qweb_Enabled()!=0)
                        fprintf(fptr, "checked");
        }
        else
        if (!strcmp(name, "IP"))
        {
		        NIC_INFO	nic_info;
		        NIC_Get_Info(&nic_info, NIC_LAN01);
		        fprintf(fptr, "%s", nic_info.ipaddr);
        }
        else
        if (!strcmp(name, "QWEBPORT"))
        {
		        char buf[BUF_SIZE];
		        Get_Profile_String("QWEB", "Port", "80",buf, BUF_SIZE);
		        fprintf(fptr, "%s", buf);
        }
        else
        if (!strcmp(name, "ERR_TITLE"))
				{
					fprintf(fptr, "NIC_WEB_STR04");
				}
        else
        if (!strcmp(name, "ERR_MSG"))
				{
					fprintf(fptr, "QWEB_ERR_MSG01");
				}				
        else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int show_web_header ()
{
	HEADER_ITEM     header;
	int	nic_count;

	header.back[0]=0x0;
	header.home[0]=0x0;
	header.logout[0]=0x0;

	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_web_main");
	else
		CGI_Get_Help(header.help, "network_web_main.html");

	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", web_replace, NULL);
	nic_count=NIC_Count_Interface();
	CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network.def", 8);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", web_replace, NULL);
	return NIC_SUCCESS;
}

int show_web_tail ()
{
	return CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", web_replace, NULL);
}
//  add until here

int do_web_main()
{
        CGI_Output_Html1(NIC_HEADER_HTML, "$", web_replace, NULL);
        show_web_header ();
        CGI_Output_Html1(NIC_WEB_MAIN_HTML, "$", web_replace, NULL);
        show_web_tail ();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", web_replace, NULL);
        return NIC_SUCCESS;
}

int do_web_main_submit(INPUT *input)
{
        INPUT   *tmp;
				char buf[BUF_SIZE]; //KenChen 20060327
				int port,ori_port,val;

		Get_Profile_String("System", "Internal Model", "--",buf, BUF_SIZE); 
		ori_port=Get_Profile_Integer("QWEB", "Port", 80);
		
				if ((tmp=CGI_Find_Parameter(input, "qweb_port"))!=NULL){
					if ((port = atoi(tmp->val)) <= 0)	port=ori_port;
					if (port<1 || port>65535 || port==6000) port=ori_port;
				}	
		
        if ((tmp=CGI_Find_Parameter(input, "bWEB"))!=NULL){
        	if (strcasecmp(buf, "TS-201")==0){
        		if(Check_Share_Folder("/share/Qweb")<0){
        			CGI_Output_Html1(NIC_WEB_HEADER_HTML, "$", web_replace, NULL);
        			CGI_Output_Html1(NIC_WEB_ERROR_HTML, "$", web_replace, NULL);
        			return NIC_SUCCESS;
        		}
          	else{
              if (port==ori_port)
              	Enable_Qweb(1);
              else
              	Restart_Qweb(1,port);
            }
        	}
          else{
              if (port==ori_port)
              	Enable_Qweb(1);
              else
              	Restart_Qweb(1,port);
					}
        }			
        else{
           if (port==ori_port)
             Enable_Qweb(0);
           else
             Restart_Qweb(0,port);
        }
        
        do_web_main();
        return NIC_SUCCESS;
}


