#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

/* include NAS lib */
#include <Util.h>
#include <cgi.h>
#include <cfg_nic.h>
#include <cfg_system.h>
#include <cfg_dhcp.h>
#include <cfg_fw.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>

/* include local file */
#include "network.h"
#include "nic_wan.h"

int g_page = 0;  // 0 -->  submit
		 // 1 -->  setting
		 // 2 -->  pppoe
		 // 3 -->  pptp
		 // 4 -->  dhcp

int get_page (INPUT * input)
{
	INPUT * p = NULL;
	int ret = 0;
	if ((p = CGI_Find_Parameter (input, "page")) != NULL)
		ret = atoi (p->val);
	return ret;
}

int wan_replace(FILE *fptr, char *name, void *arg)
{
        NIC_NAS_INFO    *nic_nas_info;
        char            buf[256], *ptr;
        int             ret;
	NIC_TCPIP	tcpip;
	PPPOE		pppoe;
	PPTP		pptp;

	if (!strcmp(name, "ONLOAD"))
	{
		fprintf(fptr, "Init_Wan()");
	}
	else
	if (!strcmp(name, "VAR_WAN_USAGE"))
	{
		nic_nas_info=(NIC_NAS_INFO *)arg;
		if (nic_nas_info->usage==NIC_USE_PPPOE)
			fprintf(fptr, "PPPOE");
		else
		if (nic_nas_info->usage==NIC_USE_DHCP)
			fprintf(fptr, "DHCP");
		else
		if (nic_nas_info->usage==NIC_USE_STATIC)
			fprintf(fptr, "STATIC");
		else
		if (nic_nas_info->usage==NIC_USE_PPTP)
			fprintf(fptr, "PPTP");
		else
			fprintf(fptr, "DHCP");
	}
	else
	if (!strcmp(name, "VAR_PPPOE_ALIVE"))
	{
		NIC_Get_PPPOE(&pppoe);
		if (pppoe.keep_alive==1)
			fprintf(fptr, "ALIVE");
		else
		if (pppoe.keep_alive==0)
			fprintf(fptr, "HANGUP");
	}
	else
	if (    !strcmp(name, "WAN_IP1") || !strcmp(name, "WAN_IP2") || !strcmp(name, "WAN_IP3") ||
		!strcmp(name, "WAN_IP4"))
	{
		char	*pip;

		nic_nas_info=(NIC_NAS_INFO *)arg;
		ptr=name+(strlen(name)-1);
		pip=parser_ipaddr(buf, nic_nas_info->ifconfig.ipaddr, (int)(*ptr-'1'));
		if (pip==NULL)
			fprintf(fptr, "0");
		else
			fprintf(fptr, "%d", atoi(pip));
//		fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.ipaddr, (int)(*ptr-'1')));
        }
        else
        if (    !strcmp(name, "WAN_MASK1") || !strcmp(name, "WAN_MASK2") || !strcmp(name, "WAN_MASK3") ||
                !strcmp(name, "WAN_MASK4"))
        {
		char	*pip;

                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
		pip=parser_ipaddr(buf, nic_nas_info->ifconfig.netmask, (int)(*ptr-'1'));
                if (pip==NULL)
                        fprintf(fptr, "0");
                else
                        fprintf(fptr, "%d", atoi(pip));
//                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.netmask, (int)(*ptr-'1')));
        }
        else
        if (    !strcmp(name, "DNS_IP1") || !strcmp(name, "DNS_IP2") || !strcmp(name, "DNS_IP3") ||
                !strcmp(name, "DNS_IP4"))
        {
		char	*pip;

		NIC_Get_Tcpip(&tcpip);
                ptr=name+(strlen(name)-1);
		pip=parser_ipaddr(buf, tcpip.dns, (int)(*ptr-'1'));
                if (pip==NULL)
                        fprintf(fptr, "0");
                else
                        fprintf(fptr, "%d", atoi(pip));
//                fprintf(fptr, "%s", parser_ipaddr(buf, tcpip.dns, (int)(*ptr-'1')));
        }
        else
        if (    !strcmp(name, "WAN_GW1") || !strcmp(name, "WAN_GW2") || !strcmp(name, "WAN_GW3") ||
                !strcmp(name, "WAN_GW4"))
        {
		char	*pip;

                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
		pip=parser_ipaddr(buf, nic_nas_info->ifconfig.gateway, (int)(*ptr-'1'));
                if (pip==NULL)
                        fprintf(fptr, "0");
                else
                        fprintf(fptr, "%d", atoi(pip));
//                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.gateway, (int)(*ptr-'1')));
        }
        else
        if (	!strcmp(name, "radio_dhcp") || !strcmp(name, "radio_pppoe") ||
		!strcmp(name, "radio_static") || !strcmp(name, "radio_pptp"))
        {
                nic_nas_info=(NIC_NAS_INFO *)arg;
                if (nic_nas_info->usage==NIC_USE_DHCP && !strcmp(name, "radio_dhcp"))
                        fprintf(fptr, "checked");
                else
                if (nic_nas_info->usage==NIC_USE_STATIC && !strcmp(name, "radio_static"))
                        fprintf(fptr, "checked");
                else
                if (nic_nas_info->usage==NIC_USE_PPPOE && !strcmp(name, "radio_pppoe"))
                        fprintf(fptr, "checked");
		else
		if (nic_nas_info->usage==NIC_USE_PPTP && !strcmp(name, "radio_pptp"))
			fprintf(fptr, "checked");
        }
        else
        if (!strcmp(name, "bWANACCESS"))
        {
                ret=Get_Web_Access(SYSTEM_WAN_ACCESS);
                if (ret==1)
                        fprintf(fptr, "checked");
        }
        else
        if (!strcmp(name, "PORTNUM"))
        {
                ret=Get_Web_Access_Port();
                fprintf(fptr, "%d", ret);
        }
        else
        if (!strcmp (name, "bDNS"))
        {
        	NIC_Get_Tcpip(&tcpip);
        	if (strcmp ("0.0.0.0", tcpip.dns))
        		fprintf (fptr, "checked");
        }
	else
	if (!strcmp(name, "bICMP"))
	{
		if (FW_Is_ICMP_Request()!=FW_SUCCESS)
			fprintf(fptr, "checked");
	}
	else
	if (!strcmp(name, "PPPOE_USER"))
	{
		NIC_Get_PPPOE(&pppoe);
		fprintf(fptr, "%s", pppoe.username);
	}
	else
	if (!strcmp(name, "PPPOE_PWD"))
	{
		NIC_Get_PPPOE(&pppoe);
		fprintf(fptr, "%s", pppoe.passwd);
	}
	else  //  Tiger
	if (!strcmp(name, "bPPPOEDHCP"))
	{
		NIC_Get_PPPOE(&pppoe);
		if (pppoe.fail_use_dhcp)
			fprintf(fptr, "ON");
		else
			fprintf (fptr, "OFF");

	}
	else  //  Tiger
	if (!strcmp(name, "bPPTPDHCP"))
	{
		NIC_Get_PPTP(&pptp);
		if (pptp.fail_use_dhcp)
			fprintf(fptr, "ON");
		else
			fprintf (fptr, "OFF");
	}
	else
	if (!strcmp(name, "bBOOT"))
	{
		NIC_Get_PPPOE(&pppoe);
		if (pppoe.connect_on_boot)
			fprintf(fptr, "ON");
		else
			fprintf (fptr, "OFF");  //  Tiger
	}
	else  //  Tiger
	if (!strcmp (name, "PPPOE_ALIVE"))
	{
		NIC_Get_PPPOE(&pppoe);
		if (pppoe.keep_alive == 1)
			fprintf (fptr, "PPPOE_ALIVE");
		else
			fprintf (fptr, "PPPOE_HANGUP");
	}
	/*else
	if (!strcmp(name, "radio_pppoe_alive") || !strcmp(name, "radio_pppoe_hangup"))
	{
		NIC_Get_PPPOE(&pppoe);
		if (pppoe.keep_alive==1 && !strcmp(name, "radio_pppoe_alive"))
			fprintf(fptr, "checked");
		else
		if (pppoe.keep_alive==0 && !strcmp(name, "radio_pppoe_hangup"))
			fprintf(fptr, "checked");
	}*/
	else
	if (!strcmp(name, "PPPOE_IDLE"))
	{
		NIC_Get_PPPOE(&pppoe);
		fprintf(fptr, "%d", pppoe.idle);
	}
	else
        if (    !strcmp(name, "PPTP_IP1") || !strcmp(name, "PPTP_IP2") || !strcmp(name, "PPTP_IP3") ||
                !strcmp(name, "PPTP_IP4"))
        {
		char	*pip;

		NIC_Get_PPTP(&pptp);
                ptr=name+(strlen(name)-1);
                pip=parser_ipaddr(buf, pptp.serveraddr, (int)(*ptr-'1'));
                if (pip==NULL)
                        fprintf(fptr, "0");
                else
                        fprintf(fptr, "%d", atoi(pip));
//                fprintf(fptr, "%s", parser_ipaddr(buf, pptp.serveraddr, (int)(*ptr-'1')));
        }
        else
        if (!strcmp(name, "PPTP_USER"))
        {
                NIC_Get_PPTP(&pptp);
                fprintf(fptr, "%s", pptp.username);
        }
        else
        if (!strcmp(name, "PPTP_PWD"))
        {
                NIC_Get_PPTP(&pptp);
                fprintf(fptr, "%s", pptp.passwd);
        }
        else
        if (!strcmp (name, "select_function"))
        {
      		CGI_Output_Html1(NIC_WAN_SETTING_HTML, "$", NULL, NULL);
       		CGI_Output_Html1(NIC_WAN_PPPOE1_HTML, "$", NULL, NULL);
       		CGI_Output_Html1(NIC_WAN_PPTP1_HTML, "$", NULL, NULL);
       		CGI_Output_Html1(NIC_WAN_DHCP1_HTML, "$", NULL, NULL);
       		//CGI_Output_Html1(NIC_WAN_STATICIP1_HTML, "$", NULL, NULL);
       		//CGI_Output_Html1(NIC_WAN_OTHER1_HTML, "$", NULL, NULL);
        }
        else
        if (	!strcmp (name, "1MAC_ADD") || !strcmp (name, "2MAC_ADD") || !strcmp (name, "3MAC_ADD") ||
        	!strcmp (name, "4MAC_ADD") || !strcmp (name, "5MAC_ADD") || !strcmp (name, "6MAC_ADD"))
        {
        	int single_mac;
        	char mac_addr[32];

        	NIC_Get_VHWADDR (mac_addr, sizeof (mac_addr), NIC_WAN);
        	single_mac = NIC_Parse_HWADDR (mac_addr, atoi (name));

        	fprintf (fptr, "%02X", single_mac);
        }
        else
        if (!strcmp (name, "use_specify_mac"))
        {
        	if (NIC_Is_VHWADDR_Enabled (NIC_WAN))
        		fprintf (fptr, "ON");
        	else
        		fprintf (fptr, "OFF");
        }
        else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int get_def_name(char *filename)
{
	if (NIC_Count_Interface()==2)
	{
		if (Is_Support_Printer())
		{
			if (Is_Support_DNS())
				strcpy(filename, DEF_NETWORK2);
			else
				strcpy(filename, DEF_NETWORK2_NODNS);
		}
		else
		{
			if (Is_Support_DNS())
				strcpy(filename, DEF_NETWORK2_NOPRN);
			else
				strcpy(filename, DEF_NETWORK2_NOPRNDNS);
		}
	}
	else
	if (NIC_Count_Interface()==1)
	{
		if (Is_Support_Printer())
		{
			if (Is_Support_DNS())
				strcpy(filename, DEF_NETWORK1);
			else
				strcpy(filename, DEF_NETWORK1_NODNS);
		}
		else
		{
			if (Is_Support_DNS())
				strcpy(filename, DEF_NETWORK1_NOPRN);
			else
				strcpy(filename, DEF_NETWORK1_NOPRNDNS);
		}
	}
	return NIC_SUCCESS;
}

int show_wan_header()
{
	char		buf[256];
	HEADER_ITEM	header;

        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_wset_main");
	else
		CGI_Get_Help(header.help, "network_wset_main.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", wan_replace, NULL);
	get_def_name(buf);
	CGI_Show_Menu_V3_2(buf, 1);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", wan_replace, NULL);
        return NIC_SUCCESS;
}

int show_wan_tail()
{
        return CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", wan_replace, NULL);
}
//  Tiger
int select_replace(FILE *fptr, char *name, void *arg)
{
        INPUT * input = (INPUT *)arg, * p = NULL;
        NIC_NAS_INFO    nic_nas_info;
        NIC_INFO	nic_info;
        int status;

	if (!strcmp(name, "ONLOAD"))
	{
		fprintf(fptr, "Init_Wan()");
	}
	else if (!strcmp(name, "VAR_WAN_USAGE"))
	{
        	if ((p = CGI_Find_Parameter (input, "WAN_USAGE")) != NULL)
        		fprintf (fptr, "%s", p->val);
	}
	else if (!strcmp(name, "WAN_IP1"))
	{
		if ((p = CGI_Find_Parameter (input, "WAN_IP1")) != NULL)
        		fprintf (fptr, "%s", p->val);
	}
	else if (!strcmp(name, "WAN_IP2"))
	{
		if ((p = CGI_Find_Parameter (input, "WAN_IP2")) != NULL)
        		fprintf (fptr, "%s", p->val);
	}
	else if (!strcmp(name, "WAN_IP3"))
	{
		if ((p = CGI_Find_Parameter (input, "WAN_IP3")) != NULL)
        		fprintf (fptr, "%s", p->val);
	}
        else if (!strcmp(name, "WAN_IP4"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_IP4")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_MASK1"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_MASK1")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_MASK2"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_MASK2")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_MASK3"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_MASK3")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_MASK4"))
        {
                if ((p = CGI_Find_Parameter (input, "WAN_MASK4")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "DNS_IP1"))
        {
        	if ((p = CGI_Find_Parameter (input, "DNS_IP1")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "DNS_IP2"))
        {
        	if ((p = CGI_Find_Parameter (input, "DNS_IP2")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "DNS_IP3"))
        {
        	if ((p = CGI_Find_Parameter (input, "DNS_IP3")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "DNS_IP4"))
        {
        	if ((p = CGI_Find_Parameter (input, "DNS_IP4")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_GW1"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_GW1")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_GW2"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_GW2")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_GW3"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_GW3")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "WAN_GW4"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_GW4")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp (name, "WAN_USAGE"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_USAGE")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "radio_dhcp"))
        {
       		if ((p = CGI_Find_Parameter (input, "WAN_USAGE")) != NULL)
                {
       	        	if (!strcmp (p->val, "DHCP"))
               			fprintf(fptr, "checked");
               	}
        }
        else if (!strcmp(name, "radio_pppoe"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_USAGE")) != NULL)
                {
                	if (!strcmp (p->val, "PPPOE"))
                		fprintf(fptr, "checked");
                }
        }
        else if (!strcmp(name, "radio_static"))
        {
        	if ((p = CGI_Find_Parameter (input, "WAN_USAGE")) != NULL)
                {
                	if (!strcmp (p->val, "STATIC"))
                		fprintf(fptr, "checked");
                }
        }
        else if (!strcmp(name, "radio_pptp"))
        {
                if ((p = CGI_Find_Parameter (input, "WAN_USAGE")) != NULL)
                {
                	if (!strcmp (p->val, "PPTP"))
                		fprintf(fptr, "checked");
                }
        }
        else if (!strcmp(name, "bWANACCESS"))
        {
                if (g_page != 1)
                {
                	if ((p = CGI_Find_Parameter (input, "bWANACCESS")) != NULL)
                		fprintf (fptr, "%s", p->val);
                	else
                		fprintf (fptr, "OFF");
                }
                else
                {
	                if ((p = CGI_Find_Parameter (input, "bWANACCESS")) != NULL)
                		if (!strcmp (p->val, "ON"))
                			fprintf(fptr, "checked");
	        }
        }
        else if (!strcmp(name, "PORTNUM"))
        {
                if ((p = CGI_Find_Parameter (input, "PORTNUM")) != NULL)
                	fprintf(fptr, "%s", p->val);
        }
        else if (!strcmp (name, "bDNS"))
        {
        	if (g_page != 1)
        	{
	        	if ((p = CGI_Find_Parameter (input, "bDNS")) != NULL)
        			fprintf (fptr, "%s", p->val);
        		else
        			fprintf (fptr, "OFF");
        	}
        	else
        	{
        		if ((p = CGI_Find_Parameter (input, "bDNS")) != NULL)
        			if (!strcmp (p->val, "ON"))
					fprintf(fptr, "checked");
        	}
        }
	else if (!strcmp(name, "bICMP"))
	{
		if (g_page != 1)
		{
			if ((p = CGI_Find_Parameter (input, "bICMP")) != NULL)
				fprintf (fptr, "%s", p->val);
			else
				fprintf(fptr, "ON");
		}
		else
		{
			if ((p = CGI_Find_Parameter (input, "bICMP")) != NULL)
			{
				if (!strcmp (p->val, "OFF"))
					fprintf(fptr, "checked");
			}
		}
	}
	else if (!strcmp(name, "PPPOE_USER"))
	{
		if ((p = CGI_Find_Parameter (input, "PPPOE_USER")) != NULL)
			fprintf(fptr, "%s", p->val);
	}
	else if (!strcmp(name, "PPPOE_PWD"))
	{
		if ((p = CGI_Find_Parameter (input, "PPPOE_PWD")) != NULL)
			fprintf(fptr, "%s", p->val);
	}
	else if (!strcmp(name, "bBOOT"))
	{
		if (g_page != 2)
		{
			if ((p = CGI_Find_Parameter (input, "bBOOT")) != NULL)
				fprintf (fptr, "%s", p->val);
			else
				fprintf (fptr, "OFF");
		}
		else
		{
			if ((p = CGI_Find_Parameter (input, "bBOOT")) != NULL)
			{
				if (!strcmp (p->val, "ON"))
					fprintf(fptr, "checked");
			}
		}
	}
	else if (!strcmp(name, "bPPPOEDHCP"))
	{
		if (g_page != 2)
		{
			if ((p = CGI_Find_Parameter (input, "bPPPOEDHCP")) != NULL)
				fprintf (fptr, "%s", p->val);
			else
				fprintf(fptr, "OFF");
		}
		else
		{
			if ((p = CGI_Find_Parameter (input, "bPPPOEDHCP")) != NULL)
			{
				if (!strcmp (p->val, "ON"))
					fprintf(fptr, "checked");
			}
		}
	}
	else if (!strcmp(name, "PPPOE_ALIVE"))
	{
		if ((p = CGI_Find_Parameter (input, "PPPOE_ALIVE")) != NULL)
			fprintf (fptr, "%s", p->val);
	}
	else if (!strcmp(name, "radio_pppoe_alive"))
	{
		if ((p = CGI_Find_Parameter (input, "PPPOE_ALIVE")) != NULL)
		{
			if (!strcmp (p->val, "PPPOE_ALIVE"))
				fprintf(fptr, "checked");
		}
	}
	else if (!strcmp(name, "radio_pppoe_hangup"))
	{
		if ((p = CGI_Find_Parameter (input, "PPPOE_ALIVE")) != NULL)
		{
			if (!strcmp (p->val, "PPPOE_HANGUP"))
				fprintf(fptr, "checked");
		}
	}

	else if (!strcmp(name, "bPPTPDHCP"))
	{
		if (g_page != 3)
		{
			if ((p = CGI_Find_Parameter (input, "bPPTPDHCP")) != NULL)
				fprintf (fptr, "%s", p->val);
			else
				fprintf(fptr, "OFF");
		}
		else
		{
			if ((p = CGI_Find_Parameter (input, "bPPTPDHCP")) != NULL)
			{
				if (!strcmp (p->val, "ON"))
					fprintf(fptr, "checked");
			}
		}
	}
	else if (!strcmp(name, "PPPOE_IDLE"))
	{
		if ((p = CGI_Find_Parameter (input, "PPPOE_IDLE")) != NULL)
			fprintf(fptr, "%s", p->val);
	}
	else if (!strcmp(name, "PPTP_IP1"))
        {
        	if ((p = CGI_Find_Parameter (input, "PPTP_IP1")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "PPTP_IP2"))
        {
        	if ((p = CGI_Find_Parameter (input, "PPTP_IP2")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "PPTP_IP3"))
        {
        	if ((p = CGI_Find_Parameter (input, "PPTP_IP3")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "PPTP_IP4"))
        {
        	if ((p = CGI_Find_Parameter (input, "PPTP_IP4")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "PPTP_USER"))
        {
        	if ((p = CGI_Find_Parameter (input, "PPTP_USER")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp(name, "PPTP_PWD"))
        {
        	if ((p = CGI_Find_Parameter (input, "PPTP_PWD")) != NULL)
        		fprintf (fptr, "%s", p->val);
        }
        else if (!strcmp (name, "select_function"))
        {
        	switch (g_page)
        	{
        	case 1:
        		CGI_Output_Html1(NIC_WAN_SETTING_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPPOE1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPTP1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_DHCP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_STATICIP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_OTHER1_HTML, "$", NULL, NULL);
        		break;
        	case 2:
        		CGI_Output_Html1(NIC_WAN_SETTING1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPPOE_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPTP1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_DHCP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_STATICIP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_OTHER1_HTML, "$", NULL, NULL);
        		break;
        	case 3:
        		CGI_Output_Html1(NIC_WAN_SETTING1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPPOE1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPTP_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_DHCP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_STATICIP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_OTHER1_HTML, "$", NULL, NULL);
        		break;
        	case 4:
        		CGI_Output_Html1(NIC_WAN_SETTING1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPPOE1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPTP1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_DHCP_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_STATICIP_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_OTHER1_HTML, "$", NULL, NULL);
        		break;
        	default:
        		CGI_Output_Html1(NIC_WAN_SETTING_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPPOE1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_PPTP1_HTML, "$", NULL, NULL);
        		CGI_Output_Html1(NIC_WAN_DHCP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_STATICIP1_HTML, "$", NULL, NULL);
        		//CGI_Output_Html1(NIC_WAN_OTHER1_HTML, "$", NULL, NULL);
        	}
        }
        else if (!strcmp (name, "pppoe_usage") || !strcmp (name, "pptp_usage") || !strcmp (name, "dhcp_usage"))
        {
        	int status;

        	NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
        	if (nic_nas_info.usage == NIC_USE_PPPOE)
        	{
        		if (!strcmp (name, "pppoe_usage"))
        		{
        			status=NIC_Get_PPPOE_Status();
	                        if (status==PPPOE_STATUS_CONNECT || status == PPPOE_STATUS_READY)
        	                        fprintf(fptr, "NIC_WAN_STR37");
                	        else if (status==PPPOE_STATUS_DISABLE)
                	        	fprintf(fptr, "NIC_WAN_STR38");
                	        else if (status==PPPOE_STATUS_CONNECTING)
                	        	fprintf(fptr, "NIC_WAN_STR36");
                	        else if (status==PPPOE_STATUS_DHCP)
                	        	fprintf(fptr, "NIC_WAN_STR39");
        		}
        		else if (!strcmp (name, "pptp_usage"))
        			fprintf(fptr, "NIC_WAN_STR40");
        		else if (!strcmp (name, "dhcp_usage"))
        			fprintf (fptr, "NIC_WAN_STR33");
        	}
        	else if (nic_nas_info.usage == NIC_USE_PPTP)
        	{
        		if (!strcmp (name, "pptp_usage"))
        		{

        			status=NIC_Get_PPTP_Status();
	                        if (status==PPTP_STATUS_CONNECT || status==PPTP_STATUS_READY)
        	                        fprintf(fptr, "NIC_WAN_STR42");
        	                else if (status==PPTP_STATUS_DISABLE)
        	                	fprintf(fptr, "NIC_WAN_STR43");
                	        else if (status==PPTP_STATUS_CONNECTING)
                	        	fprintf(fptr, "NIC_WAN_STR41");
                	        else if (status==PPTP_STATUS_DHCP)
                	        	fprintf(fptr, "NIC_WAN_STR44");
        		}
	        	else if (!strcmp (name, "pppoe_usage"))
        			fprintf(fptr, "NIC_WAN_STR35");
        		else if (!strcmp (name, "dhcp_usage"))
        			fprintf (fptr, "NIC_WAN_STR33");
        	}
        	else if (nic_nas_info.usage == NIC_USE_DHCP)
        	{
        		if (!strcmp (name, "dhcp_usage"))
        			fprintf (fptr, "NIC_WAN_STR26");
	        	else if (!strcmp (name, "pppoe_usage"))
        			fprintf(fptr, "NIC_WAN_STR35");
        		else if (!strcmp (name, "pptp_usage"))
        			fprintf(fptr, "NIC_WAN_STR40");
        	}
        	else
        	{
        		if (!strcmp (name, "pppoe_usage"))
        			fprintf(fptr, "NIC_WAN_STR35");
        		if (!strcmp (name, "pptp_usage"))
        			fprintf(fptr, "NIC_WAN_STR40");
        		if (!strcmp (name, "dhcp_usage"))
        			fprintf (fptr, "NIC_WAN_STR33");
        	}
        }
        else if (!strcmp (name, "pppoe_error"))
        {
        	NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
        	if (nic_nas_info.usage == NIC_USE_PPPOE)
        	{
       			status=NIC_Get_PPPOE_Status();
               	        if (status==PPPOE_STATUS_DISABLE || status==PPPOE_STATUS_CONNECTING || status==PPPOE_STATUS_DHCP)
               	        {
               	        	int error = NIC_Get_PPPOE_Latest_Error ();
               	        	char error_code[256];
               	        	switch (error)
               	        	{
               	        	case 10:
               	        		error = 9;
               	        		break;
               	        	case 11:
               	        		error = 10;
               	        		break;
               	        	case 12:
               	        		error = 11;
               	        		break;
               	        	case 16:
               	        		error = 12;
               	        		break;
               	        	case 19:
               	        		error = 13;
               	        		break;
               	        	default:
               	        		error = 14;
               	        		break;
               	        	}
               	        	sprintf (error_code, "<td>&nbsp</td><td class=\"st\"><script language=\"JavaScript\">document.write (NIC_WAN_STR45)</script></td><td class=\"st\" ><script language=\"JavaScript\">document.write (NIC_WAN_ALERT%02d)</script></td>", error);
               	        	fprintf (fptr, "%s", error_code);
               	        }
        	}
        }
        else if (!strcmp (name, "dhcp_ip") || !strcmp (name, "pppoe_ip") || !strcmp (name, "pptp_ip"))
        {
        	NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
        	NIC_Get_Info (&nic_info, NIC_WAN);
        	if (nic_nas_info.usage == NIC_USE_PPPOE)
        	{
        		if (!strcmp (name, "pppoe_ip"))
        		{
        			status=NIC_Get_PPPOE_Status();
        			if (status==PPPOE_STATUS_CONNECT || status==PPPOE_STATUS_READY || status==PPPOE_STATUS_DHCP)
        				fprintf (fptr, "%s", nic_info.ipaddr);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}

        	}
        	else if (nic_nas_info.usage == NIC_USE_PPTP)
        	{
        		if (!strcmp (name, "pptp_ip"))
        		{
        			status=NIC_Get_PPTP_Status();
        			if (status==PPTP_STATUS_CONNECT || status==PPTP_STATUS_READY || status==PPTP_STATUS_DHCP)
        				fprintf (fptr, "%s", nic_info.ipaddr);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}

        	}
        	else if (nic_nas_info.usage == NIC_USE_DHCP)
        	{
        		if (!strcmp (name, "dhcp_ip"))
        		{
        			if (strlen (nic_info.ipaddr) > 0)
        				fprintf (fptr, "%s", nic_info.ipaddr);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else
        		fprintf (fptr, "'+NIC_WAN_STR31+'");

        }
        else if (!strcmp (name, "dhcp_netmask") || !strcmp (name, "pppoe_netmask") || !strcmp (name, "pptp_netmask"))
        {
        	NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
       		NIC_Get_Info (&nic_info, NIC_WAN);
        	if (nic_nas_info.usage == NIC_USE_PPPOE)
        	{
        		if (!strcmp (name, "pppoe_netmask"))
        		{
        			status=NIC_Get_PPPOE_Status();
        			if (status==PPPOE_STATUS_CONNECT || status==PPPOE_STATUS_READY || status==PPPOE_STATUS_DHCP)
        				fprintf (fptr, "%s", nic_info.netmask);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else if (nic_nas_info.usage == NIC_USE_PPTP)
        	{
        		if (!strcmp (name, "pptp_netmask"))
        		{
        			status=NIC_Get_PPTP_Status();
        			if (status==PPTP_STATUS_CONNECT || status==PPTP_STATUS_READY || status==PPTP_STATUS_DHCP)
        				fprintf (fptr, "%s", nic_info.netmask);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else if (nic_nas_info.usage == NIC_USE_DHCP)
        	{
        		if (!strcmp (name, "dhcp_netmask"))
        		{
        			if (strlen (nic_info.netmask) > 0)
        				fprintf (fptr, "%s", nic_info.netmask);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else
        		fprintf (fptr, "'+NIC_WAN_STR31+'");
        }
        else if (!strcmp (name, "dhcp_gateway") || !strcmp (name, "pppoe_gateway") || !strcmp (name, "pptp_gateway"))
        {
        	NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
        	NIC_Get_Info (&nic_info, NIC_WAN);
        	if (nic_nas_info.usage == NIC_USE_PPPOE)
        	{
        		if (!strcmp (name, "pppoe_gateway"))
        		{
        			status=NIC_Get_PPPOE_Status();
        			if (status==PPPOE_STATUS_CONNECT || status==PPPOE_STATUS_READY || status==PPPOE_STATUS_DHCP)
        				fprintf (fptr, "%s", nic_info.gateway);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else if (nic_nas_info.usage == NIC_USE_PPTP)
        	{
        		if (!strcmp (name, "pptp_gateway"))
        		{
        			status=NIC_Get_PPTP_Status();
        			if (status==PPTP_STATUS_CONNECT || status==PPTP_STATUS_READY || status==PPTP_STATUS_DHCP)
        				fprintf (fptr, "%s", nic_info.gateway);
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else if (nic_nas_info.usage == NIC_USE_DHCP)
        	{
        		if (!strcmp (name, "dhcp_gateway"))
        		{
       				if (strlen (nic_info.gateway) > 0)
       					fprintf (fptr, "%s", nic_info.gateway);
       				else
       					fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else
        		fprintf (fptr, "'+NIC_WAN_STR31+'");
        }
        else if (!strcmp(name, "dhcp_dns") || !strcmp(name, "pppoe_dns") || !strcmp(name, "pptp_dns"))
	{
		char dns1[256], dns2[256];
		NIC_Get_Resolv2(dns1, 256, dns2, 256);
		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
        	if (nic_nas_info.usage == NIC_USE_PPPOE)
        	{
        		if (!strcmp (name, "pppoe_dns"))
        		{
        			status=NIC_Get_PPPOE_Status();
        			if (status==PPPOE_STATUS_CONNECT || status==PPPOE_STATUS_READY || status==PPPOE_STATUS_DHCP)
        			{
	        			if (!strcmp(dns2, "0.0.0.0"))
	        			{
						if (strcmp(dns1, "0.0.0.0"))
							fprintf(fptr, "%s ", dns1);
						else
							fprintf (fptr, "'+NIC_WAN_STR31+'");
					}
					else
						fprintf(fptr, "%s&nbsp;&nbsp;&nbsp;%s", dns1, dns2);
        			}
        			else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else if (nic_nas_info.usage == NIC_USE_PPTP)
        	{
        		if (!strcmp (name, "pptp_dns"))
        		{
        			status=NIC_Get_PPTP_Status();
        			if (status==PPTP_STATUS_CONNECT || status==PPTP_STATUS_READY || status==PPTP_STATUS_DHCP)
        			{
	        			if (!strcmp("0.0.0.0", dns2))
	        			{
						if (strcmp(dns1, "0.0.0.0"))
							fprintf(fptr, "%s ", dns1);
						else
							fprintf (fptr, "'+NIC_WAN_STR31+'");
					}
					else
						fprintf(fptr, "%s&nbsp;&nbsp;&nbsp;%s", dns1, dns2);
				}
				else
        				fprintf (fptr, "'+NIC_WAN_STR31+'");
        		}
        	}
        	else if (nic_nas_info.usage == NIC_USE_DHCP)
        	{
        		if (!strcmp (name, "dhcp_dns"))
        		{
        			if (!strcmp("0.0.0.0", dns2))
        			{
					if (strcmp("0.0.0.0", dns1))
						fprintf(fptr, "%s ", dns1);
					else
						fprintf (fptr, "'+NIC_WAN_STR31+'");
				}
				else
					fprintf(fptr, "%s&nbsp;&nbsp;&nbsp;%s", dns1, dns2);
        		}
        	}
        	else
        		fprintf (fptr, "'+NIC_WAN_STR31+'");
	}
	else if (!strcmp (name, "dhcp_info") || !strcmp (name, "pppoe_info") || !strcmp (name, "pptp_info"))
	{
		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
		if (nic_nas_info.usage == NIC_USE_PPPOE)
        	{
			if (!strcmp (name, "pppoe_info"))
				CGI_Output_Html1(NIC_PPPOE_INFO_HTML, "$", select_replace, arg);
		}
        	else if (nic_nas_info.usage == NIC_USE_PPTP)
        	{
       			if (!strcmp (name, "pptp_info"))
       				CGI_Output_Html1(NIC_PPTP_INFO_HTML, "$", select_replace, arg);
        	}
        	else if (nic_nas_info.usage == NIC_USE_DHCP)
        	{
        		if (!strcmp (name, "dhcp_info"))
	        		CGI_Output_Html1(NIC_DHCP_INFO_HTML, "$", select_replace, arg);
        	}
	}
	else if (!strcmp (name, "1MAC_ADD") || !strcmp (name, "2MAC_ADD") || !strcmp (name, "3MAC_ADD") ||
        	 !strcmp (name, "4MAC_ADD") || !strcmp (name, "5MAC_ADD") || !strcmp (name, "6MAC_ADD"))
        {
        	if ((p = CGI_Find_Parameter (input, name)) != NULL)
        		fprintf (fptr, "%s", p->val);
        	else
	        	fprintf (fptr, "00");
        }
        else if (!strcmp (name, "use_specify_mac"))
        {
        	if (g_page == 4)
        	{
        		if ((p = CGI_Find_Parameter (input, "Use_Specify_MAC")) != NULL)
        			if (!strcmp (p->val, "ON"))
        				fprintf (fptr, "checked");
        	}
        	else
        	{
        		if ((p = CGI_Find_Parameter (input, "Use_Specify_MAC")) != NULL)
        			fprintf (fptr, "%s", p->val);
        		else
        			fprintf (fptr, "OFF");
        	}
        }
	else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int show_select_main(INPUT * input)
{
        NIC_NAS_INFO    nic_nas_info;

        NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
        CGI_Output_Html1(NIC_HEADER_HTML, "$", select_replace, input);
	show_wan_header();

	g_page = get_page (input);
        switch (g_page)
        {
        case 1:
        	CGI_Output_Html1(NIC_SETTING_MAIN_HTML, "$", select_replace, input);
        	break;
        case 2:
        	CGI_Output_Html1(NIC_PPPOE_MAIN_HTML, "$", select_replace, input);
        	break;
        case 3:
        	CGI_Output_Html1(NIC_PPTP_MAIN_HTML, "$", select_replace, input);
        	break;
        case 4:
        	CGI_Output_Html1(NIC_DHCP_MAIN_HTML, "$", select_replace, input);
        	break;
        case 5:
        	CGI_Output_Html1(NIC_STATICIP_MAIN_HTML, "$", select_replace, input);
        	break;
        case 6:
        	CGI_Output_Html1(NIC_OTHER_MAIN_HTML, "$", select_replace, input);
        	break;
        }
	show_wan_tail();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", wan_replace, &nic_nas_info);
        return NIC_SUCCESS;
}

int do_wan_main()
{
        NIC_NAS_INFO    nic_nas_info;

        NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
        CGI_Output_Html1(NIC_HEADER_HTML, "$", wan_replace, &nic_nas_info);
	show_wan_header();
	CGI_Output_Html1(NIC_SETTING_MAIN_HTML, "$", wan_replace, &nic_nas_info);
	show_wan_tail();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", wan_replace, &nic_nas_info);
        return NIC_SUCCESS;
}

int comp_pppoe(PPPOE *p1, PPPOE *p2)
{
	if (	!strcmp(p1->username, p2->username) && !strcmp(p1->passwd, p2->passwd) &&
		p1->connect_on_boot==p2->connect_on_boot && p1->keep_alive==p2->keep_alive &&
		p1->idle==p2->idle && p1->fail_use_dhcp==p2->fail_use_dhcp)
		return 0;
	else
		return 1;
}

int comp_pptp(PPTP *p1, PPTP *p2)
{
	if (!strcmp(p1->username, p2->username) && !strcmp(p1->passwd, p2->passwd) && !strcmp(p1->serveraddr, p2->serveraddr) && p1->fail_use_dhcp==p2->fail_use_dhcp)
		return 0;
	else
		return 1;
}

int check_btn(INPUT *input)
{
	INPUT	*p;

	p=input;
	if ((p=CGI_Find_Parameter(input, "PPPOE_CONNECT"))!=NULL)
		return BTN_PPPOE_CONNECT;
	else
        if ((p=CGI_Find_Parameter(input, "PPPOE_DISCONNECT"))!=NULL)
                return BTN_PPPOE_DISCONNECT;
        else
        if ((p=CGI_Find_Parameter(input, "PPTP_CONNECT"))!=NULL)
                return BTN_PPTP_CONNECT;
        else
        if ((p=CGI_Find_Parameter(input, "PPTP_DISCONNECT"))!=NULL)
                return BTN_PPTP_DISCONNECT;
        else
        if ((p=CGI_Find_Parameter(input, "DHCP_CONNECT"))!=NULL)
                return BTN_DHCP_CONNECT;
        else
        if ((p=CGI_Find_Parameter(input, "DHCP_DISCONNECT"))!=NULL)
                return BTN_DHCP_DISCONNECT;
        else
        if ((p=CGI_Find_Parameter(input, "OK"))!=NULL)
                return BTN_OK;
	return BTN_UNKNOWN;
}

BOOL compare_mac_addr (char * new_mac_addr)
{
	char old_mac_addr[32];
	NIC_Get_VHWADDR (old_mac_addr, sizeof (old_mac_addr), NIC_WAN);
	if (!strcmp (new_mac_addr, old_mac_addr))
		return TRUE;
	return FALSE;
}

int combine_mac_input (char * buf, char (*mac_addr)[3])
{
	int ret = 0, i, mac_idx, zero_flag = 0;

	for (i = 0; i < 6; i++)
	{
		for (mac_idx = 0; mac_idx < 2; mac_idx++)
		{
			if ((mac_addr[i][mac_idx] < '0' || mac_addr[i][mac_idx] > 'f') ||
			    (mac_addr[i][mac_idx] > '9' && mac_addr[i][mac_idx] < 'A') ||
			    (mac_addr[i][mac_idx] > '9' && mac_addr[i][mac_idx] < 'A'))
				return -1;
		}
	}

	for (i = 0; i < 6; i++)
	{
		if (!strcmp (mac_addr[i], "00"))
			zero_flag++;
	}

	if (zero_flag == 6)
		return -1;

	for (i = 0; i < 6; i++)
	{
		if (i == 0)
			strcpy (buf, mac_addr[i]);
		else
		{
			strcat (buf, ":");
			strcat (buf, mac_addr[i]);
		}
	}
#ifdef	_DEBUG
printf ("\nmac_addr = %s<br>", buf);
#endif
	return ret;
}

int do_wan_main_submit(INPUT *input)
{
        INPUT           *p;
        NIC_NAS_INFO    nic_nas_info;
        int             ret=NIC_SUCCESS, old_access, new_access, old_port, new_port;
	int		thttpd_change=0, pppoe_change=0, pptp_change=0, dhcp_change=0;
        char            addr[NIC_IPADDR_LEN];
	PPPOE		pppoe, tmp_pppoe;
	PPTP		pptp, tmp_pptp;
	int		btn, usage=0;
	pid_t		parent, mypid;
	char		dir[128], buf[128];
#ifdef	_DEBUG
CGI_Debug_Input(input);
#endif
	btn=check_btn(input);

	g_page = get_page (input);

        if (g_page == 0)
        {
                if ((p=CGI_Find_Parameter(input, "WAN_USAGE"))!=NULL)
                {
                       	if (!strcmp(p->val, "DHCP"))
                                usage=NIC_USE_DHCP;
                        else
                        if (!strcmp(p->val, "STATIC"))
                                usage=NIC_USE_STATIC;
                        else
                        if (!strcmp(p->val, "PPPOE"))
                                usage=NIC_USE_PPPOE;
                        else
                        if (!strcmp(p->val, "PPTP"))
                                usage=NIC_USE_PPTP;
                        else
                                usage=NIC_USE_OTHER;
                }
		else
			return CGI_SUCCESS;
		/* set pppoe */
		if (usage == NIC_USE_PPPOE)
		{
			NIC_Get_PPPOE(&tmp_pppoe);
			if ((p=CGI_Find_Parameter(input, "PPPOE_USER"))!=NULL)
				strcpy(pppoe.username, p->val);
			else
				goto wan_not_found;

                	if ((p=CGI_Find_Parameter(input, "PPPOE_PWD"))!=NULL)
	                        strcpy(pppoe.passwd, p->val);
        	        else
        	                goto wan_not_found;

	                if ((p=CGI_Find_Parameter(input, "bBOOT"))!=NULL)
	                {
        	                if (!strcmp (p->val, "ON"))
        	                	pppoe.connect_on_boot=1;
        	                else
        	                	pppoe.connect_on_boot=0;
        	        }
                        else
                                pppoe.connect_on_boot=0;

			if ((p=CGI_Find_Parameter(input, "PPPOE_IDLE"))!=NULL)
                                pppoe.idle=atoi(p->val);
		        else
				goto wan_not_found;

                        if ((p=CGI_Find_Parameter(input, "PPPOE_ALIVE"))!=NULL)
        		{
        			if (!strcmp(p->val, "PPPOE_ALIVE"))
        			{
        				pppoe.keep_alive = 1;
        				pppoe.idle = tmp_pppoe.idle;
        			}
        			else
        			{
        				pppoe.keep_alive = 0;
        			}
        		}
                        else
                                goto wan_not_found;

        		if ((p=CGI_Find_Parameter(input, "bPPPOEDHCP"))!=NULL)
        		{
				if (!strcmp (p->val, "ON"))
					pppoe.fail_use_dhcp=1;
				else
					pppoe.fail_use_dhcp=0;
			}
			else
        			pppoe.fail_use_dhcp=0;

			if (comp_pppoe(&pppoe, &tmp_pppoe))
				pppoe_change=1;

	  	        NIC_Set_PPPOE(&pppoe);
	  	}

		/* set pptp */
		if (usage == NIC_USE_PPTP)
		{
        		NIC_Get_PPTP(&tmp_pptp);
        		if ((p=CGI_Find_Parameter(input, "PPTP_USER"))!=NULL)
        			strcpy(pptp.username, p->val);
        		else
        			goto wan_not_found;

        		if ((p=CGI_Find_Parameter(input, "PPTP_PWD"))!=NULL)
        			strcpy(pptp.passwd, p->val);
        		else
        			goto wan_not_found;

        		CGI_Get_Text_IP(pptp.serveraddr, NIC_IPADDR_LEN, input, "PPTP_IP1", "PPTP_IP2", "PPTP_IP3", "PPTP_IP4");
                        if ((p=CGI_Find_Parameter(input, "bPPTPDHCP"))!=NULL)
                        {
                                if (!strcmp (p->val, "ON"))
                                	pptp.fail_use_dhcp=1;
                                else
                                	pptp.fail_use_dhcp=0;
                        }
                        else
                                pptp.fail_use_dhcp=0;

        		if (comp_pptp(&pptp, &tmp_pptp))
        			pptp_change=1;

			pptp.keep_alive=tmp_pptp.keep_alive;
			pptp.idle=tmp_pptp.idle;
        		NIC_Set_PPTP(&pptp);
        	}

	        /* set dhcp */
	        if (usage == NIC_USE_DHCP)
	        {
	        	char mac_buf[6][3];
	        	char mac_addr[32];
	        	bzero (mac_buf, sizeof (mac_buf));
	        	if ((p=CGI_Find_Parameter (input, "Use_Specify_MAC")) != NULL)
	        	{
	        		if (!strcmp (p->val, "ON"))
	        		{
	        			int i;
	        			for (i = 0; i < 6; i++)
	        			{
		        			char name_buf[16];
		        			sprintf (name_buf, "%dMAC_ADD", i + 1);
		        			if ((p=CGI_Find_Parameter (input, name_buf)) != NULL)
		        				strncpy (mac_buf[i], p->val, 2);
		        		}

		        		if (combine_mac_input (mac_addr, mac_buf) < 0)
		        			return MAC_INPUT_ERROR;

	        			if (!compare_mac_addr (mac_addr))
	        				dhcp_change = 1;

	        			if (NIC_Set_VHWADDR (mac_addr, NIC_WAN) == NIC_FAIL)
	        				return MAC_INPUT_ERROR;

	        			if (NIC_Is_VHWADDR_Enabled (NIC_WAN) == FALSE)
	        				dhcp_change = 1;

	        			NIC_Enable_VHWADDR (1, NIC_WAN);
	        		}
	        		else
	        		{
	        			if (NIC_Is_VHWADDR_Enabled (NIC_WAN) == TRUE)
	        			{
	        				NIC_Enable_VHWADDR (0, NIC_WAN);
	        				dhcp_change = 1;
	        			}
	        		}
	        	}
	        	else
	        	{
	        		if (NIC_Is_VHWADDR_Enabled (NIC_WAN) == TRUE)
	        		{
	        			NIC_Enable_VHWADDR (0, NIC_WAN);
	        			dhcp_change = 1;
	        		}
	        	}
	        }

		/* set dns */
		if ((p=CGI_Find_Parameter(input, "bDNS"))!=NULL)
		{
	                if (!strcmp (p->val, "ON"))
	                {
			        if ((p=CGI_Find_Parameter(input, "DNS_IP1"))!=NULL)
                	        {
                        	        sprintf (buf, "%d", atoi (p->val));
                                	strcpy(addr, buf);
		                }
                	        else
                        	        goto wan_not_found;
		                strcat(addr, ".");
                	        if ((p=CGI_Find_Parameter(input, "DNS_IP2"))!=NULL)
                        	{
                                	sprintf (buf, "%d", atoi (p->val));
		                        strcat(addr, buf);
                	        }
                        	else
                                	goto wan_not_found;
		                strcat(addr, ".");
                	        if ((p=CGI_Find_Parameter(input, "DNS_IP3"))!=NULL)
                        	{
                                	sprintf (buf, "%d", atoi (p->val));
		                        strcat(addr, buf);
                	        }
                        	else
                                	goto wan_not_found;
		                strcat(addr, ".");
                	        if ((p=CGI_Find_Parameter(input, "DNS_IP4"))!=NULL)
                        	{
                                	sprintf (buf, "%d", atoi (p->val));
		                        strcat(addr, buf);
                	        }
                        	else
                                	goto wan_not_found;
                        }
                        else
                        	strcpy (addr, "0.0.0.0");
                }
                else
                	strcpy (addr, "0.0.0.0");
                NIC_Set_DNS(addr);
                Reload_DHCP_Config();

		/* set icmp echo-request */
		if ((p=CGI_Find_Parameter(input, "bICMP"))!=NULL)
		{
			if (!strcmp (p->val, "OFF"))
				FW_Set_ICMP_Request(0);
			else
				FW_Set_ICMP_Request(1);
		}
		else
			FW_Set_ICMP_Request(1);
		FW_Add_ICMP_Rule();
		/* set web access & port */
		old_access=Get_Web_Access(SYSTEM_WAN_ACCESS);
		if ((p=CGI_Find_Parameter(input, "bWANACCESS"))!=NULL)
		{
			if (!strcmp (p->val, "ON"))
				new_access=1;
			else
				new_access=0;
		}
		else
			new_access=0;

		if (old_access!=new_access)
		{
			Set_Web_Access(SYSTEM_WAN_ACCESS, new_access);
			thttpd_change=1;
		}

		new_port=old_port=Get_Web_Access_Port();

		if ((p=CGI_Find_Parameter(input, "PORTNUM"))!=NULL)
			new_port=atoi(p->val);
		if (old_port!=new_port)
		{
			Set_Web_Access_Port(new_port);
			thttpd_change=1;
		}
		/* set wan */
                NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
                if ((p=CGI_Find_Parameter(input, "WAN_USAGE"))!=NULL)
                {
                        if (!strcmp(p->val, "DHCP"))
                        {
                                nic_nas_info.usage=NIC_USE_DHCP;
                        }
                        else
                        if (!strcmp(p->val, "STATIC"))
                                nic_nas_info.usage=NIC_USE_STATIC;
                        else
                        if (!strcmp(p->val, "PPPOE"))
                                nic_nas_info.usage=NIC_USE_PPPOE;
			else
			if (!strcmp(p->val, "PPTP"))
				nic_nas_info.usage=NIC_USE_PPTP;
                        else
                                nic_nas_info.usage=NIC_USE_OTHER;
                }
                else
                        goto wan_not_found;

                if (usage == NIC_USE_STATIC)
                {
                	CGI_Get_Text_IP(nic_nas_info.ifconfig.ipaddr, NIC_IPADDR_LEN, input, "WAN_IP1", "WAN_IP2", "WAN_IP3", "WAN_IP4");
                	CGI_Get_Text_IP(nic_nas_info.ifconfig.netmask, NIC_IPADDR_LEN, input, "WAN_MASK1", "WAN_MASK2", "WAN_MASK3", "WAN_MASK4");
                	CGI_Get_Text_IP(nic_nas_info.ifconfig.gateway, NIC_IPADDR_LEN, input, "WAN_GW1", "WAN_GW2", "WAN_GW3", "WAN_GW4");
                }
                ret=NIC_Set_Info_To_uLinux(&nic_nas_info);
		/* click button, check if input error ? */
                if ((btn==BTN_PPPOE_CONNECT || btn==BTN_PPPOE_DISCONNECT) && usage!=NIC_USE_PPPOE)
                        return PPPOE_NOT_SELECTED;
		else
                if ((btn==BTN_PPTP_CONNECT || btn==BTN_PPTP_DISCONNECT) && usage!=NIC_USE_PPTP)
                        return PPTP_NOT_SELECTED;
		else
                if ((btn==BTN_DHCP_CONNECT || btn==BTN_DHCP_DISCONNECT) && usage!=NIC_USE_DHCP)
                        return DHCP_NOT_SELECTED;
		/* button action */
       		parent=getpid();
       		sprintf(dir, "/proc/%d/exe", parent);
       		if (btn==BTN_PPPOE_CONNECT)
       		{
                        mypid=fork();
                        if (mypid==0)
                        {       /* child */
                                close(0);
                                close(1);
                                close(2);
                                while (1)
                                {
                                        if (readlink(dir, buf, 256)==-1)
                                                break;
                                        sleep(1);
                                }
	                        NIC_Restart_PPPOE();
	                }
                        do_wan_main();
	                return NIC_SUCCESS;
	        }
		else
		if (btn==BTN_PPPOE_DISCONNECT)
		{
                        mypid=fork();
                        if (mypid==0)
                        {       /* child */
                                close(0);
                                close(1);
                                close(2);
                                while (1)
                                {
                                        if (readlink(dir, buf, 256)==-1)
                                                break;
                                        sleep(1);
                                }
                                NIC_Stop_PPPOE();
                        }
			do_wan_main();
                        return NIC_SUCCESS;
		}
		else
		if (btn==BTN_PPTP_CONNECT)
		{
			mypid=fork();
			if (mypid==0)
			{       /* child */
				close(0);
				close(1);
				close(2);
				while (1)
                                {
					if (readlink(dir, buf, 256)==-1)
						break;
					sleep(1);
				}
				NIC_Restart_PPTP();
			}
			do_wan_main();
			return NIC_SUCCESS;
		}
		else
		if (btn==BTN_PPTP_DISCONNECT)
		{
                        mypid=fork();
                        if (mypid==0)
                        {       /* child */
                                close(0);
                                close(1);
                                close(2);
                                while (1)
                                {
                                        if (readlink(dir, buf, 256)==-1)
                                                break;
                                        sleep(1);
                                }
                                NIC_Stop_PPTP();
                        }
			do_wan_main();
                        return NIC_SUCCESS;
		}
		else
		if (btn==BTN_DHCP_CONNECT)
		{
                        mypid=fork();
                        if (mypid==0)
                        {       /* child */
                                close(0);
                                close(1);
                                close(2);
                                while (1)
                                {
                                        if (readlink(dir, buf, 256)==-1)
                                                break;
                                        sleep(1);
                                }
                                NIC_Restart_DHCP(NIC_WAN);
                        }
			do_wan_main();
                        return NIC_SUCCESS;
		}
		else
		if (btn==BTN_DHCP_DISCONNECT)
		{
                        mypid=fork();
                        if (mypid==0)
                        {       /* child */
                                close(0);
                                close(1);
                                close(2);
                                while (1)
                                {
                                        if (readlink(dir, buf, 256)==-1)
                                                break;
                                        sleep(1);
                                }
                                NIC_Stop_DHCP(NIC_WAN);
                        }
			do_wan_main();
                        return NIC_SUCCESS;
		}

		if (thttpd_change==1)
		{
			/* need to restart thttpd? */
			if (old_port!=new_port)
			{
				if (ret==NIC_RESTART)
					do_restart_main(NIC_RESTART_WAN_WEB);
				else
					do_restart_main(NIC_RESTART_WEB);
				return NIC_SUCCESS;
			}
			else
			if (old_access!=new_access)
			{
				parent=getpid();
				sprintf(dir, "/proc/%d/exe", parent);
				mypid=fork();
				if (mypid==0)
				{	/* child */
					close(0);
					close(1);
					close(2);
					while (1)
					{
						if (readlink(dir, buf, 256)==-1)
							break;
						sleep(1);
					}
					FW_Begin_NAT(NULL);
				}
			}
		}

wan_not_found:
	        if (ret==NIC_RESTART || (pppoe_change==1 && nic_nas_info.usage==NIC_USE_PPPOE) || (pptp_change==1 && nic_nas_info.usage==NIC_USE_PPTP) || (dhcp_change==1 && nic_nas_info.usage==NIC_USE_DHCP))
	        {
        	        do_restart_main(NIC_RESTART_WAN);
        	}
	        else
        	{
                	//  Modify by Tiger
	                do_wan_main();
        	}

	}
	else
	{
		show_select_main (input);
	}
        return NIC_SUCCESS;
}
