#include <stdio.h>
#include <string.h>

#include <cfg_nic.h>

void show_help()
{
	printf("usage: nic_getinfo [dev] [option]\n");
	printf("	[dev]: eth0, eth1, eth2, ppp0, br0\n");
	printf("	[option]: ip, netmask, gw, dstaddr, hwaddr, vhwaddr\n\n");
}

int nic_getinfo(int argc, char *argv[])
{
	NIC_INFO	nic_info;
	int		type;
	char		dev[NIC_DEV_LEN];
	char		command[255];
	char		buf[64];

        if (argc<3)
                show_help();
        else
        {
        	int is_switch_dev = 0;

        	if (NIC_Is_Bonding_Support() &&
        		strcmp(argv[1], BONDING_DEV) != 0 &&
        		!NIC_Is_Bonding_Device(argv[1]))
        	{
        		is_switch_dev++;
        		NIC_Get_Dev(dev, NIC_DEV_LEN, NIC_LAN03);
        	}
        	else
		{//Shone modified to let eth1 and eth2 be gotten normally 2005,05,16
			if(!strcmp(argv[1],"eth0"))
			   NIC_Get_Dev(dev, NIC_DEV_LEN, NIC_LAN01);
			else if(!strcmp(argv[1],"eth1"))
			   NIC_Get_Dev(dev, NIC_DEV_LEN, NIC_LAN02);
			else if(!strcmp(argv[1],"eth2"))
			   NIC_Get_Dev(dev, NIC_DEV_LEN, NIC_LAN03);
			else
			   NIC_Get_Dev(dev, NIC_DEV_LEN, NIC_LAN01);
		}

		if (!strcmp(dev, argv[1]))
		{//Shone modified to let eth1 and eth2 be gotten normally
			if (is_switch_dev)
				type = NIC_LAN03;
			else if(!strcmp(argv[1],"eth0"))
				type=NIC_LAN01;
			else if(!strcmp(argv[1],"eth1"))
				type=NIC_LAN02;
			else if(!strcmp(argv[1],"eth2"))
				type=NIC_LAN03;
			else
				type=NIC_LAN01;

			NIC_Get_Info(&nic_info, type);
		}
		else
		{
			type=NIC_WAN;
			NIC_Get_Dev(dev, NIC_DEV_LEN, NIC_WAN);
			NIC_Get_Info(&nic_info, NIC_WAN);
		}
		sprintf(command, "/sbin/ifconfig %s 2>/dev/null 1>/dev/null", dev);
		if (system(command)!=0)
		{
			printf("127.0.0.1");
			return NIC_SUCCESS;
		}
                if (!strcmp(argv[2], "ip"))
		{
			if (nic_info.ipaddr[0]==0x0)
				printf("127.0.0.1");
			else
				printf("%s", nic_info.ipaddr);
		}
                else
                if (!strcmp(argv[2], "netmask"))
		{
                        if (nic_info.ipaddr[0]==0x0)
                                printf("127.0.0.1");
                        else
                        printf("%s", nic_info.netmask);
		}
                else
                if (!strcmp(argv[2], "gw"))
		{
                        if (nic_info.ipaddr[0]==0x0)
                                printf("127.0.0.1");
                        else
                        printf("%s", nic_info.gateway);
		}
		else
		if (!strcmp(argv[2], "dstaddr"))
		{
			if (nic_info.dstaddr[0]==0x0)
				printf("127.0.0.1");
			else
				printf("%s", nic_info.dstaddr);
		}
		else
		if (!strcmp(argv[2], "hwaddr"))
		{
			NIC_Get_HWADDR(buf, 64, type);
			printf("%s", buf);
		}
		else
		if (!strcmp(argv[2], "vhwaddr"))
		{
			NIC_Get_VHWADDR(buf, 64, type);
			printf("%s", buf);
		}
                else
                        show_help();
        }
        return NIC_SUCCESS;
}

