#include <stdio.h>
#include <string.h>

/* include NAS lib */
#include <cgi.h>
#include <cfg_nic.h>
#include <config.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>

/* include local file */
#include "network.h"
#include "nic_apple.h"

int apple_replace(FILE *fptr, char *name, void *arg)
{
	char		buf[256];


        if (!strcmp(name, "ONLOAD"))
        {
        }
        else
        if (!strcmp(name, "bAPPLE"))
        {
                if (Is_Appletalk_Enabled()!=0)
                        fprintf(fptr, "checked");
        }
        else
        if (!strcmp(name, "AppleZone_Dsiabled"))
        {
                if (!Is_Appletalk_Enabled())
                        fprintf(fptr, "disabled");
        }
        else
        if (!strcmp(name, "AppleZone"))
        {
                Get_Appletalk_Default_Zone(buf, 256);
                fprintf(fptr, buf);
        }
        else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

//  Add by Tiger
int show_apple_header ()
{
	HEADER_ITEM	header;
	int	nic_count;

        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_apple_main");
	else
		CGI_Get_Help(header.help, "network_apple_main.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", apple_replace, NULL);
	nic_count=NIC_Count_Interface();
//modified by jeffrey hsieh
/*	if (	(nic_count==1 && !Is_Support_DNS()) ||
		(nic_count==2 && NIC_Is_Bonding_Support() && !Is_Support_DNS()) ||
		(nic_count==3 && NIC_Is_Bonding_Support() && !Is_Support_DNS()))
		if(!Is_Support_Printer())
			CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.noprndns.def", 3);
		else
			CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.nodns.def", 3);
	else
		CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/nas_services.def", 2);
*/
	CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network.def", 3);
//end
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", apple_replace, NULL);
	return NIC_SUCCESS;
}

int show_apple_tail ()
{
	return CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", apple_replace, NULL);
}
//  add until here

int do_apple_main()
{
        CGI_Output_Html1(NIC_HEADER_HTML, "$", apple_replace, NULL);
        //  Add by Tiger
        show_apple_header ();
        CGI_Output_Html1(NIC_APPLE_MAIN_HTML, "$", apple_replace, NULL);
        //  Add by Tiger
        show_apple_tail ();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", apple_replace, NULL);
        return NIC_SUCCESS;
}

int do_apple_main_submit(INPUT *input)
{
        INPUT   *tmp;

        if ((tmp=CGI_Find_Parameter(input, "bAPPLE"))!=NULL)
        {
                if ((tmp=CGI_Find_Parameter(input, "AppleZone"))!=NULL)
                {
                        Set_Appletalk_Default_Zone(tmp->val);
                }
		Enable_Appletalk(1);
        }
        else
                Enable_Appletalk(0);
	do_apple_main();
        return NIC_SUCCESS;
}


