//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		dnsconf.c
//
//	Abstract: 
//		Setting named.conf
//
//	FUNCTIONS:
//
//	COMMENTS:
//
//	HISTORY:
//		V1.0 2001/08/09		Tiger Fu created
//
//**************************************************************************
#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<errno.h>
#include 	<sys/timeb.h>

//  NAS lib
#include	<Util.h>
#include 	<config.h>
#include	<cfg_dns.h>
#include	<cfg_nic.h>

#include	"dns_zone.h"

//  private funciton
void copy_file (char * target_file, FILE * source_fp);

#define		ZONE		"zone"

char zonefmt[] = "zone \"%s\" {\n\ttype %s;\n\tfile \"%s\";\n};\n";

char slavezonefmt[] ="zone \"%s\" {\n\ttype %s;\n\tfile \"%s\";\n\tmasters { %s; };\n};\n";

char zonefilefmt[] = "@      IN     SOA    %s.     root.%s. (\n\t\t\t\t\t%d\t\t;Serial\n\t\t\t\t\t%d\t\t;Refresh\n\t\t\t\t\t%d\t\t;Retry\n\t\t\t\t\t%d\t\t;Expire\n\t\t\t\t\t%d)\t\t;Minmum\n";

char recordfmt[] = "%s\t\t%s\t%s\t%s\n";
//**************************************************************************
//	Function:	add_zone
//	Description: 	add zone to conf file
//
//	Parameter:	
//	Return value:
//
int add_zone(FILE * fp, ZONE_INFO * zone_info)
{
	char * buf = NULL;
	char zone_buf[128];

	int len = 0;
	int result = -1;  //  -1 = can't open config file
	
	//erease_zone (zone_info->zone_name);
	
	memset (zone_buf, '\0', sizeof (zone_buf));
	
	//  add to file
	sprintf (zone_buf, zonefmt, 
		zone_info->zone_name,
		zone_info->zone_type,
		zone_info->zone_file);
	if (fp)
	{
		fwrite (zone_buf, strlen (zone_buf), 1, fp);
		result = 0;
	}
	return result;
}

//**************************************************************************
//	Function:	add_slave_zone
//	Description: 	add slave zone to conf file
//
//	Parameter:	
//	Return value:
//
int add_slave_zone (FILE * fp, SLAVE_ZONE_INFO * zone_info)
{
	char * buf = NULL;
	char zone_buf[128];

	int len = 0;
	int result = -1;  //  -1 = can't open config file
	
	//erease_zone (zone_info->zone_name);
	
	memset (zone_buf, '\0', sizeof (zone_buf));
	//  add to file
	sprintf (zone_buf, slavezonefmt, 
		zone_info->zone_info.zone_name,
		zone_info->zone_info.zone_type,
		zone_info->zone_info.zone_file,
		zone_info->masters_ip);
	if (fp)
	{
		fwrite (zone_buf, strlen (zone_buf), 1, fp);
		result = 0;
	}
	return result;
}

//**************************************************************************
//	Function:	add_option
//	Description: 	add option
//
//	Parameter:	
//	Return value:
//
int add_option (char * option, char * value)
{
	FILE * fp = NULL, * tmpfp = NULL;
	char s[255];

	//  open config file
	fp = fopen (get_conf_file_name (), "r");
	//  open temp file
	tmpfp = tmpfile();

	while (fgets (s, sizeof (s), fp))
	{
		fprintf(tmpfp, "%s", s);
		//  if find the option
		if (strstr (s, option))
		{
			while (fgets (s, sizeof (s), fp))
			{
				if (strstr (s, "}"))
				{
					//  insert item
					fprintf (tmpfp, "\t\t%s;", value);
					fprintf (tmpfp, "\n");
					fprintf (tmpfp, "%s", s);
					break;
				}
				fprintf(tmpfp, "%s", s);
			}
		}
	}
	//  set position to start of temp file
	rewind (tmpfp);
	//  close config file
	fclose (fp);
	//  copy temp file to config file
	copy_file (get_conf_file_name (), tmpfp);

	//  close temp file
	fclose (tmpfp);
}

//**************************************************************************
//	Function:	erease_option
//	Description: 	erase specify option
//
//	Parameter:	
//	Return value:
//
int erease_option (char * option, char * value)
{
	FILE * fp = NULL, * tmpfp = NULL;
	char s[255];

	//  open config file
	fp = fopen (get_conf_file_name (), "r");
	//  open temp file
	tmpfp = tmpfile();

	while (fgets (s, sizeof (s), fp))
	{
		fprintf(tmpfp, "%s", s);
		if (strstr (s, option))
		{
			while (fgets (s, sizeof (s), fp))
			{
				if (strstr (s, "}"))
				{
					fprintf(tmpfp, "%s", s);
					break;
				}
				if (!strstr (s, value))
					fprintf(tmpfp, "%s", s);
			}
		}
	}
	//  set position to start of temp file
	rewind (tmpfp);
	//  close config file
	fclose (fp);
	//  copy temp file to config file
	copy_file (get_conf_file_name (), tmpfp);

	//  close temp file
	fclose (tmpfp);
}

//**************************************************************************
//	Function:	copy_file
//	Description: 	copy source file to target file
//
//	Parameter:	
//	Return value:
//
void copy_file (char * target_file, FILE * source_fp)
{
	FILE * fp = NULL;
	char s[255];
	
	//  open config file
	fp = fopen (target_file, "w");
	
	while (fgets (s, sizeof (s), source_fp))
		fprintf (fp, "%s", s);
		
	//  close file
	fclose (fp);
}

//**************************************************************************
//	Function:	create_zone_file
//	Description: 	create zone file 
//			note: this function will be erease original content
//	Parameter:	
//	Return value:
//
int create_zone_file (char * file_name, ZONE_DETAIL_INFO * zone_content)
{
	FILE * fp = NULL;
	int result = -1; //  -1 = can't open file
	char buf[255];
	memset (buf, '\0', sizeof (buf));
	
	Get_Profile_String (DNS_SECTION, DB_PATH, "/var/named", buf, sizeof (buf));
	strcat (buf, "/");
	strcat (buf, file_name);

	fp = fopen (buf, "w");
	if (fp)
	{
		fprintf (fp, "; File: %s\n", file_name);
		fprintf (fp, ";\n");
		fprintf (fp, "; Zone file for domain : %s.\n", zone_content->zone_name);
		fprintf (fp, ";\n");
		fprintf (fp, "$TTL %d\n", zone_content->default_TTL);
		fprintf (fp, zonefilefmt,zone_content->zone_name,
					zone_content->zone_name,
					zone_content->serial_number,
					zone_content->refresh_time,
					zone_content->retry_time,
					zone_content->expire_time,
					zone_content->mini_TTL);
		fclose (fp);
		result = 0;
	}
	return result;
}

//**************************************************************************
//	Function:	add_record
//	Description: 	add record to zone file
//			
//	Parameter:	
//	Return value:
//
int add_record (char * zone_file, RESOURCE_RECORD * rr_info)//char * left_value, char * type1, char * type2, char * right_value)
{
	FILE * fp = NULL;
	int result = -1;  //  can't open file
	char fullpath[255];
	
	memset (fullpath, '\0', sizeof (fullpath));
	
	Get_Profile_String (DNS_SECTION, DB_PATH, "/var/named", fullpath, sizeof (fullpath));
	strcat (fullpath, "/");
	strcat (fullpath, zone_file);
	
	if (!strcmp (rr_info->type2, "MX"))
	{
		int priority = parser_priority (rr_info->mapping);
		strcpy (rr_info->type1, rr_info->type2);
		sprintf (rr_info->type2, "%d", priority);
		strcpy (rr_info->mapping, parser_mapping (rr_info->mapping));
	}

	fp = fopen (fullpath, "a");
	if (fp)
	{
		fprintf (fp, recordfmt, rr_info->name, rr_info->type1, rr_info->type2, rr_info->mapping);
		fclose (fp);
		result = 0;
	}
	return result;
}

//**************************************************************************
//	Function:	parser_priority
//	Description: 	
//			
//	Parameter:	
//	Return value:
//
int parser_priority (char * mapping)
{
	char * ptr;
	ptr = (char *)strstr (mapping, "/");
	if (ptr == NULL)
		return 0;
	return atoi (mapping);
}

//**************************************************************************
//	Function:	parser_mapping
//	Description: 	
//			
//	Parameter:	
//	Return value:
//
char * parser_mapping (char * mapping)
{
	char * ptr;
	ptr = (char *)strstr (mapping, "/");
	if (ptr == NULL)
		return mapping;
	return ptr + 1;
}

//**************************************************************************
//	Function:	remove_record
//	Description: 	remove record from zone file
//			
//	Parameter:	
//	Return value:
//
int remove_record (char * zone_file, char * record)
{
	FILE * fp = NULL;
	int result = -1;
	char fullpath[255];
	memset (fullpath, '\0', sizeof (fullpath));
	
	Get_Profile_String (DNS_SECTION, DB_PATH, "/var/named", fullpath, sizeof (fullpath));
	strcat (fullpath, "/");
	strcat (fullpath, zone_file);
	
	return result;
}

//**************************************************************************
//	Function:	check_conf_file_exist
//	Description: 	check conf file whether exist
//			
//	Parameter:	
//	Return value:
//
int check_file_exist (char * filename)
{
	FILE * fp = NULL;
	fp = fopen (filename, "r");
	if (!fp)
		return 0;
	fclose (fp);
	return 1;
}

//**************************************************************************
//	Function:	create_conf_file
//	Description: 	
//			
//	Parameter: 
//	Return value:
//
int create_conf_file (CONF_FILE_INFO * conf_file_info, ZONE_DETAIL_INFO * zone, enum e_nstype type)
{
	FILE * fp = NULL;
	int result = -1; //  the file was exist
	ZONE_INFO zone_info, reserve_zone_info;
	RESOURCE_RECORD rr_info;
	NIC_NAS_INFO nic_nas_info;
	char rr_buf[128];

	bzero (&zone_info, sizeof (zone_info));
	bzero (&nic_nas_info, sizeof (nic_nas_info));
	bzero (&reserve_zone_info, sizeof (reserve_zone_info));

	strcpy (zone_info.zone_name, conf_file_info->local_zone_name);

	fp = fopen (conf_file_info->conf_file_name, "w");
	if (fp)
	{
		fprintf (fp, "// generated by create_conf_file function\n");
		fprintf (fp, "\n");
		fprintf (fp, "options {\n");
		fprintf (fp, "\tversion \"%s NAS DNS server\";\n", conf_file_info->NAS_name);
		fprintf (fp, "\tdirectory \"%s\";\n", get_db_path ());

		fprintf (fp, "\tdump-file \"/dev/null\";\n");
		fprintf (fp, "\tnotify yes;\n");
		if (conf_file_info->behind_firewall)
			fprintf (fp, "\tquery-source address * port 53;\n");
		if (type == E_Master)
		{
			int index = 0, total = get_forwarders_number ();
			if (total > 0)
			{
				fprintf (fp, "\tforwarders {\n");
				while (index++ < total)
					fprintf (fp, "\t\t%s;\n", get_forwarders (index));
				fprintf (fp, "\t};\n");
			}
			fprintf (fp, "\tallow-transfer {\n\t\tany;\n\t};\n");
		}
		//fprintf (fp, "\tallow-query {\"any\"; };\n");
		fprintf (fp, "};\n");
		fprintf (fp, "\n");

		//  create root file
		generate_root_file ();

		//  . zone information
		strcpy (zone_info.zone_name, ".");
		strcpy (zone_info.zone_type, "hint");
		strcpy (zone_info.zone_file, "named.root");
		add_zone (fp, &zone_info);
		
		//  localhost zone information
		strcpy (zone_info.zone_name, "localhost");
		strcpy (zone_info.zone_type, "master");
		strcpy (zone_info.zone_file, "Localhost");
		add_zone (fp, &zone_info);			//  add to named.conf
		strcpy (rr_buf, "/IN/NS/");
		strcat (rr_buf, conf_file_info->local_zone_name);
		strcat (rr_buf, ".");

		//create zone file
		create_zone_file (zone_info.zone_file, zone);

		parser_resource_record (rr_buf, sizeof (rr_buf), &rr_info, sizeof (rr_info));
		add_record (zone_info.zone_file, &rr_info);
		
		strcpy (rr_buf, "localhost./IN/A/127.0.0.1");
		parser_resource_record (rr_buf, sizeof (rr_buf), &rr_info, sizeof (rr_info));
		add_record (zone_info.zone_file, &rr_info);

		//  1.0.0.127.in-addr.arpa zone information
		strcpy (zone_info.zone_name, "0.0.127.in-addr.arpa");
		strcpy (zone_info.zone_type, "master");
		strcpy (zone_info.zone_file, "0.0.127.rev");
		add_zone (fp, &zone_info);			//  add to named.conf

		//create zone file
		create_zone_file (zone_info.zone_file, zone);
		get_zone_resource_record_number (zone_info.zone_name);

		strcpy (rr_info.name, "");
		strcpy (rr_info.type1, "IN");
		strcpy (rr_info.type2, "NS");
		strcpy (rr_info.mapping, conf_file_info->local_zone_name);
		add_record (zone_info.zone_file, &rr_info);
		
		strcpy (rr_buf, "1/IN/PTR/localhost.");
		parser_resource_record (rr_buf, sizeof (rr_buf), &rr_info, sizeof (rr_info));
		add_record (zone_info.zone_file, &rr_info);
		
		strcpy (rr_buf, "*/IN/PTR/not-a-legal-address.");
		parser_resource_record (rr_buf, sizeof (rr_buf), &rr_info, sizeof (rr_info));
		add_record (zone_info.zone_file, &rr_info);
		
		if (type == E_Master)
		{
			//  create master zone file...
			//	:
			//	:
			int index = 0, total = get_master_zone_number ();

			//  get WAN interface information
			while (index++ < total)
			{
				char master_zone [128];
				char rr_buf[128];
				RESOURCE_RECORD rr_info, rr_reserve_info;
				int rr_index = 0, rr_total = 0;

				bzero (&rr_info, sizeof (rr_reserve_info));

				strcpy (master_zone, get_master_zone_name (index));
				rr_total = get_zone_resource_record_number (master_zone);
				
				if (!get_master_zone_info (master_zone, &zone_info))
				{
					generate_reserve_zone (&reserve_zone_info);
					add_zone (fp, &reserve_zone_info);
					create_zone_file (reserve_zone_info.zone_file, zone);

					add_zone (fp, &zone_info);
					create_zone_file (zone_info.zone_file, zone);
				}
				
				strcpy (rr_info.name, "");
				strcpy (rr_info.type1, "IN");
				strcpy (rr_info.type2, "NS");
				sprintf (rr_info.mapping, "%s.", zone_info.zone_name);
				add_record (zone_info.zone_file, &rr_info);
				add_record (reserve_zone_info.zone_file, &rr_info);
				
				NIC_Get_Info_From_uLinux (&nic_nas_info, NIC_WAN);
				strcpy (rr_info.name, "");
				strcpy (rr_info.type1, "IN");
				strcpy (rr_info.type2, "A");
				strcpy (rr_info.mapping, nic_nas_info.ifconfig.ipaddr);
				add_record (zone_info.zone_file, &rr_info);
				if (!conver_rr_to_reserve (&rr_info, &rr_reserve_info))
					add_record (reserve_zone_info.zone_file, &rr_reserve_info);	
				
				/*strcpy (rr_buf, "/IN/A/");
				strcat (rr_buf, zone_info.zone_name);
				strcat (rr_buf, ".");
				parser_resource_record (rr_buf, sizeof (rr_buf), &rr_info, sizeof (rr_info));
				add_record (zone_info.zone_file, &rr_info);*/
				
				while (rr_index++ < rr_total)
				{
					strcpy (rr_buf, get_zone_resource_record (master_zone, rr_index));
					parser_resource_record (rr_buf, sizeof (rr_buf), &rr_info, sizeof (rr_info));
					if (!conver_rr_to_reserve (&rr_info, &rr_reserve_info))
						add_record (reserve_zone_info.zone_file, &rr_reserve_info);	
					add_record (zone_info.zone_file, &rr_info);
				}
			}
		}
		else if (type == E_Slave)
		{
			//  create sllave zone file...
			//	:
			//	:
			SLAVE_ZONE_INFO slave_zone_info;
			int index = 0, total = get_slave_zone_number ();
			while (index++ < total)
			{
				if (!get_slave_zone_info (get_slave_zone_name (index), &slave_zone_info))
					add_slave_zone (fp, &slave_zone_info);
			}
		}
		
		result = 0;
		fclose (fp);
	}

	return result;
}

//**************************************************************************
//	Function:	create_master_ns
//	Description: 	
//			
//	Parameter:	
//	Return value:
//
int create_master_ns (CONF_FILE_INFO * conf_file_info)
{
	FILE * fp = NULL;
	char buf[255];
	ZONE_DETAIL_INFO zone;
	int result = 0;  //  the file was exist

	memset (buf, '\0', sizeof (buf));
	
	memset (&zone, '\0', sizeof (zone));
	strcpy (zone.zone_name, conf_file_info->local_zone_name);
	zone.default_TTL = 86400;
	zone.serial_number = generate_sequence_number ();
	zone.refresh_time = 28800;
	zone.retry_time = 14400;
	zone.expire_time = 3600000;
	zone.mini_TTL = 86400;
	
	return create_conf_file (conf_file_info, &zone, E_Master);
}
	
//**************************************************************************
//	Function:	create_slave_ns
//	Description: 	
//			
//	Parameter:	
//	Return value:
//
int create_slave_ns (CONF_FILE_INFO * conf_file_info)
{
	FILE * fp = NULL;
	char buf[255];
	ZONE_DETAIL_INFO zone;
	int result = 0;  //  the file was exist

	memset (buf, '\0', sizeof (buf));
	
	memset (&zone, '\0', sizeof (zone));
	strcpy (zone.zone_name, conf_file_info->local_zone_name);
	zone.default_TTL = 86400;
	zone.serial_number = 1;
	zone.refresh_time = 28800;
	zone.retry_time = 14400;
	zone.expire_time = 3600000;
	zone.mini_TTL = 86400;
	
	return create_conf_file (conf_file_info, &zone, E_Slave);
}

//**************************************************************************
//	Function:	create_cache_only
//	Description: 	
//			
//	Parameter:	
//	Return value:
//
int create_cache_only (CONF_FILE_INFO * conf_file_info)
{
	FILE * fp = NULL;
	char buf[255];
	ZONE_DETAIL_INFO zone;
	int result = 0;  //  the file was exist

	memset (buf, '\0', sizeof (buf));
	
	memset (&zone, '\0', sizeof (zone));
	strcpy (zone.zone_name, conf_file_info->local_zone_name);
	zone.default_TTL = 86400;
	zone.serial_number = 1;
	zone.refresh_time = 28800;
	zone.retry_time = 14400;
	zone.expire_time = 3600000;
	zone.mini_TTL = 86400;
	
	return create_conf_file (conf_file_info, &zone, E_Cache);
}


int paser_input (FILE * fp, char * value)
{
	int len = 0, index = 0, howmany = 0, i = 0;
	char s[80];
	memset (s, '\0', sizeof (s));
	
	len = strlen (value);
	if (len > 0)
		howmany = 1;
	while (index < len)
	{
		if (value[index] == '%')
		{
			while (value[++index] != 'A');
			if (i > 0)
				howmany++;
			fputc ('\n', fp);
			i++;
		}
		if (isdigit (value[index]) || value[index] == '.')
			fputc (value[index], fp);
		index++;
	}
	return howmany;
}


int generate_root_file (void)
{
	FILE * fp = NULL;
	char root_file_name[255];
	
	memset (root_file_name, '\0', sizeof (root_file_name));
	GET_PROFILE_STRING (DNS_SECTION, DB_PATH, "/var/named", root_file_name, sizeof (root_file_name));
	strcat (root_file_name, "/");
	strcat (root_file_name, "named.root");
	
	fp = fopen (root_file_name, "w");
	if (fp)
	{
		fprintf (fp, ".                        3600000  IN  NS    A.ROOT-SERVERS.NET.\n");
		fprintf (fp, "A.ROOT-SERVERS.NET.      3600000      A     198.41.0.4\n");
		fprintf (fp, ".                        3600000      NS    B.ROOT-SERVERS.NET.\n");
		fprintf (fp, "B.ROOT-SERVERS.NET.      3600000      A     128.9.0.107\n");
		fprintf (fp, ".                        3600000      NS    C.ROOT-SERVERS.NET.\n");
		fprintf (fp, "C.ROOT-SERVERS.NET.      3600000      A     192.33.4.12\n");
		fprintf (fp, ".                        3600000      NS    D.ROOT-SERVERS.NET.\n");
		fprintf (fp, "D.ROOT-SERVERS.NET.      3600000      A     128.8.10.90\n");
		fprintf (fp, ".                        3600000      NS    E.ROOT-SERVERS.NET.\n");
		fprintf (fp, "E.ROOT-SERVERS.NET.      3600000      A     192.203.230.10\n");
		fprintf (fp, ".                        3600000      NS    F.ROOT-SERVERS.NET.\n");
		fprintf (fp, "F.ROOT-SERVERS.NET.      3600000      A     192.5.5.241\n");
		fprintf (fp, ".                        3600000      NS    G.ROOT-SERVERS.NET.\n");
		fprintf (fp, "G.ROOT-SERVERS.NET.      3600000      A     192.112.36.4\n");
		fprintf (fp, ".                        3600000      NS    H.ROOT-SERVERS.NET.\n");
		fprintf (fp, "H.ROOT-SERVERS.NET.      3600000      A     128.63.2.53\n");
		fprintf (fp, ".                        3600000      NS    I.ROOT-SERVERS.NET.\n");
		fprintf (fp, "I.ROOT-SERVERS.NET.      3600000      A     192.36.148.17\n");
		fprintf (fp, ".                        3600000      NS    J.ROOT-SERVERS.NET.\n");
		fprintf (fp, "J.ROOT-SERVERS.NET.      3600000      A     198.41.0.10\n");
		fprintf (fp, ".                        3600000      NS    K.ROOT-SERVERS.NET.\n");
		fprintf (fp, "K.ROOT-SERVERS.NET.      3600000      A     193.0.14.129\n");
		fprintf (fp, ".                        3600000      NS    L.ROOT-SERVERS.NET.\n");
		fprintf (fp, "L.ROOT-SERVERS.NET.      3600000      A     198.32.64.12\n");
		fprintf (fp, ".                        3600000      NS    M.ROOT-SERVERS.NET.\n");
		fprintf (fp, "M.ROOT-SERVERS.NET.      3600000      A     202.12.27.33\n");
		fclose (fp);
	}
	else
		return 1;
	return 0;
}


void parser_resource_record (char * src, int len, RESOURCE_RECORD * rr_info, int size)
{
	char * ptr = NULL;
	int index = 0;
	while (src[index] != '/')
		rr_info->name[index] = src[index++];
	rr_info->name[index] = '\0';
	
	index = 0;
	ptr = (char *)strstr (src, "/");
	ptr = &ptr[1];
	while (ptr[index] != '/')
		rr_info->type1[index] = ptr[index++];
	rr_info->type1[index] = '\0';
	
	index = 0;
	ptr = (char *)strstr (ptr, "/");
	ptr = &ptr[1];
	while (ptr[index] != '/')
		rr_info->type2[index] = ptr[index++];
	rr_info->type2[index] = '\0';
	
	index = 0;
	ptr = (char *)strstr (ptr, "/");
	ptr = &ptr[1];
	while (ptr[index] != '\0')
		rr_info->mapping[index] = ptr[index++];
	rr_info->mapping[index] = '\0';
}

int generate_sequence_number (void)
{
	struct timeb current_time;
	ftime (&current_time);
	return current_time.time;
}

char * parser_reserve_zone_ip (NIC_NAS_INFO * nic_nas_info)
{
	static char reserve_zone[32], buf[32];
	int number_of_netmask = 0;

	bzero (reserve_zone, sizeof (reserve_zone));

	while (number_of_netmask++ < 4)
		if (parser_ip_string (nic_nas_info->ifconfig.netmask, number_of_netmask) != 255)
			break;

	while (--number_of_netmask)
	{
		bzero (buf, sizeof (buf));
		sprintf (buf, "%d", parser_ip_string (nic_nas_info->ifconfig.ipaddr, number_of_netmask));
		strcat (reserve_zone, buf);
		strcat (reserve_zone, ".");
	}
	return reserve_zone;
}

int generate_reserve_zone (ZONE_INFO * zone_info)
{
	NIC_NAS_INFO nic_nas_info;
	bzero (&nic_nas_info, sizeof (nic_nas_info));

	NIC_Get_Info_From_uLinux (&nic_nas_info, NIC_WAN);
	sprintf (zone_info->zone_name, "%sin-addr.arpa", parser_reserve_zone_ip (&nic_nas_info));
	sprintf (zone_info->zone_type, "master");
	sprintf (zone_info->zone_file, "%s.rev", zone_info->zone_name);
	return 0;
}

int parser_ip_string (char * ip, int index)
{
	char * ptr = ip;

	if (!strcmp (ip, ""))
		return 0;

	while (--index)
	{
		ptr = (char *)strchr (ptr, '.');
		if (ptr)
			ptr += 1;
		else
			return 0;
	}
	return atoi (ptr);
}

int conver_rr_to_reserve (RESOURCE_RECORD * rr_buf, RESOURCE_RECORD * rr_info)
{
	if (strcmp (rr_buf->type2, "A"))
		return 1;	//  tye type must be "A"

	//  canvert input
	if (rr_buf->name[strlen (rr_buf->name) - 1] == '.')
		strcpy (rr_info->mapping, rr_buf->name);
	else
	{
		if (!strcmp (rr_buf->name, ""))
			sprintf (rr_info->mapping, "%s.", get_domain_name ());
		else
			sprintf (rr_info->mapping, "%s.%s.", rr_buf->name, get_domain_name ());
	}
	strcpy (rr_info->type1, rr_buf->type1);
	strcpy (rr_info->type2, "PTR");
	sprintf (rr_info->name, "%d.%d.%d.%d.in-addr.arpa.", 
		parser_ip_string (rr_buf->mapping, 4), 
		parser_ip_string (rr_buf->mapping, 3), 
		parser_ip_string (rr_buf->mapping, 2), 
		parser_ip_string (rr_buf->mapping, 1));
	return 0;
}
