#include	<stdio.h>
#include	<stdlib.h>
#include 	<config.h>

#include	<cfg_dns.h>
#include	"dns_zone.h"

int main (int argc, char * argv[])
{
	CONF_FILE_INFO conf_file_info;
	char buf[256];
	int result = 0;
	
	memset (&conf_file_info, '\0', sizeof (conf_file_info));
	memset (buf, '\0', sizeof (buf));
	
	if (get_which_page () == 0)
	{
		memset (buf, '\0', sizeof (buf));
		Get_Server_Name (buf, sizeof (buf));

		strcpy (conf_file_info.conf_file_name, get_conf_file_name ());
		strcpy (conf_file_info.NAS_name, buf);
		strcpy (buf, get_domain_name ());
		if (!strcmp (buf, ""))
			return 1;	// can't get domain name from uLinux.conf
		strcpy (conf_file_info.local_zone_name, buf);
		conf_file_info.behind_firewall = 0;

		create_cache_only (&conf_file_info);
		result = 0;
	}
	else
	{
		switch (get_ns_type ())
		{
		case E_Master:
			memset (buf, '\0', sizeof (buf));
			Get_Server_Name (buf, sizeof (buf));
        
			strcpy (conf_file_info.conf_file_name, get_conf_file_name ());
			strcpy (conf_file_info.NAS_name, buf);
			strcpy (conf_file_info.local_zone_name, get_domain_name ());
			conf_file_info.behind_firewall = 0;
        
			create_master_ns (&conf_file_info);
			result = 0;
			break;
			
		case E_Slave:
			memset (buf, '\0', sizeof (buf));
			Get_Server_Name (buf, sizeof (buf));
        
			strcpy (conf_file_info.conf_file_name, get_conf_file_name ());
			strcpy (conf_file_info.NAS_name, buf);
			strcpy (conf_file_info.local_zone_name, get_domain_name ());
			conf_file_info.behind_firewall = 0;
        
			create_slave_ns (&conf_file_info);
			result = 0;
			break;
			
		case E_Cache:
			memset (buf, '\0', sizeof (buf));
			Get_Server_Name (buf, sizeof (buf));
        
			strcpy (conf_file_info.conf_file_name, get_conf_file_name ());
			strcpy (conf_file_info.NAS_name, buf);
			strcpy (conf_file_info.local_zone_name, get_domain_name ());
			conf_file_info.behind_firewall = 0;
        
			create_cache_only (&conf_file_info);
			result = 0;
			break;
			
		default:
			result = -1;
			break;
		}
	}
	exit (result);
}