#!/bin/bash

SETSID=/usr/bin/setsid
DHCP_PIDFILE=/var/run/dhcpcd.sh.pid

stop_old_dhcpcd()
{
	TMP_FILE=/var/run/dhcpcd.tmp
	# kill all
	if [ -f $DHCP_PIDFILE ]; then
		/bin/rm -f $TMP_FILE
		while read LINE
		do
			DHCP_PID=`/bin/echo "$LINE" | /sbin/cut -f 1 -d " "`
			SH_DEV=`/bin/echo "$LINE" | /sbin/cut -f 2 -d " "`
			if [ "$1" = "" -o "$1" = "$SH_DEV" ]; then
				/bin/echo "Killing dhcpcd.sh ($DHCP_PID)"
				/bin/kill $DHCP_PID 2>/dev/null 1>/dev/null
			else
				/bin/echo $LINE >> $TMP_FILE
			fi
		done < $DHCP_PIDFILE

		/bin/rm -f $DHCP_PIDFILE
		if [ "$1" != "" ]; then
			/bin/mv $TMP_FILE $DHCP_PIDFILE
		fi
	fi
}

write_hosts()
{
        $SETSID /bin/echo "127.0.0.1		localhost		localhost" > /etc/hosts
        $SETSID /bin/echo "`/sbin/nic_getinfo ppp0 ip`		`/bin/hostname`		`/bin/hostname`" >> /etc/hosts
        landev=`/sbin/getcfg "Network" Interface1 -d eth0`
        $SETSID /bin/echo "`/sbin/nic_getinfo $landev ip`		`/bin/hostname`		`/bin/hostname`" >> /etc/hosts
}

add_dns()
{
	/bin/cp /etc/resolv.conf /etc/resolv.bak -f
        NAS_DNS=`/sbin/getcfg "Network" DNS -d 0.0.0.0`
        if [ "$NAS_DNS" != "0.0.0.0" ]; then
                /bin/echo "nameserver $NAS_DNS" >> /etc/resolv.conf
        fi
	NAS_DNS1=`/sbin/getcfg "Network" "Domain Name Server 2" -d 0.0.0.0`
        if [ "$NAS_DNS1" != "0.0.0.0" ]; then
		/bin/mv /etc/resolv.conf /etc/resolv.conf.tmp
                /bin/echo "nameserver $NAS_DNS1" >> /etc/resolv.conf
		/bin/cat /etc/resolv.conf.tmp >> /etc/resolv.conf
		/bin/rm /etc/resolv.conf.tmp
        fi
	NAS_DNS2=`/sbin/getcfg "Network" "Domain Name Server 1" -d 0.0.0.0`
        if [ "$NAS_DNS2" != "0.0.0.0" ]; then
		/bin/mv /etc/resolv.conf /etc/resolv.conf.tmp
                /bin/echo "nameserver $NAS_DNS2" >> /etc/resolv.conf
		/bin/cat /etc/resolv.conf.tmp >> /etc/resolv.conf
		/bin/rm /etc/resolv.conf.tmp
        fi

#Shone mark this line 'cause this action seems to be a little bit meaningless
#	/bin/cat /etc/resolv.bak >> /etc/resolv.conf
}

refresh_lcd()
{
	$SETSID /bin/kill -HUP `/bin/pidof sysmond` 2>/dev/null 1>/dev/null
}

restart_dhcp_server()
{
	if [ `/sbin/getcfg "DHCP Server" Enable -u -d FALSE` = TRUE ]; then
		$SETSID /etc/init.d/dhcpd.sh restart
	fi
}

restart_nat()
{
	if [ `/sbin/getcfg NAT Support -u -d FALSE` = TRUE ]; then
		$SETSID /sbin/init_fw
	fi
}

dhcpcd_connect()
{
	refresh_lcd
	write_hosts
	add_dns
	restart_dhcp_server
	restart_nat
	/etc/init.d/smb restart
	if [ "$1" = "lcdrefresh" ]; then
		/sbin/lcd_disp -C -R
	fi
}

# change a 8 byte-long IP to xxx.xxx.xxx.xxx format
ip_base_change()
{
	let x=0x`/bin/echo $1 | /sbin/cut -c 7-8`
	byte1=`/bin/echo $x`
	let x=0x`/bin/echo $1 | /sbin/cut -c 5-6`
	byte2=`/bin/echo $x`
	let x=0x`/bin/echo $1 | /sbin/cut -c 3-4`
	byte3=`/bin/echo $x`
	let x=0x`/bin/echo $1 | /sbin/cut -c 1-2`
	byte4=`/bin/echo $x`
	OUT_IP=$byte1.$byte2.$byte3.$byte4
}
	
reorder_router_table()
{
	if [ `/sbin/getcfg Network "BONDING Support" -u -d FALSE` = FALSE -o `/sbin/getcfg Network "Switch Support" -u -d FALSE` = FALSE ]; then
		return
	fi
	if [ `/sbin/getcfg eth0 "Bonding" -u -d FALSE` = STANDALONE ]; then
		return
	fi

	# read original routing table to "/tmp/nasroute.$1"
	/bin/cat /proc/net/route | /bin/sed '/^Iface/d' > /tmp/nasroute.$1

	# bonding routing entries only
	/bin/sed '/eth2/d' /tmp/nasroute.$1 > /tmp/bond0.$1

	# eth2 routing entries only
	/bin/sed '/bond0/d' /tmp/nasroute.$1 > /tmp/eth2.$1

	while read LINE
	do
		interface=`/bin/echo $LINE | /sbin/cut -f 1 -d " "`
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 2 -d " "`
		dest=$OUT_IP
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 3 -d " "`
		gateway=$OUT_IP
		flag=`/bin/echo $LINE | /sbin/cut -f 4 -d " "`
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 8 -d " "`
		netmask=$OUT_IP

		# flag is net (1) or gateway (3) or host (5) ?
		if [ $flag = 0001 ]; then
			/sbin/route del -net $dest netmask $netmask $interface
		elif [ $flag = 0003 ]; then
			/sbin/route del default gw $gateway $interface
		else 
			/sbin/route del -host $dest $interface
		fi
	done < /tmp/nasroute.$1
	/bin/rm /tmp/nasroute.$1

	# add new routing entries
	# switch (eth2) first
	while read LINE
	do
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 2 -d " "`
		dest=$OUT_IP
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 3 -d " "`
		gateway=$OUT_IP
		flag=`/bin/echo $LINE | /sbin/cut -f 4 -d " "`
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 8 -d " "`
		netmask=$OUT_IP

		if [ $flag = 0001 ]; then
			/sbin/route add -net $dest netmask $netmask eth2
		elif [ $flag = 0003 ]; then
			/sbin/route add default gw $gateway netmask $netmask eth2
		else 
			/sbin/route add -host $dest eth2
		fi
	done < /tmp/eth2.$1
	/bin/rm /tmp/eth2.$1

	# bond0 last
	while read LINE
	do
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 2 -d " "`
		dest=$OUT_IP
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 3 -d " "`
		gateway=$OUT_IP
		flag=`/bin/echo $LINE | /sbin/cut -f 4 -d " "`
		ip_base_change `/bin/echo $LINE | /sbin/cut -f 8 -d " "`
		netmask=$OUT_IP

		if [ $flag = 0001 ]; then
			/sbin/route add -net $dest netmask $netmask bond0
		elif [ $flag = 0003 ]; then
			/sbin/route add default gw $gateway netmask $netmask bond0
		else 
			/sbin/route add -host $dest bond0
		fi
	done < /tmp/bond0.$1
	/bin/rm /tmp/bond0.$1
}


stop_old_dhcpcd $3

case "$1" in
	start)
		/bin/echo $$ $3 >> $DHCP_PIDFILE
		if [ "$3" = "" ]; then
			DEV=eth0
			/sbin/ifconfig eth0 0.0.0.0 2>/dev/null 1>/dev/null
	                if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 2 ]; then
	                        DEV=`/sbin/getcfg "Network" "Wan"`
	                fi
	                if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 1 ]; then
	                        DEV=`/sbin/getcfg "Network" "Interface1"`
	                fi
			if [ `/sbin/getcfg Network "BONDING Support" -u -d FALSE` = TRUE ]; then
				bonding_type=`/sbin/getcfg $DEV Bonding -u -d "FAIL OVER"`
				if [ "$bonding_type" != "STANDALONE" ]; then
					DEV=bond0
				fi
			fi
		else
			DEV=$3
		fi

		while [ true ]; do
			# in broadcom driver, if no up and no sleep, 
			# then dhcpcd can't get ip address, I don't know why??
			/sbin/ifconfig $DEV up
			SYSTEM_MODEL=`/sbin/getcfg System Model -u -d NAS-4000`
			# add one item "SLEEP" in network section
			LAN_SLEEP=`/sbin/getcfg Network SLEEP -u -d TEST`
			if [ $LAN_SLEEP = TEST ]; then
				# compatiable previouse 2.x version
				if [ $SYSTEM_MODEL = NAS-4020 -o $SYSTEM_MODEL = NAS-4100 -o $SYSTEM_MODEL = ND-41000 -o $SYSTEM_MODEL = NAS-4030 -o $SYSTEM_MODEL = NAS-4100-PS2 -o $SYSTEM_MODEL = NAS-5100 ]; then
					/bin/sleep 5
				fi
			else
				/bin/sleep $LAN_SLEEP
			fi
			/usr/bin/setsid /sbin/dhcpcd $DEV -t 30 2>/dev/null 1>/dev/null
			if [ `/sbin/nic_getinfo $DEV ip` != "127.0.0.1" ]; then
				if [ "$DEV" = "bond0" ]; then
					bonding1=`/sbin/getcfg Network BONDING01 -u -d Interface1`
					bonding2=`/sbin/getcfg Network BONDING02 -u -d Interface2`
					dev1=`/sbin/getcfg Network $bonding1 -d eth0`
					dev2=`/sbin/getcfg Network $bonding2 -d eth1`
					/sbin/ifconfig $dev1 `/sbin/nic_getinfo $DEV ip`
					/sbin/ifconfig $dev2 `/sbin/nic_getinfo $DEV ip`
					if [ `/sbin/getcfg Network "Interface Number"` = 3 ]; then
						bonding3=`/sbin/getcfg Network BONDING03 -u -d Interface3`
						dev3=`/sbin/getcfg Network $bonding3 -d eth2`
						if [ "`/sbin/getcfg $dev3 Bonding -u -d "FAIL OVER"`" != "STANDALONE" ]; then
							/sbin/ifconfig $dev3 `/sbin/nic_getinfo $DEV ip`
						fi
					fi
				fi
				dhcpcd_connect $2
				reorder_router_table $DEV
				break
			fi
			# if bonding fail, re-bonding again
			if [ `/sbin/getcfg Network "BONDING Support" -u -d FALSE` = TRUE -a "$DEV" = "bond0" ]; then
				bonding1=`/sbin/getcfg Network BONDING01 -u -d Interface1`
				bonding2=`/sbin/getcfg Network BONDING02 -u -d Interface2`
				dev1=`/sbin/getcfg Network $bonding1 -d eth0`
				dev2=`/sbin/getcfg Network $bonding2 -d eth1`
				/bin/kill -SIGUSR1 `/bin/pidof hwmond`
				/sbin/ifconfig bond0 down 2>/dev/null 1>/dev/null
				/sbin/ifconfig bond0 up 2>/dev/null 1>/dev/null
				/sbin/ifconfig $dev1 up
				/sbin/ifconfig $dev2 up
				/sbin/ifenslave bond0 $dev1 2>/dev/null 1>/dev/null
				/sbin/ifenslave bond0 $dev2 2>/dev/null 1>/dev/null
				if [ `/sbin/getcfg Network "Interface Number"` = 3 ]; then
					bonding3=`/sbin/getcfg Network BONDING03 -u -d Interface3`
					# *** Catherine modified ==>
					dev3=`/sbin/getcfg Network $bonding3 -d eth2`
					if [ "`/sbin/getcfg $dev3 Bonding -u -d "FAIL OVER"`" != "STANDALONE" ]; then
						/sbin/ifconfig $dev3 up
						/sbin/ifenslave bond0 $dev3 2>/dev/null 1>/dev/null
					fi
					# *** <== Catherine modified
				fi
				/bin/kill -SIGUSR1 `/bin/pidof hwmond`
			fi
			# in one NIC, if dhcp fail, use default IP address
			if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 1 ]; then
				if [ `/sbin/getcfg $DEV Configure -u -d FALSE` = FALSE ]; then
					/sbin/ifconfig $DEV `/sbin/getcfg $DEV "IP Address" -u -d "192.168.0.1"` up
					/sbin/route add -host 255.255.255.255 $DEV
					break;
				fi
			fi
		done
        ;;
	stop)
		DEV=eth0
		if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 2 ]; then
			DEV=`/sbin/getcfg "Network" "Wan"`
		fi
		if [ `/sbin/getcfg "Network" "Interface Number" -u -d 1` = 1 ]; then
			DEV=`/sbin/getcfg "Network" "Interface1"`
		fi
        	/sbin/ifconfig $DEV down
#		if [ -e /var/run/dhcpcd*.pid ]; then
	        	/bin/rm /var/run/dhcpcd*.pid -f 2>/dev/null 1>/dev/null
#		fi
        	/bin/kill -9 `/bin/pidof /sbin/dhcpcd` 2>/dev/null 1>/dev/null
        ;;
	restart)
		$0 stop
		$0 start
        ;;
	*)
		echo "Usage: /etc/init.d/dhcpcd.sh {start|stop|restart}"
		exit 1
esac

exit 0

