//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		ddns_main.c
//
//	Abstract:
//		DDNS main cgi
//
//	FUNCTIONS:
//
//	COMMENTS:
//
//	HISTORY:
//		V1.0 2001/08/09		Tiger Fu created
//
//**************************************************************************
#include 	<stdio.h>
#include 	<string.h>
#include 	<stdlib.h>

/* NAS lib */
#include	<Util.h>
#include	<cgi.h>
#include	<cfg_nic.h>
#include	<cfg_ddns.h>
#include 	<v2_menu.h>

#include 	"ddns_main.h"

#define		ERROR_PAGE				"/home/httpd/cgi-bin/dns/html/errormsg.html"

#define		TITLE_PAGE				"/home/httpd/cgi-bin/network/ddns_setting/html/templet_ddns_title.html"
#define		MAIN_PAGE				"/home/httpd/cgi-bin/network/ddns_setting/html/templet_ddns_main.html"
#define		TAIL_PAGE				"/home/httpd/cgi-bin/network/ddns_setting/html/templet_ddns_tail.html"

//modified by jeffrey hsieh
char *szDefineFilePath[] = {"/home/httpd/cgi-bin/network/network.def"};
/*
char *szDefineFilePath[] = {"/home/httpd/cgi-bin/network/network-2.def",
			    "/home/httpd/cgi-bin/network/network-2.nodns.def",
			    "/home/httpd/cgi-bin/network/network-2.noprn.def",
			    "/home/httpd/cgi-bin/network/network-2.noprndns.def"};
end*/
int main ()
{
	INPUT	*arg=NULL, *form=NULL;
	int	func, ret;

	CGI_Init();
	CGI_Check_User ();

	arg=(INPUT *)CGI_Get_Input_URL();
	form=(INPUT *)CGI_Get_Input_FORM();

#ifdef _DEBUG
	CGI_Debug_Input(arg);
	CGI_Debug_Input(form);
#endif
	func = get_ddns_func(arg);
#ifdef _DEBUG
	printf ("func = %d<br>\n", func);
#endif
	switch (func)
	{
		case DDNSMAIN:
			show_ddns_main ();
			break;

		case DDNSOK:
			if ((ret = ddns_submit (form)) == 0)
				show_ddns_main ();
			else
			{
				if (ret < 0)
					show_ddns_error (DDNS_ERROR_WRITING);
				else
					show_ddns_error (ret);
			}
			break;

		case DDNSNOFUNC:
			break;
	}

	CGI_Free_Input(arg);
	CGI_Free_Input(form);

	return DDNSSUCCESS;
}

int get_ddns_func (INPUT *arg)
{
	int	ret = DDNSNOFUNC;
	INPUT	*parg;
	parg=arg;
	while (parg!=NULL)
	{
		if (!strcmp (parg->name, "func"))
		{
			if (!strcmp (parg->val, "main"))
				ret = DDNSMAIN;
			else if (!strcmp (parg->val, "OK"))
				ret = DDNSOK;
			break;
		}
		parg=(INPUT *)parg->next;
	}
	return ret;
}

int ddns_replace(FILE * fp, char * oldstr)
{
	char buf[DDNS_MAX_BUF_SIZE];
	if (fp == NULL)
		return -1;

	if (!strcmp (oldstr, "ddns_operate"))
	{
		if (Is_DDNS_Enable ())
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "user_name"))
	{
		if (Get_DDNS_User_Name (buf, DDNS_MAX_BUF_SIZE))
			fprintf (fp, "%s", buf);
	}
	else if (!strcmp (oldstr, "password"))
	{
		if (Get_DDNS_User_Password (buf, DDNS_MAX_BUF_SIZE))
			fprintf (fp, "%s", buf);
	}
	else if (!strcmp (oldstr, "host_name"))
	{
		if (Get_DDNS_Host (buf, DDNS_MAX_BUF_SIZE))
			fprintf (fp, "%s", buf);
	}
	else if (!strcmp (oldstr, "wildcard"))
	{
		if (Is_Wildcard_Support () == 1)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "mail_exchanger"))
	{
		if (Get_DDNS_MX (buf, DDNS_MAX_BUF_SIZE))
			fprintf (fp, "%s", buf);
	}
	else if (!strcmp (oldstr, "backmx"))
	{
		Get_DDNS_MX (buf, DDNS_MAX_BUF_SIZE);
		if (strcmp (buf, ""))
		{
			if (Is_DDNS_BackupMX () == 1)
				fprintf (fp, "checked");
		}
		else
			DDNS_BackupMX (0);
	}
	else if (!strcmp (oldstr, "danymic"))
	{
		if (Get_DDNS_Type () == DDNS_DYNAMIC)
			fprintf (fp, "checked");
	}
	else if (!strcmp (oldstr, "static"))
	{
		if (Get_DDNS_Type () == DDNS_STATIC)
			fprintf (fp, "checked");
	}
	// added by YC
	else if (!strcmp (oldstr, "dyndns_selected"))
	{
		fprintf(fp, "%s", (Get_DDNS_Server () == DYNDNS)?"selected":"");
	}
	else if (!strcmp (oldstr, "obs_selected"))
	{
		fprintf(fp, "%s", (Get_DDNS_Server () == OBS)?"selected":"");
	}
	else if (!strcmp (oldstr, "dns_selected"))
	{
		fprintf(fp, "%s", (Get_DDNS_Server () == DNS)?"selected":"");
	}
	else if (!strcmp (oldstr, "dyns_selected"))
	{
		fprintf(fp, "%s", (Get_DDNS_Server () == DYNS)?"selected":"");
	}
	// end adding by YC

	else if (!strcmp (oldstr, "web_side"))
	{
		fprintf (fp, "%s", serverinfo[Get_DDNS_Server ()].Web_Side);
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}


int ddns_submit (INPUT * form)
{
	INPUT *pform;
	int operate = 0, wildcard = 0, backmx = 0, set_backmx_to_disable = 0;
	int ret = 0;
	struct DDNS_Information ddns_info;

	Get_DDNS_Info (&ddns_info);

	pform=form;
	while (pform!=NULL)
	{
		if (!strcmp (pform->name, "DDNSOperate"))
		{
 			ddns_info.Enable = ENABLE_DDNS;
 			operate = 1;
		}
		else if (!strcmp (pform->name, "UserName"))
		{
			strcpy (ddns_info.UserName, pform->val);
		}
		else if (!strcmp (pform->name, "Password"))
		{
			strcpy (ddns_info.Password, pform->val);
		}
		else if (!strcmp (pform->name, "HostName"))
		{
			strcpy (ddns_info.HostName, pform->val);
		}
		else if (!strcmp (pform->name, "Wildcard"))
		{
			ddns_info.Wildcard = ENABLE_DDNS;
			wildcard = 1;
		}
		else if (!strcmp (pform->name, "MailExchanger"))
		{
			strcpy (ddns_info.MailExchanger, pform->val);
			if (!strcmp (ddns_info.MailExchanger, ""))
				set_backmx_to_disable = 1;
		}
		else if (!strcmp (pform->name, "BackupMX"))
		{
			ddns_info.BackupMX = ENABLE_DDNS;
			backmx = 1;
		}
		else if (!strcmp (pform->name, "DDNS_Type"))
		{
			if (!strcmp (pform->val, "STATIC"))
				ddns_info.DDNS_Type = DDNS_STATIC;
			else
				ddns_info.DDNS_Type = DDNS_DYNAMIC;
		}
		else if (!strcmp (pform->name, "ddns_server"))
		{
				ddns_info.DDNS_Server = atoi(pform->val);
		}
		pform=(INPUT *)pform->next;
	}

	if (!wildcard)
		ddns_info.Wildcard = DISABLE_DDNS;

	if (!operate)
		ddns_info.Enable = DISABLE_DDNS;

	if (!set_backmx_to_disable)
	{
		if (!backmx)
			ddns_info.BackupMX = DISABLE_DDNS;
	}
	else
		ddns_info.BackupMX = DISABLE_DDNS;
	ret = Set_DDNS_Info (&ddns_info);
	return ret;

}

void show_ddns_title (void)
{
	int type = 0;
	HEADER_ITEM	header;

	bzero (&header, sizeof (header));
	header.back[0] = 0x0;
	header.home[0] = 0x0;
	header.logout[0] = 0x0;

	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_ddns_main");
	else
		CGI_Get_Help(header.help, "network_ddns_main.html");

	CGI_Output_Html (TITLE_PAGE, "$", ddns_replace);

	CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", NULL, NULL);
	CGI_Show_Menu_V3_2(szDefineFilePath[type], 9);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", NULL, NULL);
}

void show_ddns_tail (void)
{
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", NULL, NULL);
	CGI_Output_Html (TAIL_PAGE, "$", ddns_replace);
}

void show_ddns_main (void)
{
	show_ddns_title ();
	CGI_Output_Html (MAIN_PAGE, "$", ddns_replace);
	show_ddns_tail ();
}

void show_ddns_error (int error_code)
{
	FILE * fp = NULL;
	char buf[32];
	ERRMSG errormsg;
	bzero (buf, sizeof (buf));

	show_ddns_title ();

	errormsg.type = CGI_ERROR;
	sprintf (errormsg.title, "NIC_DEF_STR14");
	sprintf (errormsg.msg, "DDNS_ERROR_STR%d", abs (error_code));
	/*if (error_code == DDNS_ERROR_INTERNAL_FAIL)
	{
		fp = fopen ("/tmp/ddns_internal_error.report", "r");
		if (fp)
		{
			fgets (buf, sizeof (buf), fp);
			fclose (fp);
		}
		sprintf (errormsg.note, "t%s", buf);
	}
	else*/
	strcpy (errormsg.note, "");
	CGI_Show_Error_V3 (&errormsg);

	show_ddns_tail ();
}

int get_def_type (void)
{
	return 0;
}
