//**************************************************************************
//
//      Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//      FILE:
//              logo.c
//
//      Abstract:
//              MISC.cgi for LOGO configuration Access Functions.
//
//      FUNCTIONS:      TBD.
//
//      COMMENTS:       N/A
//
//      HISTORY:
//      12/26/2002      John Shiau created
//      
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/stat.h>
#include <sys/types.h>



#include <uLinux.h>
#include <cgi.h>
#include <config.h>
#include <v2_menu.h>
#include <Util.h>
#include <NAS.h>
#include <cfg_save_restore.h>
#include <cfg_logo.h>
#include <cfg_system.h>

#include "misc.h"
#include "logo.h"

int logo_replace(FILE *fp, char *src);
int upload_logo_file_new(INPUT* input);
void logo_replace_show_button_check(INPUT* input);
LOGO_RET_STAT *logo_check_file_size_new(char *logo_tmp_dir, char *filename);

// filled the real preview path instead of the parameters on HTML file 
int logo_replace(FILE *fp, char *src)
{	
	int i;
	int idx = 0;
	
	char str[PIC_INDEX+1][BUF_STR_LEN];
	char	pic[PATH_STR_LEN];
	
	idx=LOGO_Get_Index();
	for (i = 0; i <= PIC_INDEX; i++)
	{
		if (i == idx)
			strcpy(str[i], " selected"); //detect which item was chose by the user
		else
			strcpy(str[i], " ");		
	}
	
	// replace the preview path
	if (!strcmp(src,"LOGO_PREVIEW_IMG_UPLOAD"))
	{
		LOGO_Get_Preview_PIC(pic, BUF_STR_LEN, 0);
		fprintf(fp, pic);
	}
	else
	if (!strcmp(src,"LOGO_PREVIEW_IMG_PIC1"))
	{
		LOGO_Get_Preview_PIC(pic, BUF_STR_LEN, 1);
		fprintf(fp, pic);
	}
	else
	if (!strcmp(src,"LOGO_PREVIEW_IMG_PIC2"))
	{
		LOGO_Get_Preview_PIC(pic, BUF_STR_LEN, 2);
		fprintf(fp, pic);
	}
	else 
	if (!strcmp(src,"LOGO_PREVIEW_IMG_PIC3"))
	{
                LOGO_Get_Preview_PIC(pic, BUF_STR_LEN, 3);
                fprintf(fp, pic);
	}
	else
	if (!strcmp(src,"LOGO_PREVIEW_IMG_PIC4"))
	{
                LOGO_Get_Preview_PIC(pic, BUF_STR_LEN, 4);
                fprintf(fp, pic);
	}
	else
	if (!strcmp(src,"LOGO_PREVIEW_IMG_PIC5"))  //pic5 <-> twin system LOGO
	{
                LOGO_Get_Preview_PIC(pic, BUF_STR_LEN, 5);
                fprintf(fp, pic);
	}
	else
	// replace the parameter which was chose by the user
	if (!strcmp(src,"LOGO_P0"))
		fprintf(fp, str[0]);
	else
	if (!strcmp(src,"LOGO_P1"))
		fprintf(fp, str[1]);
	else 
	if (!strcmp(src,"LOGO_P2")) 
		fprintf(fp, str[2]);	
	else 
	if (!strcmp(src,"LOGO_P3")) 
		fprintf(fp, str[3]);	
	else 
	if (!strcmp(src,"LOGO_P4")) 
		fprintf(fp, str[4]);	
	else 
	if (!strcmp(src,"LOGO_PU")) // pic5 <-> twin system LOGO
		fprintf(fp, str[5]);	
	else 
		return CGI_REPLACE_FAIL;		
	
     return CGI_REPLACE_OK;
}

//upload customize LOGO file
int upload_logo_file_new(INPUT* input)
{
	char src_name[1024];
	char *logo_update_dir = NULL;
	int  logo_ret = 0;
	int  counter;
	char buf[256], new[1024], command[1024];
	char pic[1024];
	int  hd_init_flag;

	//use HD for working space at first; if it can't use, use RAM disk.
	if ((logo_update_dir = create_update_working_directory(&hd_init_flag)) == NULL) {
		return -1; //error
	}

	counter=LOGO_Get_Counter();
	snprintf(buf, 256, UPLOAD_LOGO_IMG, counter+1);
	if (CGI_Upload(logo_update_dir, buf, src_name)==CGI_SUCCESS && (logo_check_file_size_new(logo_update_dir, buf)->RET_VAL==1))
	{
		// 1.clear previous upload image
		// 2.copy new upload image to /home/httpd/v2_menu/image
		LOGO_Remove(0);

		sprintf(new, "%s/%s", logo_update_dir, buf);
		chmod(new, S_IRWXU | S_IRWXG | S_IROTH);
		sprintf(command, "/bin/cp -f %s %s/%s %s", new, FLASH_IMG_LOC, buf, DEVNULL);
		system(command);
		sprintf(command, "/bin/cp -f %s /home/httpd%s/%s %s", new, HTTPD_IMG_LOC, buf, DEVNULL);
		system(command);
		sprintf(command, "%s/%s", FLASH_IMG_LOC, buf);
		LOGO_Set_PIC(command, 0);
		LOGO_Set_Counter(counter+1);
	    if ( LOGO_Get_Index() == 5) {
		//when index=5 (user use upload image to be system LOGO)
		//re-setup pic5 <BEGIN> (pic5 -> twin show image)
		LOGO_Remove(5);				
		counter=LOGO_Get_Counter();
		snprintf(buf, 1024, LOGO_IMG, counter+1);
		sprintf(pic, "%s/%s", FLASH_IMG_LOC, buf);
		LOGO_Set_PIC(pic, 5);
		LOGO_Set_Counter(counter+1);
		LOGO_Start();
		//re-setup pic5 <END>
        }		
		
		clear_update_tmp_data();  // clear the working space    					
		return logo_ret; //success
	}
	else	{
		clear_update_tmp_data(); // clear the working space    
		logo_ret = -1; //failure
	}
	return logo_ret;	
}

//check the "LOGO_REPLACE_PIC_BUTTON" and "LOGO_SHOW_PIC_BUTTON" select object of HTML file is enabled or disabled
void logo_replace_show_button_check(INPUT* input)
{
        INPUT	*tmp;
	int	index = -1;
	int	counter;
	char	buf[1024], pic[1024];
	
	if((tmp = CGI_Find_Parameter(input, "LOGO_REPLACE_PIC_BUTTON")) != NULL)
	{
		index=atoi(tmp->val);
		if (index!=0)
		{
			LOGO_Remove(index);
			LOGO_Replace_PIC();
			counter=LOGO_Get_Counter();
			snprintf(buf, 1024, LOGO_IMG, counter+1);
			sprintf(pic, "%s/%s", FLASH_IMG_LOC, buf);
			LOGO_Set_PIC(pic, index);
			LOGO_Set_Counter(counter+1);
		}
	}						
    // pic5 (twin system LOGO) need re-setup
    // 1. replace upload pic to pic1~4 and LOGO_IDX = replace pic
    // 2. SHOW_LOGO re-setup by pic1~4
	if ( ((tmp = CGI_Find_Parameter(input, "LOGO_SHOW_PIC_BUTTON")) != NULL) || (index == LOGO_Get_Index()) ) {
		if ((tmp = CGI_Find_Parameter(input, "LOGO_SHOW_PIC_BUTTON")) != NULL)			
			LOGO_Set_Index(tmp->val);
			
		//re-setup pic5 <BEGIN> (pic5 -> twin show image)
		
		LOGO_Remove(5);					
		counter=LOGO_Get_Counter();
		snprintf(buf, 1024, LOGO_IMG, counter+1);
		sprintf(pic, "%s/%s", FLASH_IMG_LOC, buf);
		LOGO_Set_PIC(pic, 5);
		LOGO_Set_Counter(counter+1);
		//resetup pic5 <END>
		LOGO_Start();
	}		
}

//compare upload filesize and "LOGO Image Size Limitation" field of LOGO session
LOGO_RET_STAT *logo_check_file_size_new(char *logo_tmp_dir, char *filename)
{
	LOGO_RET_STAT *logo_status = NULL;
	static LOGO_RET_STAT logo_stat;		
	struct stat logo_info;	
	char logo_tmp_dir_copy[1024]="";
	int logo_ret_size = -1;
	int logo_ret_info = -1;
	double logo_get_size = 0;
	double logo_file_size = 0;
	char logo_temp_path[PATH_STR_LEN]="";
	char logo_get_result[BUF_STR_LEN]="";
        
	logo_stat.RET_VAL = -1;     // initial return value
	logo_info.st_size = 0;      // initial stat structure buffer filesize = 0
	logo_status = &logo_stat;
	strcpy(logo_temp_path, CONFIG_FILE_PATH);  	
	strcat(logo_temp_path, "/");
        strcat(logo_temp_path, CONFIG_FILE_NAME);	
	logo_ret_size = Conf_Get_Field(logo_temp_path, LOGO_SESSION_NAME, LOGO_IMG_LIMIT_FIELD, logo_get_result, sizeof(logo_get_result));
	logo_get_size = atof(logo_get_result);
  
	strcpy(logo_tmp_dir_copy, logo_tmp_dir);
	strcat(logo_tmp_dir_copy,"/");
//	strcat(logo_tmp_dir_copy, UPLOAD_IMG);  		
	strcat(logo_tmp_dir_copy, filename);
	logo_ret_info = stat(logo_tmp_dir_copy, &logo_info);

	logo_file_size = logo_info.st_size;

	if ((logo_ret_info == 0) && (logo_ret_size == 0))  {
		logo_stat.RET_UPLOAD_SIZE = logo_file_size; //store the upload size
		logo_stat.RET_ULINUX_SIZE = logo_get_size; //store the system limitation size
		if (logo_file_size < logo_get_size) {
			logo_stat.RET_VAL = 1; //legal, upload size < system limitation
			return (logo_status); //return the result structure
		}
		else {
			logo_stat.RET_VAL = 0; //illegal, upload size > system limitation
			return (logo_status); //return the result structure
		}
	}	
	logo_stat.RET_VAL = -1;	//error
	return (logo_status); //return the result structure
}

int do_logo_main(INPUT* input, int select)
{
	show_misc_header(input, select);
	CGI_Output_Html(LOGO_MAIN_HTML, "$", logo_replace);
	show_misc_tail();
	return MISC_SUCCESS;
}	
int do_logo_main_submit(INPUT* input)
{
	int btn, ret = MISC_SUCCESS;
	btn = get_btn(input);
	switch(btn)
	{
		case MISC_BTN_LOGO:			
			logo_replace_show_button_check(input);	
			do_logo_main(input, SELECT_LOGO);
			break;
		default:
			ret = upload_logo_file_new(input);			
			if (!ret)
				do_logo_main(input, SELECT_LOGO);
			else 
				ret = MISC_LOGO_UPLOAD_ERROR;	
			break;
	}	
			
	return ret;
}
	
