#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


#include <uLinux.h>
#include <cgi.h>
#include <config.h>
#include <v2_menu.h>
#include <Util.h>
#include <NAS.h>

#include <cfg_system.h>
#include "config.h"
#include "sysmgrd.h"
#include "msgeng.h"
#include "misc.h"
#include "hardware.h"
#include "storage.h"
#include "qnap_pic_user.h"

char *stbtime[MAX_STBTIME_NO]=
	{// unit: minute 
		"5",
		"10",
		"15",
		"20",
		"30",
		"60",
		"120",
		"180",
		"240",
		"300" 
	};


extern int  SendMessage(const char *progname, int message, unsigned long parm1, unsigned long parm2);

int is_buzzer_enabled()
{
	return Get_Profile_Boolean(MISC_SECTION, MISC_KEYNAME_BUZZER, TRUE);
}

int get_disk_standby_timeout_enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(MISC_SECTION, MISC_KEYNAME_DISK_TIMEOUT_ENABLE, "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

int set_disk_standby_timeout_enabled(int bEnable)
{
	int val, ret = SUCCESS;
	val = WriteProfileString(MISC_SECTION, MISC_KEYNAME_DISK_TIMEOUT_ENABLE, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;

	return ret;
}	

int get_disk_standby_timeout()
{
	return Get_Profile_Integer(MISC_SECTION, MISC_KEYNAME_DISK_TIMEOUT, 0);
}	

int set_disk_standby_timeout(int value)
{
	return Set_Profile_Integer(MISC_SECTION, MISC_KEYNAME_DISK_TIMEOUT, value);
}	

int set_buzzer_enable(int value)
{
	return Get_Profile_Integer(MISC_SECTION, MISC_KEYNAME_BUZZER, value);
}	

int is_auto_power_enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_SYSTEM_SECTION, SZ_AUTO_POWER_ON_FIELD, "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

int enable_auto_power(int bEnable)
{
	int val;

	val = WriteProfileString(SZ_SYSTEM_SECTION, SZ_AUTO_POWER_ON_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;
	if (bEnable) {	
		Pic_Send_Raw_Cmd(QNAP_PIC_ENABLE_POWER_RECOVERY);
	}
	else {
		Pic_Send_Raw_Cmd(QNAP_PIC_DISABLE_POWER_RECOVERY);
	}
	return SUCCESS;
}

int hardware_replace(FILE* fp, char* str, void* arg)
{
	char	tmp[16];
	
	if (!strcmp(str, "LCD_CHECKED"))
		fprintf(fp, "%s", Is_LCD_Panel_Setting_Control_Enabled()?"checked":"");
	else if (!strcmp(str, "SWITCH_CHECKED"))
		fprintf(fp, "%s", Is_Reset_Password_Switch_Enabled()?"checked":"");
	else if (!strcmp(str, "ALERT_CHECKED"))
		fprintf(fp, "%s", Is_Disk_Free_Size_Alert_Enabled()?"checked":"");
	else if (!strcmp(str, "STANDBY_CHECKED"))
		fprintf(fp, "%s", get_disk_standby_timeout_enabled()?"checked":"");
	else if (!strcmp(str, "BUZZER_CHECKED"))
		fprintf(fp, "%s", is_buzzer_enabled()?"checked":"");
	else if (!strcmp(str, "NETSTOP_CHECKED"))
		fprintf(fp, "%s", is_netstop_enabled()?"checked":"");
	else if ( !strcmp(str, "html_comment_start") ) {
		// Bad notation, should be modified some day...Andy Wu
		// 'cause this standby function doesn't work for SCSI disk.
		Conf_Get_Field("/etc/config/uLinux.conf", "System", "Model", tmp, sizeof(tmp));
		if ( !strcasecmp(tmp, "NAS-5100") || !strcasecmp(tmp, "NAS-5168") )
			fprintf(fp, "<!--");
	} 
	else if ( !strcmp(str, "html_comment_end") ) {
		if ( !strcasecmp(tmp, "NAS-5100") || !strcasecmp(tmp, "NAS-5168") )
			fprintf(fp, "-->");
	}
	 else if ( !strcmp(str, "STBTIME_LIST") ) {
		int i, *standby_time = (int*)arg;
		
		for (i = 0; i < MAX_STBTIME_NO; i++) {
			if (atoi(stbtime[i]) == *standby_time) {
				fprintf(fp, "<OPTION Value=%d SELECTED>\' + IEI_IDS_STRING%d + \'</OPTION>", *standby_time, i+220);
			}
			else {
				fprintf(fp, "<OPTION Value=%d>\' + IEI_IDS_STRING%d + \'</OPTION>", atoi(stbtime[i]), i+220);
			}
		}
	}	
	else if(!strcmp(str, "POWER_SUPPLY_NO")){
/*		int val = get_power_supply_no();
		int idx = 1;

		for(;idx<3;idx++){
			if(val==idx)
				fprintf(fp, "<option value=\"%d\" selected>%d</option>", idx, idx);
			else
				fprintf(fp, "<option value=\"%d\" >%d</option>", idx, idx);
		}*/
	}
	else if ( !strcmp(str, "SIZE") ) {
		fprintf(fp, "%d", Get_Disk_Free_Size_Alert() );
	} 
	else if (!strcmp(str, "AUTOPOWER_CHECKED")){
		if (is_auto_power_enabled()!=0)		
			fprintf(fp, "checked");
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;	
}	

int change_misc_hardware_setting(INPUT* input)
{
	INPUT *p;
	char buf[BUF_SIZE];

	p = (INPUT *) CGI_Find_Parameter(input, "LCD");
		Enable_LCD_Panel_Setting_Control(p?TRUE:FALSE);	
		
	p = (INPUT *) CGI_Find_Parameter(input, "SWITCH");
		Enable_Reset_Password_Switch(p?TRUE:FALSE);
	
	p = (INPUT *) CGI_Find_Parameter(input, "NETSTOP");
		set_netstop_enable(p?TRUE:FALSE);

	if((p = (INPUT *) CGI_Find_Parameter(input, "STANDBY")) != NULL) {
		if((p = (INPUT *) CGI_Find_Parameter(input, "STBTIME")) != NULL) {
			set_disk_standby_timeout( atoi(p->val));
			set_disk_standby_timeout_enabled(1);
			Util_Send_Message(CHANGE_TIMEOUT, NULL, atoi(p->val), NULL);
		}
	}
	else {
		set_disk_standby_timeout_enabled(0);
		sprintf(buf, "%s -a -t %d", MISC_HDSUSPEND, 0);		
		system(buf);
	}
	if((p = (INPUT *) CGI_Find_Parameter(input, "BUZZER")) != NULL) {
		if(!is_buzzer_enabled()) { // if buzzer != true original 
			set_buzzer_enable(TRUE);
			SendMessage("sysmond", MSG_SYSMGR, SYSMGR_BUZZER_NOTIFY, 0);
		}
	}
	else {
		if(is_buzzer_enabled()) { // if buzzer == true original 
			set_buzzer_enable(FALSE);
			SendMessage("sysmond", MSG_SYSMGR, SYSMGR_BUZZER_NOTIFY, 0);
		}
	}
	if((p = (INPUT *) CGI_Find_Parameter(input, "power_support_no")) != NULL){
		/*int no = atoi(p->val);		
		set_power_supply_no(no);*/
	}
	if((p = (INPUT *) CGI_Find_Parameter(input, "ALERT")) != NULL){
		if((p = (INPUT *) CGI_Find_Parameter(input, "SIZE")) != NULL) {
			Set_Disk_Free_Size_Alert(atoi(p->val));
			Enable_Disk_Free_Size_Alert(1);
		}
	}
	else {
		Enable_Disk_Free_Size_Alert(0);
	}
	if((p = (INPUT *) CGI_Find_Parameter(input, "AUTOPOWER")) != NULL) {
		enable_auto_power(1);
	}
	else {
		enable_auto_power(0);
	}
	return 0;
}

int do_hardware_main(INPUT* input, int select)
{
	int time = get_disk_standby_timeout();
	char model[256];
	int ret;
       
	ret = GetPrivateProfileString("System","Model","",model,sizeof(model),"/etc/config/uLinux.conf");
	show_misc_header(input, select);	
	if(!strncmp(model,"NAS-410T",8))
		CGI_Output_Html1(""HARDWARE_MAIN_HTML_NO_STANDBY,"$", hardware_replace, (void*)&time);
	else
		CGI_Output_Html1(HARDWARE_MAIN_HTML,"$", hardware_replace, (void*)&time);
	show_misc_tail();
	return MISC_SUCCESS;
}	

int do_hardware_main_submit(INPUT* input)
{
	int btn,ret = MISC_SUCCESS;
	btn = get_btn(input);
	switch(btn)
	{
		case MISC_BTN_APPLY:
			change_misc_hardware_setting(input);
			break;
	}	
	if (!ret)
		do_hardware_main(input, SELECT_HARD);
	return MISC_SUCCESS;
}	
