#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/wait.h>
#include <pthread.h>
#include <unistd.h>
#include <arpa/inet.h>

#include <cgi.h>
#include <config.h>
#include <v2_menu.h>
#include <NAS.h>
#include <backup.h>
#include <cfg_system.h>
#include "misc.h"
#include "failure.h"
#include "Util.h"
#include "cfg_smtp.h"

//Shone added for transfering Big Endian to Little Endian 2005,09,29
//two bytes use
#define SREV(x) (((x&0xFF)<<8) | ((x>>8)&0xFF))
//four bytes use
#define IREV(x) ((SREV(x)<<16) | (SREV(x>>16)))

int failure_replace(FILE*fp, char* str, void* arg)
{
	char buf[128];
	FAILURE_INFO* info = (FAILURE_INFO*)arg;

	if (!strcmp(str, "PARAMETER_1"))		
		fprintf(fp, "%s", info->level == 2?"checked":"");
	else if (!strcmp(str, "PARAMETER_2"))
		fprintf(fp, "%s", info->level == 1?"checked":"");
	else if (!strcmp(str, "PARAMETER_3"))
		fprintf(fp, "%s", info->level == 0?"checked":"");
	else if (!strcmp(str, "PARAMETER_4"))
		fprintf(fp, "%d", info->ip1);
	else if (!strcmp(str, "PARAMETER_5"))
		fprintf(fp, "%d", info->ip2);
	else if (!strcmp(str, "PARAMETER_6"))
		fprintf(fp, "%d", info->ip3);
	else if (!strcmp(str, "PARAMETER_7"))
		fprintf(fp, "%d", info->ip4);
	else if (!strcmp(str, "PARAMETER_8"))
		fprintf(fp, "%s", info->address1);
	else if (!strcmp(str, "PARAMETER_9"))
		fprintf(fp, "%s", info->address2);
	else if (!strcmp(str, "smtp_auth_checked"))//Shone added 2005,09,29
	{
		if(Is_SMTP_auth_on())
			fprintf(fp, "checked");
		else fprintf(fp, "%s","");
	}
	else if (!strcmp(str, "user_name"))//Shone added 2005,09,29
	{
		if(!Is_SMTP_auth_on())
			fprintf(fp, "%s","");
		else
		{
			Get_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_USER_NAME,"",buf,sizeof(buf));
			fprintf(fp, "%s", buf);
		}
	}
	else if (!strcmp(str, "password"))//Shone added 2005,09,29
	{
		if(!Is_SMTP_auth_on())
			fprintf(fp, "%s","");
		else
		{
			Get_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_PASSWORD,"",buf,sizeof(buf));
			fprintf(fp, "%s", buf);
		}
	}
	else if (!strcmp(str, "user_disabled"))//Shone added 2005,09,29
	{
		if(!Is_SMTP_auth_on())
			fprintf(fp, "disabled");
		else fprintf(fp, "%s","");
	}
	else if (!strcmp(str, "password_disabled"))//Shone added 2005,09,29
	{
		if(!Is_SMTP_auth_on())
			fprintf(fp, "disabled");
		else fprintf(fp, "%s","");
	}
	else 
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;	
}	
//Shone added 2005,09,29
int Is_SMTP_auth_on()
{
	char buf[128];

	Get_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_SMTP_AUTH,"OFF",buf,sizeof(buf));
	if(!strcasecmp(buf,"ON"))
		return 1;

	return 0;
}

int get_failure_info(FAILURE_INFO* info)
{
	unsigned long l_ip;
	char buf[BUF_SIZE], *p;
	
	Get_Alert_Level(&info->level);

	Get_Alert_SMTP_Server_IP(buf, sizeof(buf));
	l_ip = IREV(inet_addr(buf));//Shone modified 'cause PPC uses Big Endian
	info->ip1 = l_ip & 0x000000ff;
	info->ip2 = (l_ip>>8) & 0x000000ff;
	info->ip3 = (l_ip>>16) & 0x000000ff;
	info->ip4 = (l_ip>>24) & 0x000000ff;

	Get_Alert_Mail_Address(buf, sizeof(buf));
	p = strtok(buf, ";");
	if (p != NULL) {
		strncpy(info->address1, p, sizeof(info->address1));
		p = strtok(NULL, ";");
		if (p != NULL)
			strncpy(info->address2, p, sizeof(info->address2));
	}
	return MISC_SUCCESS;
}	

void set_misc_failure_alert(INPUT* input)
{
	char buf[BUF_SIZE];
	INPUT *p1, *p2, *p3, *p4;
	int i = 0;

        if((p1 = (INPUT *) CGI_Find_Parameter(input, "SMTP_AUTH")) != NULL)//Shone added 2005,09,29
	{
		Set_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_SMTP_AUTH,"ON");
		if((p1 = (INPUT *) CGI_Find_Parameter(input, "SMTP_USER")) != NULL)
			Set_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_USER_NAME,p1->val);
		if((p1 = (INPUT *) CGI_Find_Parameter(input, "SMTP_PASS")) != NULL)
			Set_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_PASSWORD,p1->val);
	}
	else Set_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_SMTP_AUTH,"OFF");

	if((p1 = (INPUT *) CGI_Find_Parameter(input, "ALERT_LEVEL")) != NULL)
		i = atoi(p1->val);
	Set_Alert_Level(i);

	p1 = (INPUT *) CGI_Find_Parameter(input, "SMTP_IP_0");
	p2 = (INPUT *) CGI_Find_Parameter(input, "SMTP_IP_1");
	p3 = (INPUT *) CGI_Find_Parameter(input, "SMTP_IP_2");
	p4 = (INPUT *) CGI_Find_Parameter(input, "SMTP_IP_3");
	sprintf(buf, "%s.%s.%s.%s", p1->val, p2->val, p3->val, p4->val);
	Set_Alert_SMTP_Server_IP(buf);

	p1 = (INPUT *) CGI_Find_Parameter(input, "MAIL_ADDR1");
	p2 = (INPUT *) CGI_Find_Parameter(input, "MAIL_ADDR2");
	sprintf(buf, "%s;%s", p1->val, p2->val);
	Set_Alert_Mail_Address(buf);
}

int send_misc_alert_test_mail()//Shone moded 2006,01,10
{
	char Subject[BUF_SIZE], Msg[BUF_SIZE], buf[BUF_SIZE];
	char Ip[BUF_SIZE], Email1[BUF_SIZE], Email2[BUF_SIZE];
	char pt[BUF_SIZE];
	char *ptr = NULL;
	int ret=0;

	Get_Server_Name(buf, sizeof(buf));
	Get_Alert_SMTP_Server_IP(Ip, sizeof(Ip));
	strncpy(pt, "Test", sizeof(pt));
	strncpy(Subject, pt, sizeof(Subject));
	strncpy(pt, MISC_FAILURE_SEND_TEST_MAIL_STR, sizeof(pt));
	sprintf(Msg, pt, buf);
	Get_Alert_Mail_Address(buf, sizeof(buf));
	ptr = strtok(buf, ";");
	if (ptr != NULL) {
		strncpy(Email1, ptr, sizeof(Email1));
		ptr = strtok(NULL, ";");
		//Send_Mail(Subject, Msg, Email1, Ip, NULL);
		if(Is_SMTP_auth_on())//Shone Modified 2005,09,29
		{
			SMTP_AUTH smtp_auth;
			char tmp[128];

			Get_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_USER_NAME,"",tmp,sizeof(buf));
			strcpy(smtp_auth.username,tmp);
			Get_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_PASSWORD,"",tmp,sizeof(buf));
			strcpy(smtp_auth.password,tmp);

			ret = Send_Mail_Auth(Subject, Msg, Email1, Ip, NULL,&smtp_auth);
		}
		else
			ret = Send_Mail(Subject, Msg, Email1, Ip, NULL);
		if (ptr != NULL) {
			strncpy(Email2, ptr, sizeof(Email2));
			if(Is_SMTP_auth_on())//Shone added 2005,09,29
			{
				SMTP_AUTH smtp_auth;
				char tmp[128];

				Get_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_USER_NAME,"",tmp,sizeof(buf));
				strcpy(smtp_auth.username,tmp);
				Get_Profile_String(CONF_ALERT_SECTION,FIELD_MISC_PASSWORD,"",tmp,sizeof(buf));
				strcpy(smtp_auth.password,tmp);

				ret = Send_Mail_Auth(Subject, Msg, Email2, Ip, NULL,&smtp_auth);
			}
			else
				ret = Send_Mail(Subject, Msg, Email2, Ip, NULL);
		}
	}
	return ret;
}



int do_failure_main(INPUT* input, int select)
{
	FAILURE_INFO info;
	bzero(&info, sizeof(FAILURE_INFO));
	show_misc_header(input, select);
	get_failure_info(&info);
	CGI_Output_Html1(MISC_FAILURE_MAIN_HTML, "$", failure_replace, (void*)&info);
	show_misc_tail();
	return MISC_SUCCESS;
}	
int do_failure_main_submit(INPUT* input)
{
	int btn, ret=MISC_SUCCESS;
	btn = get_btn(input);
	switch(btn){
		case MISC_BTN_APPLY:
			set_misc_failure_alert(input);
			if (CGI_Find_Parameter(input, "TEST"))
				ret=send_misc_alert_test_mail();
			break;
	}
	if (!ret)
		do_failure_main(input, SELECT_FAILURE);
	return ret;
}	
