#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>
#include <qnap_pic_user.h>

/* local include */
#include "hwtest.h"
#include "hwtest04.h"
#include "hwtest05.h"

int hwtest04_replace(FILE *fptr, char *name, void *arg)
{
	//char buf[64];

	if (!strcmp(name, "hwtest_powerbt"))
	{
		fprintf(fptr,   "<form><input type=\"radio\" name=\"power\" value=\"fail\" checked >FAIL <input type=\"radio\" name=\"power\" value=\"ok\" checked >OK");
	}
	else
	if (!strcmp(name, "hwtest_usbbt"))
	{
		fprintf(fptr,   "<form><input type=\"radio\" name=\"usb\" value=\"fail\" checked >FAIL <input type=\"radio\" name=\"usb\" value=\"ok\" checked >OK");
	}
	else
	if (!strcmp(name, "hwtest_resetbt"))
	{
		fprintf(fptr,   "<form><input type=\"radio\" name=\"reset\" value=\"fail\" checked >FAIL <input type=\"radio\" name=\"reset\" value=\"ok\" checked >OK");
	}
	else
        	return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int do_hwtest04_main(INPUT *input)
{
	char buf[128];
	/* put your code here */
	sprintf(buf,"/sbin/daemon_mgr picd stop /sbin/picd");
	system(buf);
	sprintf(buf,"/sbin/daemon_mgr button_test start /sbin/button_test");
	system(buf);
	CGI_Output_Html1(HWTEST04_MAIN_HTML, "$", hwtest04_replace, NULL);
	return HWTEST_SUCCESS;
}

int do_hwtest04_main_submit(INPUT *input)
{
	int	btn;
	int	ret=HWTEST_SUCCESS;
	char    s[128];
	INPUT *buf = NULL;

	btn=get_btn(input);
	switch (btn)
	{
		case HWTEST_BTN_NEXT:
			/* put your "next button" code here */
			sprintf(s,"/sbin/daemon_mgr button_test stop /sbin/button_test");
        		system(s);
			sprintf(s,"/sbin/daemon_mgr picd start \"/sbin/picd -d\"");
        		system(s);
			buf = CGI_Find_Parameter(input, "power");
			if(!strcmp(buf->val, "ok"))
				Set_Private_Profile_String("Test Result", "PowerBT", "ok", RESULT_FILE);
			else
				Set_Private_Profile_String("Test Result", "PowerBT", "<font color=\"red\">fail</font>", RESULT_FILE);
			//	printf("%s",buf->val);
			buf = CGI_Find_Parameter(input, "usb");
			if(!strcmp(buf->val, "ok"))
				Set_Private_Profile_String("Test Result", "USBBT", "ok", RESULT_FILE);
			else
				Set_Private_Profile_String("Test Result", "USBBT", "<font color=\"red\">fail</font>", RESULT_FILE);
			//	printf("%s",buf->val);
			buf = CGI_Find_Parameter(input, "reset");
			if(!strcmp(buf->val, "ok"))
				Set_Private_Profile_String("Test Result", "ResetBT", "ok", RESULT_FILE);
			else
				Set_Private_Profile_String("Test Result", "ResetBT", "<font color=\"red\">fail</font>", RESULT_FILE);
			//	printf("%s",buf->val);
			Pic_Send_Raw_Cmd(QNAP_PIC_USB_LED_OFF);
                        Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_GREEN_BLINK);
                        Pic_Send_Raw_Cmd(QNAP_PIC_POWER_LED_ON);
			do_hwtest05_main(input);
			break;
		case HWTEST_BTN_BACK:
			printf("press exit button");
			break;
		case HWTEST_BTN_REFLASH:
                        do_hwtest04_main(input);
                        break;
	}
	return ret;
}

