#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>
#include <config.h>

/* local include */
#include "hwtest.h"
#include "hwtest00.h"
#include "hwtest01.h"


int hwtest00_replace(FILE *fptr, char *name, void *arg)
{
	char buf[64],buf2[64];
	char buf1[64]="00:33:44:55:66:77";
	char result[128];
	if (!strcmp(name, "hwtest_version"))
	{
		Get_System_Version(buf, 128);
		fprintf(fptr, "%s", buf);
		Get_Build_Number(buf2, 128);
		fprintf(fptr, "(build %s)", buf2);
		sprintf(result,"%s (build %s)",buf ,buf2);
		Set_Private_Profile_String("Test Result", "Version", result, RESULT_FILE);
	}
        else
	if (!strcmp(name, "hwtest_mac"))
	{
		NIC_Get_HWADDR(buf, 128, NIC_WAN_DEFAULT);
		fprintf(fptr, "%s", buf);
		if(!strcmp(buf, buf1))
		{
			fprintf(fptr, "( No Changed )");
			sprintf(result,"%s ( No Changed )",buf);
			//Set_Private_Profile_String("Test Result", "Mac Address", result, RESULT_FILE);
		}
		else
		{
			fprintf(fptr, "&nbsp&nbsp&nbsp&nbsp ( Changed )");
			sprintf(result,"%s ( Changed )",buf);
			//Set_Private_Profile_String("Test Result", "Mac Address", result, RESULT_FILE);
		}
	}
	else
        	return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int check_mount(char *dev)
{
	int ret=0;
	char buf[128];
	sprintf(buf, "/bin/grep %s /proc/mounts", dev);
	if (system(buf)==0)
		ret=1;
	return ret;
}

int do_hwtest00_main(INPUT *input)
{
	/* put your code here */
	FILE *fp;
	char buf1[128], buf2[128];
	int ret;
	if (check_mount("/dev/mtdblock6")==0)
	{
		sprintf(buf1,"/bin/mount /dev/mtdblock6 /tmp/config 1>/dev/null 2>/dev/null");
		ret = system(buf1);
		if(ret != 0)
		{	// if mount fail, then format mtdblock6
			sprintf(buf2, "/sbin/mke2fs /dev/mtdblock6 1>/dev/null 2>/dev/null");
			system(buf2);
			system(buf1);
		}
	}
	fp = fopen(RESULT_FILE, "a+");
        fclose(fp);
	CGI_Output_Html1(HWTEST00_MAIN_HTML, "$", hwtest00_replace, NULL);
	return HWTEST_SUCCESS;
}

int do_hwtest00_main_submit(INPUT *input)
{
	int	btn;
	int	ret=HWTEST_SUCCESS;

	btn=get_btn(input);
	switch (btn)
	{
		case HWTEST_BTN_NEXT:
			/* put your "next button" code here */
			do_hwtest01_main(input);
			break;
		case HWTEST_BTN_BACK:
			printf("press exit button");
			break;
	}
	return ret;
}

