#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#include <signal.h>

#include <sys/ipc.h>
#include <sys/shm.h>

#include <Util.h>
#include <shm_util.h>
#include "nas_lib_common.h"

SHM_MAP MAP[]={ {TAG_SYSTEM, "System"}, {TAG_STORAGE, "Storage"}, {TAG_MISC, "Misc"}};

char *local_skip_white_space(char *str)
{
        char *p = str;
        while (*p == ' ' || *p == '\t')
		p++;
        return p;
}
#if 0
char *stripe_white_space_tail(char *str)
{
        if (strlen(str) > 0)
	{
                char *p = str + strlen(str) - 1;
                while (*p == ' ' || *p == '\t')
			p--;
                *(p+1) = '\0';
        }
        return str;
}
#endif

int local_conf_get_field(char *conf_file, char *section, char *field, char *result, int buf_size)
{
        FILE *fp = NULL;
        char *section_name;
        char *p, *q;
        int section_found = 0;
        char    line[1024];

	if ((fp=fopen(conf_file, "r"))==NULL)
		return -1;

        if (EMPTY_STRING(section))
                section_found = 1;

        while (!feof(fp))
        {
                if (fgets(line, 1024, fp)==NULL)
                        continue;

                q=local_skip_white_space(line);

                if (*q == '[')
                {       //start of section name...
                        section_name=q+1;
                        p=section_name+strlen(section_name)-1;
                        while (*p!=']')
                        {
                                if (p==section_name)
                                        break;
                                p--;
                        }
                        if (p==section_name)
                        {
                                if (section_found)
                                        goto this_is_item;
                                continue;
                        }
                        else
                        {
                                if (section_found)
                                        break;
                        }
                        *p=0x0;
                        section_name=local_skip_white_space(section_name);
                        section_name=stripe_white_space_tail(section_name);
                        if (strcasecmp(section_name, section)==0)
                                section_found=1;
                }
                else
                if (section_found) {
this_is_item:
                        if (*q==';' || *q=='#')
                                continue;
                        else
                        {
                                char    *item, *value;

                                item=p=q;
                                while (*p!='=')
                                {
                                        if (*p==0x0)
                                                break;
                                        p++;
                                }
                                if (*p==0x0)
                                        continue;
                                *p=0x0;
                                value=p+1;
                                item=stripe_white_space_tail(item);
                                if (strcasecmp(field, item)==0)
                                {
                                        value=local_skip_white_space(value);
                                        value=stripe_white_space_tail(value);
                                        p=value+strlen(value)-1;
                                        while (*p==0x0a || *p==0x0d)
                                        {
                                                if (p==value)
                                                        break;
                                                p--;
                                        }
					if (*p==0x0a || *p==0x0d)
						*p=0x0;
                                        *(p+1)=0x0;
                                        if (result==NULL)
                                        {
                                                fclose(fp);
                                                return (strlen(value)+1);
                                        }
                                        if (buf_size<strlen(value)+1)
                                        {
                                                fclose(fp);
                                                return -1;
                                        }
		                        strcpy(result, value);
                                        fclose(fp);
                                        return 0;
                                }
                        }
                }
        }
        fclose(fp);
        return ERROR_NOT_FOUND;
}


int get_tag_size(int tag)
{
	int	tagsize=0;

	switch (tag)
	{
		case TAG_SYSTEM:
			tagsize=sizeof(TAG_SYSTEM_DATA);
			break;
		case TAG_STORAGE:
			tagsize=sizeof(TAG_STORAGE_DATA);
			break;
	}
	return tagsize;
}

int SHM_Debug_Section(char *section)
{
        int             shmid, i;
        char            *shm;
        SHM_HEADER      *header;
        SHM_RECORD      *tag;
        int             offset=0, data_offset;
        int             find=0;

        shmid=shmget((key_t)SHM_KEY, SHM_SIZE, 0666);
        if (shmid==-1)
                return FALSE;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return FALSE;
        header=(SHM_HEADER *)shm;
        offset=sizeof(SHM_HEADER);
        tag=(SHM_RECORD *)(shm+offset);
        for (i=0;i<header->totalrecord;i++)
        {
                data_offset=offset+sizeof(SHM_RECORD);
                if (!strcasecmp(section, MAP[i].section))
                {
			if (i==TAG_SYSTEM)
			{
	                        TAG_SYSTEM_DATA *data;

        	                data=(TAG_SYSTEM_DATA *)(shm+data_offset);
				printf("[%s]->model = %s\n", section, data->model);
				printf("[%s]->server name = %s\n", section, data->servername);
				printf("[%s]->server comment = %s\n", section, data->servercomment);
				printf("[%s]->version = %s\n", section, data->version);
				printf("[%s]->build = %s\n", section, data->build);
				printf("[%s]->timezone = %s\n", section, data->timezone);
				printf("[%s]->daylight = %s\n", section, data->daylight);
				printf("[%s]->workgroup = %s\n", section, data->workgroup);
				printf("[%s]->system_dev = %s\n", section, data->system_dev);
				printf("[%s]->wan_access = %s\n", section, data->wan_access);
				printf("[%s]->lan_access = %s\n", section, data->lan_access);
				printf("[%s]->codepage = %s\n", section, data->codepage);
				printf("[%s]->test_mode = %s\n", section, data->test_mode);
				printf("[%s]->auto_create_raid = %s\n", section, data->auto_create_raid);
				printf("[%s]->www_port = %s\n", section, data->www_port);
	                        find=1;
        	                break;
			}
			else
			if (i==TAG_STORAGE)
			{
				TAG_STORAGE_DATA	*data;

				data=(TAG_STORAGE_DATA *)(shm+data_offset);
				printf("[%s]->auto_init = %s\n", section, data->auto_init);
				printf("[%s]->check_on_boot = %s\n", section, data->check_on_boot);
				printf("[%s]->disk_number = %s\n", section, data->disk_number);
				printf("[%s]->drive 1 = %s\n", section, data->dev[0]);
				printf("[%s]->drive 2 = %s\n", section, data->dev[1]);
				printf("[%s]->drive 3 = %s\n", section, data->dev[2]);
				printf("[%s]->drive 4 = %s\n", section, data->dev[3]);
				printf("[%s]->auto_fix_error = %s\n", section, data->auto_fix_error);
				printf("[%s]->support_raid5 = %s\n", section, data->support_raid5);
				printf("[%s]->support_hotswap = %s\n", section, data->support_hotswap);
                                printf("[%s]->drive dma 1 = %s\n", section, data->dma[0]);
                                printf("[%s]->drive dma 2 = %s\n", section, data->dma[1]);
                                printf("[%s]->drive dma 3 = %s\n", section, data->dma[2]);
                                printf("[%s]->drive dma 4 = %s\n", section, data->dma[3]);
				printf("[%s]->support hotspare = %s\n", section, data->support_hotspare);
				printf("[%s]->nas debug = %s\n", section, data->nas_debug);
				printf("[%s]->debug size = %s\n", section, data->debug_size);
			}
			else
			if (i==TAG_MISC)
			{
				TAG_MISC_DATA	*data;

				data=(TAG_MISC_DATA *)(shm+data_offset);
				printf("[%s]->system_started = %s\n", section, data->system_started);
				printf("[%s]->lcd = %s\n", section, data->lcd);
				printf("[%s]->reset_pwd = %s\n", section, data->reset_pwd);
				printf("[%s]->disk standby = %s\n", section, data->disk_standby);
				printf("[%s]->buzzer = %s\n", section, data->buzzer);
			}
                }
                offset=offset+sizeof(SHM_RECORD)+tag->size;
                tag=(SHM_RECORD *)(shm+offset);
        }
        shmdt(shm);
	return 0;
}

int shm_do_misc(char *item, char *result, int len, TAG_MISC_DATA *data, int type)
{
        if (!strcasecmp(item, "System Started"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->system_started))
                                return -1;
                        strcpy(result, data->system_started);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->system_started))
                                return -1;
                        strcpy(data->system_started, result);
                }
        }
	else
        if (!strcasecmp(item, "LCD Panel Setting Control"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->lcd))
                                return -1;
                        strcpy(result, data->lcd);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->lcd))
                                return -1;
                        strcpy(data->lcd, result);
                }
        }
        else
        if (!strcasecmp(item, "Reset Password Switch"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->reset_pwd))
                                return -1;
                        strcpy(result, data->reset_pwd);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->reset_pwd))
                                return -1;
                        strcpy(data->reset_pwd, result);
                }
        }
        else
        if (!strcasecmp(item, "Disk StandBy Timeout"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->disk_standby))
                                return -1;
                        strcpy(result, data->disk_standby);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->disk_standby))
                                return -1;
                        strcpy(data->disk_standby, result);
                }
        }
        else
        if (!strcasecmp(item, "Buzzer"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->buzzer))
                                return -1;
                        strcpy(result, data->buzzer);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->buzzer))
                                return -1;
                        strcpy(data->buzzer, result);
                }
        }
	else
		return ERROR_NOT_FOUND;
	return 0;
}

int shm_do_storage(char *item, char *result, int len, TAG_STORAGE_DATA *data, int type)
{
        if (!strcasecmp(item, "Auto Init"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->auto_init))
        	                return -1;
                	strcpy(result, data->auto_init);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->auto_init))
                                return -1;
                        strcpy(data->auto_init, result);
                }
        }
        else
        if (!strcasecmp(item, "Disk Drive Number"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->disk_number))
        	                return -1;
                	strcpy(result, data->disk_number);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->disk_number))
                                return -1;
                        strcpy(data->disk_number, result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 1"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->dev[0]))
        	                return -1;
                	strcpy(result, data->dev[0]);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dev[0]))
                                return -1;
                        strcpy(data->dev[0], result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 2"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->dev[1]))
        	                return -1;
                	strcpy(result, data->dev[1]);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dev[1]))
                                return -1;
                        strcpy(data->dev[1], result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 3"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->dev[2]))
        	                return -1;
                	strcpy(result, data->dev[2]);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dev[2]))
                                return -1;
                        strcpy(data->dev[2], result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 4"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->dev[3]))
        	                return -1;
                	strcpy(result, data->dev[3]);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dev[3]))
                                return -1;
                        strcpy(data->dev[3], result);
                }
        }
        else
        if (!strcasecmp(item, "Disk Check On Boot"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->check_on_boot))
        	                return -1;
                	strcpy(result, data->check_on_boot);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->check_on_boot))
                                return -1;
                        strcpy(data->check_on_boot, result);
                }
        }
        else
        if (!strcasecmp(item, "Auto Fix Disk Check Errors"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->auto_fix_error))
        	                return -1;
                	strcpy(result, data->auto_fix_error);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->auto_fix_error))
                                return -1;
                        strcpy(data->auto_fix_error, result);
                }
        }
        else
        if (!strcasecmp(item, "Support Raid 5"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->support_raid5))
        	                return -1;
                	strcpy(result, data->support_raid5);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->support_raid5))
                                return -1;
                        strcpy(data->support_raid5, result);
                }
        }
        else
        if (!strcasecmp(item, "Support HOTSWAP"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->support_hotswap))
        	                return -1;
                	strcpy(result, data->support_hotswap);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->support_hotswap))
                                return -1;
                        strcpy(data->support_hotswap, result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 1 DMA"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->dma[0]))
                                return -1;
                        strcpy(result, data->dma[0]);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dma[0]))
                                return -1;
                        strcpy(data->dma[0], result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 2 DMA"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->dma[1]))
                                return -1;
                        strcpy(result, data->dma[1]);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dma[1]))
                                return -1;
                        strcpy(data->dma[1], result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 3 DMA"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->dma[2]))
                                return -1;
                        strcpy(result, data->dma[2]);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dma[2]))
                                return -1;
                        strcpy(data->dma[2], result);
                }
        }
        else
        if (!strcasecmp(item, "Drive 4 DMA"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->dma[3]))
                                return -1;
                        strcpy(result, data->dma[3]);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->dma[3]))
                                return -1;
                        strcpy(data->dma[3], result);
                }
        }
        else
        if (!strcasecmp(item, "Support HOT Spare"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->support_hotspare))
                                return -1;
                        strcpy(result, data->support_hotspare);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->support_hotswap))
                                return -1;
                        strcpy(data->support_hotswap, result);
                }
        }
        else
        if (!strcasecmp(item, "NAS DEBUG"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->nas_debug))
                                return -1;
                        strcpy(result, data->nas_debug);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->nas_debug))
                                return -1;
                        strcpy(data->nas_debug, result);
                }
        }
        else
        if (!strcasecmp(item, "NAS DEBUG DISK SIZE"))
        {
                if (type==SHM_GET)
                {
                        if (len<strlen(data->debug_size))
                                return -1;
                        strcpy(result, data->debug_size);
                }
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->debug_size))
                                return -1;
                        strcpy(data->debug_size, result);
                }
        }
	else
		return ERROR_NOT_FOUND;

	return 0;
}

int shm_do_system(char *item, char *result, int len, TAG_SYSTEM_DATA *data, int type)
{
	if (!strcasecmp(item, "Model"))
	{
		if (type==SHM_GET)
		{
			if (len<strlen(data->model))
				return -1;
			strcpy(result, data->model);
		}
		else
		if (type==SHM_SET)
		{
			if (strlen(result)+1>sizeof(data->model))
				return -1;
			strcpy(data->model, result);
		}
	}
	else
        if (!strcasecmp(item, "Server Comment"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->servercomment))
        	                return -1;
                	strcpy(result, data->servercomment);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->servercomment))
                                return -1;
                        strcpy(data->servercomment, result);
                }
        }
        else
        if (!strcasecmp(item, "Server Name"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->servername))
        	                return -1;
                	strcpy(result, data->servername);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->servername))
                                return -1;
                        strcpy(data->servername, result);
                }
        }
        else
        if (!strcasecmp(item, "Version"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->version))
        	                return -1;
                	strcpy(result, data->version);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->version))
                                return -1;
                        strcpy(data->version, result);
                }
        }
        else
        if (!strcasecmp(item, "Build Number"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->build))
        	                return -1;
                	strcpy(result, data->build);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->build))
                                return -1;
                        strcpy(data->build, result);
                }
        }
        else
        if (!strcasecmp(item, "Time Zone"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->timezone))
        	                return -1;
                	strcpy(result, data->timezone);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->timezone))
                                return -1;
                        strcpy(data->timezone, result);
                }
        }
        else
        if (!strcasecmp(item, "Enable Daylight Saving Time"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->daylight))
        	                return -1;
                	strcpy(result, data->daylight);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->daylight))
                                return -1;
                        strcpy(data->daylight, result);
                }
        }
        else
        if (!strcasecmp(item, "Workgroup"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->workgroup))
        	                return -1;
                	strcpy(result, data->workgroup);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->workgroup))
                                return -1;
                        strcpy(data->workgroup, result);
                }
        }
        else
        if (!strcasecmp(item, "Code Page"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->codepage))
        	                return -1;
                	strcpy(result, data->codepage);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->codepage))
                                return -1;
                        strcpy(data->codepage, result);
                }
        }
        else
        if (!strcasecmp(item, "System Device"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->system_dev))
        	                return -1;
                	strcpy(result, data->system_dev);
		}

                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->system_dev))
                                return -1;
                        strcpy(data->system_dev, result);
                }
        }
        else
        if (!strcasecmp(item, "Test Mode"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->test_mode))
        	                return -1;
                	strcpy(result, data->test_mode);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->test_mode))
                                return -1;
                        strcpy(data->test_mode, result);
                }
        }
        else
        if (!strcasecmp(item, "Auto Create Raid"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->auto_create_raid))
        	                return -1;
                	strcpy(result, data->auto_create_raid);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->auto_create_raid))
                                return -1;
                        strcpy(data->auto_create_raid, result);
                }
        }
        else
        if (!strcasecmp(item, "Wan Access"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->wan_access))
        	                return -1;
                	strcpy(result, data->wan_access);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->wan_access))
                                return -1;
                        strcpy(data->wan_access, result);
                }
        }
        else
        if (!strcasecmp(item, "Lan Access"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->lan_access))
        	                return -1;
                	strcpy(result, data->lan_access);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->lan_access))
                                return -1;
                        strcpy(data->lan_access, result);
                }
        }
        else
        if (!strcasecmp(item, "Web Access Port"))
        {
		if (type==SHM_GET)
		{
	                if (len<strlen(data->www_port))
        	                return -1;
                	strcpy(result, data->www_port);
		}
                else
                if (type==SHM_SET)
                {
                        if (strlen(result)+1>sizeof(data->www_port))
                                return -1;
                        strcpy(data->www_port, result);
                }
        }
	else
		return ERROR_NOT_FOUND;
	return 0;
}

int SHM_Set_Field(char *section, char *item, char *result)
{
        int             shmid, i;
        char            *shm;
        SHM_HEADER      *header;
        SHM_RECORD      *tag;
        int             offset=0, data_offset;
        int             find=0;
	int		len;

        shmid=shmget((key_t)SHM_KEY, SHM_SIZE, 0666);
        if (shmid==-1)
                return FALSE;
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return FALSE;
        header=(SHM_HEADER *)shm;
        offset=sizeof(SHM_HEADER);
        tag=(SHM_RECORD *)(shm+offset);
	len=strlen(result);
        for (i=0;i<header->totalrecord;i++)
        {
                data_offset=offset+sizeof(SHM_RECORD);
                if (!strcasecmp(section, MAP[i].section))
                {
                        if (i==TAG_SYSTEM)
                        {
                                TAG_SYSTEM_DATA *data;

                                data=(TAG_SYSTEM_DATA *)(shm+data_offset);
                                if (shm_do_system(item, result, len, data, SHM_SET)<0)
                                        goto len_not_enough;
                                find=1;
                                break;
                        }
                        else
                        if (i==TAG_STORAGE)
                        {
                                TAG_STORAGE_DATA        *data;

                                data=(TAG_STORAGE_DATA *)(shm+data_offset);
				if (shm_do_storage(item, result, len, data, SHM_SET)<0)
					goto len_not_enough;
                                find=1;
                                break;
                        }
			else
			if (i==TAG_MISC)
			{
				TAG_MISC_DATA	*data;

				data=(TAG_MISC_DATA *)(shm+data_offset);
				if (shm_do_misc(item, result, len, data, SHM_SET)<0)
					goto len_not_enough;
				find=1;
				break;
			}
                }
                offset=offset+sizeof(SHM_RECORD)+tag->size;
                tag=(SHM_RECORD *)(shm+offset);
        }
        if (!find)
        {       /* get data from source.conf    */
                /* never occurred...            */
        }
        shmdt(shm);
        return SUCCESS;
len_not_enough:
        shmdt(shm);
        return FALSE;
}

int SHM_Get_Field(char *section, char *item, char *result, int len)
{
        int             shmid, i;
        char            *shm;
        SHM_HEADER	*header;
	SHM_RECORD	*tag;
	int		offset=0, data_offset;
	int		find=0, ret=0;

        shmid=shmget((key_t)SHM_KEY, SHM_SIZE, 0666);
        if (shmid==-1)
		return local_conf_get_field(DEFAULT_CFG_FILE, section, item, result, len);
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return local_conf_get_field(DEFAULT_CFG_FILE, section, item, result, len);
        header=(SHM_HEADER *)shm;
	offset=sizeof(SHM_HEADER);
	tag=(SHM_RECORD *)(shm+offset);
	for (i=0;i<header->totalrecord;i++)
	{
		data_offset=offset+sizeof(SHM_RECORD);
		if (!strcasecmp(section, MAP[i].section))
		{
			if (i==TAG_SYSTEM)
			{
				TAG_SYSTEM_DATA	*data;

				data=(TAG_SYSTEM_DATA *)(shm+data_offset);
				if ((ret=shm_do_system(item, result, len, data, SHM_GET))<0)
					goto len_not_enough;
				find=1;
				break;
			}
			else
			if (i==TAG_STORAGE)
			{
				TAG_STORAGE_DATA	*data;

				data=(TAG_STORAGE_DATA *)(shm+data_offset);
				if ((ret=shm_do_storage(item, result, len, data, SHM_GET))<0)
					goto len_not_enough;
				find=1;
				break;
			}
			else
			{
				TAG_MISC_DATA	*data;

				data=(TAG_MISC_DATA *)(shm+data_offset);
				if ((ret=shm_do_misc(item, result, len, data, SHM_GET))<0)
					goto len_not_enough;
				find=1;
				break;
			}
		}
		offset=offset+sizeof(SHM_RECORD)+tag->size;
		tag=(SHM_RECORD *)(shm+offset);
	}
	if (!find)
	{	/* get data from source.conf	*/
		/* never occurred...		*/
		if (local_conf_get_field(DEFAULT_CFG_FILE, section, item, result, len)!=SUCCESS)
		{
			shmdt(shm);
			return ERROR_NOT_FOUND;
		}
	}
        shmdt(shm);
	if (*result==0x0)
		return ERROR_NOT_FOUND;
        return SUCCESS;
len_not_enough:
	shmdt(shm);
	if (ret==ERROR_NOT_FOUND)
		return ret;
	return -1;
}

int SHM_Destory()
{
	int		shmid;

	shmid=shmget((key_t)SHM_KEY, SHM_SIZE, 0666 | IPC_CREAT);
	if (shmctl(shmid, IPC_RMID, 0)==-1)
	{
		printf("SHM destroy fail...\n");
		return FALSE;
	}
	return TRUE;
}

int SHM_Init()
{
        int             shmid;
        char            *shm;
        SHM_HEADER     *header;

        shmid=shmget((key_t)SHM_KEY, SHM_SIZE, 0666 | IPC_CREAT);
        if (shmid==-1)
        {
                shm=shmat(shmid, (char *)0, 0);
                shmdt(shm);
                shmctl(shmid, IPC_RMID, 0);
                shmid=shmget((key_t)SHM_KEY, SHM_SIZE, 0666 | IPC_CREAT);
                if (shmid==-1)
                        return FALSE;
        }
        shm=shmat(shmid, (char *)0, 0);
        if (shm==(char *)-1)
                return FALSE;
        else
        {	/* init shm data	*/
		TAG_SYSTEM_DATA		*tag_system_data;
		TAG_STORAGE_DATA	*tag_storage_data;
		TAG_MISC_DATA		*tag_misc_data;
		SHM_RECORD		*tag;
		int			offset=0;

                header=(SHM_HEADER *)shm;
                header->totalrecord=0;

		/* insert [system] section	*/
		header->totalrecord++;
		offset=offset+sizeof(SHM_HEADER);
		tag=(SHM_RECORD *)(shm+offset);
		offset=offset+sizeof(SHM_RECORD);
		tag_system_data=(TAG_SYSTEM_DATA *)(shm+offset);
		tag->tag=TAG_SYSTEM;
		tag->size=sizeof(TAG_SYSTEM_DATA);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Model", tag_system_data->model, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Server Name", tag_system_data->servername, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Server Comment", tag_system_data->servercomment, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Version", tag_system_data->version, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Build Number", tag_system_data->build, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Time Zone", tag_system_data->timezone, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Enable Daylight Saving Time", tag_system_data->daylight, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Workgroup", tag_system_data->workgroup, 64);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Code Page", tag_system_data->codepage, 64);
		if (tag_system_data->codepage[0]==0x0)
			strcpy(tag_system_data->codepage, "437");
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "System Device", tag_system_data->system_dev, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Test Mode", tag_system_data->test_mode, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Auto Create Mode", tag_system_data->auto_create_raid, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Wan Access", tag_system_data->wan_access, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Lan Access", tag_system_data->lan_access, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "System", "Web Access Port", tag_system_data->www_port, 16);
		offset=offset+sizeof(TAG_SYSTEM_DATA);

		/* insert [storage] section	*/
		header->totalrecord++;
		tag=(SHM_RECORD *)(shm+offset);
		offset=offset+sizeof(SHM_RECORD);
		tag_storage_data=(TAG_STORAGE_DATA *)(shm+offset);
		tag->tag=TAG_STORAGE;
		tag->size=sizeof(TAG_STORAGE_DATA);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Auto Init", tag_storage_data->auto_init, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Disk Drive Number", tag_storage_data->disk_number, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 1", tag_storage_data->dev[0], 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 2", tag_storage_data->dev[1], 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 3", tag_storage_data->dev[2], 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 4", tag_storage_data->dev[3], 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Disk Check On Boot", tag_storage_data->check_on_boot, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Auto Fix Disk Check Errors", tag_storage_data->auto_fix_error, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Support Raid 5", tag_storage_data->support_raid5, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Support HOTSWAP", tag_storage_data->support_hotswap, 16);
                local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 1 DMA", tag_storage_data->dma[0], 16);
                local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 2 DMA", tag_storage_data->dma[1], 16);
                local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 3 DMA", tag_storage_data->dma[2], 16);
                local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Drive 4 DMA", tag_storage_data->dma[3], 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "Support HOT Spare", tag_storage_data->support_hotspare, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "NAS DEBUG", tag_storage_data->nas_debug, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Storage", "NAS DEBUG DISK SIZE", tag_storage_data->debug_size, 16);
		offset=offset+sizeof(TAG_STORAGE_DATA);

		/* insert [misc] section	*/
                header->totalrecord++;
                tag=(SHM_RECORD *)(shm+offset);
                offset=offset+sizeof(SHM_RECORD);
                tag_misc_data=(TAG_MISC_DATA *)(shm+offset);
                tag->tag=TAG_MISC;
                tag->size=sizeof(TAG_MISC_DATA);
		local_conf_get_field(DEFAULT_CFG_FILE, "Misc", "System Started", tag_misc_data->system_started, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Misc", "LCD Panel Setting Control", tag_misc_data->lcd, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Misc", "Reset Password Switch", tag_misc_data->reset_pwd, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Misc", "Disk StandBy Timeout", tag_misc_data->disk_standby, 16);
		local_conf_get_field(DEFAULT_CFG_FILE, "Misc", "Buzzer", tag_misc_data->buzzer, 16);

                shmdt(shm);
        }
        return SUCCESS;
}

