#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "storage.h"
#include "qnap_pic_user.h"

int Pic_Send_Raw_Cmd(int cmd)
{
	int fd, ret;
	struct qnap_pic_ioctl qpi;

	fd = open(PIC_DEV, O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "fail to open %s\n", PIC_DEV);
		return -1;
	}
	memset(&qpi, 0, sizeof(struct qnap_pic_ioctl));
	qpi.pic_data[0] = cmd;
	qpi.count = 1;
	ret = ioctl(fd, IOCTL_MSG_SEND_RAW_COMMAND, &qpi);
	close(fd);
	return ret;
}

int Pic_Send_Raw_Cmds(unsigned char *cmdP, int len)
{
	int fd, ret;
	struct qnap_pic_ioctl qpi;

	if (len > QUEUE_BUFSIZE) {
		fprintf(stderr, "PIC command buffer overflow.\n");
		return -1;
	}
	fd = open(PIC_DEV, O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "fail to open %s\n", PIC_DEV);
		return -1;
	}
	memset(&qpi, 0, sizeof(struct qnap_pic_ioctl));
	memcpy(qpi.pic_data, cmdP, len);
	qpi.count = len;
	ret = ioctl(fd, IOCTL_MSG_SEND_RAW_COMMAND, &qpi);
	close(fd);
	return ret;
}

int Pic_Send_Message(int event, int value)
{
	int fd, ret;
	struct qnap_pic_ioctl qpi;

	fd = open(PIC_DEV, O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "fail to open %s\n", PIC_DEV);
		return -1;
	}
	memset(&qpi, 0, sizeof(struct qnap_pic_ioctl));
	qpi.pic_data[0] = event;
	qpi.count++;
	qpi.pic_data[1] = value;
	qpi.count++;
	ret = ioctl(fd, IOCTL_MSG_SEND_MESSAGE, &qpi);
	close(fd);
	return ret;
}


// event: -1->query, 0->reset to no error
// status: 0->off, 1->on
void Set_Status_Led(int event, int status)
{
	int value;
	char buf[BUF_SIZE];

	GetPrivateProfileString("System", "Status LED", "0", buf, sizeof(buf), "/tmp/ledvalue");
//	value = Get_Profile_Integer("System", "Status LED", 0);
	value = atoi(buf);
	if(event > 0)
	{
		if(status)
			value |= event;
		else
			value &= (~event);
//		Set_Profile_Integer("System", "Status LED", value);
		sprintf(buf, "%d", value);
		WritePrivateProfileString("System", "Status LED", buf, "/tmp/ledvalue");
	}
	else if(event == ERROR_NO_ERROR)	// event == 0
	{
		value = 0;
//		Set_Profile_Integer("System", "Status LED", value);
		sprintf(buf, "%d", value);
                WritePrivateProfileString("System", "Status LED", buf, "/tmp/ledvalue");
	}

	if(value & 0xF000){
		Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_RED_ON);
//		Util_Send_Message(ERROR_STATUS_OCCUR, "", 0, NULL);
	}
	else if(value & 0x0F00){
		Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_RED_BLINK);
//		Util_Send_Message(ERROR_STATUS_OCCUR, "", 0, NULL);
	}
	else if(value & 0x00F0)
		Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_BOTH_BLINK);
	else if(value & 0x000F)
	{
//		Util_Send_Message(ERROR_STATUS_OCCUR, "", 0, NULL);
		Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_GREEN_BLINK);
		if(value & ERROR_HD_WRONG_FORMAT)
		{
			sleep(5);
			Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_BOTH_BLINK);
		}
	}
	else if(value & 0xF0000){
//		Util_Send_Message(ERROR_STATUS_OCCUR, "", 0, NULL);
		Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_OFF);
	}
	else{
//		Util_Send_Message(STATUS_NORMAL, "", 0, NULL);
		Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_GREEN_ON);
	}
}

int Util_Send_Message(int command, char *dev_name, unsigned int timer, void *parameter){
	
	MESSAGE msg;
	int msgid;
        msgid = msgget((key_t)0624, 0666| IPC_CREAT);
//printf("%d\n", msgid);
        msg.command = command;
	if(dev_name!=NULL)
        	strcpy(msg.device, dev_name);
        msg.timer = timer;
	msg.parameter = parameter;
        msgsnd(msgid, (void *)&msg, sizeof(msg),0);
	return 0;
}
