// Date : 8/8/2000
// Company : ICP Electronics Inc.
// Description : Define the basic control function of watch dog

#include <linux/fs.h>

// define watchdog control code
#define WATCHDOG_IOC_MAGIC		'W'
#define WATCHDOG_IOCSETTIMER	_IO(WATCHDOG_IOC_MAGIC, 0)
#define WATCHDOG_IOCSTART		_IO(WATCHDOG_IOC_MAGIC, 1)
#define WATCHDOG_IOCSTOP		_IO(WATCHDOG_IOC_MAGIC, 2)
#define WATCHDOG_IOCRESTART		_IO(WATCHDOG_IOC_MAGIC, 3)
#include <asm/io.h>

#ifdef __KERNEL__

#define DEFAULT_TIME_TO_RESET	30

#define WD_PORT		0x443
#define WD_START	0x443
#define WD_STOP		0x843

extern inline void set_watchdog_timer(unsigned char sec)
{
#ifdef DEBUG
	printk(KERN_INFO "Set watchdog timer = %d seconds\n", sec);
#endif
    outb(sec, WD_PORT);
}

extern inline void start_watchdog()
{
#ifdef DEBUG
	printk(KERN_INFO "Start watchdog\n");
#endif
	inb(WD_START);
}

extern inline void stop_watchdog()
{
#ifdef DEBUG
	printk(KERN_INFO "Stop watchdog\n");
#endif
	inb(WD_STOP);
}

extern inline void restart_watchdog()
{
	stop_watchdog();
	start_watchdog();
}

#endif 	// __KERNEL__
