#ifndef __SYSMGR_H__
#define __SYSMGR_H__

// user defined message
enum {
	MSG_SYSMGR = 100,
	MSG_SPEAKER,
	MSG_LCD_PANEL_SETTING,
};

// the following flag is used to control event behavior.
#define FLAG_NONE		0x00
#define FLAG_SLIDING		0x01	// sliding text
#define FLAG_SHOW_LOCK		0x02	// the flag is used for power down and reboot event
#define FLAG_SHOW_TRANSIT	0x04
#define FLAG_SHOW_PERSISTENT	0x08
#define FLAG_CENTER		0x10
#define FLAG_UPDATE_DISPLAY	0x20

// the error level is used to control event behavior.
enum {
	ERRLVL_NONE=-1,
	ERRLVL_INFO,

	ERRLVL_LOW,
	ERRLVL_MID,
	ERRLVL_HIGH,
	ERRLVL_HIGHEST,
};

enum {
	SYSMGR_NOEVENT,

	SYSMGR_REBOOT,
	SYSMGR_POWER_ON,
	SYSMGR_POWER_DOWN,
	SYSMGR_POWERGOOD1_OK,
	SYSMGR_POWERGOOD1_FAIL,
	SYSMGR_POWERGOOD2_OK,
	SYSMGR_POWERGOOD2_FAIL,
	SYSMGR_POWERGOOD3_OK,
	SYSMGR_POWERGOOD3_FAIL,

	SYSMGR_NETWORK_CONNECTED,
	SYSMGR_NETWORK_DISCONNECTED,

	SYSMGR_FAN_CPU,
	SYSMGR_FAN_SYSTEM,
	SYSMGR_TEMP_CPU,
	SYSMGR_TEMP_SYSTEM,
	SYSMGR_CONFIG_RESET,

	SYSMGR_SET_SYSTEM_EVENT,	// unused
	SYSMGR_CLEAR_SYSTEM_EVENT,	// unused

	SYSMGR_SHOW_MESSAGE,
	SYSMGR_HIDE_MESSAGE,

	SYSMGR_MAIN_DISPLAY,

	SYSMGR_HD1_PLUGGED,
	SYSMGR_HD1_UNPLUGGED,
	SYSMGR_HD2_PLUGGED,
	SYSMGR_HD2_UNPLUGGED,
	SYSMGR_HD3_PLUGGED,
	SYSMGR_HD3_UNPLUGGED,
	SYSMGR_HD4_PLUGGED,
	SYSMGR_HD4_UNPLUGGED,
	SYSMGR_HD5_PLUGGED,
	SYSMGR_HD5_UNPLUGGED,
	SYSMGR_HD6_PLUGGED,
	SYSMGR_HD6_UNPLUGGED,
	SYSMGR_HD7_PLUGGED,
	SYSMGR_HD7_UNPLUGGED,
	SYSMGR_HD8_PLUGGED,
	SYSMGR_HD8_UNPLUGGED,

	SYSMGR_NO_DISKS,
	SYSMGR_DISK_FULL,
	SYSMGR_DISK_NOT_FULL,

	SYSMGR_STOPPED_FAN_SYSTEM,	// the message for test

	SYSMGR_PRINT_STARTED,
	SYSMGR_PRINT_FINISHED,
	SYSMGR_PRINT_ERROR,

	SYSMGR_BUZZER_NOTIFY,

	SYSMGR_SNAPSHOT_USE_RATE_TOO_HIGH,
	SYSMGR_DISK_CLEAR,

	SYSMGR_BONDING_CONNECTED,
	SYSMGR_BONDING_DISCONNECTED,
	SYSMGR_BONDING_ONE_LOSE,
	SYSMGR_BONDING_ONE_BACK,

	SYSMGR_BONDING_3NIC_ONE_LOSE,
	SYSMGR_BONDING_3NIC_TWO_LOSE,
	SYSMGR_BONDING_3NIC_DISCONNECTED,
	SYSMGR_BONDING_3NIC_ONE_BACK,
	SYSMGR_BONDING_3NIC_TWO_BACK,
	SYSMGR_BONDING_3NIC_CONNECTED,
};

typedef unsigned char	BYTE;
typedef unsigned short	WORD;
typedef unsigned long	DWORD;

#define LOBYTE(w)		((BYTE) (w))
#define HIBYTE(w)		((BYTE) ((w) >> 8))
#define LOWORD(dw)		((WORD) (dw))
#define HIWORD(dw)		((WORD) ((dw) >> 16))

#define NIC_PARM_SPEED(dw)	LOWORD(dw)
#define NIC_PARM_FULLDUPLEX(dw) HIWORD(dw)

#ifndef CONFIG_SYSTEST
void Sysmgr_Init();
void Sysmgr_Process_Timer_Event(int timer);
#endif
void Sysmgr_Dispatch_Message(int event, unsigned long lparm, char *extramsg);

#endif	// __SYSMGR_H__
