#ifndef __PPC_PLATFORMS_QNAP_PIC_USER_H
#define __PPC_PLATFORMS_QNAP_PIC_USER_H

#define QUEUE_BUFSIZE					16
#define PIC_MINOR						80
#define PIC_DEV							"/dev/pic"

struct qnap_pic_ioctl {
	unsigned char pic_data[QUEUE_BUFSIZE];
	int count;
};

#define IOCTL_MSG_MAGIC					'Q'
#define IOCTL_MSG_GET_MESSAGE			_IOR(IOCTL_MSG_MAGIC, 1000, struct qnap_pic_ioctl)
#define IOCTL_MSG_SEND_MESSAGE			_IOW(IOCTL_MSG_MAGIC, 1001, struct qnap_pic_ioctl)
#define IOCTL_MSG_SEND_RAW_COMMAND		_IOW(IOCTL_MSG_MAGIC, 1002, struct qnap_pic_ioctl)

#define QNAP_PIC_BOOT_COMPLETE			0
#define QNAP_PIC_NO_HD					1
#define QNAP_PIC_WRONG_HD_FORMAT		2
#define QNAP_PIC_HD_BAD_BLOCK			3
#define QNAP_PIC_HD_FULL				4
#define QNAP_PIC_FIRMWARE_UPDATE		5
#define QNAP_PIC_POWER_OFF				6
#define QNAP_PIC_HD_STANDBY				7
#define QNAP_PIC_USB_COPY				8
#define QNAP_PIC_SET_DEFAULT			9
#define QNAP_PIC_POWER_RECOVERY			10

#define QNAP_PIC_TOTAL_EVENT			11
#define QNAP_PIC_EVENT_OFF				0
#define QNAP_PIC_EVENT_ON				1

#define QNAP_PIC_POWER_BUTTON			0x40
#define QNAP_PIC_USB_COPY_BUTTON		0x68
#define QNAP_PIC_SET_DEFAULT_BUTTON		0x6A
#define QNAP_PIC_FAN_ENABLE			0x71
#define QNAP_PIC_FAN_DISABLE			0x72
#define QNAP_PIC_FAN_ERROR			0x73
#define QNAP_PIC_FAN_NORMAL			0x74
#define QNAP_PIC_POWER_RECOVERY_ON		0x79
#define QNAP_PIC_POWER_RECOVERY_OFF		0x7A
#define QNAP_NET_NIC_UP				0x81
#define QNAP_NET_NIC_DOWN			0x82

/*add by KenChen for GIGA Lan up notification
#define GIGA				1000
#define QNAP_GIGA_LAN_UP				0x7C
#define QNAP_NOT_GIGA_LAN_UP				0x7D
end here */

//Ricky added some hotswap command
#define QNAP_ESATA_UP                           0x83
#define QNAP_ESATA_DOWN                         0x84
#define QNAP_USB_FRONT_UP                       0x85
#define QNAP_USB_FRONT_DOWN                     0x86
#define QNAP_USB_B_UPPER_UP                     0x87
#define QNAP_USB_B_UPPER_DOWN                   0x88
#define QNAP_USB_B_LOWER_UP                     0x89
#define QNAP_USB_B_LOWER_DOWN                   0x8A
#define QNAP_USB_PRINTER_UP                     0x8B
#define QNAP_USB_PRINTER_DOWN                   0x8C
#define QNAP_SATA_UP                           	0x8D
#define QNAP_SATA_DOWN                         	0x8E
//End

#define QNAP_PIC_SOFTWARE_SHUTDOWN   	0x41
#define QNAP_PIC_POWER_RECOVERY_STATUS	   	0x46
#define QNAP_PIC_POWER_LED_OFF		   	0x4B
#define QNAP_PIC_POWER_LED_BLINK		0x4C
#define QNAP_PIC_POWER_LED_ON		   	0x4D
#define QNAP_PIC_ENABLE_POWER_RECOVERY	0x48
#define QNAP_PIC_DISABLE_POWER_RECOVERY	0x49
#define QNAP_PIC_BUZZER_SHORT			0x50
#define QNAP_PIC_BUZZER_LONG			0x51
#define QNAP_PIC_STATUS_RED_BLINK		0x54
#define QNAP_PIC_STATUS_GREEN_BLINK		0x55
#define QNAP_PIC_STATUS_GREEN_ON		0x56
#define QNAP_PIC_STATUS_RED_ON			0x57
#define QNAP_PIC_STATUS_BOTH_BLINK		0x58
#define QNAP_PIC_STATUS_OFF				0x59
#define QNAP_PIC_USB_LED_ON				0x60
#define QNAP_PIC_USB_LED_BLINK			0x61
#define QNAP_PIC_USB_LED_OFF			0x62
#define QNAP_PIC_SOFTWARE_REBOOT     	0x66

// The following definition just for user mode application
#define ERROR_NO_ERROR			0x0000
#define ERROR_NO_HD			0x0001
#define ERROR_HD_WRONG_FORMAT		0x0002
#define ERROR_HD_ALMOST_FULL		0x0010
#define ERROR_HD_BAD_BLOCK		0x0100
#define ERROR_NIC_DOWN			0x0200
#define ERROR_HD_FULL			0x1000
#define HD_STANDBY			0x10000

int Pic_Send_Raw_Cmd(int cmd);
int Pic_Send_Raw_Cmds(unsigned char *cmdP, int len);
int Pic_Send_Message(int event, int value);
void Set_Status_Led(int event, int status);

int Util_Send_Message(int command, char *dev_name, unsigned int timer, void *parameter);

typedef struct message {
	int command;
	char device[50];
        int timer;
        void *parameter;
} MESSAGE;

enum command {
	ENABLE_CHECK_POWERMODE=1,
	DISABLE_CHECK_POWERMODE,
	ENABLE_CHECK_FREE_SIZE,
	DISABLE_CHECK_FREE_SIZE,
	CHANGE_DISK_FREE_SIZE,
	PLUGOUT,
	RAID_STAT_CHANGED,
	FORMAT,
	CHECK,
	TO_READY,
	CHANGE_TIMEOUT,
	PLUGIN
};

#define	HD_NORMAL	0
#define	HD_INIT		1
#define	HD_FULL		2
#define	HD_ALMOST_FULL	4
#define	HD_STANDBYMODE	8

#endif /* __PPC_PLATFORMS_QNAP_PIC_USER_H */
