//**************************************************************************
//
//      Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//      FILE:
//              	mail_basic.h
//
//      Abstract:
//              	Mail Basic Function Library.
//
//      FUNCTIONS:      TBD.
//
//      COMMENTS:       N/A
//
//      HISTORY:
//      05/10/2002      Johnson Hsu created
//
//**************************************************************************
							
//#define _DEBUG
//#undef	_DEBUG

#ifndef		_MAIL_BASIC
#define		_MAIL_BASIC

typedef	long	LONG;

#define MAIL_DEFAULT_HOME			"/home"
#define MAIL_DEFAULT_MAILDIR			"Maildir"
#define MAIL_PASSWD_PROG			"/usr/bin/passwd"
#define MAIL_TCPRULES_PROG			"/usr/local/bin/tcprules"
#define MAIL_MAILDIRMAKE_PROG			"/usr/local/bin/maildirmake"
#define MAIL_CHOWN_PROG				"/bin/chown"
#define MAIL_RM_PROG				"/bin/rm"
#define MAIL_MKDIR_PROG				"/bin/mkdir"

#define MAIL_NULL_DEV				"/dev/null"

#define MAIL_RELAY_TCPSMTP_FILE			"/etc/tcp.smtp"
#define MAIL_RELAY_CDB_FILE			"/etc/tcp.smtp.cdb"
#define MAIL_RELAY_TEMP_FILE			"/etc/tcp.smtp.temp"
#define MAIL_RELAY_IEI_FILE			"/etc/config/mail/tcp.smtp.iei"
#define MAIL_INIT_USER_MAILDIR			"./Maildir/"
#define MAIL_FILE_PATH_ULINUX			"/etc/config/uLinux.conf"
#define MAIL_PROG_SCRIPT_PATH			"/etc/rc.d/init.d"
#define MAIL_PROG_SCRIPT			"qmail"
#define MAIL_PROG_SCRIPT_START_CMD		"start"
#define MAIL_PROG_SCRIPT_STOP_CMD		"stop"
#define MAIL_PROG_SCRIPT_RESTART_CMD		"restart"
#define MAIL_PROG_SCRIPT_STAT_CMD		"stat"
#define MAIL_PROG_SCRIPT_PAUSE_CMD		"pause"
#define MAIL_PROG_SCRIPT_CONT_CMD		"cont"
#define MAIL_PROG_SCRIPT_CDB_CMD		"cdb"
#define MAIL_PROG_SCRIPT_DOQUEUE_CMD		"doqueue"
#define MAIL_PROG_SCRIPT_RELOAD_CMD		"reload"
#define MAIL_PROG_SCRIPT_QUEUE_CMD		"queue"
#define MAIL_PROG_SCRIPT_ALRM_CMD		"alrm"
#define MAIL_PROG_SCRIPT_HUP_CMD		"hup"
#define MAIL_PROG_SCRIPT_TMP_FILE		"/tmp/qmail.status"
#define MAIL_PROG_SCRIPT_NON_RUNNING_STR	"not running"
#define MAIL_APP_ULINUX				"MAIL"
#define MAIL_SUPPORT_KEY_ULINUX			"Support"
#define MAIL_DEFAULT_ENABLE_ULINUX		FALSE
#define MAIL_DEFAULT_ENABLE_FORCE		FALSE

#define	USERADD_PATH				"/usr/sbin/useradd"
#define	USERDEL_PATH				"/usr/sbin/userdel"
#define	USERMOD_PATH				"/usr/sbin/usermod"

#define MAIL_HSTR_LENGTH 			2048
#define MAIL_LSTR_LENGTH 			1024
#define MAIL_MSTR_LENGTH 			254
#define MAIL_SSTR_LENGTH 			64
#define MAIL_NSTR_LENGTH 			32
#define MAIL_READLINE_LENGTH			80
#define MAIL_USER_HOME_DIR_LENGTH		128

// define error codes <begin>
#ifndef _mail_errno_h
#define _mail_errno_h

#define MAIL_SUCCESS				0
#define MAIL_FAIL				-1
#define MAIL_CREATE_FAIL			-2
#define MAIL_DELETE_FAIL			-3
#define MAIL_REFRESH_FAIL			-4
#define MAIL_INIT_FAIL				-5
#define MAIL_SERVER_ALREADY_RUNNING		-6
#define MAIL_SERVER_NOT_RUNNING			-7
#define MAIL_MODEL_NOT_SUPPORT_MAIL		-8

#define MAIL_ERROR_USER_ALREADY_EXISTED		-101
#define MAIL_ERROR_RESERVED_USER		-102
#define MAIL_ERROR_USER_NOT_EXIST		-103
#define MAIL_ERROR_ILLEGAL_NAME			-104
#define MAIL_ERROR_EMPTY_STRING			-105
#define MAIL_ERROR_RELAY_DUPLICATE		-106
#define MAIL_ERROR_IEI_RELAY_NOT_FOUND		-107
#define MAIL_ERROR_RELAY_NOT_FOUND		-108
#define MAIL_ERROR_TRANSFER_IP_MASK		-109
#define MAIL_ERROR_ILLEGAL_IP			-110
#define MAIL_ERROR_ILLEGAL_MASK			-111
#define MAIL_ERROR_ILLEGAL_ALLOW_VALUE		-112
#define MAIL_ERROR_NOT_FOUND_TARGET		-113
#define MAIL_ERROR_BUF_LENGTH_TOO_SHORT		-114	

#define MAIL_ERROR_FILE_ALREADY_EXIST		-990
#define MAIL_ERROR_INIT_USER_CTRL_FILE		-991
#define MAIL_ERROR_CREATE_USER_HOME		-992
#define MAIL_ERROR_NOT_FOUND			-993
#define MAIL_ERROR_TRANSFER_RULE_TO_CDB		-994
#define MAIL_ERROR_CHECK_SCRIPT_FILE_FAIL	-995
#define MAIL_ERROR_READLINE_FAIL		-996
#define MAIL_ERROR_OPENFILE_FAIL		-997
#define MAIL_ERROR_WRITEFILE_FAIL		-998
#define MAIL_ERROR_EXEC_FAIL			-999
#define MAIL_UNDEFINE_TYPE			-1000

#endif
// define error code <end>

#define MAIL_VERSION				1.0
#define	CRYPT_SALT_NO				"Icp"
#define NASCRYPT				bigcrypt	

extern char *bigcrypt(const char *key, const char *salt);

#define MAIL_RELAY_RULE_DEFAULT_ALLOW		"allow"
#define MAIL_RELAY_RULE_DEFAULT_CLIENT		"RELAYCLIENT"
#define MAIL_RELAY_RULE_DEFAULT_SYM		"\"\""
#define MAIL_RELAY_RULE_DEFAULT_RULE		":allow"

typedef struct tagMAIL_HEADER
{
	float	version;
	int	bodysize;
	int	num;
	LONG	reserved;
} MAIL_HEADER;

typedef struct tagMAIL_RELAY
{
	int 	ip[4];
	int 	mask[4];
	int 	allow;
	char 	describe[20];
	LONG 	reserved;
	struct	tagMAIL_RELAY	*next;
} MAIL_RELAY;

typedef enum {  Bin, Oct, Dec, Hex } CodeType;

///////////////////////
//  public function
///////////////////////
int Start_Mail_System(BOOL force);
int Stop_Mail_System(BOOL force);
int Restart_Mail_System(BOOL force);
void _DEBUG_MAIL_RELAY(MAIL_RELAY *iei_relay);
int Create_System_User_For_Mail(char *user_name, char *passwd, char *group_name, char *home_dir);
int Create_NAS_User_For_Mail(char *user_name, char *pass_wd);
MAIL_RELAY *Mail_Get_IEI_Relay();
void Mail_Free_IEI_Relay(MAIL_RELAY *iei_relay);
int Mail_Prog_Running_Status();
BOOL Mail_Transfer_Rule_To_Cdb(char *src_file, char *dest_file);
BOOL Is_Mail_Support();
BOOL Mail_Enable(BOOL enable);
int Mail_Create_User(char *user_name, char *pass_wd);
int Mail_Transfer_User_Name_To_Gid(char *user_name);
int Int2Str(int value, char* buff, int buff_size, CodeType type);
int Mail_Delete_User(char *user_name);
int Mail_Delete_User_Home_Dir(char *user_name);
BOOL Mail_Init_User_Ctrl_File(char *user_name);
int Mail_Check_User_Home_Exist(char *user_name);
int Mail_Check_User_All_Items(char *user_name);
BOOL Mail_Check_Uid(char *user_name);
int Mail_Refresh_User();
BOOL Mail_User_Enable(BOOL enable, char *user_name);
int Mail_Get_Home_Dir(char *directory, int length, char *user_name);
int Mail_Relay_Set_Rule(MAIL_RELAY *start_relay);
int Mail_Add_IEI_Relay(MAIL_RELAY *new);
int Mail_Del_IEI_Relay(MAIL_RELAY *del);
int Mail_Edit_IEI_Relay(MAIL_RELAY *new, MAIL_RELAY *old);
BOOL Mail_Relay_Clear_Rule();

////////////////////////////
//  private function
////////////////////////////
int mail_transfer_ip_mask_to_rule(int *ip, int *mask, char (*nw)[8], int *last_zero);
int mail_write_iei_relay(MAIL_RELAY *iei_relay);
//void erase_char(char *origin);
int mail_write_header(FILE *fptr, int bodysize, int num);
int mail_write_iei_relay(MAIL_RELAY *iei_relay);
int mail_comp_iei_relay(MAIL_RELAY *iei_relay1, MAIL_RELAY *iei_relay2);

#endif
