//**************************************************************************
//
//	Copyright (c) 2002  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		mail.h
//
//	Abstract: 
//		mail server configuration function header file
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		05/28/02	Tiger Fu created
//
//**************************************************************************
#ifndef	__MAIL__
#define __MAIL__

#define		USER_NAME_LENGHT	32

typedef struct {
	int	ver;
	char	id[32];
	char	owner[USER_NAME_LENGHT];
} MAIL_AB_GROUP_INFO, * PMAIL_AB_GROUP_INFO;

typedef struct {
	int	ver;
	char	id[32];
	char	relname[32];
	char	nickname[32];
	char	city[256];
	char	address[256];
	char	tel[32];
	char	mobil[32];
	char	company[256];
	char	company_address[256];
	char	company_city[256];
	char	company_tel[32];
	char	company_fax[32];
	char	email[128];
	char	owner[32];
} MAIL_AB_USER_INFO, * PMAIL_AB_USER_INFO;

typedef struct {
	char	id[32];
	PMAIL_USER_LIST * next;
}MAIL_UER_LIST, *PMAIL_USER_LIST;

typedef struct {
	char	id[32];
	PMAIL_GROUP_LIST * next;
}MAIL_GROUP_LIST, *PMAIL_GROUP_LIST;

int Mail_AB_Create_Group (MAIL_AB_GROUP_INFO * group, char * owner);
int Mail_AB_Delete_Group (MAIL_AB_GROUP_INFO * group, char * owner);
int Mail_AB_Modify_Group (MAIL_AB_GROUP_INFO * old_group, MAIL_AB_GROUP_INFO * new_group, char * owner);
int Mail_AB_Create_User (MAIL_AB_USER_INFO * user, char * owner);
int Mail_AB_Delete_User (MAIL_AB_USER_INFO * user, char * owner);
int Mail_AB_Modify_User (MAIL_AB_USER_INFO * old_user, MAIL_AB_USER_INFO * new_user, char * owner);
int Mail_AB_Add_Group_Member (MAIL_USER_LIST * user_list, char * group, char owner);
int Mail_AB_Del_Group_Member (MAIL_USER_LIST * user_list, char * group, char owner);
AB_GROUP_LIST * Mail_Get_Group (char * owner);
AB_USER_LIST * Mail_Get_User (char * owner);
AB_USER_LIST * Mail_Get_Group_User (char * group, char * owner);
AB_GROUP_LIST * Mail_AB_Sort_Group (AB_GROUP_LIST * group);
AB_USER_LIST * Mail_AB_Sort_USER (AB_USER_LIST * user, char * grp_key);
BOOL Mail_AB_Free_Group (AB_GROUP_LIST * group);
BOOL Mail_AB_Free_User (AB_USER_LIST * user);
