#define CGI_LINE		1024
#define CGI_MAX_PATH		1024

#define CGI_Output_Html_Ex	CGI_Output_Html1

#define CGI_LOAD_HTML		"/home/httpd/cgi_load.html"

#define CGI_FAIL			-1
#define CGI_SUCCESS			0
#define CGI_HTML_NOT_FOUND		-1
#define CGI_UPLOAD_LEN_NOT_ENOUGH	-2
#define CGI_UPLOAD_WRITE_ERROR		-3

#define CGI_UNKNOWN		0
#define CGI_MSIE		1
#define CGI_NETSCAPE		2
#define CGI_MOZILLA_MAC		3
#define CGI_MOZILLA		4
#define CGI_MSIE_MAC		5
#define CGI_MOZILLA_LINUX	6

#define CGI_TYPE_UPLOAD		1
#define CGI_TYPE_NORMAL		2

#define CGI_REPLACE_OK		0
#define CGI_REPLACE_FAIL	-1

#define CGI_USE_DEFINE		1
#define CGI_USE_ORIGINAL	2

#define CGI_LANG_ENG		1
#define CGI_LANG_CHT		2
#define CGI_LANG_CHS		3
#define CGI_LANG_JPN		4
#define CGI_LANG_KOR		5
#define CGI_LANG_FRE		6
#define CGI_LANG_GER		7
#define CGI_LANG_ITA		8
#define CGI_LANG_POR		9
#define CGI_LANG_SPA		10
#define CGI_LANG_DUT		11
#define CGI_LANG_NOR		12
#define CGI_LANG_FIN		13
#define CGI_LANG_SWE		14
#define CGI_LANG_DAN		15
#define CGI_LANG_RUS		16

typedef struct tagINPUT
{
        char 		*name;
        char 		*val;
        struct tagINPUT	*next;
} INPUT;

typedef struct
{
	char		remote_user[256];
	char		remote_addr[20];
	char		pwd[64];
	long		content_length;
	int		content_type;
	int		browser;
	char		host_addr[20];
} HTTP_INFO;

typedef struct
{
	long		predata;
	long		nowdata;
	char		path[CGI_LINE];
	char		filename[CGI_LINE];
	char		src[CGI_MAX_PATH];
	int		type;
} UPLOAD;

char	*strstrip(char *src, char *token, char **next);

/* below are export API function */
INPUT	*CGI_Get_Input();				/* need CGI_Free_Input */
INPUT	*CGI_Get_Input_URL();				/* need CGI_Free_Input */
INPUT	*CGI_Get_Input_FORM();				/* need CGI_Free_Input */
INPUT   *CGI_Get_Parameter(INPUT *arg, char *name);	/* need CGI_Free_Input */
INPUT   *CGI_Find_Parameter(INPUT *arg, char *name);
void	CGI_Free_Input(INPUT *arg);
void	CGI_Debug_Input(INPUT *arg);
int	CGI_Output_Html(char *filename, char *token, int (*replace)(FILE *fptr, char *oldstr));
int	CGI_Output_Html1(char *filename, char *token, int (*replace)(FILE *fptr, char *oldstr, void *), void *);
void	CGI_Get_Http_Info(HTTP_INFO *http_info);
void	CGI_Check_User();
int	CGI_Get_Language();
void	CGI_Init();
int	CGI_Upload(char *path, char *filename, char *src);
int	CGI_Load_Html(char *filename);
int	CGI_Get_Text_IP(char *addr, int len, INPUT *input, char *name1, char *name2, char *name3, char *name4);
void 	Trim(char*);

