#define FTP_SUCCESS	0
#define FTP_FAIL	-1

#define FTP_CONF_PATH	"/etc/config/proftpd.conf"
#define SZ_FTP_SECTION	"FTP"
#define SZ_ENABLE_FIELD	"Enable"

#define LINE		204800

#define FTP_READLIST	1
#define FTP_DENYLIST	2
#define FTP_WRITELIST	3

#define NAS_SMB_LIB		1
typedef struct
{
	char	servername[256];
	int		enable;			/* 1:on		0:off */
	int		port;
	int		maxinstances;
	int		allowanonymous;
	int		maxanonymous;
	char	user[20];
	char	group[20];
	char	defaultroot[256];
//paul
	int		unicode;
	int		charsetremote;
	int		charsetlocal;
} TAG_FTP;

int ftp_create_conf();

//====================================
// move to NAS.h and share.c
//===================================
/*
#ifndef NAS_SMB_LIB
typedef struct
{
	char			username[20];
	struct USER_LIST	*next;
} USER_LIST;

typedef struct
{
	char			sharename[20];
	char			path[256];
	USER_LIST		*invalid;
	USER_LIST		*read;
	USER_LIST		*write;
	struct SMB_SHARE_INFO	*next;
} SMB_SHARE_INFO;
#endif
*/
/* export function */
#ifndef NAS_SMB_LIB
SMB_SHARE_INFO *SMB_Get_Share_Info();
void SMB_Free_Share_Info(SMB_SHARE_INFO *smb_share_info);
#endif

int Ftp_Read_Tag(TAG_FTP *tag);
int Ftp_write_Tag(TAG_FTP *tag);
int FTP_Create_Conf();
int FTP_First_Create_Conf();
int Start_Ftp();
int Restart_Ftp();
int Stop_Ftp();
int Reconfig_Ftp();
BOOL Is_Ftp_Enabled();
BOOL Is_Ftp_Started();
int Enable_Ftp(int bEnable);
int FTP_Reset();
int Restart_FTP();

