#ifndef		_CFG_DNS
#define		_CFG_DNS

//  uLinux.conf
#define		DNS_SECTION		"DNS Server"
#define		WHICH_PAGE		"Which Page"
#define		ENABLE			"Enable"
#define		MODIFY_ACTION		"Modify Action"
#define		NAMED_CONF		"Named conf"
#define		DB_PATH			"DB path"
#define		DOMAIN_NAME		"Domain Name"
#define		NAME_SERVER_TYPE	"Name Server Type"
#define		CONFIG_MODIFIED		"Config Modified"
					 
#define		GET_PROFILE_STRING		Get_Profile_String
#define		GET_PRIVATE_PROFILE_STRING	Get_Private_Profile_String
#define		SET_PROFILE_STRING		Set_Profile_String
#define		SET_PRIVATE_PROFILE_STRING	Set_Private_Profile_String
#define		GET_PROFILE_INTEGER		Get_Profile_Integer
#define		GET_PRIVATE_PROFILE_INTEGER	Get_Private_Profile_Integer

#define		S_HINT			0
#define		S_MASTER_ZONE		1
#define		S_SLAVE_ZONE		2

enum e_nstype {E_Un_Know_Type = -1, E_Master, E_Slave, E_Cache};

typedef struct {

	char zone_name[256];
	char zone_type[8];
	char zone_file[256];
}ZONE_INFO;

typedef struct {
	
	ZONE_INFO zone_info;
	char masters_ip[16];
}SLAVE_ZONE_INFO;

//  public function
BOOL Is_Support_DNS();
BOOL Is_DNS_Enable (void);
BOOL is_private_dns_enable (char * cfg_file);
int set_private_dns_enable (BOOL Enable, char * cfg_file);
BOOL Enable_DNS (BOOL Enable);
void Reload_DNS_Config (void);
int Get_Name_Server (int index, char * buf, int size);
BOOL Set_Name_Sever (int index, char * nameserver);

//  private function
int get_which_page (void);
int get_private_which_page (char * cfg_file);
void set_which_page (int page);
void set_private_which_page (int page, char * cfg_file);
void set_modify_action (BOOL action);
void set_private_modify_action (BOOL action, char * cfg_file);
char * get_domain_name (void);
char * get_private_domain_name (char * cfg_file);
BOOL set_domain_name (char * domain_name);
BOOL set_private_domain_name (char * domain_name, char * cfg_file);
char * get_conf_file_name (void);
enum e_nstype get_ns_type (void);
enum e_nstype get_private_ns_type (char * cfg_file);
BOOL set_ns_type (enum e_nstype type);
BOOL set_private_ns_type (enum e_nstype type, char * cfg_file);
BOOL is_modify (void);
char * get_db_path (void);

BOOL check_section_whether_exist (char * zone_name);
BOOL check_private_section_whether_exist (char * zone_name, char * cfg_file);

//  master zone funtcion
int get_master_zone_number (void);
int get_private_master_zone_number (char * cfg_file);
char * get_master_zone_name (int index);
char * get_private_master_zone_name (int index, char * cfg_file);
int get_master_zone_info (char * zone_name, ZONE_INFO * zone_info);
int get_private_master_zone_info (char * zone_name, ZONE_INFO * zone_info, char * cfg_file);
BOOL set_master_zone_info (ZONE_INFO * zone_info);
BOOL set_private_master_zone_info (ZONE_INFO * zone_info, char * cfg_file);
int modify_master_zone_info (char * zone_name, int index);
int modify_private_master_zone_info (char * zone_name, int index, char * cfg_file);
int remove_master_zone_info (int index);
int remove_private_master_zone_info (int index, char * cfg_file);

int get_zone_resource_record_number (char * zone_name);
int get_private_resource_record_number (char * zone_name, char * cfg_file);
int set_zone_resource_record (char * zone_name, char * resource_record);
int set_private_resource_record (char * zone_name, char * resource_record, char * cfg_file);
int remove_zone_record_by_index (char * zone_name, int index);
int remove_private_record_by_index (char * zone_name, int index, char * cfg_file);
int remove_zone_record_by_value (char * zone_name, char * value);
int remove_private_record_by_value (char * zone_name, char * value, char * cfg_file);
char * get_zone_resource_record (char * zone_name, int index);
char * get_private_resource_record (char * zone_name, int index, char * cfg_file);
void permutation_private_resource_record (char * zone_name, int index, int total, char * cfg_file);

//  slave zone function
int get_slave_zone_number (void);
int get_private_slave_zone_number (char * cfg_file);
char * get_slave_zone_name (int index);
char * get_private_slave_zone_name (int index, char * cfg_file);
int get_slave_zone_info (char * zone_name, SLAVE_ZONE_INFO * zone_info);
int get_private_slave_zone_info (char * zone_name, SLAVE_ZONE_INFO * zone_info, char * cfg_file);
BOOL set_slave_zone_info (SLAVE_ZONE_INFO * zone_info);
BOOL set_private_slave_zone_info (SLAVE_ZONE_INFO * zone_info, char * cfg_file);
int remove_slave_zone_by_index (int index);
int remove_private_slave_zone_by_index (int index, char * cfg_file);
int remove_slave_zone_by_value (char * value);
int remove_private_slave_zone_by_value (char * value, char * cfg_file);

//  both of them function
void permutation_zone (int type, int index, int total);
void permutation_private_zone (int type, int index, int total, char * cfg_file); //  type = 1->master 2->slave

//  forwarders function
int get_forwarders_number (void);
int get_private_forwarders_number (char * cfg_file);
BOOL set_forwarders (char * ip);
BOOL set_private_forwarders (char * ip, char * cfg_file);
int remove_forwarders (int index);
int remove_private_forwarders (int index, char * cfg_file);
char * get_forwarders (int index);
char * get_private_forwarders (int index, char * cfg_file);
int get_forwarders_index (char * forwarders);
int get_private_forwarders_index (char * forwarders, char * cfg_file);
void permutation_private_forwarders (int index, int total, char * cfg_file);
int check_value_exist (char * keyname);
int check_private_value_exist (char * keyname, char * cfg_file);

#endif

