/**************************************************************************
**	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
**
**	FILE:
**		backup.h
**
**	ABSTRACT: 
**
**	FUNCTIONS:
**
**	COMMENTS:
**
**	HISTORY:
**		2002/06/03	Created by Ellis
**
**************************************************************************/

#ifndef _BACKUP_H_
#define _BACKUP_H_

/*
** macros
*/
#ifndef SUCCESS
#define SUCCESS		(0)
#endif

#define E_SRC		(-1)
#define E_DEST		(-2)
#define E_COMPRESS	(-3)
#define E_COPY		(-4)
#define E_REMOVE	(-5)
#define E_MALLOC	(-6)

#define BACKUP_COPY_TIMESTAMP	(0x01)
#define BACKUP_COPY_COMPRESS	(0x02)
#define BACKUP_COPY_SYNC	(0x04)
#define BACKUP_COPY_STOP_SERVICE (0x08)
/*
** global variable declarations
*/
#ifndef NDEBUG
extern int _Debug;
#endif

/*
** global function declarations
*/
/** About the function's spec, please reference the document: "Backup_Copy Spec.doc". */
extern int Backup_Copy(const char *src, const char *dest, int option, int pid, char *name);
/** About the function's spec, please reference the document: "Backup_Sync Spec.doc". */
extern int Backup_Sync(const char *src, const char *dest, int bcompress, int pid, char *name);

#endif /** _BACKUP_H_ */
