/*****  Created by Ken Chen   2005/07/07 *****/

#define MAX_NODE_PER_PAGE      		18
#define MAXNUM_OF_DIR_DEPTH    		8
#define MAXNUM_OF_PHOTO        		2000
#define MAXNUM_OF_DIR          		1000
#define MINISIZE_OF_PHOTO_FILE 		100000
#define IMG_TOOL_DIR           		"/usr/bin"
#define IMR_MUSIC_FORMAT ".wma,.wax,.cda,.wav,.mp3,.m3u,.mid,.midi,.rmi,.aif,.aifc,.aiff,.au,.snd"
#define IMR_VIDEO_FORMAT ".wmx,.wvx,.avi,.mpeg,.mpg,.mpe,.m1v,.mp2,.mpv2,.mp2v,.mpa,.dvr-ms,.asf,.asx,.wpl,.wm,.wmd,.wmz"

#define LOG		1
#define NO_LOG	0

#define IMRD_PID		"/var/run/ImRd.pid"

struct file_data {
	int type;
	char fname[1024];
	long fsize;
	long mtime;
};

typedef struct folder_content {
	/*file/folder count*/
	int total; /*total number of files/folder in the current page*/
	int new_image; /*the number of new images in the current page*/
	int file_count;
	int dir_count;
	/*page*/
	int total_page;
	int page_num;
	/*sort type*/
	int sorttype;
	char folder[1024];
	struct file_data file[18];
}IMR_PAGE_CONTENT;

// check and update thumb and resized photo in the specified dir
int ImR_Generate_Thumb(char *dir_path, int force); 
int ImR_Get_Dir_Depth(const char *dir_path); 
int ImR_Scan_New_Photo(char *folder); //check new photos
void ImR_Clean_Useless_Thumb(char *dir_path); // Remove useless thumbs
int ImR_Check_Count_Down_Number(char *folder); //check new photos
int ImR_Get_Image_Size(char *img);
void ImR_Get_File_Extension(char *fname, char **ptr);
char* ImR_Str_Case_Str(char *haystack, char *needle);
int ImR_Get_Page_Content(char *path, int page_no, int sorttype, IMR_PAGE_CONTENT *ifc);
int ImR_Check_Page_Thumb(IMR_PAGE_CONTENT *ifc);
int ImR_Generate_Thumb_Page(IMR_PAGE_CONTENT *ifc, int *flagnewjob, int force);
int ImR_Is_The_Same_Job(char *folder, int page_num, int sorttype);
int resize_jpeg_image(char *ofile, char *nfile, int nsize, int log_or_not);
