//------------------------------------------------------------------------- 
//-- This Program need work with the /sbin/mke2fs & /sbin/e2fsck commands -
// Apr 23 2001: In new_partition() -> change to create first partition size
//              from 10 to 65 MB, the 64 MB will be used as swap file
// May 15 2001: In new_partition() -> change to create 3 partitions, first
//              is 10M Bytes, 2'nd is 32 M Bytes for swapping, the rest
//              is the data partition.
//-------------------------------------------------------------------------

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <setjmp.h>
#include <errno.h>
#include <endian.h>
#include <sys/stat.h>     /** mkdir() **/

#include <sys/ioctl.h>

#include <linux/types.h>
#include <linux/genhd.h>
#include <linux/hdreg.h>
//#include <scsi/scsi.h>
#include <linux/major.h>
//#include <linux/fs.h>

#include <sys/types.h>       /** mkdir() **/
#include <sys/utsname.h>
#include <sys/vfs.h>
#include <sys/mount.h>     /** mount(), Mark by Nick 2000/12/14 **/
//#include <linux/fs.h>


#include "soft-raid.h"
//#include "public_lib.h"
#include "ds_fdisk.h"
#include "ds_fdisk-ext.h"

#include "public_lib.h"
#include "Util.h"


#if 0
#include <linux/proc_fs.h>
#endif

//#include "fdisk.h"
//#include "fdisksunlabel.h"

#define	ReadCFGData	Conf_Get_Field
#define	WriteCFGData	Conf_Set_Field

#define PROGRAM_NAME   "FDISK"     /** Add by Nick **/
extern  char *HD_ROOT_MP[MAX_RHD_NO];

#define hex_val(c)      ({ \
                                char _c = (c); \
                                isdigit(_c) ? _c - '0' : \
                                tolower(_c) + 10 - 'a'; \
                        })


#define VERSION "2.1 (>4GB)"

#define DEFAULT_DEVICE  "/dev/hda"
#define ALTERNATE_DEVICE "/dev/sda"
#define LINE_LENGTH     80
#define MAXIMUM_PARTS   60
#define PART_TABLE_FLAG 0xaa55
#define table_check(b)  ((unsigned short *)((b) + 0x1fe))
#define offset(b, n)    ((struct partition *)((b) + 0x1be + \
                                (n) * sizeof(struct partition)))
#define sector(s)       ((s) & 0x3f)
#define cylinder(s, c)  ((c) | (((s) & 0xc0) << 2))

#define calculate(h,s,c) (sector(s) - 1 + sectors * \
                                ((h) + heads * cylinder(s,c)))
#define set_hsc(h,s,c,sector) { \
                                s = sector % sectors + 1;       \
                                sector /= sectors;      \
                                h = sector % heads;     \
                                sector /= heads;        \
                                c = sector & 0xff;      \
                                s |= (sector >> 2) & 0xc0;      \
                        }

#define ACTIVE_FLAG     0x80
#define EXTENDED        5

#define LINUX_PARTITION 0x81
#define LINUX_SWAP      0x82
#define LINUX_NATIVE    0x83

/* normally O_RDWR, -l option gives O_RDONLY */
static int type_open = O_RDWR;

char    *disk_device = DEFAULT_DEVICE,  /* hda, unless specified */
        *line_ptr,                      /* interactive input */
        line_buffer[LINE_LENGTH],
        changed[MAXIMUM_PARTS],         /* marks changed buffers */
        buffer[SECTOR_SIZE],            /* first four partitions */
        *buffers[MAXIMUM_PARTS]         /* pointers to buffers */
                = {buffer, buffer, buffer, buffer};

int     fd,                             /* the disk */
        ext_index,                      /* the prime extended partition */
        //listing = 0,                  /* no aborts for fdisk -l */
        dos_compatible_flag = ~0,
        partitions = 4;                 /* maximum partition + 1 */

uint    heads,
        sectors,
        cylinders,
        sector_offset = 1,
        display_factor = 1,             /* in units/sector */
        unit_flag = 1,
        full_bits = 0,                  /* 1024 cylinders in sectors */
        extended_offset = 0,            /* offset of link pointers */
        offsets[MAXIMUM_PARTS] = {0, 0, 0, 0};
        
int     other_endian = 0;
int     sun_label = 0;                  /* if we're looking at sun disklabel */
int     scsi_disk = 0;
int     floppy = 0;

struct  partition *part_table[MAXIMUM_PARTS]    /* partitions */
                = {offset(buffer, 0), offset(buffer, 1),
                offset(buffer, 2), offset(buffer, 3)},
        *ext_pointers[MAXIMUM_PARTS]            /* link pointers */
                = {NULL, NULL, NULL, NULL};

struct systypes sys_types[] = { /* struct systypes in fdisk.h *//* bf */
                {0, "Empty"},
                {1, "DOS 12-bit FAT"},
                {2, "XENIX root"},
                {3, "XENIX usr"},
                {4, "DOS 16-bit <32M"},
                {EXTENDED, "Extended"},
                {6, "DOS 16-bit >=32M"},
                {7, "OS/2 HPFS"},               /* or QNX? */
                {8, "AIX"},
                {9, "AIX bootable"},
                {10, "OS/2 Boot Manager"},
                {0x40, "Venix 80286"},
                {0x51, "Novell?"},
                {0x52, "Microport"},            /* or CPM? */
                {0x63, "GNU HURD"},             /* or System V/386? */
                {0x64, "Novell Netware 286"},
                {0x65, "Novell Netware 386"},
                {0x75, "PC/IX"},
                {0x80, "Old MINIX"},            /* Minix 1.4a and earlier */

                {LINUX_PARTITION, "Linux/MINIX"}, /* Minix 1.4b and later */
                {LINUX_SWAP, "Linux swap"},
                {LINUX_NATIVE, "Linux native"},

                {0x93, "Amoeba"},
                {0x94, "Amoeba BBT"},           /* (bad block table) */
                {0xa5, "BSD/386"},
                {0xb7, "BSDI fs"},
                {0xb8, "BSDI swap"},
                {0xc7, "Syrinx"},
                {0xdb, "CP/M"},                 /* or Concurrent DOS? */
                {0xe1, "DOS access"},
                {0xe3, "DOS R/O"},
                {0xf2, "DOS secondary"},
                {0xff, "BBT"}                   /* (bad track table) */
        };

#define SUNOS_SWAP 3
#define WHOLE_DISK 5
struct systypes sun_sys_types[] = { /* struct systypes in fdisk.h */
                {0, "Empty"},
                {1, "Boot"},
                {2, "SunOS root"},
                {SUNOS_SWAP, "SunOS swap"},
                {4, "SunOS usr"},
                {WHOLE_DISK, "Whole disk"},
                {6, "SunOS stand"},
                {7, "SunOS var"},
                {8, "SunOS home"},
                {LINUX_SWAP, "Linux swap"},
                {LINUX_NATIVE, "Linux native"},
        };

int nsys_types = sizeof (sys_types) / sizeof (struct systypes); /* bf */

uint read_int(uint low, uint dflt, uint high, enum offset base, char *mesg);
char read_char(char *mesg);

//jmp_buf listingbuf;

inline unsigned short __swap16(unsigned short x) {
        return (((__u16)(x) & 0xFF) << 8) | (((__u16)(x) & 0xFF00) >> 8);
}
inline __u32 __swap32(__u32 x) {
        return (((__u32)(x) & 0xFF) << 24) | (((__u32)(x) & 0xFF00) << 8) | (((__u32)(x) & 0xFF0000) >> 8) | (((__u32)(x) & 0xFF000000) >> 24);
}

//--------------------------------------------------------------
// Delete one specified HD, all partitions
// The pass in parameter device_name, like as "/dev/hdc"
//--------------------------------------------------------------
int Delete_All_Partition(char *device_name)
{
    int get_boot(int action);
    //char cmd_line[80];
    int ret,j;

    disk_device = device_name;

    if ( get_boot(0) !=0 ) {
       #ifdef DEBUG
         printf(" get_boot() fail \n");
       #endif
       close (fd);
       return PL_FAIL;
    }

    /** it always return 0 currently **/
    if ( (ret=list_table(0)) !=0 ) {
       #ifdef DEBUG
         printf(" list_table() fail, ret=%d \n",ret);
       #endif
       close (fd);
       return PL_FAIL;
    }

    /*** Set Log Message ***/
    //sprintf(cmd_line," Delete %s all partition",device_name);
    //SetLogMsg(PROGRAM_NAME, cmd_line);
    /** Delete all exist partitions **/

    for (j=0;j<partitions;j++) {
        if ( delete_partition(j) !=0 ){
           #ifdef DEBUG
             printf(" delete_partition(%d) fail \n",j);
           #endif
           close (fd);
           return PL_FAIL;
        }
    }

    if ( write_table() !=0 ) {
       #ifdef DEBUG
         printf(" write_table() fail \n");
       #endif
       close (fd);
       return PL_FAIL;
    }

    return PL_OK;
 }
 /*------   Delete all Partition End   ------*/

//-----------------------------------------------------------------------------
// It will create two partitions, one is 10M, the other is the rest size
// of this HD, the first partition maybe larger than 10M, that is because
// it created partition use the cylinder as unit.
// The pass in parameter device_name, like as "/dev/hdc"
// Mar 20 2001, add one I/P parameter for the second partition size, if it's 0
// that meant it will been created with MAX Partition Size otherwise it
// represent MB it want to create.
// Mar 21 2001: It will Create Max Data Partition depend on the uLinux.conf
// [Storage] "Data Partition Size=500" field unit is MD, it will create 
// with Max partition if its value is 0
// May 23 2001: It will check the uLinux.conf [Storage] "Flash Disk=xxxx"
//              which defined in the soft-raid.h
//              If its value = True, then it will create one single max 
//              partition, otherwise create 3 partitions for traditional usage
//-----------------------------------------------------------------------------
int Create_Max_Partition(char *device_name)
{
    char buff[81];
    int  ret, mb_size=0;

    disk_device = device_name;

    if ( get_boot(0) !=0 ) {
       #ifdef DEBUG
         printf(" get_boot() fail \n");
       #endif
       close (fd);
       return PL_FAIL;
    }

    /** it always return 0 currently **/
    if ( (ret=list_table(0)) !=0 ) {
       #ifdef DEBUG
         printf(" list_table() fail, ret=%d \n",ret);
       #endif
       close (fd);
       return PL_FAIL;
    }

    /*** Set Log Message ***/
    //sprintf(cmd_line," Create one Max partition on %s",device_name);
    //SetLogMsg(PROGRAM_NAME, cmd_line);

    //-- Get the Max Partition Size
    // Lock file first 
    //if ( (ret=RW_Lock(LOCK_DISK, LOCK_READ)) !=PL_OK) {
    //  printf("Lock_DISK with READ fail, ret=%d \n", ret);
    //  return (ret);
    //}

    //mb_size = 0; // default value
    if ( ReadCFGData(DS_CONF_FILE, STORAGE_SESSION_NAME, DATA_PARTSZ_FIELD_NAME, buff, sizeof(buff))==PL_OK) {
      mb_size = atoi(buff);
    }

    //RW_Unlock(LOCK_DISK);
    /**** Create one Max Partition  *****/
    // May 23 2001: Modify new_partition() passin parameter
    // from (mb_size) to (int part_no, int part_type, int mb_size)
    

    if ( Use_Flash_Disk() ) {  // Just create one max DATA Partition
       // Create DATA Partition which partition no=3 
      if ( new_partition(2,LINUX_NATIVE, mb_size) !=0 ) {
         #ifdef DEBUG
           printf(" new_partition(0,LINUX_NATIVE, 10) fail \n");
         #endif
         close (fd);
         return PL_FAIL;
      }
    }
    else {
      // Create First ROOT Partition (10M)
      if ( new_partition(0,LINUX_NATIVE, 10) !=0 ) {
         #ifdef DEBUG
          printf(" new_partition(0,LINUX_NATIVE, 10) fail \n");
         #endif
	 close (fd);
         return PL_FAIL;
      }

      // Create the swap Partition (32M)
      if ( new_partition(1,LINUX_SWAP, 32) !=0 ) {
         #ifdef DEBUG
           printf(" new_partition(1,LINUX_SWAP, 32) fail \n");
         #endif
         close (fd);
         return PL_FAIL;
      }

      if ( new_partition(2,LINUX_NATIVE, mb_size) !=0 ) {
         #ifdef DEBUG
           printf(" new_partition(2,LINUX_NATIVE, mb_size) fail \n");
         #endif
         close (fd);
         return PL_FAIL;
      }
    }
    //=== Create Partitions End ===========

    if ( write_table() !=0 ) {
       #ifdef DEBUG
         printf(" write_table() fail \n");
       #endif
       close (fd);
       return PL_FAIL;
    }

    return PL_OK;
}

/*-----------------------------------------------------*/
/* Format, Now call mke2fs command                     */
/* Fortune you shold call Format_Part() in my_mke2fs.c */
/* part_name like as /dev/hdb1...                      */
/* if is_raid5 is HD_RAID5 the formatting with raid 5  */
/* command like as mke2fs -b 1024 -R stride=4 /dev/mdx */
/* id is_raidt is HD_NONRAID5 do normal command         */
/*-----------------------------------------------------*/
int Format_Partition(char *part_name, int is_raid5)
{
    char cmd_line[80];
    int  ret;

    //- June 26, If the part_name == FLASH_ROOT_PART_NAME Just return OK.
    if ( (Use_Flash_Disk()) && (strcmp(part_name,FLASH_ROOT_PART_NAME)==0) ) {
       return PL_OK;
    }


    if ( is_raid5==HD_RAID5 )
      sprintf(cmd_line,"/sbin/mke2fs -b 4096 -R stride=1 %s > /dev/null",part_name);
    else
      sprintf(cmd_line,"/sbin/mke2fs -b 4096 %s > /dev/null",part_name);
    #ifdef DEBUG
      printf("cmd_line = %s \n",cmd_line);
    #endif
 
    //- First get it original status  
      //hd_no = Get_HD_Integer(part_name);  
      //Get_HD_Status(hd_no, &hd_status);  
      
    //Set_HD_Status(hd_no, HD_FORMATTING);

    ret=system(cmd_line);
    if (ret !=0 ) {
       #ifdef DEBUG
         printf(" format disk fail \n");
       #endif

	 //Set_HD_Status(hd_no, hd_status); 	 
       return PL_FAIL;
    }

    //Set_HD_Status(hd_no, hd_status); 	 
    return PL_OK;
}

//----------------------------------------------------------
// Now it call e2fsck command
// part_name: /dev/hdc2
// action: CHECK_WITH_REPAIR  or CHECK_WITHOUT_REPAIR
// It will record progrss to SCAN_HD_PROGRESS_FILE
//----------------------------------------------------------
int Scan_Partition(char *part_name, int action)
{
    char  cmd_line[80];
    int   ret;
    //int   fd;

    //fd = open(SCAN_HD_PROGRESS_FILE, O_CREAT | O_RDWR | O_TRUNC | O_NONBLOCK);
    //if ( fd == -1)  return PL_OPEN_FILE;

    if ( strcmp(part_name, FLASH_ROOT_PART_NAME)==0)   return PL_OK;

    if (action==CHECK_WITH_REPAIR)
      //sprintf(cmd_line,"/sbin/e2fsck -pfy -C %d %s > /dev/null",fd,part_name);
      sprintf(cmd_line,"/sbin/e2fsck -pfy %s > /dev/null",part_name);
    else
      //sprintf(cmd_line,"/sbin/e2fsck -fy -C %d %s > /dev/null",fd,part_name);
      sprintf(cmd_line,"/sbin/e2fsck -fy %s > /dev/null",part_name);

    #ifdef DEBUG
      printf("cmd_line=%s \n",cmd_line);
    #endif

    //- First get it original status  
      //hd_no = Get_HD_Integer(part_name);  
      //Get_HD_Status(hd_no, &hd_status);  
      //Set_HD_Status(hd_no, HD_SCANNING);

    ret = system(cmd_line);
    ret = ret / 256;
    switch(ret) {
       case 0:
	 //Set_HD_Status(hd_no, hd_status);
               return PL_OK;
               break;
       case 1: /** file system errors corrected **/
	 //Set_HD_Status(hd_no, hd_status);
               return SCAN_ERR_CORRECT;
               break;
       case 2:
	 //Set_HD_Status(hd_no, hd_status); 
               return SCAN_ERR_CORRECT_NEED_REBOOT;
               break;
       case 4:
	 //Set_HD_Status(hd_no, hd_status);
              return SCAN_ERR_UNCORRECT;
              break;
       case 8:
	 //Set_HD_Status(hd_no, hd_status);
              return SCAN_ERR_OPERATIONAL;
              break;
       default:
	 //Set_HD_Status(hd_no, hd_status);
              return SCAN_ERR_UNKNOW;
              break;
    }

    //close (fd);
    //Set_HD_Status(hd_no, hd_status);
    return PL_OK;
}

//-----------------------------------------------------------------------------
// It will call mount()
// if it is already mounted, it return PL_OK & will not modify the /etc/mtab
// file
// if HD partition non-exist, return PART_NOEXIST
// part_name: like as /dev/hdc2
// mount_point: like as /mnt/hdc
// Mar 14 2001: Because after it mount its MP set as 755, so We need
// call chmod to change it permission to 777 
// Apr 10 2001: delete the lose+found directory after mount successful
// June 26 2001: If the [Storage] "Use Flash Disk" = True &
//               mount_part=ROOT_PART, Just return OK
//-----------------------------------------------------------------------------
int Mount_Partition(char *part_name, char *mount_point) {
    char cmd_line[80];
    int  action, ret;
    int  which_line;
    unsigned long rwflag=0xC0ED0000;

    //- June 26, parser the part_name==FLASH_ROOT_PART_NAME ?
    //- if it is, Just return OK.
    if ( (Use_Flash_Disk()) && (strcmp(part_name, FLASH_ROOT_PART_NAME)==0) ) {
       return PL_OK;
    }
    

    if ( mount(part_name, mount_point, "ext2",rwflag ,NULL) !=0 && errno != EBUSY) {
         #ifdef DEBUG
          printf("mount() fail \n");
         #endif
         if(errno==ENXIO) return PART_NOEXIST;
	 else  return PL_FAIL;
    }

    /*********************************************************/
    /** Write to /etc/mtab manually                         **/
    /** it will first find the device is in fstab file      **/
    /** If it in it replace it otherwise append a new line  **/
    /*********************************************************/
    which_line = 0;
    if ( (which_line=find_conf("/etc/mtab",NULL,SPACE,1,part_name,cmd_line,sizeof(cmd_line))) <0 ){ /** not found **/
        if ( (which_line=find_conf("/etc/mtab",NULL,TAB,1,part_name,cmd_line,sizeof(cmd_line))) <0 ) /** not found **/
           action = 1;   /** append **/
        else
           action = 2;   /** replace **/
    }
    else /** has found **/
           action = 2;    /** replace **/

    #ifdef DEBUG
      printf(" which_line=%d,  action=%d \n",which_line,action);
    #endif

    //- If you do append, maybe the target file is NULL, in this case
    //- edit_conf() will return PL_NOT_THIS_LINE
    sprintf(cmd_line,"%s %s ext2 rw 0 0\n",part_name,mount_point);
    if ( (ret=edit_conf("/etc/mtab",cmd_line,which_line,action)) !=0 ) {
       if ( (action==2 && ret !=PL_OK) || (action==1 && ret < PL_OK) ) {
          #ifdef DEBUG
           printf(" Write to mtab file fail \n");
          #endif
          return PL_WRITE_FILE;
       }
    }

    // After Mount Successful, Now chmod it MP to 777
    ret = chmod(mount_point, 00777);
    if ( ret !=0 ) {
      #ifdef DEBUG
       printf(" chmod(%s) fail \n", mount_point);
      #endif
      return PL_FAIL;
    }

    //-- Delete lost+found directory
    sprintf(cmd_line,"%s/lost+found",mount_point);
    ret = remove(cmd_line);
    if ( ret==-1 && errno !=ENOENT) { // remove() fail
      #ifdef DEBUG
       printf(" remove(%s) fail, errno=%d \n", cmd_line, errno);
      #endif
//      return PL_FAIL;		// The deletion of lost+found is minor action, no result code will be effected.
    }
    return PL_OK;
}

//------------------------------------------------------------
// It call the umount()
// part_name: like as /dev/hdc2  
//------------------------------------------------------------
int Umount_Partition(char *part_name)
{
    char cmd_line[80];
    int  action;
    int  which_line, i;

    //-- Try use umount command
    //sprintf(cmd_line,"umount %s",part_name);
    //action = system(cmd_line);
    //printf("cmd_line=%s, ret=%d \n",cmd_line,action/256);
    //return system(cmd_line);
    //-- Temp Test End 

    //- Ckeck it's Flash Disk & the part_name is belong to HD_ROOT_MP[]
    //- if it's just return PL_OK
    if ( Use_Flash_Disk() ) {
      if ( strcmp(part_name, FLASH_ROOT_PART_NAME)==0)  return PL_OK;
      // check the part_name is belong to ROOT_MP
      for (i=0; i< MAX_RHD_NO; i++) {
	if ( strcmp(HD_ROOT_MP[i], part_name)==0)  return PL_OK;
      }
    }

    if ( umount(part_name) !=0 ) {
       #ifdef DEBUG
        printf("umount() fail \n");
       #endif
       return HD_UMOUNT_FAIL;
    }

    /*********************************************************/
    /** Remove it from /etc/mtab                            **/
    /** it will first find the device is in fstab file      **/
    /** If it in it replace it otherwise append a new line  **/
    /*********************************************************/
    which_line = 0;
    if ( (which_line=find_conf("/etc/mtab",NULL,SPACE,1,part_name,cmd_line,sizeof(cmd_line))) <0 ){ /** not found **/
        if ( (which_line=find_conf("/etc/mtab",NULL,TAB,1,part_name,cmd_line,sizeof(cmd_line))) <0 ) /** not found **/
           action = 0;   /** No found it **/
        else
           action = 3;   /** delete **/
    }
    else /** has found **/
           action = 3;    /** replace **/

    if (action != 3) { /* not found */
       return PL_NOT_FOUND;
    }

    #ifdef DEBUG
      printf(" which_line=%d,  action=%d \n",which_line,action);
    #endif

      //action = 3;    /* delete it */
    if ( edit_conf("/etc/mtab",cmd_line,which_line,action) !=0 ) {
       #ifdef DEBUG
         printf(" Remove from mtab file fail \n");
       #endif
       return PL_WRITE_FILE;
    }

    return PL_OK;
}


/*********************************************************/
/** Write to /etc/fstab                                 **/
/** device_name: like as /dev/hdc2                      **/
/** it will first find the device is in fstab file      **/
/** If it in it replace it otherwise append a new line  **/
/*********************************************************/
int Write_To_Fstab(char *device_name, char *mount_point)
{
    int fstab_action;
    int which_line;
    char cmd_line[80];

    which_line = 0;
    if ( (which_line=find_conf("/etc/fstab",NULL,SPACE,1,device_name,cmd_line,sizeof(cmd_line))) <0 ){ /** not found **/
       if ( (which_line=find_conf("/etc/fstab",NULL,TAB,1,device_name,cmd_line,sizeof(cmd_line))) <0 ) /** not found **/
          fstab_action = 1;   /** append **/
       else
          fstab_action = 2;   /** replace **/
    }
    else /** has found **/
          fstab_action = 2;    /** replace **/

    #ifdef DEBUG
      printf(" which_line=%d,  action=%d \n",which_line,fstab_action);
    #endif

    sprintf(cmd_line,"%s1 %s ext2 defaults 1 2\n",device_name,mount_point);
    if ( edit_conf("/etc/fstab",cmd_line,which_line,fstab_action) !=0 ) {
       #ifdef DEBUG
         printf(" Write to fstab file fail \n");
       #endif
       return PL_FAIL;
    }

    return PL_OK;
}


//----------------------------------------------------------
// Remove line from /etc/fstab
// it will first find the device is in fstab file
// If it in it remove it otherwise doesn't do anything
// device_name: like as /dev/hdc2
// mount_point: like as /mnt/hdc
//-----------------------------------------------------------
int Remove_From_Fstab(char *device_name, char *mount_point) {
    int fstab_action;
    int which_line;
    char cmd_line[80];

    which_line = 0;
    if ( (which_line=find_conf("/etc/fstab",NULL,SPACE,1,device_name,cmd_line,sizeof(cmd_line))) <0 ){ /** not found **/
       if ( (which_line=find_conf("/etc/fstab",NULL,TAB,1,device_name,cmd_line,sizeof(cmd_line))) <0 ) /** not found **/
          return PL_OK;     /** return successful **/
       else
          fstab_action = 3;   /** delete **/
    }
    else /** has found **/
       fstab_action = 3;    /** delete **/

    #ifdef DEBUG
      printf(" which_line=%d,  action=%d \n",which_line,fstab_action);
    #endif

    if ( edit_conf("/etc/fstab",cmd_line,which_line,fstab_action) !=0 ) {
       #ifdef DEBUG
         printf(" Remove from fstab file fail \n");
       #endif
       return PL_WRITE_FILE;
    }

    return PL_OK;
 }
/*----------------------------------------------------------*/
/*-  Get Disk Model & C/H/S Information                    -*/
/*-  You cannot pass in device name of /dev/mdx            -*/
/*- Now, it cannot get information, if you pass in SCSI HD -*/
/*- It (disk_info->raid_name)will record it belong to some -*/
/*- raid device or "single" represent it is a single HD    -*/
/*----------------------------------------------------------*/
int DiskInfo(struct disk_info *nptr)
{
  struct hd_driveid    id;
  struct hd_geometry   id_geo;
  //struct utsname       ver_name;
  int                  fd,rd_no,ret,i,j, d_name;
  struct raid_device   *rd1;

  fd = open (nptr->device_name, O_RDONLY);
  if ( fd < 0 ) {
     #ifdef DEBUG
       printf(" open %s fail !\n",nptr->device_name);
     #endif
     return HD_NOEXIST;
  }

  if ( strstr(nptr->device_name,"hd") !=NULL) {  /*-- It is IDE HD -*/
    if ( ioctl(fd, HDIO_GET_IDENTITY, &id) != 0 ) {
       #ifdef DEBUG
         printf(" ioctl(HDIO_GET_IDENTIFY) fail ! \n");
       #endif
       close (fd);  
       return PL_FAIL;
    }
    strcpy(nptr->model,id.model);
  }
  else {  /*-- Non-ide, that is SCSI HD, currently no implement --*/
     /*- Maybe you can get information from /proc/scsi/... files -*/
     strcpy(nptr->model,"SCSI HD");
  } 
  

  if ( ioctl(fd, HDIO_GETGEO, &id_geo) != 0 ) {
     #ifdef DEBUG
       printf(" ioctl(HDID_GETGEO) fail ! \n");
     #endif
     close (fd);
     return PL_FAIL;
  }
  nptr->header   = id_geo.heads;
  nptr->cylinder = id_geo.cylinders;
  nptr->sector   = id_geo.sectors;

  close(fd);

  //nptr->totalsize = (double) (nptr->header * nptr->cylinder * nptr->sector * 512 / 1024);
  nptr->totalsize = (double) (nptr->header * nptr->cylinder * nptr->sector * 0.5);

  #ifdef DEBUG
    printf("in ds_fdisk.c, header  =%d \n",nptr->header);
    printf("in ds_fdisk.c, cylinder=%d \n",nptr->cylinder);
    printf("in ds_fdisk.c, sector  =%d \n",nptr->sector);
    //printf("in ds_fdisk.c, sector_byte  =%d \n",id.sector_bytes);
    printf("in ds_fdisk.c, total_size=%.1f \n",nptr->totalsize);
  #endif

  /*- check it play as single HD or belong one member of specified RAID Device -*/
  /*------- Initial values & Get RAID DEV No -----*/
   d_name = Get_HD_Integer(nptr->device_name);
   strcpy(nptr->raid_name,"single");

   rd_no = Get_RaidDev_No();
   if ( rd_no <=0 )  return PL_OK;

   rd1=calloc(rd_no,sizeof(struct raid_device));
   ret = Get_All_RaidDev_Conf(rd1,rd_no);

   for (i=0; i<rd_no; i++) {
       #ifdef DEBUG
         printf("\n\n");
         printf(" Device Name_%02d=%s, address=%lx \n",i,(rd1+i)->name, (rd1+i));
         printf(" Raid Level =%s \n",(rd1+i)->raid_level);
         printf(" data HD No=%d, Spare HD No=%d \n",(rd1+i)->data_hd_no,(rd1+i)->spare_hd_no);
       #endif
       for (j=0; j<(rd1+i)->data_hd_no; j++) {
           if ( d_name == (rd1+i)->data_hd[j] ) {
              strcpy(nptr->raid_name,(rd1+i)->name);
              free(rd1);
              return PL_OK;
           }
       }

       for (j=0; j<(rd1+i)->spare_hd_no; j++) {
           if ( d_name == (rd1+i)->spare_hd[j] ) {
              strcpy(nptr->raid_name,(rd1+i)->name);
              free(rd1);
              return PL_OK;
          }
       }

   }
   free(rd1);
   return PL_OK;

}

/*-------------------------------------------------*/
/*-  Get Disk Partition Total, Usage & Free Size  -*/
/*- The nptr->part_name is the mounted point name,-*/
/*- not the physical device name (/dev/hda)       -*/
/*-------------------------------------------------*/
int PartitionInfo(struct partition_info *nptr)
{
  struct statfs fsd;
  int ret;
  char buff[100];
  //FILE *fd;
  double tmp_blocks, tmp_bfree, tmp_bsize, tmp_bavail;

  #ifdef DEBUG
    printf("part_name=%s \n",nptr->part_name);
  #endif

  /*** check the partition is mount ? in /etc/mtab file Start ***/
  ret = find_conf("/etc/mtab",NULL,' ',2,nptr->part_name,buff, sizeof(buff));
  if (ret == PL_NOT_FOUND) return PART_NOMOUNTED;   /** the partition isn't mount **/
  /*** check the partition is mount ? in /etc/mtab file End   ***/
  

  if ( statfs(nptr->part_name,&fsd) != 0) {
     #ifdef DEBUG
       printf(" statfs() fail ! \n");
     #endif
     return PL_FAIL;
  }
  
  #ifdef DEBUG
    printf("f_blocks =%ld \n",fsd.f_blocks);
    printf("f_bavail =%ld \n",fsd.f_bavail);
    printf("f_bfree  =%ld \n",fsd.f_bfree);
    printf("f_bsize  =%ld \n",fsd.f_bsize);
  #endif

  tmp_blocks = fsd.f_blocks;
  tmp_bfree  = fsd.f_bfree;     /** free blocks in fs **/
  tmp_bavail = fsd.f_bavail;    /** free blocks for non-superuser **/
  tmp_bsize  = fsd.f_bsize;

  /** change free space fron b_free to b_bavail 1999/8/30 **/
  /** Because the SMB use it to calcute free disk space   **/

  nptr->total_size= (tmp_blocks * tmp_bsize) / 1024 ;
  //nptr->free_size = (tmp_bfree *  tmp_bsize) / 1024;
  nptr->free_size = (tmp_bavail *  tmp_bsize) / 1024;
  nptr->usage_size= nptr->total_size - nptr->free_size;

  #ifdef DEBUG
    printf("In PPC_C_part_info.c total_size=%.2f \n",nptr->total_size);
    printf("In PPC_C_part_info.c free_size =%.2f \n",nptr->free_size);
    printf("In PPC_C_part_info.c usage_size=%.2f \n",nptr->usage_size);
  #endif
  return PL_OK;
}
/*-----------  Export Function End  ------------*/

//---------------------------------------------------------
//       Internal  Function  Start
//---------------------------------------------------------
int get_partition(int warn, int max)
{
        /*
         * try to pick a default least likely to do damage,
         * in case luser just types a newline
         */
        int i = read_int(1, max, max, ignore, "Partition number") - 1;

        if ( (warn && (sun_label && (!sunlabel->partitions[i].num_sectors || !sunlabel->infos[i].id)))
                || (!sun_label && !part_table[i]->sys_ind))
                fprintf(stderr, "Warning: partition %d has empty type\n",
                        i + 1);
        return i;
}

int delete_partition(int i)
{
        struct partition *p = part_table[i], *q = ext_pointers[i];

/* Note that for the fifth partition (i == 4) we don't actually
 * decrement partitions.
 */

        if (warn_geometry())
                return PL_FAIL;
        changed[i] = 1;
        if (sun_label) {
                if (i == 2 && sunlabel->infos[i].id == WHOLE_DISK &&
                    !sunlabel->partitions[i].start_cylinder &&
                    SSWAP32(sunlabel->partitions[i].num_sectors) == heads * sectors * cylinders)
                    printf("If you want to maintain SunOS/Solaris compatibility, consider leaving this\n"
                           "partition as Whole disk (5), starting at 0, with %d sectors\n",
                           SSWAP32(sunlabel->partitions[i].num_sectors));
                sunlabel->infos[i].id = 0;
                sunlabel->partitions[i].num_sectors = 0;
                //return ; /** mark by Nick, delete it continutely **/
        }

        if (i < 4) {
                if (p->sys_ind == EXTENDED && i == ext_index) {
                        while (partitions > 4)
                                free(buffers[--partitions]);
                        ext_pointers[ext_index] = NULL;
                        extended_offset = 0;
                }
                clear_partition(p);
        }
        else if (!q->sys_ind && i > 4) {
                free(buffers[--partitions]);
                clear_partition(ext_pointers[--i]);
                changed[i] = 1;   /** Add by Nick **/
        }
        else if (i > 3) {
                if (i > 4) {
                        p = ext_pointers[i - 1];
                        p->boot_ind = 0;
                        p->head = q->head;
                        p->sector = q->sector;
                        p->cyl = q->cyl;
                        p->sys_ind = EXTENDED;
                        p->end_head = q->end_head;
                        p->end_sector = q->end_sector;
                        p->end_cyl = q->end_cyl;
                        p->start_sect = q->start_sect;
                        p->nr_sects = q->nr_sects;
                        changed[i - 1] = 1;
                }
                else {
                   if(part_table[5]) /* prevent SEGFAULT */
                        part_table[5]->start_sect =
                                SWAP32(
                                 SWAP32(part_table[5]->start_sect) +
                                 offsets[5] - extended_offset
                                );
                        offsets[5] = extended_offset;
                        changed[5] = 1;
                }
                if (partitions > 5) {
                        partitions--;
                        free(buffers[i]);
                        while (i < partitions) {
                                changed[i] = changed[i + 1];
                                buffers[i] = buffers[i + 1];
                                offsets[i] = offsets[i + 1];
                                part_table[i] = part_table[i + 1];
                                ext_pointers[i] = ext_pointers[i + 1];
                                i++;
                        }
                }
                else
                        clear_partition(part_table[i]);
        }
     return PL_OK;   /** add by Nick **/
}

uint read_int(uint low, uint dflt, uint high, enum offset base, char *mesg)
{
        uint i, use_default = 1;
        char ms[70];

        switch(base) {
        case lower:
            sprintf(ms, "%s ([%d]-%d): ", mesg, low, high);
            break;
        case upper:
            sprintf(ms, "%s (%d-[%d]): ", mesg, low, high);
            break;
        case deflt:
            sprintf(ms, "%s (%d-[%d]-%d): ", mesg, low, dflt, high);
            break;
        default:
            sprintf(ms, "%s (%d-%d): ", mesg, low, high);
            break;
        }

        while (1) {
                if (base == deflt) {
                        while (read_chars(ms) != '\n' && !isdigit(*line_ptr)
                                        && (*line_ptr != '-' && *line_ptr != '+'))
                                continue;
                        if (*line_ptr == '\n')
                                return dflt;
                } else {
                        while (!isdigit(read_char(ms))
                                        && (*line_ptr != '-' && *line_ptr != '+'))
                                continue;
                }
                if (*line_ptr == '+' || *line_ptr == '-') {
                        if (*line_ptr == '+')
                            ++line_ptr;
                        i = atoi(line_ptr);
                        while (isdigit(*line_ptr))
                        {
                                line_ptr++;
                                use_default = 0;
                        }
                        switch (*line_ptr) {
                                case 'c':
                                case 'C': if (!unit_flag)
                                                i *= heads * sectors;
                                        break;
                                case 'k':
                                case 'K': i *= 2;
                                        i /= display_factor;
                                        break;
                                case 'm':
                                case 'M': i *= 2048;
                                        i /= display_factor;
                                        break;
                                default: break;
                        }
                        switch(base) {
                        case lower: i += low; break;
                        case upper: i += high; break;
                        case deflt: i += dflt; break;
			default:       // add by Nick
                        }
                }
                else
                {
                        i = atoi(line_ptr);
                        while (isdigit(*line_ptr))
                        {
                                line_ptr++;
                                use_default = 0;
                        }
                }
                if (use_default)
                    printf("Using default value %d\n", i = dflt);
                if (i >= low && i <= high)
                        break;
                else
                        printf("Value out of range.\n");
        }
        return i;
}

int warn_geometry(void)
{
        char *m = NULL;
        int prev = 0;
        if (!heads)
                prev = test_c(&m, "heads");
        if (!sectors)
                prev = test_c(&m, "sectors");
        if (!cylinders)
                prev = test_c(&m, "cylinders");
        if (!m)
                return PL_OK;
        fprintf(stderr,
                "%s%s.\nYou can do this from the extra functions menu.\n",
                prev ? " and " : " ", m);
        return PL_FAIL;
}

void clear_partition(struct partition *p)
{
        p->boot_ind = 0;
        p->head = 0;
        p->sector = 0;
        p->cyl = 0;
        p->sys_ind = 0;
        p->end_head = 0;
        p->end_sector = 0;
        p->end_cyl = 0;
        p->start_sect = 0;
        p->nr_sects = 0;
}

char read_char(char *mesg)
{
        do
                fputs(mesg, stdout);
        while (!read_line());
        return *line_ptr;
}

char read_chars(char *mesg)
{
        fputs(mesg, stdout);
        if (!read_line()) {
            *line_ptr = '\n';
            return '\n';
        } else return *line_ptr;
}

int test_c(char **m, char *mesg)
{
        int val = 0;
        if (!*m)
                fprintf(stderr, "You must set");
        else {
                fprintf(stderr, " %s", *m);
                val = 1;
        }
        *m = mesg;
        return val;
}

int read_line(void)
{
        if (!fgets(line_buffer, LINE_LENGTH, stdin))
                return 0;
        line_ptr = line_buffer;
        while (*line_ptr && !isgraph(*line_ptr))
                line_ptr++;
        return *line_ptr;
}

int write_table(void)
{
        int i, error = 0;

        changed[3] = changed[0] || changed[1] || changed[2] || changed[3];
        if (!sun_label) {
                for (i = 3; i < partitions; i++)
                        if (changed[i]) {
                                *table_check(buffers[i]) = SWAP16(PART_TABLE_FLAG);
                                if (ext2_llseek(fd, (ext2_loff_t)offsets[i]
                                        * SECTOR_SIZE, SEEK_SET) < 0) {
				        //fatal(unable_to_seek);  // mark by Nick
                                        return PL_FAIL; /** add by Nick **/
                                }
                                if (write(fd, buffers[i], SECTOR_SIZE) != SECTOR_SIZE) {
				        //fatal(unable_to_write);  // Mark by Nick
                                        return PL_FAIL; /** add by Nick **/
                                }
                }
        } else {
                if (changed[3] || changed[4] || changed[5] || changed[6] || changed[7]) {
                        unsigned short *ush = (unsigned short *)sunlabel;
                        unsigned short csum = 0;
                        while(ush < (unsigned short *)(&sunlabel->csum))
                                csum ^= *ush++;
                        sunlabel->csum = csum;
                        if (lseek(fd, 0, SEEK_SET) < 0) {
                                //fatal(unable_to_seek);  // mark by Nick
                                return PL_FAIL; /** add by Nick **/
                        }
                        if (write(fd, sunlabel, SECTOR_SIZE) != SECTOR_SIZE) {
                                //fatal(unable_to_write);  // mark by Nick
                                return PL_FAIL; /** add by Nick **/
                        }
                }
        }

        //printf("The partition table has been altered!\n\n");

        //printf("Calling ioctl() to re-read partition table.\n"
        //       "(Reboot to ensure the partition table has been updated.)\n");
        sync();
        sleep(2);
        /*-----------------------------------------------------------------*/
        /* Because the below ioctl() will print out message on console     */
        /* & it descripted the ioctl() is just for re-read partition table */
        /* I think it's unnecessary, so I mark it 2000/2/9 ---> Nick       */
        /*-----------------------------------------------------------------*/
         
        /* Mark by Nick Start    */
        /* Note under ioctl() cannot disable, while result the create */
        /*  partition fail, even it see fine in fdisk program         */
        if ( (i = ioctl(fd, BLKRRPART)) ) {   /** it will print out some message on console **/
              error = errno;
        } else {
                /* some kernel versions (1.2.x) seem to have trouble
                   rereading the partition table, but if asked to do it
                   twice, the second time works. - biro@yggdrasil.com */
                sync();
                sleep(2);
                if( (i = ioctl(fd, BLKRRPART)) )
                        error = errno;
        }
        /** Mark End **/
        close(fd);

        //printf("Syncing disks.\n");
        sync();
        sleep(4);               /* for sync() */

        if (i < 0)
                printf("Re-read table failed with error %d: %s.\nReboot your "
                        "system to ensure the partition table is updated.\n",
                        error, strerror(error));

        //if (!sun_label)
        //        printf( "\nWARNING: If you have created or modified any DOS 6.x\n"
        //                "partitions, please see the fdisk manual page for additional\n"
        //                "information.\n" );

       // exit(0);
       return PL_OK;
}

/****************************************************
void fatal(enum failure why)
{
        char    error[LINE_LENGTH],
                *message = error;

        //if (listing) {
        //        close(fd);
        //        longjmp(listingbuf, 1);
        //}

        switch (why) {
                case usage: message =
                        "Usage: fdisk [-l] [-v] [-s /dev/hdxn] [/dev/hdx]\n";
                        break;
                case unable_to_open:
                        sprintf(error, "Unable to open %s\n", disk_device);
                        break;
                case unable_to_read:
                        sprintf(error, "Unable to read %s\n", disk_device);
                        break;
                case unable_to_seek:
                        sprintf(error, "Unable to seek on %s\n", disk_device);
                        break;
                case unable_to_write:
                        sprintf(error, "Unable to write %s\n", disk_device);
                        break;
                case out_of_memory:
                        message = "Unable to allocate any more memory\n";
                        break;
                default: message = "Fatal error\n";
        }

        fputc('\n', stderr);
        fputs(message, stderr);
        //exit(1);
        return PL_FAIL;
}
********************************************************/

char *const str_units(void)
{
        return unit_flag ? "cylinder" : "sector";
}
uint rounded(uint calcul, uint start)
{
        uint i;
        if (!full_bits)
                return calcul;
        while ((i = calcul + full_bits) <= start)
                calcul = i;
        return calcul;
}

char *partition_type(unsigned char type)
{
        int high;
        int low = 0, mid;
        uint tmp;
        struct systypes *types;

        if (!sun_label) {
                high = sizeof(sys_types) / sizeof(struct systypes);
                types = sys_types;
        } else {
                high = sizeof(sun_sys_types) / sizeof(struct systypes);
                types = sun_sys_types;
        }
        while (high >= low) {
                mid = (high + low) >> 1;
                if ((tmp = types[mid].index) == type)
                        return types[mid].name;
                else if (tmp < type)
                        low = mid + 1;
                else high = mid - 1;
        }
        return NULL;
}

static void long2chs(ulong ls, uint *c, uint *h, uint *s)
{
        int     spc = heads * sectors;

        *c = ls / spc;
        ls = ls % spc;
        *h = ls / sectors;
        *s = ls % sectors + 1;  /* sectors count from 1 */
}
static void check_consistency(struct partition *p, int partition)
{
        uint    pbc, pbh, pbs;          /* physical beginning c, h, s */
        uint    pec, peh, pes;          /* physical ending c, h, s */
        uint    lbc, lbh, lbs;          /* logical beginning c, h, s */
        uint    lec, leh, les;          /* logical ending c, h, s */

        if (!heads || !sectors || (partition >= 4))
                return;         /* do not check extended partitions */

/* physical beginning c, h, s */
        pbc = ((p->cyl & 0xff) | (p->sector << 2)) & 0x300;
        pbh = p->head;
        pbs = p->sector & 0x3f;

/* physical ending c, h, s */
        pec = ((p->end_cyl & 0xff) | (p->end_sector << 2)) & 0x300;
        peh = p->end_head;
        pes = p->end_sector & 0x3f;

/* compute logical beginning (c, h, s) */
        long2chs(SWAP32(p->start_sect), &lbc, &lbh, &lbs);

/* compute logical ending (c, h, s) */
        long2chs(SWAP32(p->start_sect) + SWAP32(p->nr_sects) - 1, &lec, &leh, &les);

/* Same physical / logical beginning? */
        if (cylinders <= 1024 && (pbc != lbc || pbh != lbh || pbs != lbs)) {
                printf("Partition %d has different physical/logical "
                        "beginnings (non-Linux?):\n", partition + 1);
                printf("     phys=(%d, %d, %d) ", pbc, pbh, pbs);
                printf("logical=(%d, %d, %d)\n",lbc, lbh, lbs);
        }

/* Same physical / logical ending? */
        if (cylinders <= 1024 && (pec != lec || peh != leh || pes != les)) {
                printf("Partition %d has different physical/logical "
                        "endings:\n", partition + 1);
                printf("     phys=(%d, %d, %d) ", pec, peh, pes);
                printf("logical=(%d, %d, %d)\n",lec, leh, les);
        }

#if 0
/* Beginning on cylinder boundary? */
        if (pbh != !pbc || pbs != 1) {
                printf("Partition %i does not start on cylinder "
                        "boundary:\n", partition + 1);
                printf("     phys=(%d, %d, %d) ", pbc, pbh, pbs);
                printf("should be (%d, %d, 1)\n", pbc, !pbc);
        }
#endif

/* Ending on cylinder boundary? */
        if (peh != (heads - 1) || pes != sectors) {
                printf("Partition %i does not end on cylinder boundary:\n",
                        partition + 1);
                printf("     phys=(%d, %d, %d) ", pec, peh, pes);
                printf("should be (%d, %d, %d)\n",
                pec, heads - 1, sectors);
        }
}

int list_table(int xtra)
{
        struct partition *p;
        char *type;
        int i, w = strlen(disk_device);

        if (w < 5)
                w = 5;
        if (!sun_label) {
                //printf("\nDisk %s: %d heads, %d sectors, %d cylinders\nUnits = "
                //        "%ss of %d * 512 bytes\n\n", disk_device, heads, sectors,
                //        cylinders, str_units(), display_factor);
                //    printf("%*s Boot   Begin    Start      End   Blocks   Id  System\n",
//                        w + 1, "Device");
                for (i = 0 ; i < partitions; i++)
                        if ((p = part_table[i])->sys_ind) {
//                                printf("%*s%-2d  %c%9d%9d%9d%9d%c  %2x  %s\n", w,
///* device */                    disk_device, i + 1,
///* boot flag */                 !p->boot_ind ? ' ' : p->boot_ind == ACTIVE_FLAG
//                                ? '*' : '?',
///* begin */                     cround(rounded( calculate(p->head, p->sector, p->cyl),
//                                        SWAP32(p->start_sect) + offsets[i])),
///* start */                     cround(SWAP32(p->start_sect) + offsets[i]),
///* end */                       cround(SWAP32(p->start_sect) + offsets[i] + SWAP32(p->nr_sects)
//                                        - (p->nr_sects ? 1: 0)),
///* odd flag on end */           SWAP32(p->nr_sects) / 2, SWAP32(p->nr_sects) & 1 ? '+' : ' ',
///* type id */                   p->sys_ind,
///* type name */                 (type = partition_type(p->sys_ind)) ?
//                                type : "Unknown");
                        check_consistency(p, i);
                }
        } else {
                if (xtra)
                        printf("\nDisk %s (Sun disk label): %d heads, %d sectors, %d rpm\n"
                                "%d cylinders, %d alternate cylinders, %d physical cylinders\n"
                                "%d extra sects/cyl, interleave %d:1\n"
                                "%s\n"
                                "Units = %ss of %d * 512 bytes\n\n", disk_device, heads, sectors, SSWAP16(sunlabel->rspeed),
                                cylinders, SSWAP16(sunlabel->nacyl), SSWAP16(sunlabel->pcylcount),
                                SSWAP16(sunlabel->sparecyl), SSWAP16(sunlabel->ilfact),
                                (char *)sunlabel,
                                str_units(), display_factor);
                else
                        printf("\nDisk %s (Sun disk label): %d heads, %d sectors, %d cylinders\n"
                                "Units = %ss of %d * 512 bytes\n\n", disk_device, heads, sectors,
                                cylinders, str_units(), display_factor);
                printf("%*s Flag   Begin    Start      End   Blocks   Id  System\n",
                        w + 1, "Device");
                for (i = 0 ; i < partitions; i++)
                        if (sunlabel->partitions[i].num_sectors) {
                                __u32 start = SSWAP32(sunlabel->partitions[i].start_cylinder) * heads * sectors;
                                __u32 len = SSWAP32(sunlabel->partitions[i].num_sectors);
                                printf("%*s%-2d %c%c%9d%9d%9d%9d%c  %2x  %s\n", w,
/* device */                    disk_device, i + 1,
/* flags */                     (sunlabel->infos[i].flags & 0x01) ? 'u' : ' ',
                                (sunlabel->infos[i].flags & 0x10) ? 'r' : ' ',
/* begin */                     scround(start),
/* start */                     scround(start),
/* end */                       scround(start+len),
/* odd flag on end */           len / 2, len & 1 ? '+' : ' ',
/* type id */                   sunlabel->infos[i].id,
/* type name */                 (type = partition_type(sunlabel->infos[i].id)) ?
                                type : "Unknown");
                        }
        }
   return PL_OK;
}

//void create_doslabel(void)
//{
//        int i;
//        fprintf(stderr, "Building a new DOS disklabel. Changes will remain in memory only,\n"
//                        "until you decide to write them. After that, of course, the previous\n"
//                        "content won't be recoverable.\n\n");
//        *table_check(buffer) = SWAP16(PART_TABLE_FLAG);
//        for (i = 0; i < 4; i++) {
//            clear_partition(part_table[i]);
//        }
//        for (i = 1; i < MAXIMUM_PARTS; i++)
//            changed[i] = 0;
//        changed[0] = 1;
//        get_boot(3);
//}

int get_boot(int action)
{
        int i;
        struct hd_geometry geometry;
        struct stat bootstat;

        partitions = 4;
        if (action != 3) {
            if ((fd = open(disk_device, type_open)) < 0) {
                if ((fd = open(disk_device, O_RDONLY)) < 0) {
		    //fatal(unable_to_open);  // mark by Nick
                    return PL_FAIL;  /** add by Nick **/
                }
                else
                    printf("You will not be able to write the partition table.\n");
            }
            if (fstat (fd, &bootstat) < 0) {
                scsi_disk = 0;
                floppy = 0;
            } else if ( (S_ISBLK(bootstat.st_mode) && ((bootstat.st_rdev >> 8) == IDE0_MAJOR)) || ((bootstat.st_rdev >> 8)) == IDE1_MAJOR) {
                scsi_disk = 0;
                floppy = 0;
            } else if (S_ISBLK(bootstat.st_mode) && (bootstat.st_rdev >> 8) == 2) {
                scsi_disk = 0;
                floppy = 1;
            } else {
                scsi_disk = 1;
                floppy = 0;
            }
            if (SECTOR_SIZE != read(fd, buffer, SECTOR_SIZE)) {
	        //fatal(unable_to_read);  // mark by Nick
                return PL_FAIL;  /** add by Nick **/
            }
#ifdef HDIO_REQ   
            if (!ioctl(fd, HDIO_REQ, &geometry)) {
#else
              if (!ioctl(fd, HDIO_GETGEO, &geometry)) {  /* goto here Nick */
#endif
                heads = geometry.heads;
                sectors = geometry.sectors;
                cylinders = geometry.cylinders;
                if (dos_compatible_flag)
                        sector_offset = sectors;
                
                warn_cylinders();
            }
            update_units();
        }
        if (check_sun_label() == PL_OK)
            return PL_OK;

        if (SWAP16(*table_check(buffer)) != PART_TABLE_FLAG) {
            switch (action) {
                case 1: return PL_FAIL;
                case 2: fprintf(stderr, "Disk doesn't contain any valid partition table\n"); return PL_FAIL;
                case 3: fprintf(stderr, "Internal error\n"); return PL_FAIL;
                default: break;
            }
            fprintf(stderr, "Device contains neither a valid DOS partition table, nor Sun disklabel\n");
//#ifdef __sparc__
//            create_sunlabel();
//            return;
//#else
//            create_doslabel();
//            return;
//#endif
        }
        warn_cylinders();
        warn_geometry();
        
        for (i = 0; i < 4; i++)
	  if(part_table[i]->sys_ind == EXTENDED) {
                        if (partitions != 4)
                                fprintf(stderr, "Ignoring extra extended "
                                        "partition %d\n", i + 1);
                        else read_extended(part_table[ext_index = i]);
	  }

        for (i = 3; i < partitions; i++)
                if (SWAP16(*table_check(buffers[i])) != PART_TABLE_FLAG) {
                        fprintf(stderr, "Warning: invalid flag %04x of parti"
                                "tion table %d will be corrected by w(rite)\n",
                                SWAP16(*table_check(buffers[i])), i + 1);
                        changed[i] = 1;
                }
        return PL_OK;
}

void update_units(void)
{
        full_bits = 1024 * heads * sectors;
        if (unit_flag && full_bits)
                display_factor = full_bits >> 10;
        else display_factor = 1;
}

void warn_cylinders(void)
{
        update_units();
        if (sun_label) return;
        //if (cylinders > 1024)
        //        fprintf(stderr, "The number of cylinders for this disk is "
        //                "set to %d.\nThis is larger than 1024, and may cause "
        //                "problems with:\n"
        //                "1) software that runs at boot time (e.g., LILO)\n"
        //                "2) booting and partitioning software form other OSs\n"
        //                "   (e.g., DOS FDISK, OS/2 FDISK)\n",
        //                cylinders);
}

void read_extended(struct partition *p)
{
        int i;
        struct partition *q;

        ext_pointers[ext_index] = part_table[ext_index];
        if (!p->start_sect)
                fprintf(stderr, "Bad offset in primary extended partition\n");
        else while (p->sys_ind == EXTENDED) {
                if (partitions >= MAXIMUM_PARTS) {
                        fprintf(stderr,
                                "Warning: deleting partitions after %d\n",
                                partitions);
                        clear_partition(ext_pointers[partitions - 1]);
                        changed[partitions - 1] = 1;
                        return;
                }
                offsets[partitions] = extended_offset + SWAP32(p->start_sect);
                if (!extended_offset)
                        extended_offset = SWAP32(p->start_sect);
                if (ext2_llseek(fd, (ext2_loff_t)offsets[partitions]
                               * SECTOR_SIZE, SEEK_SET) < 0) {
		        //fatal(unable_to_seek);
                        fprintf(stderr,"ext2_llseek() fail \n");
		        //return PL_FAIL; /** add by Nick **/
                }
                if (!(buffers[partitions] = (char *) malloc(SECTOR_SIZE))) {
		        //fatal(out_of_memory);
		        fprintf(stderr,"malloc() fail \n");
                        //return PL_FAIL; /** add by Nick **/
                }
                if (SECTOR_SIZE != read(fd, buffers[partitions], SECTOR_SIZE)) {
		        //fatal(unable_to_read);
		        fprintf(stderr,"read() fail \n");
                        //return PL_FAIL; /** add by Nick **/
                }

                part_table[partitions] = ext_pointers[partitions] = NULL;
                q = p = offset(buffers[partitions], 0);
                for (i = 0; i < 4; i++, p++) {
                        if (p->sys_ind == EXTENDED)
                                if (ext_pointers[partitions])
                                        fprintf(stderr, "Warning: extra link "
                                                "pointer in partition table "
                                                "%d\n", partitions + 1);
                                else
                                        ext_pointers[partitions] = p;
                        else if (p->sys_ind) {
                                if (part_table[partitions])
                                        fprintf(stderr,
                                                "Warning: ignoring extra data "
                                                "in partition table %d\n",
                                                partitions + 1);
                                else
                                        part_table[partitions] = p;
			}
                }
                if (!part_table[partitions]) {
                        if (q != ext_pointers[partitions])
                                part_table[partitions] = q;
                        else part_table[partitions] = q + 1;
		}
                if (!ext_pointers[partitions]) {
                        if (q != part_table[partitions])
                                ext_pointers[partitions] = q;
                        else ext_pointers[partitions] = q + 1;
		}
                p = ext_pointers[partitions++];
		
        }
}

int check_sun_label(void)
{
        unsigned short *ush;
        int csum;
        
        if (sunlabel->magic != SUN_LABEL_MAGIC && sunlabel->magic != SUN_LABEL_MAGIC_SWAPPED) {
                sun_label = 0;
                other_endian = 0;
                return PL_FAIL;
        }
        other_endian = (sunlabel->magic == SUN_LABEL_MAGIC_SWAPPED);
        ush = ((unsigned short *) (sunlabel + 1)) - 1;
        for (csum = 0; ush >= (unsigned short *)sunlabel;) csum ^= *ush--;
        if (csum) {
                fprintf(stderr, "Detected sun disklabel with wrong checksum.\n"
                                "Probably you'll have to set all the values,\n"
                                "e.g. heads, sectors, cylinders and partitions\n"
                                "or force a fresh label (s command in main menu)\n");
        } else {
                heads = SSWAP16(sunlabel->ntrks);
                cylinders = SSWAP16(sunlabel->ncyl);
                sectors = SSWAP16(sunlabel->nsect);
        }
        update_units();
        sun_label = 1;
        partitions = 8;
        return PL_OK; 
}


/****************************************************
void add_sun_partition(int n, int sys)
{
        uint start, stop, stop2;
        uint starts[8], lens[8];
        int whole_disk = 0;
                
        char mesg[48];
        int i, first, last;

        if (sunlabel->partitions[n].num_sectors && sunlabel->infos[n].id) {
                printf("Partition %d is already defined.  Delete "
                        "it before re-adding it.\n", n + 1);
                return;
        }
        
        fetch_sun(starts,lens,&start,&stop);
        if (stop <= start) {
                if (n == 2)
                        whole_disk = 1;
                else {
                        printf("Other partitions already cover the whole disk.\nDelete "
                               "some/shrink them before retry.\n");
                        return;
                }
        }
        sprintf(mesg, "First %s", str_units());
        for (;;) {
                if (whole_disk)
                        first = read_int(0, 0, 0, deflt, mesg);
                else
                        first = read_int(scround(start), scround(start), scround(stop),
                                         ignore, mesg);
                if (unit_flag)
                        first *= display_factor;
                else
		first = (first + heads * sectors - 1) / (heads * sectors); // Starting sector has to be properly aligned 
                if (n == 2 && first != 0) printf ("It is highly recommended that third partition covers the whole disk\n"
                                                  "and is of type `Whole disk'\n");
                for (i = 0; i < partitions; i++)
                        if (lens[i] && starts[i] <= first && starts[i] + lens[i] > first)
                                break;
                if (i < partitions && !whole_disk) {
                        if (n == 2 && !first) {
                            whole_disk = 1;
                            break;
                        }
                        printf("Sector %d is already allocated\n", first);
                } else
                        break;
        }
        stop = cylinders * heads * sectors;
        stop2 = stop;
        for (i = 0; i < partitions; i++) {
                if (starts[i] > first && starts[i] < stop)
                        stop = starts[i];
        }
        sprintf(mesg, "Last %s or +size or +sizeM or +sizeK", str_units());
        if (whole_disk)
                last = read_int(scround(stop2), scround(stop2), scround(stop2), 
                                deflt, mesg);
        else if (n == 2 && !first)
                last = read_int(scround(first), scround(stop2), scround(stop2),
                                upper, mesg);
        else
                last = read_int(scround(first), scround(stop), scround(stop),
                                lower, mesg);
        if (unit_flag)
                last *= display_factor;
        if (n == 2 && !first) {
                if (last >= stop2) {
                    whole_disk = 1;
                    last = stop2;
                } else if (last > stop) {
                    printf ("You haven't covered whole disk with 3rd partition, but your value\n"
                            "%d %s coveres some other partition. Your entry have been changed\n"
                            "to %d %s\n", scround(last), str_units(), scround(stop), str_units());
                    last = stop;
                }
        } else if (!whole_disk && last > stop)
                last = stop;

        if (whole_disk) sys = WHOLE_DISK;
        set_sun_partition(n, first, last, sys);
}
****************************************************/
/*----------------------------------------------------------*/
/* Nick add the parameter partition_size                    */
/* if the partition_size=0xffffffff that is you want to use */
/* the rest HD's maximum size                               */
/*----------------------------------------------------------*/

int add_partition(int n, int sys, unsigned int partition_size)
{
  //char mesg[48];
  int i, read = 0;
  struct partition *p = part_table[n], *q = part_table[ext_index];
  /** Add by Nick **/
  uint stop_temp, block_start;
  /** Add End **/
  uint start, stop = 0, limit, temp,
    first[partitions], last[partitions];

  if (p->sys_ind) {
    printf("Partition %d is already defined.  Delete "
	   "it before re-adding it.\n", n + 1);
    return PL_FAIL;
  }

  check_bounds(first, last);

  if (n < 4) {
    start = sector_offset;

    limit = heads * sectors * cylinders - 1;
    if (extended_offset) {
      first[ext_index] = extended_offset;
      last[ext_index] = SWAP32(q->start_sect) + SWAP32(q->nr_sects) - 1;
    }
  }
  else {
    start = extended_offset + sector_offset;
    limit = SWAP32(q->start_sect) + SWAP32(q->nr_sects) - 1;
  }
  
  if (unit_flag)
    for (i = 0; i < partitions; i++)
      first[i] = (cround(first[i]) - 1) * display_factor;
  
  //sprintf(mesg, "First %s", str_units());
  do {
    temp = start;
    for (i = 0; i < partitions; i++) {
      if (start == offsets[i])
	start += sector_offset;
      if (start >= first[i] && start <= last[i]) {
	if (n < 4)
	  start = last[i] + 1;
	else
	  start = last[i] + sector_offset;
      }

    } // end of for(i=0....)

    if (start > limit)
      break;
    if (start != temp && read) {
      printf("Sector %d is already allocated\n", temp);
      temp = start = stop;
      read = 0;
    }

    if (!read && start == temp) {
      uint i;
      i = (stop = start) + (n > 4);
      //start = read_int(cround(i), cround(i), cround(limit),
      //                 ignore, mesg);
      
      start = cround(start);  /** Add by Nick **/
      block_start = start;    /** Add by Nick May 15 2001 **/
      
      if (unit_flag) {
	start = (start - 1) * display_factor;
	if (start < i) start = i;
      }
      read = 1;
    }
  } while (start != temp || !read);
  if (n > 4)                      /* NOT for fifth partition */
    offsets[n] = start - sector_offset;
  
  for (i = 0; i < partitions; i++) {
    if (start < offsets[i] && limit >= offsets[i])
      limit = offsets[i] - 1;
    if (start < first[i] && limit >= first[i])
      limit = first[i] - 1;
  }

  if (start > limit) {
    printf("No free sectors available\n");
    if (n > 4) {
      free(buffers[n]);
      partitions--;
    }
    return PL_FAIL;  /** -1 add by Nick **/
  }

  if (cround(start) == cround(limit))
    stop = start;
  else {
    //sprintf(mesg, "Last %s or +size or +sizeM or +sizeK",
    //        str_units());

    //stop = read_int(cround(start), cround(limit), cround(limit),
    //                lower, mesg);
    /*--------------------------------------------------------------*/
    /* Add by Nick Start, comment: 2000/2/9                         */
    /* The partition_size unit is M bytes so it multiply twice 1024 */
    /* The display_factor is (heads * sectors) represent that one   */
    /* cylinder has how many sectors, one sectors=512 bytes         */
    /* so it multiply 512, then calculate the "stop=end cylinder"   */
    /* if partition_size=0xffffffff represent it will use the       */ 
    /* HD's maximumsize                                             */
    /*--------------------------------------------------------------*/
    
    stop_temp = cround(limit); 
    if (partition_size < 0xffffffff) {
      if ( ((partition_size * 1024 * 2)%(display_factor)) !=0) {
	  stop = (partition_size * 1024 * 2)/(display_factor);
	  stop++;
	  stop = stop + block_start -1;
      }
      else {  
	stop = (partition_size * 1024 * 2)/(display_factor);
        stop = stop + block_start -1;
      }
    }
    else
      stop = stop_temp;

    /** Add End **/
    
    if (unit_flag) {
      stop = stop * display_factor - 1;
      if (stop >limit)
	stop = limit;
    }
  }

  set_partition(n, p, start, stop, sys, offsets[n]);

  if (sys == EXTENDED) {
    ext_index = n;
    offsets[4] = extended_offset = start;
    ext_pointers[n] = p;
    if (!(buffers[4] = calloc(1, SECTOR_SIZE))) {
      //fatal(out_of_memory);
      return PL_FAIL; /** add by Nick **/
    }
    part_table[4] = offset(buffers[4], 0);
    ext_pointers[4] = part_table[4] + 1;
    changed[4] = 1;
    partitions = 5;
  }
  else {
    if (n > 4)
      set_partition(n - 1, ext_pointers[n - 1],
		    start - sector_offset, stop, EXTENDED,
		    extended_offset);
#if 0
    if ((limit = SWAP32(p->nr_sects)) & 1)
      printf("Warning: partition %d has an odd "
	     "number of sectors.\n", n + 1);
#endif
  }
  return PL_OK;   /** add by Nick **/
}

//void add_logical(void)
//{
//        if (partitions > 5 || part_table[4]->sys_ind) {
//                if (!(buffers[partitions] = calloc(1, SECTOR_SIZE))) {
//                        fatal(out_of_memory);
//                        return PL_FAIL; /** add by Nick **/
//                }
//                part_table[partitions] = offset(buffers[partitions], 0);
//                ext_pointers[partitions] = part_table[partitions] + 1;
//                offsets[partitions] = 0;
//                partitions++;
//        }
//        add_partition(partitions - 1, LINUX_NATIVE);
//}

//============================================================
// May 23 2001: Change the pass in parameter from (mb_size)
// to (int part_no, int part_type, int mb_size)
//============================================================
int new_partition(int part_no, int part_type, int mb_size)
{
  int i, free_primary = 0;

  if (warn_geometry())
    return PL_FAIL;  /** -1 add by Nick **/
  //if (sun_label) {
  //        /*** Test by Nick ***/
  //        printf(" In line 1189 \n");
  //        add_sun_partition(get_partition(0, partitions), LINUX_NATIVE);
  //        return;
  //}
  //if (partitions >= MAXIMUM_PARTS) {
  //        printf("The maximum number of partitions has been created\n");
  //        return;
  //}

  for (i = 0; i < 4; i++)
    free_primary += !part_table[i]->sys_ind;
  if (!free_primary) {
    if (extended_offset) {
      //add_logical();  /* mark by Nick */
      /* add by Nick */
      printf(" Error, In new_partition(), I mark add_logical() \n");
      
      return PL_FAIL;   /** add by Nick **/
    }
    else {
      printf("You must delete some partition and add "
	     "an extended partition first\n");
      return PL_FAIL;  /** add by Nick **/
    }
  }
  else {
    /*** Will go to here **/
    //char c, line[LINE_LENGTH];
    //sprintf(line, "Command action\n   %s\n   p   primary "
    //        "partition (1-4)\n", extended_offset ?
    //        "l   logical (5 or over)" : "e   extended");
    //while (1)
       //if ((c = tolower(read_char(line))) == 'p') {
       //add_partition(get_partition(0, 4),
       //if ( add_partition(0,LINUX_NATIVE,10)!=0)
       //- Apr 23 2001, change first partition size
       //- from 10 to 65 MB
       //- May 15 2001, change first partition to 10M
       //- Bytes, 2'st is 32 M Bytes for swapping

       //-May 23 2001: Modify it just create one partition everytime 
       //- previous is create 3 partitions one time
       //if ( add_partition(0,LINUX_NATIVE,10)!=0)
       //  return PL_FAIL;
       
       //if ( add_partition(1,LINUX_SWAP,32)!=0)
       //	 return PL_FAIL;
       if (mb_size==0){
	 if ( add_partition(part_no, part_type,0xffffffff)!=0)
	   return PL_FAIL;
       }
       else {
	 if ( add_partition(part_no, part_type, mb_size)!=0)
	   return PL_FAIL;	
       }     
    //}
    //else if (c == 'l' && extended_offset) {
    //        add_logical();
    //        return;
    //}
    //else if (c == 'e' && !extended_offset) {
    //        add_partition(get_partition(0, 4),
    //                EXTENDED);
    //        return;
    //}
    //else
    //        printf("Invalid partition number "
    //               "for type `%c'\n", c);
                
  }
  return PL_OK;  /** add by Nick **/
}

void check_bounds(uint *first, uint *last)
{
        int i;
        uint max = 0xffffffff;          /* used to be 256 * 63 * 1024
                                           but that made it impossible to add a
                                           partition crossing cylinder 8064 */
        struct partition *p = part_table[0];

        for (i = 0; i < partitions; p = part_table[++i])
                if (!p->sys_ind || p->sys_ind == EXTENDED) {
                        first[i] = max;
                        last[i] = 0;
                }
                else {
                        first[i] = rounded(calculate(p->head, p->sector,
                                p->cyl), SWAP32(p->start_sect) + offsets[i]);
                        last[i] = SWAP32(p->start_sect) + offsets[i] + SWAP32(p->nr_sects) - 1;
                }
}

void set_sun_partition(int i, uint start, uint stop, int sys)
{
        sunlabel->infos[i].id = sys;
        sunlabel->partitions[i].start_cylinder = SSWAP32(start / (heads * sectors));
        sunlabel->partitions[i].num_sectors = SSWAP32(stop - start);
        changed[i] = 1;
}

void set_partition(int i, struct partition *p, uint start, uint stop,
        int sys, uint offset)
{
        p->boot_ind = 0;
        p->sys_ind = sys;
        p->start_sect = SWAP32(start - offset);
        p->nr_sects = SWAP32(stop - start + 1);
        if (dos_compatible_flag && (start/(sectors*heads) > 1023))
                start = heads*sectors*1024 - 1;
        set_hsc(p->head, p->sector, p->cyl, start);
        if (dos_compatible_flag && (stop/(sectors*heads) > 1023))
                stop = heads*sectors*1024 - 1;
        set_hsc(p->end_head, p->end_sector, p->end_cyl, stop);
        changed[i] = 1;
}

void fetch_sun(uint *starts, uint *lens, uint *start, uint *stop)
{
        int i, continuous = 1;
        *start = 0; *stop = cylinders * heads * sectors;
        for (i = 0; i < partitions; i++) {
                if (sunlabel->partitions[i].num_sectors && sunlabel->infos[i].id && sunlabel->infos[i].id != WHOLE_DISK) {
                        starts[i] = SSWAP32(sunlabel->partitions[i].start_cylinder) * heads * sectors;
                        lens[i] = SSWAP32(sunlabel->partitions[i].num_sectors);
                        if (continuous) {
                                if (starts[i] == *start)
                                        *start += lens[i];
                                else if (starts[i] + lens[i] >= *stop)
                                        *stop = starts[i];
                                else
                                        continuous = 0; /* There will be probably more gaps than one, so lets check afterwards */
                        }
                } else {
                        starts[i] = 0;
                        lens[i] = 0;
                }
        }
}
