//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		sys_update.c
//
//	Abstract: 
//		System Update Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		04/26/01	Meiji Chang created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mount.h>
#include <errno.h>
#include <unistd.h>
#include "config.h"
#include "Util.h"

/* ------------------------------------------------------------------------- **
 * Build options...
 */




/* ------------------------------------------------------------------------- **
 * Constants...
 */




/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */

void Update_Flash_Data(char *filename)
{
	char cmd_line[FILE_NAME_MAX_LENGTH];
	char tmp_file[FILE_NAME_MAX_LENGTH];
	char *m_filename,*m_pathname;
	
	strcpy(tmp_file,filename);
	
	if((m_filename=strrchr(tmp_file,'/'))!=NULL) {
		*m_filename = '\0';	
		m_pathname = tmp_file;
		m_filename +=1;
		sprintf(cmd_line,"%s %s -s %s > /dev/null",UPDATE_CFG_FILE,m_filename,m_pathname);
	}
	else
		sprintf(cmd_line,"%s %s > /dev/null",UPDATE_CFG_FILE,filename);

	system(cmd_line);
	// mark by Kent 2002/08/21
	// after update_flash_data, the data partition will be umount
	// no need sync again
//	sync();
}

void Update_Flash_Data_Ex(char *filename, BOOL force)
{
	char cmd_line[FILE_NAME_MAX_LENGTH];
	char tmp_file[FILE_NAME_MAX_LENGTH];
	char *m_filename,*m_pathname;
	
	strcpy(tmp_file,filename);
	
	if((m_filename=strrchr(tmp_file,'/'))!=NULL) {
		*m_filename = '\0';	
		m_pathname = tmp_file;
		m_filename +=1;
		sprintf(cmd_line,"%s %s %s -s %s > /dev/null",
			UPDATE_CFG_FILE, m_filename,
			(force == TRUE) ? "-f " : "",
			m_pathname);
	}
	else
		sprintf(cmd_line,"%s %s %s> /dev/null",
			UPDATE_CFG_FILE, filename,
			(force == TRUE) ? "-f " : "");

	system(cmd_line);
}
