//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		gw.c
//
//	Abstract: 
//		Get gateway IP address from /PROC       
//		Bring to you by Nick Ho(first version)
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/22/00	kw lee created
//
//**************************************************************************
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>

#include <netdb.h>

#define EON

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#define ROUTE_FILE "/proc/net/route"
char seps[] = "\t\n";
char *token;

/*
 * Get gateway IP address
 * Return:
 *	number of gateway IP
 */
int
Get_Gateway_Addr(char *ifname, struct sockaddr_in *gwin)
{
	char tmpfile[] = "/tmp/route1.tmp";
	char str[128], sCmd[128];
	FILE *fp;
	struct sockaddr_in	sin;
	int cnt = 0;

	sprintf(sCmd, "cat %s > %s", ROUTE_FILE, tmpfile);
	system(sCmd);
	fp = fopen(tmpfile, "r");
	fgets(str, 128, fp);
	while(fgets(str, 128, fp) != NULL) {
		token = strtok(str, seps);
		if(token == NULL)
			continue;
		// Check if it's my IF name
		if(strcmp(token, ifname))
			continue;
		token = strtok(NULL, seps);
		token = strtok(NULL, seps);
		sin.sin_addr.s_addr = (uint32_t)strtoul(token, NULL, 16);
		if(sin.sin_addr.s_addr == 0)
			continue;
		gwin->sin_addr.s_addr = sin.sin_addr.s_addr;
		cnt++;
	}
	fclose(fp);
	unlink(tmpfile);
	return cnt;
}

