/*   ____  __  _ _____ ____     _ _            _
**  / ___||  \/ |_   _|  _ \___| (_) ___ _ __ | |_
**  \___ \| |\/| || | | |_)/ __| | |/ _ \ '_ \| __|
**   ___) | |  | || | |  _| (__| | |  __/ | | | |_
**  |____/|_|  |_||_| |_|  \___|_|_|\___|_| |_|\__|
**
**  SMTPclient -- simple SMTP client
**
**  This program is a minimal SMTP client that takes an email
**  message body and passes it on to a SMTP server (default is the
**  MTA on the local host). Since it is completely self-supporting,
**  it is especially suitable for use in restricted environments.
**
**  ======================================================================
**
**  Copyright (c) 1997 Ralf S. Engelschall, All rights reserved.
**
**  This program is free software; it may be redistributed and/or modified
**  only under the terms of either the Artistic License or the GNU General
**  Public License, which may be found in the SMTP source distribution.
**  Look at the file COPYING.
**
**  This program is distributed in the hope that it will be useful, but
**  WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  ======================================================================
**
**  smtpclient_main.c -- program source
**
**  Based on smtp.c as of August 11, 1995 from
**      W.Z. Venema,
**      Eindhoven University of Technology,
**      Department of Mathematics and Computer Science,
**      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands.
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <ctype.h>
#include "config.h"
//Shone added
#include "cfg_smtp.h" 
#include "base64.h" 

static char *from_addr  = NULL;
static char *mailhost   = NULL;
static int   mailport   = 25;
static char *reply_addr = 0;
static int   mime_style = 0;
static int   verbose    = 0;

static FILE *sfp;
static FILE *rfp;

#define dprintf  if (verbose) printf
#define dvprintf if (verbose) vprintf

/*
 *  examine message from server
 *  here can also check smtp server connected or not, if first time
 *  fgets return nothing, can be judged as "not connected to SMTPServer"
 *  Return: 0 means success, 1 means Fail
*/
int get_response(void)
{
    char buf[BUFSIZ];
    int bFirst = 1;

    while (fgets(buf, sizeof(buf), rfp)) {
	bFirst = 0;
        buf[strlen(buf)-1] = 0;
        dprintf("%s --> %s\n", mailhost, buf);
        if (!isdigit(buf[0]) || buf[0] > '3') {
            //printf("unexpected reply: %s", buf);//Shone modified 2006,01,10
            //exit(1);
		int ret=1;
		char *p=buf,*p1=NULL;
		FILE *fp;

		if((fp=fopen(SMTP_TMP_LOG_FILE,"w"))==NULL)
			return ret;
		fputs(buf,fp);
		if((p1=strstr(buf," "))!=NULL)
		{
			//fputs(p1+1,fp);
			*p1=0x0;
			ret=atoi(p);
		}
		fclose(fp);
		return ret;
        }
        if (buf[4] != '-')
            break;
    }
    return bFirst;
}

/*
**  say something to server and check the response
*/
int chat(char *fmt, ...)
{
    va_list ap;
    int len;

    va_start(ap, fmt);
    len = vfprintf(sfp, fmt, ap);
    va_end(ap);

    va_start(ap, fmt);
    dprintf("%s <-- ", mailhost);
    dvprintf(fmt, ap);
    va_end(ap);

    fflush(sfp);
    return get_response();
}

/*
**  transform to MIME-style quoted printable
**
**  Extracted from the METAMAIL version 2.7 source code (codes.c)
**  and modified to emit \r\n at line boundaries.
*/

static char basis_hex[] = "0123456789ABCDEF";

void toqp(FILE *infile, FILE *outfile)
{
    int c;
    int ct = 0;
    int prevc = 255;

    while ((c = getc(infile)) != EOF) {
        if (   (c < 32 && (c != '\n' && c != '\t'))
            || (c == '=')
            || (c >= 127)
            || (ct == 0 && c == '.')               ) {
        putc('=', outfile);
        putc(basis_hex[c >> 4], outfile);
        putc(basis_hex[c & 0xF], outfile);
        ct += 3;
        prevc = 'A'; /* close enough */
    }
    else if (c == '\n') {
        if (prevc == ' ' || prevc == '\t') {
	    putc('=', outfile);  /* soft & hard lines */
	    putc(c, outfile);
        }
        putc(c, outfile);
        ct = 0;
        prevc = c;
    }
    else {
        if (c == 'F' && prevc == '\n') {
        /*
         * HORRIBLE but clever hack suggested by MTR for
         * sendmail-avoidance
         */
        c = getc(infile);
        if (c == 'r') {
            c = getc(infile);
            if (c == 'o') {
            c = getc(infile);
            if (c == 'm') {
                c = getc(infile);
                if (c == ' ') {
                /* This is the case we are looking for */
                fputs("=46rom", outfile);
                ct += 6;
                } else {
                fputs("From", outfile);
                ct += 4;
                }
            } else {
                fputs("Fro", outfile);
                ct += 3;
            }
            }
            else {
            fputs("Fr", outfile);
            ct += 2;
            }
        }
        else {
            putc('F', outfile);
            ++ct;
        }
        ungetc(c, infile);
        prevc = 'x'; /* close enough -- printable */
        }
        else {
        putc(c, outfile);
        ++ct;
        prevc = c;
        }
    }
    if (ct > 72) {
        putc('=', outfile);
        putc('\r', outfile);
        putc('\n', outfile);
        ct = 0;
        prevc = '\n';
    }
    }
    if (ct) {
    putc('=', outfile);
    putc('\r', outfile);
    putc('\n', outfile);
    }
    return;
}



int send_single_mail(char *NASName, char *Subject, char *Msg, char *To, char *SMTP_IP, char *Level)
{
// Kevin Liao 2001-07-10: Fix send mail failure...
    //char my_name[BUFSIZ];

    char From[BUFSIZ];
    struct sockaddr_in sin;
    struct hostent *hp;
    int s = -1;
    int r = -1;
    char str[BUFSIZ], date_time[128], *ptr;
    IFInfo	ifi;
    int ret=0;//Shone added 2005,01,10

    sfp = NULL;
    rfp = NULL;

    strcpy(From, To);
    /*
     *  Determine SMTP server
     */
    mailhost = SMTP_IP;
//	printf(" Subject=%s\n", Subject);
//	printf(" Msg=%s\n", Msg);
//	printf(" To=%s\n", To);
//	printf(" SMTP=%s\n", SMTP_IP);

    /*
     *  Determine from address.
     */
    from_addr = From;

    /*
     *  Connect to smtp daemon on mailhost.
     */
    if ((hp = gethostbyname(mailhost)) == NULL) {
		goto SendFail;
    }
    if (hp->h_addrtype != AF_INET) {
		goto SendFail;
    }
    memset((char *)&sin, 0, sizeof(sin));
    memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
    sin.sin_family = hp->h_addrtype;
    sin.sin_port = htons(mailport);
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		goto SendFail;
    }
    if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		goto SendFail;
    }
    if ((r = dup(s)) < 0) {
		goto SendFail;
    }
    if ((sfp = fdopen(s, "w")) == 0) {
		goto SendFail;
    }
    if ((rfp = fdopen(r, "r")) == 0) {
		goto SendFail;
    }

    /*
     *  Give out SMTP headers.
     */
    if((ret=get_response())!=0) /* banner */
		goto SendFail;
// Kevin Liao 2001-07-10: Fix send mail failure...
//    if(chat("HELO %s\r\n", my_name))
    if((ret=chat("HELO %s\r\n", NASName)))
		goto SendFail;
    if((ret=chat("MAIL FROM: <%s>\r\n", from_addr)))
		goto SendFail;
    if((ret=chat("RCPT TO: <%s>\r\n", from_addr)))
		goto SendFail;
    if((ret=chat("DATA\r\n")))
		goto SendFail;

    /*
     *  Give out Message header.
     */
    fprintf(sfp, "From: %s\r\n", NASName);
    fprintf(sfp, "Subject: %s\r\n", Subject);

    if (reply_addr)
        fprintf(sfp, "Reply-To: %s\r\n", reply_addr);
    fprintf(sfp, "Sender: %s\r\n", NASName);

    fprintf(sfp, "To: %s", To);
    fprintf(sfp, "\r\n");

    if (mime_style) {
        fprintf(sfp, "MIME-Version: 1.0\r\n");
        fprintf(sfp, "Content-Type: text/plain; charset=ISO-8859-1\r\n");
        fprintf(sfp, "Content-Transfer-Encoding: quoted-printable\r\n");
    }

    fprintf(sfp, "\r\n");

    Get_Current_Date_Time(str);
    ptr = date_time;
    memset(date_time, ' ', sizeof(date_time));
    strncpy(ptr, &(str[0]), 2);
    ptr += 2;
    *ptr++ = '/';
    strncpy(ptr, &(str[2]), 2);
    ptr += 2;
    *ptr++ = '/';
    strncpy(ptr, &(str[4]), 4);
    ptr += 4;
    ptr++;
    strncpy(ptr, &(str[8]), 2);
    ptr += 2;
    *ptr++ = ':';
    strncpy(ptr, &(str[10]), 2);
    ptr += 2;
    *ptr++ = ':';
    strncpy(ptr, &(str[12]), 2);
    ptr += 2;
    *ptr++ = 0;

    Get_Network_Interface_Volatile(0, &ifi);
    // Title information
    fprintf(sfp, "Server Name: %s\r\n", NASName);
    fprintf(sfp, "IP Address: %s\r\n", ifi.ip_addr);
    fprintf(sfp, "Date/Time: %s\r\n", date_time);
    if(Level != NULL)
    	fprintf(sfp, "Level: %s\r\n", Level);
    fprintf(sfp, "\r\n");

    /*
     *  Give out Message body.
     */
    fprintf(sfp, "%s\r\n", Msg);

    /*
     *  Give out SMTP end.
     */
    if((ret=chat(".\r\n")))
		goto SendFail;
    if((ret=chat("QUIT\r\n")))
		goto SendFail;

    /*
     *  Die gracefully ...
     */
    if (sfp) fclose(sfp);
    if (rfp) fclose(rfp);
    if (s>=0) close(s);
    if (r>=0) close(r);
    return(0);
SendFail:
    if (sfp) fclose(sfp);
    if (rfp) fclose(rfp);
    if (s>=0) close(s);
    if (r>=0) close(r);
    
    if(ret!=0) return ret;//Shone modified 2006,01,10
    else 
    	return(1);
}

/*
 * send multiple mails via specified SMTP Server
 * Return:
 *	0			pass
 *	ERROR_FAIL	FAIL to send mails
 */
int Send_Mail(char *Subject, char *Msg, char *mailaddrs, char *SMTP_IP, char *Level)
{
	int  ret = SUCCESS;
	char NASName[BUFSIZ];
	char To[BUFSIZ];
	char addrs[20][BUFSIZ];
	char *token;
	char seps[] = ";\n";
	int  num = 0, i;
	/*
	 *	Determine NAS ServerName
 	 */
  	Get_Server_Name(NASName, sizeof(NASName));
	strcpy(To, mailaddrs);
//	printf("---addr=%s\n",To);
	token = strtok(To, seps);
	while(token != NULL) {
//		printf("---token=%s\n",token);
		strcpy(addrs[num++], token);
		token = strtok(NULL, seps);
	}
	for(i = 0; i < num; i++) {
		ret = send_single_mail(NASName, Subject, Msg, addrs[i], SMTP_IP, Level);
	}
	return ret;
}

//Shone ported from Model TS-401 2005,09,29
int send_single_mail_auth(char *NASName, char *Subject, char *Msg, char *To, char *SMTP_IP, char *Level, SMTP_AUTH *smtp_auth)
{
        // Kevin Liao 2001-07-10: Fix send mail failure...
    //char my_name[BUFSIZ];
    char tmp_buf[128];
    char From[BUFSIZ];
    struct sockaddr_in sin;
    struct hostent *hp;
    int s = -1;
    int r = -1;
    char str[BUFSIZ], date_time[128], *ptr;
    IFInfo      ifi;
    int ret=0;//Shone added 2005,01,10

    sfp = NULL;
    rfp = NULL;

    strcpy(From, To);
    
    //Determine SMTP server
    mailhost = SMTP_IP;

    //Determine from address.
    from_addr = From;

    //Connect to smtp daemon on mailhost.
    if ((hp = gethostbyname(mailhost)) == NULL) {
                goto SendFail;
    }
    if (hp->h_addrtype != AF_INET) {
                goto SendFail;
    }
    memset((char *)&sin, 0, sizeof(sin));
    memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
    sin.sin_family = hp->h_addrtype;
    sin.sin_port = htons(mailport);
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
                goto SendFail;
    }
    if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
                goto SendFail;
    }
    if ((r = dup(s)) < 0) {
                goto SendFail;
    }
    if ((sfp = fdopen(s, "w")) == 0) {
                goto SendFail;
    }
    if ((rfp = fdopen(r, "r")) == 0) {
                goto SendFail;
    }

    //Give out SMTP headers.
    if((ret=get_response())) /* banner */
                goto SendFail;
//      Kevin Liao 2001-07-10: Fix send mail failure...
//      if(chat("HELO %s\r\n", my_name))
    if((ret=chat("HELO %s\r\n", NASName)))
                goto SendFail;

//Paul
        //auth login username
        memset(tmp_buf,0,sizeof(tmp_buf));
        to64frombits((unsigned char *)tmp_buf, smtp_auth->username,
                                strlen(smtp_auth->username));
        if ((ret=chat("AUTH LOGIN %s\r\n", tmp_buf)))
                goto SendFail;

        //auth login password
        memset(tmp_buf,0,sizeof(tmp_buf));
        to64frombits((unsigned char *)tmp_buf, smtp_auth->password,
                                strlen(smtp_auth->password));
        if ((ret=chat("%s\r\n", tmp_buf)))
                goto SendFail;
//Paul

    if((ret=chat("MAIL FROM: <%s>\r\n", from_addr)))
                goto SendFail;
    if((ret=chat("RCPT TO: <%s>\r\n", from_addr)))
                goto SendFail;
    if((ret=chat("DATA\r\n")))
                goto SendFail;

    //Give out Message header.
    fprintf(sfp, "From: %s\r\n", NASName);
    fprintf(sfp, "Subject: %s\r\n", Subject);

    if (reply_addr)
        fprintf(sfp, "Reply-To: %s\r\n", reply_addr);
    fprintf(sfp, "Sender: %s\r\n", NASName);

    fprintf(sfp, "To: %s", To);
    fprintf(sfp, "\r\n");

    if (mime_style) {
        fprintf(sfp, "MIME-Version: 1.0\r\n");
        fprintf(sfp, "Content-Type: text/plain; charset=ISO-8859-1\r\n");
        fprintf(sfp, "Content-Transfer-Encoding: quoted-printable\r\n");
    }

    fprintf(sfp, "\r\n");

    Get_Current_Date_Time(str);
    ptr = date_time;
    memset(date_time, ' ', sizeof(date_time));
    strncpy(ptr, &(str[0]), 2);
    ptr += 2;
    *ptr++ = '/';
    strncpy(ptr, &(str[2]), 2);
    ptr += 2;
    *ptr++ = '/';
    strncpy(ptr, &(str[4]), 4);
    ptr += 4;
    ptr++;
    strncpy(ptr, &(str[8]), 2);
    ptr += 2;
    *ptr++ = ':';
    strncpy(ptr, &(str[10]), 2);
    ptr += 2;
    *ptr++ = ':';
    strncpy(ptr, &(str[12]), 2);
    ptr += 2;
    *ptr++ = 0;

    Get_Network_Interface_Volatile(0, &ifi);
    // Title information
    fprintf(sfp, "Server Name: %s\r\n", NASName);
    fprintf(sfp, "IP Address: %s\r\n", ifi.ip_addr);
    fprintf(sfp, "Date/Time: %s\r\n", date_time);
    if(Level != NULL)
        fprintf(sfp, "Level: %s\r\n", Level);
    fprintf(sfp, "\r\n");

    //Give out Message body.
    fprintf(sfp, "%s\r\n", Msg);

    //Give out SMTP end.
    if((ret=chat(".\r\n")))
                goto SendFail;
    if((ret=chat("QUIT\r\n")))
                goto SendFail;

    //Die gracefully ...
    if (sfp) fclose(sfp);
    if (rfp) fclose(rfp);
    if (s>=0) close(s);
    if (r>=0) close(r);
    return(0);
SendFail:
    if (sfp) fclose(sfp);
    if (rfp) fclose(rfp);
    if (s>=0) close(s);
    if (r>=0) close(r);
    if(ret!=0) return ret;//Shone modified 2006,01,10
    else 
    	return(1);
}

/* Shone ported from Model TS-401 2005,09,29
 * send multiple mails via specified SMTP Server with SMTP authentication
 * Return:
 *      0                       pass
 *      ERROR_FAIL      FAIL to send mails
 */
int Send_Mail_Auth(char *Subject, char *Msg, char *mailaddrs, char *SMTP_IP, char *Level,
        SMTP_AUTH *smtp_auth)
{
        int  ret = SUCCESS;
        char NASName[BUFSIZ];
        char To[BUFSIZ];
        char addrs[20][BUFSIZ];
        char *token;
        char seps[] = ";\n";
        int  num = 0, i;
        /*
         *      Determine NAS ServerName
         */
        Get_Server_Name(NASName, sizeof(NASName));
        strcpy(To, mailaddrs);
//      printf("---addr=%s\n",To);
        token = strtok(To, seps);
        while(token != NULL) {
//              printf("---token=%s\n",token);
                strcpy(addrs[num++], token);
                token = strtok(NULL, seps);
        }
        for(i = 0; i < num; i++) {
                ret = send_single_mail_auth(NASName, Subject, Msg, addrs[i], SMTP_IP, Level, smtp_auth);
        }
        return ret;
}

/*EOF*/
