#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/mount.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* include NAS */
#include <eventlog.h>
#include "cfg_system.h"
#include "cfg_rtrr.h"
#include "backup.h"
#include "cfg_nic.h"

//void backup_write_schedule(BACKUP_SCHEDULE *schedule);
char RSYNC_CMD[32]="/usr/bin/rsync ";

int exist_another_instance(char *progname);
int write_rtrr_jobs(RTRR_CLIENT *jobs, int job_num);
int get_rtrr_section_List(char *conf_file, SECTION_INFO **list_ptr);

extern int translate_str(char *str);
char	*RTRR_Models[] = {
	"NAS-5100", 
	"NAS-5100",
	0
};

//#define _DEBUG		1

void DEBUG_rtrr(RTRR_CLIENT *job)
{
	if ( job ) {
		printf("job->job_id=[%d]<br>\n",job->job_id);
		printf("job->job_enable=[%s]<br>\n",(job->job_enable?"True":"False"));
		printf("job->job_name=[%s]<br>\n",job->job_name);
		printf("job->local_share_name=[%s]<br>\n",job->local_share_name);
		printf("job->local_dir_name=[%s]<br>\n",job->local_dir_name);
		printf("job->local_path=[%s]<br>\n",job->local_path);
		printf("job->remote_server_ip=[%s]<br>\n",job->remote_server_ip);
		printf("job->remote_server_port=[%d]<br>\n",job->remote_server_port);
		printf("job->remote_share_name=[%s]<br>\n",job->remote_share_name);
		printf("job->remote_dir_name=[%s]<br>\n",job->remote_dir_name);
	}
}

/*
void get_rtrr_field(char *line, char *buf, int size)
{
	int	pos;	// indicate the index of the next character will be filled in "buf"
	char	tmp[2048];

	if ( size <= 0 )
		return;

	// read the next field with separator ':'
	strcpy(tmp, line);
	for (pos = 0 ; pos < size ; pos++) {
		if ( tmp[pos] == ':' ) {	// EOF or separator
			buf[pos] = 0;
			strcpy(line, &tmp[pos+1]);
			return;
		} else {
			buf[pos] = tmp[pos];
		}
	}

	if ( pos >= size ) {
		buf[size-1] = 0;
	}
}
*/

int get_all_rtrrc_jobs(RTRR_CLIENT *jobs, int *size)
{
	SECTION_INFO	*list=NULL;
	int	i = 0;
	char	result[256];
	int	res = 0;


	res = get_rtrr_section_List(RTRR_CONFFILE, &list);

	if ( jobs == NULL || *size < 0 ) {
		*size = res;
		return res;
	}
	

	for (i=0; i<res; i++) {
		strcpy(jobs[i].job_name, list[i].section_name);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"ID", result, 256);
		jobs[i].job_id = atoi(result);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Enable", result, 256);
		jobs[i].job_enable = ((!strcasecmp(result, "True"))?1:0);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Local Share Name", jobs[i].local_share_name, SHARE_NAME_LENGTH);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Local Dir Name", jobs[i].local_dir_name, FILE_NAME_MAX_LENGTH);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Local Path", jobs[i].local_path, FILE_NAME_MAX_LENGTH);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Remote Server IP", jobs[i].remote_server_ip, 16);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Remote Share Name", jobs[i].remote_share_name, SHARE_NAME_LENGTH);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Remote Dir Name", jobs[i].remote_dir_name, FILE_NAME_MAX_LENGTH);
		Conf_Get_Field(RTRR_CONFFILE, list[i].section_name, 
			"Remote Server Port", result, 256);
		jobs[i].remote_server_port = atoi(result);

		//DEBUG_rtrr(&jobs[i]);
	}
	*size = res;
	return res;
}

int ren_rtrrc_job(RTRR_CLIENT *new, RTRR_CLIENT *old)
{
	char	result[256];
	int	ret = 0;

	new->job_id = old->job_id;
	if ( strcmp(new->job_name, old->job_name) ) {
		ret=Conf_Get_Field(RTRR_CONFFILE, new->job_name, 
			"ID", result, 256);
		if ( ret == 0 ) {	//job_name already exist
			return ERROR_RTRRC_EDIT_EXIST;
		}
	}
	
	Conf_Remove_Section(RTRR_CONFFILE, old->job_name);
	write_rtrr_jobs(new, 1);

	return 0;
}


int ren_rtrrs_job(RTRR_SERVER *new, RTRR_SERVER *old)
{
	Conf_Set_Field(RSYNCD_CONFFILE, 
			old->share_name, "hosts allow", new->hosts_allow);

	return 0;
}


int write_rtrr_jobs(RTRR_CLIENT *jobs, int job_num)
{
	int			i;
	char			buf[128];

        if ( !jobs || !job_num )
        	return -1;

	for(i=0; i<=job_num-1; i++) {
		if ( jobs[i].job_id == -1 )
			continue;
		//DEBUG_rtrr(&jobs[i]);
		sprintf(buf, "%d", jobs[i].job_id);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"ID", buf);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Enable", (jobs[i].job_enable?"True":"False"));
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Local Share Name", jobs[i].local_share_name);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Local Dir Name", jobs[i].local_dir_name);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Local Path", jobs[i].local_path);
		if ( jobs[i].local_dir_name )
			strcat(jobs[i].local_path, jobs[i].local_dir_name);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Remote Server IP", jobs[i].remote_server_ip);
		sprintf(buf, "%d", jobs[i].remote_server_port);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Remote Server Port", buf);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Remote Share Name", jobs[i].remote_share_name);
		Conf_Set_Field(RTRR_CONFFILE, jobs[i].job_name, 
			"Remote Dir Name", jobs[i].remote_dir_name);

	}
	return 0;
}

int chk_rtrrc_conf_exist(char *conffile)
{
	FILE	*fp=NULL;

	if ( (fp = fopen(conffile, "r")) ) {
		fclose(fp);
		return 0;
	}

	fp = fopen(conffile, "w+");
	fclose(fp);

	return 0;
}

int chk_rtrrs_conf_exist(char *conffile)
{
	FILE	*fp=NULL;

	if ( (fp = fopen(conffile, "r")) ) {
		fclose(fp);
		return 0;
	}

	fp = fopen(conffile, "w+");
	fputs("uid = administrator\n", fp);
	fputs("gid = administrators\n", fp);
	fputs("#use chroot = no\n", fp);
	fputs("log file = /var/log/rsyncd.log\n", fp);
	fputs("pid file = /var/run/rsyncd.pid\n", fp);
	fputs("read only = false\n", fp);
	fputs("hosts deny = 0.0.0.0/0\n", fp);
	fputs("#end of golbal config\n\n", fp);
	fclose(fp);

	return 0;
}

int add_rtrrs_job(RTRR_SERVER *new)
{
	char		result[1024];
	int		ret = 0;
	
	if ( !new )
		return -1;
	chk_rtrrs_conf_exist(RSYNCD_CONFFILE);
	ret = Conf_Get_Field(RSYNCD_CONFFILE, 
			new->share_name, "path", result, 1024);
	if ( !ret )
		return ERROR_RTRRS_ADD_EXIST;

	//get path from smb.conf, write path to rsyncd.conf
	Conf_Get_Field(SAMBA_CONF_PATH, 
			new->share_name, "path", new->share_path, FILE_NAME_MAX_LENGTH);
	//strcpy(new->share_path, path_field);
	Conf_Set_Field(RSYNCD_CONFFILE, 
			new->share_name, "path", new->share_path);

	//get comment from smb.conf, write comment to rsyncd.conf
	/*Conf_Get_Field(SAMBA_CONF_PATH, 
			new->share_name, "comment", new->share_comment, SHARE_COMMENT_LENGTH);*/
	//strcpy(new->share_path, path_field);
	/*Conf_Set_Field(RSYNCD_CONFFILE, 
			new->share_name, "comment", new->share_comment);*/

	Conf_Set_Field(RSYNCD_CONFFILE, 
			new->share_name, "hosts allow", new->hosts_allow);
	return 0;
}


int add_rtrrc_job(RTRR_CLIENT *new)
{
	char		result[1024];
	int		ret = 0;
	int		rtrr_jobs_count = 0;
	
	if ( !new )
		return -1;

	chk_rtrrc_conf_exist(RTRR_CONFFILE);
	ret = Conf_Get_Field(RTRR_CONFFILE, 
			new->job_name, "ID", result, 1024);
	if ( ret == 0 ) {	//job_name already exist
		return ERROR_RTRRC_ADD_EXIST;
	}

	ret = get_all_rtrrc_jobs(NULL, &rtrr_jobs_count);
	new->job_id = rtrr_jobs_count;
	ret = write_rtrr_jobs(new, 1);

	return 0;

}

int get_rtrr_section_List(char *conf_file, SECTION_INFO **list_ptr)
{
	int i,j,section_no;	//,curr_s=0;
    	char tmp_str[SHARE_NAME_LENGTH];
    	int ret;
    	SECTION_INFO *list=NULL;

	// --  set all conf function case insensitive
	Conf_Case_Sensitive(0);
	if ( !conf_file )
		return -1;

	i=0;
	if ( (ret = Conf_Enum_Section(conf_file, tmp_str, SHARE_NAME_LENGTH)) == SUCCESS ) {
		list = (SECTION_INFO*)calloc(sizeof(SECTION_INFO), 1);
		strcpy(list[i].section_name,tmp_str);
		i++;
	}

	while ( (ret = Conf_Enum_Section(NULL, tmp_str, SHARE_NAME_LENGTH)) == SUCCESS ) {
		list = (SECTION_INFO*)realloc((void*)list,
			(i+1)*sizeof(SECTION_INFO));
		strcpy(list[i].section_name,tmp_str);
		i++;
		
		if (i==10)
			exit(1);
	}

    	section_no = i;
    	//- do sorting function -
    	for(i=0; i<section_no; i++) {
      		for(j=i+1;j<section_no;j++){
			if ( strcmp( (list+i)->section_name,(list+j)->section_name ) >0){
          				strcpy(tmp_str,(list+i)->section_name );
          				strcpy( (list+i)->section_name,(list+j)->section_name );
          				strcpy((list+j)->section_name,tmp_str);
        			}
      		}
    	}

	*list_ptr = list;
	return section_no;
}




int get_rtrr_server_shares(RTRR_SERVER **all_shares)
{
	RTRR_SERVER	*list=NULL;
	SECTION_INFO 	*s_ptr = NULL;
	int		section_no = 0;
	int		i;

	section_no = get_rtrr_section_List(RSYNCD_CONFFILE, &s_ptr);

	for (i=0; i<section_no; i++) {
    		list = (RTRR_SERVER*)realloc((void*)list, (i+1)*sizeof(RTRR_SERVER));
		strcpy(list[i].share_name, s_ptr[i].section_name);

		Conf_Get_Field(RSYNCD_CONFFILE, list[i].share_name, 
				"path", list[i].share_path, FILE_NAME_MAX_LENGTH);
		/*Conf_Get_Field(RSYNCD_CONFFILE, list[i].share_name, 
				"comment", list[i].share_comment, SHARE_COMMENT_LENGTH);*/
		Conf_Get_Field(SAMBA_CONF_PATH, list[i].share_name, 
				"comment", list[i].share_comment, SHARE_COMMENT_LENGTH);
		Conf_Get_Field(RSYNCD_CONFFILE, list[i].share_name, 
				"hosts allow", list[i].hosts_allow, 32);
	}
	
	if ( s_ptr ) free(s_ptr);

	*all_shares = list;
	return section_no;
}


int get_rtrr_jobs(RTRR_CLIENT **all_jobs)
{
	RTRR_CLIENT	*jobs=NULL;
	int		ret = 0;
	int		rtrr_jobs_count = 0;

#if	_DEBUG
	printf("get_rtrr_jobs starts<br>\n");
#endif

	ret = get_all_rtrrc_jobs(NULL, &rtrr_jobs_count);
#if	_DEBUG
	printf("%d jobs in %s\n", rtrr_jobs_count, RTRR_CONFFILE);
#endif
	if ( ret < 0 ) {
		return ERR_FATAL;
	}
	
	if ( (jobs = (RTRR_CLIENT *) calloc((rtrr_jobs_count+1), sizeof(RTRR_CLIENT))) == NULL ) {
		return ERR_FATAL;
	}
	if ( rtrr_jobs_count > 0 )
		get_all_rtrrc_jobs(jobs, &rtrr_jobs_count);
#if	_DEBUG
{
	int	i;
	for(i=0;i<rtrr_jobs_count;i++) {
		;//DEBUG_rtrr(&jobs[i]);
	}
}
#endif

	if (rtrr_jobs_count)
		*all_jobs = jobs;
	else
		*all_jobs = NULL;
	return rtrr_jobs_count;
}

int rtrr_get_remote_server_share_list(char *server_ip, int port, char ***share_list)
{
	char		buf[1024];
	char		line[1024];
	FILE		*fp, *tmpfp;
	int		count = 0;
	int		error_num;
	char		**tmp_list = NULL;
	
	if ( *share_list ) {
		//printf("%s:%d<br>\n", __FILE__, __LINE__);
		free(*share_list);
		*share_list=NULL;
	}
	
	sprintf(buf, "%s --port=%d %s:: 2>/dev/null || echo \"**$?\"", 
		RSYNC_CMD, port, server_ip);
	fp = popen(buf, "r");
	tmpfp = tmpfile();

	while (1)
	{
		fgets(line, 1024, fp);
		fputs(line, tmpfp);
		count++;
		line[0] = 0;
		if ( feof(fp) )
			break;
	}
	
	pclose(fp);
	rewind(tmpfp);
	tmp_list = (char **)calloc(count, sizeof(char*));
	count = 0;

	while (1)
	{
		int	i=0;
		int	ret = 0;

		bzero(line, 1024);
		fgets(line, 1024, tmpfp);
		if ( line[0] == 0 )
			break;

		if ( line[0] == '*' ) {
			//Error happens
			error_num = atoi((char*)&line[2]);
			goto err_return;
		}

		//translate_str(line);
		i = strlen(line);
		
		while( 1 ) {
			if ( i >= 1 && (line[i-1] == ' ' || line[i-1] == '\n' || line[i-1] == '\r' || line[i-1] == '\t') ) {
				i--;
			} else {
				line[i] = 0;
				break;
			}
		}
		
		sprintf(buf, "%s --port=%d --dry-run %s::\"%s\" 1>>/dev/null 2>/dev/null", 
			RSYNC_CMD, port, server_ip, line);
		ret = system(buf);
		ret = ret >> 8;
		if ( ret )
			continue;

		tmp_list[count] = (char *)calloc(i+2, sizeof(char));
		/*if (!tmp_list[count])
			printf("Failed!!! %s:%d<br>\n", __FILE__, __LINE__);
		*/
		strcpy(tmp_list[count], line);

		count ++;
		if ( feof(tmpfp) )
			break;
	}
	fclose(tmpfp);
	*share_list=tmp_list;

	return count;
err_return:
	fclose(tmpfp);
	return -1;
	
}


int del_rtrrc_job(char *job_name)
{
	int		ret = 0;

	if ( !job_name )
		return -1;
	ret=Conf_Remove_Section(RTRR_CONFFILE, job_name);

        return 0;
}

int del_rtrrs_job(char * share_name)
{
	int		ret = 0;

	if ( !share_name )
		return -1;

	ret=Conf_Remove_Section(RSYNCD_CONFFILE, share_name);
	
	return 0;
}

int is_rtrr_support()
{
	char	buf[10];
	int	ret = 0;

	ret = Conf_Get_Field("/etc/config/uLinux.conf", "RTRR", "Support", buf, sizeof(buf));
	if ( ret != SUCCESS )
		return 0;
	if ( !strcasecmp(buf, "True") )
		return 1;
	else
		return 0;
}

int is_rtrr_enabled()
{
	char	buf[10];
	int	ret = 0;

	ret = Conf_Get_Field("/etc/config/uLinux.conf", "RTRR", "Enable", buf, sizeof(buf));
	if ( ret != SUCCESS )
		return 0;
	if ( !strcasecmp(buf, "True") )
		return 1;
	else
		return 0;
}


int init_rtrr_system()
{
	//Create [RTRR] section in uLinux.conf
	char	buf[10];
	int	i = 0;
	int	ret = 0;

	ret = Conf_Get_Field("/etc/config/uLinux.conf", "RTRR", "Support", buf, sizeof(buf));
	if ( ret == SUCCESS ) {
		return 1;
	}

	Conf_Get_Field("/etc/config/uLinux.conf", "System", "Model", buf, sizeof(buf));
	while ( RTRR_Models[i] ) {
		if ( !strcasecmp(buf, RTRR_Models[i]) ) {
			Conf_Set_Field(DEFAULT_CFG_FILE, "RTRR", "Support", "True");
			Conf_Set_Field(DEFAULT_CFG_FILE, "RTRR", "Enable", "False");
			Conf_Set_Field(DEFAULT_CFG_FILE, "RTRR", "Port", "873");
			//Create rsyncd.conf file
			chk_rtrrs_conf_exist(RSYNCD_CONFFILE);
			return 2;
		}
		i++;
	}
	return 0;
}

int exist_another_instance(char *progname)
{
        DIR             *dir;
        struct dirent   *d;
        char            path[256];
        char            buf[256];
        char            *s, *q;
        FILE            *fp;
        int             pid;
        int             status;

        status = 0;
        s=strrchr(progname, '/');
        if (s!=NULL)
                progname=s+1;
        if ((dir = opendir("/proc")) == NULL)
                return status;
        while (status==0 && (d=readdir(dir))!=NULL)
        {
                if ((pid=atoi(d->d_name))==0)
			continue;
                if (pid==getpid())
			continue;

                // Open the statistics file.
                sprintf(path, "/proc/%s/stat", d->d_name);

                // Read program name from it.
                if ((fp=fopen(path, "r"))!=NULL)
                {
                        buf[0]=0;
                        fgets(buf, 256, fp);

                        s=strchr(buf, '(');
                        q=strrchr(buf, ')');
                        if (s!=NULL && q!=NULL)
                        {
                                s++;
                                *q=0;
                                if (!strcmp(s, progname))
                                        status=1;
                        }
                        fclose(fp);
                }
        }
        closedir(dir);
        return status;
}

int start_rsyncd()
{
	char	buf[1024];
	int	ret=0;

	sprintf(buf, "/etc/init.d/rsyncd.sh start 1>/dev/null 2>/dev/null");
	ret = system(buf);
	ret = ret >> 8;
	return ret;
}

int stop_rsyncd()
{
	char	buf[1024];
	int	ret=0;

	sprintf(buf, "/etc/init.d/rsyncd.sh stop 1>/dev/null 2>/dev/null");
	ret = system(buf);
	ret = ret >> 8;
	return ret;
}
