/*************************************************************************
#
#	Copyright (c) 2005  QNAP Systems, Inc.  All Rights Reserved.
#
#	FILE:
#		cfg_qdownload.c
#
#	Abstract: 
#		Enable download station api
#
#	HISTORY:
#		08/15/05	Randy Huang - Created
#
#**************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"
#include <cfg_qdownload.h>



BOOL Is_Qdownload_Enabled()//return:0-->disable;return:1-->enable
{
	char buf[BUF_SIZE];
	GetProfileString(QDOWNLOAD_SECTION, QDOWNLOAD_ENABLE_FIELD, "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}


int Enable_Qdownload(int bEnable)
{
	int val, ret = 0;

	if(bEnable)//enable
	{
		val = WriteProfileString(QDOWNLOAD_SECTION, QDOWNLOAD_ENABLE_FIELD, "TRUE");
		if(!val)
			return ERROR_WRITE_FILE;
		
		ret = system("/etc/init.d/btd.sh start >/dev/null 2>&1");
	}else
	{
		val = WriteProfileString(QDOWNLOAD_SECTION, QDOWNLOAD_ENABLE_FIELD, "FALSE");
		if(!val)
			return ERROR_WRITE_FILE;
		
		ret = system("/etc/init.d/btd.sh stop >/dev/null 2>&1");
	}

	return ret;
}
