//==========================================================================
//
//      Copyright (c) 2003  ICP Electronics Inc.  All Rights Reserved.
//
//      FILE:
//              cfg_ntp.c
//
//      Abstract:
//              config library
//
//      FUNCTIONS:
//
//      COMMENTS:       N/A
//
//      HISTORY:
//              2003/04/08      Created by Albert
//==========================================================================
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include "cfg_ntp.h"

#define SZ_NTP_SECTION				"NTP"
#define SZ_USE_NTP_SERVER_FIELD			"USE NTP Server"
#define SZ_NTP_SERVER_IP_FIELD			"NTP Server IP"
#define SZ_ENABLE_NTP_SERVER_FIELD		"Enable NTP Server"
#define SZ_NTP_INTERVAL_FIELD			"Interval"
#define SZ_NTP_TIME_UNIT_FIELD			"TimeUnit"


BOOL NTP_Is_Server_Used()
{
	return Get_Profile_Boolean(SZ_NTP_SECTION, SZ_USE_NTP_SERVER_FIELD, FALSE);
}

int NTP_Get_Server_IP(char *ip_address, int max_ip_length) 
{
	int val, ret = SUCCESS;
	
	val = Get_Profile_String(SZ_NTP_SECTION, SZ_NTP_SERVER_IP_FIELD, "", ip_address, max_ip_length);
	if(!val)
		return ERROR_READ_FILE;
	return ret;	
}

BOOL NTP_Is_Server_Enabled()
{
	return Get_Profile_Boolean(SZ_NTP_SECTION, SZ_ENABLE_NTP_SERVER_FIELD, FALSE);
}

int NTP_Get_ServerN_IP(char *ip_address, int n, int max_ip_length) 
{
	char buf[IP_ADDRESS_LENGTH];
	
	sprintf(buf, "Server%d IP", n);
	return (Get_Profile_String(SZ_NTP_SECTION, buf, "", ip_address, max_ip_length));
}

BOOL NTP_Get_Interval(int *interval)
{
	if((*interval = Get_Profile_Integer(SZ_NTP_SECTION, SZ_NTP_INTERVAL_FIELD, 0)) == 0) {
		return FALSE;
	}
	return TRUE;
}

BOOL NTP_Get_Interval_Unit(char *time_unit, int tu_size)
{
	if(Get_Profile_String(SZ_NTP_SECTION, SZ_NTP_TIME_UNIT_FIELD, "", time_unit, tu_size) == 0) {
		return FALSE;
	}
	return TRUE;
}

BOOL NTP_Set_Server_IP(char *ip_address) 
{
	return Set_Profile_String(SZ_NTP_SECTION, SZ_NTP_SERVER_IP_FIELD, ip_address);
}

BOOL NTP_Set_ServerN_IP(char *ip_address, int n, int max_ip_length) 
{
	char buf[IP_ADDRESS_LENGTH];
	
	sprintf(buf, "Server%d IP", n);
	return Set_Profile_String(SZ_NTP_SECTION, buf, ip_address);
}

BOOL NTP_Set_Interval(int interval)
{
	if(!Set_Profile_Integer(SZ_NTP_SECTION, SZ_NTP_INTERVAL_FIELD, interval)) {
		return FALSE;
	}
	return TRUE;
}

BOOL NTP_Set_Interval_Unit(char *time_unit)
{
	if(!Set_Profile_String(SZ_NTP_SECTION, SZ_NTP_TIME_UNIT_FIELD, time_unit)) {
		return FALSE;
	}
	return TRUE;
}

BOOL NTP_Set_Use_Server(BOOL b_val)
{
	return Set_Profile_Boolean(SZ_NTP_SECTION, SZ_USE_NTP_SERVER_FIELD, b_val);
}

BOOL NTP_Set_Enable_Server(BOOL b_val)
{
	return Set_Profile_Boolean(SZ_NTP_SECTION, SZ_ENABLE_NTP_SERVER_FIELD, b_val);
}

int NTP_Enable_Server()
{
	int ret = -1;
	// startup the NTP server
	ret = system("/etc/init.d/ntpd.sh start 2>/dev/null 1>/dev/null");
	if(ret != 0)
		return ERROR_FAIL;
	return SUCCESS;
}
	
int NTP_Disable_Server()
{
	BOOL b_val = FALSE;
	// shutdown the NTP server
	system("/etc/init.d/ntpd.sh stop 2>/dev/null 1>/dev/null");
	b_val = Set_Profile_Boolean(SZ_NTP_SECTION, SZ_ENABLE_NTP_SERVER_FIELD, FALSE);
	if(!b_val)
		return ERROR_FAIL;
	return SUCCESS;
}

BOOL NTP_Use_Server()
{
	int pid = 0;
	FILE *fp = NULL;

	system("/bin/pidof ntpdated > /tmp/my_ntpdated_pid");
	if((fp = fopen("/tmp/my_ntpdated_pid", "r")) != NULL) {
		fscanf(fp, "%d", &pid);
		fclose(fp);
	}
	if(pid != 0) // PID of ntpdated exists
		kill(pid, SIGUSR1); // send signal to ntpdated
		
	return TRUE;
}

int NTP_Test_Server(char *ip_address)
{
	int ret = -1;
	char buf[BUF_SIZE];
	
	sprintf(buf, "/sbin/ntpdate -q %s 2>/dev/null 1>/dev/null", ip_address);
	ret = system(buf);
	if(ret != 0) {
		return ERROR_FAIL;
	}
	return SUCCESS;
}

//Shone added 2005,11,30, this function makes the NTP server synchronize time right away.
int NTP_Update_Now(char *ip_address)
{
	int ret = -1;
	char buf[BUF_SIZE];
	
	sprintf(buf, "/sbin/ntpdate %s 2>/dev/null 1>/dev/null", ip_address);
	ret = system(buf);
	if(ret != 0) {
		return ERROR_FAIL;
	}
	system("/sbin/hwclock -w 1>/dev/null 2>&1");
	return SUCCESS;
}

