#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <ctype.h>
#include "cfg_backup_agent.h"
#include "Util.h"
//#define	_DEBUG	1

int BA_Extract_Backup_Agent_Info(char *filename, char *model, char *version)
{
	int	ret=AGENT_NONE;
	FILE	*fptr;
	char	buf[256];

	// extract model & version
	if ((fptr=fopen(filename, "rb"))==NULL)
		return ret;
	fseek(fptr, -74, SEEK_END);
	fread(buf, 1, 6+4, fptr);
	if (strncmp(buf, "icpnas", 6))
	{
		fclose(fptr);
		return ret;
	}
	fread(model, 1, 16, fptr);
	fread(version, 1, 16, fptr);
#ifdef _DEBUG
	printf("model=[%s]<br>\n", model);
	printf("ver=[%s]<br>\n", version);
#endif
	fclose(fptr);
	if (!strcasecmp(model, "NetVault"))
		ret=AGENT_NETVAULT;
	else if (!strcasecmp(model, "RetroSpect"))
		ret=AGENT_RETROSPECT;
	return ret;
}

int BA_Set_Backup_Agent_To_uLinux(char *filename, char *model, char *version)
{
	char path[256], *ptr;

        strncpy(path, filename, 256);
        path[255]=0x0;
        ptr=path+strlen(path);
        while (*ptr!='/')
                ptr--;
        *ptr=0x0;
        if (!strcasecmp(model, "NetVault") ||
            !strcasecmp(model, "RetroSpect"))
        {
                WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL, model);
                WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_VERSION, version);
		WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL_FILE, filename);
		WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL_PATH, path);
        }
        else
        {
                WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL, "none");
        }
	return 1;
}

int BA_Extract_Backup_Agent(char *filename)
{
	char	path[256], cmd[1024], *ptr;
	char	devnull[]={"2>/dev/null 1>/dev/null"};

	// decompress it
	sprintf(cmd, "/sbin/PC1 d IEI_BACKUP_AGENT %s %s.tar.gz %s", filename, filename, devnull);
	system(cmd);
	strncpy(path, filename, 256);
	path[255]=0x0;
	ptr=path+strlen(path);
	while (*ptr!='/')
		ptr--;
	*ptr=0x0;
	sprintf(cmd, "/bin/tar zxvf %s.tar.gz -C %s %s", filename, path, devnull);
#ifdef _DEBUG
	printf("path=[%s]<br>\n", path);
	printf("cmd=[%s]<br>\n", cmd);
#endif
	system(cmd);
	system("/bin/ls -al > /tmp/1.txt");

	// remove tmp files
	sprintf(cmd, "/bin/rm -f %s %s", filename, devnull);
	system(cmd);
	sprintf(cmd, "/bin/rm -f %s.tar.gz %s", filename, devnull);
	system(cmd);
	return 1;
}

int BA_Get_Agent_Type()
{
	char model[64];

	GetProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL, "none", model, 64);
	if (!strcasecmp(model, "NetVault"))
		return AGENT_NETVAULT;
	else if (!strcasecmp(model, "RetroSpect"))
		return AGENT_RETROSPECT;
	else if (!strcasecmp(model, "ARCServe"))
		return AGENT_ARCSERVE;
	else
		return AGENT_NONE;
}

char * BA_Get_Agent_Version()
{
	static char version[64];

	GetProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_VERSION, "", version, 64);
	return version;
}

/**
  only check the path & folder exist
*/
int BA_Is_Agent_Exist()
{
	char	path[256];
	DIR	*dir;
	int	type;

	type=BA_Get_Agent_Type();
	if (type==AGENT_NETVAULT)
	{
		GetProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL_PATH, "/mnt/HDA_ROOT", path, 64);
		sprintf(path, "%s/NetVault6", path);
		if ((dir=opendir(path))!=NULL)
		{
			closedir(dir);
			return 1;
		}
		return 0;
	}
	else if (type==AGENT_RETROSPECT)
	{
		GetProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL_PATH, "/mnt/HDA_ROOT", path, 64);
		sprintf(path, "%s/dantz", path);
		if ((dir=opendir(path))!=NULL)
		{
			closedir(dir);
			return 1;
		}
		return 0;
	}
	return 0;
}

int BA_Is_Process_Run(char *process)
{
	char	path[256], buf[512], *s, *q;
	DIR	*proc;
	struct dirent	*dir=NULL;
	FILE	*fptr;
	

	proc=opendir("/proc");
	while ((dir=readdir(proc)))
	{
		if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, "..") || !isdigit(*dir->d_name))
			continue;
		sprintf(path, "/proc/%s/stat", dir->d_name);
		if ((fptr=fopen(path, "r"))!=NULL)
		{
			buf[0]=0x0;
        	        fgets(buf, 256, fptr);

               	        s=strchr(buf, '(');
                        q=strrchr(buf, ')');
       	                if (s!=NULL && q!=NULL)
               	        {
                       	        s++;
                               	*q=0;
				if (!strcmp(process, s))
				{
					fclose(fptr);
					closedir(proc);
					return 1;
				}
               	        }
                fclose(fptr);
		}
	}
	closedir(proc);
	return 0;
}

int BA_Is_Agent_Run()
{
	int	ret=0, type;

	type=BA_Get_Agent_Type();
	if (type==AGENT_NETVAULT)
        {
		ret=BA_Is_Process_Run("nvpmgr");
	}
	else if (type==AGENT_RETROSPECT)
        {
		ret=BA_Is_Process_Run("retroclient");
	}
	return ret;
}

int BA_Start_Backup_Agent(int start)
{
	int	type;

	type=BA_Get_Agent_Type();
	if (type==AGENT_NETVAULT)
	{
		if (start)
			system("/etc/init.d/netvault.sh start 2>/dev/null 1>/dev/null");
		else
			system("/etc/init.d/netvault.sh stop 2>/dev/null 1>/dev/null");
	}
	else if(type==AGENT_RETROSPECT)
	{
		if (start)
			system("/etc/init.d/rcl start 2>/dev/null 1>/dev/null");
		else
			system("/etc/init.d/rcl stop 2>/dev/null 1>/dev/null");
	}
	return 1;
}

int BA_Enable_Backup_Agent(int enable)
{
	if (enable)
	{
		WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_ENABLED, "TRUE");
		BA_Start_Backup_Agent(1);
	}
	else
	{
		WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_ENABLED, "FALSE");
		BA_Start_Backup_Agent(0);
	}
	return 1;
}

int BA_Get_Backup_Agent_Enable()
{
	char	buf[256];

	GetProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_ENABLED, "FALSE", buf, 256);
	if (!strcasecmp(buf, "TRUE"))
		return 1;
	else
		return 0;
}

int BA_Set_Backup_Agent_Password(char *pwd)
{
	int	type;

	WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_PASSWORD, pwd);
	type=BA_Get_Agent_Type();
	if (type==AGENT_NETVAULT)
		system("/etc/init.d/netvault_pwd.sh");
	if (type==AGENT_RETROSPECT)
		system("/etc/init.d/retrospect_pwd.sh");
	return 1;
}

int BA_Get_Backup_Agent_Password(char *pwd, int size)
{
	GetProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_PASSWORD, "admin", pwd, size);
	return 1;
}

/**
 *  Assume agnet stop running
 */
int BA_Remove_Agent()
{
	int	type;
	char	cmd[512];

	if((type=BA_Get_Agent_Type()) < 0)
		return 0;
	if (type==AGENT_NETVAULT)
	{
		// remove all NetVault files
		sprintf(cmd, "/bin/rm /mnt/HDA_ROOT/NetVault* -rf 2>/dev/null 1>/dev/null");
		system(cmd);
	}
	else if (type==AGENT_RETROSPECT)
	{
		// remove all dantz retrospect files
		sprintf(cmd, "/bin/rm -rf /mnt/HDA_ROOT/dantz 2>/dev/null 1>/dev/null");
		system(cmd);
		sprintf(cmd, "/bin/rm -rf /var/log/retroclient.state 2>/dev/null 1>/dev/null");
		system(cmd);
	}
        WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL, "none");
        WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_VERSION, " ");
        WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL_FILE, " ");
        WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_INSTALL_PATH, " ");
	WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_ENABLED, "FALSE");
	WriteProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BA_PASSWORD, "admin");
	return 1;
}

int BA_Reset()
{
	BA_Remove_Agent();
	return 1;
}

int BA_Is_Support()
{
	char buf[20];

	GetProfileString(SZ_BACKUP_AGENT_SECTION, SZ_BACKUP_AGENT_SUPPORT, "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

