//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_appletalk.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	kw lee created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"


/* ------------------------------------------------------------------------- **
 * Build options...
 */

//#define CFG_SYSTEM_TEST		// Build as a standalone program (with main), for testing only...



/* ------------------------------------------------------------------------- **
 * Constants...
 */



/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */


BOOL is_appletalk_started();
BOOL restart_appletalk();
BOOL stop_appletalk();

#define	SZ_APPLETALK_SECTION		"Appletalk"
#define	SZ_ENABLE_FIELD			"Enable"
#define	SZ_DEFAULT_ZONE_FIELD		"Default Zone"
#define	SZ_DEFAULT_ZONE_DEFAULT		"*"

/*
 * Check Appletalk enabled
 * Return:
 *	true	Enabled			
 *	false	Disabled
 */
BOOL Is_Appletalk_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_APPLETALK_SECTION, SZ_ENABLE_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

/*
 * Enable Appletalk
 * Return:
 *	0		pass			
 *  ERROR_WRITE_FILE	can not write to config file
 *	others	fail, according to appletalk report
 */
int Enable_Appletalk(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_APPLETALK_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;

	if (bEnable) {
		//John modified 2001-10-18:
		//if (!is_appletalk_started()) ret = restart_appletalk();	 		if(!is_appletalk_started())
			if(!restart_appletalk())	ret = ERROR_FAIL;
	}
	else {
		//John modified 2001-10-18:
		//ret = stop_appletalk();
		if(!stop_appletalk())	ret = ERROR_FAIL;
	}
	return ret;
}


/*
 * Get default appletalk zone name
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Appletalk_Default_Zone(char *default_zone, int buf_size)
{
	int val, ret = SUCCESS;

	val = GetProfileString(SZ_APPLETALK_SECTION, SZ_DEFAULT_ZONE_FIELD, SZ_DEFAULT_ZONE_DEFAULT, default_zone, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/*
 * Set default appletalk zone name
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 *  others			fail, according to appletalk's report
 */
int Set_Appletalk_Default_Zone(char *default_zone)
{
	int val, ret = SUCCESS;
	
	val = WriteProfileString(SZ_APPLETALK_SECTION, SZ_DEFAULT_ZONE_FIELD, default_zone);
	if(!val)
		return ERROR_WRITE_FILE;
	// restart appletalk to make the change effective...
//	if (Is_Appletalk_Enabled()) ret = restart_appletalk();
	return ret;
}


BOOL is_appletalk_started()
{
	// here, check atalkd only!! it's possible atalkd up but afpd is still
	// not up, because nbrgstr is still waiting...
	if(system("/sbin/pidof atalkd > /dev/null"))
		return FALSE;
	return TRUE;
}

BOOL restart_appletalk()
{
	int ret = system("/etc/init.d/atalk.sh restart > /dev/null 2> /dev/null");
	return (ret == 0);
}

BOOL stop_appletalk()
{
//	int ret = system("/etc/init.d/atalk.sh stop > /dev/null 2> /dev/null");
	int ret = system("/etc/init.d/atalk.sh stop > /dev/null");
	return (0 == ret);
}

int set_appletalk_codepage(char *cp_str)
{
	// ******* TBD *********
	int ret = SUCCESS;
//	int ret = WritePrivateProfileString("global", ""client code page", cp_str, SAMBA_CONF_PATH);
//	// restart samba to make the change effective...
//	if (IsSambaEnabled()) RestartSamba();
	return ret;
}
