#!/bin/sh
CONFIG=/etc/config/smb.conf

# Check that smb.conf exists.
[ -f $CONFIG ] || exit 0
/sbin/setcfg global "null passwords" yes -f ${CONFIG}
mode=`/sbin/getcfg global "force directory security mode" -f ${CONFIG}`
if [ "x${mode}" = "x0777" ]
then
	/sbin/setcfg global "force directory security mode" 0000 -f ${CONFIG}
fi
# force to change send/receive buffer size
/sbin/setcfg global "socket options" "TCP_NODELAY SO_KEEPALIVE SO_SNDBUF=32768 SO_RCVBUF=32768" -f ${CONFIG}

# See how we were called.
case "$1" in
  start)
	if [ `/sbin/getcfg Samba Enable -u -d TRUE` = FALSE ]
	then
	    echo "Starting SMB Services: disabled."
	    exit 0
	fi
	echo -n "Starting SMB services:"
	/sbin/daemon_mgr smbd start "/usr/local/samba/sbin/smbd -D -s $CONFIG"
	if [ "$?" = "0" ]; then echo -n " smbd"; fi
	/sbin/daemon_mgr nmbd start "/usr/local/samba/sbin/nmbd -D -s $CONFIG"
	if [ "$?" = "0" ]; then echo -n " nmbd"; fi
	echo "."
	touch /var/lock/subsys/smb
	;;
  stop)
	echo -n "Shutting down SMB services:"

	## we have to get all the smbd process here instead of just the
	## main parent (i.e. killproc) because it can take a long time
	## for an individual process to process a TERM signal
	smbdpids=`pidof smbd`
	/sbin/daemon_mgr smbd stop /usr/local/samba/sbin/smbd
	for pid in $smbdpids; do
		kill -TERM $pid
	done
	echo -n " smbd"
	nmbdpids=`pidof nmbd`
	/sbin/daemon_mgr nmbd stop /usr/local/samba/sbin/nmbd
	for pid in $nmbdpids; do
		kill -TERM $pid
	done
	echo " nmbd."
	rm -f /var/lock/subsys/smb
	;;
  restart)
	echo "Restarting SMB services:"
	$0 stop
	$0 start
	echo "done."
	;;
  *)
	echo "Usage: smb {start|stop|restart}"
	exit 1
esac

