#!/bin/sh
# For Administration
# default port: 6000

test -f /usr/local/sbin/thttpd || exit 0
/sbin/http_link

case "$1" in
    start)
	echo -n "Starting thttpd services:" 
	/sbin/daemon_mgr thttpd start \
		"/usr/local/sbin/thttpd -p 6000 -nor -nos -u administrator -d /home/httpd -c '**.*'"
	echo -n " thttpd"
	touch /var/lock/subsys/thttpd
	echo "."
	;;
    stop)
	echo -n "Shutting down thttpd services:" 
	/sbin/daemon_mgr thttpd stop /usr/local/sbin/thttpd
	rm -f /var/lock/subsys/thttpd
	echo -n " thttpd"
	echo "."
	;;
    restart)
	$0 stop
	$0 start
	;;	
    *)
        echo "Usage: /etc/init.d/thttpd {start|stop|restart}"
        exit 1
esac

exit 0
