#!/bin/sh

case "$1" in
    start)
	STARTED=`/sbin/getcfg Misc "System Started" -u -d FALSE`
	if [ $STARTED = TRUE ]; then
		echo "Last system shutdown process is incomplete."
		/sbin/report_log -t Warning "The system was not shutdowned properly last time."
		/sbin/daemon_mgr
	else
		/sbin/setcfg Misc "System Started" TRUE
	fi
	/sbin/report_log -t Information "System started."
    ;;
    stop)
	/sbin/setcfg Misc "System Started" FALSE
	/sbin/report_log -t Information "System was shut down on `/bin/date`."
    ;;
    restart)
    $0 stop
    $0 start
    ;;
    *)
	echo "Usage: /etc/init.d/shutdown_check.sh {start|stop|restart}"
	exit 1
esac

