#!/bin/sh

RETVAL=0
case "$1" in
  start)
        echo -n "Starting FTP services: "
	if [ `/sbin/getcfg FTP Enable -u -d FALSE` = TRUE ]; then
	        /sbin/daemon_mgr proftpd start "/usr/local/sbin/proftpd"
	fi
        RETVAL=$?
	echo "proftpd."
        ;;
  stop)
        echo "Shutting down FTP services: "
	/sbin/daemon_mgr proftpd stop "/usr/local/sbin/proftpd"
	RETVAL=$?
        ;;
  restart)
        $0 stop
        $0 start
        RETVAL=$?
	echo "stopped."
        ;;
  reconfig)
	echo "Reconfigure FTP services: "
	pid=`/bin/pidof proftpd`
	if [ "$pid" != "" ]; then
		echo "reconfig ftp success"
		/bin/kill -HUP $pid
	fi
	;;
  *)
        echo "Usage: $0 {start|stop|restart|reconfig}"
        exit 1
esac

exit $RETVAL

