#!/bin/sh
# For Qweb and Qphoto
# default port: 80

QWEB_SLINK="/home/Qhttpd/Qweb"
QWEB_FOLDER="/share/HDA_DATA/Qweb"
QWEB_DEFAULT_INDEX_HTML="/home/httpd/help/eng/help_qweb.html"
QWEB_INDEX_HTML="$QWEB_SLINK/index.html"
QWEB_INDEX_HTM="$QWEB_SLINK/index.htm"

init_qweb()
{
	if [ ! -f $QWEB_INDEX_HTML ] && [ ! -f $QWEB_INDEX_HTM ]; then
		/bin/cp "$QWEB_DEFAULT_INDEX_HTML" "$QWEB_INDEX_HTML"
	fi
}

check_qweb_link()
{
	if [ `/sbin/getcfg "QWEB" "Enable" -d 0` = 1 ]; then
		if [ -d $QWEB_FOLDER ]; then
			if [ ! -e $QWEB_SLINK ]; then
				ln -s $QWEB_FOLDER $QWEB_SLINK
			elif [ ! -L $QWEB_SLINK ]; then
			#shouldn't come to this place
				rm -rf $QWEB_SLINK
				ln -s $QWEB_FOLDER $QWEB_SLINK
			fi
			init_qweb
		fi
	fi
}

test -f /usr/local/sbin/Qthttpd || exit 0

case "$1" in
    start)
	echo -n "Starting Qthttpd services:" 
	check_qweb_link
	PORT_NO=`/sbin/getcfg QWEB Port -d 80`
	/sbin/daemon_mgr Qthttpd start \
		"/usr/local/sbin/Qthttpd -p $PORT_NO -nor -nos -u administrator -d /home/Qhttpd -c '**.*'"
	echo -n " Qthttpd"
	touch /var/lock/subsys/Qthttpd
	echo "."
	;;
    stop)
	echo -n "Shutting down Qthttpd services:" 
	/sbin/daemon_mgr Qthttpd stop /usr/local/sbin/Qthttpd
	rm -f /var/lock/subsys/Qthttpd
	echo -n " Qthttpd"
	echo "."
	;;
    restart)
	$0 stop
	$0 start
	;;
    reload)
	check_qweb_link
	/bin/kill -HUP `pidof Qthttpd`
	;;
    *)
        echo "Usage: /etc/init.d/$0 {start|stop|restart}"
        exit 1
esac

exit 0
