//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		uLinux.h
//
//	Abstract: 
//		Standard header for uLinux library functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	Meiji Chang created
//
//**************************************************************************

#ifndef ULINUX_H

#define ULINUX_H




#ifndef ICPNAS

#undef 	TRUE
#undef 	True
#undef 	FALSE
#undef 	False

typedef enum { FALSE = 0, TRUE = 1, False = 0, True = 1 } BOOL;
#else
typedef int	BOOL;
#endif

typedef	char *	LPSTR;
typedef	const char * 	LPCSTR;
typedef	unsigned long	ULONG;
typedef	unsigned int	UINT;


#define	BUF_SIZE	257


#define	NOT_FALSE(str)		((strcasecmp(str, "FALSE")) ? 1 : 0)
#define	IS_TRUE(str)		(!strcasecmp(str, "TRUE"))	
#define	BOOL2STR(bool)		( (bool) ? "TRUE" : "FALSE" )
#define	STR2BOOL(str)		((BOOL) (((!strcasecmp(str, "TRUE")) | (!strcasecmp(str, "YES")) | (atoi(str) != 0) ) ? TRUE : FALSE ))
#define	EMPTY_STRING(str)	((NULL == str) || (strlen(str) == 0))



// Common Error Code Definition
#define	SUCCESS				0	// function returns successfully

#ifndef ERROR_SUCCESS
	#define	ERROR_SUCCESS			0	// function returns successfully
#endif

#define	ERROR_FAIL			-1	// generic failure code
#define	ERROR_INVALID_PARAM		-2	// the parameter is invalid
#define	ERROR_OPEN_FILE			-3	// fail to open file
#define	ERROR_READ_FILE			-4	// fail to read from file
#define	ERROR_WRITE_FILE		-5	// fail to write into file

#define	ERROR_NOT_FOUND			-6	// cannot find the specified file or target

#define	ERROR_EXEC_FAIL			-7	// call system command or function fail

#define	ERROR_ALREADY_EXISTED		-8	// the user or group already exist 
#define	ERROR_BUFFER_TOO_SMALL		-9	// the output buffer is too small 
#define	ERROR_OUT_OF_MEMORY		-10	// unable to allocate memory 

#define	ERROR_BUSY			-11	// busy, try it later
#define	ERROR_NOT_EXISTED		-12	// the specified target is not existed
#define	ERROR_IO_ERROR			-13	// generic I/O error
#define	ERROR_TIMEOUT			-14	// execution timeout

#define	ERROR_RESERVED_USER		-15	// can't add/remove the system reserved user...
#define	ERROR_RESERVED_GROUP		-16	// can't add/remove the system reserved group...

#define	ERROR_BAD_USERNAME		-17	// The user name is invalid or not existed
#define	ERROR_BAD_GROUPNAME		-18	// The group name is invalid or not existed
#define	ERROR_BAD_PASSWORD		-19	// The password is not valid
#define	ERROR_NO_PRIVILEGE		-20	// No enough privilege
#define	ERROR_LOCK_FILE			-21
#define ERROR_READ_LOCK			-22	// OPEN FILE BE READ LOCKED
#define ERROR_WRITE_LOCK		-23	// OPEN FILE BE WRITE LOCKED
#define ERROR_ILLEGAL_NAME		-24	// input illegal name
#define ERROR_EMPTY_STRING		-25	// Null string
#define	ERROR_PDC_USER_GROUP		-26	// caused by the limitations of PDC users/groups

#endif



