//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		nas_tape.h
//
//	Abstract: 
//		Standard header for uLinux library functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		03/01/2002	Johnson Hsu created
//
//**************************************************************************

#ifndef ICPNAS

#undef 	TRUE
#undef 	True
#undef 	FALSE
#undef 	False

typedef enum { FALSE = 0, TRUE = 1, False = 0, True = 1 } BOOL;
#else
typedef int	BOOL;
#endif

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <dirent.h>
#include <time.h>

//#define TAPE_JOB_READY_STATUS		"ready"
//#define TAPE_JOB_EXECUTE_STATUS	"execute"
//#define TAPE_JOB_WAIT_STATUS		"wait"

#define TAPE_JOB_READY_STATUS		"ready"
#define TAPE_JOB_FINISH_STATUS		"finished"
#define TAPE_JOB_FAIL_STATUS		"failed"
#define TAPE_JOB_STOP_STATUS		"stopped"
#define TAPE_JOB_EXECUTE_STATUS		"executing"
#define TAPE_JOB_WAIT_STATUS		"waiting"
#define TAPE_JOB_DEFAULT_PID		-1
#define STR_LENGTH 			254
#define SSTR_LENGTH 			64
#define TAPE_CRONTAB_FILE 		"/etc/config/tape/crontab.tape"
#define TAPE_CRONTAB_TMP_FILE 		"/etc/config/tape/crontab.tape.tmp"

// <begin> by Johnson, 07/17/2002
#define TAPE_CONFIG_DIR			"/etc/config/tape"
// <end> by Johnson, 07/17/2002

BOOL Tape_Tar_Set_Cron_Job_Status(int choose)
{
	BOOL	result = FALSE;
	FILE 	*fptr, *fptrm;	
	char sys_cmd[STR_LENGTH];
	int  id;
	char task_name[SSTR_LENGTH]="";	
	char source[SSTR_LENGTH]="";
	char type[SSTR_LENGTH]="";
	int  compress;
	int  verify;	
	int  day;
	char weekly[SSTR_LENGTH]="";
	int  monthly;
	int  hh; //time:hh
	int  mm; //time:mm
	char tape_cmd[STR_LENGTH]="";
	char status[SSTR_LENGTH]="";
	int  pid;	
	int  file_num0,file_num1;		//A20040512,albert add-start == for patch tape schedule jobs is cleared abnormally.

// <begin> by Johnson, 07/17/2002	
// fixed /bin/touch: creating `/etc/config/tape/crontab.tape`: No such file or directory problem
// fixed /bin/mv: cannot stat `/etc/config/tape/crontab.tape`: No such file or directory problem
	struct stat tape_buf;
	
	if (stat(TAPE_CONFIG_DIR, &tape_buf)!=0)
		return FALSE;
// <end> by Johnson, 07/17/2002

	sprintf(sys_cmd, "/bin/touch %s", TAPE_CRONTAB_FILE);	
	system(sys_cmd);
	
	sprintf(sys_cmd, "/bin/mv -f %s %s", TAPE_CRONTAB_FILE, TAPE_CRONTAB_TMP_FILE);	
	system(sys_cmd);

	if ((fptrm=fopen(TAPE_CRONTAB_TMP_FILE, "r+"))==NULL)
		return FALSE;

	if ((fptr=fopen(TAPE_CRONTAB_FILE, "w+"))==NULL)
		return FALSE;
//A20040512,albert add-start == for patch tape schedule jobs is cleared abnormally.

	if ((file_num0 = fileno(fptrm)) == -1) 
	{
		sprintf(sys_cmd, "/bin/mv -f %s %s", TAPE_CRONTAB_TMP_FILE, TAPE_CRONTAB_FILE);	
		system(sys_cmd);
		return FALSE;
	}
	if ((file_num1 = fileno(fptr)) == -1);
	{
		sprintf(sys_cmd, "/bin/mv -f %s %s", TAPE_CRONTAB_TMP_FILE, TAPE_CRONTAB_FILE);	
		system(sys_cmd);
		return FALSE;
	}
	if ((flock(file_num0, LOCK_EX)) != 0)
	{
		sprintf(sys_cmd, "/bin/mv -f %s %s", TAPE_CRONTAB_TMP_FILE, TAPE_CRONTAB_FILE);	
		system(sys_cmd);
		return FALSE;
	}
	if ((flock(file_num1, LOCK_EX)) != 0)
	{
		sprintf(sys_cmd, "/bin/mv -f %s %s", TAPE_CRONTAB_TMP_FILE, TAPE_CRONTAB_FILE);	
		system(sys_cmd);
		return FALSE;
	}
//A20040512,albert add-end
		
	while (!feof(fptrm))
	{		
		fscanf(fptrm, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d",
			&id, task_name, source, type, &compress, &verify, &day, weekly, &monthly, &hh, &mm, tape_cmd, status, &pid);	

		if (strcasecmp(task_name,"")==0) //prevent to read null line	
			continue;

		switch (choose) {
		case	1:	if (strcasecmp(status, TAPE_JOB_EXECUTE_STATUS)==0) {//for begin
					pid=getpid();
					result = TRUE;	
				}			
				break;							
		case	2:	if (strcasecmp(status, TAPE_JOB_EXECUTE_STATUS)==0) {//for wait
					strcpy(status, TAPE_JOB_WAIT_STATUS);
					result = TRUE;				
				}
				break;	
		case	3:	if (strcasecmp(status, TAPE_JOB_WAIT_STATUS)==0) {//for wait then execute
					strcpy(status, TAPE_JOB_EXECUTE_STATUS);
					result = TRUE;	
				}			
				break;
		case	4:	if (strcasecmp(status, TAPE_JOB_EXECUTE_STATUS)==0) {//for finish
					strcpy(status, TAPE_JOB_FINISH_STATUS);
					pid = TAPE_JOB_DEFAULT_PID;
					result = TRUE;
				}				
				break;
		case	5:	if ((strcasecmp(status, TAPE_JOB_EXECUTE_STATUS)==0) ||
					(strcasecmp(status, TAPE_JOB_WAIT_STATUS)==0)) {//for user abort
					strcpy(status, TAPE_JOB_STOP_STATUS);
					pid = TAPE_JOB_DEFAULT_PID;
					result = TRUE;	
				}			
				break;	
		case	6:	if (strcasecmp(status, TAPE_JOB_EXECUTE_STATUS)==0 ||
					(strcasecmp(status, TAPE_JOB_WAIT_STATUS)==0)) {//for process failure
					strcpy(status, TAPE_JOB_FAIL_STATUS);
					pid = TAPE_JOB_DEFAULT_PID;
					result = TRUE;	
				}			
				break;							
/*													
		case	4:	if (strcasecmp(status, TAPE_JOB_EXECUTE_STATUS)==0) {//for finish, old version
					strcpy(status, TAPE_JOB_READY_STATUS);
					pid = TAPE_JOB_DEFAULT_PID;
					result = TRUE;
				}				
				break;						
		case	5:	if ((strcasecmp(status, TAPE_JOB_EXECUTE_STATUS)==0) ||
					(strcasecmp(status, TAPE_JOB_WAIT_STATUS)==0)) {//for user abort, old version
					strcpy(status, TAPE_JOB_READY_STATUS);
					pid = TAPE_JOB_DEFAULT_PID;
					result = TRUE;	
				}			
				break;
*/
		default:	break;		
		}							

		fprintf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d\n", 
			id, task_name, source, type, compress, verify, day, weekly, monthly, hh, mm, tape_cmd, status, pid);
			
		strcpy(task_name,""); //prevent to read null line
			
	}
		
//A20040512,albert add-start == for patch tape schedule jobs is cleared abnormally.
	flock(file_num0, LOCK_UN);
	flock(file_num1, LOCK_UN);
//A20040512,albert add-end
	fclose(fptrm);				
	fclose(fptr);
	
	sprintf(sys_cmd, "/bin/rm -f %s", TAPE_CRONTAB_TMP_FILE);	
	system(sys_cmd);
	
	return result;				
}
