#ifndef _WINBINDD_PROTO_H_
#define _WINBINDD_PROTO_H_

/* This file is automatically generated with "make proto". DO NOT EDIT */


/* The following definitions come from nsswitch/winbindd.c  */

void add_fd_event(struct fd_event *ev);
void remove_fd_event(struct fd_event *ev);
void setup_async_read(struct fd_event *event, void *data, size_t length,
		      void (*finished)(void *private_data, BOOL success),
		      void *private_data);
void setup_async_write(struct fd_event *event, void *data, size_t length,
		       void (*finished)(void *private_data, BOOL success),
		       void *private_data);
void request_error(struct winbindd_cli_state *state);
void request_ok(struct winbindd_cli_state *state);
void request_finished_cont(void *private_data, BOOL success);
int winbindd_main(int argc, char **argv);

/* The following definitions come from nsswitch/winbindd_ads.c  */


/* The following definitions come from nsswitch/winbindd_async.c  */

void idmap_set_mapping_async(TALLOC_CTX *mem_ctx, const DOM_SID *sid,
			     unid_t id, int id_type,
			     void (*cont)(void *private_data, BOOL success),
			     void *private_data);
enum winbindd_result winbindd_dual_idmapset(struct winbindd_domain *domain,
					    struct winbindd_cli_state *state);
void idmap_sid2uid_async(TALLOC_CTX *mem_ctx, const DOM_SID *sid, BOOL alloc,
			 void (*cont)(void *private_data, BOOL success, uid_t uid),
			 void *private_data);
enum winbindd_result winbindd_dual_sid2uid(struct winbindd_domain *domain,
					   struct winbindd_cli_state *state);
void winbindd_uid2name_async(TALLOC_CTX *mem_ctx, uid_t uid,
			     void (*cont)(void *private_data, BOOL success,
					  const char *name),
			     void *private_data);
enum winbindd_result winbindd_dual_uid2name(struct winbindd_domain *domain,
					    struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_name2uid(struct winbindd_domain *domain,
					    struct winbindd_cli_state *state);
void idmap_sid2gid_async(TALLOC_CTX *mem_ctx, const DOM_SID *sid, BOOL alloc,
			 void (*cont)(void *private_data, BOOL success, gid_t gid),
			 void *private_data);
enum winbindd_result winbindd_dual_sid2gid(struct winbindd_domain *domain,
					   struct winbindd_cli_state *state);
void winbindd_gid2name_async(TALLOC_CTX *mem_ctx, gid_t gid,
			     void (*cont)(void *private_data, BOOL success,
					  const char *name),
			     void *private_data);
enum winbindd_result winbindd_dual_gid2name(struct winbindd_domain *domain,
					    struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_name2gid(struct winbindd_domain *domain,
					    struct winbindd_cli_state *state);
void winbindd_lookupsid_async(TALLOC_CTX *mem_ctx, const DOM_SID *sid,
			      void (*cont)(void *private_data, BOOL success,
					   const char *dom_name,
					   const char *name,
					   enum SID_NAME_USE type),
			      void *private_data);
enum winbindd_result winbindd_dual_lookupsid(struct winbindd_domain *domain,
					     struct winbindd_cli_state *state);
void winbindd_lookupname_async(TALLOC_CTX *mem_ctx, const char *dom_name,
			       const char *name,
			       void (*cont)(void *private_data, BOOL success,
					    const DOM_SID *sid,
					    enum SID_NAME_USE type),
			       void *private_data);
enum winbindd_result winbindd_dual_lookupname(struct winbindd_domain *domain,
					      struct winbindd_cli_state *state);
void winbindd_getsidaliases_async(struct winbindd_domain *domain,
				  TALLOC_CTX *mem_ctx,
				  const DOM_SID *sids, int num_sids,
			 	  void (*cont)(void *private_data,
				 	       BOOL success,
					       const DOM_SID *aliases,
					       int num_aliases),
				  void *private_data);
enum winbindd_result winbindd_dual_getsidaliases(struct winbindd_domain *domain,
						 struct winbindd_cli_state *state);
void winbindd_gettoken_async(TALLOC_CTX *mem_ctx, const DOM_SID *user_sid,
			     void (*cont)(void *private_data, BOOL success,
					  DOM_SID *sids, int num_sids),
			     void *private_data);
void winbindd_sid2uid_async(TALLOC_CTX *mem_ctx, const DOM_SID *sid,
			    void (*cont)(void *private_data, BOOL success,
					 uid_t uid),
			    void *private_data);
void winbindd_sid2gid_async(TALLOC_CTX *mem_ctx, const DOM_SID *sid,
			    void (*cont)(void *private_data, BOOL success,
					 gid_t gid),
			    void *private_data);
void query_user_async(TALLOC_CTX *mem_ctx, struct winbindd_domain *domain,
		      const DOM_SID *sid,
		      void (*cont)(void *private_data, BOOL success,
				   const char *acct_name,
				   const char *full_name,
				   const char *homedir,
				   const char *shell,
				   uint32 group_rid),
		      void *private_data);

/* The following definitions come from nsswitch/winbindd_cache.c  */

void wcache_flush_cache(void);
void winbindd_check_cache_size(time_t t);
struct cache_entry *centry_start(struct winbindd_domain *domain, NTSTATUS status);
void wcache_invalidate_samlogon(struct winbindd_domain *domain, 
				NET_USER_INFO_3 *info3);
void wcache_invalidate_cache(void);
void cache_store_response(pid_t pid, struct winbindd_response *response);
BOOL cache_retrieve_response(pid_t pid, struct winbindd_response * response);
char *cache_store_request_data(TALLOC_CTX *mem_ctx, char *request_string);
char *cache_retrieve_request_data(TALLOC_CTX *mem_ctx, char *key);

/* The following definitions come from nsswitch/winbindd_cm.c  */

void invalidate_cm_connection(struct winbindd_cm_conn *conn);
void close_conns_after_fork(void);
void set_dc_type_and_flags( struct winbindd_domain *domain );
NTSTATUS cm_connect_sam(struct winbindd_domain *domain, TALLOC_CTX *mem_ctx,
			struct rpc_pipe_client **cli, POLICY_HND *sam_handle);
NTSTATUS cm_connect_lsa(struct winbindd_domain *domain, TALLOC_CTX *mem_ctx,
			struct rpc_pipe_client **cli, POLICY_HND *lsa_policy);
NTSTATUS cm_connect_netlogon(struct winbindd_domain *domain,
			     TALLOC_CTX *mem_ctx,
			     struct rpc_pipe_client **cli,
			     unsigned char **session_key,
			     DOM_CRED **credentials);

/* The following definitions come from nsswitch/winbindd_dual.c  */

void async_request(TALLOC_CTX *mem_ctx, struct winbindd_child *child,
		   struct winbindd_request *request,
		   struct winbindd_response *response,
		   void (*continuation)(void *private_data, BOOL success),
		   void *private_data);
void async_domain_request(TALLOC_CTX *mem_ctx,
			  struct winbindd_domain *domain,
			  struct winbindd_request *request,
			  struct winbindd_response *response,
			  void (*continuation)(void *private_data, BOOL success),
			  void *private_data);
void sendto_child(struct winbindd_cli_state *state,
		  struct winbindd_child *child);
void sendto_domain(struct winbindd_cli_state *state,
		   struct winbindd_domain *domain);
void setup_domain_child(struct winbindd_domain *domain,
			struct winbindd_child *child,
			const char *explicit_logfile);
void winbind_child_died(pid_t pid);

/* The following definitions come from nsswitch/winbindd_group.c  */

void winbindd_getgrnam(struct winbindd_cli_state *state);
void winbindd_getgrgid(struct winbindd_cli_state *state);
void winbindd_setgrent(struct winbindd_cli_state *state);
void winbindd_endgrent(struct winbindd_cli_state *state);
void winbindd_getgrent(struct winbindd_cli_state *state);
void winbindd_list_groups(struct winbindd_cli_state *state);
void winbindd_getgroups(struct winbindd_cli_state *state);
void winbindd_getusersids(struct winbindd_cli_state *state);
void winbindd_getuserdomgroups(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_getuserdomgroups(struct winbindd_domain *domain,
						    struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_misc.c  */

void winbindd_check_machine_acct(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_check_machine_acct(struct winbindd_domain *domain,
						      struct winbindd_cli_state *state);
void winbindd_list_trusted_domains(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_list_trusted_domains(struct winbindd_domain *domain,
							struct winbindd_cli_state *state);
void winbindd_getdcname(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_getdcname(struct winbindd_domain *domain,
					     struct winbindd_cli_state *state);
void winbindd_show_sequence(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_show_sequence(struct winbindd_domain *domain,
						 struct winbindd_cli_state *state);
void winbindd_domain_info(struct winbindd_cli_state *state);
void winbindd_ping(struct winbindd_cli_state *state);
void winbindd_info(struct winbindd_cli_state *state);
void winbindd_interface_version(struct winbindd_cli_state *state);
void winbindd_domain_name(struct winbindd_cli_state *state);
void winbindd_netbios_name(struct winbindd_cli_state *state);
void winbindd_priv_pipe_dir(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_pam.c  */

void winbindd_pam_auth(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_pam_auth(struct winbindd_domain *domain,
					    struct winbindd_cli_state *state) ;
void winbindd_pam_auth_crap(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_pam_auth_crap(struct winbindd_domain *domain,
						 struct winbindd_cli_state *state) ;
void winbindd_pam_chauthtok(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_passdb.c  */

BOOL fill_passdb_alias_grmem(struct winbindd_domain *domain,
			     DOM_SID *group_sid, 
			     int *num_gr_mem, char **gr_mem, int *gr_mem_len);

/* The following definitions come from nsswitch/winbindd_reconnect.c  */


/* The following definitions come from nsswitch/winbindd_rpc.c  */

NTSTATUS msrpc_name_to_sid(struct winbindd_domain *domain,
			    TALLOC_CTX *mem_ctx,
			    const char *domain_name,
			    const char *name,
			    DOM_SID *sid,
			    enum SID_NAME_USE *type);
NTSTATUS msrpc_sid_to_name(struct winbindd_domain *domain,
			    TALLOC_CTX *mem_ctx,
			    const DOM_SID *sid,
			    char **domain_name,
			    char **name,
			    enum SID_NAME_USE *type);
NTSTATUS msrpc_lookup_useraliases(struct winbindd_domain *domain,
				  TALLOC_CTX *mem_ctx,
				  uint32 num_sids, const DOM_SID *sids,
				  uint32 *num_aliases, uint32 **alias_rids);

/* The following definitions come from nsswitch/winbindd_sid.c  */

void winbindd_lookupsid(struct winbindd_cli_state *state);
void winbindd_lookupname(struct winbindd_cli_state *state);
void init_idmap_child(void);
struct winbindd_child *idmap_child(void);
void winbindd_sid_to_uid(struct winbindd_cli_state *state);
void winbindd_sid_to_gid(struct winbindd_cli_state *state);
void winbindd_uid_to_sid(struct winbindd_cli_state *state);
void winbindd_gid_to_sid(struct winbindd_cli_state *state);
void winbindd_allocate_rid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_allocate_rid(struct winbindd_domain *domain,
						struct winbindd_cli_state *state);
void winbindd_allocate_rid_and_gid(struct winbindd_cli_state *state);
enum winbindd_result winbindd_dual_allocate_rid_and_gid(struct winbindd_domain *domain,
							struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_user.c  */

enum winbindd_result winbindd_dual_userinfo(struct winbindd_domain *domain,
					    struct winbindd_cli_state *state);
void winbindd_getpwnam(struct winbindd_cli_state *state);
void winbindd_getpwuid(struct winbindd_cli_state *state);
void winbindd_setpwent(struct winbindd_cli_state *state);
void winbindd_endpwent(struct winbindd_cli_state *state);
void winbindd_getpwent(struct winbindd_cli_state *state);
void winbindd_list_users(struct winbindd_cli_state *state);

/* The following definitions come from nsswitch/winbindd_util.c  */

struct winbindd_domain *domain_list(void);
void free_domain_list(void);
void rescan_trusted_domains( void );
enum winbindd_result init_child_connection(struct winbindd_domain *domain,
					   void (*continuation)(void *private_data,
								BOOL success),
					   void *private_data);
enum winbindd_result winbindd_dual_init_connection(struct winbindd_domain *domain,
						   struct winbindd_cli_state *state);
void init_domain_list(void);
struct winbindd_domain *find_domain_from_name_noinit(const char *domain_name);
struct winbindd_domain *find_domain_from_name(const char *domain_name);
struct winbindd_domain *find_domain_from_sid_noinit(const DOM_SID *sid);
struct winbindd_domain *find_domain_from_sid(const DOM_SID *sid);
struct winbindd_domain *find_our_domain(void);
struct winbindd_domain *find_builtin_domain(void);
struct winbindd_domain *find_lookup_domain_from_sid(const DOM_SID *sid);
struct winbindd_domain *find_lookup_domain_from_name(const char *domain_name);
BOOL winbindd_lookup_sid_by_name(TALLOC_CTX *mem_ctx,
				 struct winbindd_domain *domain, 
				 const char *domain_name,
				 const char *name, DOM_SID *sid, 
				 enum SID_NAME_USE *type);
BOOL winbindd_lookup_name_by_sid(TALLOC_CTX *mem_ctx,
				 DOM_SID *sid,
				 fstring dom_name,
				 fstring name,
				 enum SID_NAME_USE *type);
void free_getent_state(struct getent_state *state);
BOOL winbindd_param_init(void);
BOOL is_in_uid_range(uid_t uid);
BOOL is_in_gid_range(gid_t gid);
BOOL parse_domain_user(const char *domuser, fstring domain, fstring user);
BOOL parse_domain_user_talloc(TALLOC_CTX *mem_ctx, const char *domuser,
			      char **domain, char **user);
void fill_domain_username(fstring name, const char *domain, const char *user);
char *get_winbind_priv_pipe_dir(void) ;
int open_winbindd_socket(void);
int open_winbindd_priv_socket(void);
void close_winbindd_socket(void);
struct winbindd_cli_state *winbindd_client_list(void);
void winbindd_add_client(struct winbindd_cli_state *cli);
void winbindd_remove_client(struct winbindd_cli_state *cli);
void winbindd_demote_client(struct winbindd_cli_state *cli);
void winbindd_kill_all_clients(void);
int winbindd_num_clients(void);
BOOL winbindd_upgrade_idmap(void);

/* The following definitions come from nsswitch/winbindd_wins.c  */

void winbindd_wins_byip(struct winbindd_cli_state *state);
void winbindd_wins_byname(struct winbindd_cli_state *state);

#endif /*  _WINBINDD_PROTO_H_  */
