#ifndef _PROTO_H_
#define _PROTO_H_

/* This file is automatically generated with "make proto". DO NOT EDIT */


/* The following definitions come from auth/auth.c  */

NTSTATUS smb_register_auth(int version, const char *name, auth_init_function init);
BOOL load_auth_module(struct auth_context *auth_context, 
		      const char *module, auth_methods **ret) ;
NTSTATUS make_auth_context_subsystem(struct auth_context **auth_context) ;
NTSTATUS make_auth_context_fixed(struct auth_context **auth_context, uchar chal[8]) ;

/* The following definitions come from auth/auth_builtin.c  */

NTSTATUS auth_builtin_init(void);

/* The following definitions come from auth/auth_compat.c  */

NTSTATUS check_plaintext_password(const char *smb_name, DATA_BLOB plaintext_password, auth_serversupplied_info **server_info);
BOOL password_ok(char *smb_name, DATA_BLOB password_blob);

/* The following definitions come from auth/auth_domain.c  */

NTSTATUS auth_domain_init(void) ;

/* The following definitions come from auth/auth_ntlmssp.c  */

NTSTATUS auth_ntlmssp_start(AUTH_NTLMSSP_STATE **auth_ntlmssp_state);
void auth_ntlmssp_end(AUTH_NTLMSSP_STATE **auth_ntlmssp_state);
NTSTATUS auth_ntlmssp_update(AUTH_NTLMSSP_STATE *auth_ntlmssp_state, 
			     const DATA_BLOB request, DATA_BLOB *reply) ;

/* The following definitions come from auth/auth_rhosts.c  */

NTSTATUS auth_rhosts_init(void);

/* The following definitions come from auth/auth_sam.c  */

NTSTATUS auth_sam_init(void);

/* The following definitions come from auth/auth_server.c  */

NTSTATUS auth_server_init(void);

/* The following definitions come from auth/auth_unix.c  */

NTSTATUS auth_unix_init(void);

/* The following definitions come from auth/auth_util.c  */

NTSTATUS auth_get_sam_account(const char *user, SAM_ACCOUNT **account) ;
NTSTATUS make_user_info_map(auth_usersupplied_info **user_info, 
			    const char *smb_name, 
			    const char *client_domain, 
			    const char *wksta_name, 
 			    DATA_BLOB *lm_pwd, DATA_BLOB *nt_pwd,
 			    DATA_BLOB *lm_interactive_pwd, DATA_BLOB *nt_interactive_pwd,
			    DATA_BLOB *plaintext, 
			    BOOL encrypted);
BOOL make_user_info_netlogon_network(auth_usersupplied_info **user_info, 
				     const char *smb_name, 
				     const char *client_domain, 
				     const char *wksta_name, 
				     const uchar *lm_network_pwd, int lm_pwd_len,
				     const uchar *nt_network_pwd, int nt_pwd_len);
BOOL make_user_info_netlogon_interactive(auth_usersupplied_info **user_info, 
					 const char *smb_name, 
					 const char *client_domain, 
					 const char *wksta_name, 
					 const uchar chal[8], 
					 const uchar lm_interactive_pwd[16], 
					 const uchar nt_interactive_pwd[16], 
					 const uchar *dc_sess_key);
BOOL make_user_info_for_reply(auth_usersupplied_info **user_info, 
			      const char *smb_name, 
			      const char *client_domain,
			      const uint8 chal[8],
			      DATA_BLOB plaintext_password);
NTSTATUS make_user_info_for_reply_enc(auth_usersupplied_info **user_info, 
                                      const char *smb_name,
                                      const char *client_domain, 
                                      DATA_BLOB lm_resp, DATA_BLOB nt_resp);
BOOL make_user_info_guest(auth_usersupplied_info **user_info) ;
void debug_nt_user_token(int dbg_class, int dbg_lev, NT_USER_TOKEN *token);
void debug_unix_user_token(int dbg_class, int dbg_lev, uid_t uid, gid_t gid, int n_groups, gid_t *groups);
NT_USER_TOKEN *create_nt_token(uid_t uid, gid_t gid, int ngroups, gid_t *groups, BOOL is_guest);
NTSTATUS make_server_info_sam(auth_serversupplied_info **server_info, 
			      SAM_ACCOUNT *sampass);
NTSTATUS make_server_info_pw(auth_serversupplied_info **server_info, 
                             char *unix_username,
			     struct passwd *pwd);
BOOL init_guest_info(void);
NTSTATUS make_server_info_guest(auth_serversupplied_info **server_info);
struct passwd *smb_getpwnam( char *domuser, fstring save_username, BOOL create );
NTSTATUS make_server_info_info3(TALLOC_CTX *mem_ctx, 
				const char *internal_username,
				const char *sent_nt_username,
				const char *domain,
				auth_serversupplied_info **server_info, 
				NET_USER_INFO_3 *info3) ;
void free_user_info(auth_usersupplied_info **user_info);
void free_server_info(auth_serversupplied_info **server_info);
BOOL make_auth_methods(struct auth_context *auth_context, auth_methods **auth_method) ;
void delete_nt_token(NT_USER_TOKEN **pptoken);
NT_USER_TOKEN *dup_nt_token(NT_USER_TOKEN *ptoken);
BOOL nt_token_check_sid ( DOM_SID *sid, NT_USER_TOKEN *token );
BOOL nt_token_check_domain_rid( NT_USER_TOKEN *token, uint32 rid ) ;
BOOL is_trusted_domain(const char* dom_name);

/* The following definitions come from auth/auth_winbind.c  */

NTSTATUS auth_winbind_init(void);

/* The following definitions come from auth/pampass.c  */

BOOL smb_pam_claim_session(char *user, char *tty, char *rhost);
BOOL smb_pam_close_session(char *user, char *tty, char *rhost);
NTSTATUS smb_pam_accountcheck(const char * user);
NTSTATUS smb_pam_passcheck(const char * user, const char * password);
BOOL smb_pam_passchange(const char * user, const char * oldpassword, const char * newpassword);
NTSTATUS smb_pam_accountcheck(const char * user);
BOOL smb_pam_claim_session(char *user, char *tty, char *rhost);
BOOL smb_pam_close_session(char *in_user, char *tty, char *rhost);

/* The following definitions come from auth/pass_check.c  */

void dfs_unlogin(void);
NTSTATUS pass_check(const struct passwd *pass, const char *user, const char *password, 
		    int pwlen, BOOL (*fn) (const char *, const char *), BOOL run_cracker);

/* The following definitions come from dynconfig.c  */


/* The following definitions come from groupdb/mapping.c  */

char *decode_sid_name_use(fstring group, enum SID_NAME_USE name_use);
BOOL add_initial_entry(gid_t gid, const char *sid, enum SID_NAME_USE sid_name_use, const char *nt_name, const char *comment);
BOOL get_domain_group_from_sid(DOM_SID sid, GROUP_MAP *map);
BOOL get_local_group_from_sid(DOM_SID *sid, GROUP_MAP *map);
BOOL get_builtin_group_from_sid(DOM_SID *sid, GROUP_MAP *map);
BOOL get_group_from_gid(gid_t gid, GROUP_MAP *map);
int smb_create_group(char *unix_group, gid_t *new_gid);
int smb_delete_group(char *unix_group);
int smb_set_primary_group(const char *unix_group, const char* unix_user);
int smb_add_user_group(char *unix_group, char *unix_user);
int smb_delete_user_group(const char *unix_group, const char *unix_user);
NTSTATUS pdb_default_getgrsid(struct pdb_methods *methods, GROUP_MAP *map,
				 DOM_SID sid);
NTSTATUS pdb_default_getgrgid(struct pdb_methods *methods, GROUP_MAP *map,
				 gid_t gid);
NTSTATUS pdb_default_getgrnam(struct pdb_methods *methods, GROUP_MAP *map,
				 const char *name);
NTSTATUS pdb_default_add_group_mapping_entry(struct pdb_methods *methods,
						GROUP_MAP *map);
NTSTATUS pdb_default_update_group_mapping_entry(struct pdb_methods *methods,
						   GROUP_MAP *map);
NTSTATUS pdb_default_delete_group_mapping_entry(struct pdb_methods *methods,
						   DOM_SID sid);
NTSTATUS pdb_default_enum_group_mapping(struct pdb_methods *methods,
					   enum SID_NAME_USE sid_name_use,
					   GROUP_MAP **rmap, int *num_entries,
					   BOOL unix_only);
NTSTATUS pdb_default_find_alias(struct pdb_methods *methods,
				const char *name, DOM_SID *sid);
NTSTATUS pdb_default_create_alias(struct pdb_methods *methods,
				  const char *name, uint32 *rid);
NTSTATUS pdb_default_delete_alias(struct pdb_methods *methods,
				  const DOM_SID *sid);
NTSTATUS pdb_default_get_aliasinfo(struct pdb_methods *methods,
				   const DOM_SID *sid,
				   struct acct_info *info);
NTSTATUS pdb_default_set_aliasinfo(struct pdb_methods *methods,
				   const DOM_SID *sid,
				   struct acct_info *info);
NTSTATUS pdb_default_add_aliasmem(struct pdb_methods *methods,
				  const DOM_SID *alias, const DOM_SID *member);
NTSTATUS pdb_default_del_aliasmem(struct pdb_methods *methods,
				  const DOM_SID *alias, const DOM_SID *member);
NTSTATUS pdb_default_enum_aliasmem(struct pdb_methods *methods,
				   const DOM_SID *alias, DOM_SID **members,
				   int *num_members);
NTSTATUS pdb_default_alias_memberships(struct pdb_methods *methods,
				       TALLOC_CTX *mem_ctx,
				       const DOM_SID *domain_sid,
				       const DOM_SID *members,
				       int num_members,
				       uint32 **alias_rids,
				       int *num_alias_rids);
NTSTATUS pdb_nop_getgrsid(struct pdb_methods *methods, GROUP_MAP *map,
				 DOM_SID sid);
NTSTATUS pdb_nop_getgrgid(struct pdb_methods *methods, GROUP_MAP *map,
				 gid_t gid);
NTSTATUS pdb_nop_getgrnam(struct pdb_methods *methods, GROUP_MAP *map,
				 const char *name);
NTSTATUS pdb_nop_add_group_mapping_entry(struct pdb_methods *methods,
						GROUP_MAP *map);
NTSTATUS pdb_nop_update_group_mapping_entry(struct pdb_methods *methods,
						   GROUP_MAP *map);
NTSTATUS pdb_nop_delete_group_mapping_entry(struct pdb_methods *methods,
						   DOM_SID sid);
NTSTATUS pdb_nop_enum_group_mapping(struct pdb_methods *methods,
					   enum SID_NAME_USE sid_name_use,
					   GROUP_MAP **rmap, int *num_entries,
					   BOOL unix_only);

/* The following definitions come from intl/lang_tdb.c  */

BOOL lang_tdb_init(const char *lang);
const char *lang_msg(const char *msgid);
void lang_msg_free(const char *msgstr);
const char *lang_msg_rotate(const char *msgid);
char *lang_tdb_current(void);

/* The following definitions come from lib/access.c  */

BOOL allow_access(const char **deny_list, const char **allow_list,
		  const char *cname, const char *caddr);
BOOL check_access(int sock, const char **allow_list, const char **deny_list);

/* The following definitions come from lib/account_pol.c  */

BOOL init_account_policy(void);
char *account_policy_names_list(void);
int account_policy_name_to_fieldnum(const char *name);
BOOL account_policy_get(int field, uint32 *value);
BOOL account_policy_set(int field, uint32 value);
TDB_CONTEXT *get_account_pol_tdb( void );

/* The following definitions come from lib/adt_tree.c  */


/* The following definitions come from lib/afs.c  */

char *afs_createtoken_str(const char *username, const char *cell);
BOOL afs_login(connection_struct *conn);
BOOL afs_login(connection_struct *conn);
char *afs_createtoken_str(const char *username, const char *cell);

/* The following definitions come from lib/afs_settoken.c  */

int afs_syscall( int subcall,
	  char * path,
	  int cmd,
	  char * cmarg,
	  int follow);
BOOL afs_settoken_str(const char *token_string);
BOOL afs_settoken_str(const char *token_string);

/* The following definitions come from lib/bitmap.c  */

struct bitmap *bitmap_allocate(int n);
void bitmap_free(struct bitmap *bm);
struct bitmap *bitmap_talloc(TALLOC_CTX *mem_ctx, int n);
int bitmap_copy(struct bitmap * const dst, const struct bitmap * const src);
BOOL bitmap_set(struct bitmap *bm, unsigned i);
BOOL bitmap_clear(struct bitmap *bm, unsigned i);
BOOL bitmap_query(struct bitmap *bm, unsigned i);
int bitmap_find(struct bitmap *bm, unsigned ofs);

/* The following definitions come from lib/charcnv.c  */

char lp_failed_convert_char(void);
void lazy_initialize_conv(void);
void init_iconv(void);
size_t convert_string(charset_t from, charset_t to,
		      void const *src, size_t srclen, 
		      void *dest, size_t destlen, BOOL allow_bad_conv);
size_t convert_string_allocate(TALLOC_CTX *ctx, charset_t from, charset_t to,
			       void const *src, size_t srclen, void **dest, BOOL allow_bad_conv);
size_t unix_strupper(const char *src, size_t srclen, char *dest, size_t destlen);
char *strdup_upper(const char *s);
size_t unix_strlower(const char *src, size_t srclen, char *dest, size_t destlen);
char *strdup_lower(const char *s);
size_t push_ascii(void *dest, const char *src, size_t dest_len, int flags);
size_t push_ascii_fstring(void *dest, const char *src);
size_t push_ascii_pstring(void *dest, const char *src);
size_t push_ascii_nstring(void *dest, const char *src);
size_t pull_ascii(char *dest, const void *src, size_t dest_len, size_t src_len, int flags);
size_t pull_ascii_pstring(char *dest, const void *src);
size_t pull_ascii_fstring(char *dest, const void *src);
size_t pull_ascii_nstring(char *dest, size_t dest_len, const void *src);
size_t push_ucs2(const void *base_ptr, void *dest, const char *src, size_t dest_len, int flags);
size_t push_ucs2_talloc(TALLOC_CTX *ctx, smb_ucs2_t **dest, const char *src);
size_t push_ucs2_allocate(smb_ucs2_t **dest, const char *src);
size_t push_utf8_fstring(void *dest, const char *src);
size_t push_utf8_talloc(TALLOC_CTX *ctx, char **dest, const char *src);
size_t push_utf8_allocate(char **dest, const char *src);
size_t pull_ucs2(const void *base_ptr, char *dest, const void *src, size_t dest_len, size_t src_len, int flags);
size_t pull_ucs2_pstring(char *dest, const void *src);
size_t pull_ucs2_fstring(char *dest, const void *src);
size_t pull_ucs2_talloc(TALLOC_CTX *ctx, char **dest, const smb_ucs2_t *src);
size_t pull_ucs2_allocate(char **dest, const smb_ucs2_t *src);
size_t pull_utf8_talloc(TALLOC_CTX *ctx, char **dest, const char *src);
size_t pull_utf8_allocate(char **dest, const char *src);
size_t pull_ascii_talloc(TALLOC_CTX *ctx, char **dest, const char *src);
size_t push_string_fn(const char *function, unsigned int line, const void *base_ptr, void *dest, const char *src, size_t dest_len, int flags);
size_t pull_string_fn(const char *function, unsigned int line, const void *base_ptr, char *dest, const void *src, size_t dest_len, size_t src_len, int flags);
size_t align_string(const void *base_ptr, const char *p, int flags);
size_t next_mb_char_size(const char *s);

/* The following definitions come from lib/clobber.c  */

void clobber_region(const char *fn, unsigned int line, char *dest, size_t len);

/* The following definitions come from lib/crc32.c  */

uint32 crc32_calc_buffer( const char *buffer, uint32 count);

/* The following definitions come from lib/data_blob.c  */

DATA_BLOB data_blob(const void *p, size_t length);
DATA_BLOB data_blob_talloc(TALLOC_CTX *mem_ctx, const void *p, size_t length);
void data_blob_free(DATA_BLOB *d);
void data_blob_clear_free(DATA_BLOB *d);

/* The following definitions come from lib/debug.c  */

const char *debug_classname_from_index(int ndx);
int debug_add_class(const char *classname);
int debug_lookup_classname(const char *classname);
BOOL debug_parse_levels(const char *params_str);
void debug_message_send(pid_t pid, const char *params_str);
void debug_init(void);
void setup_logging(const char *pname, BOOL interactive);
BOOL reopen_logs( void );
void force_check_log_size( void );
BOOL need_to_check_log_size( void );
void check_log_size( void );
void dbgflush( void );
BOOL dbghdr( int level, const char *file, const char *func, int line );

/* The following definitions come from lib/dmallocmsg.c  */

void register_dmalloc_msgs(void);

/* The following definitions come from lib/dprintf.c  */

void display_set_stderr(void);

/* The following definitions come from lib/fault.c  */

void fault_setup(void (*fn)(void *));

/* The following definitions come from lib/fsusage.c  */

int sys_fsusage(const char *path, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);

/* The following definitions come from lib/gencache.c  */

BOOL gencache_init(void);
BOOL gencache_shutdown(void);
BOOL gencache_set(const char *keystr, const char *value, time_t timeout);
BOOL gencache_set_only(const char *keystr, const char *valstr, time_t timeout);
BOOL gencache_del(const char *keystr);
BOOL gencache_get(const char *keystr, char **valstr, time_t *timeout);
void gencache_iterate(void (*fn)(const char* key, const char *value, time_t timeout, void* dptr),
                      void* data, const char* keystr_pattern);
int gencache_lock_entry( const char *key );
void gencache_unlock_entry( const char *key );

/* The following definitions come from lib/genrand.c  */

void set_rand_reseed_callback(void (*fn)(int *));
void set_need_random_reseed(void);
void generate_random_buffer( unsigned char *out, int len);
char *generate_random_str(size_t len);

/* The following definitions come from lib/getsmbpass.c  */

char *getsmbpass(const char *prompt);

/* The following definitions come from lib/hmacmd5.c  */

void hmac_md5_init_rfc2104(uchar*  key, int key_len, HMACMD5Context *ctx);
void hmac_md5_init_limK_to_64(const uchar* key, int key_len,
			HMACMD5Context *ctx);
void hmac_md5_update(const uchar* text, int text_len, HMACMD5Context *ctx);
void hmac_md5_final(uchar *digest, HMACMD5Context *ctx);
void hmac_md5( uchar key[16], uchar* data, int data_len, uchar* digest);

/* The following definitions come from lib/iconv.c  */

NTSTATUS smb_register_charset(struct charset_functions *funcs) ;
size_t smb_iconv(smb_iconv_t cd, 
		 const char **inbuf, size_t *inbytesleft,
		 char **outbuf, size_t *outbytesleft);
smb_iconv_t smb_iconv_open(const char *tocode, const char *fromcode);
int smb_iconv_close (smb_iconv_t cd);

/* The following definitions come from lib/interface.c  */

void load_interfaces(void);
BOOL interfaces_changed(void);
BOOL ismyip(struct in_addr ip);
BOOL is_local_net(struct in_addr from);
int iface_count(void);
struct interface *get_interface(int n);
struct in_addr *iface_n_ip(int n);
struct in_addr *iface_n_bcast(int n);
struct in_addr *iface_ip(struct in_addr ip);
BOOL iface_local(struct in_addr ip);

/* The following definitions come from lib/interfaces.c  */

int get_interfaces(struct iface_struct *ifaces, int max_interfaces);

/* The following definitions come from lib/ldap_escape.c  */

char *escape_ldap_string_alloc(const char *s);

/* The following definitions come from lib/md4.c  */

void mdfour(unsigned char *out, const unsigned char *in, int n);

/* The following definitions come from lib/md5.c  */

void MD5Init(struct MD5Context *ctx);
void MD5Update(struct MD5Context *ctx, unsigned char const *buf, unsigned len);
void MD5Final(unsigned char digest[16], struct MD5Context *ctx);

/* The following definitions come from lib/messages.c  */

BOOL message_init(void);
BOOL message_send_pid(pid_t pid, int msg_type, const void *buf, size_t len, BOOL duplicates_allowed);
BOOL message_send_pid_with_timeout(pid_t pid, int msg_type, const void *buf, size_t len,
		BOOL duplicates_allowed, unsigned int timeout);
unsigned int messages_pending_for_pid(pid_t pid);
void message_dispatch(void);
void message_register(int msg_type, 
		      void (*fn)(int msg_type, pid_t pid, void *buf, size_t len));
void message_deregister(int msg_type);
BOOL message_send_all(TDB_CONTEXT *conn_tdb, int msg_type,
		      const void *buf, size_t len,
		      BOOL duplicates_allowed,
		      int *n_sent);

/* The following definitions come from lib/module.c  */

NTSTATUS smb_load_module(const char *module_name);
int smb_load_modules(const char **modules);
NTSTATUS smb_probe_module(const char *subsystem, const char *module);
NTSTATUS smb_load_module(const char *module_name);
int smb_load_modules(const char **modules);
NTSTATUS smb_probe_module(const char *subsystem, const char *module);
void init_modules(void);
smb_event_id_t smb_register_idle_event(smb_idle_event_fn *fn, void *data, time_t interval);
BOOL smb_unregister_idle_event(smb_event_id_t id);
void smb_run_idle_events(time_t now);
smb_event_id_t smb_register_exit_event(smb_exit_event_fn *fn, void *data);
BOOL smb_unregister_exit_event(smb_event_id_t id);
void smb_run_exit_events(void);

/* The following definitions come from lib/ms_fnmatch.c  */

int ms_fnmatch(const char *pattern, const char *string, BOOL translate_pattern,
	       BOOL is_case_sensitive);
int gen_fnmatch(const char *pattern, const char *string);

/* The following definitions come from lib/pam_errors.c  */

NTSTATUS pam_to_nt_status(int pam_error);
int nt_status_to_pam(NTSTATUS nt_status);
NTSTATUS pam_to_nt_status(int pam_error);
int nt_status_to_pam(NTSTATUS nt_status);

/* The following definitions come from lib/pidfile.c  */

pid_t pidfile_pid(const char *name);
void pidfile_create(const char *name);

/* The following definitions come from lib/popt_common.c  */


/* The following definitions come from lib/privileges.c  */

BOOL se_priv_copy( SE_PRIV *dst, const SE_PRIV *src );
void se_priv_add( SE_PRIV *mask, const SE_PRIV *addpriv );
void se_priv_remove( SE_PRIV *mask, const SE_PRIV *removepriv );
BOOL se_priv_from_name( const char *name, SE_PRIV *mask );
void dump_se_priv( int dbg_cl, int dbg_lvl, const SE_PRIV *mask );
LUID_ATTR get_privilege_luid( SE_PRIV *mask );
const char* get_privilege_dispname( const char *name );
BOOL get_privileges_for_sids(SE_PRIV *privileges, DOM_SID *slist, int scount);
NTSTATUS privilege_enumerate_accounts(DOM_SID **sids, int *num_sids);
BOOL grant_privilege(const DOM_SID *sid, const SE_PRIV *priv_mask);
BOOL grant_privilege_by_name(DOM_SID *sid, const char *name);
BOOL revoke_privilege(const DOM_SID *sid, const SE_PRIV *priv_mask);
BOOL revoke_all_privileges( DOM_SID *sid );
BOOL revoke_privilege_by_name(DOM_SID *sid, const char *name);
NTSTATUS privilege_create_account(const DOM_SID *sid );
NTSTATUS privilege_set_init(PRIVILEGE_SET *priv_set);
NTSTATUS privilege_set_init_by_ctx(TALLOC_CTX *mem_ctx, PRIVILEGE_SET *priv_set);
void privilege_set_free(PRIVILEGE_SET *priv_set);
NTSTATUS dup_luid_attr(TALLOC_CTX *mem_ctx, LUID_ATTR **new_la, LUID_ATTR *old_la, int count);
BOOL user_has_privileges(NT_USER_TOKEN *token, const SE_PRIV *privilege);
BOOL user_has_any_privilege(NT_USER_TOKEN *token, const SE_PRIV *privilege);
char* luid_to_privilege_name(const LUID *set);
int count_all_privileges( void );
BOOL se_priv_to_privilege_set( PRIVILEGE_SET *set, SE_PRIV *mask );
BOOL privilege_set_to_se_priv( SE_PRIV *mask, PRIVILEGE_SET *privset );
BOOL is_privileged_sid( DOM_SID *sid );

/* The following definitions come from lib/readline.c  */

char *smb_readline(char *prompt, void (*callback)(void), 
		   char **(completion_fn)(const char *text, int start, int end));
const char *smb_readline_get_line_buffer(void);
void smb_readline_ca_char(char c);
int cmd_history(void);

/* The following definitions come from lib/replace.c  */

char *rep_inet_ntoa(struct in_addr ip);

/* The following definitions come from lib/replace1.c  */


/* The following definitions come from lib/secace.c  */

BOOL sec_ace_object(uint8 type);
void sec_ace_copy(SEC_ACE *ace_dest, SEC_ACE *ace_src);
void init_sec_ace(SEC_ACE *t, const DOM_SID *sid, uint8 type, SEC_ACCESS mask, uint8 flag);
NTSTATUS sec_ace_add_sid(TALLOC_CTX *ctx, SEC_ACE **pp_new, SEC_ACE *old, unsigned *num, DOM_SID *sid, uint32 mask);
NTSTATUS sec_ace_mod_sid(SEC_ACE *ace, size_t num, DOM_SID *sid, uint32 mask);
NTSTATUS sec_ace_del_sid(TALLOC_CTX *ctx, SEC_ACE **pp_new, SEC_ACE *old, uint32 *num, DOM_SID *sid);
BOOL sec_ace_equal(SEC_ACE *s1, SEC_ACE *s2);
int nt_ace_inherit_comp( SEC_ACE *a1, SEC_ACE *a2);
int nt_ace_canon_comp( SEC_ACE *a1, SEC_ACE *a2);
void dacl_sort_into_canonical_order(SEC_ACE *srclist, unsigned int num_aces);
BOOL token_sid_in_ace(const NT_USER_TOKEN *token, const SEC_ACE *ace);

/* The following definitions come from lib/secacl.c  */

SEC_ACL *make_sec_acl(TALLOC_CTX *ctx, uint16 revision, int num_aces, SEC_ACE *ace_list);
SEC_ACL *dup_sec_acl(TALLOC_CTX *ctx, SEC_ACL *src);
BOOL sec_acl_equal(SEC_ACL *s1, SEC_ACL *s2);

/* The following definitions come from lib/secdesc.c  */

size_t sec_desc_size(SEC_DESC *psd);
BOOL sec_desc_equal(SEC_DESC *s1, SEC_DESC *s2);
SEC_DESC_BUF *sec_desc_merge(TALLOC_CTX *ctx, SEC_DESC_BUF *new_sdb, SEC_DESC_BUF *old_sdb);
SEC_DESC *make_sec_desc(TALLOC_CTX *ctx, uint16 revision, uint16 type,
			const DOM_SID *owner_sid, const DOM_SID *grp_sid,
			SEC_ACL *sacl, SEC_ACL *dacl, size_t *sd_size);
SEC_DESC *dup_sec_desc(TALLOC_CTX *ctx, const SEC_DESC *src);
SEC_DESC *make_standard_sec_desc(TALLOC_CTX *ctx, const DOM_SID *owner_sid, const DOM_SID *grp_sid,
				 SEC_ACL *dacl, size_t *sd_size);
SEC_DESC_BUF *make_sec_desc_buf(TALLOC_CTX *ctx, size_t len, SEC_DESC *sec_desc);
SEC_DESC_BUF *dup_sec_desc_buf(TALLOC_CTX *ctx, SEC_DESC_BUF *src);
NTSTATUS sec_desc_add_sid(TALLOC_CTX *ctx, SEC_DESC **psd, DOM_SID *sid, uint32 mask, size_t *sd_size);
NTSTATUS sec_desc_mod_sid(SEC_DESC *sd, DOM_SID *sid, uint32 mask);
NTSTATUS sec_desc_del_sid(TALLOC_CTX *ctx, SEC_DESC **psd, DOM_SID *sid, size_t *sd_size);
SEC_DESC_BUF *se_create_child_secdesc(TALLOC_CTX *ctx, SEC_DESC *parent_ctr, 
				      BOOL child_container);
void init_sec_access(SEC_ACCESS *t, uint32 mask);

/* The following definitions come from lib/select.c  */

void sys_select_signal(char c);
int sys_select(int maxfd, fd_set *readfds, fd_set *writefds, fd_set *errorfds, struct timeval *tval);
int sys_select_intr(int maxfd, fd_set *readfds, fd_set *writefds, fd_set *errorfds, struct timeval *tval);

/* The following definitions come from lib/sendfile.c  */

ssize_t sys_sendfile(int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count);
ssize_t sys_sendfile(int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count);
ssize_t sys_sendfile(int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count);
ssize_t sys_sendfile(int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count);
ssize_t sys_sendfile(int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count);
ssize_t sys_sendfile(int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count);
ssize_t sys_sendfile(int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count);

/* The following definitions come from lib/server_mutex.c  */

BOOL grab_server_mutex(const char *name);
void release_server_mutex(void);

/* The following definitions come from lib/signal.c  */

void BlockSignals(BOOL block,int signum);
void (*CatchSignal(int signum,void (*handler)(int )))(int);
void CatchChild(void);
void CatchChildLeaveStatus(void);

/* The following definitions come from lib/smbldap.c  */

int smbldap_search(struct smbldap_state *ldap_state, 
		   const char *base, int scope, const char *filter, 
		   const char *attrs[], int attrsonly, 
		   LDAPMessage **res);
int smbldap_search_paged(struct smbldap_state *ldap_state, 
			 const char *base, int scope, const char *filter, 
			 const char **attrs, int attrsonly, int pagesize,
			 LDAPMessage **res, void **cookie);
int smbldap_modify(struct smbldap_state *ldap_state, const char *dn, LDAPMod *attrs[]);
int smbldap_add(struct smbldap_state *ldap_state, const char *dn, LDAPMod *attrs[]);
int smbldap_delete(struct smbldap_state *ldap_state, const char *dn);
int smbldap_extended_operation(struct smbldap_state *ldap_state, 
			       LDAP_CONST char *reqoid, struct berval *reqdata, 
			       LDAPControl **serverctrls, LDAPControl **clientctrls, 
			       char **retoidp, struct berval **retdatap);
int smbldap_search_suffix (struct smbldap_state *ldap_state, const char *filter, 
			   const char **search_attr, LDAPMessage ** result);
void smbldap_free_struct(struct smbldap_state **ldap_state) ;
NTSTATUS smbldap_init(TALLOC_CTX *mem_ctx, const char *location, struct smbldap_state **smbldap_state) ;
char *smbldap_get_dn(LDAP *ld, LDAPMessage *entry);
BOOL smbldap_has_control(struct smbldap_state *ldap_state, const char *control);
BOOL smbldap_has_extension(struct smbldap_state *ldap_state, const char *extension);
BOOL smbldap_has_naming_context(struct smbldap_state *ldap_state, const char *naming_context);

/* The following definitions come from lib/smbldap_util.c  */

NTSTATUS smbldap_search_domain_info(struct smbldap_state *ldap_state,
                                    LDAPMessage ** result, const char *domain_name,
                                    BOOL try_add);

/* The following definitions come from lib/smbrun.c  */

int smbrun(char *cmd, int *outfd);
int smbrunsecret(char *cmd, char *secret);

/* The following definitions come from lib/snprintf.c  */

int smb_snprintf(char *str,size_t count,const char *fmt,...);

/* The following definitions come from lib/sock_exec.c  */

int sock_exec(const char *prog);

/* The following definitions come from lib/substitute.c  */

void set_local_machine_name(const char* local_name, BOOL perm);
void set_remote_machine_name(const char* remote_name, BOOL perm);
const char* get_remote_machine_name(void) ;
const char* get_local_machine_name(void) ;
void sub_set_smb_name(const char *name);
char* sub_get_smb_name( void );
void set_current_user_info(const userdom_struct *pcui);
const char* get_current_username( void );
void standard_sub_basic(const char *smb_name, char *str,size_t len);
char *talloc_sub_basic(TALLOC_CTX *mem_ctx, const char *smb_name, const char *str);
char *alloc_sub_basic(const char *smb_name, const char *str);
char *talloc_sub_specified(TALLOC_CTX *mem_ctx,
			const char *input_string,
			const char *username,
			const char *domain,
			uid_t uid,
			gid_t gid);
char *alloc_sub_specified(const char *input_string,
			const char *username,
			const char *domain,
			uid_t uid,
			gid_t gid);
char *talloc_sub_advanced(TALLOC_CTX *mem_ctx,
			int snum,
			const char *user,
			const char *connectpath,
			gid_t gid,
			const char *smb_name,
			const char *str);
char *alloc_sub_advanced(int snum, const char *user, 
				  const char *connectpath, gid_t gid, 
				  const char *smb_name, const char *str);
void standard_sub_conn(connection_struct *conn, char *str, size_t len);
char *talloc_sub_conn(TALLOC_CTX *mem_ctx, connection_struct *conn, const char *str);
char *alloc_sub_conn(connection_struct *conn, const char *str);
void standard_sub_snum(int snum, char *str, size_t len);

/* The following definitions come from lib/sysacls.c  */

int sys_acl_get_entry( SMB_ACL_T the_acl, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_get_tag_type( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p);
int sys_acl_get_permset( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void *sys_acl_get_qualifier( SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T sys_acl_get_file( const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T sys_acl_get_fd(int fd);
int sys_acl_clear_perms(SMB_ACL_PERMSET_T permset);
int sys_acl_add_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
int sys_acl_get_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
char *sys_acl_to_text( SMB_ACL_T the_acl, ssize_t *plen);
SMB_ACL_T sys_acl_init( int count);
int sys_acl_create_entry( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry);
int sys_acl_set_tag_type( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype);
int sys_acl_set_qualifier( SMB_ACL_ENTRY_T entry, void *qual);
int sys_acl_set_permset( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset);
int sys_acl_valid( SMB_ACL_T theacl );
int sys_acl_set_file(const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl);
int sys_acl_set_fd( int fd, SMB_ACL_T theacl);
int sys_acl_delete_def_file(const char *name);
int sys_acl_free_text(char *text);
int sys_acl_free_acl(SMB_ACL_T the_acl) ;
int sys_acl_free_qualifier(void *qual, SMB_ACL_TAG_T tagtype);
int sys_acl_get_entry( SMB_ACL_T the_acl, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_get_tag_type( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p);
int sys_acl_get_permset( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void *sys_acl_get_qualifier( SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T sys_acl_get_file( const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T sys_acl_get_fd(int fd);
int sys_acl_clear_perms(SMB_ACL_PERMSET_T permset);
int sys_acl_add_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
int sys_acl_get_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
char *sys_acl_to_text( SMB_ACL_T the_acl, ssize_t *plen);
SMB_ACL_T sys_acl_init( int count);
int sys_acl_create_entry( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry);
int sys_acl_set_tag_type( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype);
int sys_acl_set_qualifier( SMB_ACL_ENTRY_T entry, void *qual);
int sys_acl_set_permset( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset);
int sys_acl_valid( SMB_ACL_T theacl );
int sys_acl_set_file( const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl);
int sys_acl_set_fd( int fd, SMB_ACL_T theacl);
int sys_acl_delete_def_file(const char *name);
int sys_acl_free_text(char *text);
int sys_acl_free_acl(SMB_ACL_T the_acl) ;
int sys_acl_free_qualifier(void *qual, SMB_ACL_TAG_T tagtype);
int sys_acl_get_entry(SMB_ACL_T acl_d, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_get_tag_type(SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *type_p);
int sys_acl_get_permset(SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void *sys_acl_get_qualifier(SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T sys_acl_get_file(const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T sys_acl_get_fd(int fd);
int sys_acl_clear_perms(SMB_ACL_PERMSET_T permset_d);
int sys_acl_add_perm(SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm);
int sys_acl_get_perm(SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm);
char *sys_acl_to_text(SMB_ACL_T acl_d, ssize_t *len_p);
SMB_ACL_T sys_acl_init(int count);
int sys_acl_create_entry(SMB_ACL_T *acl_p, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_set_tag_type(SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T tag_type);
int sys_acl_set_qualifier(SMB_ACL_ENTRY_T entry_d, void *qual_p);
int sys_acl_set_permset(SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T permset_d);
int sys_acl_valid(SMB_ACL_T acl_d);
int sys_acl_set_file(const char *name, SMB_ACL_TYPE_T type, SMB_ACL_T acl_d);
int sys_acl_set_fd(int fd, SMB_ACL_T acl_d);
int sys_acl_delete_def_file(const char *path);
int sys_acl_free_text(char *text);
int sys_acl_free_acl(SMB_ACL_T acl_d) ;
int sys_acl_free_qualifier(void *qual, SMB_ACL_TAG_T tagtype);
int sys_acl_get_entry(SMB_ACL_T acl_d, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_get_tag_type(SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *type_p);
int sys_acl_get_permset(SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void *sys_acl_get_qualifier(SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T sys_acl_get_file(const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T sys_acl_get_fd(int fd);
int sys_acl_clear_perms(SMB_ACL_PERMSET_T permset_d);
int sys_acl_add_perm(SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm);
int sys_acl_get_perm(SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm);
char *sys_acl_to_text(SMB_ACL_T acl_d, ssize_t *len_p);
SMB_ACL_T sys_acl_init(int count);
int sys_acl_create_entry(SMB_ACL_T *acl_p, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_set_tag_type(SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T tag_type);
int sys_acl_set_qualifier(SMB_ACL_ENTRY_T entry_d, void *qual_p);
int sys_acl_set_permset(SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T permset_d);
int sys_acl_valid(SMB_ACL_T acl_d);
int sys_acl_set_file(const char *name, SMB_ACL_TYPE_T type, SMB_ACL_T acl_d);
int sys_acl_set_fd(int fd, SMB_ACL_T acl_d);
int sys_acl_delete_def_file(const char *path);
int sys_acl_free_text(char *text);
int sys_acl_free_acl(SMB_ACL_T acl_d) ;
int sys_acl_free_qualifier(void *qual, SMB_ACL_TAG_T tagtype);
int sys_acl_get_entry(SMB_ACL_T acl_d, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_get_tag_type(SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *type_p);
int sys_acl_get_permset(SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void *sys_acl_get_qualifier(SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T sys_acl_get_file(const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T sys_acl_get_fd(int fd);
int sys_acl_clear_perms(SMB_ACL_PERMSET_T permset_d);
int sys_acl_add_perm(SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm);
int sys_acl_get_perm(SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm);
char *sys_acl_to_text(SMB_ACL_T acl_d, ssize_t *len_p);
SMB_ACL_T sys_acl_init(int count);
int sys_acl_create_entry(SMB_ACL_T *acl_p, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_set_tag_type(SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T tag_type);
int sys_acl_set_qualifier(SMB_ACL_ENTRY_T entry_d, void *qual_p);
int sys_acl_set_permset(SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T permset_d);
int sys_acl_valid(SMB_ACL_T acl_d);
int sys_acl_set_file(const char *name, SMB_ACL_TYPE_T type, SMB_ACL_T acl_d);
int sys_acl_set_fd(int fd, SMB_ACL_T acl_d);
int sys_acl_delete_def_file(const char *name);
int sys_acl_free_text(char *text);
int sys_acl_free_acl(SMB_ACL_T acl_d) ;
int sys_acl_free_qualifier(void *qual, SMB_ACL_TAG_T tagtype);
int sys_acl_get_entry( SMB_ACL_T theacl, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_get_tag_type( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p);
int sys_acl_get_permset( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void *sys_acl_get_qualifier( SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T sys_acl_get_file( const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T sys_acl_get_fd(int fd);
int sys_acl_clear_perms(SMB_ACL_PERMSET_T permset);
int sys_acl_add_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
char *sys_acl_to_text( SMB_ACL_T theacl, ssize_t *plen);
SMB_ACL_T sys_acl_init( int count);
int sys_acl_create_entry( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry);
int sys_acl_set_tag_type( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype);
int sys_acl_set_qualifier( SMB_ACL_ENTRY_T entry, void *qual);
int sys_acl_set_permset( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset);
int sys_acl_valid( SMB_ACL_T theacl );
int sys_acl_set_file( const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl);
int sys_acl_set_fd( int fd, SMB_ACL_T theacl);
int sys_acl_delete_def_file(const char *name);
int sys_acl_get_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
int sys_acl_free_text(char *text);
int sys_acl_free_acl(SMB_ACL_T posix_acl);
int sys_acl_free_qualifier(void *qual, SMB_ACL_TAG_T tagtype);
int sys_acl_get_entry( SMB_ACL_T the_acl, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int sys_acl_get_tag_type( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p);
int sys_acl_get_permset( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void *sys_acl_get_qualifier( SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T sys_acl_get_file( const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T sys_acl_get_fd(int fd);
int sys_acl_clear_perms(SMB_ACL_PERMSET_T permset);
int sys_acl_add_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
int sys_acl_get_perm( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
char *sys_acl_to_text( SMB_ACL_T the_acl, ssize_t *plen);
int sys_acl_free_text(char *text);
SMB_ACL_T sys_acl_init( int count);
int sys_acl_create_entry( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry);
int sys_acl_set_tag_type( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype);
int sys_acl_set_qualifier( SMB_ACL_ENTRY_T entry, void *qual);
int sys_acl_set_permset( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset);
int sys_acl_valid( SMB_ACL_T theacl );
int sys_acl_set_file( const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl);
int sys_acl_set_fd( int fd, SMB_ACL_T theacl);
int sys_acl_delete_def_file(const char *name);
int sys_acl_free_acl(SMB_ACL_T the_acl) ;
int sys_acl_free_qualifier(void *qual, SMB_ACL_TAG_T tagtype);
int no_acl_syscall_error(int err);

/* The following definitions come from lib/sysquotas.c  */

int sys_get_quota(const char *path, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);
int sys_set_quota(const char *path, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);

/* The following definitions come from lib/sysquotas_4A.c  */

int sys_get_vfs_quota(const char *path, const char *bdev, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);
int sys_set_vfs_quota(const char *path, const char *bdev, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);

/* The following definitions come from lib/sysquotas_linux.c  */

int sys_get_vfs_quota(const char *path, const char *bdev, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);
int sys_set_vfs_quota(const char *path, const char *bdev, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);

/* The following definitions come from lib/sysquotas_xfs.c  */

int sys_get_xfs_quota(const char *path, const char *bdev, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);
int sys_set_xfs_quota(const char *path, const char *bdev, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *dp);

/* The following definitions come from lib/system.c  */

int sys_usleep(long usecs);
ssize_t sys_read(int fd, void *buf, size_t count);
ssize_t sys_write(int fd, const void *buf, size_t count);
ssize_t sys_pread(int fd, void *buf, size_t count, SMB_OFF_T off);
ssize_t sys_pwrite(int fd, const void *buf, size_t count, SMB_OFF_T off);
ssize_t sys_send(int s, const void *msg, size_t len, int flags);
ssize_t sys_sendto(int s,  const void *msg, size_t len, int flags, const struct sockaddr *to, socklen_t tolen);
ssize_t sys_recvfrom(int s, void *buf, size_t len, int flags, struct sockaddr *from, socklen_t *fromlen);
int sys_fcntl_ptr(int fd, int cmd, void *arg);
int sys_fcntl_long(int fd, int cmd, long arg);
int sys_stat(const char *fname,SMB_STRUCT_STAT *sbuf);
int sys_fstat(int fd,SMB_STRUCT_STAT *sbuf);
int sys_lstat(const char *fname,SMB_STRUCT_STAT *sbuf);
int sys_ftruncate(int fd, SMB_OFF_T offset);
SMB_OFF_T sys_lseek(int fd, SMB_OFF_T offset, int whence);
int sys_fseek(FILE *fp, SMB_OFF_T offset, int whence);
SMB_OFF_T sys_ftell(FILE *fp);
int sys_creat(const char *path, mode_t mode);
int sys_open(const char *path, int oflag, mode_t mode);
FILE *sys_fopen(const char *path, const char *type);
SMB_STRUCT_DIR *sys_opendir(const char *name);
SMB_STRUCT_DIRENT *sys_readdir(SMB_STRUCT_DIR *dirp);
void sys_seekdir(SMB_STRUCT_DIR *dirp, long offset);
long sys_telldir(SMB_STRUCT_DIR *dirp);
void sys_rewinddir(SMB_STRUCT_DIR *dirp);
int sys_closedir(SMB_STRUCT_DIR *dirp);
int sys_mknod(const char *path, mode_t mode, SMB_DEV_T dev);
char *sys_realpath(const char *path, char *resolved_path);
int sys_waitpid(pid_t pid,int *status,int options);
char *sys_getwd(char *s);
int sys_symlink(const char *oldpath, const char *newpath);
int sys_readlink(const char *path, char *buf, size_t bufsiz);
int sys_link(const char *oldpath, const char *newpath);
int sys_chown(const char *fname,uid_t uid,gid_t gid);
int sys_chroot(const char *dname);
struct hostent *sys_gethostbyname(const char *name);
void oplock_set_capability(BOOL this_process, BOOL inherit);
long sys_random(void);
void sys_srandom(unsigned int seed);
int groups_max(void);
int sys_getgroups(int setlen, gid_t *gidset);
int sys_setgroups(int setlen, gid_t *gidset);
void sys_setpwent(void);
struct passwd *sys_getpwent(void);
void sys_endpwent(void);
struct passwd *sys_getpwnam(const char *name);
struct passwd *sys_getpwuid(uid_t uid);
struct group *sys_getgrnam(const char *name);
struct group *sys_getgrgid(gid_t gid);
int wsys_stat(const smb_ucs2_t *wfname,SMB_STRUCT_STAT *sbuf);
int wsys_lstat(const smb_ucs2_t *wfname,SMB_STRUCT_STAT *sbuf);
int wsys_creat(const smb_ucs2_t *wfname, mode_t mode);
int wsys_open(const smb_ucs2_t *wfname, int oflag, mode_t mode);
FILE *wsys_fopen(const smb_ucs2_t *wfname, const char *type);
SMB_STRUCT_DIR *wsys_opendir(const smb_ucs2_t *wfname);
SMB_STRUCT_WDIRENT *wsys_readdir(SMB_STRUCT_DIR *dirp);
smb_ucs2_t *wsys_getwd(smb_ucs2_t *s);
int wsys_chown(const smb_ucs2_t *wfname, uid_t uid, gid_t gid);
int wsys_chroot(const smb_ucs2_t *wfname);
pid_t sys_fork(void);
pid_t sys_getpid(void);
int sys_popen(const char *command);
int sys_pclose(int fd);
void *sys_dlopen(const char *name, int flags);
void *sys_dlsym(void *handle, const char *symbol);
int sys_dlclose (void *handle);
const char *sys_dlerror(void);
int sys_dup2(int oldfd, int newfd) ;
ssize_t sys_getxattr (const char *path, const char *name, void *value, size_t size);
ssize_t sys_lgetxattr (const char *path, const char *name, void *value, size_t size);
ssize_t sys_fgetxattr (int filedes, const char *name, void *value, size_t size);
ssize_t sys_listxattr (const char *path, char *list, size_t size);
ssize_t sys_llistxattr (const char *path, char *list, size_t size);
ssize_t sys_flistxattr (int filedes, char *list, size_t size);
int sys_removexattr (const char *path, const char *name);
int sys_lremovexattr (const char *path, const char *name);
int sys_fremovexattr (int filedes, const char *name);
int sys_setxattr (const char *path, const char *name, const void *value, size_t size, int flags);
int sys_lsetxattr (const char *path, const char *name, const void *value, size_t size, int flags);
int sys_fsetxattr (int filedes, const char *name, const void *value, size_t size, int flags);
uint32 unix_dev_major(SMB_DEV_T dev);
uint32 unix_dev_minor(SMB_DEV_T dev);
int sys_aio_read(SMB_STRUCT_AIOCB *aiocb);
int sys_aio_write(SMB_STRUCT_AIOCB *aiocb);
ssize_t sys_aio_return(SMB_STRUCT_AIOCB *aiocb);
int sys_aio_cancel(int fd, SMB_STRUCT_AIOCB *aiocb);
int sys_aio_error(const SMB_STRUCT_AIOCB *aiocb);
int sys_aio_fsync(int op, SMB_STRUCT_AIOCB *aiocb);
int sys_aio_suspend(const SMB_STRUCT_AIOCB * const cblist[], int n, const struct timespec *timeout);
int sys_aio_read(SMB_STRUCT_AIOCB *aiocb);
int sys_aio_write(SMB_STRUCT_AIOCB *aiocb);
ssize_t sys_aio_return(SMB_STRUCT_AIOCB *aiocb);
int sys_aio_cancel(int fd, SMB_STRUCT_AIOCB *aiocb);
int sys_aio_error(const SMB_STRUCT_AIOCB *aiocb);
int sys_aio_fsync(int op, SMB_STRUCT_AIOCB *aiocb);
int sys_aio_suspend(const SMB_STRUCT_AIOCB * const cblist[], int n, const struct timespec *timeout);

/* The following definitions come from lib/system_smbd.c  */

BOOL getgroups_user(const char *user, gid_t primary_gid,
		    gid_t **ret_groups, int *ngroups);
NTSTATUS pdb_default_enum_group_memberships(struct pdb_methods *methods,
					    const char *username,
					    gid_t primary_gid,
					    DOM_SID **sids,
					    gid_t **gids,
					    int *num_groups);

/* The following definitions come from lib/talloc.c  */

void *talloc_parent(const void *ptr);
void *_talloc(const void *context, size_t size);
void talloc_set_destructor(const void *ptr, int (*destructor)(void *));
void talloc_increase_ref_count(const void *ptr);
void *talloc_reference(const void *context, const void *ptr);
int talloc_unlink(const void *context, void *ptr);
void talloc_set_name(const void *ptr, const char *fmt, ...);
void talloc_set_name_const(const void *ptr, const char *name);
void *talloc_named(const void *context, size_t size, const char *fmt, ...);
void *talloc_named_const(const void *context, size_t size, const char *name);
const char *talloc_get_name(const void *ptr);
void *talloc_check_name(const void *ptr, const char *name);
void *talloc_init(const char *fmt, ...);
void talloc_free_children(void *ptr);
int talloc_free(void *ptr);
void *_talloc_realloc(const void *context, void *ptr, size_t size, const char *name);
void *talloc_steal(const void *new_ctx, const void *ptr);
off_t talloc_total_size(const void *ptr);
off_t talloc_total_blocks(const void *ptr);
void talloc_report_depth(const void *ptr, FILE *f, int depth);
void talloc_report_full(const void *ptr, FILE *f);
void talloc_report(const void *ptr, FILE *f);
void talloc_enable_null_tracking(void);
void talloc_enable_leak_report(void);
void talloc_enable_leak_report_full(void);
void *_talloc_zero(const void *ctx, size_t size, const char *name);
void *_talloc_memdup(const void *t, const void *p, size_t size, const char *name);
char *talloc_strdup(const void *t, const char *p);
char *talloc_strndup(const void *t, const char *p, size_t n);
char *talloc_vasprintf(const void *t, const char *fmt, va_list ap);
char *talloc_asprintf(const void *t, const char *fmt, ...);
char *talloc_asprintf_append(char *s, const char *fmt, ...);
void *_talloc_array(const void *ctx, size_t el_size, unsigned count, const char *name);
void *_talloc_zero_array(const void *ctx, size_t el_size, unsigned count, const char *name);
void *_talloc_realloc_array(const void *ctx, void *ptr, size_t el_size, unsigned count, const char *name);
void *talloc_realloc_fn(const void *context, void *ptr, size_t size);
void *talloc_autofree_context(void);
size_t talloc_get_size(const void *context);

/* The following definitions come from lib/tallocmsg.c  */

void msg_pool_usage(int msg_type, pid_t src_pid,
		    void *UNUSED(buf), size_t UNUSED(len));
void register_msg_pool_usage(void);

/* The following definitions come from lib/time.c  */

void get_nttime_max(NTTIME *t);
time_t get_time_t_max(void);
void GetTimeOfDay(struct timeval *tval);
void TimeInit(void);
void get_process_uptime(struct timeval *ret_time);
int TimeDiff(time_t t);
struct tm *LocalTime(time_t *t);
time_t nt_time_to_unix(NTTIME *nt);
time_t nt_time_to_unix_abs(NTTIME *nt);
time_t interpret_long_date(char *p);
void unix_to_nt_time(NTTIME *nt, time_t t);
void unix_to_nt_time_abs(NTTIME *nt, time_t t);
void put_long_date(char *p,time_t t);
BOOL null_mtime(time_t mtime);
void put_dos_date(char *buf,int offset,time_t unixdate);
void put_dos_date2(char *buf,int offset,time_t unixdate);
void put_dos_date3(char *buf,int offset,time_t unixdate);
time_t make_unix_date(void *date_ptr);
time_t make_unix_date2(void *date_ptr);
time_t make_unix_date3(void *date_ptr);
char *http_timestring(time_t t);
char *timestring(BOOL hires);
time_t get_create_time(SMB_STRUCT_STAT *st,BOOL fake_dirs);
void init_nt_time(NTTIME *nt);
BOOL nt_time_is_zero(NTTIME *nt);
SMB_BIG_INT usec_time_diff(const struct timeval *larget, const struct timeval *smallt);
time_t generalized_to_unix_time(const char *str);

/* The following definitions come from lib/ufc.c  */

char *ufc_crypt(const char *key,const char *salt);

/* The following definitions come from lib/username.c  */

BOOL split_domain_and_name(const char *name, char *domain, char* username);
char *get_user_home_dir(const char *user);
BOOL map_username(fstring user);
struct passwd *Get_Pwnam_alloc(const char *user);
struct passwd *Get_Pwnam(const char *user);
BOOL user_in_unix_group_list(const char *user,const char *gname);
BOOL user_in_group_list(const char *user, const char *gname, gid_t *groups, size_t n_groups);
BOOL user_in_list(const char *user,const char **list, gid_t *groups, size_t n_groups);

/* The following definitions come from lib/util.c  */

BOOL set_global_myname(const char *myname);
const char *global_myname(void);
BOOL set_global_myworkgroup(const char *myworkgroup);
const char *lp_workgroup(void);
BOOL set_global_scope(const char *scope);
const char *global_scope(void);
const char *my_netbios_names(int i);
BOOL set_netbios_aliases(const char **str_array);
BOOL init_names(void);
const char *tmpdir(void);
void add_gid_to_array_unique(TALLOC_CTX *mem_ctx, gid_t gid,
			     gid_t **gids, int *num);
const char *get_numlist(const char *p, uint32 **num, int *count);
BOOL file_exist(const char *fname,SMB_STRUCT_STAT *sbuf);
time_t file_modtime(const char *fname);
BOOL directory_exist(char *dname,SMB_STRUCT_STAT *st);
SMB_OFF_T get_file_size(char *file_name);
char *attrib_string(uint16 mode);
void show_msg(char *buf);
void smb_setlen(char *buf,int len);
int set_message(char *buf,int num_words,int num_bytes,BOOL zero);
int set_message_bcc(char *buf,int num_bytes);
int set_message_end(void *outbuf,void *end_ptr);
void dos_clean_name(char *s);
void unix_clean_name(char *s);
void close_low_fds(BOOL stderr_too);
ssize_t write_data_at_offset(int fd, const char *buffer, size_t N, SMB_OFF_T pos);
int set_blocking(int fd, BOOL set);
ssize_t transfer_file_internal(int infd, int outfd, size_t n, ssize_t (*read_fn)(int, void *, size_t),
						ssize_t (*write_fn)(int, const void *, size_t));
SMB_OFF_T transfer_file(int infd,int outfd,SMB_OFF_T n);
void smb_msleep(unsigned int t);
void become_daemon(BOOL Fork);
BOOL yesno(char *p);
void *malloc_(size_t size);
void *malloc_array(size_t el_size, unsigned int count);
void *calloc_array(size_t size, size_t nmemb);
void *Realloc(void *p,size_t size);
void *realloc_array(void *p,size_t el_size, unsigned int count);
void add_to_large_array(TALLOC_CTX *mem_ctx, size_t element_size,
			void *element, void **array, uint32 *num_elements,
			ssize_t *array_size);
void safe_free(void *p);
BOOL get_myname(char *my_name);
BOOL get_mydnsfullname(fstring my_dnsname);
BOOL get_mydnsdomname(fstring my_domname);
int interpret_protocol(const char *str,int def);
BOOL is_ipaddress(const char *str);
uint32 interpret_addr(const char *str);
struct in_addr *interpret_addr2(const char *str);
BOOL is_zero_ip(struct in_addr ip);
void zero_ip(struct in_addr *ip);
char *automount_lookup( char *user_name);
char *automount_lookup( char *user_name);
BOOL same_net(struct in_addr ip1,struct in_addr ip2,struct in_addr mask);
BOOL process_exists(pid_t pid);
const char *uidtoname(uid_t uid);
char *gidtoname(gid_t gid);
uid_t nametouid(const char *name);
gid_t nametogid(const char *name);
void smb_panic( const char *why );
void smb_panic2(const char *why, BOOL decrement_pid_count );
const char *readdirname(SMB_STRUCT_DIR *p);
BOOL is_in_path(const char *name, name_compare_entry *namelist, BOOL case_sensitive);
void set_namearray(name_compare_entry **ppname_array, char *namelist);
void free_namearray(name_compare_entry *name_array);
BOOL fcntl_lock(int fd, int op, SMB_OFF_T offset, SMB_OFF_T count, int type);
BOOL is_myname(const char *s);
BOOL is_myname_or_ipaddr(const char *s);
BOOL is_myworkgroup(const char *s);
void ra_lanman_string( const char *native_lanman );
void set_remote_arch(enum remote_arch_types type);
enum remote_arch_types get_remote_arch(void);
void print_asc(int level, const unsigned char *buf,int len);
void dump_data(int level, const char *buf1,int len);
void dump_data_pw(const char *msg, const uchar * data, size_t len);
char *tab_depth(int depth);
int str_checksum(const char *s);
void zero_free(void *p, size_t size);
int set_maxfiles(int requested_max);
int smb_mkstemp(char *name_template);
void *smb_xmalloc_array(size_t size, unsigned int count);
void *smb_xmemdup(const void *p, size_t size);
char *smb_xstrdup(const char *s);
char *smb_xstrndup(const char *s, size_t n);
void *memdup(const void *p, size_t size);
char *myhostname(void);
char *lock_path(const char *name);
char *pid_path(const char *name);
char *lib_path(const char *name);
const char *shlib_ext(void);
char *parent_dirname(const char *path);
BOOL ms_has_wild(const char *s);
BOOL ms_has_wild_w(const smb_ucs2_t *s);
BOOL mask_match(const char *string, char *pattern, BOOL is_case_sensitive);
BOOL mask_match_search(const char *string, char *pattern, BOOL is_case_sensitive);
BOOL mask_match_list(const char *string, char **list, int listLen, BOOL is_case_sensitive);
BOOL unix_wild_match(const char *pattern, const char *string);
void name_to_fqdn(fstring fqdn, const char *name);
void *talloc_check_name_abort(const void *ptr, const char *name);
int _Insure_trap_error(int a1, int a2, int a3, int a4, int a5, int a6);
uint32 map_share_mode_to_deny_mode(uint32 share_access, uint32 private_options);

/* The following definitions come from lib/util_file.c  */

BOOL do_file_lock(int fd, int waitsecs, int type);
BOOL file_lock(int fd, int type, int secs, int *plock_depth);
BOOL file_unlock(int fd, int *plock_depth);
void *startfilepwent(char *pfile, char *s_readbuf, int bufsize,
				int *file_lock_depth, BOOL update);
void endfilepwent(void *vp, int *file_lock_depth);
SMB_BIG_UINT getfilepwpos(void *vp);
BOOL setfilepwpos(void *vp, SMB_BIG_UINT tok);
int getfileline(void *vp, char *linebuf, int linebuf_size);
char *fgets_slash(char *s2,int maxlen,XFILE *f);
char *file_pload(char *syscmd, size_t *size);
char *fd_load(int fd, size_t *size);
char *file_load(const char *fname, size_t *size);
void *map_file(char *fname, size_t size);
char **file_lines_load(const char *fname, int *numlines);
char **fd_lines_load(int fd, int *numlines);
char **file_lines_pload(char *syscmd, int *numlines);
void file_lines_free(char **lines);
void file_lines_slashcont(char **lines);
BOOL file_save(const char *fname, void *packet, size_t length);

/* The following definitions come from lib/util_getent.c  */

struct sys_grent * getgrent_list(void);
void grent_free (struct sys_grent *glist);
struct sys_pwent * getpwent_list(void);
void pwent_free (struct sys_pwent *plist);
struct sys_userlist *get_users_in_group(const char *gname);
void free_userlist(struct sys_userlist *list_head);
void remove_duplicate_gids( int *num_groups, gid_t *groups );

/* The following definitions come from lib/util_pw.c  */

void passwd_free (struct passwd **buf);
void flush_pwnam_cache(void);
struct passwd *getpwnam_alloc(const char *name) ;
struct passwd *getpwuid_alloc(uid_t uid) ;

/* The following definitions come from lib/util_seaccess.c  */

void se_map_generic(uint32 *access_mask, struct generic_mapping *mapping);
void se_map_standard(uint32 *access_mask, struct standard_mapping *mapping);
BOOL se_access_check(const SEC_DESC *sd, const NT_USER_TOKEN *token,
		     uint32 acc_desired, uint32 *acc_granted, 
		     NTSTATUS *status);
NTSTATUS samr_make_sam_obj_sd(TALLOC_CTX *ctx, SEC_DESC **psd, size_t *sd_size);

/* The following definitions come from lib/util_sec.c  */

void sec_init(void);
uid_t sec_initial_uid(void);
gid_t sec_initial_gid(void);
BOOL non_root_mode(void);
void gain_root_privilege(void);
void gain_root_group_privilege(void);
void set_effective_uid(uid_t uid);
void set_effective_gid(gid_t gid);
void save_re_uid(void);
void restore_re_uid(void);
void save_re_gid(void);
void restore_re_gid(void);
int set_re_uid(void);
void become_user_permanently(uid_t uid, gid_t gid);
BOOL is_setuid_root(void) ;

/* The following definitions come from lib/util_sid.c  */

const char *sid_type_lookup(uint32 sid_type) ;
NT_USER_TOKEN *get_system_token(void) ;
const char *get_global_sam_name(void) ;
void split_domain_name(const char *fullname, char *domain, char *name);
BOOL resolvable_wellknown_sid(DOM_SID *sid);
char *sid_to_string(fstring sidstr_out, const DOM_SID *sid);
const char *sid_string_static(const DOM_SID *sid);
BOOL string_to_sid(DOM_SID *sidout, const char *sidstr);
DOM_SID *string_sid_talloc(TALLOC_CTX *mem_ctx, const char *sidstr);
BOOL sid_append_rid(DOM_SID *sid, uint32 rid);
BOOL sid_compose(DOM_SID *dst, const DOM_SID *domain_sid, uint32 rid);
BOOL sid_split_rid(DOM_SID *sid, uint32 *rid);
BOOL sid_peek_rid(const DOM_SID *sid, uint32 *rid);
BOOL sid_peek_check_rid(const DOM_SID *exp_dom_sid, const DOM_SID *sid, uint32 *rid);
void sid_copy(DOM_SID *dst, const DOM_SID *src);
BOOL sid_linearize(char *outbuf, size_t len, const DOM_SID *sid);
BOOL sid_parse(const char *inbuf, size_t len, DOM_SID *sid);
int sid_compare(const DOM_SID *sid1, const DOM_SID *sid2);
int sid_compare_domain(const DOM_SID *sid1, const DOM_SID *sid2);
BOOL sid_equal(const DOM_SID *sid1, const DOM_SID *sid2);
BOOL sid_check_is_builtin(const DOM_SID *sid);
BOOL sid_check_is_in_builtin(const DOM_SID *sid);
size_t sid_size(const DOM_SID *sid);
BOOL non_mappable_sid(DOM_SID *sid);
char *sid_binstring(const DOM_SID *sid);
DOM_SID *sid_dup_talloc(TALLOC_CTX *ctx, const DOM_SID *src);
void add_sid_to_array(TALLOC_CTX *mem_ctx, const DOM_SID *sid, 
		      DOM_SID **sids, int *num);
void add_sid_to_array_unique(TALLOC_CTX *mem_ctx, const DOM_SID *sid,
			     DOM_SID **sids, int *num_sids);
void del_sid_from_array(const DOM_SID *sid, DOM_SID **sids, int *num);

/* The following definitions come from lib/util_sock.c  */

void client_setfd(int fd);
char *client_name(void);
char *client_addr(void);
char *client_socket_addr(void);
int client_socket_port(void);
struct in_addr *client_inaddr(struct sockaddr *sa);
BOOL is_a_socket(int fd);
void set_socket_options(int fd, const char *options);
ssize_t read_udp_socket(int fd,char *buf,size_t len);
ssize_t read_data_until(int fd,char *buffer,size_t N, const struct timeval *endtime);
ssize_t read_socket_with_timeout(int fd,char *buf,size_t mincnt,size_t maxcnt,unsigned int time_out);
ssize_t read_data(int fd,char *buffer,size_t N);
ssize_t write_data(int fd, const char *buffer, size_t N);
BOOL send_keepalive(int client);
ssize_t read_smb_length(int fd, char *inbuf, unsigned int timeout);
BOOL receive_smb_raw(int fd, char *buffer, unsigned int timeout);
BOOL receive_smb(int fd, char *buffer, unsigned int timeout);
BOOL send_smb(int fd, char *buffer);
int open_socket_in( int type, int port, int dlevel, uint32 socket_addr, BOOL rebind );
int open_socket_out(int type, struct in_addr *addr, int port ,int timeout);
BOOL open_any_socket_out(struct sockaddr_in *addrs, int num_addrs,
			 int timeout, int *fd_index, int *fd);
int open_udp_socket(const char *host, int port);
char *get_peer_name(int fd, BOOL force_lookup);
char *get_peer_addr(int fd);
int create_pipe_sock(const char *socket_dir,
		     const char *socket_name,
		     mode_t dir_perms);

/* The following definitions come from lib/util_str.c  */

BOOL next_token(const char **ptr,char *buff, const char *sep, size_t bufsize);
BOOL next_token_nr(const char **ptr,char *buff, const char *sep, size_t bufsize);
void set_first_token(char *ptr);
char **toktocliplist(int *ctok, const char *sep);
int StrCaseCmp(const char *s, const char *t);
int StrnCaseCmp(const char *s, const char *t, size_t n);
BOOL strequal(const char *s1, const char *s2);
BOOL strnequal(const char *s1,const char *s2,size_t n);
BOOL strcsequal(const char *s1,const char *s2);
int strwicmp(const char *psz1, const char *psz2);
char *strupper_static(const char *s);
void strnorm(char *s, int case_default);
BOOL strisnormal(const char *s, int case_default);
void string_replace( pstring s, char oldc, char newc );
char *skip_string(char *buf,size_t n);
size_t str_charnum(const char *s);
size_t str_ascii_charnum(const char *s);
BOOL trim_char(char *s,char cfront,char cback);
BOOL trim_string(char *s,const char *front,const char *back);
BOOL strhasupper(const char *s);
BOOL strhaslower(const char *s);
size_t count_chars(const char *s,char c);
char *safe_strcpy_fn(const char *fn, int line, char *dest,const char *src, size_t maxlength);
char *safe_strcat_fn(const char *fn, int line, char *dest, const char *src, size_t maxlength);
char *alpha_strcpy_fn(const char *fn, int line, char *dest, const char *src, const char *other_safe_chars, size_t maxlength);
char *StrnCpy_fn(const char *fn, int line,char *dest,const char *src,size_t n);
size_t strhex_to_str(char *p, size_t len, const char *strhex);
DATA_BLOB strhex_to_data_blob(const char *strhex) ;
void hex_encode(const unsigned char *buff_in, size_t len, char **out_hex_buffer);
BOOL in_list(const char *s, const char *list, BOOL casesensitive);
void string_free(char **s);
BOOL string_set(char **dest,const char *src);
void string_sub2(char *s,const char *pattern, const char *insert, size_t len, 
		 BOOL remove_unsafe_characters, BOOL replace_once);
void string_sub_once(char *s, const char *pattern, const char *insert, size_t len);
void string_sub(char *s,const char *pattern, const char *insert, size_t len);
void fstring_sub(char *s,const char *pattern,const char *insert);
void pstring_sub(char *s,const char *pattern,const char *insert);
char *realloc_string_sub(char *string, const char *pattern, const char *insert);
void all_string_sub(char *s,const char *pattern,const char *insert, size_t len);
smb_ucs2_t *all_string_sub_wa(smb_ucs2_t *s, const char *pattern,
					     const char *insert);
const char *octal_string(int i);
char *string_truncate(char *s, unsigned int length);
char *strchr_m(const char *src, char c);
char *strrchr_m(const char *s, char c);
char *strnrchr_m(const char *s, char c, unsigned int n);
char *strstr_m(const char *src, const char *findstr);
void strlower_m(char *s);
void strupper_m(char *s);
char *binary_string(char *buf, int len);
int fstr_sprintf(fstring s, const char *fmt, ...);
char **str_list_make(const char *string, const char *sep);
BOOL str_list_copy(char ***dest, const char **src);
BOOL str_list_compare(char **list1, char **list2);
void str_list_free(char ***list);
int str_list_count( const char **list );
BOOL str_list_sub_basic( char **list, const char *smb_name );
BOOL str_list_substitute(char **list, const char *pattern, const char *insert);
char* ipstr_list_add(char** ipstr_list, const struct ip_service *service);
char* ipstr_list_make(char** ipstr_list, const struct ip_service* ip_list, int ip_count);
int ipstr_list_parse(const char* ipstr_list, struct ip_service **ip_list);
void ipstr_list_free(char* ipstr_list);
void rfc1738_unescape(char *buf);
DATA_BLOB base64_decode_data_blob(const char *s);
void base64_decode_inplace(char *s);
char * base64_encode_data_blob(DATA_BLOB data);
SMB_BIG_UINT STR_TO_SMB_BIG_UINT(const char *nptr, const char **entptr);
void string_append(char **left, const char *right);
BOOL add_string_to_array(TALLOC_CTX *mem_ctx,
			 const char *str, const char ***strings,
			 int *num);
void sprintf_append(TALLOC_CTX *mem_ctx, char **string, ssize_t *len,
		    size_t *bufsize, const char *fmt, ...);
char *sstring_sub(const char *src, char front, char back);

/* The following definitions come from lib/util_unistr.c  */

void load_case_tables(void);
int check_dos_char(smb_ucs2_t c);
void init_doschar_table(void);
void init_valid_table(void);
size_t dos_PutUniCode(char *dst,const char *src, ssize_t len, BOOL null_terminate);
char *skip_unibuf(char *src, size_t len);
int rpcstr_pull(char* dest, void *src, int dest_len, int src_len, int flags);
int rpcstr_pull_unistr2_fstring(char *dest, UNISTR2 *src);
int rpcstr_push(void* dest, const char *src, int dest_len, int flags);
void unistr2_to_ascii(char *dest, const UNISTR2 *str, size_t maxlen);
void unistr3_to_ascii(char *dest, const UNISTR3 *str, size_t maxlen);
const char *unistr2_static(const UNISTR2 *str);
char *unistr2_tdup(TALLOC_CTX *ctx, const UNISTR2 *str);
smb_ucs2_t toupper_w(smb_ucs2_t val);
smb_ucs2_t tolower_w( smb_ucs2_t val );
BOOL islower_w(smb_ucs2_t c);
BOOL isupper_w(smb_ucs2_t c);
BOOL isvalid83_w(smb_ucs2_t c);
size_t strlen_w(const smb_ucs2_t *src);
size_t strnlen_w(const smb_ucs2_t *src, size_t max);
smb_ucs2_t *strchr_w(const smb_ucs2_t *s, smb_ucs2_t c);
smb_ucs2_t *strchr_wa(const smb_ucs2_t *s, char c);
smb_ucs2_t *strrchr_w(const smb_ucs2_t *s, smb_ucs2_t c);
smb_ucs2_t *strnrchr_w(const smb_ucs2_t *s, smb_ucs2_t c, unsigned int n);
smb_ucs2_t *strstr_w(const smb_ucs2_t *s, const smb_ucs2_t *ins);
BOOL strlower_w(smb_ucs2_t *s);
BOOL strupper_w(smb_ucs2_t *s);
void strnorm_w(smb_ucs2_t *s, int case_default);
int strcmp_w(const smb_ucs2_t *a, const smb_ucs2_t *b);
int strncmp_w(const smb_ucs2_t *a, const smb_ucs2_t *b, size_t len);
int strcasecmp_w(const smb_ucs2_t *a, const smb_ucs2_t *b);
int strncasecmp_w(const smb_ucs2_t *a, const smb_ucs2_t *b, size_t len);
BOOL strequal_w(const smb_ucs2_t *s1, const smb_ucs2_t *s2);
BOOL strnequal_w(const smb_ucs2_t *s1,const smb_ucs2_t *s2,size_t n);
smb_ucs2_t *strdup_w(const smb_ucs2_t *src);
smb_ucs2_t *strndup_w(const smb_ucs2_t *src, size_t len);
smb_ucs2_t *strncpy_w(smb_ucs2_t *dest, const smb_ucs2_t *src, const size_t max);
smb_ucs2_t *strncat_w(smb_ucs2_t *dest, const smb_ucs2_t *src, const size_t max);
smb_ucs2_t *strcat_w(smb_ucs2_t *dest, const smb_ucs2_t *src);
void string_replace_w(smb_ucs2_t *s, smb_ucs2_t oldc, smb_ucs2_t newc);
BOOL trim_string_w(smb_ucs2_t *s, const smb_ucs2_t *front,
				  const smb_ucs2_t *back);
int strcmp_wa(const smb_ucs2_t *a, const char *b);
int strncmp_wa(const smb_ucs2_t *a, const char *b, size_t len);
smb_ucs2_t *strpbrk_wa(const smb_ucs2_t *s, const char *p);
smb_ucs2_t *strstr_wa(const smb_ucs2_t *s, const char *ins);
BOOL trim_string_wa(smb_ucs2_t *s, const char *front,
				  const char *back);
int unistrlen(uint16 *s);
int unistrcpy(uint16 *dst, uint16 *src);
UNISTR2* ucs2_to_unistr2(TALLOC_CTX *ctx, UNISTR2* dst, smb_ucs2_t* src);

/* The following definitions come from lib/util_uuid.c  */

void smb_uuid_pack(const struct uuid uu, UUID_FLAT *ptr);
void smb_uuid_unpack(const UUID_FLAT in, struct uuid *uu);
struct uuid smb_uuid_unpack_static(const UUID_FLAT in);
void smb_uuid_generate_random(struct uuid *uu);
char *smb_uuid_to_string(const struct uuid uu);
const char *smb_uuid_string_static(const struct uuid uu);
BOOL smb_string_to_uuid(const char *in, struct uuid* uu);

/* The following definitions come from lib/version.c  */

const char *samba_version_string(void);

/* The following definitions come from lib/wins_srv.c  */

BOOL wins_srv_is_dead(struct in_addr wins_ip, struct in_addr src_ip);
void wins_srv_alive(struct in_addr wins_ip, struct in_addr src_ip);
void wins_srv_died(struct in_addr wins_ip, struct in_addr src_ip);
unsigned wins_srv_count(void);
char **wins_srv_tags(void);
void wins_srv_tags_free(char **list);
struct in_addr wins_srv_ip_tag(const char *tag, struct in_addr src_ip);
unsigned wins_srv_count_tag(const char *tag);

/* The following definitions come from lib/xfile.c  */

int x_setvbuf(XFILE *f, char *buf, int mode, size_t size);
XFILE *x_fopen(const char *fname, int flags, mode_t mode);
int x_fclose(XFILE *f);
size_t x_fwrite(const void *p, size_t size, size_t nmemb, XFILE *f);
int x_fileno(XFILE *f);
int x_fflush(XFILE *f);
void x_setbuffer(XFILE *f, char *buf, size_t size);
void x_setbuf(XFILE *f, char *buf);
void x_setlinebuf(XFILE *f);
int x_feof(XFILE *f);
int x_ferror(XFILE *f);
int x_fgetc(XFILE *f);
size_t x_fread(void *p, size_t size, size_t nmemb, XFILE *f);
char *x_fgets(char *s, int size, XFILE *stream) ;
off_t x_tseek(XFILE *f, off_t offset, int whence);

/* The following definitions come from libads/ads_ldap.c  */

ADS_STATUS ads_sid_to_dn(ADS_STRUCT *ads,
			 TALLOC_CTX *mem_ctx,
			 const DOM_SID *sid,
			 char **dn);

/* The following definitions come from libads/ads_status.c  */

ADS_STATUS ads_build_error(enum ads_error_type etype, 
			   int rc, int minor_status);
ADS_STATUS ads_build_nt_error(enum ads_error_type etype, 
			   NTSTATUS nt_status);
NTSTATUS ads_ntstatus(ADS_STATUS status);
const char *ads_errstr(ADS_STATUS status);

/* The following definitions come from libads/ads_struct.c  */

char *ads_build_path(const char *realm, const char *sep, const char *field, int reverse);
char *ads_build_dn(const char *realm);
ADS_STRUCT *ads_init(const char *realm, 
		     const char *workgroup,
		     const char *ldap_server);
void ads_destroy(ADS_STRUCT **ads);

/* The following definitions come from libads/ads_utils.c  */

uint32 ads_acb2uf(uint16 acb);
uint16 ads_uf2acb(uint32 uf);
uint32 ads_uf2atype(uint32 uf);
uint32 ads_gtype2atype(uint32 gtype);
enum SID_NAME_USE ads_atype_map(uint32 atype);

/* The following definitions come from libads/authdata.c  */

PAC_DATA *decode_pac_data(DATA_BLOB *auth_data, TALLOC_CTX *ctx);

/* The following definitions come from libads/disp_sec.c  */

void ads_disp_sd(SEC_DESC *sd);

/* The following definitions come from libads/kerberos.c  */

int kerberos_kinit_password(const char *principal,
				const char *password,
				int time_offset,
				time_t *expire_time,
				const char *cache_name);
int ads_kinit_password(ADS_STRUCT *ads);
int ads_kdestroy(const char *cc_name);
BOOL kerberos_secrets_store_salting_principal(const char *service,
					      int enctype,
					      const char *principal);
BOOL kerberos_derive_salting_principal(char *service_principal);
BOOL kerberos_derive_cifs_salting_principals(void);

/* The following definitions come from libads/kerberos_keytab.c  */

int ads_keytab_add_entry(ADS_STRUCT *ads, const char *srvPrinc);
int ads_keytab_flush(ADS_STRUCT *ads);
int ads_keytab_create_default(ADS_STRUCT *ads);

/* The following definitions come from libads/kerberos_verify.c  */

NTSTATUS ads_verify_ticket(const char *realm, const DATA_BLOB *ticket, 
			   char **principal, DATA_BLOB *auth_data,
			   DATA_BLOB *ap_rep,
			   DATA_BLOB *session_key);

/* The following definitions come from libads/krb5_setpw.c  */

ADS_STATUS ads_krb5_set_password(const char *kdc_host, const char *princ, 
				 const char *newpw, int time_offset);
ADS_STATUS kerberos_set_password(const char *kpasswd_server, 
				 const char *auth_principal, const char *auth_password,
				 const char *target_principal, const char *new_password,
				 int time_offset);
ADS_STATUS ads_set_machine_password(ADS_STRUCT *ads,
				    const char *machine_account,
				    const char *password);

/* The following definitions come from libads/ldap.c  */

BOOL ads_try_connect(ADS_STRUCT *ads, const char *server, unsigned port);
ADS_STATUS ads_connect(ADS_STRUCT *ads);
ADS_STATUS ads_do_paged_search(ADS_STRUCT *ads, const char *bind_path,
			       int scope, const char *expr,
			       const char **attrs, void **res, 
			       int *count, void **cookie);
ADS_STATUS ads_do_search_all(ADS_STRUCT *ads, const char *bind_path,
			     int scope, const char *expr,
			     const char **attrs, void **res);
ADS_STATUS ads_do_search_all_fn(ADS_STRUCT *ads, const char *bind_path,
				int scope, const char *expr, const char **attrs,
				BOOL(*fn)(char *, void **, void *), 
				void *data_area);
ADS_STATUS ads_do_search(ADS_STRUCT *ads, const char *bind_path, int scope, 
			 const char *expr,
			 const char **attrs, void **res);
ADS_STATUS ads_search(ADS_STRUCT *ads, void **res, 
		      const char *expr, 
		      const char **attrs);
ADS_STATUS ads_search_dn(ADS_STRUCT *ads, void **res, 
			 const char *dn, 
			 const char **attrs);
void ads_msgfree(ADS_STRUCT *ads, void *msg);
void ads_memfree(ADS_STRUCT *ads, void *mem);
char *ads_get_dn(ADS_STRUCT *ads, void *msg);
ADS_STATUS ads_find_machine_acct(ADS_STRUCT *ads, void **res, const char *machine);
ADS_MODLIST ads_init_mods(TALLOC_CTX *ctx);
ADS_STATUS ads_mod_str(TALLOC_CTX *ctx, ADS_MODLIST *mods, 
		       const char *name, const char *val);
ADS_STATUS ads_mod_strlist(TALLOC_CTX *ctx, ADS_MODLIST *mods,
			   const char *name, const char **vals);
ADS_STATUS ads_gen_mod(ADS_STRUCT *ads, const char *mod_dn, ADS_MODLIST mods);
ADS_STATUS ads_gen_add(ADS_STRUCT *ads, const char *new_dn, ADS_MODLIST mods);
ADS_STATUS ads_del_dn(ADS_STRUCT *ads, char *del_dn);
char *ads_ou_string(ADS_STRUCT *ads, const char *org_unit);
char *ads_default_ou_string(ADS_STRUCT *ads, const char *wknguid);
ADS_STATUS ads_add_strlist(TALLOC_CTX *ctx, ADS_MODLIST *mods,
				const char *name, const char **vals);
uint32 ads_get_kvno(ADS_STRUCT *ads, const char *machine_name);
ADS_STATUS ads_clear_service_principal_names(ADS_STRUCT *ads, const char *machine_name);
ADS_STATUS ads_add_service_principal_name(ADS_STRUCT *ads, const char *machine_name, const char *spn);
void ads_dump(ADS_STRUCT *ads, void *res);
void ads_process_results(ADS_STRUCT *ads, void *res,
			 BOOL(*fn)(char *, void **, void *),
			 void *data_area);
int ads_count_replies(ADS_STRUCT *ads, void *res);
ADS_STATUS ads_join_realm(ADS_STRUCT *ads, const char *machine_name, 
			  uint32 account_type, const char *org_unit);
ADS_STATUS ads_leave_realm(ADS_STRUCT *ads, const char *hostname);
ADS_STATUS ads_set_machine_sd(ADS_STRUCT *ads, const char *hostname, char *dn);
void *ads_first_entry(ADS_STRUCT *ads, void *res);
void *ads_next_entry(ADS_STRUCT *ads, void *res);
char *ads_pull_string(ADS_STRUCT *ads, 
		      TALLOC_CTX *mem_ctx, void *msg, const char *field);
char **ads_pull_strings(ADS_STRUCT *ads, 
			TALLOC_CTX *mem_ctx, void *msg, const char *field,
			size_t *num_values);
char **ads_pull_strings_range(ADS_STRUCT *ads, 
			      TALLOC_CTX *mem_ctx,
			      void *msg, const char *field,
			      char **current_strings,
			      const char **next_attribute,
			      size_t *num_strings,
			      BOOL *more_strings);
BOOL ads_pull_uint32(ADS_STRUCT *ads, 
		     void *msg, const char *field, uint32 *v);
BOOL ads_pull_guid(ADS_STRUCT *ads,
		   void *msg, struct uuid *guid);
BOOL ads_pull_sid(ADS_STRUCT *ads, 
		  void *msg, const char *field, DOM_SID *sid);
int ads_pull_sids(ADS_STRUCT *ads, TALLOC_CTX *mem_ctx,
		  void *msg, const char *field, DOM_SID **sids);
BOOL ads_pull_sd(ADS_STRUCT *ads, TALLOC_CTX *mem_ctx,
		  void *msg, const char *field, SEC_DESC **sd);
char *ads_pull_username(ADS_STRUCT *ads, TALLOC_CTX *mem_ctx, void *msg);
ADS_STATUS ads_USN(ADS_STRUCT *ads, uint32 *usn);
const char *ads_get_attrname_by_oid(ADS_STRUCT *ads, TALLOC_CTX *mem_ctx, const char * OID);
ADS_STATUS ads_server_info(ADS_STRUCT *ads);
BOOL ads_check_sfu_mapping(ADS_STRUCT *ads) ;
ADS_STATUS ads_domain_sid(ADS_STRUCT *ads, DOM_SID *sid);
ADS_STATUS ads_workgroup_name(ADS_STRUCT *ads, TALLOC_CTX *mem_ctx, const char **workgroup);

/* The following definitions come from libads/ldap_printer.c  */

ADS_STATUS ads_find_printer_on_server(ADS_STRUCT *ads, void **res,
				      const char *printer, const char *servername);
ADS_STATUS ads_find_printers(ADS_STRUCT *ads, void **res);
ADS_STATUS ads_mod_printer_entry(ADS_STRUCT *ads, char *prt_dn,
				 TALLOC_CTX *ctx, const ADS_MODLIST *mods);
ADS_STATUS ads_add_printer_entry(ADS_STRUCT *ads, char *prt_dn,
					TALLOC_CTX *ctx, ADS_MODLIST *mods);
WERROR get_remote_printer_publishing_data(struct cli_state *cli, 
					  TALLOC_CTX *mem_ctx,
					  ADS_MODLIST *mods,
					  const char *printer);
BOOL get_local_printer_publishing_data(TALLOC_CTX *mem_ctx,
				       ADS_MODLIST *mods,
				       NT_PRINTER_DATA *data);

/* The following definitions come from libads/ldap_user.c  */

ADS_STATUS ads_find_user_acct(ADS_STRUCT *ads, void **res, const char *user);
ADS_STATUS ads_add_user_acct(ADS_STRUCT *ads, const char *user, 
			     const char *container, const char *fullname);
ADS_STATUS ads_add_group_acct(ADS_STRUCT *ads, const char *group, 
			      const char *container, const char *comment);

/* The following definitions come from libads/ldap_utils.c  */

ADS_STATUS ads_do_search_retry(ADS_STRUCT *ads, const char *bind_path, int scope, 
			       const char *expr,
			       const char **attrs, void **res);
ADS_STATUS ads_search_retry(ADS_STRUCT *ads, void **res, 
			    const char *expr, 
			    const char **attrs);
ADS_STATUS ads_search_retry_dn(ADS_STRUCT *ads, void **res, 
			       const char *dn, 
			       const char **attrs);

/* The following definitions come from libads/sasl.c  */

ADS_STATUS ads_sasl_bind(ADS_STRUCT *ads);

/* The following definitions come from libads/util.c  */

ADS_STATUS ads_change_trust_account_password(ADS_STRUCT *ads, char *host_principal);

/* The following definitions come from libsmb/asn1.c  */

void asn1_free(ASN1_DATA *data);
BOOL asn1_write(ASN1_DATA *data, const void *p, int len);
BOOL asn1_write_uint8(ASN1_DATA *data, uint8 v);
BOOL asn1_push_tag(ASN1_DATA *data, uint8 tag);
BOOL asn1_pop_tag(ASN1_DATA *data);
BOOL asn1_write_Integer(ASN1_DATA *data, int i);
BOOL asn1_write_OID(ASN1_DATA *data, const char *OID);
BOOL asn1_write_OctetString(ASN1_DATA *data, const void *p, size_t length);
BOOL asn1_write_GeneralString(ASN1_DATA *data, const char *s);
BOOL asn1_write_BOOLEAN(ASN1_DATA *data, BOOL v);
BOOL asn1_write_BOOLEAN2(ASN1_DATA *data, BOOL v);
BOOL asn1_check_BOOLEAN(ASN1_DATA *data, BOOL v);
BOOL asn1_load(ASN1_DATA *data, DATA_BLOB blob);
BOOL asn1_read(ASN1_DATA *data, void *p, int len);
BOOL asn1_read_uint8(ASN1_DATA *data, uint8 *v);
BOOL asn1_start_tag(ASN1_DATA *data, uint8 tag);
BOOL asn1_end_tag(ASN1_DATA *data);
int asn1_tag_remaining(ASN1_DATA *data);
BOOL asn1_read_OID(ASN1_DATA *data, char **OID);
BOOL asn1_check_OID(ASN1_DATA *data, const char *OID);
BOOL asn1_read_GeneralString(ASN1_DATA *data, char **s);
BOOL asn1_read_OctetString(ASN1_DATA *data, DATA_BLOB *blob);
BOOL asn1_read_Integer(ASN1_DATA *data, int *i);
BOOL asn1_check_enumerated(ASN1_DATA *data, int v);
BOOL asn1_write_enumerated(ASN1_DATA *data, uint8 v);

/* The following definitions come from libsmb/cliconnect.c  */

ADS_STATUS cli_session_setup_spnego(struct cli_state *cli, const char *user, 
			      const char *pass, const char *domain);
BOOL cli_session_setup(struct cli_state *cli, 
		       const char *user, 
		       const char *pass, int passlen,
		       const char *ntpass, int ntpasslen,
		       const char *workgroup);
BOOL cli_ulogoff(struct cli_state *cli);
BOOL cli_send_tconX(struct cli_state *cli, 
		    const char *share, const char *dev, const char *pass, int passlen);
BOOL cli_tdis(struct cli_state *cli);
void cli_negprot_send(struct cli_state *cli);
BOOL cli_negprot(struct cli_state *cli);
BOOL cli_session_request(struct cli_state *cli,
			 struct nmb_name *calling, struct nmb_name *called);
BOOL cli_connect(struct cli_state *cli, const char *host, struct in_addr *ip);
void init_creds(struct ntuser_creds *creds, const char* username,
		       const char* domain, const char* password);
NTSTATUS cli_start_connection(struct cli_state **output_cli, 
			      const char *my_name, 
			      const char *dest_host, 
			      struct in_addr *dest_ip, int port,
			      int signing_state, int flags,
			      BOOL *retry) ;
NTSTATUS cli_full_connection(struct cli_state **output_cli, 
			     const char *my_name, 
			     const char *dest_host, 
			     struct in_addr *dest_ip, int port,
			     const char *service, const char *service_type,
			     const char *user, const char *domain, 
			     const char *password, int flags,
			     int signing_state,
			     BOOL *retry) ;
BOOL attempt_netbios_session_request(struct cli_state *cli, const char *srchost, const char *desthost,
                                     struct in_addr *pdest_ip);
NTSTATUS cli_raw_tcon(struct cli_state *cli, 
		      const char *service, const char *pass, const char *dev,
		      uint16 *max_xmit, uint16 *tid);
struct cli_state *get_ipc_connect(char *server, struct in_addr *server_ip,
                                         struct user_auth_info *user_info);
struct cli_state *get_ipc_connect_master_ip(struct ip_service * mb_ip, pstring workgroup, struct user_auth_info *user_info);
struct cli_state *get_ipc_connect_master_ip_bcast(pstring workgroup, struct user_auth_info *user_info);

/* The following definitions come from libsmb/clidfs.c  */

const char * cli_cm_get_mntpoint( struct cli_state *c );
struct cli_state* cli_cm_open( const char *server, const char *share, BOOL show_hdr );
void cli_cm_shutdown( void );
void cli_cm_display(void);
void cli_cm_set_credentials( struct user_auth_info *user );
void cli_cm_set_port( int port_number );
void cli_cm_set_dest_name_type( int type );
void cli_cm_set_dest_ip(struct in_addr ip );
BOOL cli_dfs_make_full_path( pstring path, const char *server, const char *share,
                            const char *dir );
BOOL cli_dfs_get_referral( struct cli_state *cli, const char *path, 
                           CLIENT_DFS_REFERRAL**refs, size_t *num_refs,
			   uint16 *consumed);
BOOL cli_resolve_path( const char *mountpt, struct cli_state *rootcli, const char *path,
                       struct cli_state **targetcli, pstring targetpath );
BOOL cli_check_msdfs_proxy( struct cli_state *cli, const char *sharename,
                            fstring newserver, fstring newshare );

/* The following definitions come from libsmb/clidgram.c  */

BOOL cli_send_mailslot(BOOL unique, const char *mailslot,
		       uint16 priority,
		       char *buf, int len,
		       const char *srcname, int src_type, 
		       const char *dstname, int dest_type,
		       struct in_addr dest_ip);
BOOL cli_get_response(const char *mailslot, char *buf, int bufsiz);
int cli_get_backup_list(const char *myname, const char *send_to_name);
int cli_get_backup_server(char *my_name, char *target, char *servername, int namesize);

/* The following definitions come from libsmb/clientgen.c  */

unsigned int cli_set_timeout(struct cli_state *cli, unsigned int timeout);
int cli_set_port(struct cli_state *cli, int port);
BOOL cli_receive_smb(struct cli_state *cli);
BOOL cli_send_smb(struct cli_state *cli);
void cli_setup_packet(struct cli_state *cli);
void cli_setup_bcc(struct cli_state *cli, void *p);
void cli_init_creds(struct cli_state *cli, const struct ntuser_creds *usr);
void cli_setup_signing_state(struct cli_state *cli, int signing_state);
struct cli_state *cli_initialise(struct cli_state *cli);
void cli_nt_session_close(struct cli_state *cli);
void cli_nt_netlogon_netsec_session_close(struct cli_state *cli);
void cli_close_connection(struct cli_state *cli);
void cli_shutdown(struct cli_state *cli);
void cli_sockopt(struct cli_state *cli, const char *options);
uint16 cli_setpid(struct cli_state *cli, uint16 pid);
BOOL cli_set_case_sensitive(struct cli_state *cli, BOOL case_sensitive);
BOOL cli_send_keepalive(struct cli_state *cli);

/* The following definitions come from libsmb/clierror.c  */

const char *cli_errstr(struct cli_state *cli);
NTSTATUS cli_nt_error(struct cli_state *cli);
void cli_dos_error(struct cli_state *cli, uint8 *eclass, uint32 *ecode);
int cli_errno(struct cli_state *cli);
BOOL cli_is_error(struct cli_state *cli);
BOOL cli_is_nt_error(struct cli_state *cli);
BOOL cli_is_dos_error(struct cli_state *cli);

/* The following definitions come from libsmb/clifile.c  */

uint32 unix_perms_to_wire(mode_t perms);
mode_t wire_perms_to_unix(uint32 perms);
BOOL cli_unix_getfacl(struct cli_state *cli, const char *name, size_t *prb_size, char **retbuf);
BOOL cli_unix_stat(struct cli_state *cli, const char *name, SMB_STRUCT_STAT *sbuf);
BOOL cli_unix_symlink(struct cli_state *cli, const char *oldname, const char *newname);
BOOL cli_unix_hardlink(struct cli_state *cli, const char *oldname, const char *newname);
BOOL cli_unix_chmod(struct cli_state *cli, const char *fname, mode_t mode);
BOOL cli_unix_chown(struct cli_state *cli, const char *fname, uid_t uid, gid_t gid);
BOOL cli_rename(struct cli_state *cli, const char *fname_src, const char *fname_dst);
BOOL cli_ntrename(struct cli_state *cli, const char *fname_src, const char *fname_dst);
BOOL cli_nt_hardlink(struct cli_state *cli, const char *fname_src, const char *fname_dst);
BOOL cli_unlink(struct cli_state *cli, const char *fname);
BOOL cli_mkdir(struct cli_state *cli, const char *dname);
BOOL cli_rmdir(struct cli_state *cli, const char *dname);
int cli_nt_delete_on_close(struct cli_state *cli, int fnum, BOOL flag);
int cli_nt_create_full(struct cli_state *cli, const char *fname, 
		 uint32 CreatFlags, uint32 DesiredAccess,
		 uint32 FileAttributes, uint32 ShareAccess,
		 uint32 CreateDisposition, uint32 CreateOptions,
		 uint8 SecuityFlags);
int cli_nt_create(struct cli_state *cli, const char *fname, uint32 DesiredAccess);
int cli_open(struct cli_state *cli, const char *fname, int flags, int share_mode);
BOOL cli_close(struct cli_state *cli, int fnum);
NTSTATUS cli_locktype(struct cli_state *cli, int fnum, 
		      uint32 offset, uint32 len, int timeout, unsigned char locktype);
BOOL cli_lock(struct cli_state *cli, int fnum, 
	      uint32 offset, uint32 len, int timeout, enum brl_type lock_type);
BOOL cli_unlock(struct cli_state *cli, int fnum, uint32 offset, uint32 len);
BOOL cli_lock64(struct cli_state *cli, int fnum, 
		SMB_BIG_UINT offset, SMB_BIG_UINT len, int timeout, enum brl_type lock_type);
BOOL cli_unlock64(struct cli_state *cli, int fnum, SMB_BIG_UINT offset, SMB_BIG_UINT len);
BOOL cli_getattrE(struct cli_state *cli, int fd, 
		  uint16 *attr, SMB_OFF_T *size, 
		  time_t *c_time, time_t *a_time, time_t *m_time);
BOOL cli_getatr(struct cli_state *cli, const char *fname, 
		uint16 *attr, SMB_OFF_T *size, time_t *t);
BOOL cli_setattrE(struct cli_state *cli, int fd,
		  time_t c_time, time_t a_time, time_t m_time);
BOOL cli_setatr(struct cli_state *cli, const char *fname, uint16 attr, time_t t);
BOOL cli_chkpath(struct cli_state *cli, const char *path);
BOOL cli_dskattr(struct cli_state *cli, int *bsize, int *total, int *avail);
int cli_ctemp(struct cli_state *cli, const char *path, char **tmp_path);
NTSTATUS cli_raw_ioctl(struct cli_state *cli, int fnum, uint32 code, DATA_BLOB *blob);
BOOL cli_set_ea_path(struct cli_state *cli, const char *path, const char *ea_name, const char *ea_val, size_t ea_len);
BOOL cli_set_ea_fnum(struct cli_state *cli, int fnum, const char *ea_name, const char *ea_val, size_t ea_len);
BOOL cli_get_ea_list_path(struct cli_state *cli, const char *path,
		TALLOC_CTX *ctx,
		size_t *pnum_eas,
		struct ea_struct **pea_list);
BOOL cli_get_ea_list_fnum(struct cli_state *cli, int fnum,
		TALLOC_CTX *ctx,
		size_t *pnum_eas,
		struct ea_struct **pea_list);

/* The following definitions come from libsmb/clifsinfo.c  */

BOOL cli_unix_extensions_version(struct cli_state *cli, uint16 *pmajor, uint16 *pminor,
                                        uint32 *pcaplow, uint32 *pcaphigh);
BOOL cli_get_fs_attr_info(struct cli_state *cli, uint32 *fs_attr);
BOOL cli_get_fs_volume_info_old(struct cli_state *cli, fstring volume_name, uint32 *pserial_number);
BOOL cli_get_fs_volume_info(struct cli_state *cli, fstring volume_name, uint32 *pserial_number, time_t *pdate);

/* The following definitions come from libsmb/clikrb5.c  */

int cli_krb5_get_ticket(const char *principal, time_t time_offset, 
			DATA_BLOB *ticket, DATA_BLOB *session_key_krb5);
int cli_krb5_get_ticket(const char *principal, time_t time_offset, 
			DATA_BLOB *ticket, DATA_BLOB *session_key_krb5) ;

/* The following definitions come from libsmb/clilist.c  */

int cli_list_new(struct cli_state *cli,const char *Mask,uint16 attribute, 
		 void (*fn)(const char *, file_info *, const char *, void *), void *state);
int cli_list_old(struct cli_state *cli,const char *Mask,uint16 attribute, 
		 void (*fn)(const char *, file_info *, const char *, void *), void *state);
int cli_list(struct cli_state *cli,const char *Mask,uint16 attribute, 
	     void (*fn)(const char *, file_info *, const char *, void *), void *state);

/* The following definitions come from libsmb/climessage.c  */

int cli_message_start_build(struct cli_state *cli, char *host, char *username);
BOOL cli_message_start(struct cli_state *cli, char *host, char *username,
			      int *grp);
int cli_message_text_build(struct cli_state *cli, char *msg, int len, int grp);
BOOL cli_message_text(struct cli_state *cli, char *msg, int len, int grp);
int cli_message_end_build(struct cli_state *cli, int grp);
BOOL cli_message_end(struct cli_state *cli, int grp);

/* The following definitions come from libsmb/clioplock.c  */

BOOL cli_oplock_ack(struct cli_state *cli, int fnum, unsigned char level);
void cli_oplock_handler(struct cli_state *cli, 
			BOOL (*handler)(struct cli_state *, int, unsigned char));

/* The following definitions come from libsmb/cliprint.c  */

int cli_print_queue(struct cli_state *cli, 
		    void (*fn)(struct print_job_info *));
int cli_printjob_del(struct cli_state *cli, int job);
int cli_spl_open(struct cli_state *cli, const char *fname, int flags, int share_mode);
BOOL cli_spl_close(struct cli_state *cli, int fnum);

/* The following definitions come from libsmb/cliquota.c  */

BOOL cli_get_quota_handle(struct cli_state *cli, int *quota_fnum);
void free_ntquota_list(SMB_NTQUOTA_LIST **qt_list);
BOOL cli_get_user_quota(struct cli_state *cli, int quota_fnum, SMB_NTQUOTA_STRUCT *pqt);
BOOL cli_set_user_quota(struct cli_state *cli, int quota_fnum, SMB_NTQUOTA_STRUCT *pqt);
BOOL cli_list_user_quota(struct cli_state *cli, int quota_fnum, SMB_NTQUOTA_LIST **pqt_list);
BOOL cli_get_fs_quota_info(struct cli_state *cli, int quota_fnum, SMB_NTQUOTA_STRUCT *pqt);
BOOL cli_set_fs_quota_info(struct cli_state *cli, int quota_fnum, SMB_NTQUOTA_STRUCT *pqt);
void dump_ntquota(SMB_NTQUOTA_STRUCT *qt, BOOL _verbose, BOOL _numeric, void (*_sidtostring)(fstring str, DOM_SID *sid, BOOL _numeric));
void dump_ntquota_list(SMB_NTQUOTA_LIST **qtl, BOOL _verbose, BOOL _numeric, void (*_sidtostring)(fstring str, DOM_SID *sid, BOOL _numeric));

/* The following definitions come from libsmb/clirap.c  */

BOOL cli_api_pipe(struct cli_state *cli, const char *pipe_name, 
                  uint16 *setup, uint32 setup_count, uint32 max_setup_count,
                  char *params, uint32 param_count, uint32 max_param_count,
                  char *data, uint32 data_count, uint32 max_data_count,
                  char **rparam, uint32 *rparam_count,
                  char **rdata, uint32 *rdata_count);
BOOL cli_api(struct cli_state *cli,
	     char *param, int prcnt, int mprcnt,
	     char *data, int drcnt, int mdrcnt,
	     char **rparam, unsigned int *rprcnt,
	     char **rdata, unsigned int *rdrcnt);
BOOL cli_NetWkstaUserLogon(struct cli_state *cli,char *user, char *workstation);
int cli_RNetShareEnum(struct cli_state *cli, void (*fn)(const char *, uint32, const char *, void *), void *state);
BOOL cli_NetServerEnum(struct cli_state *cli, char *workgroup, uint32 stype,
		       void (*fn)(const char *, uint32, const char *, void *),
		       void *state);
BOOL cli_oem_change_password(struct cli_state *cli, const char *user, const char *new_password,
                             const char *old_password);
BOOL cli_qpathinfo(struct cli_state *cli, const char *fname, 
		   time_t *c_time, time_t *a_time, time_t *m_time, 
		   SMB_OFF_T *size, uint16 *mode);
BOOL cli_setpathinfo(struct cli_state *cli, const char *fname, 
                     time_t c_time, time_t a_time, time_t m_time, uint16 mode);
BOOL cli_qpathinfo2(struct cli_state *cli, const char *fname, 
		    time_t *c_time, time_t *a_time, time_t *m_time, 
		    time_t *w_time, SMB_OFF_T *size, uint16 *mode,
		    SMB_INO_T *ino);
BOOL cli_qfilename(struct cli_state *cli, int fnum, 
		   pstring name);
BOOL cli_qfileinfo(struct cli_state *cli, int fnum, 
		   uint16 *mode, SMB_OFF_T *size,
		   time_t *c_time, time_t *a_time, time_t *m_time, 
		   time_t *w_time, SMB_INO_T *ino);
BOOL cli_qpathinfo_basic( struct cli_state *cli, const char *name, 
                          SMB_STRUCT_STAT *sbuf, uint32 *attributes );
BOOL cli_qfileinfo_test(struct cli_state *cli, int fnum, int level, char **poutdata, uint32 *poutlen);
NTSTATUS cli_qpathinfo_alt_name(struct cli_state *cli, const char *fname, fstring alt_name);

/* The following definitions come from libsmb/clirap2.c  */

int cli_NetGroupDelete(struct cli_state *cli, const char *group_name );
int cli_NetGroupAdd(struct cli_state *cli, RAP_GROUP_INFO_1 * grinfo );
int cli_RNetGroupEnum(struct cli_state *cli, void (*fn)(const char *, const char *, void *), void *state);
int cli_RNetGroupEnum0(struct cli_state *cli,
		       void (*fn)(const char *, void *),
		       void *state);
int cli_NetGroupDelUser(struct cli_state * cli, const char *group_name, const char *user_name);
int cli_NetGroupAddUser(struct cli_state * cli, const char *group_name, const char *user_name);
int cli_NetGroupGetUsers(struct cli_state * cli, const char *group_name, void (*fn)(const char *, void *), void *state );
int cli_NetUserGetGroups(struct cli_state * cli, const char *user_name, void (*fn)(const char *, void *), void *state );
int cli_NetUserDelete(struct cli_state *cli, const char * user_name );
int cli_NetUserAdd(struct cli_state *cli, RAP_USER_INFO_1 * userinfo );
int cli_RNetUserEnum(struct cli_state *cli, void (*fn)(const char *, const char *, const char *, const char *, void *), void *state);
int cli_RNetUserEnum0(struct cli_state *cli,
		      void (*fn)(const char *, void *),
		      void *state);
int cli_NetFileClose(struct cli_state *cli, uint32 file_id );
int cli_NetFileGetInfo(struct cli_state *cli, uint32 file_id, void (*fn)(const char *, const char *, uint16, uint16, uint32));
int cli_NetFileEnum(struct cli_state *cli, char * user, char * base_path, void (*fn)(const char *, const char *, uint16, uint16, uint32));
int cli_NetShareAdd(struct cli_state *cli, RAP_SHARE_INFO_2 * sinfo );
int cli_NetShareDelete(struct cli_state *cli, const char * share_name );
BOOL cli_get_pdc_name(struct cli_state *cli, char *workgroup, char *pdc_name);
BOOL cli_get_server_domain(struct cli_state *cli);
BOOL cli_get_server_type(struct cli_state *cli, uint32 *pstype);
BOOL cli_ns_check_server_type(struct cli_state *cli, char *workgroup, uint32 stype);
BOOL cli_NetWkstaUserLogoff(struct cli_state *cli,char *user, char *workstation);
int cli_NetPrintQEnum(struct cli_state *cli,
		void (*qfn)(const char*,uint16,uint16,uint16,const char*,const char*,const char*,const char*,const char*,uint16,uint16),
		void (*jfn)(uint16,const char*,const char*,const char*,const char*,uint16,uint16,const char*,uint,uint,const char*));
int cli_NetPrintQGetInfo(struct cli_state *cli, const char *printer,
	void (*qfn)(const char*,uint16,uint16,uint16,const char*,const char*,const char*,const char*,const char*,uint16,uint16),
	void (*jfn)(uint16,const char*,const char*,const char*,const char*,uint16,uint16,const char*,uint,uint,const char*));
int cli_RNetServiceEnum(struct cli_state *cli, void (*fn)(const char *, const char *, void *), void *state);
int cli_NetSessionEnum(struct cli_state *cli, void (*fn)(char *, char *, uint16, uint16, uint16, uint, uint, uint, char *));
int cli_NetSessionGetInfo(struct cli_state *cli, const char *workstation, void (*fn)(const char *, const char *, uint16, uint16, uint16, uint, uint, uint, const char *));
int cli_NetSessionDel(struct cli_state *cli, const char *workstation);
int cli_NetConnectionEnum(struct cli_state *cli, const char *qualifier, void (*fn)(uint16 conid, uint16 contype, uint16 numopens, uint16 numusers, uint32 contime, const char *username, const char *netname));

/* The following definitions come from libsmb/clireadwrite.c  */

ssize_t cli_read(struct cli_state *cli, int fnum, char *buf, off_t offset, size_t size);
ssize_t cli_readraw(struct cli_state *cli, int fnum, char *buf, off_t offset, size_t size);
size_t cli_write(struct cli_state *cli,
    	         int fnum, uint16 write_mode,
		 const char *buf, off_t offset, size_t size);
ssize_t cli_smbwrite(struct cli_state *cli,
		     int fnum, char *buf, off_t offset, size_t size1);

/* The following definitions come from libsmb/clisecdesc.c  */

SEC_DESC *cli_query_secdesc(struct cli_state *cli, int fnum, 
			    TALLOC_CTX *mem_ctx);
BOOL cli_set_secdesc(struct cli_state *cli, int fnum, SEC_DESC *sd);

/* The following definitions come from libsmb/clispnego.c  */

DATA_BLOB spnego_gen_negTokenInit(uint8 guid[16], 
				  const char *OIDs[], 
				  const char *principal);
DATA_BLOB gen_negTokenInit(const char *OID, DATA_BLOB blob);
BOOL spnego_parse_negTokenInit(DATA_BLOB blob,
			       char *OIDs[ASN1_MAX_OIDS], 
			       char **principal);
DATA_BLOB gen_negTokenTarg(const char *OIDs[], DATA_BLOB blob);
BOOL parse_negTokenTarg(DATA_BLOB blob, char *OIDs[ASN1_MAX_OIDS], DATA_BLOB *secblob);
DATA_BLOB spnego_gen_krb5_wrap(DATA_BLOB ticket, const uint8 tok_id[2]);
BOOL spnego_parse_krb5_wrap(DATA_BLOB blob, DATA_BLOB *ticket, uint8 tok_id[2]);
int spnego_gen_negTokenTarg(const char *principal, int time_offset, 
			    DATA_BLOB *targ, 
			    DATA_BLOB *session_key_krb5);
BOOL spnego_parse_challenge(const DATA_BLOB blob,
			    DATA_BLOB *chal1, DATA_BLOB *chal2);
DATA_BLOB spnego_gen_auth(DATA_BLOB blob);
BOOL spnego_parse_auth(DATA_BLOB blob, DATA_BLOB *auth);
DATA_BLOB spnego_gen_auth_response(DATA_BLOB *reply, NTSTATUS nt_status,
				   const char *mechOID);
BOOL spnego_parse_auth_response(DATA_BLOB blob, NTSTATUS nt_status, 
				DATA_BLOB *auth);

/* The following definitions come from libsmb/clistr.c  */

size_t clistr_push_fn(const char *function, unsigned int line, 
		   struct cli_state *cli, void *dest, 
		   const char *src, int dest_len, int flags);
size_t clistr_pull_fn(const char *function, unsigned int line, 
		   struct cli_state *cli, char *dest, const void *src, 
		   int dest_len, int src_len, 
		   int flags);
size_t clistr_align_out(struct cli_state *cli, const void *p, int flags);
size_t clistr_align_in(struct cli_state *cli, const void *p, int flags);

/* The following definitions come from libsmb/clitrans.c  */

BOOL cli_send_trans(struct cli_state *cli, int trans, 
		    const char *pipe_name, 
		    int fid, int flags,
		    uint16 *setup, unsigned int lsetup, unsigned int msetup,
		    const char *param, unsigned int lparam, unsigned int mparam,
		    const char *data, unsigned int ldata, unsigned int mdata);
BOOL cli_receive_trans(struct cli_state *cli,int trans,
                              char **param, unsigned int *param_len,
                              char **data, unsigned int *data_len);
BOOL cli_send_nt_trans(struct cli_state *cli, 
		       int function, 
		       int flags,
		       uint16 *setup, unsigned int lsetup, unsigned int msetup,
		       char *param, unsigned int lparam, unsigned int mparam,
		       char *data, unsigned int ldata, unsigned int mdata);
BOOL cli_receive_nt_trans(struct cli_state *cli,
			  char **param, unsigned int *param_len,
			  char **data, unsigned int *data_len);

/* The following definitions come from libsmb/conncache.c  */

NTSTATUS check_negative_conn_cache( const char *domain, const char *server );
void add_failed_connection_entry(const char *domain, const char *server, NTSTATUS result) ;
void flush_negative_conn_cache( void );

/* The following definitions come from libsmb/credentials.c  */

char *credstr(const uchar *cred);
void cred_session_key(const DOM_CHAL *clnt_chal, const DOM_CHAL *srv_chal, const uchar *pass, 
		      uchar session_key[8]);
void cred_create(uchar session_key[8], DOM_CHAL *stor_cred, UTIME timestamp, 
		 DOM_CHAL *cred);
int cred_assert(DOM_CHAL *cred, uchar session_key[8], DOM_CHAL *stored_cred,
		UTIME timestamp);
BOOL clnt_deal_with_creds(uchar sess_key[8],
			  DOM_CRED *sto_clnt_cred, DOM_CRED *rcv_srv_cred);
BOOL deal_with_creds(uchar sess_key[8],
		     DOM_CRED *sto_clnt_cred, 
		     DOM_CRED *rcv_clnt_cred, DOM_CRED *rtn_srv_cred);

/* The following definitions come from libsmb/doserr.c  */

const char *dos_errstr(WERROR werror);

/* The following definitions come from libsmb/errormap.c  */

NTSTATUS dos_to_ntstatus(uint8 eclass, uint32 ecode);
void ntstatus_to_dos(NTSTATUS ntstatus, uint8 *eclass, uint32 *ecode);
NTSTATUS werror_to_ntstatus(WERROR error);
WERROR ntstatus_to_werror(NTSTATUS error);
NTSTATUS map_nt_error_from_unix(int unix_error);

/* The following definitions come from libsmb/namecache.c  */

BOOL namecache_enable(void);
BOOL namecache_shutdown(void);
BOOL namecache_store(const char *name, int name_type,
                     int num_names, struct ip_service *ip_list);
BOOL namecache_fetch(const char *name, int name_type, struct ip_service **ip_list,
                     int *num_names);
void namecache_flush(void);
BOOL namecache_status_store(const char *keyname, int keyname_type,
		int name_type, struct in_addr keyip,
		const char *srvname);
BOOL namecache_status_fetch(const char *keyname, int keyname_type,
			int name_type, struct in_addr keyip, char *srvname_out);

/* The following definitions come from libsmb/namequery.c  */

NODE_STATUS_STRUCT *node_status_query(int fd,struct nmb_name *name,
				      struct in_addr to_ip, int *num_names,
				      struct node_status_extra *extra);
BOOL name_status_find(const char *q_name, int q_type, int type, struct in_addr to_ip, fstring name);
struct in_addr *name_query(int fd,const char *name,int name_type, 
			   BOOL bcast,BOOL recurse,
			   struct in_addr to_ip, int *count, int *flags,
			   BOOL *timed_out);
XFILE *startlmhosts(char *fname);
BOOL getlmhostsent( XFILE *fp, pstring name, int *name_type, struct in_addr *ipaddr);
void endlmhosts(XFILE *fp);
BOOL name_resolve_bcast(const char *name, int name_type,
			struct ip_service **return_iplist, int *return_count);
BOOL resolve_wins(const char *name, int name_type,
		  struct ip_service **return_iplist, int *return_count);
BOOL internal_resolve_name(const char *name, int name_type,
			   struct ip_service **return_iplist, 
			   int *return_count, const char *resolve_order);
BOOL resolve_name(const char *name, struct in_addr *return_ip, int name_type);
BOOL find_master_ip(const char *group, struct in_addr *master_ip);
BOOL get_pdc_ip(const char *domain, struct in_addr *ip);
BOOL get_sorted_dc_list( const char *domain, struct ip_service **ip_list, int *count, BOOL ads_only );

/* The following definitions come from libsmb/namequery_dc.c  */

BOOL get_dc_name(const char *domain, const char *realm, fstring srv_name, struct in_addr *ip_out);

/* The following definitions come from libsmb/nmblib.c  */

void debug_nmb_packet(struct packet_struct *p);
char *nmb_namestr(struct nmb_name *n);
struct packet_struct *copy_packet(struct packet_struct *packet);
void free_packet(struct packet_struct *packet);
struct packet_struct *parse_packet(char *buf,int length,
				   enum packet_type packet_type);
struct packet_struct *read_packet(int fd,enum packet_type packet_type);
void make_nmb_name( struct nmb_name *n, const char *name, int type);
BOOL nmb_name_equal(struct nmb_name *n1, struct nmb_name *n2);
int build_packet(char *buf, struct packet_struct *p);
BOOL send_packet(struct packet_struct *p);
struct packet_struct *receive_packet(int fd,enum packet_type type,int t);
struct packet_struct *receive_nmb_packet(int fd, int t, int trn_id);
struct packet_struct *receive_dgram_packet(int fd, int t, const char *mailslot_name);
BOOL match_mailslot_name(struct packet_struct *p, const char *mailslot_name);
int matching_quad_bits(unsigned char *p1, unsigned char *p2);
void sort_query_replies(char *data, int n, struct in_addr ip);
char *dns_to_netbios_name(const char *dns_name);
int name_mangle( char *In, char *Out, char name_type );
int name_extract(char *buf,int ofs, fstring name);
int name_len(char *s1);

/* The following definitions come from libsmb/nterr.c  */

const char *nt_errstr(NTSTATUS nt_code);
const char *get_friendly_nt_error_msg(NTSTATUS nt_code);
const char *get_nt_error_c_code(NTSTATUS nt_code);
NTSTATUS nt_status_string_to_code(char *nt_status_str);
NTSTATUS nt_status_squash(NTSTATUS nt_status);

/* The following definitions come from libsmb/ntlm_check.c  */

NTSTATUS ntlm_password_check(TALLOC_CTX *mem_ctx,
			     const DATA_BLOB *challenge,
			     const DATA_BLOB *lm_response,
			     const DATA_BLOB *nt_response,
			     const DATA_BLOB *lm_interactive_pwd,
			     const DATA_BLOB *nt_interactive_pwd,
			     const char *username, 
			     const char *client_username, 
			     const char *client_domain,
			     const uint8 *lm_pw, const uint8 *nt_pw, 
			     DATA_BLOB *user_sess_key, 
			     DATA_BLOB *lm_sess_key);

/* The following definitions come from libsmb/ntlmssp.c  */

void debug_ntlmssp_flags(uint32 neg_flags);
NTSTATUS ntlmssp_set_username(NTLMSSP_STATE *ntlmssp_state, const char *user) ;
NTSTATUS ntlmssp_set_password(NTLMSSP_STATE *ntlmssp_state, const char *password) ;
NTSTATUS ntlmssp_set_domain(NTLMSSP_STATE *ntlmssp_state, const char *domain) ;
NTSTATUS ntlmssp_set_workstation(NTLMSSP_STATE *ntlmssp_state, const char *workstation) ;
NTSTATUS ntlmssp_store_response(NTLMSSP_STATE *ntlmssp_state,
				DATA_BLOB response) ;
NTSTATUS ntlmssp_update(NTLMSSP_STATE *ntlmssp_state, 
			const DATA_BLOB in, DATA_BLOB *out) ;
void ntlmssp_end(NTLMSSP_STATE **ntlmssp_state);
NTSTATUS ntlmssp_server_start(NTLMSSP_STATE **ntlmssp_state);
NTSTATUS ntlmssp_client_start(NTLMSSP_STATE **ntlmssp_state);

/* The following definitions come from libsmb/ntlmssp_parse.c  */

BOOL msrpc_gen(DATA_BLOB *blob,
	       const char *format, ...);
BOOL msrpc_parse(const DATA_BLOB *blob,
		 const char *format, ...);

/* The following definitions come from libsmb/ntlmssp_sign.c  */

NTSTATUS ntlmssp_sign_packet(NTLMSSP_STATE *ntlmssp_state,
				    const uchar *data, size_t length, 
				    DATA_BLOB *sig) ;
NTSTATUS ntlmssp_check_packet(NTLMSSP_STATE *ntlmssp_state,
			      const uchar *data, size_t length, 
			      const DATA_BLOB *sig) ;
NTSTATUS ntlmssp_seal_packet(NTLMSSP_STATE *ntlmssp_state,
			     uchar *data, size_t length,
			     DATA_BLOB *sig);
NTSTATUS ntlmssp_unseal_packet(NTLMSSP_STATE *ntlmssp_state,
				      uchar *data, size_t length,
				      DATA_BLOB *sig);
NTSTATUS ntlmssp_sign_init(NTLMSSP_STATE *ntlmssp_state);

/* The following definitions come from libsmb/passchange.c  */

BOOL remote_password_change(const char *remote_machine, const char *user_name, 
			    const char *old_passwd, const char *new_passwd,
			    char *err_str, size_t err_str_len);

/* The following definitions come from libsmb/pwd_cache.c  */

void pwd_set_cleartext(struct pwd_info *pwd, const char *clr);
void pwd_get_cleartext(struct pwd_info *pwd, fstring clr);

/* The following definitions come from libsmb/samlogon_cache.c  */

BOOL netsamlogon_cache_init(void);
BOOL netsamlogon_cache_shutdown(void);
void netsamlogon_clear_cached_user(TDB_CONTEXT *tdb, NET_USER_INFO_3 *user);
BOOL netsamlogon_cache_store(TALLOC_CTX *mem_ctx, const char * username, NET_USER_INFO_3 *user);
NET_USER_INFO_3* netsamlogon_cache_get( TALLOC_CTX *mem_ctx, const DOM_SID *user_sid);
BOOL netsamlogon_cache_have(const DOM_SID *user_sid);

/* The following definitions come from libsmb/smb_signing.c  */

BOOL cli_simple_set_signing(struct cli_state *cli,
			    const DATA_BLOB user_session_key,
			    const DATA_BLOB response);
void cli_signing_trans_start(struct cli_state *cli, uint16 mid);
void cli_signing_trans_stop(struct cli_state *cli);
BOOL cli_null_set_signing(struct cli_state *cli);
BOOL cli_temp_set_signing(struct cli_state *cli);
void cli_free_signing_context(struct cli_state *cli);
void cli_calculate_sign_mac(struct cli_state *cli);
BOOL cli_check_sign_mac(struct cli_state *cli) ;
BOOL srv_oplock_set_signing(BOOL onoff);
BOOL srv_check_sign_mac(char *inbuf, BOOL must_be_ok);
void srv_calculate_sign_mac(char *outbuf);
void srv_defer_sign_response(uint16 mid);
void srv_cancel_sign_response(uint16 mid);
void srv_set_signing_negotiated(void);
BOOL srv_is_signing_active(void);
BOOL srv_is_signing_negotiated(void);
BOOL srv_signing_started(void);
void srv_signing_trans_start(uint16 mid);
void srv_signing_trans_stop(void);
void srv_set_signing(const DATA_BLOB user_session_key, const DATA_BLOB response);

/* The following definitions come from libsmb/smbdes.c  */

void des_crypt56(unsigned char *out, const unsigned char *in, const unsigned char *key, int forw);
void E_P16(const unsigned char *p14,unsigned char *p16);
void E_P24(const unsigned char *p21, const unsigned char *c8, unsigned char *p24);
void D_P16(const unsigned char *p14, const unsigned char *in, unsigned char *out);
void E_old_pw_hash( unsigned char *p14, const unsigned char *in, unsigned char *out);
void cred_hash1(unsigned char *out, const unsigned char *in, const unsigned char *key);
void cred_hash2(unsigned char *out, const unsigned char *in, const unsigned char *key);
void cred_hash3(unsigned char *out, unsigned char *in, const unsigned char *key, int forw);
void SamOEMhash( unsigned char *data, const unsigned char *key, int val);
void SamOEMhashBlob( unsigned char *data, int len, DATA_BLOB *key);
void sam_pwd_hash(unsigned int rid, const uchar *in, uchar *out, int forw);

/* The following definitions come from libsmb/smbencrypt.c  */

BOOL SMBencrypt(const char *passwd, const uchar *c8, uchar p24[24]);
void E_md4hash(const char *passwd, uchar p16[16]);
void E_md5hash(const uchar salt[16], const uchar nthash[16], uchar hash_out[16]);
BOOL E_deshash(const char *passwd, uchar p16[16]);
void nt_lm_owf_gen(const char *pwd, uchar nt_p16[16], uchar p16[16]);
BOOL ntv2_owf_gen(const uchar owf[16],
		  const char *user_in, const char *domain_in,
		  BOOL upper_case_domain, /* Transform the domain into UPPER case */
		  uchar kr_buf[16]);
void SMBOWFencrypt(const uchar passwd[16], const uchar *c8, uchar p24[24]);
void NTLMSSPOWFencrypt(const uchar passwd[8], const uchar *ntlmchalresp, uchar p24[24]);
void SMBNTencrypt(const char *passwd, uchar *c8, uchar *p24);
void SMBOWFencrypt_ntv2(const uchar kr[16],
			const DATA_BLOB *srv_chal,
			const DATA_BLOB *cli_chal,
			uchar resp_buf[16]);
void SMBsesskeygen_ntv2(const uchar kr[16],
			const uchar * nt_resp, uint8 sess_key[16]);
void SMBsesskeygen_ntv1(const uchar kr[16],
			const uchar * nt_resp, uint8 sess_key[16]);
void SMBsesskeygen_lmv1(const uchar lm_hash[16],
			const uchar lm_resp[24], /* only uses 8 */ 
			uint8 sess_key[16]);
void SMBsesskeygen_lm_sess_key(const uchar lm_hash[16],
			const uchar lm_resp[24], /* only uses 8 */ 
			uint8 sess_key[16]);
DATA_BLOB NTLMv2_generate_names_blob(const char *hostname, 
				     const char *domain);
BOOL SMBNTLMv2encrypt(const char *user, const char *domain, const char *password, 
		      const DATA_BLOB *server_chal, 
		      const DATA_BLOB *names_blob,
		      DATA_BLOB *lm_response, DATA_BLOB *nt_response, 
		      DATA_BLOB *user_session_key) ;
BOOL encode_pw_buffer(char buffer[516], const char *password, int string_flags);
BOOL decode_pw_buffer(uint8 in_buffer[516], char *new_pwrd,
		      int new_pwrd_size, uint32 *new_pw_len,
		      int string_flags);
void sess_crypt_blob(DATA_BLOB *out, const DATA_BLOB *in, const DATA_BLOB *session_key, int forward);
char *decrypt_trustdom_secret(const char *pass, DATA_BLOB *data_in);

/* The following definitions come from libsmb/smberr.c  */

const char *smb_dos_err_name(uint8 e_class, uint16 num);
const char *get_dos_error_msg(WERROR result);
const char *smb_dos_err_class(uint8 e_class);
char *smb_dos_errstr(char *inbuf);
WERROR map_werror_from_unix(int error);

/* The following definitions come from libsmb/spnego.c  */

ssize_t read_spnego_data(DATA_BLOB data, SPNEGO_DATA *token);
ssize_t write_spnego_data(DATA_BLOB *blob, SPNEGO_DATA *spnego);
BOOL free_spnego_data(SPNEGO_DATA *spnego);

/* The following definitions come from libsmb/trustdom_cache.c  */

BOOL trustdom_cache_enable(void);
BOOL trustdom_cache_shutdown(void);
BOOL trustdom_cache_store(char* name, char* alt_name, const DOM_SID *sid,
                          time_t timeout);
BOOL trustdom_cache_fetch(const char* name, DOM_SID* sid);
uint32 trustdom_cache_fetch_timestamp( void );
BOOL trustdom_cache_store_timestamp( uint32 t, time_t timeout );
BOOL trustdom_cache_lock_timestamp( void );
void trustdom_cache_unlock_timestamp( void );
void trustdom_cache_flush(void);
void update_trustdom_cache( void );

/* The following definitions come from libsmb/trusts_util.c  */

NTSTATUS trust_pw_change_and_store_it(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				      const char *domain,
				      unsigned char orig_trust_passwd_hash[16],
				      uint32 sec_channel_type);
NTSTATUS trust_pw_find_change_and_store_it(struct cli_state *cli, 
					   TALLOC_CTX *mem_ctx, 
					   const char *domain) ;
BOOL enumerate_domain_trusts( TALLOC_CTX *mem_ctx, const char *domain,
                                     char ***domain_names, uint32 *num_domains,
				     DOM_SID **sids );

/* The following definitions come from libsmb/unexpected.c  */

void unexpected_packet(struct packet_struct *p);
void clear_unexpected(time_t t);
struct packet_struct *receive_unexpected(enum packet_type packet_type, int id, 
					 const char *mailslot_name);

/* The following definitions come from locking/brlock.c  */

void brl_init(int read_only);
void brl_shutdown(int read_only);
NTSTATUS brl_lock(SMB_DEV_T dev, SMB_INO_T ino, int fnum,
		  uint16 smbpid, pid_t pid, uint16 tid,
		  br_off start, br_off size, 
		  enum brl_type lock_type, BOOL *my_lock_ctx);
BOOL brl_unlock(SMB_DEV_T dev, SMB_INO_T ino, int fnum,
		uint16 smbpid, pid_t pid, uint16 tid,
		br_off start, br_off size,
		BOOL remove_pending_locks_only,
		void (*pre_unlock_fn)(void *),
		void *pre_unlock_data);
BOOL brl_locktest(SMB_DEV_T dev, SMB_INO_T ino, int fnum,
		  uint16 smbpid, pid_t pid, uint16 tid,
		  br_off start, br_off size, 
		  enum brl_type lock_type);
void brl_close(SMB_DEV_T dev, SMB_INO_T ino, pid_t pid, int tid, int fnum);
int brl_forall(BRLOCK_FN(fn));

/* The following definitions come from locking/locking.c  */

BOOL is_locked(files_struct *fsp,connection_struct *conn,
	       SMB_BIG_UINT count,SMB_BIG_UINT offset, 
	       enum brl_type lock_type);
NTSTATUS do_lock_spin(files_struct *fsp,connection_struct *conn, uint16 lock_pid,
		 SMB_BIG_UINT count,SMB_BIG_UINT offset,enum brl_type lock_type, BOOL *my_lock_ctx);
NTSTATUS do_unlock(files_struct *fsp,connection_struct *conn, uint16 lock_pid,
		   SMB_BIG_UINT count,SMB_BIG_UINT offset);
void locking_close_file(files_struct *fsp);
BOOL locking_init(int read_only);
BOOL locking_end(void);
BOOL lock_share_entry(connection_struct *conn,
		      SMB_DEV_T dev, SMB_INO_T inode);
void unlock_share_entry(connection_struct *conn,
			SMB_DEV_T dev, SMB_INO_T inode);
BOOL lock_share_entry_fsp(files_struct *fsp);
void unlock_share_entry_fsp(files_struct *fsp);
char *share_mode_str(int num, share_mode_entry *e);
int get_share_modes(SMB_DEV_T dev, SMB_INO_T inode, 
		    share_mode_entry **pp_shares,
		    BOOL *delete_on_close);
BOOL get_delete_on_close_flag(SMB_DEV_T dev, SMB_INO_T inode);
BOOL share_modes_identical( share_mode_entry *e1, share_mode_entry *e2);
ssize_t del_share_entry(SMB_DEV_T dev, SMB_INO_T inode,
			share_mode_entry *entry, share_mode_entry **ppse,
			BOOL *delete_on_close);
ssize_t del_share_mode(files_struct *fsp, share_mode_entry **ppse,
		       BOOL *delete_on_close);
BOOL set_share_mode(files_struct *fsp, uint16 port, uint16 op_type);
BOOL remove_share_oplock(files_struct *fsp);
BOOL downgrade_share_oplock(files_struct *fsp);
BOOL modify_delete_flag( SMB_DEV_T dev, SMB_INO_T inode, BOOL delete_on_close);
char *deferred_open_str(int num, deferred_open_entry *e);
int get_deferred_opens(connection_struct *conn, 
		    SMB_DEV_T dev, SMB_INO_T inode, 
		    deferred_open_entry **pp_de_entries);
BOOL delete_deferred_open_entry(deferred_open_entry *entry);
BOOL add_deferred_open(uint16 mid, struct timeval *ptv, SMB_DEV_T dev, SMB_INO_T inode, uint16 port, const char *fname);
int share_mode_forall(SHAREMODE_FN(fn));

/* The following definitions come from locking/posix.c  */

int fd_close_posix(struct connection_struct *conn, files_struct *fsp);
BOOL is_posix_locked(files_struct *fsp, SMB_BIG_UINT u_offset, SMB_BIG_UINT u_count, enum brl_type lock_type);
BOOL set_posix_lock(files_struct *fsp, SMB_BIG_UINT u_offset, SMB_BIG_UINT u_count, enum brl_type lock_type);
BOOL release_posix_lock(files_struct *fsp, SMB_BIG_UINT u_offset, SMB_BIG_UINT u_count);
void posix_locking_close_file(files_struct *fsp);
BOOL posix_locking_init(int read_only);
BOOL posix_locking_end(void);

/* The following definitions come from nmbd/asyncdns.c  */

int asyncdns_fd(void);
void kill_async_dns_child(void);
void start_async_dns(void);
void run_dns_queue(void);
BOOL queue_dns_query(struct packet_struct *p,struct nmb_name *question,
		     struct name_record **n);
BOOL queue_dns_query(struct packet_struct *p,struct nmb_name *question,
		     struct name_record **n);
void kill_async_dns_child(void);

/* The following definitions come from nmbd/nmbd.c  */


/* The following definitions come from nmbd/nmbd_become_dmb.c  */

void add_domain_names(time_t t);

/* The following definitions come from nmbd/nmbd_become_lmb.c  */

void insert_permanent_name_into_unicast( struct subnet_record *subrec, 
                                                struct nmb_name *nmbname, uint16 nb_type );
void unbecome_local_master_browser(struct subnet_record *subrec, struct work_record *work,
                                   BOOL force_new_election);
void become_local_master_browser(struct subnet_record *subrec, struct work_record *work);
void set_workgroup_local_master_browser_name( struct work_record *work, const char *newname);

/* The following definitions come from nmbd/nmbd_browserdb.c  */

void update_browser_death_time( struct browse_cache_record *browc );
struct browse_cache_record *create_browser_in_lmb_cache( const char *work_name, 
                                                         const char *browser_name, 
                                                         struct in_addr ip );
struct browse_cache_record *find_browser_in_lmb_cache( const char *browser_name );
void expire_lmb_browsers( time_t t );

/* The following definitions come from nmbd/nmbd_browsesync.c  */

void dmb_expire_and_sync_browser_lists(time_t t);
void announce_and_sync_with_domain_master_browser( struct subnet_record *subrec,
                                                   struct work_record *work);
void collect_all_workgroup_names_from_wins_server(time_t t);
void sync_all_dmbs(time_t t);

/* The following definitions come from nmbd/nmbd_elections.c  */

void check_master_browser_exists(time_t t);
void run_elections(time_t t);
void process_election(struct subnet_record *subrec, struct packet_struct *p, char *buf);
BOOL check_elections(void);
void nmbd_message_election(int msg_type, pid_t src, void *buf, size_t len);

/* The following definitions come from nmbd/nmbd_incomingdgrams.c  */

void tell_become_backup(void);
void process_host_announce(struct subnet_record *subrec, struct packet_struct *p, char *buf);
void process_workgroup_announce(struct subnet_record *subrec, struct packet_struct *p, char *buf);
void process_local_master_announce(struct subnet_record *subrec, struct packet_struct *p, char *buf);
void process_master_browser_announce(struct subnet_record *subrec, 
                                     struct packet_struct *p,char *buf);
void process_lm_host_announce(struct subnet_record *subrec, struct packet_struct *p, char *buf);
void process_get_backup_list_request(struct subnet_record *subrec,
                                     struct packet_struct *p,char *buf);
void process_reset_browser(struct subnet_record *subrec,
                                  struct packet_struct *p,char *buf);
void process_announce_request(struct subnet_record *subrec, struct packet_struct *p, char *buf);
void process_lm_announce_request(struct subnet_record *subrec, struct packet_struct *p, char *buf);

/* The following definitions come from nmbd/nmbd_incomingrequests.c  */

void process_name_release_request(struct subnet_record *subrec, 
                                  struct packet_struct *p);
void process_name_refresh_request(struct subnet_record *subrec,
                                  struct packet_struct *p);
void process_name_registration_request(struct subnet_record *subrec, 
                                       struct packet_struct *p);
void process_node_status_request(struct subnet_record *subrec, struct packet_struct *p);
void process_name_query_request(struct subnet_record *subrec, struct packet_struct *p);

/* The following definitions come from nmbd/nmbd_lmhosts.c  */

void load_lmhosts_file(char *fname);
BOOL find_name_in_lmhosts(struct nmb_name *nmbname, struct name_record **namerecp);

/* The following definitions come from nmbd/nmbd_logonnames.c  */

void add_logon_names(void);

/* The following definitions come from nmbd/nmbd_mynames.c  */

void register_my_workgroup_one_subnet(struct subnet_record *subrec);
BOOL register_my_workgroup_and_names(void);
void release_wins_names(void);
void refresh_my_names(time_t t);

/* The following definitions come from nmbd/nmbd_namelistdb.c  */

void set_samba_nb_type(void);
void remove_name_from_namelist( struct subnet_record *subrec, 
                                struct name_record   *namerec );
struct name_record *find_name_on_subnet( struct subnet_record *subrec,
                                         struct nmb_name      *nmbname,
                                         BOOL                  self_only );
struct name_record *find_name_for_remote_broadcast_subnet(
                                                   struct nmb_name *nmbname,
                                                   BOOL             self_only );
void update_name_ttl( struct name_record *namerec, int ttl );
struct name_record *add_name_to_subnet( struct subnet_record *subrec,
                                        const char           *name,
                                        int                   type,
                                        uint16                nb_flags,
                                        int                   ttl,
                                        enum name_source      source,
                                        int                   num_ips,
                                        struct in_addr       *iplist);
void standard_success_register(struct subnet_record *subrec, 
                             struct userdata_struct *userdata,
                             struct nmb_name *nmbname, uint16 nb_flags, int ttl,
                             struct in_addr registered_ip);
void standard_fail_register( struct subnet_record   *subrec,
                             struct response_record *rrec,
                             struct nmb_name        *nmbname );
BOOL find_ip_in_name_record( struct name_record *namerec, struct in_addr ip );
void add_ip_to_name_record( struct name_record *namerec, struct in_addr new_ip );
void remove_ip_from_name_record( struct name_record *namerec,
                                 struct in_addr      remove_ip );
void standard_success_release( struct subnet_record   *subrec,
                               struct userdata_struct *userdata,
                               struct nmb_name        *nmbname,
                               struct in_addr          released_ip );
void expire_names_on_subnet(struct subnet_record *subrec, time_t t);
void expire_names(time_t t);
void add_samba_names_to_subnet( struct subnet_record *subrec );
void dump_all_namelists(void);

/* The following definitions come from nmbd/nmbd_namequery.c  */

BOOL query_name(struct subnet_record *subrec, const char *name, int type,
                   query_name_success_function success_fn,
                   query_name_fail_function fail_fn, 
                   struct userdata_struct *userdata);
BOOL query_name_from_wins_server(struct in_addr ip_to, 
                   const char *name, int type,
                   query_name_success_function success_fn,
                   query_name_fail_function fail_fn, 
                   struct userdata_struct *userdata);

/* The following definitions come from nmbd/nmbd_nameregister.c  */

void register_name(struct subnet_record *subrec,
                   const char *name, int type, uint16 nb_flags,
                   register_name_success_function success_fn,
                   register_name_fail_function fail_fn,
                   struct userdata_struct *userdata);
void wins_refresh_name(struct name_record *namerec);

/* The following definitions come from nmbd/nmbd_namerelease.c  */

void release_name(struct subnet_record *subrec, struct name_record *namerec,
		  release_name_success_function success_fn,
		  release_name_fail_function fail_fn,
		  struct userdata_struct *userdata);

/* The following definitions come from nmbd/nmbd_nodestatus.c  */

BOOL node_status(struct subnet_record *subrec, struct nmb_name *nmbname,
                 struct in_addr send_ip, node_status_success_function success_fn, 
                 node_status_fail_function fail_fn, struct userdata_struct *userdata);

/* The following definitions come from nmbd/nmbd_packets.c  */

uint16 get_nb_flags(char *buf);
void set_nb_flags(char *buf, uint16 nb_flags);
struct response_record *queue_register_name( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          register_name_success_function success_fn,
                          register_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname,
                          uint16 nb_flags);
void queue_wins_refresh(struct nmb_name *nmbname,
			response_function resp_fn,
			timeout_response_function timeout_fn,
			uint16 nb_flags,
			struct in_addr refresh_ip,
			const char *tag);
struct response_record *queue_register_multihomed_name( struct subnet_record *subrec,
							response_function resp_fn,
							timeout_response_function timeout_fn,
							register_name_success_function success_fn,
							register_name_fail_function fail_fn,
							struct userdata_struct *userdata,
							struct nmb_name *nmbname,
							uint16 nb_flags,
							struct in_addr register_ip,
							struct in_addr wins_ip);
struct response_record *queue_release_name( struct subnet_record *subrec,
					    response_function resp_fn,
					    timeout_response_function timeout_fn,
					    release_name_success_function success_fn,
					    release_name_fail_function fail_fn,
					    struct userdata_struct *userdata,
					    struct nmb_name *nmbname,
					    uint16 nb_flags,
					    struct in_addr release_ip,
					    struct in_addr dest_ip);
struct response_record *queue_query_name( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          query_name_success_function success_fn,
                          query_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname);
struct response_record *queue_query_name_from_wins_server( struct in_addr to_ip,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          query_name_success_function success_fn,
                          query_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname);
struct response_record *queue_node_status( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          node_status_success_function success_fn,
                          node_status_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname,
                          struct in_addr send_ip);
void reply_netbios_packet(struct packet_struct *orig_packet,
                          int rcode, enum netbios_reply_type_code rcv_code, int opcode,
                          int ttl, char *data,int len);
void run_packet_queue(void);
void retransmit_or_expire_response_records(time_t t);
BOOL listen_for_packets(BOOL run_election);
BOOL send_mailslot(BOOL unique, const char *mailslot,char *buf, size_t len,
                   const char *srcname, int src_type,
                   const char *dstname, int dest_type,
                   struct in_addr dest_ip,struct in_addr src_ip,
		   int dest_port);

/* The following definitions come from nmbd/nmbd_processlogon.c  */

void process_logon_packet(struct packet_struct *p, char *buf,int len, 
                          const char *mailslot);

/* The following definitions come from nmbd/nmbd_responserecordsdb.c  */

void remove_response_record(struct subnet_record *subrec,
				struct response_record *rrec);
struct response_record *make_response_record( struct subnet_record *subrec,
					      struct packet_struct *p,
					      response_function resp_fn,
					      timeout_response_function timeout_fn,
					      success_function success_fn,
					      fail_function fail_fn,
					      struct userdata_struct *userdata);
struct response_record *find_response_record(struct subnet_record **ppsubrec,
				uint16 id);
BOOL is_refresh_already_queued(struct subnet_record *subrec, struct name_record *namerec);

/* The following definitions come from nmbd/nmbd_sendannounce.c  */

void send_browser_reset(int reset_type, const char *to_name, int to_type, struct in_addr to_ip);
void broadcast_announce_request(struct subnet_record *subrec, struct work_record *work);
void announce_my_server_names(time_t t);
void announce_my_lm_server_names(time_t t);
void reset_announce_timer(void);
void announce_myself_to_domain_master_browser(time_t t);
void announce_my_servers_removed(void);
void announce_remote(time_t t);
void browse_sync_remote(time_t t);

/* The following definitions come from nmbd/nmbd_serverlistdb.c  */

void remove_all_servers(struct work_record *work);
struct server_record *find_server_in_workgroup(struct work_record *work, const char *name);
void remove_server_from_workgroup(struct work_record *work, struct server_record *servrec);
struct server_record *create_server_on_workgroup(struct work_record *work,
                                                 const char *name,int servertype, 
                                                 int ttl, const char *comment);
void update_server_ttl(struct server_record *servrec, int ttl);
void expire_servers(struct work_record *work, time_t t);
void write_browse_list_entry(XFILE *fp, const char *name, uint32 rec_type,
		const char *local_master_browser_name, const char *description);
void write_browse_list(time_t t, BOOL force_write);

/* The following definitions come from nmbd/nmbd_subnetdb.c  */

void close_subnet(struct subnet_record *subrec);
struct subnet_record *make_normal_subnet(struct interface *iface);
BOOL create_subnets(void);
BOOL we_are_a_wins_client(void);
struct subnet_record *get_next_subnet_maybe_unicast(struct subnet_record *subrec);
struct subnet_record *get_next_subnet_maybe_unicast_or_wins_server(struct subnet_record *subrec);

/* The following definitions come from nmbd/nmbd_synclists.c  */

void sync_browse_lists(struct work_record *work,
		       char *name, int nm_type, 
		       struct in_addr ip, BOOL local, BOOL servers);
void sync_check_completion(void);

/* The following definitions come from nmbd/nmbd_winsproxy.c  */

void make_wins_proxy_name_query_request( struct subnet_record *subrec, 
                                         struct packet_struct *incoming_packet,
                                         struct nmb_name *question_name);

/* The following definitions come from nmbd/nmbd_winsserver.c  */

BOOL packet_is_for_wins_server(struct packet_struct *packet);
BOOL initialise_wins(void);
void wins_process_name_refresh_request( struct subnet_record *subrec,
                                        struct packet_struct *p );
void wins_process_name_registration_request(struct subnet_record *subrec,
                                            struct packet_struct *p);
void wins_process_multihomed_name_registration_request( struct subnet_record *subrec,
                                                        struct packet_struct *p);
void send_wins_name_query_response(int rcode, struct packet_struct *p, 
                                          struct name_record *namerec);
void wins_process_name_query_request(struct subnet_record *subrec, 
                                     struct packet_struct *p);
void wins_process_name_release_request(struct subnet_record *subrec,
                                       struct packet_struct *p);
void initiate_wins_processing(time_t t);
void wins_write_database(BOOL background);
void nmbd_wins_new_entry(int msg_type, pid_t src, void *buf, size_t len);

/* The following definitions come from nmbd/nmbd_workgroupdb.c  */

struct work_record *find_workgroup_on_subnet(struct subnet_record *subrec, 
                                             const char *name);
struct work_record *create_workgroup_on_subnet(struct subnet_record *subrec,
                                               const char *name, int ttl);
void update_workgroup_ttl(struct work_record *work, int ttl);
void initiate_myworkgroup_startup(struct subnet_record *subrec, struct work_record *work);
void dump_workgroups(BOOL force_write);
void expire_workgroups_and_servers(time_t t);

/* The following definitions come from nsswitch/wb_client.c  */

NSS_STATUS winbindd_request_response(int req_type,
                                 struct winbindd_request *request,
                                 struct winbindd_response *response);

/* Call winbindd to convert a name to a sid */

BOOL winbind_lookup_name(const char *dom_name, const char *name, DOM_SID *sid, 
                         enum SID_NAME_USE *name_type);
BOOL winbind_lookup_sid(const DOM_SID *sid, 
			fstring dom_name, fstring name, 
                        enum SID_NAME_USE *name_type);
BOOL winbind_sid_to_uid(uid_t *puid, const DOM_SID *sid);
BOOL winbind_uid_to_sid(DOM_SID *sid, uid_t uid);
BOOL winbind_sid_to_gid(gid_t *pgid, const DOM_SID *sid);
BOOL winbind_gid_to_sid(DOM_SID *sid, gid_t gid);
BOOL winbind_allocate_rid(uint32 *rid);
BOOL winbind_allocate_rid_and_gid(uint32 *rid, gid_t *gid);
int winbind_initgroups(char *user, gid_t gid);
int winbind_getgroups(const char *user, gid_t **list);
BOOL winbind_ping( void );
NSS_STATUS wb_is_trusted_domain(const char *domain);

/* The following definitions come from nsswitch/wb_common.c  */

void free_response(struct winbindd_response *response);
void init_request(struct winbindd_request *request, int request_type);
void init_response(struct winbindd_response *response);
void close_sock(void);
int write_sock(void *buffer, int count, int recursing);
int read_reply(struct winbindd_response *response);
NSS_STATUS winbindd_send_request(int req_type, struct winbindd_request *request);
NSS_STATUS winbindd_get_response(struct winbindd_response *response);
NSS_STATUS winbindd_request_response(int req_type, 
			    struct winbindd_request *request,
			    struct winbindd_response *response);
BOOL winbind_off( void );
BOOL winbind_on( void );

/* The following definitions come from param/loadparm.c  */

void lp_talloc_free(void);
char *lp_smb_ports(void);
char *lp_dos_charset(void);
char *lp_unix_charset(void);
char *lp_display_charset(void);
char *lp_logfile(void);
char *lp_configfile(void);
char *lp_smb_passwd_file(void);
char *lp_private_dir(void);
char *lp_serverstring(void);
int lp_printcap_cache_time(void);
char *lp_enumports_cmd(void);
char *lp_addprinter_cmd(void);
char *lp_deleteprinter_cmd(void);
char *lp_os2_driver_map(void);
char *lp_lockdir(void);
char *lp_piddir(void);
char *lp_mangling_method(void);
int lp_mangle_prefix(void);
char *lp_utmpdir(void);
char *lp_wtmpdir(void);
BOOL lp_utmp(void);
char *lp_rootdir(void);
char *lp_defaultservice(void);
char *lp_msg_command(void);
char *lp_dfree_command(void);
char *lp_get_quota_command(void);
char *lp_set_quota_command(void);
char *lp_hosts_equiv(void);
char *lp_auto_services(void);
char *lp_passwd_program(void);
char *lp_passwd_chat(void);
char *lp_passwordserver(void);
char *lp_name_resolve_order(void);
char *lp_realm(void);
const char *lp_afs_username_map(void);
int lp_afs_token_lifetime(void);
char *lp_log_nt_token_command(void);
char *lp_username_map(void);
const char *lp_logon_script(void);
const char *lp_logon_path(void);
const char *lp_logon_drive(void);
const char *lp_logon_home(void);
char *lp_remote_announce(void);
char *lp_remote_browse_sync(void);
const char **lp_wins_server_list(void);
const char **lp_interfaces(void);
char *lp_socket_address(void);
char *lp_nis_home_map_name(void);
const char **lp_netbios_aliases(void);
const char **lp_passdb_backend(void);
const char **lp_preload_modules(void);
char *lp_panic_action(void);
char *lp_adduser_script(void);
char *lp_deluser_script(void);
const char *lp_guestaccount(void);
char *lp_addgroup_script(void);
char *lp_delgroup_script(void);
char *lp_addusertogroup_script(void);
char *lp_deluserfromgroup_script(void);
char *lp_setprimarygroup_script(void);
char *lp_addmachine_script(void);
char *lp_shutdown_script(void);
char *lp_abort_shutdown_script(void);
char *lp_username_map_script(void);
char *lp_check_password_script(void);
char *lp_wins_hook(void);
char *lp_wins_partners(void);
const char *lp_template_homedir(void);
const char *lp_template_shell(void);
const char *lp_winbind_separator(void);
char *lp_acl_compatibility(void);
BOOL lp_winbind_enum_users(void);
BOOL lp_winbind_enum_groups(void);
BOOL lp_winbind_use_default_domain(void);
BOOL lp_winbind_trusted_domains_only(void);
BOOL lp_winbind_nested_groups(void);
const char **lp_idmap_backend(void);
BOOL lp_enable_rid_algorithm(void);
char *lp_ldap_server(void);
int lp_ldap_port(void);
char *lp_ldap_suffix(void);
char *lp_ldap_admin_dn(void);
int lp_ldap_ssl(void);
int lp_ldap_passwd_sync(void);
BOOL lp_ldap_delete_dn(void);
int lp_ldap_replication_sleep(void);
int lp_ldap_timeout(void);
int lp_ldap_page_size(void);
char *lp_add_share_cmd(void);
char *lp_change_share_cmd(void);
char *lp_delete_share_cmd(void);
char *lp_eventlog_open_cmd(void);
char *lp_eventlog_read_cmd(void);
char *lp_eventlog_clear_cmd(void);
char *lp_eventlog_num_records_cmd(void);
char *lp_eventlog_oldest_record_cmd(void);
char *lp_eventlog_close_cmd(void);
const char **lp_eventlog_list(void);
BOOL lp_disable_netbios(void);
BOOL lp_ms_add_printer_wizard(void);
BOOL lp_dns_proxy(void);
BOOL lp_wins_support(void);
BOOL lp_we_are_a_wins_server(void);
BOOL lp_wins_proxy(void);
BOOL lp_local_master(void);
BOOL lp_domain_logons(void);
BOOL lp_load_printers(void);
BOOL lp_readbmpx(void);
BOOL lp_readraw(void);
BOOL lp_large_readwrite(void);
BOOL lp_writeraw(void);
BOOL lp_null_passwords(void);
BOOL lp_obey_pam_restrictions(void);
BOOL lp_encrypted_passwords(void);
BOOL lp_update_encrypted(void);
int lp_client_schannel(void);
int lp_server_schannel(void);
BOOL lp_syslog_only(void);
BOOL lp_timestamp_logs(void);
BOOL lp_debug_hires_timestamp(void);
BOOL lp_debug_pid(void);
BOOL lp_debug_uid(void);
BOOL lp_browse_list(void);
BOOL lp_nis_home_map(void);
BOOL lp_bind_interfaces_only(void);
BOOL lp_pam_password_change(void);
BOOL lp_unix_password_sync(void);
BOOL lp_passwd_chat_debug(void);
int lp_passwd_chat_timeout(void);
BOOL lp_nt_pipe_support(void);
BOOL lp_nt_status_support(void);
BOOL lp_stat_cache(void);
int lp_max_stat_cache_size(void);
BOOL lp_allow_trusted_domains(void);
int lp_restrict_anonymous(void);
BOOL lp_lanman_auth(void);
BOOL lp_ntlm_auth(void);
BOOL lp_client_plaintext_auth(void);
BOOL lp_client_lanman_auth(void);
BOOL lp_client_ntlmv2_auth(void);
BOOL lp_host_msdfs(void);
BOOL lp_kernel_oplocks(void);
BOOL lp_enhanced_browsing(void);
BOOL lp_use_mmap(void);
BOOL lp_unix_extensions(void);
BOOL lp_use_spnego(void);
BOOL lp_client_use_spnego(void);
BOOL lp_hostname_lookups(void);
BOOL lp_kernel_change_notify(void);
BOOL lp_use_kerberos_keytab(void);
BOOL lp_defer_sharing_violations(void);
BOOL lp_enable_privileges(void);
BOOL lp_enable_asu_support(void);
int lp_os_level(void);
int lp_max_ttl(void);
int lp_max_wins_ttl(void);
int lp_min_wins_ttl(void);
int lp_max_log_size(void);
int lp_max_open_files(void);
int lp_maxxmit(void);
int lp_maxmux(void);
int lp_passwordlevel(void);
int lp_usernamelevel(void);
int lp_deadtime(void);
int lp_maxprotocol(void);
int lp_minprotocol(void);
int lp_security(void);
const char **lp_auth_methods(void);
BOOL lp_paranoid_server_security(void);
int lp_maxdisksize(void);
int lp_lpqcachetime(void);
int lp_max_smbd_processes(void);
int _lp_disable_spoolss(void);
int lp_syslog(void);
int lp_lm_announce(void);
int lp_lm_interval(void);
int lp_machine_password_timeout(void);
int lp_change_notify_timeout(void);
int lp_map_to_guest(void);
int lp_oplock_break_wait_time(void);
int lp_lock_spin_count(void);
int lp_lock_sleep_time(void);
char *lp_preexec(int );
char *lp_postexec(int );
char *lp_rootpreexec(int );
char *lp_rootpostexec(int );
char *lp_servicename(int );
const char *lp_const_servicename(int );
char *lp_pathname(int );
char *lp_dontdescend(int );
char *lp_username(int );
const char **lp_invalid_users(int );
const char **lp_valid_users(int );
const char **lp_admin_users(int );
const char **lp_enable_svcctl(void);
char *lp_cups_options(int );
char *lp_cups_server(void);
char *lp_printcommand(int );
char *lp_lpqcommand(int );
char *lp_lprmcommand(int );
char *lp_lppausecommand(int );
char *lp_lpresumecommand(int );
char *lp_queuepausecommand(int );
char *lp_queueresumecommand(int );
const char **lp_hostsallow(int );
const char **lp_hostsdeny(int );
char *lp_magicscript(int );
char *lp_magicoutput(int );
char *lp_comment(int );
char *lp_force_user(int );
char *lp_force_group(int );
const char **lp_readlist(int );
const char **lp_writelist(int );
const char **lp_printer_admin(int );
char *lp_fstype(int );
const char **lp_vfs_objects(int );
char *lp_msdfs_proxy(int );
char *lp_mangled_map(int );
char *lp_veto_files(int );
char *lp_hide_files(int );
char *lp_veto_oplocks(int );
BOOL lp_msdfs_root(int );
char *lp_aio_write_behind(int );
BOOL lp_autoloaded(int );
BOOL lp_preexec_close(int );
BOOL lp_rootpreexec_close(int );
int lp_casesensitive(int );
BOOL lp_preservecase(int );
BOOL lp_shortpreservecase(int );
BOOL lp_hide_dot_files(int );
BOOL lp_hide_special_files(int );
BOOL lp_hideunreadable(int );
BOOL lp_hideunwriteable_files(int );
BOOL lp_browseable(int );
BOOL lp_readonly(int );
BOOL lp_no_set_dir(int );
BOOL lp_guest_ok(int );
BOOL lp_guest_only(int );
BOOL lp_print_ok(int );
BOOL lp_map_hidden(int );
BOOL lp_map_archive(int );
BOOL lp_store_dos_attributes(int );
BOOL lp_locking(int );
int lp_strict_locking(int );
BOOL lp_posix_locking(int );
BOOL lp_share_modes(int );
BOOL lp_oplocks(int );
BOOL lp_level2_oplocks(int );
BOOL lp_onlyuser(int );
BOOL lp_manglednames(int );
BOOL lp_widelinks(int );
BOOL lp_symlinks(int );
BOOL lp_syncalways(int );
BOOL lp_strict_allocate(int );
BOOL lp_strict_sync(int );
BOOL lp_map_system(int );
BOOL lp_delete_readonly(int );
BOOL lp_fake_oplocks(int );
BOOL lp_recursive_veto_delete(int );
BOOL lp_dos_filemode(int );
BOOL lp_dos_filetimes(int );
BOOL lp_dos_filetime_resolution(int );
BOOL lp_fake_dir_create_times(int );
BOOL lp_blocking_locks(int );
BOOL lp_inherit_perms(int );
BOOL lp_inherit_acls(int );
BOOL lp_inherit_owner(int );
BOOL lp_use_client_driver(int );
BOOL lp_default_devmode(int );
BOOL lp_force_printername(int );
BOOL lp_nt_acl_support(int );
BOOL lp_force_unknown_acl_user(int );
BOOL lp_ea_support(int );
BOOL _lp_use_sendfile(int );
BOOL lp_profile_acls(int );
BOOL lp_map_acl_inherit(int );
BOOL lp_afs_share(int );
BOOL lp_acl_check_permissions(int );
BOOL lp_acl_group_control(int );
BOOL lp_acl_map_full_control(int );
int lp_create_mask(int );
int lp_force_create_mode(int );
int lp_security_mask(int );
int lp_force_security_mode(int );
int lp_dir_mask(int );
int lp_force_dir_mode(int );
int lp_dir_security_mask(int );
int lp_force_dir_security_mode(int );
int lp_max_connections(int );
int lp_defaultcase(int );
int lp_minprintspace(int );
int lp_printing(int );
int lp_max_reported_jobs(int );
int lp_oplock_contention_limit(int );
int lp_csc_policy(int );
int lp_write_cache_size(int );
int lp_block_size(int );
int lp_allocation_roundup_size(int );
int lp_aio_read_size(int );
int lp_aio_write_size(int );
char lp_magicchar(int );
int lp_winbind_cache_time(void);
int lp_winbind_max_idle_children(void);
const char **lp_winbind_nss_info(void);
int lp_algorithmic_rid_base(void);
int lp_name_cache_timeout(void);
int lp_client_signing(void);
int lp_server_signing(void);
char *lp_parm_talloc_string(int snum, const char *type, const char *option, const char *def);
const char *lp_parm_const_string(int snum, const char *type, const char *option, const char *def);
const char **lp_parm_string_list(int snum, const char *type, const char *option, const char **def);
int lp_parm_int(int snum, const char *type, const char *option, int def);
unsigned long lp_parm_ulong(int snum, const char *type, const char *option, unsigned long def);
BOOL lp_parm_bool(int snum, const char *type, const char *option, BOOL def);
int lp_parm_enum(int snum, const char *type, const char *option,
		 const struct enum_list *_enum, int def);
BOOL lp_add_home(const char *pszHomename, int iDefaultService, 
		 const char *user, const char *pszHomedir);
int lp_add_service(const char *pszService, int iDefaultService);
BOOL lp_add_printer(const char *pszPrintername, int iDefaultService);
void show_parameter_list(void);
BOOL lp_file_list_changed(void);
BOOL lp_idmap_uid(uid_t *low, uid_t *high);
BOOL lp_idmap_gid(gid_t *low, gid_t *high);
char *lp_ldap_machine_suffix(void);
char *lp_ldap_user_suffix(void);
char *lp_ldap_group_suffix(void);
char *lp_ldap_idmap_suffix(void);
void *lp_local_ptr(int snum, void *ptr);
BOOL lp_do_parameter(int snum, const char *pszParmName, const char *pszParmValue);
void init_locals(void);
BOOL lp_is_default(int snum, struct parm_struct *parm);
BOOL dump_a_parameter(int snum, char *parm_name, FILE * f, BOOL isGlobal);
struct parm_struct *lp_next_parameter(int snum, int *i, int allparameters);
BOOL lp_snum_ok(int iService);
void lp_add_one_printer(char *name, char *comment);
BOOL lp_loaded(void);
void lp_killunused(BOOL (*snumused) (int));
void lp_killservice(int iServiceIn);
BOOL lp_load(const char *pszFname, BOOL global_only, BOOL save_defaults,
	     BOOL add_ipc);
void lp_resetnumservices(void);
int lp_numservices(void);
void lp_dump(FILE *f, BOOL show_defaults, int maxtoprint);
void lp_dump_one(FILE * f, BOOL show_defaults, int snum);
int lp_servicenumber(const char *pszServiceName);
char *volume_label(int snum);
int lp_server_role(void);
BOOL lp_domain_master(void);
BOOL lp_preferred_master(void);
void lp_remove_service(int snum);
void lp_copy_service(int snum, const char *new_name);
int lp_default_server_announce(void);
int lp_major_announce_version(void);
int lp_minor_announce_version(void);
void lp_set_name_resolve_order(const char *new_order);
const char *lp_printername(int snum);
void get_private_directory(pstring privdir);
void lp_set_logfile(const char *name);
int lp_maxprintjobs(int snum);
const char *lp_printcapname(void);
BOOL lp_disable_spoolss( void );
void lp_set_spoolss_state( uint32 state );
uint32 lp_get_spoolss_state( void );
BOOL lp_use_sendfile(int snum);
void set_use_sendfile(int snum, BOOL val);
void set_store_dos_attributes(int snum, BOOL val);
void lp_set_mangling_method(const char *new_method);
BOOL lp_posix_pathnames(void);
void lp_set_posix_pathnames(void);

/* The following definitions come from param/params.c  */

BOOL pm_process( const char *FileName,
		BOOL (*sfunc)(const char *),
		BOOL (*pfunc)(const char *, const char *) );

/* The following definitions come from passdb/login_cache.c  */

BOOL login_cache_init(void);
BOOL login_cache_shutdown(void);
LOGIN_CACHE * login_cache_read(SAM_ACCOUNT *sampass);
BOOL login_cache_write(const SAM_ACCOUNT *sampass, LOGIN_CACHE entry);
BOOL login_cache_delentry(const SAM_ACCOUNT *sampass);

/* The following definitions come from passdb/lookup_sid.c  */

BOOL lookup_name(const char *domain, const char *name, DOM_SID *psid, enum SID_NAME_USE *name_type);
BOOL lookup_sid(const DOM_SID *sid, fstring dom_name, fstring name, enum SID_NAME_USE *name_type);
NTSTATUS uid_to_sid(DOM_SID *psid, uid_t uid);
NTSTATUS gid_to_sid(DOM_SID *psid, gid_t gid);
NTSTATUS sid_to_uid(const DOM_SID *psid, uid_t *puid);
NTSTATUS sid_to_gid(const DOM_SID *psid, gid_t *pgid);

/* The following definitions come from passdb/machine_sid.c  */

DOM_SID *get_global_sam_sid(void);
void reset_global_sam_sid(void) ;

/* The following definitions come from passdb/passdb.c  */

const char *get_default_sam_name(void);
void pdb_fill_default_sam(SAM_ACCOUNT *user);
NTSTATUS pdb_init_sam_talloc(TALLOC_CTX *mem_ctx, SAM_ACCOUNT **user);
NTSTATUS pdb_init_sam(SAM_ACCOUNT **user);
NTSTATUS pdb_fill_sam_pw(SAM_ACCOUNT *sam_account, const struct passwd *pwd);
NTSTATUS pdb_init_sam_pw(SAM_ACCOUNT **new_sam_acct, const struct passwd *pwd);
NTSTATUS pdb_init_sam_new(SAM_ACCOUNT **new_sam_acct, const char *username,
                          uint32 rid);
NTSTATUS pdb_reset_sam(SAM_ACCOUNT *user);
NTSTATUS pdb_free_sam(SAM_ACCOUNT **user);
char *pdb_encode_acct_ctrl(uint16 acct_ctrl, size_t length);
uint16 pdb_decode_acct_ctrl(const char *p);
void pdb_sethexpwd(char *p, const unsigned char *pwd, uint16 acct_ctrl);
BOOL pdb_gethexpwd(const char *p, unsigned char *pwd);
void pdb_sethexhours(char *p, const unsigned char *hours);
BOOL pdb_gethexhours(const char *p, unsigned char *hours);
int algorithmic_rid_base(void);
uid_t algorithmic_pdb_user_rid_to_uid(uint32 user_rid);
uint32 algorithmic_pdb_uid_to_user_rid(uid_t uid);
gid_t pdb_group_rid_to_gid(uint32 group_rid);
uint32 pdb_gid_to_group_rid(gid_t gid);
BOOL algorithmic_pdb_rid_is_user(uint32 rid);
BOOL local_lookup_sid(const DOM_SID *sid, char *name, enum SID_NAME_USE *psid_name_use);
BOOL local_lookup_name(const char *c_user, DOM_SID *psid, enum SID_NAME_USE *psid_name_use);
BOOL local_password_change(const char *user_name, int local_flags,
			   const char *new_passwd, 
			   char *err_str, size_t err_str_len,
			   char *msg_str, size_t msg_str_len);
DOM_SID *algorithmic_uid_to_sid(DOM_SID *psid, uid_t uid);
DOM_SID *local_uid_to_sid(DOM_SID *psid, uid_t uid);
BOOL local_sid_to_uid(uid_t *puid, const DOM_SID *psid, enum SID_NAME_USE *name_type);
DOM_SID *local_gid_to_sid(DOM_SID *psid, gid_t gid);
BOOL local_sid_to_gid(gid_t *pgid, const DOM_SID *psid, enum SID_NAME_USE *name_type);
BOOL init_sam_from_buffer(SAM_ACCOUNT *sampass, uint8 *buf, uint32 buflen);
uint32 init_buffer_from_sam (uint8 **buf, const SAM_ACCOUNT *sampass, BOOL size_only);
BOOL init_sam_from_buffer_v0(SAM_ACCOUNT *sampass, uint8 *buf, uint32 buflen);
BOOL init_sam_from_buffer_v1(SAM_ACCOUNT *sampass, uint8 *buf, uint32 buflen);
BOOL init_sam_from_buffer_v2(SAM_ACCOUNT *sampass, uint8 *buf, uint32 buflen);
uint32 init_buffer_from_sam_v2 (uint8 **buf, const SAM_ACCOUNT *sampass, BOOL size_only);
BOOL pdb_copy_sam_account(const SAM_ACCOUNT *src, SAM_ACCOUNT **dst);
BOOL get_free_rid_range(uint32 *low, uint32 *high);
BOOL pdb_update_bad_password_count(SAM_ACCOUNT *sampass, BOOL *updated);
BOOL pdb_update_autolock_flag(SAM_ACCOUNT *sampass, BOOL *updated);
BOOL pdb_increment_bad_password_count(SAM_ACCOUNT *sampass);

/* The following definitions come from passdb/pdb_compat.c  */

uint32 pdb_get_user_rid (const SAM_ACCOUNT *sampass);
uint32 pdb_get_group_rid (const SAM_ACCOUNT *sampass);
BOOL pdb_set_user_sid_from_rid (SAM_ACCOUNT *sampass, uint32 rid, enum pdb_value_state flag);
BOOL pdb_set_group_sid_from_rid (SAM_ACCOUNT *sampass, uint32 grid, enum pdb_value_state flag);

/* The following definitions come from passdb/pdb_get_set.c  */

uint16 pdb_get_acct_ctrl (const SAM_ACCOUNT *sampass);
time_t pdb_get_logon_time (const SAM_ACCOUNT *sampass);
time_t pdb_get_logoff_time (const SAM_ACCOUNT *sampass);
time_t pdb_get_kickoff_time (const SAM_ACCOUNT *sampass);
time_t pdb_get_bad_password_time (const SAM_ACCOUNT *sampass);
time_t pdb_get_pass_last_set_time (const SAM_ACCOUNT *sampass);
time_t pdb_get_pass_can_change_time (const SAM_ACCOUNT *sampass);
time_t pdb_get_pass_must_change_time (const SAM_ACCOUNT *sampass);
uint16 pdb_get_logon_divs (const SAM_ACCOUNT *sampass);
uint32 pdb_get_hours_len (const SAM_ACCOUNT *sampass);
const uint8* pdb_get_hours (const SAM_ACCOUNT *sampass);
const uint8* pdb_get_nt_passwd (const SAM_ACCOUNT *sampass);
const uint8* pdb_get_lanman_passwd (const SAM_ACCOUNT *sampass);
const uint8* pdb_get_pw_history (const SAM_ACCOUNT *sampass, uint32 *current_hist_len);
const char* pdb_get_plaintext_passwd (const SAM_ACCOUNT *sampass);
const DOM_SID *pdb_get_user_sid(const SAM_ACCOUNT *sampass);
const DOM_SID *pdb_get_group_sid(const SAM_ACCOUNT *sampass);
enum pdb_value_state pdb_get_init_flags (const SAM_ACCOUNT *sampass, enum pdb_elements element);
const char* pdb_get_username (const SAM_ACCOUNT *sampass);
const char* pdb_get_domain (const SAM_ACCOUNT *sampass);
const char* pdb_get_nt_username (const SAM_ACCOUNT *sampass);
const char* pdb_get_fullname (const SAM_ACCOUNT *sampass);
const char* pdb_get_homedir (const SAM_ACCOUNT *sampass);
const char* pdb_get_unix_homedir (const SAM_ACCOUNT *sampass);
const char* pdb_get_dir_drive (const SAM_ACCOUNT *sampass);
const char* pdb_get_logon_script (const SAM_ACCOUNT *sampass);
const char* pdb_get_profile_path (const SAM_ACCOUNT *sampass);
const char* pdb_get_acct_desc (const SAM_ACCOUNT *sampass);
const char* pdb_get_workstations (const SAM_ACCOUNT *sampass);
const char* pdb_get_unknown_str (const SAM_ACCOUNT *sampass);
const char* pdb_get_munged_dial (const SAM_ACCOUNT *sampass);
uint16 pdb_get_bad_password_count(const SAM_ACCOUNT *sampass);
uint16 pdb_get_logon_count(const SAM_ACCOUNT *sampass);
uint32 pdb_get_unknown_6 (const SAM_ACCOUNT *sampass);
void *pdb_get_backend_private_data (const SAM_ACCOUNT *sampass, const struct pdb_methods *my_methods);
BOOL pdb_set_acct_ctrl (SAM_ACCOUNT *sampass, uint16 acct_ctrl, enum pdb_value_state flag);
BOOL pdb_set_logon_time (SAM_ACCOUNT *sampass, time_t mytime, enum pdb_value_state flag);
BOOL pdb_set_logoff_time (SAM_ACCOUNT *sampass, time_t mytime, enum pdb_value_state flag);
BOOL pdb_set_kickoff_time (SAM_ACCOUNT *sampass, time_t mytime, enum pdb_value_state flag);
BOOL pdb_set_bad_password_time (SAM_ACCOUNT *sampass, time_t mytime, 
				enum pdb_value_state flag);
BOOL pdb_set_pass_can_change_time (SAM_ACCOUNT *sampass, time_t mytime, enum pdb_value_state flag);
BOOL pdb_set_pass_must_change_time (SAM_ACCOUNT *sampass, time_t mytime, enum pdb_value_state flag);
BOOL pdb_set_pass_last_set_time (SAM_ACCOUNT *sampass, time_t mytime, enum pdb_value_state flag);
BOOL pdb_set_hours_len (SAM_ACCOUNT *sampass, uint32 len, enum pdb_value_state flag);
BOOL pdb_set_logon_divs (SAM_ACCOUNT *sampass, uint16 hours, enum pdb_value_state flag);
BOOL pdb_set_init_flags (SAM_ACCOUNT *sampass, enum pdb_elements element, enum pdb_value_state value_flag);
BOOL pdb_set_user_sid (SAM_ACCOUNT *sampass, const DOM_SID *u_sid, enum pdb_value_state flag);
BOOL pdb_set_user_sid_from_string (SAM_ACCOUNT *sampass, fstring u_sid, enum pdb_value_state flag);
BOOL pdb_set_group_sid (SAM_ACCOUNT *sampass, const DOM_SID *g_sid, enum pdb_value_state flag);
BOOL pdb_set_group_sid_from_string (SAM_ACCOUNT *sampass, fstring g_sid, enum pdb_value_state flag);
BOOL pdb_set_username(SAM_ACCOUNT *sampass, const char *username, enum pdb_value_state flag);
BOOL pdb_set_domain(SAM_ACCOUNT *sampass, const char *domain, enum pdb_value_state flag);
BOOL pdb_set_nt_username(SAM_ACCOUNT *sampass, const char *nt_username, enum pdb_value_state flag);
BOOL pdb_set_fullname(SAM_ACCOUNT *sampass, const char *full_name, enum pdb_value_state flag);
BOOL pdb_set_logon_script(SAM_ACCOUNT *sampass, const char *logon_script, enum pdb_value_state flag);
BOOL pdb_set_profile_path (SAM_ACCOUNT *sampass, const char *profile_path, enum pdb_value_state flag);
BOOL pdb_set_dir_drive (SAM_ACCOUNT *sampass, const char *dir_drive, enum pdb_value_state flag);
BOOL pdb_set_homedir (SAM_ACCOUNT *sampass, const char *home_dir, enum pdb_value_state flag);
BOOL pdb_set_unix_homedir (SAM_ACCOUNT *sampass, const char *unix_home_dir, enum pdb_value_state flag);
BOOL pdb_set_acct_desc (SAM_ACCOUNT *sampass, const char *acct_desc, enum pdb_value_state flag);
BOOL pdb_set_workstations (SAM_ACCOUNT *sampass, const char *workstations, enum pdb_value_state flag);
BOOL pdb_set_unknown_str (SAM_ACCOUNT *sampass, const char *unknown_str, enum pdb_value_state flag);
BOOL pdb_set_munged_dial (SAM_ACCOUNT *sampass, const char *munged_dial, enum pdb_value_state flag);
BOOL pdb_set_nt_passwd (SAM_ACCOUNT *sampass, const uint8 pwd[NT_HASH_LEN], enum pdb_value_state flag);
BOOL pdb_set_lanman_passwd (SAM_ACCOUNT *sampass, const uint8 pwd[LM_HASH_LEN], enum pdb_value_state flag);
BOOL pdb_set_pw_history (SAM_ACCOUNT *sampass, const uint8 *pwd, uint32 historyLen, enum pdb_value_state flag);
BOOL pdb_set_plaintext_pw_only (SAM_ACCOUNT *sampass, const char *password, enum pdb_value_state flag);
BOOL pdb_set_bad_password_count(SAM_ACCOUNT *sampass, uint16 bad_password_count, enum pdb_value_state flag);
BOOL pdb_set_logon_count(SAM_ACCOUNT *sampass, uint16 logon_count, enum pdb_value_state flag);
BOOL pdb_set_unknown_6 (SAM_ACCOUNT *sampass, uint32 unkn, enum pdb_value_state flag);
BOOL pdb_set_hours (SAM_ACCOUNT *sampass, const uint8 *hours, enum pdb_value_state flag);
BOOL pdb_set_backend_private_data (SAM_ACCOUNT *sampass, void *private_data, 
				   void (*free_fn)(void **), 
				   const struct pdb_methods *my_methods, 
				   enum pdb_value_state flag);
BOOL pdb_set_pass_changed_now (SAM_ACCOUNT *sampass);
BOOL pdb_set_plaintext_passwd (SAM_ACCOUNT *sampass, const char *plaintext);
uint32 pdb_build_fields_present (SAM_ACCOUNT *sampass);

/* The following definitions come from passdb/pdb_guest.c  */

NTSTATUS pdb_init_guestsam(PDB_CONTEXT *pdb_context, PDB_METHODS **pdb_method, const char *location);
NTSTATUS pdb_guest_init(void);

/* The following definitions come from passdb/pdb_interface.c  */

NTSTATUS smb_register_passdb(int version, const char *name, pdb_init_function init) ;
NTSTATUS make_pdb_context_list(struct pdb_context **context, const char **selected) ;
NTSTATUS make_pdb_context_string(struct pdb_context **context, const char *selected) ;
BOOL pdb_setsampwent(BOOL update, uint16 acb_mask) ;
void pdb_endsampwent(void) ;
BOOL pdb_getsampwent(SAM_ACCOUNT *user) ;
BOOL pdb_getsampwnam(SAM_ACCOUNT *sam_acct, const char *username) ;
BOOL pdb_getsampwsid(SAM_ACCOUNT *sam_acct, const DOM_SID *sid) ;
BOOL pdb_add_sam_account(SAM_ACCOUNT *sam_acct) ;
BOOL pdb_update_sam_account(SAM_ACCOUNT *sam_acct) ;
BOOL pdb_delete_sam_account(SAM_ACCOUNT *sam_acct) ;
NTSTATUS pdb_update_login_attempts(SAM_ACCOUNT *sam_acct, BOOL success);
BOOL pdb_getgrsid(GROUP_MAP *map, DOM_SID sid);
BOOL pdb_getgrgid(GROUP_MAP *map, gid_t gid);
BOOL pdb_getgrnam(GROUP_MAP *map, const char *name);
BOOL pdb_add_group_mapping_entry(GROUP_MAP *map);
BOOL pdb_update_group_mapping_entry(GROUP_MAP *map);
BOOL pdb_delete_group_mapping_entry(DOM_SID sid);
BOOL pdb_enum_group_mapping(enum SID_NAME_USE sid_name_use, GROUP_MAP **rmap,
			    int *num_entries, BOOL unix_only);
NTSTATUS pdb_enum_group_members(TALLOC_CTX *mem_ctx,
				const DOM_SID *sid,
				uint32 **member_rids,
				int *num_members);
NTSTATUS pdb_enum_group_memberships(const char *username, gid_t primary_gid,
				    DOM_SID **sids, gid_t **gids,
				    int *num_groups);
BOOL pdb_find_alias(const char *name, DOM_SID *sid);
NTSTATUS pdb_create_alias(const char *name, uint32 *rid);
BOOL pdb_delete_alias(const DOM_SID *sid);
BOOL pdb_get_aliasinfo(const DOM_SID *sid, struct acct_info *info);
BOOL pdb_set_aliasinfo(const DOM_SID *sid, struct acct_info *info);
BOOL pdb_add_aliasmem(const DOM_SID *alias, const DOM_SID *member);
BOOL pdb_del_aliasmem(const DOM_SID *alias, const DOM_SID *member);
BOOL pdb_enum_aliasmem(const DOM_SID *alias,
		       DOM_SID **members, int *num_members);
BOOL pdb_enum_alias_memberships(TALLOC_CTX *mem_ctx, const DOM_SID *domain_sid,
				const DOM_SID *members, int num_members,
				uint32 **alias_rids, int *num_alias_rids);
NTSTATUS pdb_lookup_rids(TALLOC_CTX *mem_ctx,
			 const DOM_SID *domain_sid,
			 int num_rids,
			 uint32 *rids,
			 const char ***names,
			 uint32 **attrs);
BOOL initialize_password_db(BOOL reload);
NTSTATUS pdb_default_enum_group_members(struct pdb_methods *methods,
					TALLOC_CTX *mem_ctx,
					const DOM_SID *group,
					uint32 **member_rids,
					int *num_members);
NTSTATUS pdb_default_lookup_rids(struct pdb_methods *methods,
				 TALLOC_CTX *mem_ctx,
				 const DOM_SID *domain_sid,
				 int num_rids,
				 uint32 *rids,
				 const char ***names,
				 uint32 **attrs);
struct pdb_search *pdb_search_users(uint16 acct_flags);
struct pdb_search *pdb_search_groups(void);
struct pdb_search *pdb_search_aliases(const DOM_SID *sid);
uint32 pdb_search_entries(struct pdb_search *search,
			  uint32 start_idx, uint32 max_entries,
			  struct samr_displayentry **result);
void pdb_search_destroy(struct pdb_search *search);
NTSTATUS make_pdb_methods(TALLOC_CTX *mem_ctx, PDB_METHODS **methods) ;

/* The following definitions come from passdb/pdb_ldap.c  */

void private_data_free_fn(void **result) ;
const char** get_userattr_list( int schema_ver );
int ldapsam_search_suffix_by_name(struct ldapsam_privates *ldap_state, 
					  const char *user,
					  LDAPMessage ** result,
					  const char **attr);
char *get_ldap_filter(TALLOC_CTX *mem_ctx, const char *username);
const char **talloc_attrs(TALLOC_CTX *mem_ctx, ...);
NTSTATUS pdb_init_ldapsam_compat(PDB_CONTEXT *pdb_context, PDB_METHODS **pdb_method, const char *location);
NTSTATUS pdb_init_ldapsam(PDB_CONTEXT *pdb_context, PDB_METHODS **pdb_method, const char *location);
NTSTATUS pdb_ldap_init(void);

/* The following definitions come from passdb/pdb_nds.c  */

int pdb_nds_get_password(
	struct smbldap_state *ldap_state,
	char *object_dn,
	size_t *pwd_len,
	char *pwd );
int pdb_nds_set_password(
	struct smbldap_state *ldap_state,
	char *object_dn,
	const char *pwd );
NTSTATUS pdb_nds_init(void);

/* The following definitions come from passdb/pdb_smbpasswd.c  */

NTSTATUS pdb_smbpasswd_init(void) ;

/* The following definitions come from passdb/pdb_sql.c  */

char *sql_escape_string(TALLOC_CTX *mem_ctx, const char *unesc);
char *sql_account_query_select(TALLOC_CTX *mem_ctx, const char *data, BOOL update, enum sql_search_field field, const char *value);
char *sql_account_query_delete(TALLOC_CTX *mem_ctx, const char *data, const char *esc) ;
char *sql_account_query_update(TALLOC_CTX *mem_ctx, const char *location, const SAM_ACCOUNT *newpwd, char isupdate);
BOOL sql_account_config_valid(const char *data);

/* The following definitions come from passdb/pdb_tdb.c  */

NTSTATUS pdb_tdbsam_init(void);

/* The following definitions come from passdb/secrets.c  */

BOOL secrets_init(void);
void *secrets_fetch(const char *key, size_t *size);
BOOL secrets_store(const char *key, const void *data, size_t size);
BOOL secrets_delete(const char *key);
BOOL secrets_store_domain_sid(const char *domain, const DOM_SID *sid);
BOOL secrets_fetch_domain_sid(const char *domain, DOM_SID *sid);
BOOL secrets_store_domain_guid(const char *domain, struct uuid *guid);
BOOL secrets_fetch_domain_guid(const char *domain, struct uuid *guid);
const char *trust_keystr(const char *domain);
BOOL secrets_lock_trust_account_password(const char *domain, BOOL dolock);
uint32 get_default_sec_channel(void) ;
BOOL secrets_fetch_trust_account_password(const char *domain, uint8 ret_pwd[16],
					  time_t *pass_last_set_time,
					  uint32 *channel);
BOOL secrets_fetch_trusted_domain_password(const char *domain, char** pwd,
                                           DOM_SID *sid, time_t *pass_last_set_time);
BOOL secrets_store_trust_account_password(const char *domain, uint8 new_pwd[16]);
BOOL secrets_store_trusted_domain_password(const char* domain, smb_ucs2_t *uni_dom_name,
                                           size_t uni_name_len, const char* pwd,
                                           DOM_SID sid);
BOOL secrets_store_machine_password(const char *pass, const char *domain, uint32 sec_channel);
char *secrets_fetch_machine_password(const char *domain, 
				     time_t *pass_last_set_time,
				     uint32 *channel);
BOOL trust_password_delete(const char *domain);
BOOL trusted_domain_password_delete(const char *domain);
BOOL secrets_store_ldap_pw(const char* dn, char* pw);
BOOL fetch_ldap_pw(char **dn, char** pw);
NTSTATUS secrets_get_trusted_domains(TALLOC_CTX* ctx, int* enum_ctx, unsigned int max_num_domains,
                                     int *num_domains, TRUSTDOM ***domains);
BOOL secrets_named_mutex(const char *name, unsigned int timeout);
void secrets_named_mutex_release(const char *name);
BOOL must_use_pdc( const char *domain );
BOOL secrets_store_afs_keyfile(const char *cell, const struct afs_keyfile *keyfile);
BOOL secrets_fetch_afs_key(const char *cell, struct afs_key *result);
void secrets_fetch_ipc_userpass(char **username, char **domain, char **password);

/* The following definitions come from passdb/util_sam_sid.c  */

BOOL map_domain_sid_to_name(DOM_SID *sid, fstring nt_domain);
BOOL lookup_known_rid(DOM_SID *sid, uint32 rid, char *name, enum SID_NAME_USE *psid_name_use);
BOOL map_domain_name_to_sid(DOM_SID *sid, char *nt_domain);
BOOL sid_check_is_domain(const DOM_SID *sid);
BOOL sid_check_is_in_our_domain(const DOM_SID *sid);
BOOL map_name_to_wellknown_sid(DOM_SID *sid, enum SID_NAME_USE *use, const char *name);

/* The following definitions come from printing/load.c  */

void load_printers(void);

/* The following definitions come from printing/lpq_parse.c  */

BOOL parse_lpq_entry(enum printing_types printing_type,char *line,
		     print_queue_struct *buf,
		     print_status_struct *status,BOOL first);

/* The following definitions come from printing/notify.c  */

int print_queue_snum(const char *qname);
BOOL print_notify_messages_pending(void);
void print_notify_send_messages(unsigned int timeout);
void notify_printer_status_byname(const char *sharename, uint32 status);
void notify_printer_status(int snum, uint32 status);
void notify_job_status_byname(const char *sharename, uint32 jobid, uint32 status,
			      uint32 flags);
void notify_job_status(const char *sharename, uint32 jobid, uint32 status);
void notify_job_total_bytes(const char *sharename, uint32 jobid,
			    uint32 size);
void notify_job_total_pages(const char *sharename, uint32 jobid,
			    uint32 pages);
void notify_job_username(const char *sharename, uint32 jobid, char *name);
void notify_job_name(const char *sharename, uint32 jobid, char *name);
void notify_job_submitted(const char *sharename, uint32 jobid,
			  time_t submitted);
void notify_printer_driver(int snum, char *driver_name);
void notify_printer_comment(int snum, char *comment);
void notify_printer_sharename(int snum, char *share_name);
void notify_printer_printername(int snum, char *printername);
void notify_printer_port(int snum, char *port_name);
void notify_printer_location(int snum, char *location);
void notify_printer_byname( const char *printername, uint32 change, char *value );
BOOL print_notify_pid_list(const char *printername, TALLOC_CTX *mem_ctx, size_t *p_num_pids, pid_t **pp_pid_list);

/* The following definitions come from printing/nt_printing.c  */

BOOL nt_printing_init(void);
uint32 update_c_setprinter(BOOL initialize);
uint32 get_c_setprinter(void);
int get_builtin_ntforms(nt_forms_struct **list);
BOOL get_a_builtin_ntform(UNISTR2 *uni_formname,nt_forms_struct *form);
int get_ntforms(nt_forms_struct **list);
int write_ntforms(nt_forms_struct **list, int number);
BOOL add_a_form(nt_forms_struct **list, const FORM *form, int *count);
BOOL delete_a_form(nt_forms_struct **list, UNISTR2 *del_name, int *count, WERROR *ret);
void update_a_form(nt_forms_struct **list, const FORM *form, int count);
int get_ntdrivers(fstring **list, const char *architecture, uint32 version);
const char *get_short_archi(const char *long_archi);
WERROR clean_up_driver_struct(NT_PRINTER_DRIVER_INFO_LEVEL driver_abstract,
							  uint32 level, struct current_user *user);
WERROR move_driver_to_download_area(NT_PRINTER_DRIVER_INFO_LEVEL driver_abstract, uint32 level, 
				  struct current_user *user, WERROR *perr);
int pack_devicemode(NT_DEVICEMODE *nt_devmode, char *buf, int buflen);
uint32 del_a_printer(const char *sharename);
NT_DEVICEMODE *construct_nt_devicemode(const fstring default_devicename);
NT_DEVICEMODE *dup_nt_devicemode(NT_DEVICEMODE *nt_devicemode);
void free_nt_devicemode(NT_DEVICEMODE **devmode_ptr);
int unpack_devicemode(NT_DEVICEMODE **nt_devmode, char *buf, int buflen);
int add_new_printer_key( NT_PRINTER_DATA *data, const char *name );
int delete_printer_key( NT_PRINTER_DATA *data, const char *name );
int lookup_printerkey( NT_PRINTER_DATA *data, const char *name );
int get_printer_subkeys( NT_PRINTER_DATA *data, const char* key, fstring **subkeys );
WERROR nt_printer_publish(Printer_entry *print_hnd, int snum, int action);
WERROR check_published_printers(void);
BOOL is_printer_published(Printer_entry *print_hnd, int snum, 
			  struct uuid *guid);
WERROR nt_printer_publish(Printer_entry *print_hnd, int snum, int action);
WERROR check_published_printers(void);
BOOL is_printer_published(Printer_entry *print_hnd, int snum, 
			  struct uuid *guid);
WERROR delete_all_printer_data( NT_PRINTER_INFO_LEVEL_2 *p2, const char *key );
WERROR delete_printer_data( NT_PRINTER_INFO_LEVEL_2 *p2, const char *key, const char *value );
WERROR add_printer_data( NT_PRINTER_INFO_LEVEL_2 *p2, const char *key, const char *value, 
                           uint32 type, uint8 *data, int real_len );
REGISTRY_VALUE* get_printer_data( NT_PRINTER_INFO_LEVEL_2 *p2, const char *key, const char *value );
WERROR mod_a_printer(NT_PRINTER_INFO_LEVEL *printer, uint32 level);
BOOL set_driver_init(NT_PRINTER_INFO_LEVEL *printer, uint32 level);
BOOL del_driver_init(char *drivername);
WERROR save_driver_init(NT_PRINTER_INFO_LEVEL *printer, uint32 level, uint8 *data, uint32 data_len);
NT_PRINTER_INFO_LEVEL_2* dup_printer_2( TALLOC_CTX *ctx, NT_PRINTER_INFO_LEVEL_2 *printer );
WERROR get_a_printer( Printer_entry *print_hnd, NT_PRINTER_INFO_LEVEL **pp_printer, uint32 level, 
			const char *sharename);
uint32 free_a_printer(NT_PRINTER_INFO_LEVEL **pp_printer, uint32 level);
uint32 add_a_printer_driver(NT_PRINTER_DRIVER_INFO_LEVEL driver, uint32 level);
WERROR get_a_printer_driver(NT_PRINTER_DRIVER_INFO_LEVEL *driver, uint32 level,
                            fstring drivername, const char *architecture, uint32 version);
uint32 free_a_printer_driver(NT_PRINTER_DRIVER_INFO_LEVEL driver, uint32 level);
BOOL printer_driver_in_use ( NT_PRINTER_DRIVER_INFO_LEVEL_3 *info_3 );
BOOL printer_driver_files_in_use ( NT_PRINTER_DRIVER_INFO_LEVEL_3 *info );
WERROR delete_printer_driver( NT_PRINTER_DRIVER_INFO_LEVEL_3 *info_3, struct current_user *user,
                              uint32 version, BOOL delete_files );
WERROR nt_printing_setsec(const char *sharename, SEC_DESC_BUF *secdesc_ctr);
BOOL nt_printing_getsec(TALLOC_CTX *ctx, const char *sharename, SEC_DESC_BUF **secdesc_ctr);
void map_printer_permissions(SEC_DESC *sd);
BOOL print_access_check(struct current_user *user, int snum, int access_type);
BOOL print_time_access_check(int snum);
char* get_server_name( Printer_entry *printer );

/* The following definitions come from printing/pcap.c  */

BOOL pcap_cache_add(const char *name, const char *comment);
BOOL pcap_cache_loaded(void);
void pcap_cache_reload(void);
BOOL pcap_printername_ok(const char *printername);
void pcap_printer_fn(void (*fn)(char *, char *));

/* The following definitions come from printing/print_aix.c  */

BOOL aix_cache_reload(void);

/* The following definitions come from printing/print_cups.c  */

BOOL cups_cache_reload(void);

/* The following definitions come from printing/print_generic.c  */


/* The following definitions come from printing/print_svid.c  */

BOOL sysv_cache_reload(void);

/* The following definitions come from printing/printfsp.c  */

files_struct *print_fsp_open(connection_struct *conn, const char *fname);
void print_fsp_end(files_struct *fsp, BOOL normal_close);

/* The following definitions come from printing/printing.c  */

uint16 pjobid_to_rap(const char* sharename, uint32 jobid);
BOOL rap_to_pjobid(uint16 rap_jobid, fstring sharename, uint32 *pjobid);
BOOL print_backend_init(void);
void printing_end(void);
int unpack_pjob( char* buf, int buflen, struct printjob *pjob );
uint32 sysjob_to_jobid(int unix_jobid);
void pjob_delete(const char* sharename, uint32 jobid);
void start_background_queue(void);
BOOL print_notify_register_pid(int snum);
BOOL print_notify_deregister_pid(int snum);
BOOL print_job_exists(const char* sharename, uint32 jobid);
int print_job_fd(const char* sharename, uint32 jobid);
char *print_job_fname(const char* sharename, uint32 jobid);
NT_DEVICEMODE *print_job_devmode(const char* sharename, uint32 jobid);
BOOL print_job_set_place(int snum, uint32 jobid, int place);
BOOL print_job_set_name(int snum, uint32 jobid, char *name);
BOOL print_job_delete(struct current_user *user, int snum, uint32 jobid, WERROR *errcode);
BOOL print_job_pause(struct current_user *user, int snum, uint32 jobid, WERROR *errcode);
BOOL print_job_resume(struct current_user *user, int snum, uint32 jobid, WERROR *errcode);
ssize_t print_job_write(int snum, uint32 jobid, const char *buf, SMB_OFF_T pos, size_t size);
int print_queue_length(int snum, print_status_struct *pstatus);
uint32 print_job_start(struct current_user *user, int snum, char *jobname, NT_DEVICEMODE *nt_devmode );
void print_job_endpage(int snum, uint32 jobid);
BOOL print_job_end(int snum, uint32 jobid, BOOL normal_close);
int print_queue_status(int snum, 
		       print_queue_struct **ppqueue,
		       print_status_struct *status);
BOOL print_queue_pause(struct current_user *user, int snum, WERROR *errcode);
BOOL print_queue_resume(struct current_user *user, int snum, WERROR *errcode);
BOOL print_queue_purge(struct current_user *user, int snum, WERROR *errcode);

/* The following definitions come from printing/printing_db.c  */

struct tdb_print_db *get_print_db_byname(const char *printername);
void release_print_db( struct tdb_print_db *pdb);
void close_all_print_db(void);
TDB_DATA get_printer_notify_pid_list(TDB_CONTEXT *tdb, const char *printer_name, BOOL cleanlist);

/* The following definitions come from profile/profile.c  */

void profile_message(int msg_type, pid_t src, void *buf, size_t len);
void reqprofile_message(int msg_type, pid_t src, void *buf, size_t len);
BOOL profile_setup(BOOL rdonly);

/* The following definitions come from registry/reg_cachehook.c  */

BOOL reghook_cache_init( void );
BOOL reghook_cache_add( REGISTRY_HOOK *hook );
REGISTRY_HOOK* reghook_cache_find( const char *keyname );
void reghook_dump_cache( int debuglevel );

/* The following definitions come from registry/reg_db.c  */

BOOL init_registry_db( void );
BOOL regdb_store_keys( const char *key, REGSUBKEY_CTR *ctr );
int regdb_fetch_keys( const char* key, REGSUBKEY_CTR *ctr );
int regdb_fetch_values( const char* key, REGVAL_CTR *values );
BOOL regdb_store_values( const char *key, REGVAL_CTR *values );

/* The following definitions come from registry/reg_dynamic.c  */

int fetch_dynamic_reg_values( REGISTRY_KEY *key, REGVAL_CTR *val );
BOOL check_dynamic_reg_values( REGISTRY_KEY *key );

/* The following definitions come from registry/reg_eventlog.c  */


/* The following definitions come from registry/reg_frontend.c  */

BOOL init_registry( void );
BOOL store_reg_keys( REGISTRY_KEY *key, REGSUBKEY_CTR *subkeys );
BOOL store_reg_values( REGISTRY_KEY *key, REGVAL_CTR *val );
int fetch_reg_keys( REGISTRY_KEY *key, REGSUBKEY_CTR *subkey_ctr );
BOOL fetch_reg_keys_specific( REGISTRY_KEY *key, char** subkey, uint32 key_index );
int fetch_reg_values( REGISTRY_KEY *key, REGVAL_CTR *val );
BOOL fetch_reg_values_specific( REGISTRY_KEY *key, REGISTRY_VALUE **val, uint32 val_index );
BOOL regkey_access_check( REGISTRY_KEY *key, uint32 requested, uint32 *granted, NT_USER_TOKEN *token );

/* The following definitions come from registry/reg_objects.c  */

void regsubkey_ctr_init( REGSUBKEY_CTR *ctr );
int regsubkey_ctr_addkey( REGSUBKEY_CTR *ctr, const char *keyname );
int regsubkey_ctr_delkey( REGSUBKEY_CTR *ctr, const char *keyname );
BOOL regsubkey_ctr_key_exists( REGSUBKEY_CTR *ctr, const char *keyname );
int regsubkey_ctr_numkeys( REGSUBKEY_CTR *ctr );
char* regsubkey_ctr_specific_key( REGSUBKEY_CTR *ctr, uint32 key_index );
void regsubkey_ctr_destroy( REGSUBKEY_CTR *ctr );
void regval_ctr_init( REGVAL_CTR *ctr );
int regval_ctr_numvals( REGVAL_CTR *ctr );
REGISTRY_VALUE* dup_registry_value( REGISTRY_VALUE *val );
void free_registry_value( REGISTRY_VALUE *val );
uint8* regval_data_p( REGISTRY_VALUE *val );
uint32 regval_size( REGISTRY_VALUE *val );
char* regval_name( REGISTRY_VALUE *val );
uint32 regval_type( REGISTRY_VALUE *val );
REGISTRY_VALUE* regval_ctr_specific_value( REGVAL_CTR *ctr, uint32 idx );
TALLOC_CTX* regval_ctr_getctx( REGVAL_CTR *val );
BOOL regval_ctr_key_exists( REGVAL_CTR *ctr, const char *value );
int regval_ctr_addvalue( REGVAL_CTR *ctr, const char *name, uint16 type, 
                         const char *data_p, size_t size );
int regval_ctr_copyvalue( REGVAL_CTR *ctr, REGISTRY_VALUE *val );
int regval_ctr_delvalue( REGVAL_CTR *ctr, const char *name );
REGISTRY_VALUE* regval_ctr_getvalue( REGVAL_CTR *ctr, const char *name );
void regval_ctr_destroy( REGVAL_CTR *ctr );

/* The following definitions come from registry/reg_printing.c  */


/* The following definitions come from registry/reg_shares.c  */


/* The following definitions come from registry/reg_util.c  */

BOOL reg_split_path( char *path, char **base, char **new_path );
BOOL reg_split_key( char *path, char **base, char **key );
void normalize_reg_path( pstring keyname );

/* The following definitions come from registry/regfio.c  */


/* The following definitions come from rpc_client/cli_dfs.c  */

NTSTATUS cli_dfs_exist(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                       BOOL *dfs_exists);
NTSTATUS cli_dfs_add(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                     const char *entrypath, const char *servername, 
		     const char *sharename, const char *comment, uint32 flags);
NTSTATUS cli_dfs_remove(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                        const char *entrypath, const char *servername, 
			const char *sharename);
NTSTATUS cli_dfs_get_info(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                          const char *entrypath, const char *servername, 
			  const char *sharename, uint32 info_level, 
			  DFS_INFO_CTR *ctr);
NTSTATUS cli_dfs_enum(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                      uint32 info_level, DFS_INFO_CTR *ctr);

/* The following definitions come from rpc_client/cli_ds.c  */

NTSTATUS rpccli_ds_getprimarydominfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx, 
				     uint16 level, DS_DOMINFO_CTR *ctr);
NTSTATUS cli_ds_getprimarydominfo(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				  uint16 level, DS_DOMINFO_CTR *ctr);
NTSTATUS rpccli_ds_enum_domain_trusts(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx, 
				      const char *server, uint32 flags, 
				      struct ds_domain_trust **trusts,
				      uint32 *num_domains);
NTSTATUS cli_ds_enum_domain_trusts(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				   const char *server, uint32 flags, 
				   struct ds_domain_trust **trusts,
				   uint32 *num_domains);

/* The following definitions come from rpc_client/cli_echo.c  */

NTSTATUS cli_echo_add_one(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			  uint32 request, uint32 *response);
NTSTATUS cli_echo_data(struct cli_state *cli, TALLOC_CTX *mem_ctx,
		       uint32 size, char *in_data, char **out_data);
NTSTATUS cli_echo_sink_data(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			    uint32 size, char *in_data);
NTSTATUS cli_echo_source_data(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      uint32 size, char **out_data);

/* The following definitions come from rpc_client/cli_lsarpc.c  */

NTSTATUS rpccli_lsa_open_policy(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				BOOL sec_qos, uint32 des_access,
				POLICY_HND *pol);
NTSTATUS cli_lsa_open_policy(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             BOOL sec_qos, uint32 des_access, POLICY_HND *pol);
NTSTATUS rpccli_lsa_open_policy2(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx, BOOL sec_qos,
				 uint32 des_access, POLICY_HND *pol);
NTSTATUS cli_lsa_open_policy2(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                              BOOL sec_qos, uint32 des_access, POLICY_HND *pol);
NTSTATUS rpccli_lsa_close(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, 
			  POLICY_HND *pol);
NTSTATUS cli_lsa_close(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                       POLICY_HND *pol);
NTSTATUS rpccli_lsa_lookup_sids(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				POLICY_HND *pol, int num_sids,
				const DOM_SID *sids, 
				char ***domains, char ***names, uint32 **types);
NTSTATUS cli_lsa_lookup_sids(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *pol, int num_sids,
			     const DOM_SID *sids, 
                             char ***domains, char ***names, uint32 **types);
NTSTATUS rpccli_lsa_lookup_names(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 POLICY_HND *pol, int num_names, 
				 const char **names, DOM_SID **sids, 
				 uint32 **types);
NTSTATUS cli_lsa_lookup_names(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                              POLICY_HND *pol, int num_names, 
			      const char **names, DOM_SID **sids, 
			      uint32 **types);
NTSTATUS rpccli_lsa_query_info_policy(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      POLICY_HND *pol, uint16 info_class, 
				      char **domain_name, DOM_SID **domain_sid);
NTSTATUS cli_lsa_query_info_policy(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                   POLICY_HND *pol, uint16 info_class, 
                                   char **domain_name, DOM_SID **domain_sid);
NTSTATUS rpccli_lsa_query_info_policy2(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       POLICY_HND *pol, uint16 info_class, 
				       char **domain_name, char **dns_name,
				       char **forest_name,
				       struct uuid **domain_guid,
				       DOM_SID **domain_sid);
NTSTATUS cli_lsa_query_info_policy2(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				    POLICY_HND *pol, uint16 info_class, 
				    char **domain_name, char **dns_name,
				    char **forest_name,
				    struct uuid **domain_guid,
				    DOM_SID **domain_sid);
NTSTATUS rpccli_lsa_enum_trust_dom(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   POLICY_HND *pol, uint32 *enum_ctx, 
				   uint32 *num_domains,
				   char ***domain_names, DOM_SID **domain_sids);
NTSTATUS cli_lsa_enum_trust_dom(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *pol, uint32 *enum_ctx, 
                                uint32 *num_domains,
                                char ***domain_names, DOM_SID **domain_sids);
NTSTATUS cli_lsa_enum_privilege(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *pol, uint32 *enum_context, uint32 pref_max_length,
				uint32 *count, char ***privs_name, uint32 **privs_high, uint32 **privs_low);
NTSTATUS cli_lsa_get_dispname(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, const char *name, 
			      uint16 lang_id, uint16 lang_id_sys,
			      fstring description, uint16 *lang_id_desc);
NTSTATUS cli_lsa_enum_sids(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *pol, uint32 *enum_ctx, uint32 pref_max_length, 
                                uint32 *num_sids, DOM_SID **sids);
NTSTATUS cli_lsa_create_account(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *dom_pol, DOM_SID *sid, uint32 desired_access, 
			     POLICY_HND *user_pol);
NTSTATUS cli_lsa_open_account(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *dom_pol, DOM_SID *sid, uint32 des_access, 
			     POLICY_HND *user_pol);
NTSTATUS cli_lsa_enum_privsaccount(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *pol, uint32 *count, LUID_ATTR **set);
NTSTATUS cli_lsa_lookup_priv_value(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 POLICY_HND *pol, const char *name, LUID *luid);
NTSTATUS cli_lsa_query_secobj(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, uint32 sec_info, 
			      SEC_DESC_BUF **psdb);
NTSTATUS cli_lsa_enum_account_rights(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				     POLICY_HND *pol, DOM_SID *sid,
				     uint32 *count, char ***priv_names);
NTSTATUS cli_lsa_add_account_rights(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				    POLICY_HND *pol, DOM_SID sid,
				    
uint32 count, const char **privs_name);
NTSTATUS cli_lsa_remove_account_rights(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				       POLICY_HND *pol, DOM_SID sid, BOOL removeall,
				       uint32 count, const char **privs_name);
BOOL fetch_domain_sid( char *domain, char *remote_machine, DOM_SID *psid);
NTSTATUS cli_lsa_open_trusted_domain(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				     POLICY_HND *pol, DOM_SID *dom_sid, uint32 access_mask,
				     POLICY_HND *trustdom_pol);
NTSTATUS cli_lsa_query_trusted_domain_info(struct cli_state *cli, TALLOC_CTX *mem_ctx,
					   POLICY_HND *pol, 
					   uint16 info_class, DOM_SID *dom_sid, 
					   LSA_TRUSTED_DOMAIN_INFO **info);
NTSTATUS cli_lsa_query_trusted_domain_info_by_sid(struct cli_state *cli, TALLOC_CTX *mem_ctx,
						  POLICY_HND *pol, 
						  uint16 info_class, DOM_SID *dom_sid, 
						  LSA_TRUSTED_DOMAIN_INFO **info);
NTSTATUS cli_lsa_query_trusted_domain_info_by_name(struct cli_state *cli, TALLOC_CTX *mem_ctx,
						   POLICY_HND *pol, 
						   uint16 info_class, const char *domain_name, 
						   LSA_TRUSTED_DOMAIN_INFO **info);

/* The following definitions come from rpc_client/cli_netlogon.c  */

NTSTATUS cli_net_req_chal(struct cli_state *cli, DOM_CHAL *clnt_chal, 
			  DOM_CHAL *srv_chal);
NTSTATUS rpccli_net_req_chal(struct rpc_pipe_client *cli,
			     const char *server_name,
			     const char *computer_name,
			     DOM_CHAL *clnt_chal, DOM_CHAL *srv_chal);
NTSTATUS cli_net_auth2(struct cli_state *cli, 
		       uint16 sec_chan, 
		       uint32 *neg_flags, DOM_CHAL *srv_chal);
NTSTATUS rpccli_net_auth2(struct rpc_pipe_client *cli,
			  const char *server_name,
			  const char *account_name,
			  uint16 sec_chan_type,
			  const char *computer_name,
			  const DOM_CHAL *credentials,
			  uint32 *neg_flags,
			  DOM_CHAL *srv_chal);
NTSTATUS cli_net_auth3(struct cli_state *cli, 
		       uint16 sec_chan, 
		       uint32 *neg_flags, DOM_CHAL *srv_chal);
NTSTATUS cli_nt_setup_creds(struct cli_state *cli, 
			    uint16 sec_chan,
			    const unsigned char mach_pwd[16], uint32 *neg_flags, int level);
NTSTATUS cli_netlogon_logon_ctrl2(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                  uint32 query_level);
NTSTATUS rpccli_netlogon_getdcname(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx, const char *mydcname,
				   const char *domainname, fstring newdcname);
NTSTATUS cli_netlogon_getdcname(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				const char *domainname, fstring dcname);
NTSTATUS cli_netlogon_sam_sync(struct cli_state *cli, TALLOC_CTX *mem_ctx, DOM_CRED *ret_creds,
                               uint32 database_id, uint32 next_rid, uint32 *num_deltas,
                               SAM_DELTA_HDR **hdr_deltas, 
                               SAM_DELTA_CTR **deltas);
NTSTATUS cli_netlogon_sam_deltas(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 uint32 database_id, UINT64_S seqnum,
                                 uint32 *num_deltas, 
                                 SAM_DELTA_HDR **hdr_deltas, 
                                 SAM_DELTA_CTR **deltas);
NTSTATUS cli_netlogon_sam_logon(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				DOM_CRED *ret_creds,
                                const char *username, const char *password,
                                int logon_type);
NTSTATUS rpccli_netlogon_sam_network_logon(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_name_slash,
					   DOM_CRED *clnt_creds,
					   DOM_CRED *ret_creds,
					   const char *username,
					   const char *domain,
					   const char *workstation, 
					   const uint8 chal[8], 
					   DATA_BLOB lm_response,
					   DATA_BLOB nt_response,
					   NET_USER_INFO_3 *info3,
					   const uint8 *session_key);
NTSTATUS cli_netlogon_sam_network_logon(struct cli_state *cli,
					TALLOC_CTX *mem_ctx,
					DOM_CRED *ret_creds,
					const char *username,
					const char *domain,
					const char *workstation, 
					const uint8 chal[8], 
					DATA_BLOB lm_response,
					DATA_BLOB nt_response,
					NET_USER_INFO_3 *info3);
NTSTATUS cli_net_srv_pwset(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
			   const char *machine_name, uint8 hashed_mach_pwd[16]);

/* The following definitions come from rpc_client/cli_pipe.c  */

void get_auth_type_level(int pipe_auth_flags, int *auth_type, int *auth_level) ;
BOOL rpc_api_pipe_req_int(struct rpc_pipe_client *cli, uint8 op_num,
			  prs_struct *data, prs_struct *rdata);
BOOL rpc_api_pipe_req(struct cli_state *cli, int pipe_idx, uint8 op_num,
                      prs_struct *data, prs_struct *rdata);
int get_pipe_index( const char *pipe_name );
const char* get_pipe_name_from_index( const int pipe_index );
BOOL is_win2k_pipe( const int pipe_idx );
BOOL cli_nt_session_open(struct cli_state *cli, const int pipe_idx);
NTSTATUS cli_nt_establish_netlogon(struct cli_state *cli, int sec_chan,
				   const uchar trust_password[16]);
NTSTATUS cli_nt_setup_netsec(struct cli_state *cli, int sec_chan, int auth_flags,
			     const uchar trust_password[16]);
const char *cli_pipe_get_name(struct cli_state *cli);
struct rpc_pipe_client *cli_rpc_open_noauth(struct cli_state *cli,
					    int pipe_idx);
struct rpc_pipe_client *cli_rpc_open_ntlmssp(struct cli_state *cli,
					     int pipe_idx,
					     const char *domain,
					     const char *username,
					     const char *password);
struct rpc_pipe_client *cli_rpc_open_schannel(struct cli_state *cli,
					      int pipe_idx,
					      const uchar session_key[16],
					      const char *domain);
void cli_rpc_close(struct rpc_pipe_client *cli_pipe);

/* The following definitions come from rpc_client/cli_reg.c  */

WERROR cli_reg_connect(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                         uint32 reg_type, uint32 access_mask,
                         POLICY_HND *reg_hnd);
WERROR cli_reg_shutdown(struct cli_state * cli, TALLOC_CTX *mem_ctx,
                          const char *msg, uint32 timeout, BOOL do_reboot,
			  BOOL force);
WERROR cli_reg_abort_shutdown(struct cli_state * cli, TALLOC_CTX *mem_ctx);
WERROR cli_reg_flush_key(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                           POLICY_HND *hnd);
WERROR cli_reg_query_key(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                           POLICY_HND *hnd,
                           char *key_class, uint32 *class_len,
                           uint32 *num_subkeys, uint32 *max_subkeylen,
                           uint32 *max_classlen, uint32 *num_values,
                           uint32 *max_valnamelen, uint32 *max_valbufsize,
                           uint32 *sec_desc, NTTIME *mod_time);
WERROR cli_reg_getversion(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *hnd, uint32 *version);
WERROR cli_reg_query_value(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                           POLICY_HND *hnd, const char *val_name,
                           uint32 *type, REGVAL_BUFFER *buffer);
WERROR cli_reg_set_key_sec(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *hnd, uint32 sec_info,
                             size_t secdesc_size, SEC_DESC *sec_desc);
WERROR cli_reg_get_key_sec(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *hnd, uint32 sec_info,
                             uint32 *sec_buf_size, SEC_DESC_BUF *sec_buf);
WERROR cli_reg_delete_val(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *hnd, char *val_name);
WERROR cli_reg_delete_key(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *hnd, char *key_name);
WERROR cli_reg_create_key_ex(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *hnd, char *key_name, char *key_class,
                            uint32 access_desired, POLICY_HND *key);
WERROR cli_reg_enum_key(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                          POLICY_HND *hnd, int key_index, fstring key_name,
                          fstring class_name, time_t *mod_time);
WERROR cli_reg_set_val(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *hnd, char *val_name, uint32 type,
                            RPC_DATA_BLOB *data);
WERROR cli_reg_enum_val(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                          POLICY_HND *hnd, int idx,
                          fstring val_name, uint32 *type, REGVAL_BUFFER *value);
WERROR cli_reg_open_entry(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *hnd, char *key_name,
                            uint32 access_desired, POLICY_HND *key_hnd);
WERROR cli_reg_close(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                       POLICY_HND *hnd);
WERROR cli_reg_save_key( struct cli_state *cli, TALLOC_CTX *mem_ctx,
                         POLICY_HND *hnd, const char *filename );
BOOL reg_split_hive(const char *full_keyname, uint32 *reg_type, pstring key_name);

/* The following definitions come from rpc_client/cli_samr.c  */

NTSTATUS rpccli_samr_connect(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, 
			     uint32 access_mask, POLICY_HND *connect_pol);
NTSTATUS cli_samr_connect(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                          uint32 access_mask, POLICY_HND *connect_pol);
NTSTATUS cli_samr_connect4(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
			   uint32 access_mask, POLICY_HND *connect_pol);
NTSTATUS rpccli_samr_close(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx,
			   POLICY_HND *connect_pol);
NTSTATUS cli_samr_close(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                        POLICY_HND *connect_pol);
NTSTATUS rpccli_samr_open_domain(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx,
				 POLICY_HND *connect_pol, uint32 access_mask, 
				 const DOM_SID *domain_sid,
				 POLICY_HND *domain_pol);
NTSTATUS cli_samr_open_domain(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                              POLICY_HND *connect_pol, uint32 access_mask, 
                              const DOM_SID *domain_sid,
			      POLICY_HND *domain_pol);
NTSTATUS rpccli_samr_open_user(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       POLICY_HND *domain_pol, uint32 access_mask, 
			       uint32 user_rid, POLICY_HND *user_pol);
NTSTATUS cli_samr_open_user(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *domain_pol, uint32 access_mask, 
                            uint32 user_rid, POLICY_HND *user_pol);
NTSTATUS rpccli_samr_open_group(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx, 
				POLICY_HND *domain_pol, uint32 access_mask, 
				uint32 group_rid, POLICY_HND *group_pol);
NTSTATUS cli_samr_open_group(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                             POLICY_HND *domain_pol, uint32 access_mask, 
                             uint32 group_rid, POLICY_HND *group_pol);
NTSTATUS cli_samr_create_dom_group(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				   POLICY_HND *domain_pol,
				   const char *group_name,
				   uint32 access_mask, POLICY_HND *group_pol);
NTSTATUS cli_samr_add_groupmem(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			       POLICY_HND *group_pol, uint32 rid);
NTSTATUS cli_samr_del_groupmem(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			       POLICY_HND *group_pol, uint32 rid);
NTSTATUS rpccli_samr_query_userinfo(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    POLICY_HND *user_pol, uint16 switch_value, 
				    SAM_USERINFO_CTR **ctr);
NTSTATUS cli_samr_query_userinfo(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *user_pol, uint16 switch_value, 
                                 SAM_USERINFO_CTR **ctr);
NTSTATUS cli_samr_set_groupinfo(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				POLICY_HND *group_pol, GROUP_INFO_CTR *ctr);
NTSTATUS cli_samr_query_groupinfo(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                  POLICY_HND *group_pol, uint32 info_level, 
                                  GROUP_INFO_CTR **ctr);
NTSTATUS rpccli_samr_query_usergroups(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx, 
				      POLICY_HND *user_pol,
				      uint32 *num_groups, 
				      DOM_GID **gid);
NTSTATUS cli_samr_query_usergroups(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                   POLICY_HND *user_pol, uint32 *num_groups, 
                                   DOM_GID **gid);
NTSTATUS cli_samr_set_aliasinfo(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				POLICY_HND *alias_pol, ALIAS_INFO_CTR *ctr);
NTSTATUS rpccli_samr_query_useraliases(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx, 
				       POLICY_HND *dom_pol, uint32 num_sids,
				       DOM_SID2 *sid,
				       uint32 *num_aliases, uint32 **als_rids);
NTSTATUS cli_samr_query_useraliases(struct cli_state *cli,
				    TALLOC_CTX *mem_ctx, 
				    POLICY_HND *dom_pol, uint32 num_sids,
				    DOM_SID2 *sid,
				    uint32 *num_aliases, uint32 **als_rids);
NTSTATUS rpccli_samr_query_groupmem(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    POLICY_HND *group_pol, uint32 *num_mem, 
				    uint32 **rid, uint32 **attr);
NTSTATUS cli_samr_query_groupmem(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *group_pol, uint32 *num_mem, 
                                 uint32 **rid, uint32 **attr);
NTSTATUS cli_samr_enum_dom_users(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *pol, uint32 *start_idx, uint16 acb_mask,
                                 uint32 size, char ***dom_users, uint32 **rids,
                                 uint32 *num_dom_users);
NTSTATUS rpccli_samr_enum_dom_groups(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx, 
				     POLICY_HND *pol, uint32 *start_idx, 
				     uint32 size, struct acct_info **dom_groups,
				     uint32 *num_dom_groups);
NTSTATUS cli_samr_enum_dom_groups(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *pol, uint32 *start_idx, 
                                  uint32 size, struct acct_info **dom_groups,
                                  uint32 *num_dom_groups);
NTSTATUS rpccli_samr_enum_als_groups(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx, 
				     POLICY_HND *pol, uint32 *start_idx, 
				     uint32 size, struct acct_info **dom_aliases,
				     uint32 *num_dom_aliases);
NTSTATUS cli_samr_enum_als_groups(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *pol, uint32 *start_idx, 
                                  uint32 size, struct acct_info **dom_aliases,
                                  uint32 *num_dom_aliases);
NTSTATUS cli_samr_query_aliasmem(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *alias_pol, uint32 *num_mem, 
                                 DOM_SID **sids);
NTSTATUS cli_samr_open_alias(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                             POLICY_HND *domain_pol, uint32 access_mask, 
                             uint32 alias_rid, POLICY_HND *alias_pol);
NTSTATUS cli_samr_create_dom_alias(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				   POLICY_HND *domain_pol, const char *name,
				   POLICY_HND *alias_pol);
NTSTATUS cli_samr_add_aliasmem(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
			       POLICY_HND *alias_pol, DOM_SID *member);
NTSTATUS cli_samr_del_aliasmem(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
			       POLICY_HND *alias_pol, DOM_SID *member);
NTSTATUS cli_samr_query_alias_info(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				   POLICY_HND *alias_pol, uint16 switch_value,
				   ALIAS_INFO_CTR *ctr);
NTSTATUS rpccli_samr_query_dom_info(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx, 
				    POLICY_HND *domain_pol,
				    uint16 switch_value,
				    SAM_UNK_CTR *ctr);
NTSTATUS cli_samr_query_dom_info(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                 POLICY_HND *domain_pol, uint16 switch_value,
                                 SAM_UNK_CTR *ctr);
NTSTATUS rpccli_samr_chgpasswd_user(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx, 
				    const char *username, 
				    const char *newpassword, 
				    const char *oldpassword );
NTSTATUS cli_samr_chgpasswd_user(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				 const char *username, 
				 const char *newpassword, 
				 const char *oldpassword );
void get_query_dispinfo_params(int loop_count, uint32 *max_entries,
			       uint32 *max_size);
NTSTATUS rpccli_samr_query_dispinfo(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx, 
				    POLICY_HND *domain_pol, uint32 *start_idx,
				    uint16 switch_value, uint32 *num_entries,
				    uint32 max_entries, uint32 max_size,
				    SAM_DISPINFO_CTR *ctr);
NTSTATUS cli_samr_query_dispinfo(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                 POLICY_HND *domain_pol, uint32 *start_idx,
                                 uint16 switch_value, uint32 *num_entries,
                                 uint32 max_entries, uint32 max_size,
				 SAM_DISPINFO_CTR *ctr);
NTSTATUS rpccli_samr_lookup_rids(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx, 
				 POLICY_HND *domain_pol,
				 uint32 num_rids, uint32 *rids, 
				 uint32 *num_names, char ***names,
				 uint32 **name_types);
NTSTATUS cli_samr_lookup_rids(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                              POLICY_HND *domain_pol,
                              uint32 num_rids, uint32 *rids, 
                              uint32 *num_names, char ***names,
                              uint32 **name_types);
NTSTATUS cli_samr_lookup_names(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                               POLICY_HND *domain_pol, uint32 flags,
                               uint32 num_names, const char **names,
                               uint32 *num_rids, uint32 **rids,
                               uint32 **rid_types);
NTSTATUS cli_samr_create_dom_user(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *domain_pol, const char *acct_name,
                                  uint32 acb_info, uint32 unknown, 
                                  POLICY_HND *user_pol, uint32 *rid);
NTSTATUS cli_samr_set_userinfo(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                               POLICY_HND *user_pol, uint16 switch_value,
                               DATA_BLOB *sess_key, SAM_USERINFO_CTR *ctr);
NTSTATUS cli_samr_set_userinfo2(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                POLICY_HND *user_pol, uint16 switch_value,
                                DATA_BLOB *sess_key, SAM_USERINFO_CTR *ctr);
NTSTATUS cli_samr_delete_dom_group(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *group_pol);
NTSTATUS cli_samr_delete_dom_alias(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *alias_pol);
NTSTATUS cli_samr_delete_dom_user(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *user_pol);
NTSTATUS cli_samr_remove_sid_foreign_domain(struct cli_state *cli, 
					    TALLOC_CTX *mem_ctx, 
					    POLICY_HND *user_pol,
					    DOM_SID *sid);
NTSTATUS cli_samr_query_sec_obj(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *user_pol, uint16 switch_value, 
                                 TALLOC_CTX *ctx, SEC_DESC_BUF **sec_desc_buf);
NTSTATUS cli_samr_get_dom_pwinfo(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 uint16 *unk_0, uint16 *unk_1);
NTSTATUS cli_samr_lookup_domain(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				POLICY_HND *user_pol, char *domain_name, 
				DOM_SID *sid);

/* The following definitions come from rpc_client/cli_shutdown.c  */

NTSTATUS cli_shutdown_init(struct cli_state * cli, TALLOC_CTX *mem_ctx,
			   const char *msg, uint32 timeout, BOOL do_reboot,
			   BOOL force);
NTSTATUS cli_shutdown_init_ex(struct cli_state * cli, TALLOC_CTX *mem_ctx,
			   const char *msg, uint32 timeout, BOOL do_reboot,
			   BOOL force, uint32 reason);
NTSTATUS cli_shutdown_abort(struct cli_state * cli, TALLOC_CTX *mem_ctx);

/* The following definitions come from rpc_client/cli_spoolss.c  */

WERROR cli_spoolss_open_printer_ex(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				const char *printername, const char *datatype, uint32 access_required,
				const char *station, const char *username, POLICY_HND *pol);
WERROR cli_spoolss_close_printer(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 POLICY_HND *pol);
WERROR cli_spoolss_enum_printers(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 char *name, uint32 flags, uint32 level,
				 uint32 *num_printers, PRINTER_INFO_CTR *ctr);
WERROR cli_spoolss_enum_ports(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      uint32 level, uint32 *num_ports, PORT_INFO_CTR *ctr);
WERROR cli_spoolss_getprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, uint32 level, 
			      PRINTER_INFO_CTR *ctr);
WERROR cli_spoolss_setprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, uint32 level, 
			      PRINTER_INFO_CTR *ctr, uint32 command);
WERROR cli_spoolss_getprinterdriver(struct cli_state *cli, 
				    TALLOC_CTX *mem_ctx, 
				    POLICY_HND *pol, uint32 level, 
				    const char *env, int version, PRINTER_DRIVER_CTR *ctr);
WERROR cli_spoolss_enumprinterdrivers (struct cli_state *cli, 
				       TALLOC_CTX *mem_ctx,
				       uint32 level, const char *env,
				       uint32 *num_drivers,
				       PRINTER_DRIVER_CTR *ctr);
WERROR cli_spoolss_getprinterdriverdir (struct cli_state *cli, 
					TALLOC_CTX *mem_ctx,
					uint32 level, char *env,
					DRIVER_DIRECTORY_CTR *ctr);
WERROR cli_spoolss_addprinterdriver (struct cli_state *cli, 
				     TALLOC_CTX *mem_ctx, uint32 level,
				     PRINTER_DRIVER_CTR *ctr);
WERROR cli_spoolss_addprinterex (struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 uint32 level, PRINTER_INFO_CTR*ctr);
WERROR cli_spoolss_deleteprinterdriverex(struct cli_state *cli, 
                                         TALLOC_CTX *mem_ctx, const char *arch,
                                         const char *driver, int version);
WERROR cli_spoolss_deleteprinterdriver (struct cli_state *cli, 
					TALLOC_CTX *mem_ctx, const char *arch,
					const char *driver);
WERROR cli_spoolss_getprintprocessordirectory(struct cli_state *cli,
					      TALLOC_CTX *mem_ctx,
					      char *name, char *environment,
					      fstring procdir);
WERROR cli_spoolss_addform(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			   POLICY_HND *handle, uint32 level, FORM *form);
WERROR cli_spoolss_setform(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			   POLICY_HND *handle, uint32 level, 
			   const char *form_name, FORM *form);
WERROR cli_spoolss_getform(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			   POLICY_HND *handle, const char *formname, 
			   uint32 level, FORM_1 *form);
WERROR cli_spoolss_deleteform(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *handle, const char *form_name);
WERROR cli_spoolss_enumforms(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			     POLICY_HND *handle, int level, uint32 *num_forms,
			     FORM_1 **forms);
WERROR cli_spoolss_enumjobs(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			    POLICY_HND *hnd, uint32 level, uint32 firstjob, 
			    uint32 num_jobs, uint32 *returned, JOB_INFO_CTR *ctr);
WERROR cli_spoolss_setjob(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			  POLICY_HND *hnd, uint32 jobid, uint32 level, 
			  uint32 command);
WERROR cli_spoolss_getjob(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			  POLICY_HND *hnd, uint32 jobid, uint32 level,
			  JOB_INFO_CTR *ctr);
WERROR cli_spoolss_startpageprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				    POLICY_HND *hnd);
WERROR cli_spoolss_endpageprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				  POLICY_HND *hnd);
WERROR cli_spoolss_startdocprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				   POLICY_HND *hnd, char *docname, 
				   char *outputfile, char *datatype, 
				   uint32 *jobid);
WERROR cli_spoolss_enddocprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				  POLICY_HND *hnd);
WERROR cli_spoolss_getprinterdata(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				  POLICY_HND *hnd, const char *valuename, 
				  REGISTRY_VALUE *value);
WERROR cli_spoolss_getprinterdataex(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				    POLICY_HND *hnd, const char *keyname, 
				    const char *valuename, 
				    REGISTRY_VALUE *value);
WERROR cli_spoolss_setprinterdata(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				  POLICY_HND *hnd, REGISTRY_VALUE *value);
WERROR cli_spoolss_setprinterdataex(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				    POLICY_HND *hnd, char *keyname, 
				    REGISTRY_VALUE *value);
WERROR cli_spoolss_enumprinterdata(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				   POLICY_HND *hnd, uint32 ndx,
				   uint32 value_offered, uint32 data_offered,
				   uint32 *value_needed, uint32 *data_needed,
				   REGISTRY_VALUE *value);
WERROR cli_spoolss_enumprinterdataex(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				     POLICY_HND *hnd, const char *keyname, 
				     REGVAL_CTR *ctr);
WERROR cli_spoolss_writeprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				POLICY_HND *hnd, uint32 data_size, char *data,
				uint32 *num_written);
WERROR cli_spoolss_deleteprinterdata(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				     POLICY_HND *hnd, char *valuename);
WERROR cli_spoolss_deleteprinterdataex(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				       POLICY_HND *hnd, char *keyname, 
				       char *valuename);
WERROR cli_spoolss_enumprinterkey(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				  POLICY_HND *hnd, const char *keyname,
				  uint16 **keylist, uint32 *len);
WERROR cli_spoolss_deleteprinterkey(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				    POLICY_HND *hnd, char *keyname);

/* The following definitions come from rpc_client/cli_spoolss_notify.c  */

WERROR cli_spoolss_reply_open_printer(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				      const char *printer, uint32 printerlocal, uint32 type, 
				      POLICY_HND *handle);
WERROR cli_spoolss_reply_close_printer(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				       POLICY_HND *handle);
WERROR cli_spoolss_routerreplyprinter(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				      POLICY_HND *pol, uint32 condition, uint32 change_id);
WERROR cli_spoolss_rrpcn(struct cli_state *cli, TALLOC_CTX *mem_ctx, 
			 POLICY_HND *pol, uint32 notify_data_len,
			 SPOOL_NOTIFY_INFO_DATA *notify_data,
			 uint32 change_low, uint32 change_high);
WERROR cli_spoolss_rffpcnex(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			    POLICY_HND *pol, uint32 flags, uint32 options,
			    const char *localmachine, uint32 printerlocal,
			    SPOOL_NOTIFY_OPTION *option);

/* The following definitions come from rpc_client/cli_srvsvc.c  */

WERROR cli_srvsvc_net_srv_get_info(struct cli_state *cli, 
				   TALLOC_CTX *mem_ctx,
				   uint32 switch_value, SRV_INFO_CTR *ctr);
WERROR cli_srvsvc_net_share_enum(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 uint32 info_level, SRV_SHARE_INFO_CTR *ctr,
				 int preferred_len, ENUM_HND *hnd);
WERROR cli_srvsvc_net_share_get_info(struct cli_state *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *sharename,
				     uint32 info_level,
				     SRV_SHARE_INFO *info);
WERROR cli_srvsvc_net_share_set_info(struct cli_state *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *sharename,
				     uint32 info_level,
				     SRV_SHARE_INFO *info);
WERROR cli_srvsvc_net_share_del(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				const char *sharename);
WERROR cli_srvsvc_net_share_add(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				const char *netname, uint32 type, 
				const char *remark, uint32 perms, 
				uint32 max_uses, uint32 num_uses, 
				const char *path, const char *passwd,
				int level, SEC_DESC *sd);
WERROR cli_srvsvc_net_remote_tod(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 char *server, TIME_OF_DAY_INFO *tod);
WERROR cli_srvsvc_net_file_enum(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				uint32 file_level, const char *user_name,
				SRV_FILE_INFO_CTR *ctr,	int preferred_len,
				ENUM_HND *hnd);
WERROR cli_srvsvc_net_file_close(struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 uint32 file_id);

/* The following definitions come from rpc_client/cli_svcctl.c  */

const char* svc_status_string( uint32 state );
WERROR cli_svcctl_open_scm( struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                              POLICY_HND *hSCM, uint32 access_desired );
WERROR cli_svcctl_open_service( struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                POLICY_HND *hSCM, POLICY_HND *hService, 
				const char *servicename, uint32 access_desired );
WERROR cli_svcctl_close_service( struct cli_state *cli, TALLOC_CTX *mem_ctx, POLICY_HND *hService );
WERROR cli_svcctl_enumerate_services( struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                      POLICY_HND *hSCM, uint32 type, uint32 state, 
				      uint32 *returned, ENUM_SERVICES_STATUS **service_array  );
WERROR cli_svcctl_query_status( struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *hService, SERVICE_STATUS *status );
WERROR cli_svcctl_query_config(struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *hService, SERVICE_CONFIG *config );
WERROR cli_svcctl_start_service( struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *hService,
                                 const char **parm_array, uint32 parmcount );
WERROR cli_svcctl_control_service( struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                   POLICY_HND *hService, uint32 control,
				   SERVICE_STATUS *status );
WERROR cli_svcctl_get_dispname( struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                POLICY_HND *hService, fstring displayname );

/* The following definitions come from rpc_client/cli_wkssvc.c  */

NTSTATUS cli_wks_query_info(struct cli_state *cli, TALLOC_CTX *mem_ctx,
			    WKS_INFO_100 *wks100);

/* The following definitions come from rpc_parse/parse_buffer.c  */

void rpcbuf_init(RPC_BUFFER *buffer, uint32 size, TALLOC_CTX *ctx);
BOOL prs_rpcbuffer(const char *desc, prs_struct *ps, int depth, RPC_BUFFER *buffer);
BOOL prs_rpcbuffer_p(const char *desc, prs_struct *ps, int depth, RPC_BUFFER **buffer);
BOOL rpcbuf_alloc_size(RPC_BUFFER *buffer, uint32 buffer_size);
void rpcbuf_move(RPC_BUFFER *src, RPC_BUFFER **dest);
uint32 rpcbuf_get_size(RPC_BUFFER *buffer);
BOOL smb_io_relstr(const char *desc, RPC_BUFFER *buffer, int depth, UNISTR *string);
BOOL smb_io_relarraystr(const char *desc, RPC_BUFFER *buffer, int depth, uint16 **string);
BOOL smb_io_relsecdesc(const char *desc, RPC_BUFFER *buffer, int depth, SEC_DESC **secdesc);
uint32 size_of_relative_string(UNISTR *string);

/* The following definitions come from rpc_parse/parse_dfs.c  */

void init_dfs_q_dfs_exist(DFS_Q_DFS_EXIST *q_d);
BOOL dfs_io_q_dfs_exist(const char *desc, DFS_Q_DFS_EXIST *q_d, prs_struct *ps, int depth);
BOOL dfs_io_r_dfs_exist(const char *desc, DFS_R_DFS_EXIST *q_d, prs_struct *ps, int depth);
BOOL init_dfs_q_dfs_remove(DFS_Q_DFS_REMOVE *q_d, const char *entrypath, 
			   const char *servername, const char *sharename);
BOOL dfs_io_q_dfs_remove(const char *desc, DFS_Q_DFS_REMOVE *q_d, prs_struct *ps, int depth);
BOOL dfs_io_r_dfs_remove(const char *desc, DFS_R_DFS_REMOVE *r_d, prs_struct *ps, int depth);
BOOL init_dfs_q_dfs_add(DFS_Q_DFS_ADD *q_d, const char *entrypath, 
			const char *servername, const char *sharename, 
			const char *comment, uint32 flags);
BOOL dfs_io_q_dfs_add(const char *desc, DFS_Q_DFS_ADD *q_d, prs_struct *ps, int depth);
BOOL dfs_io_r_dfs_add(const char *desc, DFS_R_DFS_ADD *r_d, prs_struct *ps, int depth);
BOOL init_dfs_q_dfs_get_info(DFS_Q_DFS_GET_INFO *q_d, const char *entrypath,
			     const char *servername, const char *sharename, 
			     uint32 info_level);
BOOL dfs_io_q_dfs_get_info(const char *desc, DFS_Q_DFS_GET_INFO* q_i, prs_struct* ps, int depth);
BOOL dfs_io_r_dfs_get_info(const char *desc, DFS_R_DFS_GET_INFO* r_i, prs_struct* ps, int depth);
BOOL init_dfs_q_dfs_enum(DFS_Q_DFS_ENUM *q_d, uint32 level, DFS_INFO_CTR *ctr);
BOOL dfs_io_q_dfs_enum(const char *desc, DFS_Q_DFS_ENUM *q_d, prs_struct *ps, int depth);
BOOL dfs_io_dfs_info_ctr(const char *desc, DFS_INFO_CTR* ctr, uint32 num_entries, uint32 level, prs_struct* ps, int depth);
BOOL dfs_io_r_dfs_enum(const char *desc, DFS_R_DFS_ENUM *q_d, prs_struct *ps, int depth);
BOOL dfs_io_dfs_storage_info(const char *desc, DFS_INFO_3* info3, prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_ds.c  */

BOOL ds_io_q_getprimdominfo( const char *desc, prs_struct *ps, int depth, DS_Q_GETPRIMDOMINFO *q_u);
BOOL ds_io_r_getprimdominfo( const char *desc, prs_struct *ps, int depth, DS_R_GETPRIMDOMINFO *r_u);
BOOL init_q_ds_enum_domain_trusts( DS_Q_ENUM_DOM_TRUSTS *q, const char *server, 
                                 uint32 flags );
BOOL ds_io_q_enum_domain_trusts( const char *desc, prs_struct *ps, int depth, DS_Q_ENUM_DOM_TRUSTS *q_u);
BOOL ds_io_r_enum_domain_trusts( const char *desc, prs_struct *ps, int depth, DS_R_ENUM_DOM_TRUSTS *r_u);

/* The following definitions come from rpc_parse/parse_echo.c  */

void init_echo_q_add_one(ECHO_Q_ADD_ONE *q_d, uint32 request);
BOOL echo_io_q_add_one(const char *desc, ECHO_Q_ADD_ONE *q_d,
		       prs_struct *ps, int depth);
BOOL echo_io_r_add_one(const char *desc, ECHO_R_ADD_ONE *q_d,
		       prs_struct *ps, int depth);
void init_echo_q_echo_data(ECHO_Q_ECHO_DATA *q_d, uint32 size, char *data);
BOOL echo_io_q_echo_data(const char *desc, ECHO_Q_ECHO_DATA *q_d,
			  prs_struct *ps, int depth);
BOOL echo_io_r_echo_data(const char *desc, ECHO_R_ECHO_DATA *q_d,
			  prs_struct *ps, int depth);
void init_echo_q_sink_data(ECHO_Q_SINK_DATA *q_d, uint32 size, char *data);
BOOL echo_io_q_sink_data(const char *desc, ECHO_Q_SINK_DATA *q_d,
			 prs_struct *ps, int depth);
BOOL echo_io_r_sink_data(const char *desc, ECHO_R_SINK_DATA *q_d,
			 prs_struct *ps, int depth);
void init_echo_q_source_data(ECHO_Q_SOURCE_DATA *q_d, uint32 size);
BOOL echo_io_q_source_data(const char *desc, ECHO_Q_SOURCE_DATA *q_d,
			 prs_struct *ps, int depth);
BOOL echo_io_r_source_data(const char *desc, ECHO_R_SOURCE_DATA *q_d,
			   prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_eventlog.c  */

BOOL eventlog_io_q_open_eventlog(const char *desc, EVENTLOG_Q_OPEN_EVENTLOG *q_u,
				 prs_struct *ps, int depth);
BOOL eventlog_io_r_open_eventlog(const char *desc, EVENTLOG_R_OPEN_EVENTLOG *r_u,
				 prs_struct *ps, int depth);
BOOL eventlog_io_q_get_num_records(const char *desc, EVENTLOG_Q_GET_NUM_RECORDS *q_u,
				   prs_struct *ps, int depth);
BOOL eventlog_io_r_get_num_records(const char *desc, EVENTLOG_R_GET_NUM_RECORDS *r_u,
				   prs_struct *ps, int depth);
BOOL eventlog_io_q_get_oldest_entry(const char *desc, EVENTLOG_Q_GET_OLDEST_ENTRY *q_u,
				    prs_struct *ps, int depth);
BOOL eventlog_io_r_get_oldest_entry(const char *desc, EVENTLOG_R_GET_OLDEST_ENTRY *r_u,
				    prs_struct *ps, int depth);
BOOL eventlog_io_q_close_eventlog(const char *desc, EVENTLOG_Q_CLOSE_EVENTLOG *q_u,
				  prs_struct *ps, int depth);
BOOL eventlog_io_r_close_eventlog(const char *desc, EVENTLOG_R_CLOSE_EVENTLOG *r_u,
				  prs_struct *ps, int depth);
BOOL eventlog_io_q_read_eventlog(const char *desc, EVENTLOG_Q_READ_EVENTLOG *q_u,
				 prs_struct *ps, int depth);
BOOL eventlog_io_r_read_eventlog(const char *desc,
				 EVENTLOG_Q_READ_EVENTLOG *q_u,
				 EVENTLOG_R_READ_EVENTLOG *r_u,
				 prs_struct *ps,
				 int depth);
BOOL eventlog_io_q_clear_eventlog(const char *desc, EVENTLOG_Q_CLEAR_EVENTLOG *q_u,
				  prs_struct *ps, int depth);
BOOL eventlog_io_r_clear_eventlog(const char *desc, EVENTLOG_R_CLEAR_EVENTLOG *r_u,
				  prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_lsa.c  */

void init_lsa_trans_name(LSA_TRANS_NAME *trn, UNISTR2 *uni_name,
			 uint16 sid_name_use, const char *name, uint32 idx);
void init_lsa_sec_qos(LSA_SEC_QOS *qos, uint16 imp_lev, uint8 ctxt, uint8 eff);
void init_q_open_pol(LSA_Q_OPEN_POL *in, uint16 system_name,
		     uint32 attributes, uint32 desired_access,
		     LSA_SEC_QOS *qos);
BOOL lsa_io_q_open_pol(const char *desc, LSA_Q_OPEN_POL *in, prs_struct *ps, 
		       int depth);
BOOL lsa_io_r_open_pol(const char *desc, LSA_R_OPEN_POL *out, prs_struct *ps, 
		       int depth);
void init_q_open_pol2(LSA_Q_OPEN_POL2 *in, const char *server_name,
			uint32 attributes, uint32 desired_access,
			LSA_SEC_QOS *qos);
BOOL lsa_io_q_open_pol2(const char *desc, LSA_Q_OPEN_POL2 *in, prs_struct *ps, 
			int depth);
BOOL lsa_io_r_open_pol2(const char *desc, LSA_R_OPEN_POL2 *out, prs_struct *ps, 
			int depth);
void init_q_query_sec_obj(LSA_Q_QUERY_SEC_OBJ *in, const POLICY_HND *hnd, 
			  uint32 sec_info);
BOOL lsa_io_q_query_sec_obj(const char *desc, LSA_Q_QUERY_SEC_OBJ *in, 
			    prs_struct *ps, int depth);
BOOL lsa_io_r_query_sec_obj(const char *desc, LSA_R_QUERY_SEC_OBJ *out, prs_struct *ps, int depth);
void init_q_query(LSA_Q_QUERY_INFO *in, POLICY_HND *hnd, uint16 info_class);
BOOL lsa_io_q_query(const char *desc, LSA_Q_QUERY_INFO *in, prs_struct *ps, 
		    int depth);
BOOL init_q_enum_trust_dom(LSA_Q_ENUM_TRUST_DOM * q_e, POLICY_HND *pol,
			   uint32 enum_context, uint32 preferred_len);
BOOL lsa_io_q_enum_trust_dom(const char *desc, LSA_Q_ENUM_TRUST_DOM *q_e, 
			     prs_struct *ps, int depth);
void init_r_enum_trust_dom(TALLOC_CTX *ctx, LSA_R_ENUM_TRUST_DOM *out, uint32 enum_context,
			   uint32 req_num_domains, uint32 num_domains, TRUSTDOM **td);
BOOL lsa_io_domain_list( const char *desc, prs_struct *ps, int depth, DOMAIN_LIST *domlist );
BOOL lsa_io_r_enum_trust_dom(const char *desc, LSA_R_ENUM_TRUST_DOM *out, 
			     prs_struct *ps, int depth);
BOOL lsa_io_r_query(const char *desc, LSA_R_QUERY_INFO *out, prs_struct *ps, int depth);
void init_q_lookup_sids(TALLOC_CTX *mem_ctx, LSA_Q_LOOKUP_SIDS *q_l, 
			POLICY_HND *hnd, int num_sids, const DOM_SID *sids,
			uint16 level);
BOOL lsa_io_q_lookup_sids(const char *desc, LSA_Q_LOOKUP_SIDS *q_s, prs_struct *ps,
			  int depth);
BOOL lsa_io_r_lookup_sids(const char *desc, LSA_R_LOOKUP_SIDS *r_s, 
			  prs_struct *ps, int depth);
void init_q_lookup_names(TALLOC_CTX *mem_ctx, LSA_Q_LOOKUP_NAMES *q_l, 
			 POLICY_HND *hnd, int num_names, const char **names);
BOOL lsa_io_q_lookup_names(const char *desc, LSA_Q_LOOKUP_NAMES *q_r, 
			   prs_struct *ps, int depth);
BOOL lsa_io_r_lookup_names(const char *desc, LSA_R_LOOKUP_NAMES *out, prs_struct *ps, int depth);
void init_lsa_q_close(LSA_Q_CLOSE *in, POLICY_HND *hnd);
BOOL lsa_io_q_close(const char *desc, LSA_Q_CLOSE *in, prs_struct *ps, int depth);
BOOL lsa_io_r_close(const char *desc,  LSA_R_CLOSE *out, prs_struct *ps, int depth);
BOOL lsa_io_q_open_secret(const char *desc, LSA_Q_OPEN_SECRET *in, prs_struct *ps, int depth);
BOOL lsa_io_r_open_secret(const char *desc, LSA_R_OPEN_SECRET *out, prs_struct *ps, int depth);
void init_q_enum_privs(LSA_Q_ENUM_PRIVS *in, POLICY_HND *hnd, uint32 enum_context, uint32 pref_max_length);
BOOL lsa_io_q_enum_privs(const char *desc, LSA_Q_ENUM_PRIVS *in, prs_struct *ps, int depth);
void init_lsa_r_enum_privs(LSA_R_ENUM_PRIVS *out, uint32 enum_context,
			  uint32 count, LSA_PRIV_ENTRY *entries);
BOOL lsa_io_r_enum_privs(const char *desc, LSA_R_ENUM_PRIVS *out, prs_struct *ps, int depth);
void init_lsa_priv_get_dispname(LSA_Q_PRIV_GET_DISPNAME *trn, POLICY_HND *hnd, const char *name, uint16 lang_id, uint16 lang_id_sys);
BOOL lsa_io_q_priv_get_dispname(const char *desc, LSA_Q_PRIV_GET_DISPNAME *in, prs_struct *ps, int depth);
BOOL lsa_io_r_priv_get_dispname(const char *desc, LSA_R_PRIV_GET_DISPNAME *out, prs_struct *ps, int depth);
void init_lsa_q_enum_accounts(LSA_Q_ENUM_ACCOUNTS *trn, POLICY_HND *hnd, uint32 enum_context, uint32 pref_max_length);
BOOL lsa_io_q_enum_accounts(const char *desc, LSA_Q_ENUM_ACCOUNTS *in, prs_struct *ps, int depth);
void init_lsa_r_enum_accounts(LSA_R_ENUM_ACCOUNTS *out, uint32 enum_context);
BOOL lsa_io_r_enum_accounts(const char *desc, LSA_R_ENUM_ACCOUNTS *out, prs_struct *ps, int depth);
BOOL lsa_io_q_unk_get_connuser(const char *desc, LSA_Q_UNK_GET_CONNUSER *in, prs_struct *ps, int depth);
BOOL lsa_io_r_unk_get_connuser(const char *desc, LSA_R_UNK_GET_CONNUSER *out, prs_struct *ps, int depth);
void init_lsa_q_create_account(LSA_Q_CREATEACCOUNT *trn, POLICY_HND *hnd, DOM_SID *sid, uint32 desired_access);
BOOL lsa_io_q_create_account(const char *desc, LSA_Q_CREATEACCOUNT *out, prs_struct *ps, int depth);
BOOL lsa_io_r_create_account(const char *desc, LSA_R_CREATEACCOUNT  *out, prs_struct *ps, int depth);
void init_lsa_q_open_account(LSA_Q_OPENACCOUNT *trn, POLICY_HND *hnd, DOM_SID *sid, uint32 desired_access);
BOOL lsa_io_q_open_account(const char *desc, LSA_Q_OPENACCOUNT *out, prs_struct *ps, int depth);
BOOL lsa_io_r_open_account(const char *desc, LSA_R_OPENACCOUNT  *out, prs_struct *ps, int depth);
void init_lsa_q_enum_privsaccount(LSA_Q_ENUMPRIVSACCOUNT *trn, POLICY_HND *hnd);
BOOL lsa_io_q_enum_privsaccount(const char *desc, LSA_Q_ENUMPRIVSACCOUNT *out, prs_struct *ps, int depth);
NTSTATUS init_lsa_r_enum_privsaccount(TALLOC_CTX *mem_ctx, LSA_R_ENUMPRIVSACCOUNT *out, LUID_ATTR *set, uint32 count, uint32 control);
BOOL lsa_io_r_enum_privsaccount(const char *desc, LSA_R_ENUMPRIVSACCOUNT *out, prs_struct *ps, int depth);
BOOL lsa_io_q_getsystemaccount(const char *desc, LSA_Q_GETSYSTEMACCOUNT  *out, prs_struct *ps, int depth);
BOOL lsa_io_r_getsystemaccount(const char *desc, LSA_R_GETSYSTEMACCOUNT  *out, prs_struct *ps, int depth);
BOOL lsa_io_q_setsystemaccount(const char *desc, LSA_Q_SETSYSTEMACCOUNT  *out, prs_struct *ps, int depth);
BOOL lsa_io_r_setsystemaccount(const char *desc, LSA_R_SETSYSTEMACCOUNT  *out, prs_struct *ps, int depth);
void init_lsa_q_lookup_priv_value(LSA_Q_LOOKUP_PRIV_VALUE *q_u, POLICY_HND *hnd, const char *name);
BOOL smb_io_lsa_string( const char *desc, LSA_STRING *string, prs_struct *ps, int depth );
BOOL lsa_io_q_lookup_priv_value(const char *desc, LSA_Q_LOOKUP_PRIV_VALUE  *out, prs_struct *ps, int depth);
BOOL lsa_io_r_lookup_priv_value(const char *desc, LSA_R_LOOKUP_PRIV_VALUE  *out, prs_struct *ps, int depth);
BOOL lsa_io_q_addprivs(const char *desc, LSA_Q_ADDPRIVS *out, prs_struct *ps, int depth);
BOOL lsa_io_r_addprivs(const char *desc, LSA_R_ADDPRIVS *out, prs_struct *ps, int depth);
BOOL lsa_io_q_removeprivs(const char *desc, LSA_Q_REMOVEPRIVS *out, prs_struct *ps, int depth);
BOOL lsa_io_r_removeprivs(const char *desc, LSA_R_REMOVEPRIVS *out, prs_struct *ps, int depth);
BOOL policy_handle_is_valid(const POLICY_HND *hnd);
BOOL lsa_io_dns_dom_info(const char *desc, LSA_DNS_DOM_INFO *info,
			 prs_struct *ps, int depth);
void init_q_query2(LSA_Q_QUERY_INFO2 *in, POLICY_HND *hnd, uint16 info_class);
BOOL lsa_io_q_query_info2(const char *desc, LSA_Q_QUERY_INFO2 *in, prs_struct *ps, int depth);
BOOL lsa_io_r_query_info2(const char *desc, LSA_R_QUERY_INFO2 *out,
			  prs_struct *ps, int depth);
void init_q_enum_acct_rights(LSA_Q_ENUM_ACCT_RIGHTS *in, 
			     POLICY_HND *hnd, 
			     uint32 count, 
			     DOM_SID *sid);
NTSTATUS init_r_enum_acct_rights( LSA_R_ENUM_ACCT_RIGHTS *out, PRIVILEGE_SET *privileges );
BOOL lsa_io_q_enum_acct_rights(const char *desc, LSA_Q_ENUM_ACCT_RIGHTS *in, prs_struct *ps, int depth);
BOOL lsa_io_r_enum_acct_rights(const char *desc, LSA_R_ENUM_ACCT_RIGHTS *out, prs_struct *ps, int depth);
void init_q_add_acct_rights( LSA_Q_ADD_ACCT_RIGHTS *in, POLICY_HND *hnd, 
                             DOM_SID *sid, uint32 count, const char **rights );
BOOL lsa_io_q_add_acct_rights(const char *desc, LSA_Q_ADD_ACCT_RIGHTS *in, prs_struct *ps, int depth);
BOOL lsa_io_r_add_acct_rights(const char *desc, LSA_R_ADD_ACCT_RIGHTS *out, prs_struct *ps, int depth);
void init_q_remove_acct_rights(LSA_Q_REMOVE_ACCT_RIGHTS *in, 
			       POLICY_HND *hnd, 
			       DOM_SID *sid,
			       uint32 removeall,
			       uint32 count, 
			       const char **rights);
BOOL lsa_io_q_remove_acct_rights(const char *desc, LSA_Q_REMOVE_ACCT_RIGHTS *in, prs_struct *ps, int depth);
BOOL lsa_io_r_remove_acct_rights(const char *desc, LSA_R_REMOVE_ACCT_RIGHTS *out, prs_struct *ps, int depth);
void init_lsa_q_open_trusted_domain(LSA_Q_OPEN_TRUSTED_DOMAIN *q, POLICY_HND *hnd, DOM_SID *sid, uint32 desired_access);
BOOL lsa_io_q_open_trusted_domain(const char *desc, LSA_Q_OPEN_TRUSTED_DOMAIN *in, prs_struct *ps, int depth);
BOOL lsa_io_q_open_trusted_domain(const char *desc, LSA_Q_OPEN_TRUSTED_DOMAIN *q_o, prs_struct *ps, int depth);
BOOL lsa_io_r_open_trusted_domain(const char *desc, LSA_R_OPEN_TRUSTED_DOMAIN *out, prs_struct *ps, int depth);
BOOL lsa_io_q_create_trusted_domain(const char *desc, LSA_Q_CREATE_TRUSTED_DOMAIN *in, prs_struct *ps, int depth);
BOOL lsa_io_r_create_trusted_domain(const char *desc, LSA_R_CREATE_TRUSTED_DOMAIN *out, prs_struct *ps, int depth);
BOOL lsa_io_q_create_secret(const char *desc, LSA_Q_CREATE_SECRET *in, prs_struct *ps, int depth);
BOOL lsa_io_r_create_secret(const char *desc, LSA_R_CREATE_SECRET *out, prs_struct *ps, int depth);
BOOL lsa_io_q_set_secret(const char *desc, LSA_Q_SET_SECRET *in, prs_struct *ps, int depth);
BOOL lsa_io_r_set_secret(const char *desc, LSA_R_SET_SECRET *out, prs_struct *ps, int depth);
BOOL lsa_io_q_delete_object(const char *desc, LSA_Q_DELETE_OBJECT *in, prs_struct *ps, int depth);
BOOL lsa_io_r_delete_object(const char *desc, LSA_R_DELETE_OBJECT *out, prs_struct *ps, int depth);
void init_q_query_trusted_domain_info(LSA_Q_QUERY_TRUSTED_DOMAIN_INFO *q, 
				      POLICY_HND *hnd, uint16 info_class) ;
void init_q_query_trusted_domain_info_by_name(LSA_Q_QUERY_TRUSTED_DOMAIN_INFO_BY_NAME *q, 
					      POLICY_HND *hnd, uint16 info_class, 
					      const char *dom_name);
void init_q_query_trusted_domain_info_by_sid(LSA_Q_QUERY_TRUSTED_DOMAIN_INFO_BY_SID *q, 
					     POLICY_HND *hnd, uint16 info_class, 
					     DOM_SID *dom_sid);
BOOL lsa_io_q_query_trusted_domain_info(const char *desc, 
					LSA_Q_QUERY_TRUSTED_DOMAIN_INFO *q_q,
					prs_struct *ps, int depth);
BOOL lsa_io_q_query_trusted_domain_info_by_sid(const char *desc, 
					       LSA_Q_QUERY_TRUSTED_DOMAIN_INFO_BY_SID *q_q,
					       prs_struct *ps, int depth);
BOOL lsa_io_q_query_trusted_domain_info_by_name(const char *desc, 
					        LSA_Q_QUERY_TRUSTED_DOMAIN_INFO_BY_NAME *q_q,
					        prs_struct *ps, int depth);
BOOL lsa_io_r_query_trusted_domain_info(const char *desc, 
					LSA_R_QUERY_TRUSTED_DOMAIN_INFO *r_q, 
					prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_misc.c  */

void set_current_rpc_talloc( TALLOC_CTX *ctx);
void main_loop_talloc_free(void);
TALLOC_CTX *main_loop_talloc_get(void);
TALLOC_CTX *get_talloc_ctx(void);
BOOL smb_io_time(const char *desc, NTTIME *nttime, prs_struct *ps, int depth);
BOOL smb_io_nttime(const char *desc, prs_struct *ps, int depth, NTTIME *nttime);
uint32 get_enum_hnd(ENUM_HND *enh);
void init_enum_hnd(ENUM_HND *enh, uint32 hnd);
BOOL smb_io_enum_hnd(const char *desc, ENUM_HND *hnd, prs_struct *ps, int depth);
BOOL smb_io_dom_sid(const char *desc, DOM_SID *sid, prs_struct *ps, int depth);
void init_dom_sid(DOM_SID *sid, const char *str_sid);
void init_dom_sid2(DOM_SID2 *sid2, const DOM_SID *sid);
BOOL smb_io_dom_sid2_p(const char *desc, prs_struct *ps, int depth, DOM_SID2 **sid2);
BOOL smb_io_dom_sid2(const char *desc, DOM_SID2 *sid, prs_struct *ps, int depth);
BOOL smb_io_uuid(const char *desc, struct uuid *uuid, 
		 prs_struct *ps, int depth);
void init_str_hdr(STRHDR *hdr, int max_len, int len, uint32 buffer);
BOOL smb_io_strhdr(const char *desc,  STRHDR *hdr, prs_struct *ps, int depth);
void init_uni_hdr(UNIHDR *hdr, UNISTR2 *str2);
BOOL smb_io_unihdr(const char *desc, UNIHDR *hdr, prs_struct *ps, int depth);
void init_buf_hdr(BUFHDR *hdr, int max_len, int len);
BOOL smb_io_hdrbuf_pre(const char *desc, BUFHDR *hdr, prs_struct *ps, int depth, uint32 *offset);
BOOL smb_io_hdrbuf_post(const char *desc, BUFHDR *hdr, prs_struct *ps, int depth, 
				uint32 ptr_hdrbuf, uint32 max_len, uint32 len);
BOOL smb_io_hdrbuf(const char *desc, BUFHDR *hdr, prs_struct *ps, int depth);
void init_unistr(UNISTR *str, const char *buf);
BOOL smb_io_unistr(const char *desc, UNISTR *uni, prs_struct *ps, int depth);
size_t create_rpc_blob(RPC_DATA_BLOB *str, size_t len);
void init_rpc_blob_uint32(RPC_DATA_BLOB *str, uint32 val);
void init_rpc_blob_str(RPC_DATA_BLOB *str, const char *buf, int len);
void init_rpc_blob_hex(RPC_DATA_BLOB *str, const char *buf);
void init_rpc_blob_bytes(RPC_DATA_BLOB *str, uint8 *buf, size_t len);
BOOL smb_io_buffer5(const char *desc, BUFFER5 *buf5, prs_struct *ps, int depth);
void init_regval_buffer(REGVAL_BUFFER *str, const uint8 *buf, size_t len);
BOOL smb_io_regval_buffer(const char *desc, prs_struct *ps, int depth, REGVAL_BUFFER *buf2);
void init_buf_unistr2(UNISTR2 *str, uint32 *ptr, const char *buf);
void copy_unistr2(UNISTR2 *str, const UNISTR2 *from);
void init_string2(STRING2 *str, const char *buf, size_t max_len, size_t str_len);
BOOL smb_io_string2(const char *desc, STRING2 *str2, uint32 buffer, prs_struct *ps, int depth);
void init_unistr2(UNISTR2 *str, const char *buf, enum unistr2_term_codes flags);
void init_unistr4(UNISTR4 *uni4, const char *buf, enum unistr2_term_codes flags);
void init_unistr4_w( TALLOC_CTX *ctx, UNISTR4 *uni4, const smb_ucs2_t *buf );
void init_unistr2_w(TALLOC_CTX *ctx, UNISTR2 *str, const smb_ucs2_t *buf);
void init_unistr2_from_unistr(UNISTR2 *to, const UNISTR *from);
void init_unistr2_from_datablob(UNISTR2 *str, DATA_BLOB *blob) ;
BOOL prs_io_unistr2_p(const char *desc, prs_struct *ps, int depth, UNISTR2 **uni2);
BOOL prs_io_unistr2(const char *desc, prs_struct *ps, int depth, UNISTR2 *uni2 );
BOOL smb_io_unistr2(const char *desc, UNISTR2 *uni2, uint32 buffer, prs_struct *ps, int depth);
BOOL prs_unistr4(const char *desc, prs_struct *ps, int depth, UNISTR4 *uni4);
BOOL prs_unistr4_hdr(const char *desc, prs_struct *ps, int depth, UNISTR4 *uni4);
BOOL prs_unistr4_str(const char *desc, prs_struct *ps, int depth, UNISTR4 *uni4);
BOOL prs_unistr4_array(const char *desc, prs_struct *ps, int depth, UNISTR4_ARRAY *array );
BOOL init_unistr4_array( UNISTR4_ARRAY *array, uint32 count, const char **strings );
BOOL smb_io_lockout_string_hdr(const char *desc, HDR_LOCKOUT_STRING *hdr_account_lockout, prs_struct *ps, int depth);
BOOL smb_io_account_lockout_str(const char *desc, LOCKOUT_STRING *account_lockout, uint32 buffer, prs_struct *ps, int depth);
void init_dom_rid2(DOM_RID2 *rid2, uint32 rid, uint8 type, uint32 idx);
BOOL smb_io_dom_rid2(const char *desc, DOM_RID2 *rid2, prs_struct *ps, int depth);
void init_dom_rid3(DOM_RID3 *rid3, uint32 rid, uint8 type);
BOOL smb_io_dom_rid3(const char *desc, DOM_RID3 *rid3, prs_struct *ps, int depth);
void init_dom_rid4(DOM_RID4 *rid4, uint16 unknown, uint16 attr, uint32 rid);
void init_log_info(DOM_LOG_INFO *loginfo, const char *logon_srv, const char *acct_name,
		uint16 sec_chan, const char *comp_name);
BOOL smb_io_log_info(const char *desc, DOM_LOG_INFO *loginfo, prs_struct *ps, int depth);
BOOL smb_io_chal(const char *desc, DOM_CHAL *chal, prs_struct *ps, int depth);
BOOL smb_io_cred(const char *desc,  DOM_CRED *cred, prs_struct *ps, int depth);
void init_clnt_info2(DOM_CLNT_INFO2 *clnt,
				const char *logon_srv, const char *comp_name,
				const DOM_CRED *clnt_cred);
BOOL smb_io_clnt_info2(const char *desc, DOM_CLNT_INFO2 *clnt, prs_struct *ps, int depth);
void init_clnt_info(DOM_CLNT_INFO *clnt,
		const char *logon_srv, const char *acct_name,
		uint16 sec_chan, const char *comp_name,
		const DOM_CRED *cred);
BOOL smb_io_clnt_info(const char *desc,  DOM_CLNT_INFO *clnt, prs_struct *ps, int depth);
void init_logon_id(DOM_LOGON_ID *logonid, uint32 log_id_low, uint32 log_id_high);
BOOL smb_io_logon_id(const char *desc, DOM_LOGON_ID *logonid, prs_struct *ps, int depth);
void init_owf_info(OWF_INFO *hash, const uint8 data[16]);
BOOL smb_io_owf_info(const char *desc, OWF_INFO *hash, prs_struct *ps, int depth);
BOOL smb_io_gid(const char *desc,  DOM_GID *gid, prs_struct *ps, int depth);
BOOL smb_io_pol_hnd(const char *desc, POLICY_HND *pol, prs_struct *ps, int depth);
void init_unistr3(UNISTR3 *str, const char *buf);
BOOL smb_io_unistr3(const char *desc, UNISTR3 *name, prs_struct *ps, int depth);
BOOL prs_uint64(const char *name, prs_struct *ps, int depth, UINT64_S *data64);
BOOL smb_io_bufhdr2(const char *desc, BUFHDR2 *hdr, prs_struct *ps, int depth);
BOOL smb_io_bufhdr4(const char *desc, BUFHDR4 *hdr, prs_struct *ps, int depth);
BOOL smb_io_rpc_blob(const char *desc, RPC_DATA_BLOB *blob, prs_struct *ps, int depth);
BOOL make_uni_hdr(UNIHDR *hdr, int len);
BOOL make_bufhdr2(BUFHDR2 *hdr, uint32 info_level, uint32 length, uint32 buffer);
uint32 str_len_uni(UNISTR *source);

/* The following definitions come from rpc_parse/parse_net.c  */

BOOL net_io_q_logon_ctrl2(const char *desc, NET_Q_LOGON_CTRL2 *q_l, prs_struct *ps, int depth);
void init_net_q_logon_ctrl2(NET_Q_LOGON_CTRL2 *q_l, const char *srv_name,
			    uint32 query_level);
void init_net_r_logon_ctrl2(NET_R_LOGON_CTRL2 *r_l, uint32 query_level,
			    uint32 flags, uint32 pdc_status, 
			    uint32 logon_attempts, uint32 tc_status, 
			    const char *trusted_domain_name);
BOOL net_io_r_logon_ctrl2(const char *desc, NET_R_LOGON_CTRL2 *r_l, prs_struct *ps, int depth);
BOOL net_io_q_logon_ctrl(const char *desc, NET_Q_LOGON_CTRL *q_l, prs_struct *ps, 
			 int depth);
void init_net_q_logon_ctrl(NET_Q_LOGON_CTRL *q_l, const char *srv_name,
			   uint32 query_level);
void init_net_r_logon_ctrl(NET_R_LOGON_CTRL *r_l, uint32 query_level,
			   uint32 flags, uint32 pdc_status);
BOOL net_io_r_logon_ctrl(const char *desc, NET_R_LOGON_CTRL *r_l, prs_struct *ps, 
			 int depth);
void init_net_q_getdcname(NET_Q_GETDCNAME *r_t, const char *logon_server,
			  const char *domainname);
BOOL net_io_q_getdcname(const char *desc, NET_Q_GETDCNAME *r_t, prs_struct *ps,
			int depth);
void init_net_r_getdcname(NET_R_GETDCNAME *r_t, const char *dcname);
BOOL net_io_r_getdcname(const char *desc, NET_R_GETDCNAME *r_t, prs_struct *ps,
			int depth);
void init_r_trust_dom(NET_R_TRUST_DOM_LIST *r_t,
			uint32 num_doms, const char *dom_name);
BOOL net_io_r_trust_dom(const char *desc, NET_R_TRUST_DOM_LIST *r_t, prs_struct *ps, int depth);
BOOL net_io_q_trust_dom(const char *desc, NET_Q_TRUST_DOM_LIST *q_l, prs_struct *ps, int depth);
void init_q_req_chal(NET_Q_REQ_CHAL *q_c,
		     const char *logon_srv, const char *logon_clnt,
		     DOM_CHAL *clnt_chal);
BOOL net_io_q_req_chal(const char *desc,  NET_Q_REQ_CHAL *q_c, prs_struct *ps, int depth);
BOOL net_io_r_req_chal(const char *desc, NET_R_REQ_CHAL *r_c, prs_struct *ps, int depth);
BOOL net_io_q_auth(const char *desc, NET_Q_AUTH *q_a, prs_struct *ps, int depth);
BOOL net_io_r_auth(const char *desc, NET_R_AUTH *r_a, prs_struct *ps, int depth);
void init_q_auth_2(NET_Q_AUTH_2 *q_a,
		const char *logon_srv, const char *acct_name, uint16 sec_chan, const char *comp_name,
		const DOM_CHAL *clnt_chal, uint32 clnt_flgs);
BOOL net_io_q_auth_2(const char *desc, NET_Q_AUTH_2 *q_a, prs_struct *ps, int depth);
BOOL net_io_r_auth_2(const char *desc, NET_R_AUTH_2 *r_a, prs_struct *ps, int depth);
void init_q_auth_3(NET_Q_AUTH_3 *q_a,
		const char *logon_srv, const char *acct_name, uint16 sec_chan, const char *comp_name,
		DOM_CHAL *clnt_chal, uint32 clnt_flgs);
BOOL net_io_q_auth_3(const char *desc, NET_Q_AUTH_3 *q_a, prs_struct *ps, int depth);
BOOL net_io_r_auth_3(const char *desc, NET_R_AUTH_3 *r_a, prs_struct *ps, int depth);
void init_q_srv_pwset(NET_Q_SRV_PWSET *q_s,
		const char *logon_srv, const char *sess_key, const char *acct_name, 
                uint16 sec_chan, const char *comp_name,
		DOM_CRED *cred, uchar hashed_mach_pwd[16]);
BOOL net_io_q_srv_pwset(const char *desc, NET_Q_SRV_PWSET *q_s, prs_struct *ps, int depth);
BOOL net_io_r_srv_pwset(const char *desc, NET_R_SRV_PWSET *r_s, prs_struct *ps, int depth);
void init_id_info1(NET_ID_INFO_1 *id, const char *domain_name,
				uint32 param_ctrl, uint32 log_id_low, uint32 log_id_high,
				const char *user_name, const char *wksta_name,
				const char *sess_key,
				unsigned char lm_cypher[16], unsigned char nt_cypher[16]);
void init_id_info2(NET_ID_INFO_2 * id, const char *domain_name,
		   uint32 param_ctrl,
		   uint32 log_id_low, uint32 log_id_high,
		   const char *user_name, const char *wksta_name,
		   const uchar lm_challenge[8],
		   const uchar * lm_chal_resp, size_t lm_chal_resp_len,
		   const uchar * nt_chal_resp, size_t nt_chal_resp_len);
void init_sam_info(DOM_SAM_INFO *sam,
				const char *logon_srv, const char *comp_name,
				DOM_CRED *clnt_cred,
				DOM_CRED *rtn_cred, uint16 logon_level,
				NET_ID_INFO_CTR *ctr);
void init_net_user_info3(TALLOC_CTX *ctx, NET_USER_INFO_3 *usr, 
			 uint32                user_rid,
			 uint32                group_rid,

			 const char*		user_name,
			 const char*		full_name,
			 const char*		home_dir,
			 const char*		dir_drive,
			 const char*		logon_script,
			 const char*		profile_path,

			 time_t unix_logon_time,
			 time_t unix_logoff_time,
			 time_t unix_kickoff_time,
			 time_t unix_pass_last_set_time,
			 time_t unix_pass_can_change_time,
			 time_t unix_pass_must_change_time,
			 
			 uint16 logon_count, uint16 bad_pw_count,
 		 	 uint32 num_groups, const DOM_GID *gids,
			 uint32 user_flgs, uchar user_session_key[16],
			 uchar lm_session_key[16],
 			 const char *logon_srv, const char *logon_dom,
			 const DOM_SID *dom_sid, const char *other_sids);
BOOL net_io_user_info3(const char *desc, NET_USER_INFO_3 *usr, prs_struct *ps, 
		       int depth, uint16 validation_level);
BOOL net_io_q_sam_logon(const char *desc, NET_Q_SAM_LOGON *q_l, prs_struct *ps, int depth);
BOOL net_io_r_sam_logon(const char *desc, NET_R_SAM_LOGON *r_l, prs_struct *ps, int depth);
BOOL net_io_q_sam_logoff(const char *desc,  NET_Q_SAM_LOGOFF *q_l, prs_struct *ps, int depth);
BOOL net_io_r_sam_logoff(const char *desc, NET_R_SAM_LOGOFF *r_l, prs_struct *ps, int depth);
BOOL init_net_q_sam_sync(NET_Q_SAM_SYNC * q_s, const char *srv_name,
                         const char *cli_name, DOM_CRED *cli_creds, 
                         DOM_CRED *ret_creds, uint32 database_id, 
			 uint32 next_rid);
BOOL net_io_q_sam_sync(const char *desc, NET_Q_SAM_SYNC * q_s, prs_struct *ps,
		       int depth);
BOOL make_sam_account_info(SAM_ACCOUNT_INFO * info,
			   const UNISTR2 *user_name,
			   const UNISTR2 *full_name,
			   uint32 user_rid, uint32 group_rid,
			   const UNISTR2 *home_dir,
			   const UNISTR2 *dir_drive,
			   const UNISTR2 *log_scr,
			   const UNISTR2 *desc,
			   uint32 acb_info,
			   const UNISTR2 *prof_path,
			   const UNISTR2 *wkstas,
			   const UNISTR2 *unk_str, const UNISTR2 *mung_dial);
BOOL net_io_r_sam_sync(const char *desc, uint8 sess_key[16],
		       NET_R_SAM_SYNC * r_s, prs_struct *ps, int depth);
BOOL init_net_q_sam_deltas(NET_Q_SAM_DELTAS *q_s, const char *srv_name, 
                           const char *cli_name, DOM_CRED *cli_creds, 
                           uint32 database_id, UINT64_S dom_mod_count);
BOOL net_io_q_sam_deltas(const char *desc, NET_Q_SAM_DELTAS *q_s, prs_struct *ps,
                         int depth);
BOOL net_io_r_sam_deltas(const char *desc, uint8 sess_key[16],
                         NET_R_SAM_DELTAS *r_s, prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_prs.c  */

void prs_dump(char *name, int v, prs_struct *ps);
void prs_dump_before(char *name, int v, prs_struct *ps);
void prs_dump_region(char *name, int v, prs_struct *ps,
		     int from_off, int to_off);
void prs_debug(prs_struct *ps, int depth, const char *desc, const char *fn_name);
BOOL prs_init(prs_struct *ps, uint32 size, TALLOC_CTX *ctx, BOOL io);
void prs_mem_free(prs_struct *ps);
void prs_mem_clear(prs_struct *ps);
char *prs_alloc_mem_(prs_struct *ps, size_t size, unsigned int count);
char *prs_alloc_mem(prs_struct *ps, size_t size, unsigned int count);
TALLOC_CTX *prs_get_mem_context(prs_struct *ps);
void prs_give_memory(prs_struct *ps, char *buf, uint32 size, BOOL is_dynamic);
char *prs_take_memory(prs_struct *ps, uint32 *psize);
BOOL prs_set_buffer_size(prs_struct *ps, uint32 newsize);
BOOL prs_grow(prs_struct *ps, uint32 extra_space);
BOOL prs_force_grow(prs_struct *ps, uint32 extra_space);
char *prs_data_p(prs_struct *ps);
uint32 prs_data_size(prs_struct *ps);
uint32 prs_offset(prs_struct *ps);
BOOL prs_set_offset(prs_struct *ps, uint32 offset);
BOOL prs_append_prs_data(prs_struct *dst, prs_struct *src);
BOOL prs_append_some_prs_data(prs_struct *dst, prs_struct *src, int32 start, uint32 len);
BOOL prs_copy_data_in(prs_struct *dst, char *src, uint32 len);
BOOL prs_copy_data_out(char *dst, prs_struct *src, uint32 len);
BOOL prs_copy_all_data_out(char *dst, prs_struct *src);
void prs_set_endian_data(prs_struct *ps, BOOL endian);
BOOL prs_align(prs_struct *ps);
BOOL prs_align_uint16(prs_struct *ps);
BOOL prs_align_uint64(prs_struct *ps);
BOOL prs_align_needed(prs_struct *ps, uint32 needed);
char *prs_mem_get(prs_struct *ps, uint32 extra_size);
void prs_switch_type(prs_struct *ps, BOOL io);
void prs_force_dynamic(prs_struct *ps);
BOOL prs_uint8(const char *name, prs_struct *ps, int depth, uint8 *data8);
BOOL prs_pointer( const char *name, prs_struct *ps, int depth, 
                 void **data, size_t data_size,
                 BOOL(*prs_fn)(const char*, prs_struct*, int, void*) );
BOOL prs_uint16(const char *name, prs_struct *ps, int depth, uint16 *data16);
BOOL prs_uint32(const char *name, prs_struct *ps, int depth, uint32 *data32);
BOOL prs_ntstatus(const char *name, prs_struct *ps, int depth, NTSTATUS *status);
BOOL prs_werror(const char *name, prs_struct *ps, int depth, WERROR *status);
BOOL prs_uint8s(BOOL charmode, const char *name, prs_struct *ps, int depth, uint8 *data8s, int len);
BOOL prs_uint16s(BOOL charmode, const char *name, prs_struct *ps, int depth, uint16 *data16s, int len);
BOOL prs_uint16uni(BOOL charmode, const char *name, prs_struct *ps, int depth, uint16 *data16s, int len);
BOOL prs_uint32s(BOOL charmode, const char *name, prs_struct *ps, int depth, uint32 *data32s, int len);
BOOL prs_buffer5(BOOL charmode, const char *name, prs_struct *ps, int depth, BUFFER5 *str);
BOOL prs_regval_buffer(BOOL charmode, const char *name, prs_struct *ps, int depth, REGVAL_BUFFER *buf);
BOOL prs_string2(BOOL charmode, const char *name, prs_struct *ps, int depth, STRING2 *str);
BOOL prs_unistr2(BOOL charmode, const char *name, prs_struct *ps, int depth, UNISTR2 *str);
BOOL prs_unistr3(BOOL charmode, const char *name, UNISTR3 *str, prs_struct *ps, int depth);
BOOL prs_unistr(const char *name, prs_struct *ps, int depth, UNISTR *str);
BOOL prs_string(const char *name, prs_struct *ps, int depth, char *str, int max_buf_size);
BOOL prs_string_alloc(const char *name, prs_struct *ps, int depth,
		      const char **str);
BOOL prs_uint16_pre(const char *name, prs_struct *ps, int depth, uint16 *data16, uint32 *offset);
BOOL prs_uint16_post(const char *name, prs_struct *ps, int depth, uint16 *data16,
				uint32 ptr_uint16, uint32 start_offset);
BOOL prs_uint32_pre(const char *name, prs_struct *ps, int depth, uint32 *data32, uint32 *offset);
BOOL prs_uint32_post(const char *name, prs_struct *ps, int depth, uint32 *data32,
				uint32 ptr_uint32, uint32 data_size);
int tdb_prs_store(TDB_CONTEXT *tdb, char *keystr, prs_struct *ps);
int tdb_prs_fetch(TDB_CONTEXT *tdb, char *keystr, prs_struct *ps, TALLOC_CTX *mem_ctx);
BOOL prs_hash1(prs_struct *ps, uint32 offset, uint8 sess_key[16], int len);
void netsec_encode(struct netsec_auth_struct *a, int auth_flags, 
		   enum netsec_direction direction,
		   RPC_AUTH_NETSEC_CHK * verf,
		   char *data, size_t data_len);
BOOL netsec_decode(struct netsec_auth_struct *a, int auth_flags,
		   enum netsec_direction direction, 
		   RPC_AUTH_NETSEC_CHK * verf, char *data, size_t data_len);

/* The following definitions come from rpc_parse/parse_reg.c  */

void init_reg_q_open_hive( REG_Q_OPEN_HIVE *q_o, uint32 access_desired );
BOOL reg_io_q_open_hive(const char *desc, REG_Q_OPEN_HIVE *q_u,
                        prs_struct *ps, int depth);
BOOL reg_io_r_open_hive(const char *desc,  REG_R_OPEN_HIVE *r_u,
                        prs_struct *ps, int depth);
void init_reg_q_flush_key(REG_Q_FLUSH_KEY *q_u, POLICY_HND *pol);
BOOL reg_io_q_flush_key(const char *desc,  REG_Q_FLUSH_KEY *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_flush_key(const char *desc,  REG_R_FLUSH_KEY *r_u,
                        prs_struct *ps, int depth);
void init_reg_q_create_key_ex(REG_Q_CREATE_KEY_EX *q_c, POLICY_HND *hnd,
                           char *name, char *key_class, uint32 access_desired,
                           SEC_DESC_BUF *sec_buf);
BOOL reg_io_q_create_key_ex(const char *desc,  REG_Q_CREATE_KEY_EX *q_u,
                         prs_struct *ps, int depth);
BOOL reg_io_r_create_key_ex(const char *desc,  REG_R_CREATE_KEY_EX *r_u,
                         prs_struct *ps, int depth);
void init_reg_q_delete_val(REG_Q_DELETE_VALUE *q_c, POLICY_HND *hnd,
                           char *name);
BOOL reg_io_q_delete_value(const char *desc, REG_Q_DELETE_VALUE *q_u,
                         prs_struct *ps, int depth);
BOOL reg_io_r_delete_value(const char *desc,  REG_R_DELETE_VALUE *r_u,
                         prs_struct *ps, int depth);
void init_reg_q_delete_key(REG_Q_DELETE_KEY *q_c, POLICY_HND *hnd,
                           char *name);
BOOL reg_io_q_delete_key(const char *desc,  REG_Q_DELETE_KEY *q_u,
                         prs_struct *ps, int depth);
BOOL reg_io_r_delete_key(const char *desc,  REG_R_DELETE_KEY *r_u, prs_struct *ps, int depth);
void init_reg_q_query_key(REG_Q_QUERY_KEY *q_o, POLICY_HND *hnd, const char *key_class);
BOOL reg_io_q_query_key(const char *desc,  REG_Q_QUERY_KEY *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_query_key(const char *desc,  REG_R_QUERY_KEY *r_u, prs_struct *ps, int depth);
void init_reg_q_getversion(REG_Q_GETVERSION *q_o, POLICY_HND *hnd);
BOOL reg_io_q_getversion(const char *desc,  REG_Q_GETVERSION *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_getversion(const char *desc,  REG_R_GETVERSION *r_u, prs_struct *ps, int depth);
BOOL reg_io_q_restore_key(const char *desc,  REG_Q_RESTORE_KEY *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_restore_key(const char *desc,  REG_R_RESTORE_KEY *r_u, prs_struct *ps, int depth);
void init_q_reg_save_key( REG_Q_SAVE_KEY *q_u, POLICY_HND *handle, const char *fname );
BOOL reg_io_q_save_key(const char *desc,  REG_Q_SAVE_KEY *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_save_key(const char *desc,  REG_R_SAVE_KEY *r_u, prs_struct *ps, int depth);
void init_reg_q_close(REG_Q_CLOSE *q_c, POLICY_HND *hnd);
BOOL reg_io_q_close(const char *desc,  REG_Q_CLOSE *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_close(const char *desc,  REG_R_CLOSE *r_u, prs_struct *ps, int depth);
void init_reg_q_set_key_sec(REG_Q_SET_KEY_SEC *q_u, POLICY_HND *pol,
                            uint32 sec_info, SEC_DESC_BUF *sec_desc_buf);
BOOL reg_io_q_set_key_sec(const char *desc,  REG_Q_SET_KEY_SEC *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_set_key_sec(const char *desc, REG_R_SET_KEY_SEC *q_u, prs_struct *ps, int depth);
void init_reg_q_get_key_sec(REG_Q_GET_KEY_SEC *q_u, POLICY_HND *pol, 
                            uint32 sec_info, uint32 sec_buf_size,
                            SEC_DESC_BUF *psdb);
BOOL reg_io_q_get_key_sec(const char *desc,  REG_Q_GET_KEY_SEC *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_get_key_sec(const char *desc,  REG_R_GET_KEY_SEC *q_u, prs_struct *ps, int depth);
BOOL init_reg_q_query_value(REG_Q_QUERY_VALUE *q_u, POLICY_HND *pol, const char *val_name,
                     REGVAL_BUFFER *value_output);
BOOL reg_io_q_query_value(const char *desc,  REG_Q_QUERY_VALUE *q_u, prs_struct *ps, int depth);
BOOL init_reg_r_query_value(uint32 include_keyval, REG_R_QUERY_VALUE *r_u,
		     REGISTRY_VALUE *val, WERROR status);
BOOL reg_io_r_query_value(const char *desc, REG_R_QUERY_VALUE *r_u, prs_struct *ps, int depth);
void init_reg_q_enum_val(REG_Q_ENUM_VALUE *q_u, POLICY_HND *pol,
				uint32 val_idx,
				uint32 max_name_len, uint32 max_buf_len);
void init_reg_r_enum_val(REG_R_ENUM_VALUE *r_u, REGISTRY_VALUE *val );
BOOL reg_io_q_enum_val(const char *desc,  REG_Q_ENUM_VALUE *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_enum_val(const char *desc,  REG_R_ENUM_VALUE *r_u, prs_struct *ps, int depth);
void init_reg_q_set_val(REG_Q_SET_VALUE *q_u, POLICY_HND *pol,
				char *val_name, uint32 type,
				RPC_DATA_BLOB *val);
BOOL reg_io_q_set_value(const char *desc,  REG_Q_SET_VALUE *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_set_value(const char *desc,  REG_R_SET_VALUE *q_u, prs_struct *ps, int depth);
void init_reg_q_enum_key(REG_Q_ENUM_KEY *q_u, POLICY_HND *pol, uint32 key_idx);
void init_reg_r_enum_key(REG_R_ENUM_KEY *r_u, char *subkey );
BOOL reg_io_q_enum_key(const char *desc,  REG_Q_ENUM_KEY *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_enum_key(const char *desc,  REG_R_ENUM_KEY *q_u, prs_struct *ps, int depth);
void init_reg_q_open_entry(REG_Q_OPEN_ENTRY *q_u, POLICY_HND *pol,
				char *key_name, uint32 access_desired);
BOOL reg_io_q_open_entry(const char *desc,  REG_Q_OPEN_ENTRY *q_u, prs_struct *ps, int depth);
BOOL reg_io_r_open_entry(const char *desc,  REG_R_OPEN_ENTRY *r_u, prs_struct *ps, int depth);
void init_reg_q_shutdown(REG_Q_SHUTDOWN *q_u, const char *msg,
			uint32 timeout, BOOL do_reboot, BOOL force);
void init_reg_q_shutdown_ex(REG_Q_SHUTDOWN_EX * q_u_ex, const char *msg,
			uint32 timeout, BOOL do_reboot, BOOL force, uint32 reason);
BOOL reg_io_q_shutdown(const char *desc, REG_Q_SHUTDOWN *q_u, prs_struct *ps,
		       int depth);
BOOL reg_io_r_shutdown(const char *desc, REG_R_SHUTDOWN *r_u, prs_struct *ps,
		       int depth);
BOOL reg_io_q_shutdown_ex(const char *desc, REG_Q_SHUTDOWN_EX *q_u, prs_struct *ps,
		       int depth);
BOOL reg_io_r_shutdown_ex(const char *desc, REG_R_SHUTDOWN_EX *r_u, prs_struct *ps,
		       int depth);
void init_reg_q_abort_shutdown(REG_Q_ABORT_SHUTDOWN *q_u);
BOOL reg_io_q_abort_shutdown(const char *desc, REG_Q_ABORT_SHUTDOWN *q_u,
			     prs_struct *ps, int depth);
BOOL reg_io_r_abort_shutdown(const char *desc, REG_R_ABORT_SHUTDOWN *r_u,
			     prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_rpc.c  */

void init_rpc_hdr(RPC_HDR *hdr, enum RPC_PKT_TYPE pkt_type, uint8 flags,
				uint32 call_id, int data_len, int auth_len);
BOOL smb_io_rpc_hdr(const char *desc,  RPC_HDR *rpc, prs_struct *ps, int depth);
void init_rpc_context(RPC_CONTEXT *rpc_ctx, uint16 context_id, RPC_IFACE *abstract, RPC_IFACE *transfer);
void init_rpc_hdr_rb(RPC_HDR_RB *rpc, 
				uint16 max_tsize, uint16 max_rsize, uint32 assoc_gid,
				RPC_CONTEXT *context);
BOOL smb_io_rpc_context(const char *desc, RPC_CONTEXT *rpc_ctx, prs_struct *ps, int depth);
BOOL smb_io_rpc_hdr_rb(const char *desc, RPC_HDR_RB *rpc, prs_struct *ps, int depth);
void init_rpc_hdr_ba(RPC_HDR_BA *rpc, 
				uint16 max_tsize, uint16 max_rsize, uint32 assoc_gid,
				const char *pipe_addr,
				uint8 num_results, uint16 result, uint16 reason,
				RPC_IFACE *transfer);
BOOL smb_io_rpc_hdr_ba(const char *desc, RPC_HDR_BA *rpc, prs_struct *ps, int depth);
void init_rpc_hdr_req(RPC_HDR_REQ *hdr, uint32 alloc_hint, uint16 opnum);
BOOL smb_io_rpc_hdr_req(const char *desc, RPC_HDR_REQ *rpc, prs_struct *ps, int depth);
BOOL smb_io_rpc_hdr_resp(const char *desc, RPC_HDR_RESP *rpc, prs_struct *ps, int depth);
BOOL smb_io_rpc_hdr_fault(const char *desc, RPC_HDR_FAULT *rpc, prs_struct *ps, int depth);
void init_rpc_hdr_auth(RPC_HDR_AUTH *rai,
				uint8 auth_type, uint8 auth_level,
				uint8 auth_pad_len,
				uint32 auth_context_id);
BOOL smb_io_rpc_hdr_auth(const char *desc, RPC_HDR_AUTH *rai, prs_struct *ps, int depth);
void init_rpc_hdr_autha(RPC_HDR_AUTHA *rai,
				uint16 max_tsize, uint16 max_rsize,
				RPC_HDR_AUTH *auth);
BOOL smb_io_rpc_hdr_autha(const char *desc, RPC_HDR_AUTHA *rai, prs_struct *ps, int depth);
BOOL rpc_auth_verifier_chk(RPC_AUTH_VERIFIER *rav,
				const char *signature, uint32 msg_type);
void init_rpc_auth_verifier(RPC_AUTH_VERIFIER *rav,
				const char *signature, uint32 msg_type);
BOOL smb_io_rpc_auth_verifier(const char *desc, RPC_AUTH_VERIFIER *rav, prs_struct *ps, int depth);
BOOL smb_io_rpc_netsec_verifier(const char *desc, RPC_AUTH_VERIFIER *rav, prs_struct *ps, int depth);
void init_rpc_auth_ntlmssp_neg(RPC_AUTH_NTLMSSP_NEG *neg,
				uint32 neg_flgs,
				const char *myname, const char *domain);
BOOL smb_io_rpc_auth_ntlmssp_neg(const char *desc, RPC_AUTH_NTLMSSP_NEG *neg, prs_struct *ps, int depth);
void init_rpc_auth_ntlmssp_chal(RPC_AUTH_NTLMSSP_CHAL *chl,
				uint32 neg_flags,
				uint8 challenge[8]);
BOOL smb_io_rpc_auth_ntlmssp_chal(const char *desc, RPC_AUTH_NTLMSSP_CHAL *chl, prs_struct *ps, int depth);
void init_rpc_auth_ntlmssp_resp(RPC_AUTH_NTLMSSP_RESP *rsp,
				uchar lm_resp[24], uchar nt_resp[24],
				const char *domain, const char *user, const char *wks,
				uint32 neg_flags);
BOOL smb_io_rpc_auth_ntlmssp_resp(const char *desc, RPC_AUTH_NTLMSSP_RESP *rsp, prs_struct *ps, int depth);
BOOL rpc_auth_ntlmssp_chk(RPC_AUTH_NTLMSSP_CHK *chk, uint32 crc32, uint32 seq_num);
void init_rpc_auth_ntlmssp_chk(RPC_AUTH_NTLMSSP_CHK *chk,
				uint32 ver, uint32 crc32, uint32 seq_num);
BOOL smb_io_rpc_auth_ntlmssp_chk(const char *desc, RPC_AUTH_NTLMSSP_CHK *chk, prs_struct *ps, int depth);
void init_rpc_auth_netsec_neg(RPC_AUTH_NETSEC_NEG *neg,
			      const char *domain, const char *myname);
BOOL smb_io_rpc_auth_netsec_neg(const char *desc, RPC_AUTH_NETSEC_NEG *neg,
				prs_struct *ps, int depth);
BOOL smb_io_rpc_auth_netsec_chk(const char *desc, int auth_len, 
                                RPC_AUTH_NETSEC_CHK * chk,
				prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_samr.c  */

void init_samr_q_close_hnd(SAMR_Q_CLOSE_HND * q_c, POLICY_HND *hnd);
BOOL samr_io_q_close_hnd(const char *desc, SAMR_Q_CLOSE_HND * q_u,
			 prs_struct *ps, int depth);
BOOL samr_io_r_close_hnd(const char *desc, SAMR_R_CLOSE_HND * r_u,
			 prs_struct *ps, int depth);
void init_samr_q_lookup_domain(SAMR_Q_LOOKUP_DOMAIN * q_u,
			       POLICY_HND *pol, char *dom_name);
BOOL samr_io_q_lookup_domain(const char *desc, SAMR_Q_LOOKUP_DOMAIN * q_u,
			     prs_struct *ps, int depth);
void init_samr_r_lookup_domain(SAMR_R_LOOKUP_DOMAIN * r_u,
			       DOM_SID *dom_sid, NTSTATUS status);
BOOL samr_io_r_lookup_domain(const char *desc, SAMR_R_LOOKUP_DOMAIN * r_u,
			     prs_struct *ps, int depth);
void init_samr_q_remove_sid_foreign_domain(SAMR_Q_REMOVE_SID_FOREIGN_DOMAIN * q_u, POLICY_HND *dom_pol, DOM_SID *sid);
BOOL samr_io_q_remove_sid_foreign_domain(const char *desc, SAMR_Q_REMOVE_SID_FOREIGN_DOMAIN * q_u,
			  prs_struct *ps, int depth);
BOOL samr_io_r_remove_sid_foreign_domain(const char *desc, SAMR_R_REMOVE_SID_FOREIGN_DOMAIN * r_u,
			  prs_struct *ps, int depth);
void init_samr_q_open_domain(SAMR_Q_OPEN_DOMAIN * q_u,
			     POLICY_HND *pol, uint32 flags,
			     const DOM_SID *sid);
BOOL samr_io_q_open_domain(const char *desc, SAMR_Q_OPEN_DOMAIN * q_u,
			   prs_struct *ps, int depth);
BOOL samr_io_r_open_domain(const char *desc, SAMR_R_OPEN_DOMAIN * r_u,
			   prs_struct *ps, int depth);
void init_samr_q_get_usrdom_pwinfo(SAMR_Q_GET_USRDOM_PWINFO * q_u,
				   POLICY_HND *user_pol);
BOOL samr_io_q_get_usrdom_pwinfo(const char *desc, SAMR_Q_GET_USRDOM_PWINFO * q_u,
				 prs_struct *ps, int depth);
void init_samr_r_get_usrdom_pwinfo(SAMR_R_GET_USRDOM_PWINFO *r_u, NTSTATUS status);
BOOL samr_io_r_get_usrdom_pwinfo(const char *desc, SAMR_R_GET_USRDOM_PWINFO * r_u,
				 prs_struct *ps, int depth);
BOOL samr_io_q_set_sec_obj(const char *desc, SAMR_Q_SET_SEC_OBJ * q_u,
			     prs_struct *ps, int depth);
void init_samr_q_query_sec_obj(SAMR_Q_QUERY_SEC_OBJ * q_u,
			       POLICY_HND *user_pol, uint32 sec_info);
BOOL samr_io_q_query_sec_obj(const char *desc, SAMR_Q_QUERY_SEC_OBJ * q_u,
			     prs_struct *ps, int depth);
void init_samr_q_query_dom_info(SAMR_Q_QUERY_DOMAIN_INFO * q_u,
				POLICY_HND *domain_pol, uint16 switch_value);
BOOL samr_io_q_query_dom_info(const char *desc, SAMR_Q_QUERY_DOMAIN_INFO * q_u,
			      prs_struct *ps, int depth);
void init_unk_info3(SAM_UNK_INFO_3 *u_3, NTTIME nt_logout);
void init_unk_info6(SAM_UNK_INFO_6 * u_6);
void init_unk_info7(SAM_UNK_INFO_7 * u_7, uint32 server_role);
void init_unk_info8(SAM_UNK_INFO_8 * u_8, uint32 seq_num);
void init_unk_info12(SAM_UNK_INFO_12 * u_12, NTTIME nt_lock_duration, NTTIME nt_reset_time, uint16 lockout);
void init_unk_info5(SAM_UNK_INFO_5 * u_5,const char *server);
void init_unk_info2(SAM_UNK_INFO_2 * u_2,
			const char *comment, const char *domain, const char *server,
			uint32 seq_num, uint32 num_users, uint32 num_groups, uint32 num_alias, NTTIME nt_logout, uint32 server_role);
void init_unk_info1(SAM_UNK_INFO_1 *u_1, uint16 min_pass_len, uint16 pass_hist, 
		    uint32 flag, NTTIME nt_expire, NTTIME nt_min_age);
void init_samr_r_query_dom_info(SAMR_R_QUERY_DOMAIN_INFO * r_u,
				uint16 switch_value, SAM_UNK_CTR * ctr,
				NTSTATUS status);
BOOL samr_io_r_query_dom_info(const char *desc, SAMR_R_QUERY_DOMAIN_INFO * r_u,
			      prs_struct *ps, int depth);
BOOL samr_io_r_set_sec_obj(const char *desc, SAMR_R_SET_SEC_OBJ * r_u,
			     prs_struct *ps, int depth);
BOOL samr_io_r_query_sec_obj(const char *desc, SAMR_R_QUERY_SEC_OBJ * r_u,
			     prs_struct *ps, int depth);
void init_sam_entry(SAM_ENTRY *sam, UNISTR2 *uni2, uint32 rid);
void init_samr_q_enum_dom_users(SAMR_Q_ENUM_DOM_USERS * q_e, POLICY_HND *pol,
				uint32 start_idx,
				uint16 acb_mask, uint16 unk_1, uint32 size);
BOOL samr_io_q_enum_dom_users(const char *desc, SAMR_Q_ENUM_DOM_USERS * q_e,
			      prs_struct *ps, int depth);
void init_samr_r_enum_dom_users(SAMR_R_ENUM_DOM_USERS * r_u,
				uint32 next_idx, uint32 num_sam_entries);
BOOL samr_io_r_enum_dom_users(const char *desc, SAMR_R_ENUM_DOM_USERS * r_u,
			      prs_struct *ps, int depth);
void init_samr_q_query_dispinfo(SAMR_Q_QUERY_DISPINFO * q_e, POLICY_HND *pol,
				uint16 switch_level, uint32 start_idx,
				uint32 max_entries, uint32 max_size);
BOOL samr_io_q_query_dispinfo(const char *desc, SAMR_Q_QUERY_DISPINFO * q_e,
			      prs_struct *ps, int depth);
NTSTATUS init_sam_dispinfo_1(TALLOC_CTX *ctx, SAM_DISPINFO_1 **sam,
			     uint32 num_entries, uint32 start_idx,
			     struct samr_displayentry *entries);
NTSTATUS init_sam_dispinfo_2(TALLOC_CTX *ctx, SAM_DISPINFO_2 **sam,
			     uint32 num_entries, uint32 start_idx,
			     struct samr_displayentry *entries);
NTSTATUS init_sam_dispinfo_3(TALLOC_CTX *ctx, SAM_DISPINFO_3 **sam,
			     uint32 num_entries, uint32 start_idx,
			     struct samr_displayentry *entries);
NTSTATUS init_sam_dispinfo_4(TALLOC_CTX *ctx, SAM_DISPINFO_4 **sam,
			     uint32 num_entries, uint32 start_idx,
			     struct samr_displayentry *entries);
NTSTATUS init_sam_dispinfo_5(TALLOC_CTX *ctx, SAM_DISPINFO_5 **sam,
			     uint32 num_entries, uint32 start_idx,
			     struct samr_displayentry *entries);
void init_samr_r_query_dispinfo(SAMR_R_QUERY_DISPINFO * r_u,
				uint32 num_entries, uint32 total_size, uint32 data_size,
				uint16 switch_level, SAM_DISPINFO_CTR * ctr,
				NTSTATUS status);
BOOL samr_io_r_query_dispinfo(const char *desc, SAMR_R_QUERY_DISPINFO * r_u,
			      prs_struct *ps, int depth);
void init_samr_q_open_group(SAMR_Q_OPEN_GROUP * q_c,
			    POLICY_HND *hnd,
			    uint32 access_mask, uint32 rid);
BOOL samr_io_q_open_group(const char *desc, SAMR_Q_OPEN_GROUP * q_u,
			  prs_struct *ps, int depth);
BOOL samr_io_r_open_group(const char *desc, SAMR_R_OPEN_GROUP * r_u,
			  prs_struct *ps, int depth);
void init_samr_group_info1(GROUP_INFO1 * gr1,
			   char *acct_name, char *acct_desc,
			   uint32 num_members);
BOOL samr_io_group_info1(const char *desc, GROUP_INFO1 * gr1,
			 prs_struct *ps, int depth);
void init_samr_group_info2(GROUP_INFO2 * gr2, const char *acct_name);
BOOL samr_io_group_info2(const char *desc, GROUP_INFO2 *gr2, prs_struct *ps, int depth);
void init_samr_group_info3(GROUP_INFO3 *gr3);
BOOL samr_io_group_info3(const char *desc, GROUP_INFO3 *gr3, prs_struct *ps, int depth);
void init_samr_group_info4(GROUP_INFO4 * gr4, const char *acct_desc);
BOOL samr_io_group_info4(const char *desc, GROUP_INFO4 * gr4,
			 prs_struct *ps, int depth);
void init_samr_q_create_dom_group(SAMR_Q_CREATE_DOM_GROUP * q_e,
				  POLICY_HND *pol, const char *acct_desc,
				  uint32 access_mask);
BOOL samr_io_q_create_dom_group(const char *desc, SAMR_Q_CREATE_DOM_GROUP * q_e,
				prs_struct *ps, int depth);
BOOL samr_io_r_create_dom_group(const char *desc, SAMR_R_CREATE_DOM_GROUP * r_u,
				prs_struct *ps, int depth);
void init_samr_q_delete_dom_group(SAMR_Q_DELETE_DOM_GROUP * q_c,
				  POLICY_HND *hnd);
BOOL samr_io_q_delete_dom_group(const char *desc, SAMR_Q_DELETE_DOM_GROUP * q_u,
				prs_struct *ps, int depth);
BOOL samr_io_r_delete_dom_group(const char *desc, SAMR_R_DELETE_DOM_GROUP * r_u,
				prs_struct *ps, int depth);
void init_samr_q_del_groupmem(SAMR_Q_DEL_GROUPMEM * q_e,
			      POLICY_HND *pol, uint32 rid);
BOOL samr_io_q_del_groupmem(const char *desc, SAMR_Q_DEL_GROUPMEM * q_e,
			    prs_struct *ps, int depth);
void init_samr_r_del_groupmem(SAMR_R_DEL_GROUPMEM * r_u, POLICY_HND *pol,
			      NTSTATUS status);
BOOL samr_io_r_del_groupmem(const char *desc, SAMR_R_DEL_GROUPMEM * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_add_groupmem(SAMR_Q_ADD_GROUPMEM * q_e,
			      POLICY_HND *pol, uint32 rid);
BOOL samr_io_q_add_groupmem(const char *desc, SAMR_Q_ADD_GROUPMEM * q_e,
			    prs_struct *ps, int depth);
void init_samr_r_add_groupmem(SAMR_R_ADD_GROUPMEM * r_u, POLICY_HND *pol,
			      NTSTATUS status);
BOOL samr_io_r_add_groupmem(const char *desc, SAMR_R_ADD_GROUPMEM * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_set_groupinfo(SAMR_Q_SET_GROUPINFO * q_e,
			       POLICY_HND *pol, GROUP_INFO_CTR * ctr);
BOOL samr_io_q_set_groupinfo(const char *desc, SAMR_Q_SET_GROUPINFO * q_e,
			     prs_struct *ps, int depth);
void init_samr_r_set_groupinfo(SAMR_R_SET_GROUPINFO * r_u, NTSTATUS status);
BOOL samr_io_r_set_groupinfo(const char *desc, SAMR_R_SET_GROUPINFO * r_u,
			     prs_struct *ps, int depth);
void init_samr_q_query_groupinfo(SAMR_Q_QUERY_GROUPINFO * q_e,
				 POLICY_HND *pol, uint16 switch_level);
BOOL samr_io_q_query_groupinfo(const char *desc, SAMR_Q_QUERY_GROUPINFO * q_e,
			       prs_struct *ps, int depth);
void init_samr_r_query_groupinfo(SAMR_R_QUERY_GROUPINFO * r_u,
				 GROUP_INFO_CTR * ctr, NTSTATUS status);
BOOL samr_io_r_query_groupinfo(const char *desc, SAMR_R_QUERY_GROUPINFO * r_u,
			       prs_struct *ps, int depth);
void init_samr_q_query_groupmem(SAMR_Q_QUERY_GROUPMEM * q_c, POLICY_HND *hnd);
BOOL samr_io_q_query_groupmem(const char *desc, SAMR_Q_QUERY_GROUPMEM * q_u,
			      prs_struct *ps, int depth);
void init_samr_r_query_groupmem(SAMR_R_QUERY_GROUPMEM * r_u,
				uint32 num_entries, uint32 *rid,
				uint32 *attr, NTSTATUS status);
BOOL samr_io_r_query_groupmem(const char *desc, SAMR_R_QUERY_GROUPMEM * r_u,
			      prs_struct *ps, int depth);
void init_samr_q_query_usergroups(SAMR_Q_QUERY_USERGROUPS * q_u,
				  POLICY_HND *hnd);
BOOL samr_io_q_query_usergroups(const char *desc, SAMR_Q_QUERY_USERGROUPS * q_u,
				prs_struct *ps, int depth);
void init_samr_r_query_usergroups(SAMR_R_QUERY_USERGROUPS * r_u,
				  uint32 num_gids, DOM_GID * gid,
				  NTSTATUS status);
BOOL samr_io_gids(const char *desc, uint32 *num_gids, DOM_GID ** gid,
		  prs_struct *ps, int depth);
BOOL samr_io_r_query_usergroups(const char *desc, SAMR_R_QUERY_USERGROUPS * r_u,
				prs_struct *ps, int depth);
void init_samr_q_enum_domains(SAMR_Q_ENUM_DOMAINS * q_e,
			      POLICY_HND *pol,
			      uint32 start_idx, uint32 size);
BOOL samr_io_q_enum_domains(const char *desc, SAMR_Q_ENUM_DOMAINS * q_e,
			    prs_struct *ps, int depth);
void init_samr_r_enum_domains(SAMR_R_ENUM_DOMAINS * r_u,
			      uint32 next_idx, uint32 num_sam_entries);
BOOL samr_io_r_enum_domains(const char *desc, SAMR_R_ENUM_DOMAINS * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_enum_dom_groups(SAMR_Q_ENUM_DOM_GROUPS * q_e,
				 POLICY_HND *pol,
				 uint32 start_idx, uint32 size);
BOOL samr_io_q_enum_dom_groups(const char *desc, SAMR_Q_ENUM_DOM_GROUPS * q_e,
			       prs_struct *ps, int depth);
void init_samr_r_enum_dom_groups(SAMR_R_ENUM_DOM_GROUPS * r_u,
				 uint32 next_idx, uint32 num_sam_entries);
BOOL samr_io_r_enum_dom_groups(const char *desc, SAMR_R_ENUM_DOM_GROUPS * r_u,
			       prs_struct *ps, int depth);
void init_samr_q_enum_dom_aliases(SAMR_Q_ENUM_DOM_ALIASES * q_e,
				  POLICY_HND *pol, uint32 start_idx,
				  uint32 size);
BOOL samr_io_q_enum_dom_aliases(const char *desc, SAMR_Q_ENUM_DOM_ALIASES * q_e,
				prs_struct *ps, int depth);
void init_samr_r_enum_dom_aliases(SAMR_R_ENUM_DOM_ALIASES *r_u, uint32 next_idx, uint32 num_sam_entries);
BOOL samr_io_r_enum_dom_aliases(const char *desc, SAMR_R_ENUM_DOM_ALIASES * r_u,
				prs_struct *ps, int depth);
void init_samr_alias_info1(ALIAS_INFO1 * al1, char *acct_name, uint32 num_member, char *acct_desc);
BOOL samr_io_alias_info1(const char *desc, ALIAS_INFO1 * al1,
			 prs_struct *ps, int depth);
void init_samr_alias_info3(ALIAS_INFO3 * al3, const char *acct_desc);
BOOL samr_io_alias_info3(const char *desc, ALIAS_INFO3 *al3,
			 prs_struct *ps, int depth);
BOOL samr_alias_info_ctr(const char *desc, prs_struct *ps, int depth, ALIAS_INFO_CTR * ctr);
void init_samr_q_query_aliasinfo(SAMR_Q_QUERY_ALIASINFO * q_e,
				 POLICY_HND *pol, uint32 switch_level);
BOOL samr_io_q_query_aliasinfo(const char *desc, SAMR_Q_QUERY_ALIASINFO *in,
			       prs_struct *ps, int depth);
void init_samr_r_query_aliasinfo(SAMR_R_QUERY_ALIASINFO *out,
				 ALIAS_INFO_CTR * ctr, NTSTATUS status);
BOOL samr_io_r_query_aliasinfo(const char *desc, SAMR_R_QUERY_ALIASINFO *out,
			       prs_struct *ps, int depth);
void init_samr_q_set_aliasinfo(SAMR_Q_SET_ALIASINFO * q_u,
			       POLICY_HND *hnd, ALIAS_INFO_CTR * ctr);
BOOL samr_io_q_set_aliasinfo(const char *desc, SAMR_Q_SET_ALIASINFO * q_u,
			     prs_struct *ps, int depth);
BOOL samr_io_r_set_aliasinfo(const char *desc, SAMR_R_SET_ALIASINFO * r_u,
			     prs_struct *ps, int depth);
void init_samr_q_query_useraliases(SAMR_Q_QUERY_USERALIASES * q_u,
				   POLICY_HND *hnd,
				   uint32 num_sids,
				   uint32 *ptr_sid, DOM_SID2 * sid);
BOOL samr_io_q_query_useraliases(const char *desc, SAMR_Q_QUERY_USERALIASES * q_u,
				 prs_struct *ps, int depth);
void init_samr_r_query_useraliases(SAMR_R_QUERY_USERALIASES * r_u,
				   uint32 num_rids, uint32 *rid,
				   NTSTATUS status);
BOOL samr_io_rids(const char *desc, uint32 *num_rids, uint32 **rid,
		  prs_struct *ps, int depth);
BOOL samr_io_r_query_useraliases(const char *desc, SAMR_R_QUERY_USERALIASES * r_u,
				 prs_struct *ps, int depth);
void init_samr_q_open_alias(SAMR_Q_OPEN_ALIAS * q_u, POLICY_HND *pol,
			    uint32 access_mask, uint32 rid);
BOOL samr_io_q_open_alias(const char *desc, SAMR_Q_OPEN_ALIAS * q_u,
			  prs_struct *ps, int depth);
BOOL samr_io_r_open_alias(const char *desc, SAMR_R_OPEN_ALIAS * r_u,
			  prs_struct *ps, int depth);
void init_samr_q_lookup_rids(TALLOC_CTX *ctx, SAMR_Q_LOOKUP_RIDS * q_u,
			     POLICY_HND *pol, uint32 flags,
			     uint32 num_rids, uint32 *rid);
BOOL samr_io_q_lookup_rids(const char *desc, SAMR_Q_LOOKUP_RIDS * q_u,
			   prs_struct *ps, int depth);
void init_samr_r_lookup_rids(SAMR_R_LOOKUP_RIDS * r_u,
			     uint32 num_names, UNIHDR * hdr_name,
			     UNISTR2 *uni_name, uint32 *type);
BOOL samr_io_r_lookup_rids(const char *desc, SAMR_R_LOOKUP_RIDS * r_u,
			   prs_struct *ps, int depth);
void init_samr_q_delete_alias(SAMR_Q_DELETE_DOM_ALIAS * q_u, POLICY_HND *hnd);
BOOL samr_io_q_delete_alias(const char *desc, SAMR_Q_DELETE_DOM_ALIAS * q_u,
			    prs_struct *ps, int depth);
BOOL samr_io_r_delete_alias(const char *desc, SAMR_R_DELETE_DOM_ALIAS * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_create_dom_alias(SAMR_Q_CREATE_DOM_ALIAS * q_u,
				  POLICY_HND *hnd, const char *acct_desc);
BOOL samr_io_q_create_dom_alias(const char *desc, SAMR_Q_CREATE_DOM_ALIAS * q_u,
				prs_struct *ps, int depth);
BOOL samr_io_r_create_dom_alias(const char *desc, SAMR_R_CREATE_DOM_ALIAS * r_u,
				prs_struct *ps, int depth);
void init_samr_q_add_aliasmem(SAMR_Q_ADD_ALIASMEM * q_u, POLICY_HND *hnd,
			      DOM_SID *sid);
BOOL samr_io_q_add_aliasmem(const char *desc, SAMR_Q_ADD_ALIASMEM * q_u,
			    prs_struct *ps, int depth);
BOOL samr_io_r_add_aliasmem(const char *desc, SAMR_R_ADD_ALIASMEM * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_del_aliasmem(SAMR_Q_DEL_ALIASMEM * q_u, POLICY_HND *hnd,
			      DOM_SID *sid);
BOOL samr_io_q_del_aliasmem(const char *desc, SAMR_Q_DEL_ALIASMEM * q_u,
			    prs_struct *ps, int depth);
BOOL samr_io_r_del_aliasmem(const char *desc, SAMR_R_DEL_ALIASMEM * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_delete_dom_alias(SAMR_Q_DELETE_DOM_ALIAS * q_c,
				  POLICY_HND *hnd);
BOOL samr_io_q_delete_dom_alias(const char *desc, SAMR_Q_DELETE_DOM_ALIAS * q_u,
				prs_struct *ps, int depth);
void init_samr_r_delete_dom_alias(SAMR_R_DELETE_DOM_ALIAS * r_u,
				  NTSTATUS status);
BOOL samr_io_r_delete_dom_alias(const char *desc, SAMR_R_DELETE_DOM_ALIAS * r_u,
				prs_struct *ps, int depth);
void init_samr_q_query_aliasmem(SAMR_Q_QUERY_ALIASMEM * q_c,
				POLICY_HND *hnd);
BOOL samr_io_q_query_aliasmem(const char *desc, SAMR_Q_QUERY_ALIASMEM * q_u,
			      prs_struct *ps, int depth);
void init_samr_r_query_aliasmem(SAMR_R_QUERY_ALIASMEM * r_u,
				uint32 num_sids, DOM_SID2 * sid,
				NTSTATUS status);
BOOL samr_io_r_query_aliasmem(const char *desc, SAMR_R_QUERY_ALIASMEM * r_u,
			      prs_struct *ps, int depth);
NTSTATUS init_samr_q_lookup_names(TALLOC_CTX *ctx, SAMR_Q_LOOKUP_NAMES * q_u,
			      POLICY_HND *pol, uint32 flags,
			      uint32 num_names, const char **name);
BOOL samr_io_q_lookup_names(const char *desc, SAMR_Q_LOOKUP_NAMES * q_u,
			    prs_struct *ps, int depth);
NTSTATUS init_samr_r_lookup_names(TALLOC_CTX *ctx, SAMR_R_LOOKUP_NAMES * r_u,
			      uint32 num_rids,
			      uint32 *rid, uint32 *type,
			      NTSTATUS status);
BOOL samr_io_r_lookup_names(const char *desc, SAMR_R_LOOKUP_NAMES * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_delete_dom_user(SAMR_Q_DELETE_DOM_USER * q_c,
				 POLICY_HND *hnd);
BOOL samr_io_q_delete_dom_user(const char *desc, SAMR_Q_DELETE_DOM_USER * q_u,
			       prs_struct *ps, int depth);
BOOL samr_io_r_delete_dom_user(const char *desc, SAMR_R_DELETE_DOM_USER * r_u,
			       prs_struct *ps, int depth);
void init_samr_q_open_user(SAMR_Q_OPEN_USER * q_u,
			   POLICY_HND *pol,
			   uint32 access_mask, uint32 rid);
BOOL samr_io_q_open_user(const char *desc, SAMR_Q_OPEN_USER * q_u,
			 prs_struct *ps, int depth);
BOOL samr_io_r_open_user(const char *desc, SAMR_R_OPEN_USER * r_u,
			 prs_struct *ps, int depth);
void init_samr_q_create_user(SAMR_Q_CREATE_USER * q_u,
			     POLICY_HND *pol,
			     const char *name,
			     uint32 acb_info, uint32 access_mask);
BOOL samr_io_q_create_user(const char *desc, SAMR_Q_CREATE_USER * q_u,
			   prs_struct *ps, int depth);
BOOL samr_io_r_create_user(const char *desc, SAMR_R_CREATE_USER * r_u,
			   prs_struct *ps, int depth);
void init_samr_q_query_userinfo(SAMR_Q_QUERY_USERINFO * q_u,
				POLICY_HND *hnd, uint16 switch_value);
BOOL samr_io_q_query_userinfo(const char *desc, SAMR_Q_QUERY_USERINFO * q_u,
			      prs_struct *ps, int depth);
void init_sam_user_info18(SAM_USER_INFO_18 * usr,
			  const uint8 lm_pwd[16], const uint8 nt_pwd[16]);
void init_sam_user_info7(SAM_USER_INFO_7 * usr, const char *name);
void init_sam_user_info16(SAM_USER_INFO_16 * usr, uint32 acb_info);
void init_sam_user_info17(SAM_USER_INFO_17 * usr,
			  NTTIME * expiry,
			  char *mach_acct,
			  uint32 rid_user, uint32 rid_group, uint16 acct_ctrl);
void init_sam_user_info24(SAM_USER_INFO_24 * usr, char newpass[516], uint16 pw_len);
void init_sam_user_info23W(SAM_USER_INFO_23 * usr, NTTIME * logon_time,	/* all zeros */
			NTTIME * logoff_time,	/* all zeros */
			NTTIME * kickoff_time,	/* all zeros */
			NTTIME * pass_last_set_time,	/* all zeros */
			NTTIME * pass_can_change_time,	/* all zeros */
			NTTIME * pass_must_change_time,	/* all zeros */
			UNISTR2 *user_name,
			UNISTR2 *full_name,
			UNISTR2 *home_dir,
			UNISTR2 *dir_drive,
			UNISTR2 *log_scr,
			UNISTR2 *prof_path,
			UNISTR2 *desc,
			UNISTR2 *wkstas,
			UNISTR2 *unk_str,
			UNISTR2 *mung_dial,
			uint32 user_rid,	/* 0x0000 0000 */
			uint32 group_rid,
			uint32 acb_info,
			uint32 fields_present,
			uint16 logon_divs,
			LOGON_HRS * hrs,
			uint16 bad_password_count,
			uint16 logon_count,
			char newpass[516]);
void init_sam_user_info23A(SAM_USER_INFO_23 * usr, NTTIME * logon_time,	/* all zeros */
			   NTTIME * logoff_time,	/* all zeros */
			   NTTIME * kickoff_time,	/* all zeros */
			   NTTIME * pass_last_set_time,	/* all zeros */
			   NTTIME * pass_can_change_time,	/* all zeros */
			   NTTIME * pass_must_change_time,	/* all zeros */
			   char *user_name,	/* NULL */
			   char *full_name,
			   char *home_dir, char *dir_drive, char *log_scr,
			   char *prof_path, const char *desc, char *wkstas,
			   char *unk_str, char *mung_dial, uint32 user_rid,	/* 0x0000 0000 */
			   uint32 group_rid, uint32 acb_info,
			   uint32 fields_present, uint16 logon_divs,
			   LOGON_HRS * hrs, uint16 bad_password_count, uint16 logon_count,
			   char newpass[516]);
void init_sam_user_info21W(SAM_USER_INFO_21 * usr,
			   NTTIME * logon_time,
			   NTTIME * logoff_time,
			   NTTIME * kickoff_time,
			   NTTIME * pass_last_set_time,
			   NTTIME * pass_can_change_time,
			   NTTIME * pass_must_change_time,
			   UNISTR2 *user_name,
			   UNISTR2 *full_name,
			   UNISTR2 *home_dir,
			   UNISTR2 *dir_drive,
			   UNISTR2 *log_scr,
			   UNISTR2 *prof_path,
			   UNISTR2 *desc,
			   UNISTR2 *wkstas,
			   UNISTR2 *unk_str,
			   UNISTR2 *mung_dial,
			   uchar lm_pwd[16],
			   uchar nt_pwd[16],
			   uint32 user_rid,
			   uint32 group_rid,
			   uint32 acb_info,
			   uint32 fields_present,
			   uint16 logon_divs,
			   LOGON_HRS * hrs,
			   uint16 bad_password_count,
			   uint16 logon_count);
NTSTATUS init_sam_user_info21A(SAM_USER_INFO_21 *usr, SAM_ACCOUNT *pw, DOM_SID *domain_sid);
void init_sam_user_info20A(SAM_USER_INFO_20 *usr, SAM_ACCOUNT *pw);
NTSTATUS make_samr_userinfo_ctr_usr21(TALLOC_CTX *ctx, SAM_USERINFO_CTR * ctr,
				    uint16 switch_value,
				    SAM_USER_INFO_21 * usr);
void init_samr_r_query_userinfo(SAMR_R_QUERY_USERINFO * r_u,
				SAM_USERINFO_CTR * ctr, NTSTATUS status);
BOOL samr_io_r_query_userinfo(const char *desc, SAMR_R_QUERY_USERINFO * r_u,
			      prs_struct *ps, int depth);
void init_samr_q_set_userinfo(SAMR_Q_SET_USERINFO * q_u,
			      POLICY_HND *hnd, DATA_BLOB *sess_key,
			      uint16 switch_value, void *info);
BOOL samr_io_q_set_userinfo(const char *desc, SAMR_Q_SET_USERINFO * q_u,
			    prs_struct *ps, int depth);
void init_samr_r_set_userinfo(SAMR_R_SET_USERINFO * r_u, NTSTATUS status);
BOOL samr_io_r_set_userinfo(const char *desc, SAMR_R_SET_USERINFO * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_set_userinfo2(SAMR_Q_SET_USERINFO2 * q_u,
			       POLICY_HND *hnd, DATA_BLOB *sess_key,
			       uint16 switch_value, SAM_USERINFO_CTR * ctr);
BOOL samr_io_q_set_userinfo2(const char *desc, SAMR_Q_SET_USERINFO2 * q_u,
			     prs_struct *ps, int depth);
void init_samr_r_set_userinfo2(SAMR_R_SET_USERINFO2 * r_u, NTSTATUS status);
BOOL samr_io_r_set_userinfo2(const char *desc, SAMR_R_SET_USERINFO2 * r_u,
			     prs_struct *ps, int depth);
void init_samr_q_connect(SAMR_Q_CONNECT * q_u,
			 char *srv_name, uint32 access_mask);
BOOL samr_io_q_connect(const char *desc, SAMR_Q_CONNECT * q_u,
		       prs_struct *ps, int depth);
BOOL samr_io_r_connect(const char *desc, SAMR_R_CONNECT * r_u,
		       prs_struct *ps, int depth);
void init_samr_q_connect4(SAMR_Q_CONNECT4 * q_u,
			  char *srv_name, uint32 access_mask);
BOOL samr_io_q_connect4(const char *desc, SAMR_Q_CONNECT4 * q_u,
			prs_struct *ps, int depth);
BOOL samr_io_r_connect4(const char *desc, SAMR_R_CONNECT4 * r_u,
			prs_struct *ps, int depth);
void init_samr_q_connect_anon(SAMR_Q_CONNECT_ANON * q_u);
BOOL samr_io_q_connect_anon(const char *desc, SAMR_Q_CONNECT_ANON * q_u,
			    prs_struct *ps, int depth);
BOOL samr_io_r_connect_anon(const char *desc, SAMR_R_CONNECT_ANON * r_u,
			    prs_struct *ps, int depth);
void init_samr_q_get_dom_pwinfo(SAMR_Q_GET_DOM_PWINFO * q_u,
				char *srv_name);
BOOL samr_io_q_get_dom_pwinfo(const char *desc, SAMR_Q_GET_DOM_PWINFO * q_u,
			      prs_struct *ps, int depth);
BOOL samr_io_r_get_dom_pwinfo(const char *desc, SAMR_R_GET_DOM_PWINFO * r_u,
			      prs_struct *ps, int depth);
void init_enc_passwd(SAMR_ENC_PASSWD * pwd, const char pass[512]);
BOOL samr_io_enc_passwd(const char *desc, SAMR_ENC_PASSWD * pwd,
			prs_struct *ps, int depth);
void init_enc_hash(SAMR_ENC_HASH * hsh, const uchar hash[16]);
BOOL samr_io_enc_hash(const char *desc, SAMR_ENC_HASH * hsh,
		      prs_struct *ps, int depth);
void init_samr_q_chgpasswd_user(SAMR_Q_CHGPASSWD_USER * q_u,
				const char *dest_host, const char *user_name,
				const char nt_newpass[516],
				const uchar nt_oldhash[16],
				const char lm_newpass[516],
				const uchar lm_oldhash[16]);
BOOL samr_io_q_chgpasswd_user(const char *desc, SAMR_Q_CHGPASSWD_USER * q_u,
			      prs_struct *ps, int depth);
void init_samr_r_chgpasswd_user(SAMR_R_CHGPASSWD_USER * r_u, NTSTATUS status);
BOOL samr_io_r_chgpasswd_user(const char *desc, SAMR_R_CHGPASSWD_USER * r_u,
			      prs_struct *ps, int depth);
void init_samr_q_unknown_2e(SAMR_Q_UNKNOWN_2E *q_u,
				POLICY_HND *domain_pol, uint16 switch_value);
BOOL samr_io_q_unknown_2e(const char *desc, SAMR_Q_UNKNOWN_2E *q_u,
			      prs_struct *ps, int depth);
void init_samr_r_samr_unknown_2e(SAMR_R_UNKNOWN_2E * r_u,
				uint16 switch_value, SAM_UNK_CTR * ctr,
				NTSTATUS status);
BOOL samr_io_r_samr_unknown_2e(const char *desc, SAMR_R_UNKNOWN_2E * r_u,
			      prs_struct *ps, int depth);
void init_samr_q_set_domain_info(SAMR_Q_SET_DOMAIN_INFO *q_u,
				POLICY_HND *domain_pol, uint16 switch_value, SAM_UNK_CTR *ctr);
BOOL samr_io_q_set_domain_info(const char *desc, SAMR_Q_SET_DOMAIN_INFO *q_u,
			      prs_struct *ps, int depth);
void init_samr_r_set_domain_info(SAMR_R_SET_DOMAIN_INFO * r_u, NTSTATUS status);
BOOL samr_io_r_set_domain_info(const char *desc, SAMR_R_SET_DOMAIN_INFO * r_u,
			      prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_sec.c  */

BOOL sec_io_access(const char *desc, SEC_ACCESS *t, prs_struct *ps, int depth);
BOOL sec_io_ace(const char *desc, SEC_ACE *psa, prs_struct *ps, int depth);
BOOL sec_io_acl(const char *desc, SEC_ACL **ppsa, prs_struct *ps, int depth);
BOOL sec_io_desc(const char *desc, SEC_DESC **ppsd, prs_struct *ps, int depth);
BOOL sec_io_desc_buf(const char *desc, SEC_DESC_BUF **ppsdb, prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_shutdown.c  */

void init_shutdown_q_init(SHUTDOWN_Q_INIT *q_s, const char *msg,
			uint32 timeout, BOOL do_reboot, BOOL force);
void init_shutdown_q_init_ex(SHUTDOWN_Q_INIT_EX * q_u_ex, const char *msg,
			uint32 timeout, BOOL do_reboot, BOOL force, uint32 reason);
BOOL shutdown_io_q_init(const char *desc, SHUTDOWN_Q_INIT *q_s, prs_struct *ps,
			int depth);
BOOL shutdown_io_r_init(const char *desc, SHUTDOWN_R_INIT* r_s, prs_struct *ps,
			int depth);
BOOL shutdown_io_q_init_ex(const char *desc, SHUTDOWN_Q_INIT_EX * q_s, prs_struct *ps,
		       int depth);
BOOL shutdown_io_r_init_ex(const char *desc, SHUTDOWN_R_INIT_EX * r_s, prs_struct *ps,
		       int depth);
void init_shutdown_q_abort(SHUTDOWN_Q_ABORT *q_s);
BOOL shutdown_io_q_abort(const char *desc, SHUTDOWN_Q_ABORT *q_s,
			 prs_struct *ps, int depth);
BOOL shutdown_io_r_abort(const char *desc, SHUTDOWN_R_ABORT *r_s,
			 prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_spoolss.c  */

BOOL spoolss_io_system_time(const char *desc, prs_struct *ps, int depth, SYSTEMTIME *systime);
BOOL make_systemtime(SYSTEMTIME *systime, struct tm *unixtime);
BOOL smb_io_notify_info_data_strings(const char *desc,SPOOL_NOTIFY_INFO_DATA *data,
                                     prs_struct *ps, int depth);
BOOL spool_io_user_level_1( const char *desc, prs_struct *ps, int depth, SPOOL_USER_1 *q_u );
BOOL spoolss_io_devmode(const char *desc, prs_struct *ps, int depth, DEVICEMODE *devmode);
BOOL make_spoolss_q_open_printer_ex(SPOOL_Q_OPEN_PRINTER_EX *q_u,
		const fstring printername, 
		const fstring datatype, 
		uint32 access_required,
		const fstring clientname,
		const fstring user_name);
BOOL make_spoolss_q_addprinterex( TALLOC_CTX *mem_ctx, SPOOL_Q_ADDPRINTEREX *q_u, 
	const char *srv_name, const char* clientname, const char* user_name,
	uint32 level, PRINTER_INFO_CTR *ctr);
BOOL make_spoolss_printer_info_2(TALLOC_CTX *mem_ctx, SPOOL_PRINTER_INFO_LEVEL_2 **spool_info2, 
				PRINTER_INFO_2 *info);
BOOL make_spoolss_printer_info_3(TALLOC_CTX *mem_ctx, SPOOL_PRINTER_INFO_LEVEL_3 **spool_info3, 
				PRINTER_INFO_3 *info);
BOOL make_spoolss_printer_info_7(TALLOC_CTX *mem_ctx, SPOOL_PRINTER_INFO_LEVEL_7 **spool_info7, 
				PRINTER_INFO_7 *info);
BOOL spoolss_io_q_open_printer(const char *desc, SPOOL_Q_OPEN_PRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_open_printer(const char *desc, SPOOL_R_OPEN_PRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_open_printer_ex(const char *desc, SPOOL_Q_OPEN_PRINTER_EX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_open_printer_ex(const char *desc, SPOOL_R_OPEN_PRINTER_EX *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_deleteprinterdriverex( TALLOC_CTX *mem_ctx,
                                           SPOOL_Q_DELETEPRINTERDRIVEREX *q_u, 
                                           const char *server,
                                           const char* arch, 
                                           const char* driver,
                                           int version);
BOOL make_spoolss_q_deleteprinterdriver(
	TALLOC_CTX *mem_ctx,
	SPOOL_Q_DELETEPRINTERDRIVER *q_u, 
	const char *server,
	const char* arch, 
	const char* driver 
);
BOOL make_spoolss_q_getprinterdata(SPOOL_Q_GETPRINTERDATA *q_u,
				   const POLICY_HND *handle,
				   const char *valuename, uint32 size);
BOOL make_spoolss_q_getprinterdataex(SPOOL_Q_GETPRINTERDATAEX *q_u,
				     const POLICY_HND *handle,
				     const char *keyname, 
				     const char *valuename, uint32 size);
BOOL spoolss_io_q_getprinterdata(const char *desc, SPOOL_Q_GETPRINTERDATA *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_deleteprinterdata(const char *desc, SPOOL_Q_DELETEPRINTERDATA *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_deleteprinterdata(const char *desc, SPOOL_R_DELETEPRINTERDATA *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_deleteprinterdataex(const char *desc, SPOOL_Q_DELETEPRINTERDATAEX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_deleteprinterdataex(const char *desc, SPOOL_R_DELETEPRINTERDATAEX *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getprinterdata(const char *desc, SPOOL_R_GETPRINTERDATA *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_closeprinter(SPOOL_Q_CLOSEPRINTER *q_u, POLICY_HND *hnd);
BOOL spoolss_io_q_abortprinter(const char *desc, SPOOL_Q_ABORTPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_abortprinter(const char *desc, SPOOL_R_ABORTPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_deleteprinter(const char *desc, SPOOL_Q_DELETEPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_deleteprinter(const char *desc, SPOOL_R_DELETEPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_deleteprinterdriver(const char *desc, SPOOL_Q_DELETEPRINTERDRIVER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_deleteprinterdriver(const char *desc, SPOOL_R_DELETEPRINTERDRIVER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_deleteprinterdriverex(const char *desc, SPOOL_Q_DELETEPRINTERDRIVEREX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_deleteprinterdriverex(const char *desc, SPOOL_R_DELETEPRINTERDRIVEREX *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_closeprinter(const char *desc, SPOOL_Q_CLOSEPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_closeprinter(const char *desc, SPOOL_R_CLOSEPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_startdocprinter(const char *desc, SPOOL_Q_STARTDOCPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_startdocprinter(const char *desc, SPOOL_R_STARTDOCPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enddocprinter(const char *desc, SPOOL_Q_ENDDOCPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enddocprinter(const char *desc, SPOOL_R_ENDDOCPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_startpageprinter(const char *desc, SPOOL_Q_STARTPAGEPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_startpageprinter(const char *desc, SPOOL_R_STARTPAGEPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_endpageprinter(const char *desc, SPOOL_Q_ENDPAGEPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_endpageprinter(const char *desc, SPOOL_R_ENDPAGEPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_writeprinter(const char *desc, SPOOL_Q_WRITEPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_writeprinter(const char *desc, SPOOL_R_WRITEPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_rffpcnex(const char *desc, SPOOL_Q_RFFPCNEX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_rffpcnex(const char *desc, SPOOL_R_RFFPCNEX *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_rfnpcnex(const char *desc, SPOOL_Q_RFNPCNEX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_rfnpcnex(const char *desc, SPOOL_R_RFNPCNEX *r_u, prs_struct *ps, int depth);
BOOL smb_io_printer_info_0(const char *desc, RPC_BUFFER *buffer, PRINTER_INFO_0 *info, int depth);
BOOL smb_io_printer_info_1(const char *desc, RPC_BUFFER *buffer, PRINTER_INFO_1 *info, int depth);
BOOL smb_io_printer_info_2(const char *desc, RPC_BUFFER *buffer, PRINTER_INFO_2 *info, int depth);
BOOL smb_io_printer_info_3(const char *desc, RPC_BUFFER *buffer, PRINTER_INFO_3 *info, int depth);
BOOL smb_io_printer_info_4(const char *desc, RPC_BUFFER *buffer, PRINTER_INFO_4 *info, int depth);
BOOL smb_io_printer_info_5(const char *desc, RPC_BUFFER *buffer, PRINTER_INFO_5 *info, int depth);
BOOL smb_io_printer_info_7(const char *desc, RPC_BUFFER *buffer, PRINTER_INFO_7 *info, int depth);
BOOL smb_io_port_info_1(const char *desc, RPC_BUFFER *buffer, PORT_INFO_1 *info, int depth);
BOOL smb_io_port_info_2(const char *desc, RPC_BUFFER *buffer, PORT_INFO_2 *info, int depth);
BOOL smb_io_printer_driver_info_1(const char *desc, RPC_BUFFER *buffer, DRIVER_INFO_1 *info, int depth) ;
BOOL smb_io_printer_driver_info_2(const char *desc, RPC_BUFFER *buffer, DRIVER_INFO_2 *info, int depth) ;
BOOL smb_io_printer_driver_info_3(const char *desc, RPC_BUFFER *buffer, DRIVER_INFO_3 *info, int depth);
BOOL smb_io_printer_driver_info_6(const char *desc, RPC_BUFFER *buffer, DRIVER_INFO_6 *info, int depth);
BOOL smb_io_job_info_1(const char *desc, RPC_BUFFER *buffer, JOB_INFO_1 *info, int depth);
BOOL smb_io_job_info_2(const char *desc, RPC_BUFFER *buffer, JOB_INFO_2 *info, int depth);
BOOL smb_io_form_1(const char *desc, RPC_BUFFER *buffer, FORM_1 *info, int depth);
BOOL smb_io_driverdir_1(const char *desc, RPC_BUFFER *buffer, DRIVER_DIRECTORY_1 *info, int depth);
BOOL smb_io_port_1(const char *desc, RPC_BUFFER *buffer, PORT_INFO_1 *info, int depth);
BOOL smb_io_port_2(const char *desc, RPC_BUFFER *buffer, PORT_INFO_2 *info, int depth);
BOOL smb_io_printprocessor_info_1(const char *desc, RPC_BUFFER *buffer, PRINTPROCESSOR_1 *info, int depth);
BOOL smb_io_printprocdatatype_info_1(const char *desc, RPC_BUFFER *buffer, PRINTPROCDATATYPE_1 *info, int depth);
BOOL smb_io_printmonitor_info_1(const char *desc, RPC_BUFFER *buffer, PRINTMONITOR_1 *info, int depth);
BOOL smb_io_printmonitor_info_2(const char *desc, RPC_BUFFER *buffer, PRINTMONITOR_2 *info, int depth);
uint32 spoolss_size_printer_info_0(PRINTER_INFO_0 *info);
uint32 spoolss_size_printer_info_1(PRINTER_INFO_1 *info);
uint32 spoolss_size_printer_info_2(PRINTER_INFO_2 *info);
uint32 spoolss_size_printer_info_4(PRINTER_INFO_4 *info);
uint32 spoolss_size_printer_info_5(PRINTER_INFO_5 *info);
uint32 spoolss_size_printer_info_3(PRINTER_INFO_3 *info);
uint32 spoolss_size_printer_info_7(PRINTER_INFO_7 *info);
uint32 spoolss_size_printer_driver_info_1(DRIVER_INFO_1 *info);
uint32 spoolss_size_printer_driver_info_2(DRIVER_INFO_2 *info);
uint32 spoolss_size_string_array(uint16 *string);
uint32 spoolss_size_printer_driver_info_3(DRIVER_INFO_3 *info);
uint32 spoolss_size_printer_driver_info_6(DRIVER_INFO_6 *info);
uint32 spoolss_size_job_info_1(JOB_INFO_1 *info);
uint32 spoolss_size_job_info_2(JOB_INFO_2 *info);
uint32 spoolss_size_form_1(FORM_1 *info);
uint32 spoolss_size_port_info_1(PORT_INFO_1 *info);
uint32 spoolss_size_driverdir_info_1(DRIVER_DIRECTORY_1 *info);
uint32 spoolss_size_printprocessordirectory_info_1(PRINTPROCESSOR_DIRECTORY_1 *info);
uint32 spoolss_size_port_info_2(PORT_INFO_2 *info);
uint32 spoolss_size_printprocessor_info_1(PRINTPROCESSOR_1 *info);
uint32 spoolss_size_printprocdatatype_info_1(PRINTPROCDATATYPE_1 *info);
uint32 spoolss_size_printer_enum_values(PRINTER_ENUM_VALUES *p);
uint32 spoolss_size_printmonitor_info_1(PRINTMONITOR_1 *info);
uint32 spoolss_size_printmonitor_info_2(PRINTMONITOR_2 *info);
BOOL make_spoolss_q_getprinterdriver2(SPOOL_Q_GETPRINTERDRIVER2 *q_u, 
			       const POLICY_HND *hnd,
			       const fstring architecture,
			       uint32 level, uint32 clientmajor, uint32 clientminor,
			       RPC_BUFFER *buffer, uint32 offered);
BOOL spoolss_io_q_getprinterdriver2(const char *desc, SPOOL_Q_GETPRINTERDRIVER2 *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getprinterdriver2(const char *desc, SPOOL_R_GETPRINTERDRIVER2 *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_enumprinters(
	SPOOL_Q_ENUMPRINTERS *q_u, 
	uint32 flags, 
	char *servername, 
	uint32 level, 
	RPC_BUFFER *buffer, 
	uint32 offered
);
BOOL make_spoolss_q_enumports(SPOOL_Q_ENUMPORTS *q_u, 
				fstring servername, uint32 level, 
				RPC_BUFFER *buffer, uint32 offered);
BOOL spoolss_io_q_enumprinters(const char *desc, SPOOL_Q_ENUMPRINTERS *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprinters(const char *desc, SPOOL_R_ENUMPRINTERS *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getprinter(const char *desc, SPOOL_R_GETPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_getprinter(const char *desc, SPOOL_Q_GETPRINTER *q_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_getprinter(
	TALLOC_CTX *mem_ctx,
	SPOOL_Q_GETPRINTER *q_u, 
	const POLICY_HND *hnd, 
	uint32 level, 
	RPC_BUFFER *buffer, 
	uint32 offered
);
BOOL make_spoolss_q_setprinter(TALLOC_CTX *mem_ctx, SPOOL_Q_SETPRINTER *q_u, 
				const POLICY_HND *hnd, uint32 level, PRINTER_INFO_CTR *info, 
				uint32 command);
BOOL spoolss_io_r_setprinter(const char *desc, SPOOL_R_SETPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_setprinter(const char *desc, SPOOL_Q_SETPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_fcpn(const char *desc, SPOOL_R_FCPN *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_fcpn(const char *desc, SPOOL_Q_FCPN *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_addjob(const char *desc, SPOOL_R_ADDJOB *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_addjob(const char *desc, SPOOL_Q_ADDJOB *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumjobs(const char *desc, SPOOL_R_ENUMJOBS *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_enumjobs(SPOOL_Q_ENUMJOBS *q_u, const POLICY_HND *hnd,
				uint32 firstjob,
				uint32 numofjobs,
				uint32 level,
				RPC_BUFFER *buffer,
				uint32 offered);
BOOL spoolss_io_q_enumjobs(const char *desc, SPOOL_Q_ENUMJOBS *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_schedulejob(const char *desc, SPOOL_R_SCHEDULEJOB *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_schedulejob(const char *desc, SPOOL_Q_SCHEDULEJOB *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_setjob(const char *desc, SPOOL_R_SETJOB *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_setjob(const char *desc, SPOOL_Q_SETJOB *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprinterdrivers(const char *desc, SPOOL_R_ENUMPRINTERDRIVERS *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_enumprinterdrivers(SPOOL_Q_ENUMPRINTERDRIVERS *q_u,
                                const char *name,
                                const char *environment,
                                uint32 level,
                                RPC_BUFFER *buffer, uint32 offered);
BOOL spoolss_io_q_enumprinterdrivers(const char *desc, SPOOL_Q_ENUMPRINTERDRIVERS *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enumforms(const char *desc, SPOOL_Q_ENUMFORMS *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumforms(const char *desc, SPOOL_R_ENUMFORMS *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_getform(const char *desc, SPOOL_Q_GETFORM *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getform(const char *desc, SPOOL_R_GETFORM *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumports(const char *desc, SPOOL_R_ENUMPORTS *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enumports(const char *desc, SPOOL_Q_ENUMPORTS *q_u, prs_struct *ps, int depth);
BOOL spool_io_printer_info_level_1(const char *desc, SPOOL_PRINTER_INFO_LEVEL_1 *il, prs_struct *ps, int depth);
BOOL spool_io_printer_info_level_3(const char *desc, SPOOL_PRINTER_INFO_LEVEL_3 *il, prs_struct *ps, int depth);
BOOL spool_io_printer_info_level_2(const char *desc, SPOOL_PRINTER_INFO_LEVEL_2 *il, prs_struct *ps, int depth);
BOOL spool_io_printer_info_level_7(const char *desc, SPOOL_PRINTER_INFO_LEVEL_7 *il, prs_struct *ps, int depth);
BOOL spool_io_printer_info_level(const char *desc, SPOOL_PRINTER_INFO_LEVEL *il, prs_struct *ps, int depth);
BOOL spoolss_io_q_addprinterex(const char *desc, SPOOL_Q_ADDPRINTEREX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_addprinterex(const char *desc, SPOOL_R_ADDPRINTEREX *r_u, 
			       prs_struct *ps, int depth);
BOOL spool_io_printer_driver_info_level_3(const char *desc, SPOOL_PRINTER_DRIVER_INFO_LEVEL_3 **q_u, 
                                          prs_struct *ps, int depth);
BOOL spool_io_printer_driver_info_level_6(const char *desc, SPOOL_PRINTER_DRIVER_INFO_LEVEL_6 **q_u, 
                                          prs_struct *ps, int depth);
BOOL smb_io_unibuffer(const char *desc, UNISTR2 *buffer, prs_struct *ps, int depth);
BOOL spool_io_printer_driver_info_level(const char *desc, SPOOL_PRINTER_DRIVER_INFO_LEVEL *il, prs_struct *ps, int depth);
BOOL make_spoolss_q_addprinterdriver(TALLOC_CTX *mem_ctx,
				SPOOL_Q_ADDPRINTERDRIVER *q_u, const char* srv_name, 
				uint32 level, PRINTER_DRIVER_CTR *info);
BOOL make_spoolss_driver_info_3(TALLOC_CTX *mem_ctx, 
	SPOOL_PRINTER_DRIVER_INFO_LEVEL_3 **spool_drv_info,
				DRIVER_INFO_3 *info3);
BOOL make_spoolss_buffer5(TALLOC_CTX *mem_ctx, BUFFER5 *buf5, uint32 len, uint16 *src);
BOOL spoolss_io_q_addprinterdriver(const char *desc, SPOOL_Q_ADDPRINTERDRIVER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_addprinterdriver(const char *desc, SPOOL_R_ADDPRINTERDRIVER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_addprinterdriverex(const char *desc, SPOOL_Q_ADDPRINTERDRIVEREX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_addprinterdriverex(const char *desc, SPOOL_R_ADDPRINTERDRIVEREX *q_u, prs_struct *ps, int depth);
BOOL uni_2_asc_printer_driver_3(SPOOL_PRINTER_DRIVER_INFO_LEVEL_3 *uni,
                                NT_PRINTER_DRIVER_INFO_LEVEL_3 **asc);
BOOL uni_2_asc_printer_driver_6(SPOOL_PRINTER_DRIVER_INFO_LEVEL_6 *uni,
                                NT_PRINTER_DRIVER_INFO_LEVEL_6 **asc);
BOOL uni_2_asc_printer_info_2(const SPOOL_PRINTER_INFO_LEVEL_2 *uni,
                              NT_PRINTER_INFO_LEVEL_2  **asc);
BOOL make_spoolss_q_getprinterdriverdir(SPOOL_Q_GETPRINTERDRIVERDIR *q_u,
                                fstring servername, fstring env_name, uint32 level,
                                RPC_BUFFER *buffer, uint32 offered);
BOOL spoolss_io_q_getprinterdriverdir(const char *desc, SPOOL_Q_GETPRINTERDRIVERDIR *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getprinterdriverdir(const char *desc, SPOOL_R_GETPRINTERDRIVERDIR *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprintprocessors(const char *desc, SPOOL_R_ENUMPRINTPROCESSORS *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enumprintprocessors(const char *desc, SPOOL_Q_ENUMPRINTPROCESSORS *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_addprintprocessor(const char *desc, SPOOL_Q_ADDPRINTPROCESSOR *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_addprintprocessor(const char *desc, SPOOL_R_ADDPRINTPROCESSOR *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprintprocdatatypes(const char *desc, SPOOL_R_ENUMPRINTPROCDATATYPES *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enumprintprocdatatypes(const char *desc, SPOOL_Q_ENUMPRINTPROCDATATYPES *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enumprintmonitors(const char *desc, SPOOL_Q_ENUMPRINTMONITORS *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprintmonitors(const char *desc, SPOOL_R_ENUMPRINTMONITORS *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprinterdata(const char *desc, SPOOL_R_ENUMPRINTERDATA *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enumprinterdata(const char *desc, SPOOL_Q_ENUMPRINTERDATA *q_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_enumprinterdata(SPOOL_Q_ENUMPRINTERDATA *q_u,
		const POLICY_HND *hnd,
		uint32 idx, uint32 valuelen, uint32 datalen);
BOOL make_spoolss_q_enumprinterdataex(SPOOL_Q_ENUMPRINTERDATAEX *q_u,
				      const POLICY_HND *hnd, const char *key,
				      uint32 size);
BOOL make_spoolss_q_setprinterdata(SPOOL_Q_SETPRINTERDATA *q_u, const POLICY_HND *hnd,
				   char* value, uint32 data_type, char* data, uint32 data_size);
BOOL make_spoolss_q_setprinterdataex(SPOOL_Q_SETPRINTERDATAEX *q_u, const POLICY_HND *hnd,
				     char *key, char* value, uint32 data_type, char* data, 
				     uint32 data_size);
BOOL spoolss_io_q_setprinterdata(const char *desc, SPOOL_Q_SETPRINTERDATA *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_setprinterdata(const char *desc, SPOOL_R_SETPRINTERDATA *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_resetprinter(const char *desc, SPOOL_Q_RESETPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_resetprinter(const char *desc, SPOOL_R_RESETPRINTER *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_deleteform(const char *desc, SPOOL_Q_DELETEFORM *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_deleteform(const char *desc, SPOOL_R_DELETEFORM *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_addform(const char *desc, SPOOL_Q_ADDFORM *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_addform(const char *desc, SPOOL_R_ADDFORM *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_setform(const char *desc, SPOOL_Q_SETFORM *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_setform(const char *desc, SPOOL_R_SETFORM *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getjob(const char *desc, SPOOL_R_GETJOB *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_getjob(const char *desc, SPOOL_Q_GETJOB *q_u, prs_struct *ps, int depth);
void free_devmode(DEVICEMODE *devmode);
void free_printer_info_1(PRINTER_INFO_1 *printer);
void free_printer_info_2(PRINTER_INFO_2 *printer);
void free_printer_info_3(PRINTER_INFO_3 *printer);
void free_printer_info_4(PRINTER_INFO_4 *printer);
void free_printer_info_5(PRINTER_INFO_5 *printer);
void free_printer_info_7(PRINTER_INFO_7 *printer);
void free_job_info_2(JOB_INFO_2 *job);
BOOL make_spoolss_q_replyopenprinter(SPOOL_Q_REPLYOPENPRINTER *q_u, 
			       const fstring string, uint32 printer, uint32 type);
BOOL spoolss_io_q_replyopenprinter(const char *desc, SPOOL_Q_REPLYOPENPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_replyopenprinter(const char *desc, SPOOL_R_REPLYOPENPRINTER *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_routerreplyprinter(SPOOL_Q_ROUTERREPLYPRINTER *q_u, POLICY_HND *hnd, 
					uint32 condition, uint32 change_id);
BOOL spoolss_io_q_routerreplyprinter (const char *desc, SPOOL_Q_ROUTERREPLYPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_routerreplyprinter (const char *desc, SPOOL_R_ROUTERREPLYPRINTER *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_reply_closeprinter(SPOOL_Q_REPLYCLOSEPRINTER *q_u, POLICY_HND *hnd);
BOOL spoolss_io_q_replycloseprinter(const char *desc, SPOOL_Q_REPLYCLOSEPRINTER *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_replycloseprinter(const char *desc, SPOOL_R_REPLYCLOSEPRINTER *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_reply_rrpcn(SPOOL_Q_REPLY_RRPCN *q_u, POLICY_HND *hnd,
			        uint32 change_low, uint32 change_high,
				SPOOL_NOTIFY_INFO *info);
BOOL spoolss_io_q_reply_rrpcn(const char *desc, SPOOL_Q_REPLY_RRPCN *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_reply_rrpcn(const char *desc, SPOOL_R_REPLY_RRPCN *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_getprinterdataex(const char *desc, SPOOL_Q_GETPRINTERDATAEX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getprinterdataex(const char *desc, SPOOL_R_GETPRINTERDATAEX *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_setprinterdataex(const char *desc, SPOOL_Q_SETPRINTERDATAEX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_setprinterdataex(const char *desc, SPOOL_R_SETPRINTERDATAEX *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_enumprinterkey(SPOOL_Q_ENUMPRINTERKEY *q_u, 
				   POLICY_HND *hnd, const char *key, 
				   uint32 size);
BOOL spoolss_io_q_enumprinterkey(const char *desc, SPOOL_Q_ENUMPRINTERKEY *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprinterkey(const char *desc, SPOOL_R_ENUMPRINTERKEY *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_deleteprinterkey(SPOOL_Q_DELETEPRINTERKEY *q_u, 
				     POLICY_HND *hnd, char *keyname);
BOOL spoolss_io_q_deleteprinterkey(const char *desc, SPOOL_Q_DELETEPRINTERKEY *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_deleteprinterkey(const char *desc, SPOOL_R_DELETEPRINTERKEY *r_u, prs_struct *ps, int depth);
BOOL spoolss_io_q_enumprinterdataex(const char *desc, SPOOL_Q_ENUMPRINTERDATAEX *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_enumprinterdataex(const char *desc, SPOOL_R_ENUMPRINTERDATAEX *r_u, prs_struct *ps, int depth);
BOOL make_spoolss_q_getprintprocessordirectory(SPOOL_Q_GETPRINTPROCESSORDIRECTORY *q_u, const char *name, char *environment, int level, RPC_BUFFER *buffer, uint32 offered);
BOOL spoolss_io_q_getprintprocessordirectory(const char *desc, SPOOL_Q_GETPRINTPROCESSORDIRECTORY *q_u, prs_struct *ps, int depth);
BOOL spoolss_io_r_getprintprocessordirectory(const char *desc, SPOOL_R_GETPRINTPROCESSORDIRECTORY *r_u, prs_struct *ps, int depth);
BOOL smb_io_printprocessordirectory_1(const char *desc, RPC_BUFFER *buffer, PRINTPROCESSOR_DIRECTORY_1 *info, int depth);
BOOL make_spoolss_q_addform(SPOOL_Q_ADDFORM *q_u, POLICY_HND *handle, 
			    int level, FORM *form);
BOOL make_spoolss_q_setform(SPOOL_Q_SETFORM *q_u, POLICY_HND *handle, 
			    int level, const char *form_name, FORM *form);
BOOL make_spoolss_q_deleteform(SPOOL_Q_DELETEFORM *q_u, POLICY_HND *handle, 
			       const char *form);
BOOL make_spoolss_q_getform(SPOOL_Q_GETFORM *q_u, POLICY_HND *handle, 
                            const char *formname, uint32 level, 
			    RPC_BUFFER *buffer, uint32 offered);
BOOL make_spoolss_q_enumforms(SPOOL_Q_ENUMFORMS *q_u, POLICY_HND *handle, 
			      uint32 level, RPC_BUFFER *buffer,
			      uint32 offered);
BOOL make_spoolss_q_setjob(SPOOL_Q_SETJOB *q_u, POLICY_HND *handle, 
			   uint32 jobid, uint32 level, uint32 command);
BOOL make_spoolss_q_getjob(SPOOL_Q_GETJOB *q_u, POLICY_HND *handle, 
			   uint32 jobid, uint32 level, RPC_BUFFER *buffer,
			   uint32 offered);
BOOL make_spoolss_q_startpageprinter(SPOOL_Q_STARTPAGEPRINTER *q_u, 
				     POLICY_HND *handle);
BOOL make_spoolss_q_endpageprinter(SPOOL_Q_ENDPAGEPRINTER *q_u, 
				   POLICY_HND *handle);
BOOL make_spoolss_q_startdocprinter(SPOOL_Q_STARTDOCPRINTER *q_u, 
				    POLICY_HND *handle, uint32 level,
				    char *docname, char *outputfile,
				    char *datatype);
BOOL make_spoolss_q_enddocprinter(SPOOL_Q_ENDDOCPRINTER *q_u, 
				  POLICY_HND *handle);
BOOL make_spoolss_q_writeprinter(SPOOL_Q_WRITEPRINTER *q_u, 
				 POLICY_HND *handle, uint32 data_size,
				 char *data);
BOOL make_spoolss_q_deleteprinterdata(SPOOL_Q_DELETEPRINTERDATA *q_u, 
				 POLICY_HND *handle, char *valuename);
BOOL make_spoolss_q_deleteprinterdataex(SPOOL_Q_DELETEPRINTERDATAEX *q_u, 
					POLICY_HND *handle, char *key,
					char *value);
BOOL make_spoolss_q_rffpcnex(SPOOL_Q_RFFPCNEX *q_u, POLICY_HND *handle,
			     uint32 flags, uint32 options, const char *localmachine,
			     uint32 printerlocal, SPOOL_NOTIFY_OPTION *option);

/* The following definitions come from rpc_parse/parse_srv.c  */

void init_srv_share_info0_str(SH_INFO_0_STR *sh0, const char *net_name);
void init_srv_share_info0(SH_INFO_0 *sh0, const char *net_name);
void init_srv_share_info1_str(SH_INFO_1_STR *sh1, const char *net_name, const char *remark);
void init_srv_share_info1(SH_INFO_1 *sh1, const char *net_name, uint32 type, const char *remark);
void init_srv_share_info2_str(SH_INFO_2_STR *sh2,
				const char *net_name, const char *remark,
				const char *path, const char *passwd);
void init_srv_share_info2(SH_INFO_2 *sh2,
				const char *net_name, uint32 type, const char *remark,
				uint32 perms, uint32 max_uses, uint32 num_uses,
				const char *path, const char *passwd);
void init_srv_share_info501_str(SH_INFO_501_STR *sh501,
				const char *net_name, const char *remark);
void init_srv_share_info501(SH_INFO_501 *sh501, const char *net_name, uint32 type, const char *remark, uint32 csc_policy);
void init_srv_share_info502(SH_INFO_502 *sh502,
				const char *net_name, uint32 type, const char *remark,
				uint32 perms, uint32 max_uses, uint32 num_uses,
				const char *path, const char *passwd, SEC_DESC *psd, size_t sd_size);
void init_srv_share_info502_str(SH_INFO_502_STR *sh502str,
				const char *net_name, const char *remark,
				const char *path, const char *passwd, SEC_DESC *psd, size_t sd_size);
void init_srv_share_info1004_str(SH_INFO_1004_STR *sh1004, const char *remark);
void init_srv_share_info1004(SH_INFO_1004 *sh1004, const char *remark);
void init_srv_share_info1007_str(SH_INFO_1007_STR *sh1007, const char *alternate_directory_name);
void init_srv_share_info1007(SH_INFO_1007 *sh1007, uint32 flags, const char *alternate_directory_name);
void init_srv_q_net_share_enum(SRV_Q_NET_SHARE_ENUM *q_n, 
				const char *srv_name, uint32 info_level,
				uint32 preferred_len, ENUM_HND *hnd);
BOOL srv_io_q_net_share_enum(const char *desc, SRV_Q_NET_SHARE_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_share_enum(const char *desc, SRV_R_NET_SHARE_ENUM *r_n, prs_struct *ps, int depth);
BOOL init_srv_q_net_share_get_info(SRV_Q_NET_SHARE_GET_INFO *q_n, const char *srv_name, const char *share_name, uint32 info_level);
BOOL srv_io_q_net_share_get_info(const char *desc, SRV_Q_NET_SHARE_GET_INFO *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_share_get_info(const char *desc, SRV_R_NET_SHARE_GET_INFO *r_n, prs_struct *ps, int depth);
BOOL init_srv_q_net_share_set_info(SRV_Q_NET_SHARE_SET_INFO *q_n, 
				   const char *srv_name, 
				   const char *share_name, 
				   uint32 info_level, 
				   const SRV_SHARE_INFO *info) ;
BOOL srv_io_q_net_share_set_info(const char *desc, SRV_Q_NET_SHARE_SET_INFO *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_share_set_info(const char *desc, SRV_R_NET_SHARE_SET_INFO *r_n, prs_struct *ps, int depth);
BOOL srv_io_q_net_share_add(const char *desc, SRV_Q_NET_SHARE_ADD *q_n, prs_struct *ps, int depth);
void init_srv_q_net_share_add(SRV_Q_NET_SHARE_ADD *q, const char *srvname,
			      const char *netname, uint32 type, const char *remark, 
			      uint32 perms, uint32 max_uses, uint32 num_uses,
			      const char *path, const char *passwd, 
			      int level, SEC_DESC *sd);
BOOL srv_io_r_net_share_add(const char *desc, SRV_R_NET_SHARE_ADD *r_n, prs_struct *ps, int depth);
void init_srv_q_net_share_del(SRV_Q_NET_SHARE_DEL *del, const char *srvname,
			      const char *sharename);
BOOL srv_io_q_net_share_del(const char *desc, SRV_Q_NET_SHARE_DEL *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_share_del(const char *desc, SRV_R_NET_SHARE_DEL *q_n, prs_struct *ps, int depth);
void init_srv_sess_info0_str(SESS_INFO_0_STR *ss0, const char *name);
void init_srv_sess_info0(SESS_INFO_0 *ss0, const char *name);
void init_srv_sess_info1_str(SESS_INFO_1_STR *ss1, const char *name, const char *user);
void init_srv_sess_info1(SESS_INFO_1 *ss1, 
				const char *name, const char *user,
				uint32 num_opens, uint32 open_time, uint32 idle_time,
				uint32 user_flags);
void init_srv_q_net_sess_enum(SRV_Q_NET_SESS_ENUM *q_n, 
			      const char *srv_name, const char *qual_name,
			      const char *user_name, uint32 sess_level, 
			      SRV_SESS_INFO_CTR *ctr, uint32 preferred_len,
			      ENUM_HND *hnd);
BOOL srv_io_q_net_sess_enum(const char *desc, SRV_Q_NET_SESS_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_sess_enum(const char *desc, SRV_R_NET_SESS_ENUM *r_n, prs_struct *ps, int depth);
void init_srv_q_net_sess_del(SRV_Q_NET_SESS_DEL *q_n, const char *srv_name,
			      const char *cli_name, const char *user_name);
BOOL srv_io_q_net_sess_del(const char *desc, SRV_Q_NET_SESS_DEL *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_sess_del(const char *desc, SRV_R_NET_SESS_DEL *r_n, prs_struct *ps, int depth);
void init_srv_conn_info0(CONN_INFO_0 *ss0, uint32 id);
void init_srv_conn_info1_str(CONN_INFO_1_STR *ss1, const char *usr_name, const char *net_name);
void init_srv_conn_info1(CONN_INFO_1 *ss1, 
				uint32 id, uint32 type,
				uint32 num_opens, uint32 num_users, uint32 open_time,
				const char *usr_name, const char *net_name);
void init_srv_q_net_conn_enum(SRV_Q_NET_CONN_ENUM *q_n, 
				const char *srv_name, const char *qual_name,
				uint32 conn_level, SRV_CONN_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd);
BOOL srv_io_q_net_conn_enum(const char *desc, SRV_Q_NET_CONN_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_conn_enum(const char *desc,  SRV_R_NET_CONN_ENUM *r_n, prs_struct *ps, int depth);
void init_srv_file_info3_str(FILE_INFO_3_STR *fi3, const char *user_name, const char *path_name);
void init_srv_file_info3(FILE_INFO_3 *fl3,
			 uint32 id, uint32 perms, uint32 num_locks,
			 const char *path_name, const char *user_name);
void init_srv_q_net_file_enum(SRV_Q_NET_FILE_ENUM *q_n, 
			      const char *srv_name, const char *qual_name, 
			      const char *user_name,
			      uint32 file_level, SRV_FILE_INFO_CTR *ctr,
			      uint32 preferred_len,
			      ENUM_HND *hnd);
BOOL srv_io_q_net_file_enum(const char *desc, SRV_Q_NET_FILE_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_file_enum(const char *desc, SRV_R_NET_FILE_ENUM *r_n, prs_struct *ps, int depth);
void init_srv_q_net_file_close(SRV_Q_NET_FILE_CLOSE *q_n, const char *server,
			       uint32 file_id);
BOOL srv_io_q_net_file_close(const char *desc, SRV_Q_NET_FILE_CLOSE *q_n,
			     prs_struct *ps, int depth);
BOOL srv_io_r_net_file_close(const char *desc, SRV_R_NET_FILE_CLOSE *q_n, 
			     prs_struct *ps, int depth);
void init_srv_info_100(SRV_INFO_100 *sv100, uint32 platform_id, const char *name);
void init_srv_info_101(SRV_INFO_101 *sv101, uint32 platform_id, const char *name,
				uint32 ver_major, uint32 ver_minor,
				uint32 srv_type, const char *comment);
void init_srv_info_102(SRV_INFO_102 *sv102, uint32 platform_id, const char *name,
				const char *comment, uint32 ver_major, uint32 ver_minor,
				uint32 srv_type, uint32 users, uint32 disc, uint32 hidden,
				uint32 announce, uint32 ann_delta, uint32 licenses,
				const char *usr_path);
void init_srv_q_net_srv_get_info(SRV_Q_NET_SRV_GET_INFO *srv,
				const char *server_name, uint32 switch_value);
BOOL srv_io_q_net_srv_get_info(const char *desc, SRV_Q_NET_SRV_GET_INFO *q_n, prs_struct *ps, int depth);
void init_srv_r_net_srv_get_info(SRV_R_NET_SRV_GET_INFO *srv,
				uint32 switch_value, SRV_INFO_CTR *ctr, WERROR status);
void init_srv_r_net_srv_set_info(SRV_R_NET_SRV_SET_INFO *srv,
				 uint32 switch_value, WERROR status);
BOOL srv_io_q_net_srv_set_info(const char *desc, SRV_Q_NET_SRV_SET_INFO *q_n, 
			       prs_struct *ps, int depth);
BOOL srv_io_r_net_srv_get_info(const char *desc, SRV_R_NET_SRV_GET_INFO *r_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_srv_set_info(const char *desc, SRV_R_NET_SRV_SET_INFO *r_n, 
			       prs_struct *ps, int depth);
BOOL srv_io_q_net_remote_tod(const char *desc, SRV_Q_NET_REMOTE_TOD *q_n, prs_struct *ps, int depth);
void init_time_of_day_info(TIME_OF_DAY_INFO *tod, uint32 elapsedt, uint32 msecs,
                           uint32 hours, uint32 mins, uint32 secs, uint32 hunds,
			   uint32 zone, uint32 tintervals, uint32 day,
			   uint32 month, uint32 year, uint32 weekday);
BOOL srv_io_r_net_remote_tod(const char *desc, SRV_R_NET_REMOTE_TOD *r_n, prs_struct *ps, int depth);
BOOL init_srv_q_net_disk_enum(SRV_Q_NET_DISK_ENUM *q_n,
			      const char *srv_name,
			      uint32 preferred_len,
			      ENUM_HND *enum_hnd
	) ;
BOOL srv_io_q_net_disk_enum(const char *desc, SRV_Q_NET_DISK_ENUM *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_disk_enum(const char *desc, SRV_R_NET_DISK_ENUM *r_n, prs_struct *ps, int depth);
BOOL init_srv_q_net_name_validate(SRV_Q_NET_NAME_VALIDATE *q_n, const char *srv_name, const char *share_name, int type) ;
BOOL srv_io_q_net_name_validate(const char *desc, SRV_Q_NET_NAME_VALIDATE *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_name_validate(const char *desc, SRV_R_NET_NAME_VALIDATE *r_n, prs_struct *ps, int depth);
BOOL srv_io_q_net_file_query_secdesc(const char *desc, SRV_Q_NET_FILE_QUERY_SECDESC *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_file_query_secdesc(const char *desc, SRV_R_NET_FILE_QUERY_SECDESC *r_n, prs_struct *ps, int depth);
BOOL srv_io_q_net_file_set_secdesc(const char *desc, SRV_Q_NET_FILE_SET_SECDESC *q_n, prs_struct *ps, int depth);
BOOL srv_io_r_net_file_set_secdesc(const char *desc, SRV_R_NET_FILE_SET_SECDESC *r_n, prs_struct *ps, int depth);
void init_srv_q_net_remote_tod(SRV_Q_NET_REMOTE_TOD *q_u, const char *server);

/* The following definitions come from rpc_parse/parse_svcctl.c  */

BOOL svcctl_io_service_description( const char *desc, UNISTR2 *svcdesc, prs_struct *ps, int depth );
BOOL svcctl_io_enum_services_status( const char *desc, ENUM_SERVICES_STATUS *enum_status, RPC_BUFFER *buffer, int depth );
uint32 svcctl_sizeof_enum_services_status( ENUM_SERVICES_STATUS *status );
BOOL svcctl_io_q_close_service(const char *desc, SVCCTL_Q_CLOSE_SERVICE *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_close_service(const char *desc, SVCCTL_R_CLOSE_SERVICE *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_open_scmanager(const char *desc, SVCCTL_Q_OPEN_SCMANAGER *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_open_scmanager(const char *desc, SVCCTL_R_OPEN_SCMANAGER *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_get_display_name(const char *desc, SVCCTL_Q_GET_DISPLAY_NAME *q_u, prs_struct *ps, int depth);
BOOL init_svcctl_r_get_display_name( SVCCTL_R_GET_DISPLAY_NAME *r_u, const char *displayname );
BOOL svcctl_io_r_get_display_name(const char *desc, SVCCTL_R_GET_DISPLAY_NAME *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_open_service(const char *desc, SVCCTL_Q_OPEN_SERVICE *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_open_service(const char *desc, SVCCTL_R_OPEN_SERVICE *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_query_status(const char *desc, SVCCTL_Q_QUERY_STATUS *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_query_status(const char *desc, SVCCTL_R_QUERY_STATUS *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_enum_services_status(const char *desc, SVCCTL_Q_ENUM_SERVICES_STATUS *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_enum_services_status(const char *desc, SVCCTL_R_ENUM_SERVICES_STATUS *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_start_service(const char *desc, SVCCTL_Q_START_SERVICE *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_start_service(const char *desc, SVCCTL_R_START_SERVICE *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_enum_dependent_services(const char *desc, SVCCTL_Q_ENUM_DEPENDENT_SERVICES *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_enum_dependent_services(const char *desc, SVCCTL_R_ENUM_DEPENDENT_SERVICES *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_control_service(const char *desc, SVCCTL_Q_CONTROL_SERVICE *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_control_service(const char *desc, SVCCTL_R_CONTROL_SERVICE *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_query_service_config(const char *desc, SVCCTL_Q_QUERY_SERVICE_CONFIG *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_query_service_config(const char *desc, SVCCTL_R_QUERY_SERVICE_CONFIG *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_q_query_service_config2(const char *desc, SVCCTL_Q_QUERY_SERVICE_CONFIG2 *q_u, prs_struct *ps, int depth);
void init_service_description_buffer(RPC_DATA_BLOB *str,  const char *service_desc, int blob_length);
BOOL svcctl_io_q_query_service_status_ex(const char *desc, SVCCTL_Q_QUERY_SERVICE_STATUSEX *q_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_query_service_status_ex(const char *desc, SVCCTL_R_QUERY_SERVICE_STATUSEX *r_u, prs_struct *ps, int depth);
BOOL svcctl_io_r_query_service_config2(const char *desc, SVCCTL_R_QUERY_SERVICE_CONFIG2 *r_u, prs_struct *ps, int depth);

/* The following definitions come from rpc_parse/parse_wks.c  */

void init_wks_q_query_info(WKS_Q_QUERY_INFO *q_u,
				char *server, uint16 switch_value)  ;
BOOL wks_io_q_query_info(const char *desc, WKS_Q_QUERY_INFO *q_u, prs_struct *ps, int depth);
void init_wks_info_100(WKS_INFO_100 *inf,
				uint32 platform_id, uint32 ver_major, uint32 ver_minor,
				char *my_name, char *domain_name);
void init_wks_r_query_info(WKS_R_QUERY_INFO *r_u,
			   uint32 switch_value, WKS_INFO_100 *wks100,
			   NTSTATUS status)  ;
BOOL wks_io_r_query_info(const char *desc, WKS_R_QUERY_INFO *r_u, prs_struct *ps, int depth);

/* The following definitions come from rpc_server/srv_dfs.c  */

void netdfs_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_dfs_init(void);

/* The following definitions come from rpc_server/srv_dfs_nt.c  */

uint32 _dfs_exist(pipes_struct *p, DFS_Q_DFS_EXIST *q_u, DFS_R_DFS_EXIST *r_u);
WERROR _dfs_add(pipes_struct *p, DFS_Q_DFS_ADD* q_u, DFS_R_DFS_ADD *r_u);
WERROR _dfs_remove(pipes_struct *p, DFS_Q_DFS_REMOVE *q_u, 
                   DFS_R_DFS_REMOVE *r_u);
WERROR _dfs_enum(pipes_struct *p, DFS_Q_DFS_ENUM *q_u, DFS_R_DFS_ENUM *r_u);
WERROR _dfs_get_info(pipes_struct *p, DFS_Q_DFS_GET_INFO *q_u, 
                     DFS_R_DFS_GET_INFO *r_u);

/* The following definitions come from rpc_server/srv_echo.c  */

void echo_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_echo_init(void);
NTSTATUS rpc_echo_init(void);

/* The following definitions come from rpc_server/srv_echo_nt.c  */

void _echo_add_one(pipes_struct *p, ECHO_Q_ADD_ONE *q_u, ECHO_R_ADD_ONE *r_u);
void _echo_data(pipes_struct *p, ECHO_Q_ECHO_DATA *q_u, 
		ECHO_R_ECHO_DATA *r_u);
void _sink_data(pipes_struct *p, ECHO_Q_SINK_DATA *q_u, 
		ECHO_R_SINK_DATA *r_u);
void _source_data(pipes_struct *p, ECHO_Q_SOURCE_DATA *q_u, 
		  ECHO_R_SOURCE_DATA *r_u);

/* The following definitions come from rpc_server/srv_eventlog.c  */

NTSTATUS rpc_eventlog_init(void);
void eventlog_get_pipe_fns(struct api_struct **fns, int *n_fns);

/* The following definitions come from rpc_server/srv_eventlog_nt.c  */

void policy_handle_to_string(POLICY_HND *handle, fstring *dest);
WERROR _eventlog_open_eventlog(pipes_struct *p,
			       EVENTLOG_Q_OPEN_EVENTLOG *q_u,
			       EVENTLOG_R_OPEN_EVENTLOG *r_u);
WERROR _eventlog_get_num_records(pipes_struct *p,
				 EVENTLOG_Q_GET_NUM_RECORDS *q_u,
				 EVENTLOG_R_GET_NUM_RECORDS *r_u);
WERROR _eventlog_get_oldest_entry(pipes_struct *p,
				  EVENTLOG_Q_GET_OLDEST_ENTRY *q_u,
				  EVENTLOG_R_GET_OLDEST_ENTRY *r_u);
WERROR _eventlog_close_eventlog(pipes_struct *p,
				EVENTLOG_Q_CLOSE_EVENTLOG *q_u,
				EVENTLOG_R_CLOSE_EVENTLOG *r_u);
WERROR _eventlog_read_eventlog(pipes_struct *p,
			       EVENTLOG_Q_READ_EVENTLOG *q_u,
			       EVENTLOG_R_READ_EVENTLOG *r_u);
WERROR _eventlog_clear_eventlog(pipes_struct *p,
				EVENTLOG_Q_CLEAR_EVENTLOG *q_u,
				EVENTLOG_R_CLEAR_EVENTLOG *r_u);

/* The following definitions come from rpc_server/srv_lsa.c  */

void lsa_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_lsa_init(void);

/* The following definitions come from rpc_server/srv_lsa_ds.c  */

void lsa_ds_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_lsa_ds_init(void);

/* The following definitions come from rpc_server/srv_lsa_ds_nt.c  */

NTSTATUS _dsrole_get_primary_dominfo(pipes_struct *p, DS_Q_GETPRIMDOMINFO *q_u, DS_R_GETPRIMDOMINFO *r_u);

/* The following definitions come from rpc_server/srv_lsa_hnd.c  */

BOOL init_pipe_handle_list(pipes_struct *p, char *pipe_name);
BOOL create_policy_hnd(pipes_struct *p, POLICY_HND *hnd, void (*free_fn)(void *), void *data_ptr);
BOOL find_policy_by_hnd(pipes_struct *p, POLICY_HND *hnd, void **data_p);
BOOL close_policy_hnd(pipes_struct *p, POLICY_HND *hnd);
void close_policy_by_pipe(pipes_struct *p);
BOOL pipe_access_check(pipes_struct *p);

/* The following definitions come from rpc_server/srv_lsa_nt.c  */

NTSTATUS _lsa_open_policy2(pipes_struct *p, LSA_Q_OPEN_POL2 *q_u, LSA_R_OPEN_POL2 *r_u);
NTSTATUS _lsa_open_policy(pipes_struct *p, LSA_Q_OPEN_POL *q_u, LSA_R_OPEN_POL *r_u);
NTSTATUS _lsa_enum_trust_dom(pipes_struct *p, LSA_Q_ENUM_TRUST_DOM *q_u, LSA_R_ENUM_TRUST_DOM *r_u);
NTSTATUS _lsa_query_info(pipes_struct *p, LSA_Q_QUERY_INFO *q_u, LSA_R_QUERY_INFO *r_u);
NTSTATUS _lsa_lookup_sids(pipes_struct *p, LSA_Q_LOOKUP_SIDS *q_u, LSA_R_LOOKUP_SIDS *r_u);
NTSTATUS _lsa_lookup_names(pipes_struct *p,LSA_Q_LOOKUP_NAMES *q_u, LSA_R_LOOKUP_NAMES *r_u);
NTSTATUS _lsa_close(pipes_struct *p, LSA_Q_CLOSE *q_u, LSA_R_CLOSE *r_u);
NTSTATUS _lsa_open_secret(pipes_struct *p, LSA_Q_OPEN_SECRET *q_u, LSA_R_OPEN_SECRET *r_u);
NTSTATUS _lsa_open_trusted_domain(pipes_struct *p, LSA_Q_OPEN_TRUSTED_DOMAIN *q_u, LSA_R_OPEN_TRUSTED_DOMAIN *r_u);
NTSTATUS _lsa_create_trusted_domain(pipes_struct *p, LSA_Q_CREATE_TRUSTED_DOMAIN *q_u, LSA_R_CREATE_TRUSTED_DOMAIN *r_u);
NTSTATUS _lsa_create_secret(pipes_struct *p, LSA_Q_CREATE_SECRET *q_u, LSA_R_CREATE_SECRET *r_u);
NTSTATUS _lsa_set_secret(pipes_struct *p, LSA_Q_SET_SECRET *q_u, LSA_R_SET_SECRET *r_u);
NTSTATUS _lsa_delete_object(pipes_struct *p, LSA_Q_DELETE_OBJECT *q_u, LSA_R_DELETE_OBJECT *r_u);
NTSTATUS _lsa_enum_privs(pipes_struct *p, LSA_Q_ENUM_PRIVS *q_u, LSA_R_ENUM_PRIVS *r_u);
NTSTATUS _lsa_priv_get_dispname(pipes_struct *p, LSA_Q_PRIV_GET_DISPNAME *q_u, LSA_R_PRIV_GET_DISPNAME *r_u);
NTSTATUS _lsa_enum_accounts(pipes_struct *p, LSA_Q_ENUM_ACCOUNTS *q_u, LSA_R_ENUM_ACCOUNTS *r_u);
NTSTATUS _lsa_unk_get_connuser(pipes_struct *p, LSA_Q_UNK_GET_CONNUSER *q_u, LSA_R_UNK_GET_CONNUSER *r_u);
NTSTATUS _lsa_create_account(pipes_struct *p, LSA_Q_CREATEACCOUNT *q_u, LSA_R_CREATEACCOUNT *r_u);
NTSTATUS _lsa_open_account(pipes_struct *p, LSA_Q_OPENACCOUNT *q_u, LSA_R_OPENACCOUNT *r_u);
NTSTATUS _lsa_enum_privsaccount(pipes_struct *p, prs_struct *ps, LSA_Q_ENUMPRIVSACCOUNT *q_u, LSA_R_ENUMPRIVSACCOUNT *r_u);
NTSTATUS _lsa_getsystemaccount(pipes_struct *p, LSA_Q_GETSYSTEMACCOUNT *q_u, LSA_R_GETSYSTEMACCOUNT *r_u);
NTSTATUS _lsa_setsystemaccount(pipes_struct *p, LSA_Q_SETSYSTEMACCOUNT *q_u, LSA_R_SETSYSTEMACCOUNT *r_u);
NTSTATUS _lsa_addprivs(pipes_struct *p, LSA_Q_ADDPRIVS *q_u, LSA_R_ADDPRIVS *r_u);
NTSTATUS _lsa_removeprivs(pipes_struct *p, LSA_Q_REMOVEPRIVS *q_u, LSA_R_REMOVEPRIVS *r_u);
NTSTATUS _lsa_query_secobj(pipes_struct *p, LSA_Q_QUERY_SEC_OBJ *q_u, LSA_R_QUERY_SEC_OBJ *r_u);
NTSTATUS _lsa_query_info2(pipes_struct *p, LSA_Q_QUERY_INFO2 *q_u, LSA_R_QUERY_INFO2 *r_u);
NTSTATUS _lsa_add_acct_rights(pipes_struct *p, LSA_Q_ADD_ACCT_RIGHTS *q_u, LSA_R_ADD_ACCT_RIGHTS *r_u);
NTSTATUS _lsa_remove_acct_rights(pipes_struct *p, LSA_Q_REMOVE_ACCT_RIGHTS *q_u, LSA_R_REMOVE_ACCT_RIGHTS *r_u);
NTSTATUS _lsa_enum_acct_rights(pipes_struct *p, LSA_Q_ENUM_ACCT_RIGHTS *q_u, LSA_R_ENUM_ACCT_RIGHTS *r_u);
NTSTATUS _lsa_lookup_priv_value(pipes_struct *p, LSA_Q_LOOKUP_PRIV_VALUE *q_u, LSA_R_LOOKUP_PRIV_VALUE *r_u);

/* The following definitions come from rpc_server/srv_netlog.c  */

void netlog_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_net_init(void);

/* The following definitions come from rpc_server/srv_netlog_nt.c  */

NTSTATUS _net_logon_ctrl(pipes_struct *p, NET_Q_LOGON_CTRL *q_u, 
		       NET_R_LOGON_CTRL *r_u);
NTSTATUS _net_logon_ctrl2(pipes_struct *p, NET_Q_LOGON_CTRL2 *q_u, NET_R_LOGON_CTRL2 *r_u);
NTSTATUS _net_trust_dom_list(pipes_struct *p, NET_Q_TRUST_DOM_LIST *q_u, NET_R_TRUST_DOM_LIST *r_u);
NTSTATUS _net_req_chal(pipes_struct *p, NET_Q_REQ_CHAL *q_u, NET_R_REQ_CHAL *r_u);
NTSTATUS _net_auth(pipes_struct *p, NET_Q_AUTH *q_u, NET_R_AUTH *r_u);
NTSTATUS _net_auth_2(pipes_struct *p, NET_Q_AUTH_2 *q_u, NET_R_AUTH_2 *r_u);
NTSTATUS _net_srv_pwset(pipes_struct *p, NET_Q_SRV_PWSET *q_u, NET_R_SRV_PWSET *r_u);
NTSTATUS _net_sam_logoff(pipes_struct *p, NET_Q_SAM_LOGOFF *q_u, NET_R_SAM_LOGOFF *r_u);
NTSTATUS _net_sam_logon(pipes_struct *p, NET_Q_SAM_LOGON *q_u, NET_R_SAM_LOGON *r_u);
NTSTATUS _ds_enum_dom_trusts(pipes_struct *p, DS_Q_ENUM_DOM_TRUSTS *q_u,
			     DS_R_ENUM_DOM_TRUSTS *r_u);

/* The following definitions come from rpc_server/srv_pipe.c  */

BOOL create_next_pdu(pipes_struct *p);
BOOL api_pipe_bind_auth_resp(pipes_struct *p, prs_struct *rpc_in_p);
BOOL setup_fault_pdu(pipes_struct *p, NTSTATUS status);
BOOL check_bind_req(struct pipes_struct *p, RPC_IFACE* abstract,
                    RPC_IFACE* transfer, uint32 context_id);
NTSTATUS rpc_pipe_register_commands(int version, const char *clnt, const char *srv, const struct api_struct *cmds, int size);
BOOL api_pipe_bind_req(pipes_struct *p, prs_struct *rpc_in_p);
BOOL api_pipe_auth_process(pipes_struct *p, prs_struct *rpc_in);
BOOL api_pipe_netsec_process(pipes_struct *p, prs_struct *rpc_in);
struct current_user *get_current_user(struct current_user *user, pipes_struct *p);
void free_pipe_rpc_context( PIPE_RPC_FNS *list );
BOOL api_pipe_request(pipes_struct *p);
BOOL api_rpcTNP(pipes_struct *p, const char *rpc_name, 
		const struct api_struct *api_rpc_cmds, int n_cmds);
void get_pipe_fns( int idx, struct api_struct **fns, int *n_fns );

/* The following definitions come from rpc_server/srv_pipe_hnd.c  */

smb_np_struct *get_first_pipe(void);
smb_np_struct *get_next_pipe(smb_np_struct *p);
pipes_struct *get_first_internal_pipe(void);
pipes_struct *get_next_internal_pipe(pipes_struct *p);
void set_pipe_handle_offset(int max_open_files);
void reset_chain_p(void);
void init_rpc_pipe_hnd(void);
smb_np_struct *open_rpc_pipe_p(char *pipe_name, 
			      connection_struct *conn, uint16 vuid);
ssize_t write_to_pipe(smb_np_struct *p, char *data, size_t n);
ssize_t read_from_pipe(smb_np_struct *p, char *data, size_t n,
		BOOL *is_data_outstanding);
BOOL wait_rpc_pipe_hnd_state(smb_np_struct *p, uint16 priority);
BOOL set_rpc_pipe_hnd_state(smb_np_struct *p, uint16 device_state);
BOOL close_rpc_pipe_hnd(smb_np_struct *p);
void pipe_close_conn(connection_struct *conn);
smb_np_struct *get_rpc_pipe_p(char *buf, int where);
smb_np_struct *get_rpc_pipe(int pnum);

/* The following definitions come from rpc_server/srv_reg.c  */

void reg_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_reg_init(void);

/* The following definitions come from rpc_server/srv_reg_nt.c  */

NTSTATUS registry_access_check( SEC_DESC *sec_desc, NT_USER_TOKEN *token, 
                                     uint32 access_desired, uint32 *access_granted );
SEC_DESC* construct_registry_sd( TALLOC_CTX *ctx );
WERROR _reg_close(pipes_struct *p, REG_Q_CLOSE *q_u, REG_R_CLOSE *r_u);
WERROR _reg_open_hklm(pipes_struct *p, REG_Q_OPEN_HIVE *q_u, REG_R_OPEN_HIVE *r_u);
WERROR _reg_open_hkcr(pipes_struct *p, REG_Q_OPEN_HIVE *q_u, REG_R_OPEN_HIVE *r_u);
WERROR _reg_open_hku(pipes_struct *p, REG_Q_OPEN_HIVE *q_u, REG_R_OPEN_HIVE *r_u);
WERROR _reg_open_entry(pipes_struct *p, REG_Q_OPEN_ENTRY *q_u, REG_R_OPEN_ENTRY *r_u);
WERROR _reg_query_value(pipes_struct *p, REG_Q_QUERY_VALUE *q_u, REG_R_QUERY_VALUE *r_u);
WERROR _reg_query_key(pipes_struct *p, REG_Q_QUERY_KEY *q_u, REG_R_QUERY_KEY *r_u);
WERROR _reg_getversion(pipes_struct *p, REG_Q_GETVERSION *q_u, REG_R_GETVERSION *r_u);
WERROR _reg_enum_key(pipes_struct *p, REG_Q_ENUM_KEY *q_u, REG_R_ENUM_KEY *r_u);
WERROR _reg_enum_value(pipes_struct *p, REG_Q_ENUM_VALUE *q_u, REG_R_ENUM_VALUE *r_u);
WERROR _reg_shutdown(pipes_struct *p, REG_Q_SHUTDOWN *q_u, REG_R_SHUTDOWN *r_u);
WERROR _reg_shutdown_ex(pipes_struct *p, REG_Q_SHUTDOWN_EX *q_u, REG_R_SHUTDOWN_EX *r_u);
WERROR _reg_abort_shutdown(pipes_struct *p, REG_Q_ABORT_SHUTDOWN *q_u, REG_R_ABORT_SHUTDOWN *r_u);
WERROR _reg_restore_key(pipes_struct *p, REG_Q_RESTORE_KEY  *q_u, REG_R_RESTORE_KEY *r_u);
WERROR _reg_save_key(pipes_struct *p, REG_Q_SAVE_KEY  *q_u, REG_R_SAVE_KEY *r_u);
WERROR _reg_create_key_ex(pipes_struct *p, REG_Q_CREATE_KEY_EX *q_u, REG_R_CREATE_KEY_EX *r_u);
WERROR _reg_set_value(pipes_struct *p, REG_Q_SET_VALUE  *q_u, REG_R_SET_VALUE *r_u);
WERROR _reg_delete_key(pipes_struct *p, REG_Q_DELETE_KEY  *q_u, REG_R_DELETE_KEY *r_u);
WERROR _reg_delete_value(pipes_struct *p, REG_Q_DELETE_VALUE  *q_u, REG_R_DELETE_VALUE *r_u);
WERROR _reg_get_key_sec(pipes_struct *p, REG_Q_GET_KEY_SEC  *q_u, REG_R_GET_KEY_SEC *r_u);
WERROR _reg_set_key_sec(pipes_struct *p, REG_Q_SET_KEY_SEC  *q_u, REG_R_SET_KEY_SEC *r_u);

/* The following definitions come from rpc_server/srv_samr.c  */

void samr_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_samr_init(void);

/* The following definitions come from rpc_server/srv_samr_nt.c  */

NTSTATUS _samr_close_hnd(pipes_struct *p, SAMR_Q_CLOSE_HND *q_u, SAMR_R_CLOSE_HND *r_u);
NTSTATUS _samr_open_domain(pipes_struct *p, SAMR_Q_OPEN_DOMAIN *q_u, SAMR_R_OPEN_DOMAIN *r_u);
NTSTATUS _samr_get_usrdom_pwinfo(pipes_struct *p, SAMR_Q_GET_USRDOM_PWINFO *q_u, SAMR_R_GET_USRDOM_PWINFO *r_u);
NTSTATUS _samr_set_sec_obj(pipes_struct *p, SAMR_Q_SET_SEC_OBJ *q_u, SAMR_R_SET_SEC_OBJ *r_u);
NTSTATUS _samr_query_sec_obj(pipes_struct *p, SAMR_Q_QUERY_SEC_OBJ *q_u, SAMR_R_QUERY_SEC_OBJ *r_u);
NTSTATUS _samr_enum_dom_users(pipes_struct *p, SAMR_Q_ENUM_DOM_USERS *q_u, 
			      SAMR_R_ENUM_DOM_USERS *r_u);
NTSTATUS _samr_enum_dom_groups(pipes_struct *p, SAMR_Q_ENUM_DOM_GROUPS *q_u, SAMR_R_ENUM_DOM_GROUPS *r_u);
NTSTATUS _samr_enum_dom_aliases(pipes_struct *p, SAMR_Q_ENUM_DOM_ALIASES *q_u, SAMR_R_ENUM_DOM_ALIASES *r_u);
NTSTATUS _samr_query_dispinfo(pipes_struct *p, SAMR_Q_QUERY_DISPINFO *q_u, 
			      SAMR_R_QUERY_DISPINFO *r_u);
NTSTATUS _samr_query_aliasinfo(pipes_struct *p, SAMR_Q_QUERY_ALIASINFO *q_u, SAMR_R_QUERY_ALIASINFO *r_u);
NTSTATUS _samr_lookup_names(pipes_struct *p, SAMR_Q_LOOKUP_NAMES *q_u, SAMR_R_LOOKUP_NAMES *r_u);
NTSTATUS _samr_chgpasswd_user(pipes_struct *p, SAMR_Q_CHGPASSWD_USER *q_u, SAMR_R_CHGPASSWD_USER *r_u);
NTSTATUS _samr_lookup_rids(pipes_struct *p, SAMR_Q_LOOKUP_RIDS *q_u, SAMR_R_LOOKUP_RIDS *r_u);
NTSTATUS _samr_open_user(pipes_struct *p, SAMR_Q_OPEN_USER *q_u, SAMR_R_OPEN_USER *r_u);
NTSTATUS _samr_query_userinfo(pipes_struct *p, SAMR_Q_QUERY_USERINFO *q_u, SAMR_R_QUERY_USERINFO *r_u);
NTSTATUS _samr_query_usergroups(pipes_struct *p, SAMR_Q_QUERY_USERGROUPS *q_u, SAMR_R_QUERY_USERGROUPS *r_u);
NTSTATUS _samr_query_dom_info(pipes_struct *p, SAMR_Q_QUERY_DOMAIN_INFO *q_u, SAMR_R_QUERY_DOMAIN_INFO *r_u);
NTSTATUS _samr_create_user(pipes_struct *p, SAMR_Q_CREATE_USER *q_u, SAMR_R_CREATE_USER *r_u);
NTSTATUS _samr_connect_anon(pipes_struct *p, SAMR_Q_CONNECT_ANON *q_u, SAMR_R_CONNECT_ANON *r_u);
NTSTATUS _samr_connect(pipes_struct *p, SAMR_Q_CONNECT *q_u, SAMR_R_CONNECT *r_u);
NTSTATUS _samr_connect4(pipes_struct *p, SAMR_Q_CONNECT4 *q_u, SAMR_R_CONNECT4 *r_u);
NTSTATUS _samr_lookup_domain(pipes_struct *p, SAMR_Q_LOOKUP_DOMAIN *q_u, SAMR_R_LOOKUP_DOMAIN *r_u);
NTSTATUS _samr_enum_domains(pipes_struct *p, SAMR_Q_ENUM_DOMAINS *q_u, SAMR_R_ENUM_DOMAINS *r_u);
NTSTATUS _samr_open_alias(pipes_struct *p, SAMR_Q_OPEN_ALIAS *q_u, SAMR_R_OPEN_ALIAS *r_u);
NTSTATUS _samr_set_userinfo(pipes_struct *p, SAMR_Q_SET_USERINFO *q_u, SAMR_R_SET_USERINFO *r_u);
NTSTATUS _samr_set_userinfo2(pipes_struct *p, SAMR_Q_SET_USERINFO2 *q_u, SAMR_R_SET_USERINFO2 *r_u);
NTSTATUS _samr_query_useraliases(pipes_struct *p, SAMR_Q_QUERY_USERALIASES *q_u, SAMR_R_QUERY_USERALIASES *r_u);
NTSTATUS _samr_query_aliasmem(pipes_struct *p, SAMR_Q_QUERY_ALIASMEM *q_u, SAMR_R_QUERY_ALIASMEM *r_u);
NTSTATUS _samr_query_groupmem(pipes_struct *p, SAMR_Q_QUERY_GROUPMEM *q_u, SAMR_R_QUERY_GROUPMEM *r_u);
NTSTATUS _samr_add_aliasmem(pipes_struct *p, SAMR_Q_ADD_ALIASMEM *q_u, SAMR_R_ADD_ALIASMEM *r_u);
NTSTATUS _samr_del_aliasmem(pipes_struct *p, SAMR_Q_DEL_ALIASMEM *q_u, SAMR_R_DEL_ALIASMEM *r_u);
NTSTATUS _samr_add_groupmem(pipes_struct *p, SAMR_Q_ADD_GROUPMEM *q_u, SAMR_R_ADD_GROUPMEM *r_u);
NTSTATUS _samr_del_groupmem(pipes_struct *p, SAMR_Q_DEL_GROUPMEM *q_u, SAMR_R_DEL_GROUPMEM *r_u);
NTSTATUS _samr_delete_dom_user(pipes_struct *p, SAMR_Q_DELETE_DOM_USER *q_u, SAMR_R_DELETE_DOM_USER *r_u );
NTSTATUS _samr_delete_dom_group(pipes_struct *p, SAMR_Q_DELETE_DOM_GROUP *q_u, SAMR_R_DELETE_DOM_GROUP *r_u);
NTSTATUS _samr_delete_dom_alias(pipes_struct *p, SAMR_Q_DELETE_DOM_ALIAS *q_u, SAMR_R_DELETE_DOM_ALIAS *r_u);
NTSTATUS _samr_create_dom_group(pipes_struct *p, SAMR_Q_CREATE_DOM_GROUP *q_u, SAMR_R_CREATE_DOM_GROUP *r_u);
NTSTATUS _samr_create_dom_alias(pipes_struct *p, SAMR_Q_CREATE_DOM_ALIAS *q_u, SAMR_R_CREATE_DOM_ALIAS *r_u);
NTSTATUS _samr_query_groupinfo(pipes_struct *p, SAMR_Q_QUERY_GROUPINFO *q_u, SAMR_R_QUERY_GROUPINFO *r_u);
NTSTATUS _samr_set_groupinfo(pipes_struct *p, SAMR_Q_SET_GROUPINFO *q_u, SAMR_R_SET_GROUPINFO *r_u);
NTSTATUS _samr_set_aliasinfo(pipes_struct *p, SAMR_Q_SET_ALIASINFO *q_u, SAMR_R_SET_ALIASINFO *r_u);
NTSTATUS _samr_get_dom_pwinfo(pipes_struct *p, SAMR_Q_GET_DOM_PWINFO *q_u, SAMR_R_GET_DOM_PWINFO *r_u);
NTSTATUS _samr_open_group(pipes_struct *p, SAMR_Q_OPEN_GROUP *q_u, SAMR_R_OPEN_GROUP *r_u);
NTSTATUS _samr_remove_sid_foreign_domain(pipes_struct *p, 
                                          SAMR_Q_REMOVE_SID_FOREIGN_DOMAIN *q_u, 
                                          SAMR_R_REMOVE_SID_FOREIGN_DOMAIN *r_u);
NTSTATUS _samr_unknown_2e(pipes_struct *p, SAMR_Q_UNKNOWN_2E *q_u, SAMR_R_UNKNOWN_2E *r_u);
NTSTATUS _samr_set_dom_info(pipes_struct *p, SAMR_Q_SET_DOMAIN_INFO *q_u, SAMR_R_SET_DOMAIN_INFO *r_u);

/* The following definitions come from rpc_server/srv_samr_util.c  */

void copy_id20_to_sam_passwd(SAM_ACCOUNT *to, SAM_USER_INFO_20 *from);
void copy_id21_to_sam_passwd(SAM_ACCOUNT *to, SAM_USER_INFO_21 *from);
void copy_id23_to_sam_passwd(SAM_ACCOUNT *to, SAM_USER_INFO_23 *from);

/* The following definitions come from rpc_server/srv_spoolss.c  */

void spoolss_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_spoolss_init(void);

/* The following definitions come from rpc_server/srv_spoolss_nt.c  */

WERROR find_printer_in_print_hnd_cache( TALLOC_CTX *ctx, NT_PRINTER_INFO_LEVEL_2 **info2, 
                                        const char *servername, const char *printername );
void invalidate_printer_hnd_cache( char *printername );
WERROR delete_printer_hook( NT_USER_TOKEN *token, const char *sharename );
void receive_printer_mod_msg(int msg_type, pid_t src, void *buf, size_t len);
void do_drv_upgrade_printer(int msg_type, pid_t src, void *buf, size_t len);
void update_monitored_printq_cache( void );
void reset_all_printerdata(int msg_type, pid_t src, void *buf, size_t len);
WERROR _spoolss_open_printer(pipes_struct *p, SPOOL_Q_OPEN_PRINTER *q_u, SPOOL_R_OPEN_PRINTER *r_u);
WERROR _spoolss_open_printer_ex( pipes_struct *p, SPOOL_Q_OPEN_PRINTER_EX *q_u, SPOOL_R_OPEN_PRINTER_EX *r_u);
BOOL convert_devicemode(const char *printername, const DEVICEMODE *devmode,
				NT_DEVICEMODE **pp_nt_devmode);
WERROR _spoolss_closeprinter(pipes_struct *p, SPOOL_Q_CLOSEPRINTER *q_u, SPOOL_R_CLOSEPRINTER *r_u);
WERROR _spoolss_deleteprinter(pipes_struct *p, SPOOL_Q_DELETEPRINTER *q_u, SPOOL_R_DELETEPRINTER *r_u);
WERROR _spoolss_deleteprinterdriver(pipes_struct *p, SPOOL_Q_DELETEPRINTERDRIVER *q_u, SPOOL_R_DELETEPRINTERDRIVER *r_u);
WERROR _spoolss_deleteprinterdriverex(pipes_struct *p, SPOOL_Q_DELETEPRINTERDRIVEREX *q_u, SPOOL_R_DELETEPRINTERDRIVEREX *r_u);
WERROR set_printer_dataex( NT_PRINTER_INFO_LEVEL *printer, const char *key, const char *value, 
                                  uint32 type, uint8 *data, int real_len  );
WERROR _spoolss_getprinterdata(pipes_struct *p, SPOOL_Q_GETPRINTERDATA *q_u, SPOOL_R_GETPRINTERDATA *r_u);
WERROR _spoolss_rffpcnex(pipes_struct *p, SPOOL_Q_RFFPCNEX *q_u, SPOOL_R_RFFPCNEX *r_u);
void spoolss_notify_server_name(int snum, 
				       SPOOL_NOTIFY_INFO_DATA *data, 
				       print_queue_struct *queue,
				       NT_PRINTER_INFO_LEVEL *printer,
				       TALLOC_CTX *mem_ctx) ;
void spoolss_notify_printer_name(int snum, 
					SPOOL_NOTIFY_INFO_DATA *data, 
					print_queue_struct *queue,
					NT_PRINTER_INFO_LEVEL *printer,
					TALLOC_CTX *mem_ctx);
void spoolss_notify_share_name(int snum, 
				      SPOOL_NOTIFY_INFO_DATA *data, 
				      print_queue_struct *queue,
				      NT_PRINTER_INFO_LEVEL *printer,
				      TALLOC_CTX *mem_ctx);
void spoolss_notify_port_name(int snum, 
				     SPOOL_NOTIFY_INFO_DATA *data, 
				     print_queue_struct *queue,
				     NT_PRINTER_INFO_LEVEL *printer,
				     TALLOC_CTX *mem_ctx);
void spoolss_notify_driver_name(int snum, 
				       SPOOL_NOTIFY_INFO_DATA *data,
				       print_queue_struct *queue,
				       NT_PRINTER_INFO_LEVEL *printer,
				       TALLOC_CTX *mem_ctx);
void spoolss_notify_comment(int snum, 
				   SPOOL_NOTIFY_INFO_DATA *data,
				   print_queue_struct *queue,
				   NT_PRINTER_INFO_LEVEL *printer,
				   TALLOC_CTX *mem_ctx);
void spoolss_notify_location(int snum, 
				    SPOOL_NOTIFY_INFO_DATA *data,
				    print_queue_struct *queue,
				    NT_PRINTER_INFO_LEVEL *printer,
				    TALLOC_CTX *mem_ctx);
void spoolss_notify_sepfile(int snum, 
				   SPOOL_NOTIFY_INFO_DATA *data, 
				   print_queue_struct *queue,
				   NT_PRINTER_INFO_LEVEL *printer,
				   TALLOC_CTX *mem_ctx);
void spoolss_notify_print_processor(int snum, 
					   SPOOL_NOTIFY_INFO_DATA *data,
					   print_queue_struct *queue,
					   NT_PRINTER_INFO_LEVEL *printer,
					   TALLOC_CTX *mem_ctx);
void spoolss_notify_parameters(int snum, 
				      SPOOL_NOTIFY_INFO_DATA *data,
				      print_queue_struct *queue,
				      NT_PRINTER_INFO_LEVEL *printer,
				      TALLOC_CTX *mem_ctx);
void spoolss_notify_datatype(int snum, 
				    SPOOL_NOTIFY_INFO_DATA *data,
				    print_queue_struct *queue,
				    NT_PRINTER_INFO_LEVEL *printer,
				    TALLOC_CTX *mem_ctx);
void spoolss_notify_attributes(int snum, 
				      SPOOL_NOTIFY_INFO_DATA *data,
				      print_queue_struct *queue,
				      NT_PRINTER_INFO_LEVEL *printer,
				      TALLOC_CTX *mem_ctx);
void spoolss_notify_cjobs(int snum, 
				 SPOOL_NOTIFY_INFO_DATA *data,
				 print_queue_struct *queue,
				 NT_PRINTER_INFO_LEVEL *printer, 
				 TALLOC_CTX *mem_ctx);
void construct_info_data(SPOOL_NOTIFY_INFO_DATA *info_data, uint16 type, uint16 field, int id);
WERROR _spoolss_rfnpcnex( pipes_struct *p, SPOOL_Q_RFNPCNEX *q_u, SPOOL_R_RFNPCNEX *r_u);
DEVICEMODE *construct_dev_mode(int snum);
WERROR _spoolss_enumprinters( pipes_struct *p, SPOOL_Q_ENUMPRINTERS *q_u, SPOOL_R_ENUMPRINTERS *r_u);
WERROR _spoolss_getprinter(pipes_struct *p, SPOOL_Q_GETPRINTER *q_u, SPOOL_R_GETPRINTER *r_u);
WERROR _spoolss_getprinterdriver2(pipes_struct *p, SPOOL_Q_GETPRINTERDRIVER2 *q_u, SPOOL_R_GETPRINTERDRIVER2 *r_u);
WERROR _spoolss_startpageprinter(pipes_struct *p, SPOOL_Q_STARTPAGEPRINTER *q_u, SPOOL_R_STARTPAGEPRINTER *r_u);
WERROR _spoolss_endpageprinter(pipes_struct *p, SPOOL_Q_ENDPAGEPRINTER *q_u, SPOOL_R_ENDPAGEPRINTER *r_u);
WERROR _spoolss_startdocprinter(pipes_struct *p, SPOOL_Q_STARTDOCPRINTER *q_u, SPOOL_R_STARTDOCPRINTER *r_u);
WERROR _spoolss_enddocprinter(pipes_struct *p, SPOOL_Q_ENDDOCPRINTER *q_u, SPOOL_R_ENDDOCPRINTER *r_u);
WERROR _spoolss_writeprinter(pipes_struct *p, SPOOL_Q_WRITEPRINTER *q_u, SPOOL_R_WRITEPRINTER *r_u);
WERROR _spoolss_abortprinter(pipes_struct *p, SPOOL_Q_ABORTPRINTER *q_u, SPOOL_R_ABORTPRINTER *r_u);
BOOL add_printer_hook(NT_USER_TOKEN *token, NT_PRINTER_INFO_LEVEL *printer);
WERROR _spoolss_setprinter(pipes_struct *p, SPOOL_Q_SETPRINTER *q_u, SPOOL_R_SETPRINTER *r_u);
WERROR _spoolss_fcpn(pipes_struct *p, SPOOL_Q_FCPN *q_u, SPOOL_R_FCPN *r_u);
WERROR _spoolss_addjob(pipes_struct *p, SPOOL_Q_ADDJOB *q_u, SPOOL_R_ADDJOB *r_u);
WERROR _spoolss_enumjobs( pipes_struct *p, SPOOL_Q_ENUMJOBS *q_u, SPOOL_R_ENUMJOBS *r_u);
WERROR _spoolss_schedulejob( pipes_struct *p, SPOOL_Q_SCHEDULEJOB *q_u, SPOOL_R_SCHEDULEJOB *r_u);
WERROR _spoolss_setjob(pipes_struct *p, SPOOL_Q_SETJOB *q_u, SPOOL_R_SETJOB *r_u);
WERROR _spoolss_enumprinterdrivers( pipes_struct *p, SPOOL_Q_ENUMPRINTERDRIVERS *q_u, SPOOL_R_ENUMPRINTERDRIVERS *r_u);
WERROR _spoolss_enumforms(pipes_struct *p, SPOOL_Q_ENUMFORMS *q_u, SPOOL_R_ENUMFORMS *r_u);
WERROR _spoolss_getform(pipes_struct *p, SPOOL_Q_GETFORM *q_u, SPOOL_R_GETFORM *r_u);
WERROR enumports_hook( int *count, char ***lines );
WERROR _spoolss_enumports( pipes_struct *p, SPOOL_Q_ENUMPORTS *q_u, SPOOL_R_ENUMPORTS *r_u);
WERROR _spoolss_addprinterex( pipes_struct *p, SPOOL_Q_ADDPRINTEREX *q_u, SPOOL_R_ADDPRINTEREX *r_u);
WERROR _spoolss_addprinterdriver(pipes_struct *p, SPOOL_Q_ADDPRINTERDRIVER *q_u, SPOOL_R_ADDPRINTERDRIVER *r_u);
WERROR _spoolss_addprinterdriverex(pipes_struct *p, SPOOL_Q_ADDPRINTERDRIVEREX *q_u, SPOOL_R_ADDPRINTERDRIVEREX *r_u);
WERROR _spoolss_getprinterdriverdirectory(pipes_struct *p, SPOOL_Q_GETPRINTERDRIVERDIR *q_u, SPOOL_R_GETPRINTERDRIVERDIR *r_u);
WERROR _spoolss_enumprinterdata(pipes_struct *p, SPOOL_Q_ENUMPRINTERDATA *q_u, SPOOL_R_ENUMPRINTERDATA *r_u);
WERROR _spoolss_setprinterdata( pipes_struct *p, SPOOL_Q_SETPRINTERDATA *q_u, SPOOL_R_SETPRINTERDATA *r_u);
WERROR _spoolss_resetprinter(pipes_struct *p, SPOOL_Q_RESETPRINTER *q_u, SPOOL_R_RESETPRINTER *r_u);
WERROR _spoolss_deleteprinterdata(pipes_struct *p, SPOOL_Q_DELETEPRINTERDATA *q_u, SPOOL_R_DELETEPRINTERDATA *r_u);
WERROR _spoolss_addform( pipes_struct *p, SPOOL_Q_ADDFORM *q_u, SPOOL_R_ADDFORM *r_u);
WERROR _spoolss_deleteform( pipes_struct *p, SPOOL_Q_DELETEFORM *q_u, SPOOL_R_DELETEFORM *r_u);
WERROR _spoolss_setform(pipes_struct *p, SPOOL_Q_SETFORM *q_u, SPOOL_R_SETFORM *r_u);
WERROR _spoolss_enumprintprocessors(pipes_struct *p, SPOOL_Q_ENUMPRINTPROCESSORS *q_u, SPOOL_R_ENUMPRINTPROCESSORS *r_u);
WERROR _spoolss_enumprintprocdatatypes(pipes_struct *p, SPOOL_Q_ENUMPRINTPROCDATATYPES *q_u, SPOOL_R_ENUMPRINTPROCDATATYPES *r_u);
WERROR _spoolss_enumprintmonitors(pipes_struct *p, SPOOL_Q_ENUMPRINTMONITORS *q_u, SPOOL_R_ENUMPRINTMONITORS *r_u);
WERROR _spoolss_getjob( pipes_struct *p, SPOOL_Q_GETJOB *q_u, SPOOL_R_GETJOB *r_u);
WERROR _spoolss_getprinterdataex(pipes_struct *p, SPOOL_Q_GETPRINTERDATAEX *q_u, SPOOL_R_GETPRINTERDATAEX *r_u);
WERROR _spoolss_setprinterdataex(pipes_struct *p, SPOOL_Q_SETPRINTERDATAEX *q_u, SPOOL_R_SETPRINTERDATAEX *r_u);
WERROR _spoolss_deleteprinterdataex(pipes_struct *p, SPOOL_Q_DELETEPRINTERDATAEX *q_u, SPOOL_R_DELETEPRINTERDATAEX *r_u);
WERROR _spoolss_enumprinterkey(pipes_struct *p, SPOOL_Q_ENUMPRINTERKEY *q_u, SPOOL_R_ENUMPRINTERKEY *r_u);
WERROR _spoolss_deleteprinterkey(pipes_struct *p, SPOOL_Q_DELETEPRINTERKEY *q_u, SPOOL_R_DELETEPRINTERKEY *r_u);
WERROR _spoolss_enumprinterdataex(pipes_struct *p, SPOOL_Q_ENUMPRINTERDATAEX *q_u, SPOOL_R_ENUMPRINTERDATAEX *r_u);
WERROR _spoolss_getprintprocessordirectory(pipes_struct *p, SPOOL_Q_GETPRINTPROCESSORDIRECTORY *q_u, SPOOL_R_GETPRINTPROCESSORDIRECTORY *r_u);
WERROR _spoolss_replyopenprinter(pipes_struct *p, SPOOL_Q_REPLYOPENPRINTER *q_u, 
				 SPOOL_R_REPLYOPENPRINTER *r_u);
WERROR _spoolss_replycloseprinter(pipes_struct *p, SPOOL_Q_REPLYCLOSEPRINTER *q_u, 
				  SPOOL_R_REPLYCLOSEPRINTER *r_u);

/* The following definitions come from rpc_server/srv_srvsvc.c  */

void srvsvc_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_srv_init(void);

/* The following definitions come from rpc_server/srv_srvsvc_nt.c  */

BOOL share_info_db_init(void);
void map_generic_share_sd_bits(SEC_DESC *psd);
BOOL share_access_check(connection_struct *conn, int snum, user_struct *vuser, uint32 desired_access);
WERROR _srv_net_srv_get_info(pipes_struct *p, SRV_Q_NET_SRV_GET_INFO *q_u, SRV_R_NET_SRV_GET_INFO *r_u);
WERROR _srv_net_srv_set_info(pipes_struct *p, SRV_Q_NET_SRV_SET_INFO *q_u, SRV_R_NET_SRV_SET_INFO *r_u);
WERROR _srv_net_file_enum(pipes_struct *p, SRV_Q_NET_FILE_ENUM *q_u, SRV_R_NET_FILE_ENUM *r_u);
WERROR _srv_net_conn_enum(pipes_struct *p, SRV_Q_NET_CONN_ENUM *q_u, SRV_R_NET_CONN_ENUM *r_u);
WERROR _srv_net_sess_enum(pipes_struct *p, SRV_Q_NET_SESS_ENUM *q_u, SRV_R_NET_SESS_ENUM *r_u);
WERROR _srv_net_sess_del(pipes_struct *p, SRV_Q_NET_SESS_DEL *q_u, SRV_R_NET_SESS_DEL *r_u);
WERROR _srv_net_share_enum_all(pipes_struct *p, SRV_Q_NET_SHARE_ENUM *q_u, SRV_R_NET_SHARE_ENUM *r_u);
WERROR _srv_net_share_enum(pipes_struct *p, SRV_Q_NET_SHARE_ENUM *q_u, SRV_R_NET_SHARE_ENUM *r_u);
WERROR _srv_net_share_get_info(pipes_struct *p, SRV_Q_NET_SHARE_GET_INFO *q_u, SRV_R_NET_SHARE_GET_INFO *r_u);
char *valid_share_pathname(char *dos_pathname);
WERROR _srv_net_share_set_info(pipes_struct *p, SRV_Q_NET_SHARE_SET_INFO *q_u, SRV_R_NET_SHARE_SET_INFO *r_u);
WERROR _srv_net_share_add(pipes_struct *p, SRV_Q_NET_SHARE_ADD *q_u, SRV_R_NET_SHARE_ADD *r_u);
WERROR _srv_net_share_del(pipes_struct *p, SRV_Q_NET_SHARE_DEL *q_u, SRV_R_NET_SHARE_DEL *r_u);
WERROR _srv_net_share_del_sticky(pipes_struct *p, SRV_Q_NET_SHARE_DEL *q_u, SRV_R_NET_SHARE_DEL *r_u);
WERROR _srv_net_remote_tod(pipes_struct *p, SRV_Q_NET_REMOTE_TOD *q_u, SRV_R_NET_REMOTE_TOD *r_u);
WERROR _srv_net_file_query_secdesc(pipes_struct *p, SRV_Q_NET_FILE_QUERY_SECDESC *q_u,
			SRV_R_NET_FILE_QUERY_SECDESC *r_u);
WERROR _srv_net_file_set_secdesc(pipes_struct *p, SRV_Q_NET_FILE_SET_SECDESC *q_u,
									SRV_R_NET_FILE_SET_SECDESC *r_u);
WERROR _srv_net_disk_enum(pipes_struct *p, SRV_Q_NET_DISK_ENUM *q_u, SRV_R_NET_DISK_ENUM *r_u);
WERROR _srv_net_name_validate(pipes_struct *p, SRV_Q_NET_NAME_VALIDATE *q_u, SRV_R_NET_NAME_VALIDATE *r_u);

/* The following definitions come from rpc_server/srv_svcctl.c  */

void svcctl_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_svcctl_init(void);

/* The following definitions come from rpc_server/srv_svcctl_nt.c  */

WERROR _svcctl_open_scmanager(pipes_struct *p, SVCCTL_Q_OPEN_SCMANAGER *q_u, SVCCTL_R_OPEN_SCMANAGER *r_u);
WERROR _svcctl_open_service(pipes_struct *p, SVCCTL_Q_OPEN_SERVICE *q_u, SVCCTL_R_OPEN_SERVICE *r_u);
WERROR _svcctl_close_service(pipes_struct *p, SVCCTL_Q_CLOSE_SERVICE *q_u, SVCCTL_R_CLOSE_SERVICE *r_u);
WERROR _svcctl_get_display_name(pipes_struct *p, SVCCTL_Q_GET_DISPLAY_NAME *q_u, SVCCTL_R_GET_DISPLAY_NAME *r_u);
WERROR _svcctl_query_status(pipes_struct *p, SVCCTL_Q_QUERY_STATUS *q_u, SVCCTL_R_QUERY_STATUS *r_u);
WERROR _svcctl_enum_services_status(pipes_struct *p, SVCCTL_Q_ENUM_SERVICES_STATUS *q_u, SVCCTL_R_ENUM_SERVICES_STATUS *r_u);
WERROR _svcctl_start_service(pipes_struct *p, SVCCTL_Q_START_SERVICE *q_u, SVCCTL_R_START_SERVICE *r_u);
WERROR _svcctl_control_service(pipes_struct *p, SVCCTL_Q_CONTROL_SERVICE *q_u, SVCCTL_R_CONTROL_SERVICE *r_u);
WERROR _svcctl_enum_dependent_services( pipes_struct *p, SVCCTL_Q_ENUM_DEPENDENT_SERVICES *q_u, SVCCTL_R_ENUM_DEPENDENT_SERVICES *r_u );
WERROR _svcctl_query_service_status_ex( pipes_struct *p, SVCCTL_Q_QUERY_SERVICE_STATUSEX *q_u, SVCCTL_R_QUERY_SERVICE_STATUSEX *r_u );
WERROR _svcctl_query_service_config( pipes_struct *p, SVCCTL_Q_QUERY_SERVICE_CONFIG *q_u, SVCCTL_R_QUERY_SERVICE_CONFIG *r_u );
WERROR _svcctl_query_service_config2( pipes_struct *p, SVCCTL_Q_QUERY_SERVICE_CONFIG2 *q_u, SVCCTL_R_QUERY_SERVICE_CONFIG2 *r_u );

/* The following definitions come from rpc_server/srv_util.c  */

NTSTATUS nt_token_to_group_list(TALLOC_CTX *mem_ctx, const DOM_SID *domain_sid, 
				const NT_USER_TOKEN *nt_token,
				int *numgroups, DOM_GID **pgids) ;

/* The following definitions come from rpc_server/srv_wkssvc.c  */

void wkssvc_get_pipe_fns( struct api_struct **fns, int *n_fns );
NTSTATUS rpc_wks_init(void);

/* The following definitions come from rpc_server/srv_wkssvc_nt.c  */

NTSTATUS _wks_query_info(pipes_struct *p, WKS_Q_QUERY_INFO *q_u, WKS_R_QUERY_INFO *r_u);

/* The following definitions come from rpcclient/cmd_dfs.c  */


/* The following definitions come from rpcclient/cmd_ds.c  */


/* The following definitions come from rpcclient/cmd_echo.c  */


/* The following definitions come from rpcclient/cmd_lsarpc.c  */


/* The following definitions come from rpcclient/cmd_netlogon.c  */


/* The following definitions come from rpcclient/cmd_reg.c  */


/* The following definitions come from rpcclient/cmd_samr.c  */


/* The following definitions come from rpcclient/cmd_shutdown.c  */


/* The following definitions come from rpcclient/cmd_spoolss.c  */

void set_drv_info_3_env (DRIVER_INFO_3 *info, const char *arch);

/* The following definitions come from rpcclient/cmd_srvsvc.c  */


/* The following definitions come from rpcclient/display_sec.c  */

char *get_sec_mask_str(uint32 type);
void display_sec_access(SEC_ACCESS *info);
void display_sec_ace(SEC_ACE *ace);
void display_sec_acl(SEC_ACL *sec_acl);
void display_sec_desc(SEC_DESC *sec);

/* The following definitions come from rpcclient/rpcclient.c  */


/* The following definitions come from sam/idmap.c  */

NTSTATUS smb_register_idmap(int version, const char *name, struct idmap_methods *methods);
BOOL idmap_init(const char **remote_backend);
void idmap_set_proxyonly(void);
BOOL idmap_proxyonly(void);
NTSTATUS idmap_set_mapping(const DOM_SID *sid, unid_t id, int id_type);
NTSTATUS idmap_get_id_from_sid(unid_t *id, int *id_type, const DOM_SID *sid);
NTSTATUS idmap_get_sid_from_id(DOM_SID *sid, unid_t id, int id_type);
NTSTATUS idmap_allocate_id(unid_t *id, int id_type);
NTSTATUS idmap_allocate_rid(uint32 *rid, int type);
NTSTATUS idmap_close(void);
void idmap_status(void);

/* The following definitions come from sam/idmap_ldap.c  */

NTSTATUS idmap_ldap_init(void);

/* The following definitions come from sam/idmap_tdb.c  */

TDB_CONTEXT *idmap_tdb_handle( void );
NTSTATUS idmap_tdb_init(void);

/* The following definitions come from sam/idmap_util.c  */

uint32 idmap_get_free_rid_base(void);
BOOL idmap_check_ugid_is_in_free_range(uint32 id);
BOOL idmap_check_rid_is_in_free_range(uint32 rid);
BOOL idmap_check_sid_is_in_free_range(const DOM_SID *sid);
NTSTATUS idmap_uid_to_sid(DOM_SID *sid, uid_t uid, int flags);
NTSTATUS idmap_gid_to_sid(DOM_SID *sid, gid_t gid, int flags);
NTSTATUS idmap_sid_to_uid(const DOM_SID *sid, uid_t *uid, uint32 flags);
NTSTATUS idmap_sid_to_gid(const DOM_SID *sid, gid_t *gid, uint32 flags);
BOOL use_nss_info(const char *info);

/* The following definitions come from services/services_db.c  */

int num_external_services(void);
WERROR enum_external_services(TALLOC_CTX *tcx,ENUM_SERVICES_STATUS **svc_ptr, int existing_services,int *added) ;
int num_internal_services(void);
BOOL get_service_info(TDB_CONTEXT *stdb,char *service_name, Service_info *si) ;
BOOL store_service_info(TDB_CONTEXT *stdb,char *service_name, Service_info *si) ;
BOOL init_svcctl_db(void);

/* The following definitions come from services/svc_rcinit.c  */

BOOL get_LSB_data(char *fname,Service_info *si );

/* The following definitions come from services/svc_spoolss.c  */


/* The following definitions come from smbd/aio.c  */

BOOL aio_finished(void);
void initialize_async_io_handler(void);
BOOL schedule_aio_read_and_X(connection_struct *conn,
			     char *inbuf, char *outbuf,
			     int length, int len_outbuf,
			     files_struct *fsp, SMB_OFF_T startpos,
			     size_t smb_maxcnt);
BOOL schedule_aio_write_and_X(connection_struct *conn,
				char *inbuf, char *outbuf,
				int length, int len_outbuf,
				files_struct *fsp, char *data,
				SMB_OFF_T startpos,
				size_t numtowrite);
int process_aio_queue(void);
BOOL wait_for_aio_completion(files_struct *fsp);
void cancel_aio_by_fsp(files_struct *fsp);
BOOL aio_inbuffer_in_use(char *inbuf);
BOOL aio_finished(void);
void initialize_async_io_handler(void);
int process_aio_queue(void);
BOOL schedule_aio_read_and_X(connection_struct *conn,
			     char *inbuf, char *outbuf,
			     int length, int len_outbuf,
			     files_struct *fsp, SMB_OFF_T startpos,
			     size_t smb_maxcnt);
BOOL schedule_aio_write_and_X(connection_struct *conn,
                                char *inbuf, char *outbuf,
                                int length, int len_outbuf,
                                files_struct *fsp, char *data,
                                SMB_OFF_T startpos,
                                size_t numtowrite);
void cancel_aio_by_fsp(files_struct *fsp);
BOOL wait_for_aio_completion(files_struct *fsp);
BOOL aio_inbuffer_in_use(char *ptr);

/* The following definitions come from smbd/blocking.c  */

BOOL push_blocking_lock_request( char *inbuf, int length, int lock_timeout,
		int lock_num, uint16 lock_pid, SMB_BIG_UINT offset, SMB_BIG_UINT count);
void remove_pending_lock_requests_by_fid(files_struct *fsp);
void remove_pending_lock_requests_by_mid(int mid);
unsigned blocking_locks_timeout(unsigned default_timeout);
void process_blocking_lock_queue(time_t t);

/* The following definitions come from smbd/change_trust_pw.c  */

NTSTATUS change_trust_account_password( const char *domain, const char *remote_machine);

/* The following definitions come from smbd/chgpasswd.c  */

BOOL chgpasswd(const char *name, const struct passwd *pass, 
	       const char *oldpass, const char *newpass, BOOL as_root);
BOOL chgpasswd(const char *name, const struct passwd *pass, 
	       const char *oldpass, const char *newpass, BOOL as_root);
BOOL check_lanman_password(char *user, uchar * pass1,
			   uchar * pass2, SAM_ACCOUNT **hnd);
BOOL change_lanman_password(SAM_ACCOUNT *sampass, uchar *pass2);
NTSTATUS pass_oem_change(char *user,
			 uchar password_encrypted_with_lm_hash[516], 
			 const uchar old_lm_hash_encrypted[16],
			 uchar password_encrypted_with_nt_hash[516], 
			 const uchar old_nt_hash_encrypted[16]);
NTSTATUS change_oem_password(SAM_ACCOUNT *hnd, char *old_passwd, char *new_passwd, BOOL as_root);

/* The following definitions come from smbd/close.c  */

int close_file(files_struct *fsp, BOOL normal_close);

/* The following definitions come from smbd/conn.c  */

void conn_init(void);
int conn_num_open(void);
BOOL conn_snum_used(int snum);
connection_struct *conn_find(unsigned cnum);
connection_struct *conn_new(void);
void conn_close_all(void);
BOOL conn_idle_all(time_t t, int deadtime);
void conn_clear_vuid_cache(uint16 vuid);
void conn_free_internal(connection_struct *conn);
void conn_free(connection_struct *conn);
void msg_force_tdis(int msg_type, pid_t pid, void *buf, size_t len);

/* The following definitions come from smbd/connection.c  */

TDB_CONTEXT *conn_tdb_ctx(void);
BOOL yield_connection(connection_struct *conn, const char *name);
BOOL claim_connection(connection_struct *conn, const char *name,int max_connections,BOOL Clear, uint32 msg_flags);
BOOL register_message_flags(BOOL doreg, uint32 msg_flags);

/* The following definitions come from smbd/dfree.c  */

SMB_BIG_UINT sys_disk_free(const char *path, BOOL small_query, 
                           SMB_BIG_UINT *bsize,SMB_BIG_UINT *dfree,SMB_BIG_UINT *dsize);

/* The following definitions come from smbd/dir.c  */

void make_dir_struct(char *buf, const char *mask, const char *fname,SMB_OFF_T size,uint32 mode,time_t date, BOOL uc);
void init_dptrs(void);
char *dptr_path(int key);
char *dptr_wcard(int key);
uint16 dptr_attr(int key);
void dptr_close(int *key);
void dptr_closecnum(connection_struct *conn);
void dptr_idlecnum(connection_struct *conn);
void dptr_closepath(char *path,uint16 spid);
int dptr_create(connection_struct *conn, pstring path, BOOL old_handle, BOOL expect_close,uint16 spid,
		const char *wcard, uint32 attr);
int dptr_CloseDir(struct dptr_struct *dptr);
void dptr_SeekDir(struct dptr_struct *dptr, long offset);
long dptr_TellDir(struct dptr_struct *dptr);
const char *dptr_ReadDirName(struct dptr_struct *dptr, long *poffset, SMB_STRUCT_STAT *pst);
BOOL dptr_SearchDir(struct dptr_struct *dptr, const char *name, long *poffset, SMB_STRUCT_STAT *pst);
BOOL dptr_fill(char *buf1,unsigned int key);
struct dptr_struct *dptr_fetch(char *buf,int *num);
struct dptr_struct *dptr_fetch_lanman2(int dptr_num);
BOOL dir_check_ftype(connection_struct *conn, uint32 mode, uint32 dirtype);
BOOL get_dir_entry(connection_struct *conn,char *mask,uint32 dirtype, pstring fname,
                   SMB_OFF_T *size,uint32 *mode,time_t *date,BOOL check_descend);
BOOL is_visible_file(connection_struct *conn, const char *dir_path, const char *name, SMB_STRUCT_STAT *pst, BOOL use_veto);
struct smb_Dir *OpenDir(connection_struct *conn, const char *name, const char *mask, uint32 attr);
int CloseDir(struct smb_Dir *dirp);
const char *ReadDirName(struct smb_Dir *dirp, long *poffset);
void RewindDir(struct smb_Dir *dirp, long *poffset);
void SeekDir(struct smb_Dir *dirp, long offset);
long TellDir(struct smb_Dir *dirp);
BOOL SearchDir(struct smb_Dir *dirp, const char *name, long *poffset);

/* The following definitions come from smbd/dosmode.c  */

mode_t unix_mode(connection_struct *conn, int dosmode, const char *fname, BOOL creating_file);
uint32 dos_mode_from_sbuf(connection_struct *conn, const char *path, SMB_STRUCT_STAT *sbuf);
uint32 dos_mode(connection_struct *conn, const char *path,SMB_STRUCT_STAT *sbuf);
int file_set_dosmode(connection_struct *conn, const char *fname, uint32 dosmode, SMB_STRUCT_STAT *st, BOOL creating_file);
int file_utime(connection_struct *conn, const char *fname, struct utimbuf *times);
BOOL set_filetime(connection_struct *conn, const char *fname, time_t mtime);

/* The following definitions come from smbd/error.c  */

void set_saved_error_triple(int eclass, int ecode, NTSTATUS status);
BOOL get_saved_error_triple(int *peclass, int *pecode, NTSTATUS *pstatus);
int cached_error_packet(char *outbuf,files_struct *fsp,int line,const char *file);
int unix_error_packet(char *outbuf,int def_class,uint32 def_code, NTSTATUS def_status, int line, const char *file);
int error_packet(char *outbuf, uint8 eclass, uint32 ecode, NTSTATUS ntstatus, int line, const char *file);

/* The following definitions come from smbd/fake_file.c  */

enum FAKE_FILE_TYPE is_fake_file(const char *fname);
files_struct *open_fake_file(connection_struct *conn,
				enum FAKE_FILE_TYPE fake_file_type,
				const char *fname,
				uint32 access_mask);
void destroy_fake_file_handle(FAKE_FILE_HANDLE **fh);

/* The following definitions come from smbd/fileio.c  */

ssize_t read_file(files_struct *fsp,char *data,SMB_OFF_T pos,size_t n);
ssize_t write_file(files_struct *fsp, const char *data, SMB_OFF_T pos, size_t n);
void delete_write_cache(files_struct *fsp);
void set_filelen_write_cache(files_struct *fsp, SMB_OFF_T file_size);
ssize_t flush_write_cache(files_struct *fsp, enum flush_reason_enum reason);
void sync_file(connection_struct *conn, files_struct *fsp);
int fsp_stat(files_struct *fsp, SMB_STRUCT_STAT *pst);

/* The following definitions come from smbd/filename.c  */

BOOL unix_convert(pstring name,connection_struct *conn,char *saved_last_component, 
                  BOOL *bad_path, SMB_STRUCT_STAT *pst);
BOOL check_name(const pstring name,connection_struct *conn);

/* The following definitions come from smbd/files.c  */

files_struct *file_new(connection_struct *conn);
void file_close_conn(connection_struct *conn);
void file_close_pid(uint16 smbpid);
void file_init(void);
void file_close_user(int vuid);
void file_dump_open_table(void);
files_struct *file_find_fd(int fd);
files_struct *file_find_dif(SMB_DEV_T dev, SMB_INO_T inode, unsigned long file_id);
files_struct *file_find_fsp(files_struct *orig_fsp);
files_struct *file_find_di_first(SMB_DEV_T dev, SMB_INO_T inode);
files_struct *file_find_di_next(files_struct *start_fsp);
files_struct *file_find_print(void);
void fsp_set_pending_modtime(files_struct *tfsp, time_t pmod);
void file_sync_all(connection_struct *conn);
void file_free(files_struct *fsp);
files_struct *file_fsp(char *buf, int where);
void file_chain_reset(void);
void file_chain_save(void);
void file_chain_restore(void);
files_struct *dup_file_fsp(files_struct *fsp,
				uint32 access_mask,
				uint32 share_access,
				uint32 create_options);

/* The following definitions come from smbd/ipc.c  */

void send_trans_reply(char *outbuf,
				char *rparam, int rparam_len,
				char *rdata, int rdata_len,
				BOOL buffer_too_large);
int reply_trans(connection_struct *conn, char *inbuf,char *outbuf, int size, int bufsize);

/* The following definitions come from smbd/lanman.c  */

int api_reply(connection_struct *conn,uint16 vuid,char *outbuf,char *data,char *params,
		     int tdscnt,int tpscnt,int mdrcnt,int mprcnt);

/* The following definitions come from smbd/mangle.c  */

void mangle_reset_cache(void);
void mangle_change_to_posix(void);
BOOL mangle_is_mangled(const char *s, int snum);
BOOL mangle_is_8_3(const char *fname, BOOL check_case, int snum);
BOOL mangle_is_8_3_wildcards(const char *fname, BOOL check_case, int snum);
BOOL mangle_check_cache(char *s, size_t maxlen, int snum);
void mangle_map(pstring OutName, BOOL need83, BOOL cache83, int snum);

/* The following definitions come from smbd/mangle_hash.c  */

struct mangle_fns *mangle_hash_init(void);

/* The following definitions come from smbd/mangle_hash2.c  */

struct mangle_fns *mangle_hash2_init(void);
struct mangle_fns *posix_mangle_init(void);

/* The following definitions come from smbd/mangle_map.c  */

void mangle_map_filename(fstring fname, int snum);

/* The following definitions come from smbd/message.c  */

int reply_sends(connection_struct *conn,
		char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_sendstrt(connection_struct *conn,
		   char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_sendtxt(connection_struct *conn,
		  char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_sendend(connection_struct *conn,
		  char *inbuf,char *outbuf, int dum_size, int dum_buffsize);

/* The following definitions come from smbd/msdfs.c  */

BOOL is_msdfs_link(TALLOC_CTX *ctx, connection_struct *conn, char *path,
		   struct referral **reflistp, int *refcnt,
		   SMB_STRUCT_STAT *sbufp);
BOOL dfs_redirect( pstring pathname, connection_struct *conn, BOOL search_wcard_flag );
BOOL get_referred_path(TALLOC_CTX *ctx, char *pathname, struct junction_map *jucn,
		       int *consumedcntp, BOOL *self_referralp);
int setup_dfs_referral(connection_struct *orig_conn, char *pathname, int max_referral_level, char **ppdata);
BOOL create_junction(char *pathname, struct junction_map *jucn);
BOOL create_msdfs_link(struct junction_map *jucn, BOOL exists);
BOOL remove_msdfs_link(struct junction_map *jucn);
int enum_msdfs_links(TALLOC_CTX *ctx, struct junction_map *jucn, int jn_max);

/* The following definitions come from smbd/negprot.c  */

int reply_negprot(connection_struct *conn, 
		  char *inbuf,char *outbuf, int dum_size, 
		  int dum_buffsize);

/* The following definitions come from smbd/notify.c  */

void remove_pending_change_notify_requests_by_fid(files_struct *fsp);
void remove_pending_change_notify_requests_by_mid(int mid);
void remove_pending_change_notify_requests_by_filename(files_struct *fsp);
int change_notify_timeout(void);
BOOL process_pending_change_notify_queue(time_t t);
BOOL change_notify_set(char *inbuf, files_struct *fsp, connection_struct *conn, uint32 flags);
BOOL init_change_notify(void);

/* The following definitions come from smbd/notify_hash.c  */

struct cnotify_fns *hash_notify_init(void) ;

/* The following definitions come from smbd/notify_kernel.c  */

struct cnotify_fns *kernel_notify_init(void) ;

/* The following definitions come from smbd/ntquotas.c  */

int vfs_get_ntquota(files_struct *fsp, enum SMB_QUOTA_TYPE qtype, DOM_SID *psid, SMB_NTQUOTA_STRUCT *qt);
int vfs_set_ntquota(files_struct *fsp, enum SMB_QUOTA_TYPE qtype, DOM_SID *psid, SMB_NTQUOTA_STRUCT *qt);
int vfs_get_user_ntquota_list(files_struct *fsp, SMB_NTQUOTA_LIST **qt_list);
void *init_quota_handle(TALLOC_CTX *mem_ctx);
void destroy_quota_handle(void **pqt_handle);

/* The following definitions come from smbd/nttrans.c  */

BOOL is_ntfs_stream_name(const char *fname);
int reply_ntcreate_and_X_quota(connection_struct *conn,
				char *inbuf,
				char *outbuf,
				int length,
				int bufsize,
				enum FAKE_FILE_TYPE fake_file_type,
				const char *fname);
int reply_ntcreate_and_X(connection_struct *conn,
			 char *inbuf,char *outbuf,int length,int bufsize);
int reply_ntcancel(connection_struct *conn,
		   char *inbuf,char *outbuf,int length,int bufsize);
int reply_ntrename(connection_struct *conn,
		   char *inbuf,char *outbuf,int length,int bufsize);
int reply_nttranss(connection_struct *conn,
		   char *inbuf,char *outbuf,int length,int bufsize);
int reply_nttrans(connection_struct *conn,
			char *inbuf,char *outbuf,int length,int bufsize);

/* The following definitions come from smbd/open.c  */

int fd_close(struct connection_struct *conn,
		files_struct *fsp);
void change_owner_to_parent(connection_struct *conn,
				files_struct *fsp,
				const char *fname,
				SMB_STRUCT_STAT *psbuf);
BOOL map_open_params_to_ntcreate(const char *fname, int deny_mode, int open_func,
				uint32 *paccess_mask,
				uint32 *pshare_mode,
				uint32 *pcreate_disposition,
				uint32 *pcreate_options);
files_struct *open_file_ntcreate(connection_struct *conn,
				 const char *fname,
				 SMB_STRUCT_STAT *psbuf,
				 uint32 access_mask,		/* access bits (FILE_READ_DATA etc.) */
				 uint32 share_access,		/* share constants (FILE_SHARE_READ etc). */
				 uint32 create_disposition,	/* FILE_OPEN_IF etc. */
				 uint32 create_options,		/* options such as delete on close. */
				 uint32 new_dos_attributes,	/* attributes used for new file. */
				 int oplock_request, 		/* internal Samba oplock codes. */
				 				/* Information (FILE_EXISTS etc.) */
				 int *pinfo);
files_struct *open_file_fchmod(connection_struct *conn, const char *fname,
			       SMB_STRUCT_STAT *psbuf);
int close_file_fchmod(files_struct *fsp);
files_struct *open_directory(connection_struct *conn,
				const char *fname,
				SMB_STRUCT_STAT *psbuf,
				uint32 access_mask,
				uint32 share_access,
				uint32 create_disposition,
				uint32 create_options,
				int *pinfo);
files_struct *open_file_stat(connection_struct *conn, char *fname,
			     SMB_STRUCT_STAT *psbuf);

/* The following definitions come from smbd/oplock.c  */

int32 get_number_of_exclusive_open_oplocks(void);
BOOL oplock_message_waiting(fd_set *fds);
BOOL receive_local_message( char *buffer, int buffer_len, int timeout);
BOOL set_file_oplock(files_struct *fsp, int oplock_type);
void release_file_oplock(files_struct *fsp);
BOOL remove_oplock(files_struct *fsp, BOOL break_to_none);
int setup_oplock_select_set( fd_set *fds);
BOOL process_local_message(char *buffer, int buf_size);
BOOL request_oplock_break(share_mode_entry *share_entry);
BOOL attempt_close_oplocked_file(files_struct *fsp);
void release_level_2_oplocks_on_change(files_struct *fsp);
BOOL send_deferred_open_retry_message(deferred_open_entry *entry);
BOOL init_oplocks(void);

/* The following definitions come from smbd/oplock_irix.c  */

struct kernel_oplocks *irix_init_kernel_oplocks(void) ;

/* The following definitions come from smbd/oplock_linux.c  */

struct kernel_oplocks *linux_init_kernel_oplocks(void) ;

/* The following definitions come from smbd/password.c  */

user_struct *get_valid_user_struct(uint16 vuid);
user_struct *get_partial_auth_user_struct(uint16 vuid);
void invalidate_vuid(uint16 vuid);
void invalidate_all_vuids(void);
int register_vuid(auth_serversupplied_info *server_info, DATA_BLOB session_key, DATA_BLOB response_blob, const char *smb_name);
void add_session_user(const char *user);
BOOL user_ok(const char *user,int snum, gid_t *groups, size_t n_groups);
BOOL authorise_login(int snum, fstring user, DATA_BLOB password, 
		     BOOL *guest);

/* The following definitions come from smbd/pipes.c  */

int reply_open_pipe_and_X(connection_struct *conn,
			  char *inbuf,char *outbuf,int length,int bufsize);
int reply_pipe_write(char *inbuf,char *outbuf,int length,int dum_bufsize);
int reply_pipe_write_and_X(char *inbuf,char *outbuf,int length,int bufsize);
int reply_pipe_read_and_X(char *inbuf,char *outbuf,int length,int bufsize);
int reply_pipe_close(connection_struct *conn, char *inbuf,char *outbuf);

/* The following definitions come from smbd/posix_acls.c  */

SMB_ACL_T free_empty_sys_acl(connection_struct *conn, SMB_ACL_T the_acl);
size_t get_nt_acl(files_struct *fsp, uint32 security_info, SEC_DESC **ppdesc);
BOOL set_nt_acl(files_struct *fsp, uint32 security_info_sent, SEC_DESC *psd);
int get_acl_group_bits( connection_struct *conn, const char *fname, mode_t *mode );
int chmod_acl(connection_struct *conn, const char *name, mode_t mode);
int inherit_access_acl(connection_struct *conn, const char *name, mode_t mode);
int fchmod_acl(files_struct *fsp, int fd, mode_t mode);
BOOL directory_has_default_acl(connection_struct *conn, const char *fname);
BOOL set_unix_posix_default_acl(connection_struct *conn, const char *fname, SMB_STRUCT_STAT *psbuf,
				uint16 num_def_acls, const char *pdata);
BOOL set_unix_posix_acl(connection_struct *conn, files_struct *fsp, const char *fname, uint16 num_acls, const char *pdata);
BOOL can_delete_file_in_directory(connection_struct *conn, const char *fname);
BOOL can_write_to_file(connection_struct *conn, const char *fname, SMB_STRUCT_STAT *psbuf);

/* The following definitions come from smbd/process.c  */

uint16 get_current_mid(void);
BOOL push_oplock_pending_smb_message(char *buf, int msg_len);
void remove_sharing_violation_open_smb_message(uint16 mid);
void schedule_sharing_violation_open_smb_message(uint16 mid);
BOOL open_was_deferred(uint16 mid);
struct pending_message_list *get_open_deferred_message(uint16 mid);
BOOL push_sharing_violation_open_smb_message(struct timeval *ptv, char *private_data, size_t priv_len);
BOOL receive_next_smb(char *inbuf, int bufsize, int timeout);
void respond_to_all_remaining_local_messages(void);
void decrement_smbd_process_count(void);
void process_smb(char *inbuf, char *outbuf);
const char *smb_fn_name(int type);
void add_to_common_flags2(uint32 v);
void remove_from_common_flags2(uint32 v);
void construct_reply_common(char *inbuf,char *outbuf);
int chain_reply(char *inbuf,char *outbuf,int size,int bufsize);
void check_reload(int t);
char *get_InBuffer(void);
void set_InBuffer(char *new_inbuf);
char *get_OutBuffer(void);
void set_OutBuffer(char *new_outbuf);
void free_InBuffer(char *inbuf);
void free_OutBuffer(char *outbuf);
char *NewInBuffer(char **old_inbuf);
char *NewOutBuffer(char **old_outbuf);
void smbd_process(void);

/* The following definitions come from smbd/quotas.c  */

BOOL disk_quotas(const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
BOOL disk_quotas(const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
BOOL disk_quotas(const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
BOOL disk_quotas(const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
BOOL disk_quotas(const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
BOOL disk_quotas(const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
BOOL disk_quotas_vxfs(const pstring name, char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
BOOL disk_quotas(const char *path,SMB_BIG_UINT *bsize,SMB_BIG_UINT *dfree,SMB_BIG_UINT *dsize);
BOOL disk_quotas(const char *path,SMB_BIG_UINT *bsize,SMB_BIG_UINT *dfree,SMB_BIG_UINT *dsize);

/* The following definitions come from smbd/reply.c  */

NTSTATUS check_path_syntax(pstring destname, const pstring srcname);
NTSTATUS check_path_syntax_wcard(pstring destname, const pstring srcname);
NTSTATUS check_path_syntax_posix(pstring destname, const pstring srcname);
size_t srvstr_get_path(char *inbuf, char *dest, const char *src, size_t dest_len, size_t src_len, int flags, NTSTATUS *err, BOOL allow_wcard_names);
int reply_special(char *inbuf,char *outbuf);
int reply_tcon(connection_struct *conn,
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_tcon_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_unknown(char *inbuf,char *outbuf);
int reply_ioctl(connection_struct *conn,
		char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_chkpth(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_getatr(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_setatr(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_dskattr(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_search(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_fclose(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_open(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_open_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_ulogoffX(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_mknew(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_ctemp(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
NTSTATUS can_delete(connection_struct *conn, char *fname, uint32 dirtype, BOOL bad_path, BOOL check_is_at_open);
NTSTATUS unlink_internals(connection_struct *conn, uint32 dirtype, char *name);
int reply_unlink(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, 
		 int dum_buffsize);
void send_file_readbraw(connection_struct *conn, files_struct *fsp, SMB_OFF_T startpos, size_t nread,
		ssize_t mincount, char *outbuf, int out_buffsize);
int reply_readbraw(connection_struct *conn, char *inbuf, char *outbuf, int dum_size, int out_buffsize);
int reply_lockread(connection_struct *conn, char *inbuf,char *outbuf, int length, int dum_buffsiz);
int reply_read(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int send_file_readX(connection_struct *conn, char *inbuf,char *outbuf,int length, int len_outbuf,
		files_struct *fsp, SMB_OFF_T startpos, size_t smb_maxcnt);
int reply_read_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_writebraw(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_writeunlock(connection_struct *conn, char *inbuf,char *outbuf, 
		      int size, int dum_buffsize);
int reply_write(connection_struct *conn, char *inbuf,char *outbuf,int size,int dum_buffsize);
int reply_write_and_X(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_lseek(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_flush(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_exit(connection_struct *conn, 
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_close(connection_struct *conn, char *inbuf,char *outbuf, int size,
                int dum_buffsize);
int reply_writeclose(connection_struct *conn,
		     char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_lock(connection_struct *conn,
	       char *inbuf,char *outbuf, int length, int dum_buffsize);
int reply_unlock(connection_struct *conn, char *inbuf,char *outbuf, int size, 
		 int dum_buffsize);
int reply_tdis(connection_struct *conn, 
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_echo(connection_struct *conn,
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printopen(connection_struct *conn, 
		    char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printclose(connection_struct *conn,
		     char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printqueue(connection_struct *conn,
		     char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_printwrite(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
NTSTATUS mkdir_internal(connection_struct *conn, const pstring directory, BOOL bad_path);
int reply_mkdir(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
BOOL rmdir_internals(connection_struct *conn, char *directory);
int reply_rmdir(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
NTSTATUS rename_internals_fsp(connection_struct *conn, files_struct *fsp, char *newname, uint32 attrs, BOOL replace_if_exists);
NTSTATUS rename_internals(connection_struct *conn, char *name, char *newname, uint32 attrs, BOOL replace_if_exists);
int reply_mv(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, 
	     int dum_buffsize);
BOOL copy_file(char *src,char *dest1,connection_struct *conn, int ofun,
		      int count,BOOL target_is_directory, int *err_ret);
int reply_copy(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_setdir(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
uint16 get_lock_pid( char *data, int data_offset, BOOL large_file_format);
SMB_BIG_UINT get_lock_count( char *data, int data_offset, BOOL large_file_format);
SMB_BIG_UINT get_lock_offset( char *data, int data_offset, BOOL large_file_format, BOOL *err);
int reply_lockingX(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_readbmpx(connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize);
int reply_setattrE(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_writebmpx(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);
int reply_writebs(connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize);
int reply_getattrE(connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize);

/* The following definitions come from smbd/sec_ctx.c  */

int get_current_groups(gid_t gid, int *p_ngroups, gid_t **p_groups);
BOOL initialise_groups(char *user, uid_t uid, gid_t gid);
BOOL push_sec_ctx(void);
void set_sec_ctx(uid_t uid, gid_t gid, int ngroups, gid_t *groups, NT_USER_TOKEN *token);
void set_root_sec_ctx(void);
BOOL pop_sec_ctx(void);
void init_sec_ctx(void);

/* The following definitions come from smbd/server.c  */

int smbd_server_fd(void);
void reload_printers(void);
BOOL reload_services(BOOL test);
void exit_server(const char *reason);

/* The following definitions come from smbd/service.c  */

BOOL set_current_service(connection_struct *conn, uint16 flags, BOOL do_chdir);
int add_home_service(const char *service, const char *username, const char *homedir);
int find_service(fstring service);
connection_struct *make_connection_with_chdir(const char *service_in, DATA_BLOB password, 
				   const char *dev, uint16 vuid, NTSTATUS *status);
connection_struct *make_connection(const char *service_in, DATA_BLOB password, 
				   const char *pdev, uint16 vuid, NTSTATUS *status);
void close_cnum(connection_struct *conn, uint16 vuid);

/* The following definitions come from smbd/session.c  */

BOOL session_init(void);
BOOL session_claim(user_struct *vuser);
void session_yield(user_struct *vuser);
int list_sessions(struct sessionid **session_list);

/* The following definitions come from smbd/sesssetup.c  */

int reply_sesssetup_and_X(connection_struct *conn, char *inbuf,char *outbuf,
			  int length,int bufsize);

/* The following definitions come from smbd/srvstr.c  */

size_t srvstr_push_fn(const char *function, unsigned int line, 
		      const char *base_ptr, void *dest, 
		      const char *src, int dest_len, int flags);

/* The following definitions come from smbd/statcache.c  */

void stat_cache_add( const char *full_orig_name, const char *orig_translated_path, BOOL case_sensitive);
BOOL stat_cache_lookup(connection_struct *conn, pstring name, pstring dirpath, 
		       char **start, SMB_STRUCT_STAT *pst);
u32 fast_string_hash(TDB_DATA *key);
BOOL reset_stat_cache( void );

/* The following definitions come from smbd/trans2.c  */

SMB_BIG_UINT smb_roundup(connection_struct *conn, SMB_BIG_UINT val);
SMB_BIG_UINT get_allocation_size(connection_struct *conn, files_struct *fsp, SMB_STRUCT_STAT *sbuf);
NTSTATUS set_ea(connection_struct *conn, files_struct *fsp, const char *fname, struct ea_list *ea_list);
struct ea_list *read_ea_list_entry(TALLOC_CTX *ctx, const char *pdata, size_t data_size, size_t *pbytes_used);
int set_bad_path_error(int err, BOOL bad_path, char *outbuf, int def_class, uint32 def_code);
NTSTATUS can_set_delete_on_close(files_struct *fsp, BOOL delete_on_close,
				 uint32 dosmode);
NTSTATUS set_delete_on_close(files_struct *fsp, BOOL delete_on_close);
NTSTATUS hardlink_internals(connection_struct *conn, char *oldname, char *newname);
int reply_findclose(connection_struct *conn,
		    char *inbuf,char *outbuf,int length,int bufsize);
int reply_findnclose(connection_struct *conn, 
		     char *inbuf,char *outbuf,int length,int bufsize);
int reply_transs2(connection_struct *conn,
		  char *inbuf,char *outbuf,int length,int bufsize);
int reply_trans2(connection_struct *conn,
		 char *inbuf,char *outbuf,int length,int bufsize);

/* The following definitions come from smbd/uid.c  */

gid_t get_current_user_gid_first(int *piterator);
gid_t get_current_user_gid_next(int *piterator);
BOOL change_to_guest(void);
BOOL change_to_user(connection_struct *conn, uint16 vuid);
BOOL change_to_root_user(void);
BOOL become_authenticated_pipe_user(pipes_struct *p);
BOOL unbecome_authenticated_pipe_user(void);
void become_root(void);
void unbecome_root(void);
BOOL become_user(connection_struct *conn, uint16 vuid);
BOOL unbecome_user(void);

/* The following definitions come from smbd/utmp.c  */

void sys_utmp_claim(const char *username, const char *hostname, 
		    struct in_addr *ipaddr,
		    const char *id_str, int id_num);
void sys_utmp_yield(const char *username, const char *hostname, 
		    struct in_addr *ipaddr,
		    const char *id_str, int id_num);
void sys_utmp_yield(const char *username, const char *hostname, 
		    struct in_addr *ipaddr,
		    const char *id_str, int id_num);
void sys_utmp_claim(const char *username, const char *hostname, 
		    struct in_addr *ipaddr,
		    const char *id_str, int id_num);

/* The following definitions come from smbd/vfs-wrap.c  */

int vfswrap_dummy_connect(vfs_handle_struct *handle, connection_struct *conn, const char *service, const char *user);
void vfswrap_dummy_disconnect(vfs_handle_struct *handle, connection_struct *conn);
SMB_BIG_UINT vfswrap_disk_free(vfs_handle_struct *handle, connection_struct *conn, const char *path, BOOL small_query, SMB_BIG_UINT *bsize, 
			       SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize);
int vfswrap_get_quota(struct vfs_handle_struct *handle, struct connection_struct *conn, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *qt);
int vfswrap_set_quota(struct vfs_handle_struct *handle, struct connection_struct *conn, enum SMB_QUOTA_TYPE qtype, unid_t id, SMB_DISK_QUOTA *qt);
int vfswrap_get_shadow_copy_data(struct vfs_handle_struct *handle, struct files_struct *fsp, SHADOW_COPY_DATA *shadow_copy_data, BOOL labels);
SMB_STRUCT_DIR *vfswrap_opendir(vfs_handle_struct *handle, connection_struct *conn, const char *fname, const char *mask, uint32 attr);
SMB_STRUCT_DIRENT *vfswrap_readdir(vfs_handle_struct *handle, connection_struct *conn, SMB_STRUCT_DIR *dirp);
void vfswrap_seekdir(vfs_handle_struct *handle, connection_struct *conn, SMB_STRUCT_DIR *dirp, long offset);
long vfswrap_telldir(vfs_handle_struct *handle, connection_struct *conn, SMB_STRUCT_DIR *dirp);
void vfswrap_rewinddir(vfs_handle_struct *handle, connection_struct *conn, SMB_STRUCT_DIR *dirp);
int vfswrap_mkdir(vfs_handle_struct *handle, connection_struct *conn, const char *path, mode_t mode);
int vfswrap_rmdir(vfs_handle_struct *handle, connection_struct *conn, const char *path);
int vfswrap_closedir(vfs_handle_struct *handle, connection_struct *conn, SMB_STRUCT_DIR *dirp);
int vfswrap_open(vfs_handle_struct *handle, connection_struct *conn, const char *fname, int flags, mode_t mode);
int vfswrap_close(vfs_handle_struct *handle, files_struct *fsp, int fd);
ssize_t vfswrap_read(vfs_handle_struct *handle, files_struct *fsp, int fd, void *data, size_t n);
ssize_t vfswrap_pread(vfs_handle_struct *handle, files_struct *fsp, int fd, void *data,
			size_t n, SMB_OFF_T offset);
ssize_t vfswrap_write(vfs_handle_struct *handle, files_struct *fsp, int fd, const void *data, size_t n);
ssize_t vfswrap_pwrite(vfs_handle_struct *handle, files_struct *fsp, int fd, const void *data,
			size_t n, SMB_OFF_T offset);
SMB_OFF_T vfswrap_lseek(vfs_handle_struct *handle, files_struct *fsp, int filedes, SMB_OFF_T offset, int whence);
ssize_t vfswrap_sendfile(vfs_handle_struct *handle, int tofd, files_struct *fsp, int fromfd, const DATA_BLOB *hdr,
			SMB_OFF_T offset, size_t n);
int vfswrap_rename(vfs_handle_struct *handle, connection_struct *conn, const char *oldname, const char *newname);
int vfswrap_fsync(vfs_handle_struct *handle, files_struct *fsp, int fd);
int vfswrap_stat(vfs_handle_struct *handle, connection_struct *conn, const char *fname, SMB_STRUCT_STAT *sbuf);
int vfswrap_fstat(vfs_handle_struct *handle, files_struct *fsp, int fd, SMB_STRUCT_STAT *sbuf);
int vfswrap_lstat(vfs_handle_struct *handle, connection_struct *conn, const char *path, SMB_STRUCT_STAT *sbuf);
int vfswrap_unlink(vfs_handle_struct *handle, connection_struct *conn, const char *path);
int vfswrap_chmod(vfs_handle_struct *handle, connection_struct *conn, const char *path, mode_t mode);
int vfswrap_fchmod(vfs_handle_struct *handle, files_struct *fsp, int fd, mode_t mode);
int vfswrap_chown(vfs_handle_struct *handle, connection_struct *conn, const char *path, uid_t uid, gid_t gid);
int vfswrap_fchown(vfs_handle_struct *handle, files_struct *fsp, int fd, uid_t uid, gid_t gid);
int vfswrap_chdir(vfs_handle_struct *handle, connection_struct *conn, const char *path);
char *vfswrap_getwd(vfs_handle_struct *handle, connection_struct *conn, char *path);
int vfswrap_utime(vfs_handle_struct *handle, connection_struct *conn, const char *path, struct utimbuf *times);
int vfswrap_ftruncate(vfs_handle_struct *handle, files_struct *fsp, int fd, SMB_OFF_T len);
BOOL vfswrap_lock(vfs_handle_struct *handle, files_struct *fsp, int fd, int op, SMB_OFF_T offset, SMB_OFF_T count, int type);
int vfswrap_symlink(vfs_handle_struct *handle, connection_struct *conn, const char *oldpath, const char *newpath);
int vfswrap_readlink(vfs_handle_struct *handle, connection_struct *conn, const char *path, char *buf, size_t bufsiz);
int vfswrap_link(vfs_handle_struct *handle, connection_struct *conn, const char *oldpath, const char *newpath);
int vfswrap_mknod(vfs_handle_struct *handle, connection_struct *conn, const char *pathname, mode_t mode, SMB_DEV_T dev);
char *vfswrap_realpath(vfs_handle_struct *handle, connection_struct *conn, const char *path, char *resolved_path);
size_t vfswrap_fget_nt_acl(vfs_handle_struct *handle, files_struct *fsp, int fd, uint32 security_info, SEC_DESC **ppdesc);
size_t vfswrap_get_nt_acl(vfs_handle_struct *handle, files_struct *fsp, const char *name, uint32 security_info, SEC_DESC **ppdesc);
BOOL vfswrap_fset_nt_acl(vfs_handle_struct *handle, files_struct *fsp, int fd, uint32 security_info_sent, SEC_DESC *psd);
BOOL vfswrap_set_nt_acl(vfs_handle_struct *handle, files_struct *fsp, const char *name, uint32 security_info_sent, SEC_DESC *psd);
int vfswrap_chmod_acl(vfs_handle_struct *handle, connection_struct *conn, const char *name, mode_t mode);
int vfswrap_fchmod_acl(vfs_handle_struct *handle, files_struct *fsp, int fd, mode_t mode);
int vfswrap_sys_acl_get_entry(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_T theacl, int entry_id, SMB_ACL_ENTRY_T *entry_p);
int vfswrap_sys_acl_get_tag_type(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p);
int vfswrap_sys_acl_get_permset(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p);
void * vfswrap_sys_acl_get_qualifier(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_ENTRY_T entry_d);
SMB_ACL_T vfswrap_sys_acl_get_file(vfs_handle_struct *handle, connection_struct *conn, const char *path_p, SMB_ACL_TYPE_T type);
SMB_ACL_T vfswrap_sys_acl_get_fd(vfs_handle_struct *handle, files_struct *fsp, int fd);
int vfswrap_sys_acl_clear_perms(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_PERMSET_T permset);
int vfswrap_sys_acl_add_perm(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
char * vfswrap_sys_acl_to_text(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_T theacl, ssize_t *plen);
SMB_ACL_T vfswrap_sys_acl_init(vfs_handle_struct *handle, connection_struct *conn, int count);
int vfswrap_sys_acl_create_entry(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry);
int vfswrap_sys_acl_set_tag_type(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype);
int vfswrap_sys_acl_set_qualifier(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_ENTRY_T entry, void *qual);
int vfswrap_sys_acl_set_permset(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset);
int vfswrap_sys_acl_valid(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_T theacl );
int vfswrap_sys_acl_set_file(vfs_handle_struct *handle, connection_struct *conn, const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl);
int vfswrap_sys_acl_set_fd(vfs_handle_struct *handle, files_struct *fsp, int fd, SMB_ACL_T theacl);
int vfswrap_sys_acl_delete_def_file(vfs_handle_struct *handle, connection_struct *conn, const char *path);
int vfswrap_sys_acl_get_perm(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm);
int vfswrap_sys_acl_free_text(vfs_handle_struct *handle, connection_struct *conn, char *text);
int vfswrap_sys_acl_free_acl(vfs_handle_struct *handle, connection_struct *conn, SMB_ACL_T posix_acl);
int vfswrap_sys_acl_free_qualifier(vfs_handle_struct *handle, connection_struct *conn, void *qualifier, SMB_ACL_TAG_T tagtype);
ssize_t vfswrap_getxattr(struct vfs_handle_struct *handle,struct connection_struct *conn,const char *path, const char *name, void *value, size_t size);
ssize_t vfswrap_lgetxattr(struct vfs_handle_struct *handle,struct connection_struct *conn,const char *path, const char *name, void *value, size_t size);
ssize_t vfswrap_fgetxattr(struct vfs_handle_struct *handle, struct files_struct *fsp,int fd, const char *name, void *value, size_t size);
ssize_t vfswrap_listxattr(struct vfs_handle_struct *handle, struct connection_struct *conn,const char *path, char *list, size_t size);
ssize_t vfswrap_llistxattr(struct vfs_handle_struct *handle, struct connection_struct *conn,const char *path, char *list, size_t size);
ssize_t vfswrap_flistxattr(struct vfs_handle_struct *handle, struct files_struct *fsp,int fd, char *list, size_t size);
int vfswrap_removexattr(struct vfs_handle_struct *handle, struct connection_struct *conn,const char *path, const char *name);
int vfswrap_lremovexattr(struct vfs_handle_struct *handle, struct connection_struct *conn,const char *path, const char *name);
int vfswrap_fremovexattr(struct vfs_handle_struct *handle, struct files_struct *fsp,int fd, const char *name);
int vfswrap_setxattr(struct vfs_handle_struct *handle, struct connection_struct *conn,const char *path, const char *name, const void *value, size_t size, int flags);
int vfswrap_lsetxattr(struct vfs_handle_struct *handle, struct connection_struct *conn,const char *path, const char *name, const void *value, size_t size, int flags);
int vfswrap_fsetxattr(struct vfs_handle_struct *handle, struct files_struct *fsp,int fd, const char *name, const void *value, size_t size, int flags);
int vfswrap_aio_read(struct vfs_handle_struct *handle, struct files_struct *fsp, SMB_STRUCT_AIOCB *aiocb);
int vfswrap_aio_write(struct vfs_handle_struct *handle, struct files_struct *fsp, SMB_STRUCT_AIOCB *aiocb);
ssize_t vfswrap_aio_return(struct vfs_handle_struct *handle, struct files_struct *fsp, SMB_STRUCT_AIOCB *aiocb);
int vfswrap_aio_cancel(struct vfs_handle_struct *handle, struct files_struct *fsp, int fd, SMB_STRUCT_AIOCB *aiocb);
int vfswrap_aio_error(struct vfs_handle_struct *handle, struct files_struct *fsp, SMB_STRUCT_AIOCB *aiocb);
int vfswrap_aio_fsync(struct vfs_handle_struct *handle, struct files_struct *fsp, int op, SMB_STRUCT_AIOCB *aiocb);
int vfswrap_aio_suspend(struct vfs_handle_struct *handle, struct files_struct *fsp, const SMB_STRUCT_AIOCB * const aiocb[], int n, const struct timespec *timeout);

/* The following definitions come from smbd/vfs.c  */

NTSTATUS smb_register_vfs(int version, const char *name, vfs_op_tuple *vfs_op_tuples);
BOOL vfs_init_custom(connection_struct *conn, const char *vfs_object);
BOOL smbd_vfs_init(connection_struct *conn);
BOOL vfs_directory_exist(connection_struct *conn, const char *dname, SMB_STRUCT_STAT *st);
int vfs_MkDir(connection_struct *conn, const char *name, mode_t mode);
BOOL vfs_object_exist(connection_struct *conn,const char *fname,SMB_STRUCT_STAT *sbuf);
BOOL vfs_file_exist(connection_struct *conn, const char *fname,SMB_STRUCT_STAT *sbuf);
ssize_t vfs_read_data(files_struct *fsp, char *buf, size_t byte_count);
ssize_t vfs_pread_data(files_struct *fsp, char *buf,
                size_t byte_count, SMB_OFF_T offset);
ssize_t vfs_write_data(files_struct *fsp,const char *buffer,size_t N);
ssize_t vfs_pwrite_data(files_struct *fsp,const char *buffer,
                size_t N, SMB_OFF_T offset);
int vfs_allocate_file_space(files_struct *fsp, SMB_BIG_UINT len);
int vfs_set_filelen(files_struct *fsp, SMB_OFF_T len);
int vfs_fill_sparse(files_struct *fsp, SMB_OFF_T len);
SMB_OFF_T vfs_transfer_file(files_struct *in, files_struct *out, SMB_OFF_T n);
char *vfs_readdirname(connection_struct *conn, void *p);
int vfs_ChDir(connection_struct *conn, const char *path);
char *vfs_GetWd(connection_struct *conn, char *path);
BOOL canonicalize_path(connection_struct *conn, pstring path);
BOOL reduce_name(connection_struct *conn, const pstring fname);

/* The following definitions come from tdb/spinlock.c  */

int tdb_spinlock(TDB_CONTEXT *tdb, int list, int rw_type);
int tdb_spinunlock(TDB_CONTEXT *tdb, int list, int rw_type);
int tdb_create_rwlocks(int fd, unsigned int hash_size);
int tdb_clear_spinlocks(TDB_CONTEXT *tdb);
int tdb_clear_spinlocks(TDB_CONTEXT *tdb);

/* The following definitions come from tdb/tdb.c  */

void tdb_set_lock_alarm(sig_atomic_t *palarm);
void tdb_dump_all(TDB_CONTEXT *tdb);
int tdb_printfreelist(TDB_CONTEXT *tdb);
enum TDB_ERROR tdb_error(TDB_CONTEXT *tdb);
const char *tdb_errorstr(TDB_CONTEXT *tdb);
TDB_DATA tdb_fetch(TDB_CONTEXT *tdb, TDB_DATA key);
int tdb_exists(TDB_CONTEXT *tdb, TDB_DATA key);
int tdb_traverse(TDB_CONTEXT *tdb, tdb_traverse_func fn, void *private_val);
TDB_DATA tdb_firstkey(TDB_CONTEXT *tdb);
TDB_DATA tdb_nextkey(TDB_CONTEXT *tdb, TDB_DATA oldkey);
int tdb_delete(TDB_CONTEXT *tdb, TDB_DATA key);
int tdb_store(TDB_CONTEXT *tdb, TDB_DATA key, TDB_DATA dbuf, int flag);
int tdb_append(TDB_CONTEXT *tdb, TDB_DATA key, TDB_DATA new_dbuf);
TDB_CONTEXT *tdb_open(const char *name, int hash_size, int tdb_flags,
		      int open_flags, mode_t mode);
TDB_CONTEXT *tdb_open_ex(const char *name, int hash_size, int tdb_flags,
			 int open_flags, mode_t mode,
			 tdb_log_func log_fn,
			 tdb_hash_func hash_fn);
int tdb_close(TDB_CONTEXT *tdb);
int tdb_lockall(TDB_CONTEXT *tdb);
void tdb_unlockall(TDB_CONTEXT *tdb);
int tdb_chainlock(TDB_CONTEXT *tdb, TDB_DATA key);
int tdb_chainunlock(TDB_CONTEXT *tdb, TDB_DATA key);
int tdb_chainlock_read(TDB_CONTEXT *tdb, TDB_DATA key);
int tdb_chainunlock_read(TDB_CONTEXT *tdb, TDB_DATA key);
void tdb_logging_function(TDB_CONTEXT *tdb, void (*fn)(TDB_CONTEXT *, int , const char *, ...));
int tdb_reopen(TDB_CONTEXT *tdb);
int tdb_reopen_all(void);

/* The following definitions come from tdb/tdbback.c  */

char *add_suffix(const char *name, const char *suffix);
int backup_tdb(const char *old_name, const char *new_name);
int verify_tdb(const char *fname, const char *bak_name);

/* The following definitions come from tdb/tdbutil.c  */

TDB_DATA make_tdb_data(const char *dptr, size_t dsize);
TDB_DATA string_tdb_data(const char *string);
int tdb_chainlock_with_timeout( TDB_CONTEXT *tdb, TDB_DATA key, unsigned int timeout);
int tdb_lock_bystring(TDB_CONTEXT *tdb, const char *keyval, unsigned int timeout);
void tdb_unlock_bystring(TDB_CONTEXT *tdb, const char *keyval);
int tdb_read_lock_bystring(TDB_CONTEXT *tdb, const char *keyval, unsigned int timeout);
void tdb_read_unlock_bystring(TDB_CONTEXT *tdb, const char *keyval);
int32 tdb_fetch_int32_byblob(TDB_CONTEXT *tdb, const char *keyval, size_t len);
int32 tdb_fetch_int32(TDB_CONTEXT *tdb, const char *keystr);
int tdb_store_int32_byblob(TDB_CONTEXT *tdb, const char *keystr, size_t len, int32 v);
int tdb_store_int32(TDB_CONTEXT *tdb, const char *keystr, int32 v);
BOOL tdb_fetch_uint32_byblob(TDB_CONTEXT *tdb, const char *keyval, size_t len, uint32 *value);
BOOL tdb_fetch_uint32(TDB_CONTEXT *tdb, const char *keystr, uint32 *value);
BOOL tdb_store_uint32_byblob(TDB_CONTEXT *tdb, const char *keystr, size_t len, uint32 value);
BOOL tdb_store_uint32(TDB_CONTEXT *tdb, const char *keystr, uint32 value);
int tdb_store_bystring(TDB_CONTEXT *tdb, const char *keystr, TDB_DATA data, int flags);
TDB_DATA tdb_fetch_bystring(TDB_CONTEXT *tdb, const char *keystr);
int tdb_delete_bystring(TDB_CONTEXT *tdb, const char *keystr);
int32 tdb_change_int32_atomic(TDB_CONTEXT *tdb, const char *keystr, int32 *oldval, int32 change_val);
BOOL tdb_change_uint32_atomic(TDB_CONTEXT *tdb, const char *keystr, uint32 *oldval, uint32 change_val);
size_t tdb_pack_va(char *buf, int bufsize, const char *fmt, va_list ap);
size_t tdb_pack(char *buf, int bufsize, const char *fmt, ...);
BOOL tdb_pack_append(TALLOC_CTX *mem_ctx, uint8_t **buf, size_t *len,
		     const char *fmt, ...);
int tdb_unpack(char *buf, int bufsize, const char *fmt, ...);
size_t tdb_sid_pack(char* pack_buf, int bufsize, DOM_SID* sid);
size_t tdb_sid_unpack(char* pack_buf, int bufsize, DOM_SID* sid);
size_t tdb_trusted_dom_pass_pack(char* pack_buf, int bufsize, TRUSTED_DOM_PASS* pass);
size_t tdb_trusted_dom_pass_unpack(char* pack_buf, int bufsize, TRUSTED_DOM_PASS* pass);
TDB_CONTEXT *tdb_open_log(const char *name, int hash_size, int tdb_flags,
			  int open_flags, mode_t mode);
int tdb_traverse_delete_fn(TDB_CONTEXT *the_tdb, TDB_DATA key, TDB_DATA dbuf,
                     void *state);
void tdb_search_list_free(TDB_LIST_NODE* node);

/* The following definitions come from torture/denytest.c  */

BOOL torture_denytest1(int dummy);
BOOL torture_denytest2(int dummy);

/* The following definitions come from torture/mangle_test.c  */

BOOL torture_mangle(int dummy);

/* The following definitions come from torture/nbio.c  */

double nbio_total(void);
void nb_alarm(int ignore);
void nbio_shmem(int n);
void nb_setup(struct cli_state *cli);
void nb_unlink(const char *fname);
void nb_createx(const char *fname, 
		unsigned create_options, unsigned create_disposition, int handle);
void nb_writex(int handle, int offset, int size, int ret_size);
void nb_readx(int handle, int offset, int size, int ret_size);
void nb_close(int handle);
void nb_rmdir(const char *fname);
void nb_rename(const char *oldname, const char *newname);
void nb_qpathinfo(const char *fname);
void nb_qfileinfo(int fnum);
void nb_qfsinfo(int level);
void nb_findfirst(const char *mask);
void nb_flush(int fnum);
void nb_deltree(const char *dname);
void nb_cleanup(void);

/* The following definitions come from torture/scanner.c  */

BOOL torture_trans2_scan(int dummy);
BOOL torture_nttrans_scan(int dummy);

/* The following definitions come from torture/torture.c  */

void start_timer(void);
double end_timer(void);
void *shm_setup(int size);
BOOL torture_open_connection(struct cli_state **c);
BOOL torture_cli_session_setup2(struct cli_state *cli, uint16 *new_vuid);
BOOL torture_close_connection(struct cli_state *c);
BOOL torture_ioctl_test(int dummy);
BOOL torture_chkpath_test(int dummy);

/* The following definitions come from torture/utable.c  */

BOOL torture_utable(int dummy);
BOOL torture_casetable(int dummy);

/* The following definitions come from web/cgi.c  */

void cgi_load_variables(void);
const char *cgi_variable(const char *name);
BOOL am_root(void);
char *cgi_user_name(void);
void cgi_setup(const char *rootdir, int auth_required);
const char *cgi_baseurl(void);
const char *cgi_pathinfo(void);
char *cgi_remote_host(void);
char *cgi_remote_addr(void);
BOOL cgi_waspost(void);

/* The following definitions come from web/diagnose.c  */

BOOL winbindd_running(void);
BOOL nmbd_running(void);
BOOL smbd_running(void);

/* The following definitions come from web/neg_lang.c  */

int web_open(const char *fname, int flags, mode_t mode);
void web_set_lang(const char *lang_string);

/* The following definitions come from web/startstop.c  */

void start_smbd(void);
void start_nmbd(void);
void start_winbindd(void);
void stop_smbd(void);
void stop_nmbd(void);
void stop_winbindd(void);
void kill_pid(pid_t pid);

/* The following definitions come from web/statuspage.c  */

void status_page(void);

/* The following definitions come from web/swat.c  */


#endif /*  _PROTO_H_  */
