/*
 * tools/lib/vg_read_with_pv_and_lv.c
 *
 * Copyright (C) 1997 - 2002  Heinz Mauelshagen, Sistina Software
 *
 * March,October,November 1997
 * June,August 1998
 * January,March 1999
 * January 2000
 * January,April 2001
 * February 2002
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    12/06/1998 - seperated memory for PVs, PEs and LVs
 *                 in vg_read_with_pv_and_lv() from pv_read_all_pv cache
 *    20/03/1999 - added major device number correction in case
 *                 of old block device major 
 *    08/02/2000 - use debug_enter()/debug_leave()
 *    08/01/2001 - set up core pointers for snapshots
 *    07/02/2002 - check for NULL entries in pv array
 *
 */

#include <liblvm.h>


int vg_read_with_pv_and_lv ( char *vg_name, vg_t **vg) {
   int l = 0;
   int lv_num = 0;
   int p = 0;
   int ope = 0;
   int npe = 0;
   int ret = 0;
   int size = 0;
   uint pe_index = 0;
   pe_disk_t **pe = NULL;
   lv_t **lv = NULL;
   vg_t *vg_this = NULL;
   pv_t **pv = NULL;

   debug_enter ( "vg_read_with_pv_and_lv -- CALLED\n");

   if ( vg_name == NULL || vg == NULL ||
        vg_check_name ( vg_name) < 0) {
      ret = -LVM_EPARAM;
      goto vg_read_with_pv_and_lv_end;
   }

   *vg = NULL;
   if ( ( ret = vg_read ( vg_name, &vg_this)) < 0 &&
        ret != -LVM_EVG_READ_VG_EXPORTED)
      goto vg_read_with_pv_and_lv_end;

   debug ( "vg_read_with_pv_and_lv -- AFTER vg_read; "
            " vg_this->lv_cur: %lu\n", vg_this->lv_cur);

   if ( vg_this->pv_cur == 0) {
      ret = -LVM_EVG_READ_WITH_PV_AND_LV_PV_CUR;
      goto vg_read_with_pv_and_lv_end;
   }

   if ( ( ret = pv_read_all_pv_of_vg ( vg_name, &pv, FALSE)) < 0)
      goto vg_read_with_pv_and_lv_end;
   debug ( "vg_read_with_pv_and_lv -- AFTER pv_read_all_pv_of_vg\n");
   if ( ( ret = pv_read_all_pe_of_vg ( vg_name, &pe, FALSE)) < 0)
      goto vg_read_with_pv_and_lv_end;
   debug ( "vg_read_with_pv_and_lv -- AFTER pv_read_all_pe_of_vg\n");
   if ( ( ret = lv_read_all_lv ( vg_name, &lv, FALSE)) < 0)
      goto vg_read_with_pv_and_lv_end;

   debug ( "vg_read_with_pv_and_lv -- AFTER lv_read_all_lv;"
            " vg_this->pv_cur: %lu  vg_this->pv_max: %lu  ret: %d\n",
            vg_this->pv_cur, vg_this->pv_max, ret);

   if ( ret == 0) {
      debug (  "vg_read_with_pv_and_lv -- BEFORE for PE\n");
      /* set up PE pointers in PVs */
      for ( p = 0; p < vg_this->pv_cur; p++) {
         if ( pv[p] == NULL) {
            ret = -LVM_EVG_READ_WITH_PV_AND_LV_PV_CUR;
            goto vg_read_with_pv_and_lv_end;
         }
         if ( ( vg_this->pv[p] = malloc ( sizeof ( pv_t))) == NULL) {
            fprintf ( stderr, "malloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            vg_free ( vg_this, FALSE);
            ret = -LVM_EVG_READ_WITH_PV_AND_LV_MALLOC;
            goto vg_read_with_pv_and_lv_end;
         }
         memcpy ( vg_this->pv[p], pv[p], sizeof ( pv_t));
         size = vg_this->pv[p]->pe_total * sizeof ( pe_disk_t);
         if ( ( vg_this->pv[p]->pe = malloc ( size)) == NULL) {
            fprintf ( stderr, "malloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            vg_free ( vg_this, FALSE);
            ret = -LVM_EVG_READ_WITH_PV_AND_LV_MALLOC;
            goto vg_read_with_pv_and_lv_end;
         }
         memcpy ( vg_this->pv[p]->pe, pe[p], size);
      }
      debug (  "vg_read_with_pv_and_lv -- AFTER for PE\n");
      /* build the lv_current_pe structure array */
      debug (  "vg_read_with_pv_and_lv -- BEFORE for LV\n");
      for ( l = 0; l < vg_this->lv_max; l++) vg_this->lv[l] = NULL;
      if ( vg_this->lv_cur > 0) {
         for ( l = 0; l < vg_this->lv_max; l++) {
            lv_num = l + 1;
            if ( lv[l] != NULL) {
               if ( ( vg_this->lv[l] = malloc ( sizeof ( lv_t))) == NULL) {
                  fprintf ( stderr, "malloc error in %s [line %d]\n",
                                    __FILE__, __LINE__);
                  vg_free ( vg_this, FALSE);
                  ret = -LVM_EVG_READ_WITH_PV_AND_LV_MALLOC;
                  goto vg_read_with_pv_and_lv_end;
               }
               memcpy ( vg_this->lv[l], lv[l], sizeof ( lv_t));
               debug ( "vg_read_with_pv_and_lv -- vg_this->lv[%d]->"
                        "lv_allocated_le: %lu\n", l,
                        vg_this->lv[l]->lv_allocated_le);
               if ( ( vg_this->lv[l]->lv_current_pe = malloc (
                         vg_this->lv[l]->lv_allocated_le *
                         sizeof ( pe_t))) == NULL) {
                  fprintf ( stderr, "malloc error in %s [line %d]\n",
                                    __FILE__, __LINE__);
                  vg_free ( vg_this, FALSE);
                  ret = -LVM_EVG_READ_WITH_PV_AND_LV_MALLOC;
                  goto vg_read_with_pv_and_lv_end;
               }
               /* construct the lv_current_pe pointer array */
               p = npe = 0;
               for ( p = 0; p < vg_this->pv_cur &&
                            npe < vg_this->lv[l]->lv_allocated_le; p++) {
                  for ( ope = 0; ope < vg_this->pv[p]->pe_total; ope++) {
                     if ( vg_this->pv[p]->pe[ope].lv_num == lv_num) {
                        pe_index = vg_this->pv[p]->pe[ope].le_num;
                        vg_this->lv[l]->lv_current_pe[pe_index].dev =
                           vg_this->pv[p]->pv_dev;
                        vg_this->lv[l]->lv_current_pe[pe_index].pe =
				get_pe_offset(ope, vg_this->pv[p]);
                        vg_this->lv[l]->lv_current_pe[pe_index].reads = \
                        vg_this->lv[l]->lv_current_pe[pe_index].writes = 0;
                        npe++;
                     }
                  }
               }
               if ( npe != vg_this->lv[l]->lv_allocated_le) {
                  fprintf ( stderr,
                            "%s -- only found %d of %d LEs for LV %s (%d)\n",
                            cmd, npe, vg_this->lv[l]->lv_allocated_le,
                            vg_this->lv[l]->lv_name, l);
                  ret = -LVM_EVG_READ_WITH_PV_AND_LV_LV_ALLOCATED_LE;
                  goto vg_read_with_pv_and_lv_end;
               }
               /* correct LVM_BLK_MAJOR */
               if ( MAJOR ( vg_this->lv[l]->lv_dev) != LVM_BLK_MAJOR) {
                  vg_this->lv[l]->lv_dev = MKDEV(LVM_BLK_MAJOR,
						 MINOR(vg_this->lv[l]->lv_dev));
               }
            } else vg_this->lv[l] = NULL;
         }
      }
   } /* if ( ret == 0) */

   if ( ret == 0) *vg = vg_this;
   else goto vg_read_with_pv_and_lv_end;

   /* Set up core pointers for snapshots */
   vg_setup_pointers_for_snapshots ( *vg);

vg_read_with_pv_and_lv_end:

   debug_leave ( "vg_read_with_pv_and_lv -- LEAVING with ret: %d\n", ret);
   return ret;
}

#ifdef ICP_NAS_2 // Catherine 2003/11/26

int pv_pe_lv_read_for_vg ( char *vg_name, char **pv_name_list,
                        vg_t **out_vg, pv_t ***out_pv, pe_disk_t ***out_pe, lv_t ***out_lv)
{
   int v, cnt, ret = 0;
   int size = 0;
   ulong offset = 0;
   int pv_handle = -1;
   pv_t *pv_tmp = NULL;
   pv_t **pv_start;
   lv_disk_t *lv_this = NULL;
   lv_t **lv_start;
   vg_t *vg_this = NULL;
   static pv_t **pv = NULL;
   static pe_disk_t **pe = NULL;
   static lv_t **lv = NULL;

   debug ( "pv_pe_lv_read_for_vg -- CALLED\n");

   /* init all lists */
   if ( pv != NULL) {
   	for ( v = 0; pv[v] != NULL; v++) free ( pv[v]);
   	free ( pv);
   	pv = NULL;
   }

   if ( pe != NULL) {
   	for ( v = 0; pe[v] != NULL; v++) free ( pe[v]);
   	free ( pe);
   	pe = NULL;
   }
   if ( lv != NULL) {
      free ( lv);
      lv = NULL;
   }

   /* read PV and PE first */
   cnt = 0;
   for ( v = 0; pv_name_list[v] != NULL; v++) {
      if ( ( ret = pv_read ( pv_name_list[v], &pv_tmp, FALSE)) < 0) {
      	 printf ( "pv_pe_lv_read_for_vg -- pv_read failed (%d)\n", ret);
         goto pv_pe_lv_read_for_vg_err_end;
      }

      if ( strcmp( vg_name, pv_tmp->vg_name) == 0) {
      	 pv_start = pv;
      	 if ( ( pv = realloc( pv, ( cnt + 2) * sizeof( pv_t)) ) == NULL) {
      	    printf ( "pv_pe_lv_read_for_vg -- mem alloc failed at line %d\n",
      	             __LINE__);

      	    pv = pv_start;
      	    ret = -LVM_EPVPELV_READ_FROM_VG_MALLOC;
            goto pv_pe_lv_read_for_vg_err_end;
      	 }
      	 pv[ cnt + 1] = NULL;

      	 if ( ( pv[cnt] = calloc(1, sizeof( pv_t))) == NULL) {
      	    printf ( "pv_pe_lv_read_for_vg -- mem alloc failed at line %d\n",
      	             __LINE__);

      	    ret = -LVM_EPVPELV_READ_FROM_VG_MALLOC;
            goto pv_pe_lv_read_for_vg_err_end;
      	 }
      	 memcpy( pv[cnt], pv_tmp, sizeof( pv_t));
         cnt ++;
      }
   }

   debug ( "pv_pe_lv_read_for_vg -- read PEs of %d PVs\n", cnt);

   if ( cnt == 0) goto pv_pe_lv_read_for_vg_end;

   if ( ( pe = calloc ( ( cnt+1), sizeof ( pe_disk_t*))) == NULL)
   {
      printf ( "pv_pe_lv_read_for_vg -- mem alloc failed at line %d\n",
                __LINE__);

      ret = -LVM_EPVPELV_READ_FROM_VG_MALLOC;
      goto pv_pe_lv_read_for_vg_err_end;
   }

   pe[cnt] = NULL;
   for ( v = 0; pv[v] != NULL; v++) {
         if ( ( ret = pv_read_pe ( pv[v], &pe[v])) < 0)
     	    	goto pv_pe_lv_read_for_vg_err_end;
   }

   debug ( "pv_pe_lv_read_for_vg -- read VG from PV \"%s\"\n", pv[0]->pv_name);

   /* now read LVs from the 1st PV */
   if ( pv[0] != NULL && ( ret = vg_read_from_pv ( pv[0]->pv_name, &vg_this)) < 0) {
      printf ( "pv_pe_lv_read_for_vg -- vg_read_from_pv fails, err=%d\n", ret);

      ret = -LVM_EPVPELV_READ_FROM_VG_VGREAD;
      goto pv_pe_lv_read_for_vg_err_end;
   }

   size = vg_this->lv_max * sizeof ( lv_disk_t);

   debug ( "pv_pe_lv_read_for_vg -- AFTER vg_read_from_pv, max LV number = %d",
            vg_this->lv_max);
   if ( ( lv_this = malloc ( size)) == NULL) {
      printf ( "pv_pe_lv_read_for_vg -- mem alloc failed at line %d\n",
               __LINE__);

      ret = -LVM_EPVPELV_READ_FROM_VG_MALLOC;
      goto pv_pe_lv_read_for_vg_err_end;
   }

   offset = LVM_LV_DISK_OFFSET ( pv[0], 0);
   debug ( "pv_pe_lv_read_for_vg -- before read LV from PV \"%s\"", pv[0]->pv_name);
   if ( ( pv_handle = open ( pv[0]->pv_name, O_RDONLY)) == -1)
      ret = -LVM_EPVPELV_READ_FROM_VG_LVOPEN;
   else if ( lseek ( pv_handle, offset, SEEK_SET) != offset)
      ret = -LVM_EPVPELV_READ_FROM_VG_LVLSEEK;
   else if ( read ( pv_handle, lv_this, size) != size)
      ret = -LVM_EPVPELV_READ_FROM_VG_LVREAD;

   debug ( "pv_pe_lv_read_for_vg -- AFTER read LV from PV \"%s\"", pv[0]->pv_name);
   if ( ret < 0) {
      printf ( "pv_pe_lv_read_for_vg -- fails to read LV info\n");
      goto pv_pe_lv_read_for_vg_err_end;
   }
   else {
      for ( v = 0; v < vg_this->lv_max; v++) {
         lv_start = lv;

         if ( ( lv = (lv_t **) realloc( lv, (v + 1) * sizeof( lv_t*))) == NULL) {
      	    printf ( "pv_pe_lv_read_for_vg -- mem alloc failed at line %d\n",
                      __LINE__);

      	    ret = -LVM_EPVPELV_READ_FROM_VG_MALLOC;
      	    lv = lv_start;
      	    goto pv_pe_lv_read_for_vg_err_end;
      	 }

         lv[v] = NULL;
         /* changed check to avoid pointer access to vg->lv[] */
         if ( lv_this[v].lv_name[0] != 0) {
            /* lv_copy_from_disk does its own malloc! */
            lv[v] = lv_copy_from_disk ( &lv_this[v]);
         }
      }
   }
   debug ( "pv_pe_lv_read_for_vg -- AFTER lv_copy_from_disk");

pv_pe_lv_read_for_vg_end:

   debug ( "pv_pe_lv_read_for_vg -- pv_pe_lv_read_for_vg_end LEAVING with ret %d", ret);
   if ( pv_handle != -1) close ( pv_handle);

   *out_vg = vg_this;
   *out_pv = pv;
   *out_pe = pe;
   *out_lv = lv;

   debug ( "pv_pe_lv_read_for_vg -- LEAVING with ret %d", ret);
   return ret;

pv_pe_lv_read_for_vg_err_end:

   debug ( "pv_pe_lv_read_for_vg -- pv_pe_lv_read_for_vg_err_end LEAVING with ret %d", ret);
   if ( pv != NULL) {
      for ( v = 0; pv[v] != NULL; v++) free( pv[v]);
      free ( pv);
      pv = NULL;
   }
   if ( pe != NULL) {
      for ( v = 0; pe[v] != NULL; v++) free( pe[v]);
      free ( pe);
      pe = NULL;
   }
   if ( lv != NULL) {
      free ( lv);
      lv = NULL;
   }
   goto pv_pe_lv_read_for_vg_end;
}
/*
int lv_read_from_pv ( char *vg_name, pv_t *pv, lv_t ***lv)
{
   int pv_handle = -1;
   int ret = 0;
   ulong offset = 0;
   int l;
   pv_t **pv_tmp = NULL;
   static lv_t **lv_this_ptr = NULL;
   lv_t **lv_this;
   vg_t *vg_this = NULL;

   if ( ( ret = vg_read ( vg_name, &vg_this)) < 0 &&
           ret != -LVM_EVG_READ_VG_EXPORTED) {
         ret =  -LVM_ELV_READ_ALL_LV_VG_READ;

   if ( lv_this_ptr != NULL) {
      for ( l = 0; lv_this_ptr[l] != NULL l++) free ( lv_this_ptr[l]);

      free ( lv_this_ptr);
      lv_this_ptr = NULL;
   }

   offset = LVM_LV_DISK_OFFSET ( pv_tmp[0], 0);

   if ( ( pv_handle = open ( pv_tmp[0]->pv_name, O_RDONLY)) == -1)
      ret = -LVM_ELV_READ_ALL_LV_OPEN;
   else if ( lseek ( pv_handle, offset, SEEK_SET) != offset)
      ret = -LVM_ELV_READ_ALL_LV_LSEEK;
   else if ( read ( pv_handle, lv_this, size) != size)
      ret = -LVM_ELV_READ_ALL_LV_READ;
   
   if ( ret >= 0) {
      nl = 0;
      for ( l = 0; l < vg_this->lv_max; l++) {
         lv_this_ptr[l] = NULL;
         // changed check to avoid pointer access to vg->lv[]
         if ( lv_this[l].lv_name[0] != 0) {
            // lv_copy_from_disk does its own malloc!
            lv_this_ptr[l] = lv_copy_from_disk ( &lv_this[l]);
            nl++;
         }
      }

      debug ( "lv_read_all_lv -- l: %d  nl: %d  "
              "vg_this->lv_cur: %lu\n",
              l, nl, vg_this->lv_cur);
      if ( nl != vg_this->lv_cur) ret = -LVM_ELV_READ_ALL_LV_NL;
      else                        ret = 0;
   }
   *lv = lv_this_ptr;
   return ret;
}
*/

int vg_read_with_lv_from_pv ( char *vg_name, vg_t **vg, char **pv_name_list) {
   int l = 0;
   int lv_num = 0;
   int p = 0;
   int ope = 0;
   int npe = 0;
   int ret = 0;
   int size = 0;
   uint pe_index = 0;
   pe_disk_t **pe = NULL;
   lv_t **lv = NULL;
   vg_t *vg_this = NULL;
   pv_t **pv = NULL;

   debug_enter ( "vg_read_with_lv_from_pv -- CALLED\n");

   if ( vg_name == NULL || vg == NULL ||
        vg_check_name ( vg_name) < 0) {
      ret = -LVM_EPARAM;
      goto vg_read_with_lv_from_pv_end;
   }

   *vg = NULL;
   debug (  "vg_read_with_pv_and_lv -- BEFORE pv_pe_lv_read_for_vg\n");
   if ( ( ret = pv_pe_lv_read_for_vg ( vg_name, pv_name_list, &vg_this, &pv, &pe, &lv)) < 0)
	goto vg_read_with_lv_from_pv_end;

   debug ( "vg_read_with_lv_from_pv -- AFTER pv_pe_lv_read_for_vg\n");
   if ( ret == 0) {
      debug (  "vg_read_with_pv_and_lv -- BEFORE for PE\n");
      /* set up PE pointers in PVs */
      for ( p = 0; p < vg_this->pv_cur; p++) {
         if ( pv[p] == NULL) {
            ret = -VG_READ_WITH_LV_FROM_PV_PV_CUR;
            goto vg_read_with_lv_from_pv_end;
         }
         if ( ( vg_this->pv[p] = malloc ( sizeof ( pv_t))) == NULL) {
            fprintf ( stderr, "malloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            vg_free ( vg_this, FALSE);
            ret = -VG_READ_WITH_LV_FROM_PV_MALLOC;
            goto vg_read_with_lv_from_pv_end;
         }
         memcpy ( vg_this->pv[p], pv[p], sizeof ( pv_t));
         size = vg_this->pv[p]->pe_total * sizeof ( pe_disk_t);
         if ( ( vg_this->pv[p]->pe = malloc ( size)) == NULL) {
            fprintf ( stderr, "malloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            vg_free ( vg_this, FALSE);
            ret = -VG_READ_WITH_LV_FROM_PV_MALLOC;
            goto vg_read_with_lv_from_pv_end;
         }
         memcpy ( vg_this->pv[p]->pe, pe[p], size);
      }
      debug (  "vg_read_with_pv_and_lv -- AFTER for PE\n");
      /* build the lv_current_pe structure array */
      debug (  "vg_read_with_pv_and_lv -- BEFORE for LV\n");
      for ( l = 0; l < vg_this->lv_max; l++) vg_this->lv[l] = NULL;
      if ( vg_this->lv_cur > 0) {
         for ( l = 0; l < vg_this->lv_max; l++) {
            lv_num = l + 1;
            if ( lv[l] != NULL) {
               if ( ( vg_this->lv[l] = malloc ( sizeof ( lv_t))) == NULL) {
                  fprintf ( stderr, "malloc error in %s [line %d]\n",
                                    __FILE__, __LINE__);
                  vg_free ( vg_this, FALSE);
                  ret = -VG_READ_WITH_LV_FROM_PV_MALLOC;
                  goto vg_read_with_lv_from_pv_end;
               }
               memcpy ( vg_this->lv[l], lv[l], sizeof ( lv_t));
               debug ( "vg_read_with_pv_and_lv -- vg_this->lv[%d]->"
                        "lv_allocated_le: %lu\n", l,
                        vg_this->lv[l]->lv_allocated_le);
               if ( ( vg_this->lv[l]->lv_current_pe = malloc (
                         vg_this->lv[l]->lv_allocated_le *
                         sizeof ( pe_t))) == NULL) {
                  fprintf ( stderr, "malloc error in %s [line %d]\n",
                                    __FILE__, __LINE__);
                  vg_free ( vg_this, FALSE);
                  ret = -VG_READ_WITH_LV_FROM_PV_MALLOC;
                  goto vg_read_with_lv_from_pv_end;
               }
               /* construct the lv_current_pe pointer array */
               p = npe = 0;
               for ( p = 0; p < vg_this->pv_cur &&
                            npe < vg_this->lv[l]->lv_allocated_le; p++) {
                  for ( ope = 0; ope < vg_this->pv[p]->pe_total; ope++) {
                     if ( vg_this->pv[p]->pe[ope].lv_num == lv_num) {
                        pe_index = vg_this->pv[p]->pe[ope].le_num;
                        vg_this->lv[l]->lv_current_pe[pe_index].dev =
                           vg_this->pv[p]->pv_dev;
                        vg_this->lv[l]->lv_current_pe[pe_index].pe =
				get_pe_offset(ope, vg_this->pv[p]);
                        vg_this->lv[l]->lv_current_pe[pe_index].reads = \
                        vg_this->lv[l]->lv_current_pe[pe_index].writes = 0;
                        npe++;
                     }
                  }
               }
               if ( npe != vg_this->lv[l]->lv_allocated_le) {
                  fprintf ( stderr,
                            "%s -- only found %d of %d LEs for LV %s (%d)\n",
                            cmd, npe, vg_this->lv[l]->lv_allocated_le,
                            vg_this->lv[l]->lv_name, l);
                  ret = -LVM_EVG_READ_WITH_PV_AND_LV_LV_ALLOCATED_LE;
                  goto vg_read_with_lv_from_pv_end;
               }
               /* correct LVM_BLK_MAJOR */
               if ( MAJOR ( vg_this->lv[l]->lv_dev) != LVM_BLK_MAJOR) {
                  vg_this->lv[l]->lv_dev = MKDEV(LVM_BLK_MAJOR,
						 MINOR(vg_this->lv[l]->lv_dev));
               }
            } else vg_this->lv[l] = NULL;
         }
      }
   } /* if ( ret == 0) */

   if ( ret == 0) *vg = vg_this;
   else goto vg_read_with_lv_from_pv_end;

   /* Set up core pointers for snapshots */
   vg_setup_pointers_for_snapshots ( *vg);

vg_read_with_lv_from_pv_end:

   debug_leave ( "vg_read_with_lv_from_pv -- LEAVING with ret: %d\n", ret);
   return ret;
}
#endif // ICP_NAS_2 Catherine 2003/11/26
