#!/bin/sh

homedir=`pwd`

. build.conf
. tools.sh
check_arg create_update_image.sh $1
select_model $1

NASMODEL=$1

#------------------------------------------------
# create lilo_conf with ramdisk=$ramdisk
#-------------------------------------------------
create_lilo_conf

#----------------------------------------------------
# copy bzImage
# should we need to build bzImage by each model?
#----------------------------------------------------
cd image/$model
SYSTEM_MODEL=`getcfg "System" "Model" -f $homedir/$model/config/uLinux.conf -u -d NAS-4000`
if [ $SYSTEM_MODEL = NAS-4120 ]; then
	cp -f $homedir/image/bzImage/bzImage.NAS-4120-$KVERSION boot/bzImage.NAS
elif [ $SYSTEM_MODEL = NAS-4300 ]; then
	cp -f $homedir/image/bzImage/bzImage.NAS-4300-$KVERSION boot/bzImage.NAS
elif [ $SYSTEM_MODEL = NAS-4300S ]; then
	cp -f $homedir/image/bzImage/bzImage.NAS-4300S-$KVERSION boot/bzImage.NAS
elif [ $SYSTEM_MODEL = NAS-5100 ]; then
	cp -f $homedir/image/bzImage/bzImage.NAS-5100-$KVERSION boot/bzImage.NAS
elif [ $SYSTEM_MODEL = PNS-30 ]; then
	cp -f $homedir/image/bzImage/bzImage.NAS-PNS30-$KVERSION boot/bzImage.NAS
elif [ $SYSTEM_MODEL = NAS-3000 ]; then
	cp -f $homedir/image/bzImage/bzImage.NAS-PNS30-$KVERSION boot/bzImage.NAS
else
	# now for NAS-4030
	cp -f $homedir/image/bzImage/bzImage.NAS-GEN-$KVERSION boot/bzImage.NAS
fi

tar cvzf ../../update.img boot config update rootfs.img.gz
cd ../..

tmpver=`/bin/echo $VERSION | /bin/cut -c-1`
if [ "$tmpver" = "3" ]; then
	# version 3.x
	ENCRYPTDATA=ICPNASVERSION3
else
	# version 1.x or 2.x
	ENCRYPTDATA=ICPIPNAS4000
fi

ENCRYPT_MODEL=`getcfg "System" "Model" -f $homedir/$model/config/uLinux.conf -u -d NAS-4000`
if [ "$ENCRYPT" = "PC1.old" ]; then
	echo "use PC1.old to encrypt..."
	PC1.old e $ENCRYPTDATA update.img encrypt.img
else
	echo "use PC1 to encrypt..."
	PC1 e $ENCRYPTDATA update.img encrypt.img
	# append signature
	echo " append Signature $ENCRYPT_MODEL $VERSION"
	PC2 encrypt.img $ENCRYPT_MODEL $VERSION
fi

if [ $SYSTEM_MODEL = PNS-30 ]; then
        rm -f /mnt/pub/NAS_UPDATE_IMAGE/NASWARE3/${SYSTEM_MODEL}/${SYSTEM_MODEL}_`date +%Y%m%d`.img
        cp -avf encrypt.img /mnt/pub/NAS_UPDATE_IMAGE/NASWARE3/${SYSTEM_MODEL}/${SYSTEM_MODEL}_`date +%Y%m%d`.img
else
	rm -f /mnt/pub/NAS_UPDATE_IMAGE/NASWARE3/${NASMODEL}/${NASMODEL}_`date +%Y%m%d`.img
	cp -avf encrypt.img /mnt/pub/NAS_UPDATE_IMAGE/NASWARE3/${NASMODEL}/${NASMODEL}_`date +%Y%m%d`.img
fi
rm $homedir/encrypt.img $homedir/update.img -f

