#include "parser.h"


/*******************************************************************
 Count the number of characters (not bytes) in a unicode string.
********************************************************************/
size_t strlen_w(void *src)
{
	size_t len;

	for (len = 0; SVAL(src, len*2); len++) ;

	return len;
}

/****************************************************************************
expand a pointer to be a particular size
****************************************************************************/
void *Realloc(void *p,size_t size)
{
  void *ret=NULL;

  if (size == 0) {
    if (p) free(p);
((void)0);
    return NULL;
  }

  if (!p)
    ret = (void *)malloc(size);
  else
    ret = (void *)realloc(p,size);

  if (!ret)
((void)0);

  return(ret);
}


char *tab_depth(int depth)
{
	static pstring spaces;
	memset(spaces, ' ', depth * 4);
	spaces[depth * 4] = 0;
	return spaces;
}

void print_asc(int level, uchar const *buf, int len)
{
	int i;
	for (i = 0; i < len; i++)
	{
((void)0);
	}
}

void dump_data(int level, char *buf1, int len)
{
	uchar const *buf = (uchar const *)buf1;
	int i = 0;
	if (buf == NULL)
	{
((void)0);
		return;
	}
	if (len < 0)
		return;
	if (len == 0)
	{
((void)0);
		return;
	}

((void)0);
	for (i = 0; i < len;)
	{
((void)0);
		i++;
		if (i % 8 == 0)
((void)0);
		if (i % 16 == 0)
		{
			print_asc(level, &buf[i - 16], 8);
((void)0);
			print_asc(level, &buf[i - 8], 8);
((void)0);
			if (i < len)
((void)0);
		}
	}

	if (i % 16 != 0)	/* finish off a non-16-char-length row */
	{
		int n;

		n = 16 - (i % 16);
((void)0);
		if (n > 8)
((void)0);
		while (n--)
((void)0);

		n = MIN(8, i % 16);
		print_asc(level, &buf[i - (i % 16)], n);
((void)0);
		n = (i % 16) - n;
		if (n > 0)
			print_asc(level, &buf[i - n], n);
((void)0);
	}
}
