/*
 * $Log:    $
 * 
 */

/***********************************************************************************/
/*                        M-Systems Confidential                                   */
/*           Copyright (C) M-Systems Flash Disk Pioneers Ltd. 1995-2001            */
/*                         All Rights Reserved                                     */
/***********************************************************************************/
/*                            NOTICE OF M-SYSTEMS OEM                              */
/*                           SOFTWARE LICENSE AGREEMENT                            */
/*                                                                                 */
/*      THE USE OF THIS SOFTWARE IS GOVERNED BY A SEPARATE LICENSE                 */
/*      AGREEMENT BETWEEN THE OEM AND M-SYSTEMS. REFER TO THAT AGREEMENT           */
/*      FOR THE SPECIFIC TERMS AND CONDITIONS OF USE,                              */
/*      OR CONTACT M-SYSTEMS FOR LICENSE ASSISTANCE:                               */
/*      E-MAIL = info@m-sys.com                                                    */
/***********************************************************************************/

#ifndef __FLIOCTL__H__
#define __FLIOCTL__H__

#define FL_IOCTL_START SIOCDEVPRIVATE

typedef enum{
	FL_IOCTL_GET_INFO = FL_IOCTL_START,
             FL_IOCTL_DEFRAGMENT,
             FL_IOCTL_WRITE_PROTECT,
             FL_IOCTL_MOUNT_VOLUME,
             FL_IOCTL_FORMAT_VOLUME,
             FL_IOCTL_BDK_OPERATION,
             FL_IOCTL_DELETE_SECTORS,
             FL_IOCTL_READ_SECTORS,
             FL_IOCTL_WRITE_SECTORS,
             FL_IOCTL_FORMAT_PHYSICAL_DRIVE,
             FL_IOCTL_FORMAT_LOGICAL_DRIVE,
             FL_IOCTL_BDTL_HW_PROTECTION,
             FL_IOCTL_BINARY_HW_PROTECTION,
             FL_IOCTL_OTP,
             FL_IOCTL_CUSTOMER_ID,
             FL_IOCTL_UNIQUE_ID,
             FL_IOCTL_NUMBER_OF_PARTITIONS,
             FL_IOCTL_INQUIRE_CAPABILITIES,
             FL_IOCTL_SET_ENVIRONMENT_VARIABLES,
             FL_IOCTL_PLACE_EXB_BY_BUFFER,
             FL_IOCTL_WRITE_IPL,
             FL_IOCTL_DEEP_POWER_DOWN_MODE
} flIOctlFunctionNo;

/* non-OSAK IOCTLs defenitions */
#define FL_IOCTL_LNX	(FL_IOCTL_DEEP_POWER_DOWN_MODE+1)
typedef struct
{
	unsigned long command;
	unsigned long data;
}flInputLnxRecord;
typedef struct
{
	unsigned long status;
	unsigned long data;
}flOutputLnxRecord;
/* end of non-OSAK IOCTLs defenitions */


typedef enum
{
	flOK                      = 0,
	flBadFunction             = 1,
	flFileNotFound            = 2,
	flPathNotFound            = 3,
	flTooManyOpenFiles        = 4,
	flNoWriteAccess           = 5,
	flBadFileHandle           = 6,
	flDriveNotAvailable       = 9,
	flNonFATformat            = 10,
	flFormatNotSupported      = 11,
	flNoMoreFiles             = 18,
	flWriteProtect            = 19,
	flBadDriveHandle          = 20,
	flDriveNotReady           = 21,
	flUnknownCmd              = 22,
	flBadFormat               = 23,
	flBadLength               = 24,
	flDataError               = 25,
	flUnknownMedia            = 26,
	flSectorNotFound          = 27,
	flOutOfPaper              = 28,
	flWriteFault              = 29,
	flReadFault               = 30,
	flGeneralFailure          = 31,
	flDiskChange              = 34,
	flVppFailure              = 50,
	flBadParameter            = 51,
	flNoSpaceInVolume         = 52,
	flInvalidFATchain         = 53,
	flRootDirectoryFull       = 54,
	flNotMounted              = 55,
	flPathIsRootDirectory     = 56,
	flNotADirectory           = 57,
	flDirectoryNotEmpty       = 58,
	flFileIsADirectory        = 59,
	flAdapterNotFound         = 60,
	flFormattingError         = 62,
	flNotEnoughMemory         = 63,
	flVolumeTooSmall          = 64,
	flBufferingError          = 65,
	flFileAlreadyExists       = 80,
	flIncomplete              = 100,
	flTimedOut                = 101,
	flTooManyComponents       = 102,
	flTooManyDrives           = 103,
	flTooManyBinaryPartitions = 104,
	flPartitionNotFound       = 105,
	flFeatureNotSupported     = 106,
	flWrongVersion            = 107,
	flTooManyBadBlocks        = 108,
	flNotProtected            = 109,
	flUnchangeableProtection  = 110,
	flBadDownload             = 111,
	flBadBBT                  = 112,
	flInterleaveError         = 113,
	flWrongKey                = 114,
	flHWProtection            = 115,
	flTimeOut                 = 116
}FLStatus;

typedef struct
{
  void*inputRecord;
  void*outputRecord;
}flIOctlRecord;

/* General output record that returns only status. */
typedef struct
{
	FLStatus status;
}flOutputStatusRecord;

typedef struct
{
	unsigned long  logicalSectors;		/*  number of logical sectors                  */
	unsigned long  bootAreaSize;		/*  boot area size                             */
	unsigned long  baseAddress;			/*  physical base address                      */
	unsigned short flashType;			/*  JEDEC id of the flash                      */
	unsigned long  physicalSize;		/*  physical size of the media                 */
	unsigned short physicalUnitSize;	/*  Erasable block size                        */
	char DOCType;						/*  DiskOnChip type (MDoc/Doc2000)             */
	char lifeTime;						/*  Life time indicator for the media (1-10)   */
										/*  1 - the media is fresh,                    */
										/*  10 - the media is close to its end of life */
	char driverVer[10];					/*  driver version (NULL terminated string)    */
	char OSAKVer[10];					/*  OSAK version that driver is based on
										(NULL terminated string)                   */
	unsigned long cylinders;			/*  Media.....                                 */
	unsigned long heads;				/*            geometry......                   */
	unsigned long sectors;				/*                            parameters.      */
}VolumeInfoRecord;

typedef struct
{
	VolumeInfoRecord info;
	FLStatus status;
}flDiskInfoOutput;

typedef struct
{
	long requiredNoOfSectors;   /* Minimum number of sectors to make available. if -1 then a quick garbage collection operation is invoked. */
}flDefragInput;

typedef struct
{
	long actualNoOfSectors;     /* Actual number of sectors available */
	FLStatus status;
}flDefragOutput;

typedef struct
{
	unsigned char type;        /*  type of operation: FL_PROTECT\FL_UNPROTECT */
	long password[2];          /*  password  */
}flWriteProtectInput;

typedef struct
{
	unsigned char type;        /*  type of operation: FL_MOUNT\FL_DISMOUNT */
}flMountInput;
#define FL_MOUNT			0
#define FL_DISMOUNT			1

typedef struct
{
  /* FTL formatting section */
	long int	bootImageLen;
		/* Space to reserve for a boot-image at the start of the
		   medium. The FLite volume will begin at the next higher
		   erase unit boundary */

	unsigned int	percentUse;
		/* FTL performance depends on how full the Flash media is,
		   getting slower when the media is close to 100%. It is
		   possible to avoid the worst consequences of this effect by
		   formatting the media to less than 100% capacity, so
		   guaranteeing some free space at all times. This of course
		   sacrifices some capacity.
		   The standard value to use is 98 */

	unsigned int	noOfSpareUnits;
		/* FTL needs at least one spare erase unit to function as a
		   read/write media (it is possible to specify 0 to achieve
		   WORM functionality). It is possible to specify more than
		   one spare unit, which costs more media space.
		   The advantage to doing this is in case one of the Flash
		   erase units becomes bad and unerasable in the future, one
		   of the spare units will need to replace it. A second spare
		   unit will then enable to continue read/write functionality
		   (in its absence, the media will go into read-only mode).
		   The standard value to use is 1 */

	unsigned long	vmAddressingLimit;
		/* A part of the FTL Virtual Map always resides in RAM. The
		   RAM part is the one that is used to address the part of
		   the media below the VM addressing limit. Reading and
		   writing to this part is usually faster to some degree.
		   The downside is that the bigger the limit, the more RAM
		   size is required.
		   To get the extra RAM requirement in bytes, divide the
		   limit by 128 or by 256, depending on whether you
		   specified in #2.9 more than 32 or not, respectively.
		   The minimum VM limit is 0.
		   The standard value to use is 0x10000 (first 64 KBytes) */

	FLStatus	(*progressCallback)(int totalUnitsToFormat,int totalUnitsFormattedSoFar);
		/* Progress callback routine, will be called if not NULL.
		   The callback routine is called after erasing each unit,
		   and its parameters are the total number of erase units
		   to format and the number erased so far.
		   The callback routine returns a Status value. A value of
		   OK (0) allows formatting to continue. Any other value
		   will abort the formatting with the returned status code. */

	/* DOS formatting section */
	char	volumeId[4];
		/* Volume identification number */
	char*	volumeLabel;
		/* Volume label string. If NULL, no label */

	unsigned int	noOfFATcopies;
		/* It is customary to format DOS media with 2 FAT copies.
		   The first copy is always used, but more copies make it
		   possible to recover if the FAT becomes corrupted (a
		   rare occurrence). On the other hand, this slows down
		   performance and uses media space.
		   The standard value to use is 2 */

	unsigned int	embeddedCISlength;
		/* Length in bytes of CIS to embed after the unit header */

	char*	embeddedCIS;
		/* The unit header is structured as a beginning of a PCMCIA
		   'tuple' chain (a CIS). The unit header contains a
		   data-organization tuple, which points past the end of the
		   unit header to a location which usually just contains
		   hex FF's which mark an 'end-of-tuple-chain'. Optionally,
		   it is possible to embed an entire CIS chain at this
		   location. If so, 'embeddedCISlength' marks the length in
		   bytes */

}FormatParams;

typedef struct
{
	unsigned char formatType;
	FormatParams fp;
}flFormatInput;

typedef struct
{
	unsigned long	length;
        /* The size of the usable storage space. The size will be
           rounded upwards to a multiplication of a block size.
           The size of the last partition will calculated automatically,
           but if the requested size is greater then the remaining space
           an error code will be returned,. Requesting zero size for any
	   partition but the last will generate an flBadParameters status. */

	unsigned int	noOfSpareUnits;
        /* BDTL needs at least one spare erase unit in order to function
           as a read/write media. It is possible to specify more than one
           spare unit, which takes more media space. The advantage of
           specifying more than one spare unit is that if one of the flash
           erase units becomes bad and inerasable in the future, then one
           of the spare units can replace it. In that case, a second spare
           unit enables TrueFFS to continue its read/write functionality,
           whereas if no second spare unit is available the media goes into
           read-only mode. The standard value used is 1 */

	unsigned char flags;
#define TL_FORMAT_FAT          2  /* Add FAT format on the media      */
#define TL_OLD_FORMAT          4  /* Format with 1 sector per cluster */

	unsigned char	volumeId[4];  /* DOS partition identification number		  */

	unsigned char*	volumeLabel;  /*DOS partition label string. If NULL, no label */

	unsigned char	noOfFATcopies;
        /* It is customary to format DOS media with two FAT copies. The
           first copy is always used, but more copies make it possible
           to recover if the FAT becomes corrupted (a rare occurrence).
           On the other hand, this slows down performance and uses media
           space. The standard value used is 2. */
	unsigned char	protectionKey[8];   /* The key for the protection*/
	unsigned char	protectionType;
       /* PROTECTABLE          - Can receive protection           */
       /* READ_PROTECTED       - Protect against read operations  */
       /* WRITE_PROTECTED      - Protect against write operations */
       /* LOCK_ENABLED         - Enables the hardware lock signal */
       /* PROTECTABLE          - This partition can be protected  */
       /* CHANGEABLE_PROTECTION - protection type can be changed */
}BDTLPartitionFormatParams;

typedef struct
{
	BDTLPartitionFormatParams fp;
}flFormatLogicalInput;

typedef struct
{
	unsigned long length;	/* Required number of good blocks in the  partition.*/

	unsigned char sign[4];	/* signature of the binary  partition to format. */

	unsigned char signOffset;
		/* offset of the signature. This value should  always be 8, but it
		   can also accept 0 for backwards compatibility reasons. Note that
		   if the offset is 0 EDC\ECC is neutralized */
	unsigned char   protectionKey[8];   /* The key for the protection*/
	unsigned char   protectionType;
		   /* PROTECTABLE          - Can receive protection           */
		   /* READ_PROTECTED       - Protect against read operations  */
		   /* WRITE_PROTECTED      - Protect against write operations */
		   /* LOCK_ENABLED         - Enables the hardware lock signal */
		   /* PROTECTABLE          - This partition can be protected  */
		   /* CHANGEABLE_PROTECTION - protection type can be changed */
}BinaryPartitionFormatParams;

typedef struct
{
unsigned char        percentUse;
     	/* BDTL performance depends on how full the flash media is,
		   becoming slower as the media becomes closer to 100% full.
		   It is possible to avoid the worst-case performance
		   (at 100% full) by formatting the media to less than 100%
		   capacity, thus guaranteeing free space at all times. This
		   of course sacrifices some capacity. The standard value
		   used is 98 */

unsigned char             noOfBDTLPartitions;
		/* Indicates the number of BDTL partitions (1 to 4). 0 will
           cause a single STD_BDTL_PARAMS BDTL partition */

unsigned char             noOfBinaryPartitions;
       /* Indicates the number of binary partitions (up to 3). 0 will
	      cause formatting with no binary partition. This value is ignored
	  unless the TL_BINARY_FORMAT flag is set in the formatType of the flFormatPhysicalInput */

	BDTLPartitionFormatParams*	BDTLPartitionInfo;
	/* BDTL partition information array  */

	BinaryPartitionFormatParams  * binaryPartitionInfo;
       /* Binary partition information array*/

/***********************************/
/* Special format features section */
/***********************************/

void   *     exbBuffer;
	/* A buffer containing the EXB file. Optionally this file can
	   contain only the first 512 bytes of the file while the rest
	   will be sent using consecutive calls to flPlaceExbByBuffer */

unsigned long           exbBufferLen;	/* Size of the given EXB buffer */

unsigned long           exbLen;			/* The specific size to leave for the EXB */

unsigned short            exbWindow;	/* Set explicit DiskOnChip window base */

unsigned char            exbFlags;

unsigned char            cascadedDeviceNo;
	/* Reserved for individual cascaded device formatting 0..n. For
	   this value to have any affect the TL_SINGLE_CHIP_FORMATTING flag
	   should be set in the flags field.*/

unsigned char            noOfCascadedDevices;
	/* This field must be supplied in order to perform a format of
	   a single chip that will be eventually assembled as a cascaded
	   device. The field should specify the number of DiskOnChips
	   that will be eventually cascaded on the target platform */

FLStatus (*progressCallback)(int totalUnitsToFormat,
			     int totalUnitsFormattedSoFar);
	/* Progress callback routine, will be called if not NULL.
	   The callback routine is called after erasing each unit,
	   and its parameters are the total number of erase units
	   to format and the number erased so far.
	   The callback routine returns a Status value. A value of
	   OK (0) allows formatting to continue. Any other value
	   will abort the formatting with the returned status code. */

/* Note the following section is not used by for DiskOnChips */
/*************************************************************/

unsigned long        	vmAddressingLimit;
	    /* A part of the FTL Virtual Map always resides in RAM. The
	       RAM part is the one that is used to address the part of
	       the media below the VM addressing limit. Reading and
		   writing to this part is usually faster to some degree.
		   The downside is that the bigger the limit, the more RAM
		   size is required.
		   To get the extra RAM requirement in bytes, divide the
		   limit by 128 or by 256, depending on whether you
		   specified in #2.9 more than 32 or not, respectively.
		   The minimum VM limit is 0.
		   The standard value to use is 0x10000 (first 64 KBytes) */

unsigned short	    embeddedCISlength;
		/* Length in bytes of CIS to embed after the unit header */

unsigned char   *	    embeddedCIS;
		/* The unit header is structured as a beginning of a PCMCIA
		   'tuple' chain (a CIS). The unit header contains a
		   data-organization tuple, which points past the end of the
		   unit header to a location which usually just contains
		   hex FF's which mark an 'end-of-tuple-chain'. Optionally,
		   it is possible to embed an entire CIS chain at this
		   location. If so, 'embeddedCISlength' marks the length in
		   bytes */
} FormatParams2;

typedef struct
{
	unsigned char formatType;
	FormatParams2 fp;
}flFormatPhysicalInput;

/* flFormatPhysicalInput.formatType */
#define FAT_ONLY_FORMAT     0
#define TL_FORMAT           1
#define TL_FORMAT_IF_NEEDED 2
#define TL_FORMAT_ONLY      8


typedef struct
{
	unsigned char oldSign[4];
	unsigned char newSign[4];
	unsigned char signOffset;
	unsigned long startingBlock;
	unsigned long length;
	unsigned char flags;
	unsigned char   *bdkBuffer;
}BDKStruct;

typedef struct
{
	unsigned char type;  /* type of operation: BDK_INIT_READ\BDK_READ\BDK_INIT_WRITE\ */
                       /* BDK_WRITE\BDK_ERASE\BDK_CREATE\BDK_GET_INFO               */
	BDKStruct bdkStruct;
}flBDKOperationInput;

#define BDK_INIT_READ   0
#define BDK_READ        1
#define BDK_INIT_WRITE  2
#define BDK_WRITE       3
#define BDK_ERASE       4
#define BDK_CREATE      5
#define BDK_GET_INFO    6

typedef struct
{
   unsigned char protectionType;
   unsigned char key[8];             /* The new key to the change Key call         */
   unsigned char type;                     /* Operation type see list bellow             */
} flProtectionInput;

/* flProtectionInput.type */
#define PROTECTION_INSERT_KEY   0
#define PROTECTION_REMOVE_KEY   1
#define PROTECTION_GET_TYPE     2
#define PROTECTION_DISABLE_LOCK 3
#define PROTECTION_ENABLE_LOCK  4
#define PROTECTION_CHANGE_KEY   5
#define PROTECTION_CHANGE_TYPE  6

typedef struct
{
	unsigned long       length;           /* Length to read\write\size                  */
	unsigned long       usedSize;         /* The written size of the area \ Area offset */
	unsigned char        lockedFlag;       /* The area condition LOCKED_OTP */
	unsigned char         * buffer;     /* pointer to user buffer                     */
	unsigned short        type;             /* defined bellow                             */
}flOtpInput;

/* flOtpInput.type */
#define OTP_SIZE        1
#define OTP_READ        2
#define OTP_WRITE_LOCK        3

typedef struct
{
  unsigned char id[4];
  FLStatus status;
} flCustomerIdOutput;

typedef struct
{
  unsigned char id[16];
  FLStatus status;
} flUniqueIdOutput;

typedef struct
{
  unsigned char noOfPartitions;
  FLStatus status;
} flCountPartitionsOutput;

typedef enum
{
   CAPABILITY_NOT_SUPPORTED           = 0,
   CAPABILITY_SUPPORTED               = 1,
   SUPPORT_UNERASABLE_BBT             = 2,
   SUPPORT_MULTIPLE_BDTL_PARTITIONS   = 3,
   SUPPORT_MULTIPLE_BINARY_PARTITIONS = 4,
   SUPPORT_HW_PROTECTION              = 5,
   SUPPORT_HW_LOCK_KEY                = 6,
   SUPPORT_CUSTOMER_ID                = 7,
   SUPPORT_UNIQUE_ID                  = 8,
   SUPPORT_DEEP_POWER_DOWN_MODE       = 9,
   SUPPORT_OTP_AREA                   = 10,
   SUPPORT_WRITE_IPL_ROUTINE          = 11
}FLCapability;

typedef struct
{
   FLCapability  capability;
} flCapabilityInput;

typedef struct
{
   FLCapability  capability;
   FLStatus      status;
} flCapabilityOutput;

typedef enum        /* Variable type code for flSetEnv routine */
{
      FL_IS_RAM_CHECK_ENABLED = 1,
      FL_NFTL_CACHE_ENABLED   = 2,
      FL_DOC_8BIT_ACCESS      = 3,
      FL_MULTI_DOC_ENABLED    = 4,
      FL_SET_POLICY           = 5,
      FL_SET_MAX_CHAIN        = 6,
      FL_MARK_DELETE_ON_FLASH = 7
}FLEnvVars;

typedef struct
{
  FLEnvVars      varName;  /* Enum describing the variable */
  int            varValue; /* New variable value           */
} flEnvVarsInput;

typedef struct
{
  int   prevValue;   /* The previous value of the variable */
  FLStatus status;
}flEnvVarsOutput;

typedef struct
{
  unsigned char  * buf;  /* buffer of EXB file */
  unsigned long bufLen;     /* buffer length      */
  unsigned char exbFlags;   /* a combination of EXB flags see flPlaceExbByBuffer routine  */
  unsigned short exbWindow; /* explicitly set device window. 0 will automatically set window */
}flPlaceExbInput;

typedef struct
{
  unsigned char  * buf;       /* IPL data buffer        */
  unsigned short   bufLen;       /* IPL data buffer length */
}flIplInput;

typedef struct
{
unsigned char state; /* DEEP_POWER_DOWN - low power consumption      */
                     /* otherwise       - regular power consumption  */
}flPowerDownInput;

typedef struct
{
  long firstSector;                /* First logical sector to delete */
  long numberOfSectors;                /* Number of sectors to delete */
}flDeleteSectorsInput;

typedef struct
{
  long firstSector;                  /* first logical sector */
  long numberOfSectors;         /* Number of sectors to read\write */
  unsigned char   *buf;               /* Data to read\write */
} flReadWriteInput;

typedef struct
{
  long numberOfSectors;         /* Actual Number of sectors read\written */
  FLStatus status;
}flReadWriteOutput;

#define FL_PROTECT   0
#define FL_UNPROTECT 1
#define FL_UNLOCK    2

#endif	/*#ifndef __FLIOCTL__H__*/

