/* vi: set sw=4 ts=4 autoindent: */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>

#include "sysinfo.h"
#include "open_debug.h"


#ifndef	SOCK_DGRAM
#define	SOCK_DGRAM	1
#endif

#define NET_DEBUG	0

//return 0 if error
//return >0 if success
int
query_netdevice(char *device_name, int query_flag, void *buf)
{
	int fd;
	struct ifreq ifr;

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if(fd<0)
	{
#if NET_DEBUG > 0
		Nprintf("socket open error\n");
#endif
		//exit(1);
		return 0;
	}
	else
	{
		Strcpy(ifr.ifr_name, device_name);
		ifr.ifr_addr.sa_family = AF_INET;

		//ˬdinterfaceO_@
		if(ioctl(fd, SIOCGIFFLAGS, &ifr)< 0)
		{
			*(unsigned long *)buf = 0;
		}
		else
		{
			if((ifr.ifr_flags & IFF_UP) == 0)	//no use
			{
				*(unsigned long *)buf = 0;
			}
			else
			{
				if(ioctl(fd, query_flag, &ifr) >= 0)
				{
					switch(query_flag)
					{
						case SIOCGIFADDR:
						case SIOCGIFNETMASK:
							memcpy(buf, ifr.ifr_addr.sa_data+2, sizeof(unsigned long));
							break;
						case SIOCGIFHWADDR:
							memcpy(buf, ifr.ifr_hwaddr.sa_data, 6);	//mac address size = 6
							break;
						case SIOCGIFDSTADDR:
							memcpy(buf, ifr.ifr_dstaddr.sa_data+2, sizeof(unsigned long));
							break;
					}
				}
				else
				{
					*(unsigned long *)buf = 0;
				}
			}
		}
	}
	close(fd);

	return 1;
}

